<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Publictrack extends CI_Controller {
    public function __Construct()
    {
        parent::__Construct();
        
        redirect("tracking/orderTracking");
        $this->load->model('common');
    }
    
    public function index()
    {
       $post=$this->input->post(null,true);
       $tracnum = $data['track_number']=$post['tracknum'] = isset($post['tracknum']) ? $post['tracknum'] : "";
       $orderlist=$stop_locations=array();
       $data['order_type'] = "";
       $data['order_info'] = 0;
       if($tracnum != ""){
            $getorders = $this->db->select("id,pickup_city,delivery_city,pickup_pincode,delivery_pincode,quantity,weight,volume,goods_value,status,delivery_datetime,pickup_company,delivery_company,pickup_address1,delivery_address1,pickup_address2,delivery_address2,pickup_country,delivery_country,plat,plng,dlat,dlng,user_id,trip_sts,shift_id,trip_id,company_code,branch_code,created_source")->get_where("tb_orders",array('order_id'=>$tracnum),1,0);
            if($getorders->num_rows() == 0){
                $where = array("ref_value"=>$tracnum);
                $select = "order_id,reference_id";
                $table = "tb_order_references";
                $refence = $this->common->gettblrowdata($where,$select,$table,0,0);
                if(count($refence)>0){
                    $orid=$refence['order_id'];
                    if($orid>0){
                        /*check for SO or Return Order*/
                        /*$refid = $refence['reference_id'];
                        if($refid == "XSR"){
                            $where = array("reference_id"=>"DQ","ref_value"=>$tracnum);
                            $select = "order_id,reference_id";
                            $table = "tb_order_references";
                            $refence = $this->common->gettblrowdata($where,$select,$table,0,0);
                            if(count($refence)>0){
                            }
                        }*/
                        $getorders = $this->db->select("id,order_id,pickup_city,delivery_city,pickup_pincode,delivery_pincode,delivery_datetime,quantity,weight,volume,goods_value,status,pickup_company,delivery_company,pickup_address1,delivery_address1,pickup_address2,delivery_address2,pickup_country,delivery_country,plat,plng,dlat,dlng,user_id,trip_sts,shift_id,trip_id,company_code,branch_code,created_source")->get_where("tb_orders",array('id'=>$orid),1,0);
                        if($getorders->num_rows() >0){
                           $tracnum=$getorders->row()->order_id;
                        }
                    }
                }
            }
            $data['track_number']=$tracnum;
            if($getorders->num_rows() >0){
                $orderlist['user_id']=$getorders->row()->user_id;
                $user = $this->db->select("id,country_code")->where("id",$orderlist['user_id'])->get("tb_users")->row_array();
                $tz = $this->getUserTimeZone($user['id'],$user['country_code']);
                $curtz = $tz['timezone'];
                $data['order_type'] = "";
                $data['order_cust'] = $getorders->row()->created_source;
                if($data['order_cust'] == 15){
                    $data['order_type'] = "Uniqlo Sales Order";
                }else if($data['order_cust'] == 16){
                    $data['order_type'] = "Uniqlo Return Order";
                }
                $oid = $orderlist['orid'] = $getorders->row()->id;
                /*weight & volumn uom*/
                $orderlist['weight']=$getorders->row()->weight;
                $orderlist['volume']=$getorders->row()->volume;
                $carginfo = $this->db->query("SELECT c.weight,c.weight_unit,c.volume,c.volume_unit FROM tb_cargo_details c,tb_order_cargodetails o WHERE c.id=o.cargo_id AND o.order_id=$oid GROUP BY c.id");
                $wuom = $vuom = "";
                if($carginfo->num_rows()>0){
                    $orderlist['wuom']=$carginfo->row()->weight_unit;
                    if($orderlist['wuom'] == "G" || $orderlist['wuom'] == ""){
                        $orderlist['wuom']="Kgs";
                        $orderlist['weight'] = round(($orderlist['weight']/1000),2);
                    }else{
                        $orderlist['wuom']="Kgs";
                    }
                    $orderlist['vuom']=$carginfo->row()->volume_unit;
                    if($orderlist['vuom'] != "Cbm"){
                        $orderlist['vuom']="Cbm";
                        $volume = $getorders->row()->volume;
                        if($volume != ""){
                            $orderlist['volume']= round(($volume/1000000),2);
                        }
                    }
                }
                $orderlist['pickup_company']=$getorders->row()->pickup_company;
                $orderlist['delivery_company']=$getorders->row()->delivery_company;
                $orderlist['pickup_country']=$getorders->row()->pickup_country;
                $orderlist['delivery_country']=$getorders->row()->delivery_country;
                $orderlist['pickup_city']=$getorders->row()->pickup_city;
                $orderlist['delivery_datetime']=$getorders->row()->delivery_datetime;
                $orderlist['delivery_city']=$getorders->row()->delivery_city;
                $orderlist['pickup_pincode']=$getorders->row()->pickup_pincode;
                $orderlist['delivery_pincode']=$getorders->row()->delivery_pincode;
                $orderlist['quantity']=$getorders->row()->quantity;
                $orderlist['goods_value']=$getorders->row()->goods_value;
                $orderlist['status']=$getorders->row()->status;
                $orderlist['pickup_address1']=$getorders->row()->pickup_address1;
                $orderlist['pickup_address2']=$getorders->row()->pickup_address2;
                $orderlist['delivery_address1']=$getorders->row()->delivery_address1;
                $orderlist['delivery_address2']=$getorders->row()->delivery_address2;
                $orderlist['plat']=$getorders->row()->plat;
                $orderlist['plng']=$getorders->row()->plng;
                $orderlist['dlat']=$getorders->row()->dlat;
                $orderlist['dlng']=$getorders->row()->dlng;
                $orderlist['branch_code']=$getorders->row()->branch_code;
                $orderlist['company_code']=substr($getorders->row()->company_code, 0, 2);
                $data["orderref"] = $orderref = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$oid AND status=1 AND reference_id IN('DQ','PO','XSR','ORD','AWB','OT') GROUP BY id");
                $data['orderinfo']=$orderlist;
                /*$shipmentinfo=$this->db->query("select s.id from tb_shifts s, tb_employee e where e.shift_id=s.id and e.order_id='".$tracnum."'");*/
                $shipid=$getorders->row()->shift_id;
                $statuscode = $stcode = $status_code = '';
                $trip_id= $getorders->row()->trip_id;
                $vehicle_id = 0;
                $data['delivertimemsg'] = "Expected Delivery Date";
                $data['delivertimedonemsg'] = "Actual Delivered Date";
                $data['delivertimedone'] = "";
                $cur_date = date('Y-m-d');
                $data['delivertime'] = "----";
                $manifesttime = "";
                /*$data['order_types']=$this->db->query("select * from `tb_order_references` where order_id=".$orderlist['orid']." and reference_id='OT' and status=1");*/
                if($shipid > 0){
                    $stop_loc_query=$this->db->query("select m.status_name,s.stop_type,s.status_code,s.status_id,s.latitude,s.longitude,s.loc_name,s.reason,s.vehicle_id,convertToClientTZ(s.createdon,'".$curtz."') as createdon from tb_stop_status s,tb_status_master m where s.status_id=m.id AND s.shipment_id='".$shipid."' order by s.id desc LIMIT 1");
                    if($stop_loc_query->num_rows()>0){
                        $stop_locations['status_name']= $statuscode = $stop_loc_query->row()->status_name;
                        $stop_locations['createdon']=$stop_loc_query->row()->createdon;
                        $stop_locations['reason']=$stop_loc_query->row()->reason;
                        $status_code=$stop_loc_query->row()->status_code;
                        $stcode = $stop_loc_query->row()->stop_type;
                        if($stcode == "D" && $stop_loc_query->row()->status_id == 1){
                            $data['delivertimedonemsg'] = "Actual Delivered Date";
                            $data['delivertimedone'] = $stop_loc_query->row()->createdon;
                        }
                        $vehicle_id = $stop_loc_query->row()->vehicle_id;
                        if($stop_loc_query->row()->loc_name != ""){
                            $stop_locations['location_name']=$stop_loc_query->row()->loc_name;
                        }else if($stop_loc_query->row()->latitude=="" || $stop_loc_query->row()->longitude==""){
                            $this->db->select("latitude,longitude");
                            $this->db->from("tb_trucks_data");
                            $this->db->where('id',$vehicle_id);
                            $this->db->order_by('id','desc');
                            $this->db->limit(0,1);
                            $tb_rtdrive_loc = $this->db->get();
                            if($tb_rtdrive_loc->num_rows()>0){
                                $stop_locations['latitude'] = $tb_rtdrive_loc->row()->latitude;
                                $stop_locations['longitude'] = $tb_rtdrive_loc->row()->longitude;
                                if($tb_rtdrive_loc->row()->latitude !="" && $tb_rtdrive_loc->row()->longitude !=""){
                                    $stop_locations['location_name']=getLocationName($tb_rtdrive_loc->row()->latitude,$tb_rtdrive_loc->row()->longitude);
                                }
                            }
                        }else{
                            $stop_locations['latitude'] = $stop_loc_query->row()->latitude;
                            $stop_locations['longitude'] = $stop_loc_query->row()->longitude;
                            $stop_locations['location_name']=getLocationName($stop_loc_query->row()->latitude,$stop_loc_query->row()->longitude);
                        }
                    }
                }
                if(!isset($stop_locations['reason'])){
                    $stop_locations['reason'] = "";
                }
                $data['stop_locations']= $stop_locations;
                $data['statuscode']=$statuscode;
                $data['status_code'] = $status_code;
                $data['stcode']=$stcode;
                $data['order_info']=1;
                if($shipid > 0){
                    $data["timezone"] = $curtz;
                    $data["drivers"] = array();
                    if($trip_id != 0){
                        $data["drivers"] = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'".$curtz."') as createdon from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.trip_id = $trip_id AND td.status ='1' GROUP BY d.id ORDER BY td.createdon ASC")->result_array();
                    }
                    if($orderlist['branch_code'] == "INCL"){
                        $sql = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,ts.status_id,convertToClientTZ(ts.createdon,'".$curtz."') as createdon,sm.status_name,ss.startdate,ss.enddate,ts.reason
                        FROM tb_stop_status ts
                        LEFT JOIN tb_status_master sm ON sm.id=ts.status_id
                        LEFT JOIN tb_shiporder_stops ss ON sm.id=ts.stop_id
                         WHERE ts.shipment_id = '$shipid' AND ts.status_code IN('0470','0420','1550','0500','0191','2990','2989','0192','2300','RTO','3050','3000','2400','DTO','3051') GROUP BY ts.id ORDER BY ts.createdon ASC");
                    }else{
                        $sql = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,ts.status_id,convertToClientTZ(ts.createdon,'".$curtz."') as createdon,sm.status_name,ss.startdate,ss.enddate,ts.reason
                        FROM tb_stop_status ts
                        LEFT JOIN tb_status_master sm ON sm.id=ts.status_id
                        LEFT JOIN tb_shiporder_stops ss ON sm.id=ts.stop_id
                         WHERE ts.shipment_id = '$shipid' GROUP BY ts.id ORDER BY ts.createdon ASC");
                    }
                    if($sql->num_rows()>0){
                        foreach($sql->result_array() as $exp){
                            if($exp['status_code'] == '1550'){
                                $manifesttime = $exp['createdon'];
                            }
                            if($exp['stop_type'] == "D" && ($exp['status_code'] == 'RTO' || $exp['status_code'] == 'DTO' || $exp['status_code'] == '2300' || $exp['status_id'] == 1)){
                                $data['delivertimedonemsg'] = "Actual Delivered Date";
                                $data['delivertimedone'] = $exp['createdon'];
                            }
                        }
                    }
                    $data["history"]=$sql;
                    $data['epod'] = array();
                    $docs = $this->db->select("id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'".$curtz."') as createdon")->get_where("tb_pod_uploads",array("shipment_id"=>$shipid,"doc_type"=>3,"status"=>1),1,0);
                    if($docs->num_rows()>0){
                        $data['epod'] = array("status_code"=>"3060","status_name"=>"ePOD Available","stop_id"=>$docs->row()->stop_id,"stop_type"=>$docs->row()->stop_type,"location"=>getLocationName($docs->row()->latitude,$docs->row()->longitude),"createdon"=>$docs->row()->createdon);
                    }
                   /*$data['stevents']=$this->load->view("publictrack/statusview",$stdata,TRUE);*/
                }
                if($manifesttime != ""){
                    $pickp_city = $orderlist['pickup_city'];
                    $delivery_city = $orderlist['delivery_city'];
                    $ordtype = $data['order_cust'];
                    if($pickp_city == ""){
                        $pickp_city = $orderlist['pickup_address1'];
                    }
                    if($delivery_city == ""){
                        $delivery_city = $orderlist['delivery_address1'];
                    }
                    $containernumber = "";
                    if($orderref->num_rows()>0){
                        foreach($orderref->result() as $orref){
                            if($orref->reference_id == "AWB"){
                                $containernumber = $orref->ref_value;
                            }
                        }
                    }
                    $expparams = array("pickup_pin"=>$orderlist['pickup_pincode'],"delivery_pin"=> $orderlist['delivery_pincode'],"pickp_city"=>trim($pickp_city),"delivery_city"=>trim($delivery_city),"order_type"=>$ordtype,"manifesttime"=>$manifesttime,"container_num"=>$containernumber);
                    $chkexpdeliver = $this->getexpdeliverytime($expparams);
                    if(!empty($chkexpdeliver)){
                        if(strpos($chkexpdeliver['expdeliver_date'], "1970-01-01") === false){
                            $data['delivertime'] = $chkexpdeliver['expdeliver_date'];
                        }
                    }
                }
                /*$data['auto_orderall']=array();
                $this->db->select("order_id");
                $this->db->from("tb_orders");
                $this->db->where("status !=",0);
                $this->db->order_by("createdon",'DESC');
                $orderall = $this->db->get();
                if($orderall->num_rows() >0){
                    $data['auto_orderall'] = $orderall->result_array();
                }*/
            }
        }

        if(!isset($data['history'])){
            $data['history'] = FALSE;
        }

        if(!isset($data['epod'])){
            $data['epod'] = [];
        }
        $this->load->view('publictrack/index',$data);
    }
    /*Calculate expected delivery data basedon TAT*/
    public function getexpdeliverytime($ordinfo){
        $response = array();
        if($ordinfo['order_type'] == '15'){
            $pinwhr = array("origin_pincode"=>$ordinfo['pickup_pin'],"destinate_pincode"=>$ordinfo['delivery_pin'],"status"=>1);
            if($ordinfo['pickp_city'] == "GURGAON"){
                $ordinfo['pickp_city'] = "Bilaspur-HR";
            }
            $citywhr1 = "";
            $actualcitychk = $citywhr = "origin LIKE '%".$ordinfo['pickp_city']."%' AND destination LIKE '%".$ordinfo['delivery_city']."%' AND status=1";
            $slocdata = $slocdata2 = $dlocdata = $dlocdata2 = $scitydata = $dcitydata = "";
            $chkdblspace = strrpos($ordinfo['pickp_city'],"  ");
            if($chkdblspace){
                $citystate = explode("  ",$ordinfo['pickp_city']);
                if(count($citystate)>1){
                    $citydata = trim($citystate[0]); /*state*/
                    $scitydata = trim($citystate[1]); /*city*/
                }
            }
            $chkdblspace1 = strrpos($ordinfo['delivery_city'],"  ");
            if($chkdblspace1){
                $citystate1 = explode("  ",$ordinfo['delivery_city']);
                if(count($citystate1)>1){
                    $citydata = trim($citystate1[0]); /*state*/
                    $dcitydata = trim($citystate1[1]); /*city*/
                }
            }
            $chkspace = strrpos($ordinfo['pickp_city']," ");
            if($chkspace){
                $splitstr = explode(" ", $ordinfo['pickp_city']);
                if(count($splitstr)>1){
                    $slocdata = trim($splitstr[0]);
                    $slocdata2 = trim($splitstr[1]);
                    $slocdata3 = isset($splitstr[2]) ? trim($splitstr[2]) : "";
                    if($slocdata3 != ""){
                        if($slocdata2 != ""){
                            $slocdata2 = $slocdata2." ".$slocdata3;
                        }else{
                            $slocdata2 = $slocdata3;
                        }
                    }
                }
            }
            $chkspace1 = strrpos($ordinfo['delivery_city']," ");
            if($chkspace1){
                $splitstr1 = explode(" ", $ordinfo['delivery_city']);
                if(count($splitstr1)>1){
                    $dlocdata = trim($splitstr1[0]);
                    $dlocdata2 = trim($splitstr1[1]);
                    $dlocdata3 = isset($splitstr1[2]) ? trim($splitstr1[2]) : "";
                    if($dlocdata3 != ""){
                        if($dlocdata2 != ""){
                            $dlocdata2 = $dlocdata2." ".$dlocdata3;
                        }else{
                            $dlocdata2 = $dlocdata3;
                        }
                    }
                }
            }
            if($scitydata != "" && $dcitydata != ""){
                $citywhr = "origin LIKE '%".$scitydata."%' AND destination LIKE '%".$dcitydata."%' AND status=1";
            }else{
                if($scitydata != ""){
                    $citywhr = "origin LIKE '%".$scitydata."%' AND destination LIKE '%".$ordinfo['delivery_city']."%' AND status=1";
                }else if($dcitydata != ""){
                    $citywhr = "origin LIKE '%".$ordinfo['pickp_city']."%' AND destination LIKE '%".$dcitydata."%' AND status=1";
                }
            }
            if($slocdata != "" && $slocdata2 != "" && $dlocdata != "" && $dlocdata2 != ""){
                $citywhr1 = "(origin LIKE '%".$slocdata."%' OR origin LIKE '%".$slocdata2."%') AND (destination LIKE '%".$dlocdata."%' OR destination LIKE '%".$dlocdata2."%') AND status=1";
            }else{
                if($slocdata != "" && $slocdata2 != ""){
                    $citywhr1 = "(origin LIKE '%".$slocdata."%' OR origin LIKE '%".$slocdata2."%') AND destination LIKE '%".$ordinfo['delivery_city']."%' AND status=1";
                }else if($dlocdata != "" && $dlocdata2 != ""){
                    $citywhr1 = "origin LIKE '%".$ordinfo['pickp_city']."%' AND (destination LIKE '%".$dlocdata."%' OR destination LIKE '%".$dlocdata2."%') AND status=1";
                }
            }
        }else{
            $pinwhr = array("destinate_pincode"=>$ordinfo['pickup_pin'],"origin_pincode"=>$ordinfo['delivery_pin'],"status"=>1);
            if($ordinfo['delivery_city'] == "GURGAON"){
                $ordinfo['delivery_city'] = "Bilaspur-HR";
            }
            $actualcitychk = $citywhr = "destination LIKE '%".$ordinfo['pickp_city']."%' AND origin LIKE '%".$ordinfo['delivery_city']."%' AND status=1";
            $slocdata = $slocdata2 = $dlocdata = $dlocdata2 = $scitydata = $dcitydata = "";
            $chkdblspace = strrpos($ordinfo['pickp_city'],"  ");
            if($chkdblspace){
                $citystate = explode("  ",$ordinfo['pickp_city']);
                if(count($citystate)>1){
                    $citydata = trim($citystate[0]); /*state*/
                    $scitydata = trim($citystate[1]); /*city*/
                }
            }
            $chkdblspace1 = strrpos($ordinfo['delivery_city'],"  ");
            if($chkdblspace1){
                $citystate1 = explode("  ",$ordinfo['delivery_city']);
                if(count($citystate1)>1){
                    $citydata = trim($citystate1[0]); /*state*/
                    $dcitydata = trim($citystate1[1]); /*city*/
                }
            }
            $chkspace = strrpos($ordinfo['pickp_city']," ");
            if($chkspace){
                $splitstr = explode(" ", $ordinfo['pickp_city']);
                if(count($splitstr)>1){
                    $slocdata = trim($splitstr[0]);
                    $slocdata2 = trim($splitstr[1]);
                    $slocdata3 = isset($splitstr[2]) ? trim($splitstr[2]) : "";
                    if($slocdata3 != ""){
                        if($slocdata2 != ""){
                            $slocdata2 = $slocdata2." ".$slocdata3;
                        }else{
                            $slocdata2 = $slocdata3;
                        }
                    }
                }
            }
            $chkspace1 = strrpos($ordinfo['delivery_city']," ");
            if($chkspace1){
                $splitstr1 = explode(" ", $ordinfo['delivery_city']);
                if(count($splitstr1)>1){
                    $dlocdata = trim($splitstr1[0]);
                    $dlocdata2 = trim($splitstr1[1]);
                    $dlocdata3 = isset($splitstr1[2]) ? trim($splitstr1[2]) : "";
                    if($dlocdata3 != ""){
                        if($dlocdata2 != ""){
                            $dlocdata2 = $dlocdata2." ".$dlocdata3;
                        }else{
                            $dlocdata2 = $dlocdata3;
                        }
                    }
                }
            }
            if($scitydata != "" && $dcitydata != ""){
                $citywhr = "destination LIKE '%".$scitydata."%' AND origin LIKE '%".$dcitydata."%' AND status=1";
            }else{
                if($scitydata != ""){
                    $citywhr = "destination LIKE '%".$scitydata."%' AND origin LIKE '%".$ordinfo['delivery_city']."%' AND status=1";
                }else if($dcitydata != ""){
                    $citywhr = "destination LIKE '%".$ordinfo['pickp_city']."%' AND origin LIKE '%".$dcitydata."%' AND status=1";
                }
            }
            if($slocdata != "" && $slocdata2 != "" && $dlocdata != "" && $dlocdata2 != ""){
                $citywhr1 = "(destination LIKE '%".$slocdata."%' OR destination LIKE '%".$slocdata2."%') AND (origin LIKE '%".$dlocdata."%' OR origin LIKE '%".$dlocdata2."%') AND status=1";
            }else{
                if($slocdata != "" && $slocdata2 != ""){
                    $citywhr1 = "(destination LIKE '%".$slocdata."%' OR destination LIKE '%".$slocdata2."%') AND origin LIKE '%".$ordinfo['delivery_city']."%' AND status=1";
                }else if($dlocdata != "" && $dlocdata2 != ""){
                    $citywhr1 = "destination LIKE '%".$ordinfo['pickp_city']."%' AND (origin LIKE '%".$dlocdata."%' OR origin LIKE '%".$dlocdata2."%') AND status=1";
                }
            }
        }
        $chkcount = 0;
        $chkdays = $this->common->gettblrowdata($pinwhr,"return_cutoff,dto_cutoff,return_tat,dto_tat,frd_surface_cutoff,frd_surface_tat","tb_uniqlo_rvp_tat",0,0);
        if(count($chkdays) == 0){
            $chkdays = $this->common->gettblrowdata($actualcitychk,"return_cutoff,dto_cutoff,return_tat,dto_tat,frd_surface_cutoff,frd_surface_tat","tb_uniqlo_rvp_tat",0,0);
            if(count($chkdays) == 0){
                $chkdays = $this->common->gettblrowdata($citywhr,"return_cutoff,dto_cutoff,return_tat,dto_tat,frd_surface_cutoff,frd_surface_tat","tb_uniqlo_rvp_tat",0,0);
                if(count($chkdays) == 0){
                    if($citywhr1 != ""){
                        $chkdays = $this->common->gettblrowdata($citywhr1,"return_cutoff,dto_cutoff,return_tat,dto_tat,frd_surface_cutoff,frd_surface_tat","tb_uniqlo_rvp_tat",0,0);
                        if(count($chkdays) > 0){
                            $chkcount = 1;
                        }
                    }
                }else{
                    $chkcount = 1;
                }
            }else{
                $chkcount = 1;
            }
        }else{
            $chkcount = 1;
        }
        if($chkcount == 1){
            $curdt = $ordinfo['manifesttime'];
            if($ordinfo['order_type'] == '16'){
                $returntat = $chkdays['return_tat'];
                $exppickdate = date("Y-m-d",strtotime("+$returntat days", strtotime($curdt)));
                $exppickdate = $exppickdate." ".trim($chkdays['return_cutoff']);
                $dtotat = $chkdays['dto_tat'];
                $dtodate = date("Y-m-d",strtotime("+$dtotat days", strtotime($curdt)));
                $dtodate = $dtodate." ".trim($chkdays['dto_cutoff']);
                $response = array("expdeliver_date"=>$exppickdate,"expdto_date"=>$dtodate);
            }else{
                $frdtat = $chkdays['frd_surface_tat'];
                if($frdtat != ""){
                    $exppickdate = date("Y-m-d",strtotime("+$frdtat days", strtotime($curdt)));
                    $exppickdate = $exppickdate." ".trim($chkdays['frd_surface_cutoff']);
                    $response = array("expdeliver_date"=>$exppickdate,"expdto_date"=>"");
                }
            }
        }
        /*even found pincodes from TAT, get the data from push API only*/
        if($ordinfo['container_num'] != ""){
            $whr = array("awbnum"=>$ordinfo['container_num']);
            $chkpushdata = $this->common->gettbllastrowdata($whr,"status_name,status_datetime,promise_deliver_date","tb_uniqlo_push_api_data",0,0);
            if(count($chkpushdata)>0){
                if($chkpushdata['promise_deliver_date'] != ""){
                    if(empty($response)){
                        $response["expdto_date"] = "";
                    }
                    $response["expdeliver_date"] = $chkpushdata['promise_deliver_date'];
                }
            }
        }
        return $response;
    }
    public function etnshipment($ordr=""){
        if($ordr != ""){
            $ord1 = $this->getOrderId($ordr);
            if($ord1){
                $data["id"] = $ord1;
                $ordchkqry = $this->db->get_where("tb_orders",array("id"=>$ord1),1,0);
                if($ordchkqry->num_rows()>0){
                    $ord = $ordchkqry->row();
                    $data["order"] = $ord;
                    $data["order_id"] = $ord->order_id;
                    $oid = $ord->id;
                    $data['lguid'] = $uid = $ord->user_id;
                    $user = $this->db->select("id,country_code")->get_where("tb_users",array("id"=>$uid),1,0)->row_array();
                    $tz = $this->getUserTimeZone($user['id'],$user['country_code']);
                    $curtz = $tz['timezone'];
                    $data["timezone"] = $curtz;
                    $data["trip"] = array();
                    $tripinfo = chkTripinfoByOrdertrip($ord->trip_id,$curtz);
                    if(count($tripinfo)>0){
                        $data["trip_id"] = $trip_id = $tripinfo['id'];
                        $data["trip"] = $trip = $tripinfo;
                        $data["driver"] = $driver_row = array();
                        $drivdetail = $this->db->select("id,name,contact_num,track_type")->get_where("tb_truck_drivers",array("id"=>$trip['driver_id']),1,0);
                        if($drivdetail->num_rows()>0){
                            $data["driver"] = $driver_row = $drivdetail->row_array();
                        }
                        $data["vehicle"] = $data["record"] = array();
                        if($trip['status'] == 1){
                            $vehicle = $this->db->select("register_number,latitude,longitude,speed,battery,receivedon as `timestamp`")->get_where("tb_trucks_data",array("id"=>$trip['vehicle_id']),1,0);
                            if($vehicle->num_rows()>0){
                                $data["vehicle"] = $data["record"] = $vehicle->row_array();
                            }
                        }else{
                            $vehicle = $this->db->select("register_number,latitude,longitude,speed,battery,receivedon as `timestamp`")->get_where("tb_trucks_data",array("id"=>$trip['vehicle_id']),1,0);
                            if($vehicle->num_rows()>0){
                                $data["vehicle"] = $vehicle->row_array();
                            }
                            $data["record"] = array("latitude"=>$tripinfo['latitude'],"longitude"=>$tripinfo['longitude'],"speed"=>30,"battery"=>60,"timestamp"=>$tripinfo['time']);
                        }
                        $data["ref"] = "";
                        $refs = $this->db->query("SELECT GROUP_CONCAT(ref_value) as ref from tb_order_references where order_id=$oid AND status=1");
                        if($refs->num_rows()>0){
                            $data['ref'] = $refs->row()->ref;
                        }
                        $flag = $lat = $lng = $dist = 0;
                        if($tripinfo['status'] == 1){
                            $records = $data["records"] = $this->db->query("SELECT latitude,longitude,speed,battery,`timestamp` from tb_rtdrive_locations where trip_id = '$trip_id' ORDER BY `timestamp` ASC");
                            if ($records->num_rows() > 0) {
                                foreach ($records->result() as $row) {
                                    if ($flag == 0) {
                                        $flag = 1;
                                        $lat = $row->latitude;
                                        $lng = $row->longitude;
                                        $tstamp = $row->timestamp;
                                    } else {
                                        $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                                        if($tstamp != 0){
                                            $datetime1 = new DateTime($tstamp);//start time
                                            $datetime2 = new DateTime($row->timestamp);//end time
                                            $interval = $datetime1->diff($datetime2);
                                            $time = $interval->format('%s');
                                            if($time > 0){
                                                $ratio = ($a*1000)/$time;
                                            }else{
                                                $ratio = 0;
                                            }
                                            if($ratio < 30 || $time < 300){ // 30 is max allowed spped 30 MPS equelent to 108 KMPH
                                                $dist = $dist + $a;
                                                $lat = $row->latitude;
                                                $lng = $row->longitude;
                                                $tstamp = $row->timestamp;
                                            }
                                        }else{
                                            $dist = $dist + $a;
                                        }
                                    }
                                }
                            }
                        }else{
                            $data["records"] = $this->db->query("SELECT latitude,longitude,speed,battery,`timestamp` from tb_rtdrive_locations where trip_id = '$trip_id' ORDER BY `timestamp` ASC");
                            $tripdist = $this->db->select("trip_distance")->get_where("tb_trip_summary",array("trip_id"=>$trip_id),1,0);
                            if($tripdist->num_rows()>0){
                                $dist = $tripdist->row()->trip_distance;
                            }
                        }
                        $data["travel_dist"] = round($dist,2);
                        $data["isSimBased"] = "false";
                        $data["drivers"] = array();
                        $drivers = $this->db->query("SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'".$curtz."') as createdon,d.track_type,td.travelled_km FROM tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE trip_id = $trip_id AND td.status ='1' GROUP BY d.id ORDER BY td.createdon ASC");
                        if($drivers->num_rows()>0){
                            $data["drivers"] = $drivers->result_array();
                        }
                        if(count($driver_row)>0){
                            $data["drivers"][] = array("id"=>$driver_row['id'],"name"=>$driver_row['name'],"contact_num"=>$driver_row['name'],"createdon"=>null,"track_type"=>$driver_row['track_type'],"travelled_km"=>$dist);
                        }
                        if (count($data["drivers"])>0){
                            if(isset($data["drivers"][count($data["drivers"])-1]["track_type"])){
                                if($data["drivers"][count($data["drivers"])-1]["track_type"] == "1"){
                                    $data["isSimBased"] = "true";
                                }
                            }
                        }
                        $data["pings"] = $data["records"]->num_rows();
                        $this->load->view('publictrack/view',$data);
                    }else{
                        $data["trip_id"] = 0;
                        $order_id = $ord->order_id;
                        $recs = $this->db->query("SELECT shift_id FROM tb_employee WHERE order_id = '$ordr' GROUP BY order_id");
                        if($recs->num_rows()>0){
                            $shift_id = $recs->row()->shift_id;
                            $shft_vehs = $this->db->query("SELECT vehicle_id FROM tb_shft_veh WHERE shft_id=$shift_id AND status=1 LIMIT 1");
                            if($shft_vehs->num_rows()>0){
                                $vehicle_id = $shft_vehs->row()->vehicle_id;
                                $trip = $this->db->select("driver_id")->order_by("updated_on","DESC")->get_where("tb_assigned_drivers",array("vehicle_id"=>$vehicle_id,"status"=>1),1,0);
                                if($trip->num_rows()>0){
                                    $driver_id = $trip->row()->driver_id;
                                    $dist = 0;
                                    $data["travel_dist"] = 0.00;
                                    $data["isSimBased"] = "false";
                                    $data["drivers"] = array();
                                    $data["driver"] = $driver_row = array();
                                    $drivdetail = $this->db->select("id,name,contact_num,track_type")->get_where("tb_truck_drivers",array("id"=>$driver_id),1,0);
                                    if($drivdetail->num_rows()>0){
                                        $data["driver"] = $driver_row = $drivdetail->row_array();
                                    }
                                    $data["vehicle"] = $data["record"] = array();
                                    $vehicle = $this->db->select("register_number,latitude,longitude,speed,battery,receivedon as `timestamp`")->get_where("tb_trucks_data",array("id"=>$vehicle_id),1,0);
                                    if($vehicle->num_rows()>0){
                                        $data["vehicle"] = $data["record"] = $vehicle->row_array();
                                    }
                                    $data["ref"] = "";
                                    $refs = $this->db->query("SELECT GROUP_CONCAT(ref_value) as ref from tb_order_references where order_id=$oid AND status=1");
                                    if($refs->num_rows()>0){
                                        $data['ref'] = $refs->row()->ref;
                                    }
                                    if(count($driver_row)>0){
                                        $data["drivers"][] = array("id"=>$driver_row['id'],"name"=>$driver_row['name'],"contact_num"=>$driver_row['name'],"createdon"=>null,"track_type"=>$driver_row['track_type'],"travelled_km"=>$dist);
                                    }
                                    if (count($data["drivers"])>0){
                                        if(isset($data["drivers"][count($data["drivers"])-1]["track_type"])){
                                            if($data["drivers"][count($data["drivers"])-1]["track_type"] == "1"){
                                                $data["isSimBased"] = "true";
                                            }
                                        }
                                    }
                                    $data["records"] = $this->db->query("SELECT latitude,longitude,speed,battery,`timestamp` from tb_rtdrive_locations where driver_id = '$driver_id' ORDER BY `timestamp` ASC");
                                    $data["pings"] = 0;
                                    $this->load->view('publictrack/view',$data);
                                }
                            }
                        }
                    }
                }
            }else{
                echo "No order info found!";
            }
        }else{
            echo "No order info found!";
        }
    }
    function getUserTimeZone($uid,$cmpcode){
        $getqry = $this->db->query("SELECT country_code,cntry_timezone,cntry_hrs,currency FROM tbl_country_master WHERE (country_code='".$cmpcode."' OR country_name='".$cmpcode."') AND status=1 LIMIT 1");
        $res = array("currency"=>"SGD","timezone"=>"Asia/Singapore","hrs"=>"+08.00","country"=>"SG");
        if($getqry->num_rows()>0){
            $res = array("currency"=>$getqry->row()->currency,"timezone"=>$getqry->row()->cntry_timezone,"hrs"=>$getqry->row()->cntry_hrs,'country'=>$getqry->row()->country_code);
        }
        return $res;
    }
    public function autocomplete(){
        $output='';
        $post["query"] = $this->input->post("query",true);
        if(isset($post["query"]))
        {
        $output = '';
        $query = "SELECT order_id FROM tb_orders  WHERE status !=0 AND order_id LIKE '%".$post["query"]."%'";
        $result=$this->db->query($query);
        $output = '<ul class="list-unstyled">';
        if($result->num_rows() > 0)
        {
        foreach($result->result_array() as $res)
        {
        $output .= '<li>'.$res['order_id'].'</li>';
        }
        }
        else
        {
        $output .= '<li>Order Not Found</li>';
        }
        $output .= '</ul>';
        echo $output;
        }
    }
}
