<?php defined('BASEPATH') or exit('No direct script access allowed');
class Ratecategory extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Ratecategory_model');
        if ($this->session->userdata("user_id") == "") {
            redirect("login");
        }
    } 

    /*
     * Listing of rate_categories
     */
    function index()
    {
        $params['limit'] = 10; 
        $params['offset'] = ($this->input->get('per_page')) ? $this->input->get('per_page') : 0;
        
        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('rate_category/index?');
        $config['total_rows'] = $this->Ratecategory_model->get_all_rate_categories_count();
        $this->pagination->initialize($config);

        $data['rate_categories'] = $this->Ratecategory_model->get_all_rate_categories($params);
        
        $this->settemplate->dashboard('ratecategory/index',$data);
    }

    /*
     * Adding a new rate_category
     */
    function add()
    {   
        if(isset($_POST) && count($_POST) > 0)     
        {   
            $params = array(
				'status' => $this->input->post('status'),
				'name' => $this->input->post('name'),
            );
            
            $rate_category_id = $this->Ratecategory_model->add_rate_category($params);
            redirect('ratecategory/index');
        }
        else
        {
        	$data = [];
            $this->settemplate->dashboard('ratecategory/add',$data);
        }
    }  

    /*
     * Editing a rate_category
     */
    function edit($id)
    {   
        // check if the rate_category exists before trying to edit it
        $data['rate_category'] = $this->Ratecategory_model->get_rate_category($id);
        
        if(isset($data['rate_category']['id']))
        {
            if(isset($_POST) && count($_POST) > 0)     
            {   
                $params = array(
					'status' => $this->input->post('status'),
					'name' => $this->input->post('name'),
                );

                $this->Ratecategory_model->update_rate_category($id,$params);            
                redirect('ratecategory/index');
            }
            else
            {
                $this->settemplate->dashboard('ratecategory/edit',$data);
            }
        }
        else
            show_error('The rate_category you are trying to edit does not exist.');
    } 

    /*
     * Deleting rate_category
     */
    function remove($id)
    {
        $rate_category = $this->Ratecategory_model->get_rate_category($id);

        // check if the rate_category exists before trying to delete it
        if(isset($rate_category['id']))
        {
            $this->Ratecategory_model->delete_rate_category($id);
            redirect('ratecategory/index');
        }
        else
            show_error('The rate_category you are trying to delete does not exist.');
    }
    
}

?>