<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Ratemanagementexcel extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(["common","orderrevenuesmodel"]);
        $this->load->library('quickrateshandler');
    }

    public function index():void
    {
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        require_once APPPATH . "/third_party/PHPExcel.php";
        require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";
        $data = $errorline = $message = [];
        if (isset($_FILES['import_file'])) {
            $ext = pathinfo($_FILES['import_file']['name'], PATHINFO_EXTENSION);
            $value = [];
            $val = [];
            if ($ext == "xls" || $ext == "xlsx") {
                $path = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($path);
                $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
                $data["arr_data"] = $mainheader = [];
                foreach ($cell_collection as $cell) {
                    $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                    $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                    $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();
                    $newdtat[] = $column;
                    if ($row == 1) {
                        if ($data_value != "") {
                            $mainheader[$column] = $data_value;
                        }
                    }
                    if ($row == 2) {
                        $data["header"][$row][$column] = $data_value;
                    } else {
                        if ($row > 2) {
                            if ($data_value != "") {
                                $data["arr_data"][$row][$column] = $data_value;
                            }
                        }
                    }
                }
                $row = 3;
                $arr = [];
                $sno = "";
                foreach ($data["arr_data"] as $value[$row]) {
                    $value[$row]['row'] = $row;
                    $arr[$sno][] = $value[$row];
                    $row++;
                }

                $arrdata = [];
                if (!empty($arr)) {
                    foreach ($arr as $ar) {
                        $arrdata[] = $ar;
                    }
                }

                $rate_data = $checkValues = $allServiceNames =$fuelIds= [];
                if (!empty($arrdata)) {
                    for ($i = 0; $i < count($arrdata['0']); $i++) {
                        $charges = $geoTier = $rateTier = [];
                        $tarrifType = isset($arrdata['0'][$i]['B']) ? $arrdata['0'][$i]['B'] : "";
                        if ($i == 0 || $tarrifType != '') {
                            $j = $i;
                        }

                        $rowno = isset($arrdata['0'][$i]['row']) ? $arrdata['0'][$i]['row'] : "";
                        $mainrowno = $rowno;
                        $serviceType = isset($arrdata['0'][$i]['C']) ? $arrdata['0'][$i]['C'] : "";
                        $geoTierId = isset($arrdata['0'][$i]['R']) ? $arrdata['0'][$i]['R'] : "";
                        $rateTierId = isset($arrdata['0'][$i]['U']) ? $arrdata['0'][$i]['U'] : "";
                        $chargeId = isset($arrdata['0'][$i]['K']) ? $arrdata['0'][$i]['K'] : "";
                        $exchangeRateId = isset($arrdata['0'][$i]['L']) ? $arrdata['0'][$i]['L'] : "";
                        $chargeBasis = isset($arrdata['0'][$i]['M']) ? $arrdata['0'][$i]['M'] : "";
                        $minimumAmount = isset($arrdata['0'][$i]['N']) ? $arrdata['0'][$i]['N'] : "";
                        $amount = isset($arrdata['0'][$i]['O']) ? $arrdata['0'][$i]['O'] : "";
                        $fuelSurCharge = isset($arrdata['0'][$i]['P']) ? $arrdata['0'][$i]['P'] : "";
                        $currency = isset($arrdata['0'][$i]['Q']) ? $arrdata['0'][$i]['Q'] : "";
                        $geoChargeId = isset($arrdata['0'][$i]['S']) ? $arrdata['0'][$i]['S'] : "";
                        $geoCurrency = isset($arrdata['0'][$i]['T']) ? $arrdata['0'][$i]['T'] : "";
                        $rateChargeId = isset($arrdata['0'][$i]['V']) ? $arrdata['0'][$i]['V'] : "";
                        $rateCurrency = isset($arrdata['0'][$i]['W']) ? $arrdata['0'][$i]['W'] : "";
                        if ($tarrifType == '') {
                            if ($chargeId != "") {
                                $charges = ['rowno' => $mainrowno, 'chargeId' => $chargeId, 'exchangeRateId' => $exchangeRateId, 'chargeBasis' => $chargeBasis, 'minimumAmount' => $minimumAmount, 'amount' => $amount, 'fuelSurCharge' => $fuelSurCharge, 'currency' => $currency];
                                $checkValues[] = ['value' => $chargeId, 'message' => 'ChargeId empty on line: ' . $mainrowno, 'errorline' => 'chargeId' . $mainrowno];
                                $checkValues[] = ['value' => $chargeBasis, 'message' => 'ChargeBasis empty on line: ' . $mainrowno, 'errorline' => 'ChargeBasis' . $mainrowno];
                                if($chargeId == 'FAF-FAF' && $chargeBasis == 'FRT'){
                                    $checkValues[] = ['value' => $fuelSurCharge, 'message' => 'FuelSurcharge empty on line: ' . $mainrowno, 'errorline' => 'FuelSurcharge' . $mainrowno];
                                }
                            }
                            if ($geoTierId != "") {
                                $geoTier = ['rowno' => $mainrowno, 'geoTierId' => $geoTierId, 'chargeId' => $geoChargeId, 'currency' => $geoCurrency];
                                $checkValues[] = ['value' => $geoTierId, 'message' => 'GeoTierId empty on line: ' . $mainrowno, 'errorline' => 'GeoTierId' . $mainrowno];
                                $checkValues[] = ['value' => $geoChargeId, 'message' => 'GeoTier ChargeId empty on line: ' . $mainrowno, 'errorline' => 'GeoChargeId' . $mainrowno];
                            }
                            if ($rateTierId != "") {
                                $rateTier = ['rowno' => $mainrowno, 'rateTierId' => $rateTierId, 'chargeId' => $rateChargeId, 'currency' => $rateCurrency];
                                $checkValues[] = ['value' => $rateTierId, 'message' => 'RateTierId empty on line: ' . $mainrowno, 'errorline' => 'RateTierId' . $mainrowno];
                                $checkValues[] = ['value' => $rateChargeId, 'message' => 'Rate Tier ChargeId empty on line: ' . $mainrowno, 'errorline' => 'RateChargeId' . $mainrowno];
                            }

                            if ($chargeId != '') {
                                $rate_data[$j]['charges'][] = $charges;
                            }
                            if ($geoTierId != '') {
                                $rate_data[$j]['geoTier'][] = $geoTier;
                            }
                            if ($rateTierId != '') {
                                $rate_data[$j]['rateTier'][] = $rateTier;
                            }
                            continue;
                        }
                        $serviceName = isset($arrdata['0'][$i]['D']) ? $arrdata['0'][$i]['D'] : "";
                        if (!empty($allServiceNames)) {
                            if (in_array($serviceName, $allServiceNames)) {
                                $checkValues[] = ['value' => '', 'message' => 'ServiceName already exists in excel: ' . $mainrowno, 'errorline' => 'serviceNameExcel' . $mainrowno];
                            } else {
                                $allServiceNames[] = $serviceName;
                            }
                        } else {
                            $allServiceNames[] = $serviceName;
                        }

                        $product = isset($arrdata['0'][$i]['E']) ? $arrdata['0'][$i]['E'] : "";
                        $LaneID = isset($arrdata['0'][$i]['F']) ? $arrdata['0'][$i]['F'] : "";
                        $customerProfile = isset($arrdata['0'][$i]['G']) ? $arrdata['0'][$i]['G'] : "";
                        $vendorProfile = isset($arrdata['0'][$i]['H']) ? $arrdata['0'][$i]['H'] : "";
                        $effectiveDate = isset($arrdata['0'][$i]['I']) ? $arrdata['0'][$i]['I'] : "";
                        if ($effectiveDate != "") {
                            $UNIX_DATE = ($effectiveDate - 25569) * 86400;
                            $EXCEL_DATE = 25569 + ($UNIX_DATE / 86400);
                            $UNIX_DATE = ($EXCEL_DATE - 25569) * 86400;
                            $effectiveDate = gmdate("Y-m-d", $UNIX_DATE);
                        }
                        $expiryDate = isset($arrdata['0'][$i]['J']) ? $arrdata['0'][$i]['J'] : "";
                        if ($expiryDate != "") {
                            $UNIX_DATE = ($expiryDate - 25569) * 86400;
                            $EXCEL_DATE = 25569 + ($UNIX_DATE / 86400);
                            $UNIX_DATE = ($EXCEL_DATE - 25569) * 86400;
                            $expiryDate = gmdate("Y-m-d", $UNIX_DATE);
                        }
                        if ($chargeId != '') {
                            $charges = ['rowno' => $mainrowno, 'chargeId' => $chargeId, 'exchangeRateId' => $exchangeRateId, 'chargeBasis' => $chargeBasis, 'minimumAmount' => $minimumAmount, 'amount' => $amount, 'fuelSurCharge' => $fuelSurCharge, 'currency' => $currency];
                            $checkValues[] = ['value' => $chargeId, 'message' => 'ChargeId empty on line: ' . $mainrowno, 'errorline' => 'chargeId' . $mainrowno];
                            $checkValues[] = ['value' => $chargeBasis, 'message' => 'ChargeBasis empty on line: ' . $mainrowno, 'errorline' => 'ChargeBasis' . $mainrowno];
                            if($chargeId == 'FAF-FAF' && $chargeBasis == 'FRT'){
                                $checkValues[] = ['value' => $fuelSurCharge, 'message' => 'FuelSurcharge empty on line: ' . $mainrowno, 'errorline' => 'FuelSurcharge' . $mainrowno];
                            }
                        }
                        if ($geoTierId != '') {
                            $geoTier = ['rowno' => $mainrowno, 'geoTierId' => $geoTierId, 'chargeId' => $geoChargeId, 'currency' => $geoCurrency];
                            $checkValues[] = ['value' => $geoTierId, 'message' => 'GeoTierId empty on line: ' . $mainrowno, 'errorline' => 'GeoTierId' . $mainrowno];
                            $checkValues[] = ['value' => $geoChargeId, 'message' => 'GeoTier ChargeId empty on line: ' . $mainrowno, 'errorline' => 'GeoChargeId' . $mainrowno];
                        }
                        if ($rateTierId != '') {
                            $rateTier = ['rowno' => $mainrowno, 'rateTierId' => $rateTierId, 'chargeId' => $rateChargeId, 'currency' => $rateCurrency];
                            $checkValues[] = ['value' => $rateTierId, 'message' => 'RateTierId empty on line: ' . $mainrowno, 'errorline' => 'RateTierId' . $mainrowno];
                            $checkValues[] = ['value' => $rateChargeId, 'message' => 'Rate Tier ChargeId empty on line: ' . $mainrowno, 'errorline' => 'RateChargeId' . $mainrowno];
                        }
                        $fuelChargeIds = $this->getamountfromfuelsurcharge($tarrifType, $customerProfile, $vendorProfile);
                        if (!empty($fuelChargeIds)) {
                            foreach ($fuelChargeIds as $fuel) {
                                $fuelIds[] = trim(strtoupper($fuel['faf_id']));
                            }
                        }
                        $rate_data[$i] = [
                            'tarrifType' => $tarrifType,
                            'serviceType' => $serviceType,
                            'serviceName' => $serviceName,
                            'product' => $product,
                            'laneId' => $LaneID,
                            'customerProfile' => $customerProfile,
                            'vendorProfile' => $vendorProfile,
                            'effectiveDate' => $effectiveDate,
                            'expiryDate' => $expiryDate,
                            'rowno' => $mainrowno,
                            'fuelChargeIds' => $fuelIds
                        ];
                        if ($chargeId != '') {
                            $rate_data[$j]['charges'][] = $charges;
                        }
                        if ($geoTierId != '') {
                            $rate_data[$j]['geoTier'][] = $geoTier;
                        }
                        if ($rateTierId != '') {
                            $rate_data[$j]['rateTier'][] = $rateTier;
                        }

                        if (!empty($tarrifType)) {
                            $checkValues[] = ['value' => $serviceType, 'message' => 'Service Type  empty on line: ' . $mainrowno, 'errorline' => 'serviceType' . $mainrowno];
                            $checkValues[] = ['value' => $serviceName, 'message' => 'Service Name  empty on line: ' . $mainrowno, 'errorline' => 'serviceName' . $mainrowno];
                            $checkValues[] = ['value' => $LaneID, 'message' => 'LaneID  empty on line: ' . $mainrowno, 'errorline' => 'LaneID' . $mainrowno];
                            $checkValues[] = ['value' => $effectiveDate, 'message' => 'Effective Date  empty on line: ' . $mainrowno, 'errorline' => 'EffectiveDate' . $mainrowno];
                            $checkValues[] = ['value' => $expiryDate, 'message' => 'Expiry Date  empty on line: ' . $mainrowno, 'errorline' => 'ExpiryDate' . $mainrowno];

                            if ($tarrifType == 'BUY') {
                                $checkValues[] = ['value' => $vendorProfile, 'message' => 'VendorProfile  empty on line: ' . $mainrowno, 'errorline' => 'vendorProfile' . $mainrowno];
                            } elseif ($tarrifType == 'SELL') {
                                $checkValues[] = ['value' => $customerProfile, 'message' => 'CustomerProfile  empty on line: ' . $mainrowno, 'errorline' => 'CustomerProfile' . $mainrowno];
                            }
                        }
                    }
                    foreach ($checkValues as $res) {
                        $value = $res['value'];
                        if ($value == "") {
                            $message[] = $res['message'];
                            $errorLine[] = $res['errorline'];
                        }
                    }
                }
            }
        }
        $data['rate_data'] = $rate_data ?? [];
        $data['errorline'] = $errorLine ?? [];
        $data["message"] = $message ?? [];
        $data['serviceNameExists'] = $this->common->gettbldata(['company_code' => $companyCode, 'branch_code' => $branchCode], 'service_name', 'tb_rate_services', 0, 0);
        $data['laneCheck'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,lane_id,lane_name', 'tb_lanes_master', 0, 0);
        $data['customerPrfileCheck'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode, 'branch_code' => $branchCode], 'cust_profile_id', 'tb_customer_profile', 0, 0);
        $data['vendorProfileCheck'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode, 'branch_code' => $branchCode], 'vend_profile_id', 'tb_vendor_profile', 0, 0);
        $data['charges'] = $this->common->gettbldata(['status' => 1], 'charge_code', 'tb_charge_codes', 0, 0);
        $data['tier'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,tier_id,tier_name', 'tb_tier_master', 0, 0);
        $data['geoTier'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,geo_tier_id,geo_tier_name', ' tb_geo_tier', 0, 0);
        $data['exchangeRateId'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,exchange_rate_id,exchange_rate_name', 'tb_rate_exchange', 0, 0);
        $data["page_title"] = "Rate Excel Upload";
        $this->settemplate->dashboard("quickrates/rateexcel", $data);
    }
    public function getamountfromfuelsurcharge(string $tarrifType,string $customerProfile,string $vendorProfile):array
    {
        $company_code = $this->session->userdata('company_code');
        $result = [];
            if (!empty($tarrifType)) {
                if(!empty($vendorProfile)){
                    $getVendorId = $this->common->gettblrowdata(['vend_profile_id' => $vendorProfile], 'id', 'tb_vendor_profile', 0, 0);
                }
                if(!empty($customerProfile)){
                    $getCustomerId = $this->common->gettblrowdata(['cust_profile_id' => $customerProfile], 'id', 'tb_customer_profile', 0, 0);
                }
                $customerId = $getCustomerId['id'] ?? '';
                $vendorId = $getVendorId['id'] ?? '';
                $tarrif_match = $this->gettarrifmatchedrecords($tarrifType, $customerId, $vendorId);
                $empty_tarrif = $this->getemptytarrifrecords();
                if (!empty($tarrif_match)) {
                    foreach ($tarrif_match as $row) {
                        if (!empty($result)) {
                            if (!in_array($row['row_id'], $result)) {
                                $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                            }
                        } else {
                            $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                        }
                    }
                }
                if (!empty($empty_tarrif)) {
                    foreach ($empty_tarrif as $row) {
                        if (!empty($result)) {
                            if (!in_array($row['row_id'], $result)) {
                                $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                            }
                        } else {
                            $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                        }
                    }
                }
            }
        return $result;
    }
    public function getemptytarrifrecords():array
    {
        $faf_ids = array();
        $company_code = $this->session->userdata('company_code');
        $whr = " ( tariff_type IS NULL OR tariff_type = '' ) AND company_code LIKE '".$company_code."' AND status ='1'";
        $getempty_surcharge = $this->orderrevenuesmodel->getemptytariffrecords_forfaf($whr);
        if(!empty($getempty_surcharge)){
            foreach ($getempty_surcharge as $res){
                $faf_ids[] = array('row_id'=>$res['id'],'faf_name'=>$res['faf_name'],'faf_id'=>$res['faf_id']);
            }
        }
        return $faf_ids;
    }

    public function gettarrifmatchedrecords(string $tarrifType,string $customerId,string $vendorId):array
    {
        $surcharge_customer_id = $surcharge_carrier_id = 0;
        $surcharge_customer_code = $surcharge_carrier_code = "";
        $company_code = $this->session->userdata('company_code');
        $faf_ids = array();
        if($tarrifType != ""){
            $get_surcharge_qry = $this->common->gettbldata(array('tariff_type' => $tarrifType,'company_code'=>$company_code,'status' =>'1'),'id,faf_id,faf_name,customer_id,carrier_id','tb_fuel_surcharge', 0, 0);
            if(!empty($get_surcharge_qry)){
                foreach ($get_surcharge_qry as $get_surcharge){
                    $surcharge_customer_id = $get_surcharge['customer_id'];
                    $surcharge_carrier_id  = $get_surcharge['carrier_id'];
                    if($tarrifType == "SELL"){
                        if($surcharge_customer_id > 0){
                            $getcustomer_code = $this->common->gettblrowdata(array('id' =>$surcharge_customer_id,'company_code'=>$company_code,'status' =>'1'),'code','tb_customers', 0, 0);
                            if(!empty($getcustomer_code)){
                                $surcharge_customer_code = $getcustomer_code['code'];
                            }
                            if($surcharge_customer_code != ""){
                                $chkoffering_profile = $this->common->gettblrowdata(array('cp_id' =>$customerId,'profile_id'=>$surcharge_customer_code,'status' =>'1'),'id','tb_customer_profile_list', 0, 0);
                                if(!empty($chkoffering_profile)){
                                    $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                                }
                            }
                        }else{
                            $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                        }
                    }else if($tarrifType == "BUY"){
                        if($surcharge_carrier_id > 0){
                            $getcarrier_code = $this->common->gettblrowdata(array('id' =>$surcharge_carrier_id,'company_code'=>$company_code,'status' =>'1'),'code','tb_vendors', 0, 0);
                            if(!empty($getcarrier_code)){
                                $surcharge_carrier_code = $getcarrier_code['code'];
                            }
                            if($surcharge_carrier_code != ""){
                                $chkoffering_profile = $this->common->gettblrowdata(array('vp_id' =>$vendorId,'profile_id'=>$surcharge_carrier_code,'status' =>'1'),'id','tb_vendor_profile_list', 0, 0);
                                if(!empty($chkoffering_profile)){
                                    $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                                }
                            }
                        }else{
                            $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                        }
                    }
                }
            }
        }
        return $faf_ids;
    }

    public function addRatesData():void
    {
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $serviceTypeData = getServiceMasterData();
        $post['rates'] = $_POST['rates'] ?? [];
        $allIds = [];
        if (!empty($post)) {
            $i = 0;
            foreach ($post['rates'] as $ratesData) {
                $serviceId = $this->quickrateshandler->seridgen();
                $offeringId = $this->quickrateshandler->genofferid();
                $recordId = $this->quickrateshandler->rateRecordGen();
                $tarrifType = $ratesData['tarrifType'];
                $serviceName = $ratesData['serviceName'];
                $serviceNamesCheck[] =  $serviceName;
                $servviceType1 = explode('-', $ratesData['serviceType']);
                $serviceTypeId = $servviceType1['1'];
                foreach($serviceTypeData as $type){
                    if($serviceTypeId == $type['name']){
                        $serviceType =  $type['row_id'];
                    }
                }
                $product = $ratesData['product'] ?? '';
                $laneId1 = explode('-', $ratesData['laneId']);
                $laneTypeId = $laneId1['0'];
                $laneId = $this->common->gettblrowdata(['lane_id' => $laneTypeId], 'id', 'tb_lanes_master', 0, 0);
                $customerProfile = $ratesData['customerProfile'] ?? 0;
                $customerProfileId = $this->common->gettblrowdata(['cust_profile_id' => $customerProfile], 'id', 'tb_customer_profile', 0, 0);
                $vendorProfile = $ratesData['vendorProfile'] ?? 0;
                $vendorProfileId = $this->common->gettblrowdata(['vend_profile_id' => $vendorProfile], 'id', 'tb_vendor_profile', 0, 0);
                $effectiveDate = $ratesData['effectiveDate'];
                $expiryDate = $ratesData['expiryDate'];
                $offeringType = $this->common->gettblrowdata(['id' => $serviceType], 'transport_mode', 'tb_service_master', 0, 0);
                $rateServicedata = [
                    'service_id' => $serviceId,
                    'service_name' => $serviceName,
                    'service_type' => $serviceType,
                    'description' => $serviceName,
                    'company_code' => $companyCode,
                    'branch_code' => $branchCode,
                    'product' => $product ?? '',
                    'user_id' => $userId,
                    'status' => '1'
                ];
                $result = $this->common->insertTableData("tb_rate_services", $rateServicedata);
                if (!empty($result)) {
                    $data1 = [
                        'rate_id' => $result ?? null,
                        'lane_id' => $laneId['id'] ?? null,
                        'user_id' => $userId ?? null,
                        'status' => '1'
                    ];
                    $result1 = $this->common->insertTableData("tb_rateservice_lanes", $data1);
                    $offeringDataInsertion = [
                        'offering_id' => $offeringId,
                        'offering_name' => $serviceName,
                        'offering_type' => $offeringType['transport_mode'] ?? "FTL",
                        'description' => $serviceName,
                        'rate_service_id' => $result,
                        'lane_id' => $laneId['id'],
                        'effective_date' => $effectiveDate ?? null,
                        'expiry_date' => $expiryDate ?? null,
                        'tarrif_type' => $tarrifType ?? null,
                        'cust_profile_id' => $customerProfileId['id'] ?? 0,
                        'vendor_profile_id' => $vendorProfileId['id'] ?? 0,
                        'company_code' => $companyCode ?? null,
                        'branch_code' => $branchCode ?? null,
                        'user_id' => $userId ?? null,
                        'offering_active' => '1',
                        'status' => '1'
                    ];
                    $result2 = $this->common->insertTableData("tb_rate_offerings", $offeringDataInsertion);
                    if ($result2 > 0) {
                        $rateRecordInsert = [
                            'rate_id' => $recordId,
                            'record_name' => $serviceName,
                            'description' => $serviceName,
                            'offering_id' => $result2,
                            'company_code' => $companyCode ?? null,
                            'branch_code' => $branchCode ?? null,
                            'user_id' => $userId ?? null,
                            'status' => '1'
                        ];
                        $result3 = $this->common->insertTableData("tb_rate_records", $rateRecordInsert);
                        if ($result3 > 0) {
                            $allIds[$i]['serviceId'] = $serviceId;
                            $allIds[$i]['offeringId'] = $offeringId;
                            $allIds[$i]['recordId'] = $recordId;
                            if (!empty($ratesData['charges'])) {
                                foreach ($ratesData['charges'] as $allCharges) {
                                    $idForExchange1 = explode('-', $allCharges['exchangeRateId']);
                                    $exchangeTypeId = $idForExchange1['0'];
                                    $idForCharge1 = explode('-', $allCharges['chargeId']);
                                    $chargeTypeId1 = $idForCharge1['0'];
                                    $idForExchange = $this->common->gettblrowdata(['exchange_rate_id' => $exchangeTypeId], 'id', 'tb_rate_exchange', 0, 0);
                                    $idForCharge = $this->common->gettblrowdata(['charge_code' => $chargeTypeId1], 'id', 'tb_charge_codes', 0, 0);
                                    if(!empty($allCharges['fuelSurCharge'])){
                                        $fuelSurcharge = explode('-', $allCharges['fuelSurCharge']);
                                        $fuelSurchargeId = $fuelSurcharge['0'];
                                        $idForFuelSurcharge = $this->common->gettblrowdata(['faf_id' => $fuelSurchargeId], 'id', 'tb_fuel_surcharge', 0, 0);
                                    }
                                    $chargesData = [
                                        'exchange_rate_id' => $idForExchange['id'] ?? '',
                                        'rr_charge_type' => 'Fixed',
                                        'rr_charge_id' => $idForCharge['id'] ?? '',
                                        'charge_basis' => $allCharges['chargeBasis'] ?? '',
                                        'min_amount' => $allCharges['minimumAmount'] ?? '',
                                        'amount' => $allCharges['amount'] ?? '',
                                        'currency' => $allCharges['currency'] ?? '',
                                        'raterecord_id' => $result3,
                                        'percentage' => $allCharges['fuelSurCharge'] ?? '',
                                        'fuel_surcharge_id' => $idForFuelSurcharge['id'] ?? ''
                                    ];
                                    $chargeInsertion = $this->common->insertTableData("tb_raterecord_charges", $chargesData);
                                }
                            }
                            if (!empty($ratesData['geoTier'])) {
                                foreach ($ratesData['geoTier'] as $geoTiers) {
                                    $idForCharge2 = explode('-', $geoTiers['chargeId']);
                                    $chargeTypeId2 = $idForCharge2['0'];
                                    $idForGeo1 = explode('-', $geoTiers['geoTierId']);
                                    $geoTierId = $idForGeo1['0'];
                                    $idForCharge2 = $this->common->gettblrowdata(['charge_code' => $chargeTypeId2], 'id', 'tb_charge_codes', 0, 0);
                                    $idForGeo = $this->common->gettblrowdata(['geo_tier_id' => $geoTierId], 'id', 'tb_geo_tier', 0, 0);
                                    $geoTierData = [
                                        'rr_charge_type' => 'Geo Tier',
                                        'rr_charge_id' => $idForCharge2['id'],
                                        'geo_tier_id' => $idForGeo['id'],
                                        'currency' => $geoTiers['currency'] ?? '',
                                        'raterecord_id' => $result3,

                                    ];
                                    $geoTierInsertion = $this->common->insertTableData("tb_raterecord_charges", $geoTierData);
                                }
                            }
                            if (!empty($ratesData['rateTier'])) {
                                foreach ($ratesData['rateTier'] as $rateTiers) {
                                    $idForCharge3 = explode('-', $rateTiers['chargeId']);
                                    $chargeTypeId3 = $idForCharge3['0'];
                                    $idForTier1 = explode('-', $rateTiers['rateTierId']);
                                    $tierId = $idForTier1['0'];
                                    $idForCharge3 = $this->common->gettblrowdata(['charge_code' => $chargeTypeId3], 'id', 'tb_charge_codes', 0, 0);
                                    $idForTier = $this->common->gettblrowdata(['tier_id' => $tierId], 'id', 'tb_tier_master', 0, 0);
                                    $tierData = [
                                        'rr_charge_type' => 'Tier',
                                        'rr_charge_id' => $idForCharge3['id'] ?? '',
                                        'rr_tier_id' => $idForTier['id'] ?? '',
                                        'currency' => $rateTiers['currency'],
                                        'raterecord_id' => $result3,

                                    ];
                                    $rateTierInsertion = $this->common->insertTableData("tb_raterecord_charges", $tierData);
                                }
                            }
                        }
                    }
                }
                $i++;
            }
            if (!empty($allIds)) {
                @file_put_contents("assets/ordertemplate/quickRatesExcelData.txt", json_encode($allIds));
            }
            redirect('KNeTNQuickRates/index/05');
        }
    }


}
