<?php
defined('BASEPATH') or exit('No direct script access allowed');

use App\Generators\RandomString;

class Roadlogshipment extends CI_Controller
{
    private static $namespaces = [
        'eTN_ns1' => 'http://knie4.int.kn/com/ltypes/0200',
        'eTN_ns2' => 'http://knie4.int.kn/com/lhdr/0200',
        'eTN_ns3' => 'http://knie4.int.kn/com/ltru/0200',
        'eTN_ns4' => 'http://knie4.int.kn/com/lmlv/0200',
        'eTN_ns5' => 'http://knie4.int.kn/com/lsts/0200',
        'eTN_ns6' => 'http://knie4.int.kn/com/lref/0100',
        'eTN_ns7' => 'http://knie4.int.kn/com/lshpd/0200',
        'eTN_ns8' => 'http://knie4.int.kn/com/ladr/0200',
        'eTN_ns9' => 'http://knie4.int.kn/com/lcgod/0200',
        'eTN_ns10' => 'http://knie4.int.kn/com/ldim/0200',
        'eTN_ns11' => 'http://knie4.int.kn/com/lrdtl/0200',
        'eTN_ns12' => 'http://knie4.int.kn/com/lriroa/0200',
        'eTN_ns13' => 'http://knie4.int.kn/msg/roadshipment/0100',
        'eTN_ns14' => 'http://knie4.int.kn/com/ldgs/0200',
    ];

    private const CHECK_CARRIERS_WITH_COMPANY_CODE = ['IDKN','PHKN'];
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'DeliveryDocumentModel']);
        $this->load->model('shippeomodel');
        $this->load->library('Country_master_data_validator');
        $this->load->library("shippeostatusintigration");
        $this->load->library('Edi_logger');
        error_reporting(0);
        $this->load->helper('log');
    }

    public function index()
    {
        $response = [];
        $postData = file_get_contents('php://input');
        if (!empty($postData)) {
            // @TODO Use XSD to validate XML here
            $xml = new SimpleXMLElement($postData);
            if ($xml === false) {
                $statusMessage = "Invalid request,Please try again!";
            } else {
                self::mapXmlNamespaces($xml);

                $this->edi_logger->setEdi_request($postData);
                $shipmentData = $this->read_shipmentdata($xml);
                $currentTimezone = date_default_timezone_get();
                $currentDateTime = date('Y-m-d H:i:s');
                $getActual = getdatetimebytimezone(DFLT_TZ, $currentDateTime, $currentTimezone);
                $logDate = $getActual['datetime'];
                if (!empty($shipmentData)) {
                    $response = $this->insertShipmentData($shipmentData, $logDate);
                }
                if (!empty($response)) {
                    $shipmentId = $response[0];
                    $stopStatusId = $this->db->select("id")->get_where("tb_stop_status", array("shipment_id" => $shipmentId, "status_id" => 9), 1, 0);
                    if ($stopStatusId->num_rows() === 0) {

                        $stopStatusInsertData = [
                            "shipment_id" => $shipmentId,
                            "stop_id" => 0,
                            "stop_detail_id" => 0,
                            "stop_type" => "",
                            "trip_id" => 0,
                            "status_id" => 9,
                            "status_code" => "0100",
                            "status" => 1,
                            "reason" => "Coming from E-Booking",
                            "createdon" => $currentDateTime
                        ];
                        $this->db->insert("tb_stop_status", $stopStatusInsertData);

                        $orderId = $shipmentData['shipdata'][0]['orderid'] ?? "";
                        $senderTransportationMode = $shipmentData['shipdata'][0]['sendertransmode'] ?? "";
                        $companyCode = $shipmentData['shipdata'][0]['sendercmpcode'] ?? "";
                        $branchCode = $shipmentData['shipdata'][0]['senderbranchcode'] ?? "";
                        $pickUpCity = $shipmentData['shipdata'][0]['pickdrops'][0]['pickup_city'] ?? "";
                        $pickUpDateFromTime = $shipmentData['shipdata'][0]['pickdrops'][0]['pickup_datefromtime'] ?? "";
                        $pickUpReceiver = $shipmentData['header']['preceiver'] ?? "";
                        $lreceiver = $shipmentData['header']['lreceiver'] ?? ""; //TODO : What does l stand for?
                        $pickUpSender = $shipmentData['header']['psender'] ?? "";
                        $lsender = $shipmentData['header']['lsender'] ?? ""; //TODO : What does l stand for?
                        $shipmentid = $shipmentData['truck']['shipment_id'] ?? "";
                        $timezoneSuffix = "+05:30";

                        if ($pickUpDateFromTime !== "") {
                            $timezoneSuffix = substr($pickUpDateFromTime, -6);
                        }

                        $curtzs = gettimezonebygmtplusval($timezoneSuffix);
                        if ($orderId !== "") {
                            $postdata = [
                                "shipment_id" => $shipmentId,
                                "preceiver" => $pickUpReceiver,
                                "lreceiver" => $lreceiver,
                                "order_id" => $orderId,
                                "psender" => $pickUpSender,
                                "lsender" => $lsender,
                                "latitude" => '',
                                "longitude" => '',
                                "curtz" => $curtzs,
                                "shipmentid" => $shipmentid,
                                "modeoftransport" => $senderTransportationMode,
                                "pickup_city" => $pickUpCity,
                                "company_code" => $companyCode,
                                "branch_code" => $branchCode,
                                "hrs" => $timezoneSuffix,
                                "created_source" => "18"
                            ];

                            $stopStatusInsertData = [
                                "shipment_id" => $shipmentId,
                                "stop_id" => 0,
                                "stop_detail_id" => 0,
                                "stop_type" => "",
                                "trip_id" => 0,
                                "status_id" => 11,
                                "status_code" => "2400",
                                "status" => 1,
                                "reason" => "Planned Delivery Date",
                                "createdon" => $currentDateTime
                            ];

                            $this->db->insert("tb_stop_status", $stopStatusInsertData);
                            $this->load->library("statusintigration");
                            $this->statusintigration->roadlogshipbookedbysupplier($postdata);
                            $this->statusintigration->roadlogshipplandeliverdate($postdata);
                        }
                    }
                    $statusMessage = "Success";
                } else {
                    $statusMessage = "Failed for unformatted request,Please try again!";
                }
            }
        } else {
            $statusMessage = "Invalid request,Please try again!";
            $this->saveToEdiLog($statusMessage);
        }
        echo $statusMessage;
    }

    public function read_shipmentdata($xml)
    {
        self::mapXmlNamespaces($xml);

        $res = array();
        $references = array();
        $data = $xml->xpath('eTN_ns2:MessageHeader');
        $physicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->PhysicalReceiver);
        $logicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->LogicalReceiver);
        $physicalsender = (string)($data[0]->xpath('PhysicalSender')[0]);
        $logicalsender = (string)($data[0]->xpath('LogicalSender')[0]);
        $lreceiver = $preceiver = $psender = $lsender = $triptype = "";
        $loadcapacity = 0;
        $driver = $carrier = array();
        $preceiver = $physicalreceiver;
        $lreceiver = $logicalreceiver;
        $psender = $physicalsender;
        $lsender = $logicalsender;
        $sendapp = (string)($data[0]->xpath('SendingApplication')[0]);
        $msgtype = (string)($data[0]->xpath('MessageType')[0]);
        $version = (string)($data[0]->xpath('VersionNumber')[0]);
        $createdtime = (string)($data[0]->xpath('CreationDateTime')[0]);
        if ($createdtime != "") {
            $createdtime = date("Y-m-d H:i:s", strtotime($createdtime));
        } else {
            $createdtime = date("Y-m-d H:i:s");
        }
        $res['header'] = array("preceiver" => $preceiver, "lreceiver" => $lreceiver, "psender" => $psender, "lsender" => $lsender, "sendapp" => $sendapp, "msgtype" => $msgtype, "version" => $version, "createdtime" => $createdtime);
        /* truck and trailer info */
        $arr = array();
        $titledata = $xml->xpath('//eTN_ns3:TruckAndTrailer');
        if (isset($titledata)) {
            if (isset($titledata[0])) {
                $veh_number = isset($titledata[0]->xpath('TruckLicenseNumber')[0]) ? $titledata[0]->xpath('TruckLicenseNumber')[0] : "";
                $arr['veh_number'] = (string)($veh_number);
                $veh_type = isset($titledata[0]->xpath('VehicleType')[0]) ? $titledata[0]->xpath('VehicleType')[0] : "";
                $arr['veh_type'] = (string)($veh_type);
                $arr['trailer'] = "";
                if (null !== $titledata[0]->xpath('Trailer')) {
                    if (!empty($titledata[0]->xpath('Trailer'))) {
                        $Trailer = isset($titledata[0]->xpath('Trailer')[0]->Number[0]) ? (string)($titledata[0]->xpath('Trailer')[0]->Number[0]) : "";
                        if ($Trailer != "") {
                            $arr['trailer'] = $Trailer;
                        }
                    }
                }
                // $arr['ordernum'] = (string)($titledata[0]->xpath('VoyageNumber')[0]);
                // $arr['shipment_id'] = (string)($titledata[0]->xpath('TourNumber')[0]);

                $voyage_number = (string)($titledata[0]->xpath('VoyageNumber')[0]);
                $arr['ordernum'] = $voyage_number;
                $shipment_id = (string)($titledata[0]->xpath('TourNumber')[0]);
                $this->edi_logger->setTxn_obj_id($shipment_id);
                $arr['shipment_id'] = $shipment_id;

                $arr['origin'] = '';
                // (string)($titledata[0]->xpath('Origin')[0]->Location[0]);
                $arr['originloc2'] = (string)($titledata[0]->xpath('Origin')[0]->Location[1]);

                $arr['origindate'] = (string)($titledata[0]->xpath('Origin')[0]->Date);
                $arr['noofshipments'] = (string)($titledata[0]->xpath('NumberOfShipments')[0]);
                $address = $triptype = $loadcapacity = "";
                if (null !== $titledata[0]->xpath('Address')) {
                    if (!empty($titledata[0]->xpath('Address'))) {
                        $address = (string) $titledata[0]->xpath('Address')[0]->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->AddressType;

                        if ($address == "CA") {
                            $carrier['name'] = (string)($titledata[0]->xpath('Address')[0]->Name);
                            $carrier['street'] = (string)($titledata[0]->xpath('Address')[0]->Street[0]);
                            $carrier['street1'] = (string)($titledata[0]->xpath('Address')[0]->Street[1]);
                            $carrier['city'] = (string)($titledata[0]->xpath('Address')[0]->City);
                            $carrier['country'] = $this->country_master_data_validator->validate_country((string)($titledata[0]->xpath('Address')[0]->CountryCode));
                            $carrier['zip'] = (string)($titledata[0]->xpath('Address')[0]->ZipCode);
                            $carrier['custid'] = (string)($titledata[0]->xpath('Address')[0]->CustomerIdentifier);
                            $carrier['partyid'] = (string)($titledata[0]->xpath('Address')[0]->PartyIdentifier);
                            $partiesAddress = (array)$titledata[0]->xpath('Address')[0];
                            $driver['contacttype'] = $driver['firstname'] = $driver['lastname'] = $driver['lastname'] = $driver['driver_mobile_no'] = '';
                            if (isset($partiesAddress['ContactDetails']->ContactType)) {
                                if ($partiesAddress['ContactDetails']->ContactType == 'Driver') {
                                    $driver['contacttype'] = $partiesAddress['ContactDetails']->ContactType;
                                    $driver['lastname'] = $partiesAddress['ContactDetails']->LastName;
                                    $driver['firstname'] = $partiesAddress['ContactDetails']->FirstName;
                                    $driver['commtype'] = $partiesAddress['ContactDetails']->Communication;
                                }
                            } else {
                                $contactDetail = current(
                                    array_filter($partiesAddress['ContactDetails'] ?? [], function ($contactDetail) {
                                        $contactDetail = (array)$contactDetail;
                                        return 'Driver' === $contactDetail['ContactType'];
                                    })
                                );
                                if (false !== $contactDetail) {
                                    $contactDetail = (array) $contactDetail;
                                    $driver['contacttype'] = $contactDetail['ContactType'];
                                    $driver['lastname'] = $contactDetail['LastName'];
                                    $driver['firstname'] = $contactDetail['FirstName'];
                                    $driver['commtype'] = $contactDetail['Communication'];
                                }
                            }
                            $driver['commtypename'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication);
                            if (!empty($titledata[0]->xpath('DriverID'))) {
                                $driver['driverid'] = (string)($titledata[0]->xpath('DriverID')[0]);
                            }
                            if(isset($titledata[0]->xpath('Address')[0]->ContactDetails[0]->Communication)){
                                $communicationType = $titledata[0]->xpath('Address')[0]->ContactDetails[0]->Communication->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->CommunicationType;
                                if ($communicationType == "TE") {
                                    $driver['driver_mobile_no'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[0]->Communication);
                                }
                            }
                        }
                    }
                }
                if (null !== $titledata[0]->xpath('TripType')) {
                    if (!empty($titledata[0]->xpath('TripType'))) {
                        $triptype = (string)($titledata[0]->xpath('TripType')[0]);
                    }
                }
                if (null !== $titledata[0]->xpath('Text ')) {
                    if (!empty($titledata[0]->xpath('Text '))) {
                        $text = (string)($titledata[0]->xpath('Text ')[0]);
                    }
                }
                if (null !== $titledata[0]->xpath('LoadingCapacity')) {
                    if (!empty($titledata[0]->xpath('LoadingCapacity'))) {
                        $loadcapacity = (string)($titledata[0]->xpath('LoadingCapacity')[0]);
                    }
                }

                if (null !== $titledata[0]->xpath('Text')[0] && $titledata[0]->xpath('Text')[0] != '') {
                    $trip_notes0 = $titledata[0]->xpath('Text')[0];
                    if (isset($trip_notes0) && $trip_notes0->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->TextType == "HAN") {
                        $transport_condition_trip_note = (string)$trip_notes0;
                        // transport condition TRIP_NOTE
                        $references[] = array('code' => 'TRANS_COND_TRIP_NOTE', 'value' => $transport_condition_trip_note, 'ref_belongs_to' => "TRANS_COND_TRIP_NOTE");
                    }
                }

            }
        }

        $res['carrier'] = $carrier;
        $res['driver'] = $driver;
        $arr['triptype'] = $triptype;
        $arr['text'] = $text;
        $arr['loadcapacity'] = $loadcapacity;
        $res['truck'] = $arr;
        $res['shipdata'] = array();
        $mdata = $xml->xpath('//eTN_ns13:RoadShipment');
        $shinfo = $mdata[0]->xpath('Message')[0]->Shipment;
        foreach ($shinfo as $key => $cships) {
            $res['shipdata'][] = $this->generateshipmentdata($cships, $key, $references, $voyage_number, $shipment_id);
        }
        return $res;
    }

    function generateshipmentdata($xml, $key, $references, $voyage_number = '', $shipment_id = '')
    {
        self::mapXmlNamespaces($xml);

        $arr['references'] = $references;
        $arr['MonetaryAmount'] = '';
        // $arr['CurrencyCode'] = '';
        $titledata = $xml->xpath('eTN_ns4:MessageLevel');
        $arr['orderid'] = (string)($titledata[0]->xpath('TrackingNumber')[0]);
        $arr['voyage_number'] = $voyage_number;
        $arr['shipment_id'] = $shipment_id;
        if (null !== $titledata[0]->xpath('TrackingNumber')) {
            $arr['orderid'] = isset($titledata[0]->xpath('TrackingNumber')[0]) ? (string)($titledata[0]->xpath('TrackingNumber')[0]) : "";
            $arr['references'][] = array('code' => 'DQ', 'value' => $voyage_number, 'ref_belongs_to' => "DELIVERY NOTE");
            $arr['references'][] = array('code' => 'TRACKING_NUMBER', 'value' => $arr['orderid'], 'ref_belongs_to' => "ORDER TRACKING NUMBER");
            $arr['references'][] = array('code' => 'VOYAGE_NUMBER', 'value' => $voyage_number, 'ref_belongs_to' => "VOYAGE NUMBER");
        }


        $arr['sendercmpcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->CompanyCode);
        $arr['senderbranchcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->BranchCode);
        $arr['sendertransmode'] = 1;
        if (null !== (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport)) {
            $arr['sendertransmode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport);
        }
        $arr['senderflag'] = $arr['refcode'] = $arr['refvalue'] = "";
        if (null !== (string)($titledata[0]->xpath('SenderInformation')[0]->ExportImportFlag)) {
            $arr['senderflag'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ExportImportFlag);
        }
        /*$arr['references'] = array();
	    if(null !== $titledata[0]->xpath('MessageReferences')){
	    	if(!empty($titledata[0]->xpath('MessageReferences'))){
		    	$arr['refcode'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Code);
	        	$arr['refvalue'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Value);
	        	$arr['references'][] = array('code'=>$arr['refcode'],'value'=>$arr['refvalue']);
	        }
	    }*/
        // $arr['references'] = array();
        if (null !== $titledata[0]->xpath('MessageReferences')) {
            if (!empty($titledata[0]->xpath('MessageReferences'))) {
                foreach ($titledata[0]->xpath('MessageReferences') as $ordref) {
                    $arr['refcode'] = (string)($ordref->Code);
                    $arr['refvalue'] = (string)($ordref->Value);
                    if ($arr['refcode'] == "INN") {
                        $arr['leg_no'] = $arr['refvalue'];
                        $arr['references'][] = array('code' => $arr['refcode'], 'value' => $arr['refvalue'], 'ref_belongs_to' => "KN OFFICE");
                    } else {
                        $arr['references'][] = array('code' => $arr['refcode'], 'value' => $arr['refvalue']);
                    }
                }
            }
        }

        $arr['references'][] = array('code' => 'CUST_D_Q_NUMBER', 'value' => $arr['voyage_number'] . '_' . $arr['shipment_id'] . '_' . $arr['orderid'] . '_' . $arr['leg_no'], 'ref_belongs_to' => "ORDER REF");

        $infodata = $xml->ShipmentInformation;

        self::mapXmlNamespaces($infodata);

        $details = $infodata->xpath('eTN_ns7:ShipmentDetails');
        $arr['packages'] = 1;
        $arr['MonetaryAmount'] = 0;
        $arr['measurements'] = array();
        $arr['dangerousflag'] = $arr['totaldangerousflag'] = $arr['source'] = $arr['sourcedate'] = $arr['destination'] = $arr['destinationdate'] = $arr['slocationcountry'] = $arr['dlocationcountry'] = $arr['incoterm'] = "";
        if (!empty($details)) {
            if (null !== $details[0]->xpath('TotalPackages')) {
                if (!empty($details[0]->xpath('TotalPackages'))) {
                    $arr['packages'] = (string)($details[0]->xpath('TotalPackages')[0]);
                }
            }
            if (null !== $details[0]->xpath('Measurements')) {
                if (!empty($details[0]->xpath('Measurements'))) {
                    foreach ($details[0]->xpath('Measurements') as $mm) {
                        $arr['measurements'][] = array('mtype' => (string)$mm->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->MeasurementType, 'value' => (string)$mm->Value, 'uom' => (string)$mm->UnitOfMeasurementCode);
                    }
                }
            }

            /*
             *  Newly Added Segment.
             */
            if (null !== $details[0]->xpath('BusinessSolution')) {
                if (!empty($details[0]->xpath('BusinessSolution'))) {
                    $arr['references'][] = array("code" => (string)$details[0]->xpath('BusinessSolution')[0]->Code, "value" => (string)$details[0]->xpath('BusinessSolution')[0]->CategoryCode, 'ref_belongs_to' => "BUSINESS SOLUTIONS");
                }
            }

            if (null !== $details[0]->xpath('DangerousGoodsFlag')) {
                if (!empty($details[0]->xpath('DangerousGoodsFlag'))) {
                    $arr['dangerousflag'] = (string)($details[0]->xpath('DangerousGoodsFlag')[0]);
                }
            }
            if (null !== $details[0]->xpath('TotalPackagesOfDangerousGoods')) {
                if (!empty($details[0]->xpath('TotalPackagesOfDangerousGoods'))) {
                    $arr['totaldangerousflag'] = (string)($details[0]->xpath('TotalPackagesOfDangerousGoods')[0]);
                }
            }
            if (null !== $details[0]->xpath('TermsOfTrade')) {
                if (!empty($details[0]->xpath('TermsOfTrade'))) {
                    $arr['incoterm'] = (string)($details[0]->xpath('TermsOfTrade')[0]->Incoterm);
                }
            }
            if (null !== $details[0]->xpath('Origin')) {
                if (!empty($details[0]->xpath('Origin'))) {
                    $arr['source'] = (string)($details[0]->xpath('Origin')[0]->OriginLocation);
                    $arr['sourcedate'] = (string)($details[0]->xpath('Origin')[0]->Date);
                }
            }
            if (null !== $details[0]->xpath('Destination')) {
                if (!empty($details[0]->xpath('Destination'))) {
                    $arr['destination'] = (string)($details[0]->xpath('Destination')[0]->DestinationLocation);
                    $arr['destinationdate'] = (string)($details[0]->xpath('Destination')[0]->Date);
                }
            }

            if (isset($details[0]->xpath('MonetaryAmount')[0]) && null !== $details[0]->xpath('MonetaryAmount')[0]) {
                $arr['MonetaryAmount'] = (string)($details[0]->xpath('MonetaryAmount')[0]->Value);
                $arr['CurrencyCode'] = (string)($details[0]->xpath('MonetaryAmount')[0]->CurrencyCode);
            }
            

            if (null !== $details[0]->xpath('Location')) {
                $arr['slocationcountry'] = (string)($details[0]->xpath('Location')[0]);
                $arr['dlocationcountry'] = (string)($details[0]->xpath('Location')[1]);
            }
        }
        $shipper = $consignee = $pf = array();
        foreach ($infodata->xpath('eTN_ns8:NameAddress') as $addr) {
            // @TODO Replace all these `if` by a `swtich… case…`
            //
            if ($addr->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->AddressType == "SH") {
                $shipper = array('name' => (string)($addr->xpath('Name')[0]), 'street' => (string)($addr->xpath('Street')[0]), 'city' => (string)($addr->xpath('City')[0]), 'country' => $this->country_master_data_validator->validate_country((string)($addr->xpath('CountryCode')[0])), 'zip' => (string)($addr->xpath('ZipCode')[0]), 'custid' => (string)($addr->xpath('CustomerIdentifier')[0]), 'partyid' => (string)($addr->xpath('PartyIdentifier')[0]));
                if (null !== $addr->xpath('References')) {
                    if (!empty($addr->xpath('References'))) {
                        foreach ($addr->xpath('References') as $cref) {
                            $arr['references'][] = array('code' => (string)$cref->Code, 'value' => (string)$cref->Value, 'ref_belongs_to' => "SHIPPER");
                        }
                    }
                }
            }
            if ($addr->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->AddressType == "CN") {
                $consignee = array('name' => (string)($addr->xpath('Name')[0]), 'street' => (string)($addr->xpath('Street')[0]), 'city' => (string)($addr->xpath('City')[0]), 'country' => $this->country_master_data_validator->validate_country((string)($addr->xpath('CountryCode')[0])), 'zip' => (string)($addr->xpath('ZipCode')[0]), 'custid' => (string)($addr->xpath('CustomerIdentifier')[0]), 'partyid' => (string)($addr->xpath('PartyIdentifier')[0]));
                if (null !== $addr->xpath('References')) {
                    if (!empty($addr->xpath('References'))) {
                        foreach ($addr->xpath('References') as $cref) {
                            $arr['references'][] = array('code' => (string)$cref->Code, 'value' => (string)$cref->Value);
                        }
                    }
                }
            }
            if ($addr->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->AddressType == "PF") {
                $custid = $partyid = "";
                if (null !== $addr->xpath('CustomerIdentifier')) {
                    if (!empty($addr->xpath('CustomerIdentifier'))) {
                        $custid = (string)($addr->xpath('CustomerIdentifier')[0]);
                    }
                }
                if (null !== $addr->xpath('PartyIdentifier')) {
                    if (!empty($addr->xpath('PartyIdentifier'))) {
                        $partyid = (string)($addr->xpath('PartyIdentifier')[0]);
                    }
                }
                $pf = array('name' => (string)($addr->xpath('Name')[0]), 'street' => (string)($addr->xpath('Street')[0]), 'city' => (string)($addr->xpath('City')[0]), 'country' => $this->country_master_data_validator->validate_country((string)($addr->xpath('CountryCode')[0])), 'zip' => (string)($addr->xpath('ZipCode')[0]), 'custid' => $custid, 'partyid' => $partyid);
                /*
                 *  Freight Payer References.
                 */

                $references = $addr->xpath('References');

                if (null !== $references) {
                    foreach ($references as $cref) {
                        $arr['references'][] = array('code' => (string)$cref->Code, 'value' => (string)$cref->Value, 'ref_belongs_to' => 'FREIGHT PAYER');
                    }
                }
            }
        }
        $arr['items_count'] = $arr['pkgs_count'] = 1;
        $arr['pkgs_uom'] = 'PCS';
        $arr['gross_weight'] = $arr['volume'] = $arr['ldm'] = 1;
        $arr['weight_uom'] = 'KGM';
        $arr['volume_uom'] = 'MTQ';
        $arr['ldm_uom'] = 'MTR';
        $arr['cargo_content'] = 'Boxes';
        if (null !== $infodata[0]->xpath('CargoDescription')) {
            if (!empty($infodata[0]->xpath('CargoDescription'))) {
                /* CargoDescription */
                $cargo_index = 0;
                $arr['cargodetails'] = [];
                $epf_cargo_details = $infodata[0]->xpath('CargoDescription');
                    foreach ($epf_cargo_details as $cargoDetail) {
                        self::mapXmlNamespaces($cargoDetail);
                        $cargodetails = $cargoDetail->xpath('eTN_ns9:CargoDescriptionDetails');
                        $cargoArray = array();
                        if (null !== $cargoDetail[$cargo_index]->xpath('eTN_ns9:CargoDescriptionDetails')) {
                            $cargoArray['items_count'] = (string)($cargodetails[0]->xpath('CargoItem')[0]);
                            $cargoArray['pkgs_count'] = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->Value);
                            $cargoArray['pkgs_uom'] = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->QuantityType);
                            $cargoArray['gross_weight'] = (string)($cargodetails[0]->xpath('GrossWeight')[0]->Value);
                            $cargoArray['weight_uom'] = (string)($cargodetails[0]->xpath('GrossWeight')[0]->UnitOfMeasurementCode);
                            $cargoArray['volume'] = (string)($cargodetails[0]->xpath('Volume')[0]->Value);
                            $cargoArray['volume_uom'] = (string)($cargodetails[0]->xpath('Volume')[0]->UnitOfMeasurementCode);
                            $cargoArray['cargo_content'] = (string)($cargodetails[0]->xpath('CargoContent')[0]);
                            $RoadInformation = $cargodetails[0]->xpath('RoadInformation');
                            $cargoArray['ldm'] = (string)($RoadInformation[0]->xpath('LoadingMeters')[0]->Value);
                            $cargoArray['ldm_uom'] = (string)($RoadInformation[0]->xpath('LoadingMeters')[0]->UnitOfMeasurementCode);
                            $cargoArray['StackableFlag'] = (string)($RoadInformation[0]->xpath('StackableFlag')[0]);
                            $efp_packages_count = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->Value);
                            $efp_package_uom = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->QuantityType);
                            $arr['references'][] = array('code' => $efp_package_uom, 'value' => $efp_packages_count, 'ref_belongs_to' => "EFP");
                            $arr['cargodetails'][$cargo_index]['cargo'] = $cargoArray;
                        }
                        $dimensions = $cargoDetail->xpath('eTN_ns10:Dimensions');
                        $dimensionResults = [];
                        if (null !== $cargoDetail[0]->xpath('eTN_ns10:Dimensions')) {
                            $dimensionResults['no_of_pkgs_value'] = (string)($dimensions[0]->xpath('NumberOfPackages')[0]->Value);
                            $dimensionResults['no_of_pkgs_quantity'] = (string)($dimensions[0]->xpath('NumberOfPackages')[0]->QuantityType);
                            if (null !== $dimensions[0]->xpath('Measurements')) {
                                if (!empty($dimensions[0]->xpath('Measurements'))) {
                                    foreach ($dimensions[0]->xpath('Measurements') as $dm) {
                                        // @TODO Replace all these `if` by a `switch… case…`

                                        if ($dm->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->MeasurementType == "LN") {
                                            $dimensionResults['dimensionslength'] = [
                                                'length' => (string)$dm->Value,
                                                'length_uom' => (string)$dm->UnitOfMeasurementCode
                                            ];
                                        }
                                        if ($dm->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->MeasurementType == "WD") {
                                            $dimensionResults['dimensionswidth'] = [
                                                'width' => (string)$dm->Value,
                                                'width_uom' => (string)$dm->UnitOfMeasurementCode
                                            ];
                                        }
                                        if ($dm->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->MeasurementType == "HT") {
                                            $dimensionResults['dimensionsheight'] = [
                                                'height' => (string)$dm->Value,
                                                'height_uom' => (string)$dm->UnitOfMeasurementCode
                                            ];
                                        }
                                    }
                                }
                            }
                            $arr['cargodetails'][$cargo_index]['dimensions'] = $dimensionResults;
                        }




                        /* dangerousgoods */
                        $dangerousgoodsRow =[];
                        if (null !== $cargoDetail->xpath('eTN_ns14:DangerousGoods')) {
                            $dg_goods_list = $cargoDetail->xpath('eTN_ns14:DangerousGoods');
                            foreach ($dg_goods_list as $dg_goods) {
                                foreach ($dg_goods->xpath('DangerousGoodsPosition') as $dggoods){
                                    $dgarr['db_numpkgs'] = (string)($dggoods->xpath('NumberOfPackages')[0]->Value);
                                    $dgarr['db_pkgqtytype'] = (string)($dggoods->xpath('NumberOfPackages')[0]->QuantityType);
                                    $dgdetails = $dggoods->xpath('DangerousGoodsDetails');
                                    $dgarr['dg_qty'] = (string)($dgdetails[0]->xpath('DangerousGoodsQuantity')[0]->Value);
                                    $dgarr['dg_qtytype'] = (string)($dgdetails[0]->xpath('DangerousGoodsQuantity')[0]->QuantityType);
                                    $dgarr['dg_orgnum'] = (string)($dgdetails[0]->xpath('UnitedNationsOrganisationNumber')[0]->Value);
                                    $dgarr['dg_orgnumvar'] = (string)($dgdetails[0]->xpath('UnitedNationsOrganisationNumber')[0]->Variant);
                                    $dgarr['dg_class'] = (string)($dgdetails[0]->Class);
                                    $dgarr['dg_mainrisk'] = (string)($dgdetails[0]->MainRisk);
                                    $dgarr['subsidiary_risks'] = (string)($dgdetails[0]->SubsidiaryRisks);
                                    $dgarr['packing_group'] = (string)($dgdetails[0]->PackingGroup);
                                    $dgarr['dg_desc'] = (string)($dgdetails[0]->xpath('DangerousGoodsDescriptions')[0]->ProperShippingName);
                                    $dgarr['dg_limitqtyflag'] = (string)($dgdetails[0]->LimitedQuantityFlag);
                                    $dgarr['dg_exceptqtyflag'] = (string)($dgdetails[0]->ExceptedQuantityFlag);
                                    $dgarr['tunnel_restriction_code'] = (string)($dgdetails[0]->xpath('Roadfreight')[0]->TunnelRestrictionCode);
                                    $dgarr['transport_category'] = (string)($dgdetails[0]->xpath('Roadfreight')[0]->TransportCategory);
                                    $dgarr['environment_hazardous'] = (string)($dgdetails[0]->xpath('Roadfreight')[0]->EnvironmentallyHazardous);
                                    $dgarr['nos'] = (string)($dgdetails[0]->xpath('Roadfreight')[0]->NOS);
                                    $dgarr['adr_multiplicator'] = (string)($dgdetails[0]->xpath('Roadfreight')[0]->ADRMultiplicator);
                                    $dgarr['total_adr_points'] = (string)($dgdetails[0]->xpath('Roadfreight')[0]->TotalADRPoints);
                                    $dgarr['adr_version'] = (string)($dgdetails[0]->xpath('Roadfreight')[0]->ADRVersion);
                                    $dangerousgoodsRow[] = $dgarr;
                                }
                            }
                        }
                        $arr['cargodetails'][$cargo_index]['dangerousgoods'] = $dangerousgoodsRow;
                        $cargo_index++;
                    }
            }
        }
        $arr['shipper'] = $shipper;
        $arr['consignee'] = $consignee;
        $arr['pf'] = $pf;
        $infodata1 = $xml->ShipmentRoad;

        self::mapXmlNamespaces($infodata1);

        $roaddetail = $infodata1->xpath('eTN_ns11:RoadDetails');

        $arr['serviceproduct'] = $arr['servicetype'] = $arr['freight_term'] = $arr['freight_termname'] = "";
        if (null !== $roaddetail[0]->xpath('Product')) {
            if (!empty($roaddetail[0]->xpath('Product'))) {
                $arr['serviceproduct'] = (string)($roaddetail[0]->xpath('Product')[0]);
            }
        }
        if (null !== $roaddetail[0]->xpath('ServiceType')) {
            if (!empty($roaddetail[0]->xpath('ServiceType'))) {
                $arr['servicetype'] = (string)($roaddetail[0]->xpath('ServiceType')[0]);
            }
        }
        if (null !== $roaddetail[0]->xpath('FreightName')) {
            if (!empty($roaddetail[0]->xpath('FreightName'))) {
                $arr['freight_term'] = (string)($roaddetail[0]->xpath('FreightName')[0]->Term);
            }
        }
        if (null !== $roaddetail[0]->xpath('FreightName')) {
            if (!empty($roaddetail[0]->xpath('FreightName'))) {
                $arr['freight_termname'] = (string)($roaddetail[0]->xpath('FreightName')[0]->Name);
            }
        }
        $pickdrop = array();
        $p = $d = 0;
        $waypoints = $infodata1->TruckingWayPoint;
        foreach ($waypoints as $sd) {
            self::mapXmlNamespaces($sd);

            // @TODO Replace all these `if` by a  `switch… case…`

            if ($sd->attributes(self::getNamespaceFromPrefix('eTN_ns13'))->WayPointType == "PUP") {
                $point = $sd->xpath('eTN_ns8:NameAddress');
                $arr1 = array();
                $arr1['pickup_company'] = (string)($point[0]->xpath('Name')[0]);
                $street1 = isset($point[0]->xpath('Street')[0]) ? $point[0]->xpath('Street')[0] : "";
                $arr1['pickup_address'] = (string)($street1);
                $street2 = isset($point[0]->xpath('Street')[1]) ? $point[0]->xpath('Street')[1] : "";
                $arr1['pickup_address1'] = (string)($street2);
                $arr1['pickup_city'] = (string)($point[0]->xpath('City')[0]);
                $arr1['pickup_countrycode'] = $this->country_master_data_validator->validate_country((string)($point[0]->xpath('CountryCode')[0]));
                $arr1['pickup_postal'] = (string)($point[0]->xpath('ZipCode')[0]);
                $arr1['pickup_custid'] = (string)($point[0]->xpath('CustomerIdentifier')[0]);
                $arr1['pickup_partyid'] = (string)($point[0]->xpath('PartyIdentifier')[0]);
                $arr1['pickup_datefrom'] = (string)$sd->DateRange->DateFrom;
                $arr1['pickup_datefromtime'] = (string)$sd->DateRange->TimeFrom;
                $arr1['pickup_dateto'] = (string)$sd->DateRange->DateTo;
                $arr1['pickup_datetotime'] = (string)$sd->DateRange->TimeTo;
                $arr1['sequence'] = (string)$sd->Sequence;
                $pickuinst = isset($sd->AdditionalTextInformation) ? (string)$sd->AdditionalTextInformation : "";//added by mahendra
                $arr['references'][] = array('code' => 'ORD_PIKINST', 'value' => $pickuinst, 'ref_belongs_to' => 'ADDITIONAL PICKUP INFO');
                $arr1['stoptype'] = 'P';
                $arr1['stop_type'] = (string) $point[0]->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->AddressType;
                $p++;
                $pickdrop[] = $arr1;
            }
            if ($sd->attributes(self::getNamespaceFromPrefix('eTN_ns13'))->WayPointType == "DEL") {
                $point = $sd->xpath('eTN_ns8:NameAddress');
                $arr2 = array();
                $arr2['drop_company'] = (string)($point[0]->xpath('Name')[0]);
                $street1 = isset($point[0]->xpath('Street')[0]) ? $point[0]->xpath('Street')[0] : "";
                $arr2['drop_address'] = (string)($street1);
                $street2 = isset($point[0]->xpath('Street')[1]) ? $point[0]->xpath('Street')[1] : "";
                $arr2['drop_address1'] = (string)($street2);
                $arr2['drop_city'] = (string)($point[0]->xpath('City')[0]);
                $arr2['drop_countrycode'] = $this->country_master_data_validator->validate_country((string)($point[0]->xpath('CountryCode')[0]));
                $arr2['drop_postal'] = (string)($point[0]->xpath('ZipCode')[0]);
                $arr2['drop_custid'] = (string)($point[0]->xpath('CustomerIdentifier')[0]);
                $arr2['drop_partyid'] = (string)($point[0]->xpath('PartyIdentifier')[0]);
                $arr2['drop_datefrom'] = (string)$sd->DateRange->DateFrom;
                $arr2['drop_datefromtime'] = (string)$sd->DateRange->TimeFrom;
                $arr2['drop_dateto'] = (string)$sd->DateRange->DateTo;
                $arr2['drop_datetotime'] = (string)$sd->DateRange->TimeTo;
                $arr2['sequence'] = (string)$sd->Sequence;
                $delivinst = isset($sd->AdditionalTextInformation) ? (string)$sd->AdditionalTextInformation : "";
                $arr['references'][] = array('code' => "ORD_DLVINST", 'value' => $delivinst, 'ref_belongs_to' => 'ADDITIONAL DELIVERY INFO');
                $arr2['stoptype'] = 'D';
                $arr2['stop_type'] = (string)($point[0]->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->AddressType);
                $d++;
                $pickdrop[] = $arr2;
            }
        }
        $arr['pickdrops'] = $pickdrop;
        $arr['pickcount'] = $p;
        $arr['dropcount'] = $d;
        $bdetail = $infodata1->xpath('eTN_ns12:ReportingInformationRailroad');
        $arr['typeofbusiness'] = (string)($bdetail[0]->xpath('TypeOfBusiness')[0]);
        return $arr;
    }

    public function insertShipmentData($data, $logdate)
    {
        $curtz = date_default_timezone_get();
        $curdt = $logdate;
        $responseord = array();
        $transmode = "TL";
        $dedicateveh = 1;
        $user_id = 1;
        $shippmentupdateflag =0;
        foreach ($data['shipdata'] as $shipdata) {
            $ttansmode = $shipdata['servicetype'];
            $transportModeQry = $this->common->gettblrowdata(['name'=>$ttansmode,'status'=>1],'code','tb_transportmode', 0,0);
            $transmode = $transportModeQry ? $transportModeQry['code'] : 'FTL';
            if ($ttansmode != "Full Truck Load") {
                $transmode = "LTL";
                $dedicateveh = 0;
            }
            if (strlen($data['header']['lsender']) > 2) {
                $firsttwochars = substr($data['header']['lsender'], 0, 2);
            } else {
                $firsttwochars = $data['header']['lsender'];
            }
            $company_code = $shipdata['sendercmpcode'];
            $branch_code = $shipdata['senderbranchcode'];
            $chk = $this->db->query("SELECT id FROM tb_users WHERE company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' AND status='Active' LIMIT 1");
            if ($chk->num_rows() > 0) {
                $user_id = $chk->row()->id;
            } else {
                $chk01 = $this->db->query("SELECT user_id FROM tb_user_companies WHERE company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' AND status=1 LIMIT 1");
                if ($chk01->num_rows() > 0) {
                    $user_id = $chk01->row()->user_id;
                } else {
                    $adminrand = time();
                    $adminpwd = password_hash($adminrand, PASSWORD_DEFAULT);
                    $udata = array('country_code' => $firsttwochars, 'name' => $firsttwochars . "_Admin", 'company_indv_name' => $company_code, 'business_type' => 'Truck_Owner', 'mobile_no' => $adminrand, 'password' => $adminpwd, 'emailid' => 'svkonekt@kuehne-nagel.com', 'domain_name' => $branch_code, 'location_id' => 1646, 'createdby' => 1, 'status' => 'Active', 'createdon' => $curdt, 'company_code' => $company_code, 'branch_code' => $branch_code);
                    $user_id = $this->common->insertTableData('tb_users', $udata);
                }
            }
            $this->edi_logger->setUser_id($user_id);
            if (!empty($data['carrier'])) {
                if (!isset($data['carrier']['custid'])) {
                    $getcar = $this->db->select("name,mobile,location,address,pincode,country,code,custid,partyid")->get_where("tb_vendors", array("user_id" => $user_id, "company_code" => $shipdata['sendercmpcode'], "branch_code" => $shipdata['senderbranchcode'], "status" => 1), 1, 0);
                    if ($getcar->num_rows() > 0) {
                        $cardata = $getcar->row();
                        $data['carrier'] = array('name' => $cardata->name, 'street' => $cardata->address, 'street1' => '', 'city' => $cardata->location, 'country' => $cardata->country, 'zip' => $cardata->pincode, 'custid' => $cardata->custid, 'partyid' => $cardata->partyid);
                    } else {
                        if (in_array($shipdata['sendercmpcode'],self::CHECK_CARRIERS_WITH_COMPANY_CODE)) {
                            $checkVendor = $this->common->gettblrowdata(['company_code' => $shipdata['sendercmpcode'], 'status' => '1'], "name,mobile,location,address,pincode,country,code,custid,partyid", "tb_vendors", 0, 0);
                            if (!empty($checkVendor)) {
                                $data['carrier'] = ['name' => $checkVendor['name'], 'street' => $checkVendor['address'], 'street1' => '', 'city' => $checkVendor['location'], 'country' => $checkVendor['country'], 'zip' => $checkVendor['pincode'], 'custid' => $checkVendor['custid'], 'partyid' => $checkVendor['partyid']];
                            }
                        }
                    }
                }
            }
            $ca_partytype = 2;
            $drivercity = isset($data['carrier']['city']) ? $data['carrier']['city'] : '';//added by mahendra
            $carrier = $this->checkcarrier($data['carrier'], $shipdata['sendercmpcode'], $shipdata['senderbranchcode'], $user_id);
            $carrier_id = $carrier['id'];
            if (isset($carrier['party_id'])) {
                $carrier_party_id = $carrier['party_id'];
                $ca_partytype = $carrier['party_type'];
            }
            if (!isset($data['truck']['shipment_id'])) {
                $data['truck']['shipment_id'] = mt_rand();
            }
            if (!isset($data['truck']['ordernum'])) {
                $data['truck']['ordernum'] = mt_rand();
            }
            $getactual = getdatetimebytimezone(DFLT_TZ, $shipdata['sourcedate'], $curtz);
            $shipdata['sourcedate'] = $getactual['datetime'];
            $getactual = getdatetimebytimezone(DFLT_TZ, $shipdata['destinationdate'], $curtz);
            $shipdata['destinationdate'] = $getactual['datetime'];

            $where_tb_shipments = array('shipid' => $data['truck']['shipment_id'], 'txnid' => $data['truck']['ordernum'], 'status' => 1);
            $chktb_shipments = $this->common->gettblrowdata($where_tb_shipments, "id", "tb_shipments", 0, 0);
            if (count($chktb_shipments) == 0) {
                $shipdatains = array('shipid' => $data['truck']['shipment_id'], 'txnid' => $data['truck']['ordernum'], 'trucktype' => $ttansmode, 'product' => $shipdata['serviceproduct'], 'pickupcnt' => $shipdata['pickcount'], 'dropcnt' => $shipdata['dropcount'], 'unitspec' => $shipdata['cargo_content'], 'insertusr' => $shipdata['shipper']['custid'], 'carrier' => $carrier_id, 'insertuserdate' => $shipdata['sourcedate'], 'enddate' => $shipdata['destinationdate'], 'insdate' => $shipdata['sourcedate'], 'upddate' => $shipdata['destinationdate'], 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $logdate, 'status' => 1, 'createdon' => $curdt, 'transport_mode' => $transmode, 'txncode' => $shipdata['orderid'], 'domainname' => $data['header']['lsender'], 'company_code' => $shipdata['sendercmpcode'], 'branch_code' => $shipdata['senderbranchcode'], 'freight_term' => $shipdata['freight_term'], 'freight_termname' => $shipdata['freight_termname'], 'incoterm' => $shipdata['incoterm'], 'logicalreceiver' => $data['header']['lreceiver'], 'physicalreceiver' => $data['header']['preceiver'], 'physicalsender' => $data['header']['psender'], 'logicalsender' => $data['header']['lsender'], 'modeoftransport' => $shipdata['sendertransmode'], "source" => $data['truck']['origin'], "destination" => $data['truck']['originloc2']);
                $sship_id = $this->common->insertTableData('tb_shipments', $shipdatains);
            } else {
                // update tb_shipments
                $sship_id = $chktb_shipments['id'];
                $shipdatains = array("id" => $sship_id, "source" => $data['truck']['origin'], "destination" => $data['truck']['originloc2']);
                $upd = $this->common->updatetbledata("tb_shipments", $shipdatains, array('id' => $sship_id));
            }

            $pickup_datetime = $pickup_endtime = $delivery_datetime = $drop_endtime = $pickup_company = "";
            $starttime = $endtime = "";
            if (isset($shipdata['pickdrops'])) {
                foreach ($shipdata['pickdrops'] as $res) {
                    if ($res['stoptype'] == "P") {
                        $starttime = $res['pickup_datefromtime'];
                        $pickup_datetime = dateTimeToUTC($res['pickup_datefrom'] . "T" . $res['pickup_datefromtime'])->format('Y-m-d H:i:s');
                        $pickup_endtime = dateTimeToUTC($res['pickup_dateto'] . "T" . $res['pickup_datetotime'])->format('Y-m-d H:i:s');
                        $pickup_company = $res['pickup_company'];
                        $pickup_address = $res['pickup_address'];
                        $pickup_city = $res['pickup_city'];
                        $pickup_countrycode = $res['pickup_countrycode'];
                        $pickup_postal = $res['pickup_postal'];
                        $pickup_address1 = $res['pickup_address1'];
                        $pickup_custid = $res['pickup_custid'];
                        $pickup_partyid = $res['pickup_partyid'];
                    }
                    if ($res['stoptype'] == "D") {
                        $endtime = $res['drop_datefromtime'];
                        $delivery_datetime = dateTimeToUTC($res['drop_datefrom'] . "T" . $res['drop_datefromtime'])->format('Y-m-d H:i:s');
                        $drop_endtime = dateTimeToUTC($res['drop_dateto'] . "T" . $res['drop_datetotime'])->format('Y-m-d H:i:s');
                        $drop_company = $res['drop_company'];
                        $drop_address = $res['drop_address'];
                        $drop_city = $res['drop_city'];
                        $drop_countrycode = $res['drop_countrycode'];
                        $drop_postal = $res['drop_postal'];
                        $drop_address1 = $res['drop_address1'];
                        $drop_custid = $res['drop_custid'];
                        $drop_partyid = $res['drop_partyid'];
                    }
                }
                $chkcusttype = "";
                if (isset($shipdata['freight_term'])) {
                    if ($shipdata['freight_term'] == "30" || $shipdata['freight_term'] == "31") {
                        $chkcusttype = "CN";
                    } else if ($shipdata['freight_term'] == "20") {
                        $chkcusttype = "PF";
                    } else if ($shipdata['freight_term'] == "10") {
                        $chkcusttype = "SH";
                    } else if ($shipdata['freight_term'] == "60") {
                        $chkcusttype = "PF";
                        if (isset($shipdata['incoterm'])) {
                            if ($shipdata['incoterm'] == "DAP" || $shipdata['incoterm'] == "DDP") {
                                $chkcusttype = "SH";
                            } else if ($shipdata['incoterm'] == "EXW" || $shipdata['incoterm'] == "FCA") {
                                $chkcusttype = "CN";
                            }
                        }
                    }
                } else {
                    $shipdata['freight_term'] = 60;
                }
                $customer_id = 0;
                $cn_partytype = 3;
                $sh_partytype = 1;
                $pf_partytype = 1;
                $consignee = $this->checkconsignee($shipdata['consignee'], $shipdata['sendercmpcode'], $shipdata['senderbranchcode'], $user_id, $chkcusttype);
                if ($consignee['id'] > 0) {
                    $customer_id = $consignee['id'];
                }
                if (isset($consignee['party_id'])) {
                    $consignee_id = $consignee['party_id'];
                    $cn_partytype = $consignee['party_type'];
                }
                $shipper = $this->checkshipper($shipdata['shipper'], $shipdata['sendercmpcode'], $shipdata['senderbranchcode'], $user_id, $chkcusttype);
                if ($shipper['id'] > 0) {
                    $customer_id = $shipper['id'];
                }
                if (isset($shipper['party_id'])) {
                    $shipper_id = $shipper['party_id'];
                    $sh_partytype = $shipper['party_type'];
                }
                if (isset($shipdata['pf'])) {
                    if (!empty($shipdata['pf'])) {
                        $customer = $this->checkcustomer($shipdata['pf'], $shipdata['sendercmpcode'], $shipdata['senderbranchcode'], $user_id, 'PF');
                        if ($customer['id'] > 0) {
                            $customer_id = $customer['id'];
                        }
                        if (isset($customer['party_id'])) {
                            $cust_id = $customer['party_id'];
                            $pf_partytype = $customer['party_type'];
                        }
                    }
                }
                if ($customer_id == 0) {
                    if ($shipdata['freight_term'] != "60") {
                        $branchwisecust = $this->db->query("SELECT id FROM tb_customers WHERE user_id=$user_id AND company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' ORDER BY id ASC LIMIT 1");
                        if ($branchwisecust->num_rows() > 0) {
                            $customer_id = $branchwisecust->row()->id;
                        } else {
                            $randnum = mt_rand();
                            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                            $cinsdata = array('name' => $company_code . "_Customer", 'phone' => $randnum, 'location' => $firsttwochars, 'address' => $firsttwochars, 'pincode' => $firsttwochars, 'code' => $randnum, 'country' => $firsttwochars, 'password' => $pwd, 'user_id' => $user_id, 'company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt);
                            $customer_id = $this->common->insertTableData('tb_customers', $cinsdata);
                        }
                    }
                }
                $shiptxnid = trim($data['truck']['shipment_id']);
                /*orders table */
                $ord_id = $this->getOrderIdByReference($shipdata);
                if ($ord_id > 0) {
                    $getBookingInfo= $this->common->gettblrowdata(['id' => $ord_id], "order_id,status", "tb_orders", 0, 0);
                    $orddata = array('pickup_datetime' => $pickup_datetime, 'pickup_endtime' => $pickup_endtime, 'delivery_datetime' => $delivery_datetime, 'drop_endtime' => $drop_endtime, 'pickup_company' => $pickup_company, 'delivery_company' => $drop_company, 'pickup_country' => $pickup_countrycode, 'delivery_country' => $drop_countrycode, 'pickup_city' => $pickup_city, 'delivery_city' => $drop_city, 'pickup_pincode' => $pickup_postal, 'delivery_pincode' => $drop_postal, 'pickup_address1' => $pickup_address, 'delivery_address1' => $drop_address, 'pickup_address2' => $pickup_address1, 'delivery_address2' => $drop_address1, 'quantity' => $shipdata['pkgs_count'], 'weight' => $shipdata['gross_weight'], 'volume' => $shipdata['volume'], 'goods_value' => $shipdata['MonetaryAmount'], 'currency' => $shipdata['CurrencyCode'], 'transport_mode' => $transmode, 'dedicated_vehicle' => $dedicateveh, 'vehicle_type' => $data['truck']['triptype'], 'user_id' => $user_id, 'vendor_id' => $carrier_id, 'customer_name' => $shipdata['consignee']['name'], 'customer_code' => $shipdata['consignee']['custid'], 'customer_area' => ($shipdata['consignee']['street'] . ", " . $shipdata['consignee']['city'] . ", " . $shipdata['consignee']['zip']), 'customer_phone' => $shipdata['consignee']['custid'], 'vendor_name' => $shipdata['shipper']['name'], 'vendor_code' => $shipdata['shipper']['custid'], 'vendor_area' => ($shipdata['shipper']['street'] . ", " . $shipdata['shipper']['city'] . ", " . $shipdata['shipper']['zip']), 'vendor_phone' => $shipdata['shipper']['custid'], 'company_code' => $shipdata['sendercmpcode'], 'branch_code' => $shipdata['senderbranchcode'], 'product' => $shipdata['serviceproduct'], 'shipment_id' => $sship_id, 'pickup_custid' => $pickup_custid, 'pickup_partyid' => $pickup_partyid, 'drop_custid' => $drop_custid, 'drop_partyid' => $drop_partyid,  'updatedon' => $curdt, 'shipmentid' => $shiptxnid, 'logicalreceiver' => $data['header']['lreceiver'], 'physicalreceiver' => $data['header']['preceiver'], 'physicalsender' => $data['header']['psender'], 'logicalsender' => $data['header']['lsender'], 'modeoftransport' => $shipdata['sendertransmode']);

                    if (!checkAccessConditions('CHECK_ROADLOG_FREIGHT_TERM', $shipdata['freight_term'])) {
                        $orddata['customer_id'] = $customer_id;
                    }
                    if ($getBookingInfo['status'] != 3) {
                        $orddata['status'] = 2;
                    }
                    $upd = $this->db->where(array("id" => $ord_id))->update('tb_orders', $orddata);
                    $shippmentupdateflag =1;
                    $shipdata['references'][] = ['code' => 'RLG', 'value' => $shipdata['orderid'], 'ref_belongs_to' => "RoadLOG ORDER TRACKING NUMBER"];
                    if (!empty($getBookingInfo)) {
                        $shipdata['orderid'] = $getBookingInfo['order_id'];
                    }
                } else {
                    $orddata = array('order_id' => $shipdata['orderid'], 'pickup_datetime' => $pickup_datetime, 'pickup_endtime' => $pickup_endtime, 'delivery_datetime' => $delivery_datetime, 'drop_endtime' => $drop_endtime, 'pickup_company' => $pickup_company, 'delivery_company' => $drop_company, 'pickup_country' => $pickup_countrycode, 'delivery_country' => $drop_countrycode, 'pickup_city' => $pickup_city, 'delivery_city' => $drop_city, 'pickup_pincode' => $pickup_postal, 'delivery_pincode' => $drop_postal, 'pickup_address1' => $pickup_address, 'delivery_address1' => $drop_address, 'pickup_address2' => $pickup_address1, 'delivery_address2' => $drop_address1, 'quantity' => $shipdata['pkgs_count'], 'weight' => $shipdata['gross_weight'], 'volume' => $shipdata['volume'], 'goods_value' => $shipdata['MonetaryAmount'], 'currency' => $shipdata['CurrencyCode'], 'transport_mode' => $transmode, 'dedicated_vehicle' => $dedicateveh, 'vehicle_type' => $data['truck']['triptype'], 'user_id' => $user_id, 'customer_id' => $customer_id, 'vendor_id' => $carrier_id, 'customer_name' => $shipdata['consignee']['name'], 'customer_code' => $shipdata['consignee']['custid'], 'customer_area' => ($shipdata['consignee']['street'] . ", " . $shipdata['consignee']['city'] . ", " . $shipdata['consignee']['zip']), 'customer_phone' => $shipdata['consignee']['custid'], 'vendor_name' => $shipdata['shipper']['name'], 'vendor_code' => $shipdata['shipper']['custid'], 'vendor_area' => ($shipdata['shipper']['street'] . ", " . $shipdata['shipper']['city'] . ", " . $shipdata['shipper']['zip']), 'vendor_phone' => $shipdata['shipper']['custid'], 'company_code' => $shipdata['sendercmpcode'], 'branch_code' => $shipdata['senderbranchcode'], 'product' => $shipdata['serviceproduct'], 'shipment_id' => $sship_id, 'pickup_custid' => $pickup_custid, 'pickup_partyid' => $pickup_partyid, 'drop_custid' => $drop_custid, 'drop_partyid' => $drop_partyid, 'status' => 2, 'createdon' => $curdt, 'updatedon' => $curdt, "created_source" => 18, 'shipmentid' => $shiptxnid, 'logicalreceiver' => $data['header']['lreceiver'], 'physicalreceiver' => $data['header']['preceiver'], 'physicalsender' => $data['header']['psender'], 'logicalsender' => $data['header']['lsender'], 'modeoftransport' => $shipdata['sendertransmode']);
                    $ord_id = $this->common->insertTableData('tb_orders', $orddata);
                }
                $this->edi_logger->setCompany_code($shipdata['sendercmpcode']);
                $this->edi_logger->setBranch_code($shipdata['senderbranchcode']);
                if ($ord_id > 0) {
                    /*cargo details*/
                    $dg_goods = 0;
                    if ($shipdata['dangerousflag'] == "Y") {
                        $dg_goods = 1;
                    }

                    if (!empty($shipdata['cargodetails'])) {

                        $dimensions = $shipdata['dimensions'];
                        $cargoArray = ['order_id' => $ord_id];
                        $this->common->updatetbledata(
                            'tb_order_cargodetails',
                            ['status' => 0],
                            $cargoArray
                        );
                        $cargoDetails = $this->checkCargodetails($ord_id);
                        foreach ($cargoDetails as $cargoDetail) {
                            $this->common->updatetbledata(
                                'tb_cargo_details',
                                ['status' => 0],
                                ["id" => $cargoDetail['id']]
                            );
                        }
                        //log_message("error","cargo Details".json_encode($shipdata['cargodetails']));
                        foreach ($shipdata['cargodetails'] as $shipDataCargoDetail) {
                            //log_message("error","Packge count". $shipDataCargoDetail['cargo']['pkgs_count']);
                            $cargo_package_value = $shipDataCargoDetail['cargo']['pkgs_count'];
                            $dimensions_package_value = $shipDataCargoDetail['dimensions']['no_of_pkgs_value'];
                            $cargo_package_quantity = $shipDataCargoDetail['cargo']['pkgs_uom'];
                            $dimensions_package_quantity = $shipDataCargoDetail['dimensions']['no_of_pkgs_quantity'];
                            $dg_goods = 0;
                            if (!empty($shipDataCargoDetail['dangerousgoods'])) {
                                $dg_goods = 1;
                            }
                            if ($cargo_package_value == $dimensions_package_value && $cargo_package_quantity == $dimensions_package_quantity) {
                                $shipDataCargoDetail['cargo']['StackableFlag'] = $shipDataCargoDetail['cargo']['StackableFlag'] == "Y" ? '1' : '0';
                                $cargo = [
                                    'cargo_type' => $shipDataCargoDetail['cargo']['pkgs_uom'],
                                    'goods_description' => $shipDataCargoDetail['cargo']['cargo_content'],
                                    'quantity' => $shipDataCargoDetail['cargo']['pkgs_count'],
                                    'length' =>$shipDataCargoDetail['dimensions']['dimensionslength']['length'] ?? '0.00',
                                    'length_unit' =>$shipDataCargoDetail['dimensions']['dimensionslength']['length_uom'] ?? 'Cm',
                                    'width' =>$shipDataCargoDetail['dimensions']['dimensionswidth']['width'] ?? '0.00',
                                    'width_unit' =>$shipDataCargoDetail['dimensions']['dimensionswidth']['width_uom'] ?? 'Cm',
                                    'height' =>$shipDataCargoDetail['dimensions']['dimensionsheight']['height'] ?? '0.00',
                                    'height_unit' =>$shipDataCargoDetail['dimensions']['dimensionsheight']['height_uom'] ?? 'Cm',
                                    'weight' => $shipDataCargoDetail['cargo']['gross_weight'],
                                    'weight_unit' => $shipDataCargoDetail['cargo']['weight_uom'],
                                    'volume' => $shipDataCargoDetail['cargo']['volume'],
                                    'volume_unit' => $shipDataCargoDetail['cargo']['volume_uom'],
                                    'ldm' => $shipDataCargoDetail['cargo']['ldm'],
                                    'ldm_uom' => $shipDataCargoDetail['cargo']['ldm_uom'],
                                    'stackable' => $shipDataCargoDetail['cargo']['StackableFlag'],
                                    'dg_goods' => $dg_goods,
                                    'createdby' => $user_id,
                                    'createdon' => $curdt,
                                ];

                                $cargoDetailId = $this->common->insertTableData('tb_cargo_details', $cargo);

                                $cargodt = [
                                    'order_id' => $ord_id,
                                    'weight' => $shipDataCargoDetail['cargo']['gross_weight'],
                                    'volume' => $shipDataCargoDetail['cargo']['volume'],
                                    'quantity' => $shipDataCargoDetail['cargo']['pkgs_count'],
                                    'quantity_type' => $shipDataCargoDetail['cargo']['pkgs_uom'],
                                    'cargo_content' => $shipDataCargoDetail['cargo']['cargo_content'],
                                ];
                                $checkCargo = $this->db->select("id")->get_where("tb_order_cargodetails", $cargodt);
                                $hunit = 1;
                                $chkhandlingunit = $this->db->select("id")->get_where(
                                    "tbl_shipunit_types",
                                    ["user_id" => $user_id],
                                    1,
                                    0
                                );
                                if ($chkhandlingunit->num_rows() > 0) {
                                    $hunit = $chkhandlingunit->row()->id;
                                }
                                $cargodata = [
                                    'order_id' => $ord_id,
                                    'cargo_id' => $cargoDetailId,
                                    'handling_unit' => $hunit,
                                    'length' =>$shipDataCargoDetail['dimensions']['dimensionslength']['length'] ?? '0.00',
                                    'width' =>$shipDataCargoDetail['dimensions']['dimensionswidth']['width'] ?? '0.00',
                                    'height' =>$shipDataCargoDetail['dimensions']['dimensionsheight']['height'] ?? '0.00',
                                    'weight' => $shipDataCargoDetail['cargo']['gross_weight'],
                                    'volume' => $shipDataCargoDetail['cargo']['volume'],
                                    'quantity' => $shipDataCargoDetail['cargo']['pkgs_count'],
                                    'quantity_type' => $shipDataCargoDetail['cargo']['pkgs_uom'],
                                    'cargo_content' => $shipDataCargoDetail['cargo']['cargo_content'],
                                    'status' => 1,
                                ];
                                $cargo_id = $this->common->insertTableData('tb_order_cargodetails', $cargodata);
                                $qrcode = $this->generateQRCodes($cargo_id, $cargodata);
                                /*send mail to customer*/
                                $custdata = [
                                    "cust_id" => $customer_id,
                                    "qr_path" => $qrcode['qr_path'],
                                    "order_id" => $ord_id,
                                    'weight' => $shipDataCargoDetail['cargo']['gross_weight'],
                                    'volume' => $shipDataCargoDetail['cargo']['volume'],
                                    'quantity' => $shipDataCargoDetail['cargo']['pkgs_count'],
                                    'quantity_type' => $shipDataCargoDetail['cargo']['pkgs_uom'],
                                    'cargo_content' => $shipDataCargoDetail['cargo']['cargo_content'],
                                ];
                                if (!in_array($shipdata['sendercmpcode'], ['PLKN', 'AEKN'])) {
                                    $sendQRmail = $this->sendQRmail($custdata);
                                }
                                /* add dg goods */
                                if (!empty($shipDataCargoDetail['dangerousgoods'])) {
                                    $dgs = $shipDataCargoDetail['dangerousgoods'];
                                    foreach ($dgs as $dg) {
                                        $dggoods = [
                                            'order_id' => $ord_id,
                                            'order_cargo_id' => $cargo_id,
                                            'num_pkgs' => $dg['db_numpkgs'],
                                            'pkg_qty_type' => $dg['db_pkgqtytype'],
                                            'quantity' => $dg['dg_qty'],
                                            'quantity_type' => $dg['dg_qtytype'],
                                            'org_number' => $dg['dg_orgnum'],
                                            'org_num_varient' => $dg['dg_orgnumvar'],
                                            'db_class' => $dg['dg_class'],
                                            'mainrisk' => $dg['dg_mainrisk'],
                                            'subsidiary_risks' => $dg['subsidiary_risks'],
                                            'packing_group' => $dg['packing_group'],
                                            'description' => $dg['dg_desc'],
                                            'limitqty_flag' => $dg['dg_limitqtyflag'],
                                            'tunnel_restriction_code' => $dg['tunnel_restriction_code'],
                                            'transport_category' => $dg['transport_category'],
                                            'environment_hazardous' => $dg['environment_hazardous'],
                                            'nos' => $dg['nos'],
                                            'adr_multiplicator' => $dg['adr_multiplicator'],
                                            'total_adr_points' => $dg['total_adr_points'],
                                            'adr_version' => $dg['adr_version'],
                                            'exceptqty_flag' => $dg['dg_exceptqtyflag'],
                                            'status' => 1,
                                        ];
                                        $dg_chkcargo = $this->common->gettblrowdata(
                                            $dggoods,
                                            "id",
                                            "tb_order_dg_goods",
                                            0,
                                            0
                                        );
                                        if (count($dg_chkcargo) == 0) {
                                            $dggoods_id = $this->common->insertTableData('tb_order_dg_goods', $dggoods);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (!empty($shipdata['references'])) {
                        foreach ($shipdata['references'] as $sref) {
                            if (isset($sref['code']) && isset($sref['value'])) {
                                $chkref = $this->db->select("id")->get_where("tb_order_references", [
                                    'order_id' => $ord_id,
                                    'reference_id' => $sref['code'],
                                    'ref_value' => str_replace("ET", "", $sref['value']),
                                ]);
                                if ($chkref->num_rows() == 0) {
                                    $srefqry = [
                                        'order_id' => $ord_id,
                                        'reference_id' => $sref['code'],
                                        'ref_value' => str_replace("ET", "", $sref['value']),
                                        'status' => 1,
                                        'createdon' => $curdt,
                                        'ref_belongs_to' => $sref['ref_belongs_to'] ?? '',
                                    ];
                                    if (!$this->common->insertTableData('tb_order_references_history', $srefqry)) {
                                        log_error("Unable to execute query :" . json_encode($this->db->error()));
                                    }
                                    $srefqry['ref_belongs_to'] = $sref['ref_belongs_to'];
                                    if (!$this->common->insertTableData('tb_order_references', $srefqry)) {
                                        log_error("Unable to execute query :" . json_encode($this->db->error()));
                                     }
                                } elseif (isset($sref['ref_belongs_to'])) {
                                    $this->db->where(['order_id' => $ord_id, 'reference_id' => $sref['code'], 'ref_value' => str_replace("ET", "", $sref['value'])]
                                    )->update(
                                        'tb_order_references',
                                        [
                                            'status' => 1,
                                            'ref_belongs_to' => $sref['ref_belongs_to'],
                                        ]
                                    );
                                }
                            }
                        }
                    }
                  
                    $orddetails = array('order_row_id' => $ord_id, 'order_id' => $shipdata['orderid'], 'order_status' => "Pending", 'order_type' => '0', 'shipper_id' => 0, 'service' => 3, 'delivery_term' => 0, 'incoterm' => 'DAP', 'delivery_note' => "", 'purchase_order' => "", 'notify_party' => "", 'lane_reference' => "", 'distance' => "", 'customs_required' => 0, 'high_cargo_value' => 0, 'valorance_insurance' => 0, 'temperature_control' => 0, 'department_code' => "", 'character_id' => "", 'character_name' => "", 'revenue_price' => "", 'revenue_currency' => "", 'goods_description' => "", 'status' => 1, 'createdon' => $curdt);
                    $chkorderdt = array('order_row_id' => $ord_id);
                    $chkordetails = $this->db->select("id")->get_where("tb_order_details", $chkorderdt);
                    if ($chkordetails->num_rows() == 0) {
                        $orderdetid = $this->common->insertTableData("tb_order_details", $orddetails);
                    }
                }
                if ($sship_id > 0) {
                    if (isset($consignee_id)) {
                        $checkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $ord_id, 'party_id' => $consignee_id, 'party_type' => $cn_partytype), 1, 0);
                        if ($checkparty->num_rows() > 0) {
                            $partyarr = array('order_number' => $shipdata['orderid'], 'party_id' => $consignee_id, 'party_type' => $cn_partytype, 'status' => 1);
                            $partyid = $checkparty->row()->id;
                            $upd = $this->db->where(array("id" => $partyid))->update('tb_order_parties', $partyarr);
                        } else {
                            $partyarr = array('order_id' => $ord_id, 'order_number' => $shipdata['orderid'], 'party_id' => $consignee_id, 'party_type' => $cn_partytype, 'status' => 1, 'createdon' => $curdt);
                            $ins = $this->common->insertTableData("tb_order_parties", $partyarr);
                        }
                    }
                    if (isset($shipper_id)) {
                        $checkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $ord_id, 'party_id' => $shipper_id, 'party_type' => $sh_partytype), 1, 0);
                        if ($checkparty->num_rows() > 0) {
                            $partyarr = array('order_number' => $shipdata['orderid'], 'party_id' => $shipper_id, 'party_type' => $sh_partytype, 'status' => 1);
                            $partyid = $checkparty->row()->id;
                            $upd = $this->db->where(array("id" => $partyid))->update('tb_order_parties', $partyarr);
                        } else {
                            $partyarr = array('order_id' => $ord_id, 'order_number' => $shipdata['orderid'], 'party_id' => $shipper_id, 'party_type' => $sh_partytype, 'status' => 1, 'createdon' => $curdt);
                            $ins = $this->common->insertTableData("tb_order_parties", $partyarr);
                        }
                    }
                    if (isset($carrier_party_id)) {
                        $checkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $ord_id, 'party_id' => $carrier_party_id, 'party_type' => $ca_partytype), 1, 0);
                        if ($checkparty->num_rows() > 0) {
                            $partyarr = array('order_number' => $shipdata['orderid'], 'party_id' => $carrier_party_id, 'party_type' => $ca_partytype, 'status' => 1);
                            $partyid = $checkparty->row()->id;
                            $upd = $this->db->where(array("id" => $partyid))->update('tb_order_parties', $partyarr);
                        } else {
                            $partyarr = array('order_id' => $ord_id, 'order_number' => $shipdata['orderid'], 'party_id' => $carrier_party_id, 'party_type' => $ca_partytype, 'status' => 1, 'createdon' => $curdt);
                            $ins = $this->common->insertTableData("tb_order_parties", $partyarr);
                        }
                    }
                    if (isset($cust_id)) {
                        $checkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $ord_id, 'party_id' => $cust_id, 'party_type' => $pf_partytype), 1, 0);
                        if ($checkparty->num_rows() > 0) {
                            $partyarr = array('order_number' => $shipdata['orderid'], 'party_id' => $cust_id, 'party_type' => $pf_partytype, 'status' => 1);
                            $partyid = $checkparty->row()->id;
                            $upd = $this->db->where(array("id" => $partyid))->update('tb_order_parties', $partyarr);
                        } else {
                            $partyarr = array('order_id' => $ord_id, 'order_number' => $shipdata['orderid'], 'party_id' => $cust_id, 'party_type' => $pf_partytype, 'status' => 1, 'createdon' => $curdt);
                            $ins = $this->common->insertTableData("tb_order_parties", $partyarr);
                        }
                    }
                }
                /* store in shipment table */
                $startlat = $startlong = $endlat = $endlong = "";
                $sloc = $shipdata['pickdrops'][0]['pickup_address'] . ", " . $shipdata['pickdrops'][0]['pickup_city'] . ", " . $shipdata['pickdrops'][0]['pickup_countrycode'] . ", " . $shipdata['pickdrops'][0]['pickup_postal'];
                $eloc = $shipdata['pickdrops'][1]['drop_address'] . ", " . $shipdata['pickdrops'][1]['drop_city'] . ", " . $shipdata['pickdrops'][1]['drop_countrycode'] . ", " . $shipdata['pickdrops'][1]['drop_postal'];
                $cheklatlng = $this->getlatlongbylocname($sloc);
                if (!empty($cheklatlng)) {
                    $startlat = $cheklatlng['latitude'];
                    $startlong = $cheklatlng['longitude'];
                }
                if ($startlat == "") {
                    $sloc1 = $shipdata['pickdrops'][0]['pickup_city'] . ", " . $shipdata['pickdrops'][0]['pickup_countrycode'] . ", " . $shipdata['pickdrops'][0]['pickup_postal'];
                    $cheklatlng = $this->getlatlongbylocname($sloc1);
                    if (!empty($cheklatlng)) {
                        $startlat = $cheklatlng['latitude'];
                        $startlong = $cheklatlng['longitude'];
                    }
                }
                $cheklatlng1 = $this->getlatlongbylocname($eloc);
                if (!empty($cheklatlng1)) {
                    $endlat = $cheklatlng1['latitude'];
                    $endlong = $cheklatlng1['longitude'];
                }
                if ($endlat == "") {
                    $eloc1 = $shipdata['pickdrops'][1]['drop_city'] . ", " . $shipdata['pickdrops'][1]['drop_countrycode'] . ", " . $shipdata['pickdrops'][1]['drop_postal'];
                    $cheklatlng1 = $this->getlatlongbylocname($eloc1);
                    if (!empty($cheklatlng1)) {
                        $endlat = $cheklatlng1['latitude'];
                        $endlong = $cheklatlng1['longitude'];
                    }
                }
                /*log_message("error",$startlat."-".$startlong."-".$endlat."-".$endlong);*/
                $pickuploc = array('pickup_country' => $pickup_countrycode, 'pickup_city' => $pickup_city, 'pickup_location' => $pickup_address);
                $droploc = array('drop_country' => $drop_countrycode, 'drop_city' => $drop_city, 'drop_location' => $drop_address);
                $border_type = getshipbordertype($pickuploc, $droploc);

                $checkshipment = $this->db->select("id")->get_where("tb_shifts", array('shipmentid' => $shiptxnid), 1, 0);
                if ($checkshipment->num_rows() == 0) {
                    $shipment = array('user_id' => $user_id, 'stime' => date("H:i", strtotime($starttime)), 'etime' => date("H:i", strtotime($endtime)), 'splace' => $pickup_company, 'slat' => $startlat, 'slng' => $startlong, 'eplace' => $drop_company, 'elat' => $endlat, 'elng' => $endlong, 'scity' => $pickup_city, 'dcity' => $drop_city, 'zone_id' => 1, 'empshift_start' => date("H:i", strtotime($starttime)), 'empshift_end' => date("H:i", strtotime($endtime)), 'trip_type' => 0, 'startdate' => $pickup_datetime, 'enddate' => $delivery_datetime, 'shipment_name' => $shipdata['cargo_content'], 'shipmentid' => $shiptxnid, 'shipment_id' => $shiptxnid, 'customer_id' => $customer_id, 'transport_mode' => $transmode, 'vendor_id' => $carrier_id, 'carrier_type' => 0, 'txnid' => $data['truck']['ordernum'], 'weight' => $shipdata['gross_weight'], 'volume' => $shipdata['volume'], 'units' => $shipdata['pkgs_count'], 'domainname' => $data['header']['lsender'], 'vehicle_type' => $data['truck']['triptype'],'carrier_instructions' => $data['truck']['text'], 'company_code' => $shipdata['sendercmpcode'], 'branch_code' => $shipdata['senderbranchcode'], 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                    if ($border_type == 1) {
                        $shipment['border_type'] = $border_type;
                    }
                    $ship_id = $this->common->insertTableData("tb_shifts", $shipment);
                } else {
                    $shipment = array('user_id' => $user_id, 'stime' => date("H:i", strtotime($starttime)), 'etime' => date("H:i", strtotime($endtime)), 'splace' => $pickup_company, 'slat' => $startlat, 'slng' => $startlong, 'eplace' => $drop_company, 'elat' => $endlat, 'elng' => $endlong, 'scity' => $pickup_city, 'dcity' => $drop_city, 'zone_id' => 1, 'empshift_start' => date("H:i", strtotime($starttime)), 'empshift_end' => date("H:i", strtotime($endtime)), 'trip_type' => 0, 'startdate' => $pickup_datetime, 'enddate' => $delivery_datetime, 'shipment_name' => $shipdata['cargo_content'], 'shipment_id' => $shiptxnid, 'customer_id' => $customer_id, 'transport_mode' => $transmode, 'vendor_id' => $carrier_id, 'carrier_type' => 0, 'txnid' => $data['truck']['ordernum'], 'weight' => $shipdata['gross_weight'], 'volume' => $shipdata['volume'], 'units' => $shipdata['pkgs_count'], 'domainname' => $data['header']['lsender'], 'vehicle_type' => $data['truck']['triptype'], 'carrier_instructions' => $data['truck']['text'],'company_code' => $shipdata['sendercmpcode'], 'branch_code' => $shipdata['senderbranchcode'], 'status' => 1, 'updated_on' => $curdt);
                    if ($border_type == 1) {
                        $shipment['border_type'] = $border_type;
                    }
                    $ship_id = $checkshipment->row()->id;
                    $upd = $this->db->where(array("id" => $ship_id))->update('tb_shifts', $shipment);
                }
                /*update order table*/
                $upddt = array("shift_id" => $ship_id, "plat" => $startlat, "plng" => $startlong, "dlat" => $endlat, "dlng" => $endlong);
                $updwhr = array("id" => $ord_id);
                $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                $responseord[] = $ship_id;
                /*stop legs*/
                $stopId = $dropStopId = $employeeId = 0;
                $getStopIds = $this->common->gettblrowdata(['order_id' => $shipdata['orderid'], 'status' => '1', 'shift_id' => $ship_id], "id,stop_id,drop_stopid", "tb_employee", 0, 0);
                if (!empty($getStopIds)) {
                    $employeeId = $getStopIds['id'];
                    $stopId = $getStopIds['stop_id'];
                    $dropStopId = $getStopIds['drop_stopid'];
                }
                $stop1 = $shipdata['pickdrops'][0]['pickup_company'] . ", " . $shipdata['pickdrops'][0]['pickup_address'] . ", " . $shipdata['pickdrops'][0]['pickup_city'] . ", " . $shipdata['pickdrops'][0]['pickup_countrycode'] . ", " . $shipdata['pickdrops'][0]['pickup_postal'];
                $shiporder = [
                    'stopname' => $shipdata['pickdrops'][0]['pickup_company'],
                    'plat' => $startlat,
                    'plng' => $startlong,
                    'stopcity' => $shipdata['pickdrops'][0]['pickup_city'],
                    'address' => $stop1,
                    'stoptype' => 'P',
                    'stopstatus' => 0,
                    'shipment_id' => $ship_id,
                    'ordernumber' => 1,
                    'startdate' => $pickup_datetime,
                    'enddate' => $pickup_endtime,
                    'weight' => $shipdata['gross_weight'],
                    'volume' => $shipdata['volume'],
                    'shipmentstopid' => 0,
                    'serviceprovider' => $data['header']['sendapp'],
                    'ship_units' => $shipdata['pkgs_count'],
                    'txncode' => $data['truck']['ordernum'],
                    'status' => 1,
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                ];
                if ($stopId > 0) {
                    $stopleg1_id = $stopId;
                    $checkMultiOrderStops = $this->common->gettblrowdata("order_id != '" . $shipdata['orderid'] . "' AND shift_id ='" . $ship_id . "' AND status ='1' AND stop_id ='" . $stopId . "' ", "id,stop_id", "tb_employee", 0, 0);
                    if (!empty($checkMultiOrderStops)) {
                        $checkStopLocations = $this->common->gettblrowdata(['shipment_id' => $ship_id, 'stopname' => $shipdata['pickdrops'][0]['pickup_company'], 'stopcity' => $shipdata['pickdrops'][0]['pickup_city'], 'stoptype' => 'P', 'status' => '1'], "id", "tb_shiporder_stops", 0, 0);
                        if (!empty($checkStopLocations)) {
                            $stopleg1_id = $checkStopLocations['id'];
                            $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", $shiporder, ['id' => $stopleg1_id]);
                        } else {
                            $deleteOldStops = $this->common->updatetbledata("tb_shiporder_stops", ['status' => '0'], ['id' => $stopleg1_id]);
                            $stopleg1_id = $this->common->insertTableData("tb_shiporder_stops", $shiporder);
                        }
                    } else {
                        $checkStopLocations = $this->common->gettblrowdata(['shipment_id' => $ship_id, 'stopname' => $shipdata['pickdrops'][0]['pickup_company'], 'stopcity' => $shipdata['pickdrops'][0]['pickup_city'], 'stoptype' => 'P', 'status' => '1'], "id", "tb_shiporder_stops", 0, 0);
                        if (!empty($checkStopLocations)) {
                            $stopLegId = $checkStopLocations['id'];
                            if ($stopLegId != $stopleg1_id) {
                                $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", ['status' => '0'], ['id' => $stopleg1_id]);
                                $stopleg1_id = $stopLegId;
                            }
                        } else {
                            $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", $shiporder, ['id' => $stopleg1_id]);
                        }
                    }
                    $updateEmployee = $this->common->updatetbledata("tb_employee", ['stop_id' => $stopleg1_id], ['id' => $employeeId]);
                } else {
                    $chkstoplegs = $this->common->gettblrowdata(['stopname' => $shipdata['pickdrops'][0]['pickup_company'], 'stopcity' => $shipdata['pickdrops'][0]['pickup_city'], 'stoptype' => 'P', 'shipment_id' => $ship_id, 'txncode' => $data['truck']['ordernum']], "id", "tb_shiporder_stops", 0, 0);
                    if (!empty($chkstoplegs)) {
                        $stopleg1_id = $chkstoplegs['id'];
                        $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", ['address' => $stop1, 'plat' => $startlat, 'plng' => $startlong, 'stoptype' => 'P', 'startdate' => $pickup_datetime, 'enddate' => $pickup_endtime, 'weight' => $shipdata['gross_weight'], 'volume' => $shipdata['volume'], 'serviceprovider' => $data['header']['sendapp'], 'ship_units' => $shipdata['pkgs_count'], 'updated_on' => $curdt], ['id' => $stopleg1_id]);
                    } else {
                        $stopleg1_id = $this->common->insertTableData("tb_shiporder_stops", $shiporder);
                    }
                }
                $stop2 = $shipdata['pickdrops'][1]['drop_company'] . ", " . $shipdata['pickdrops'][1]['drop_address'] . ", " . $shipdata['pickdrops'][1]['drop_city'] . ", " . $shipdata['pickdrops'][1]['drop_countrycode'] . ", " . $shipdata['pickdrops'][1]['drop_postal'];
                $shiporder = [
                    'stopname' => $shipdata['pickdrops'][1]['drop_company'],
                    'plat' => $endlat,
                    'plng' => $endlong,
                    'stopcity' => $shipdata['pickdrops'][1]['drop_city'],
                    'address' => $stop2,
                    'stoptype' => 'D',
                    'stopstatus' => 0,
                    'shipment_id' => $ship_id,
                    'ordernumber' => 2,
                    'startdate' => $delivery_datetime,
                    'enddate' => $drop_endtime,
                    'weight' => $shipdata['gross_weight'],
                    'volume' => $shipdata['volume'],
                    'shipmentstopid' => 0,
                    'serviceprovider' => $data['header']['sendapp'],
                    'ship_units' => $shipdata['pkgs_count'],
                    'txncode' => $data['truck']['ordernum'],
                    'status' => 1,
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                ];
                if ($dropStopId > 0) {
                    $stopleg2_id = $dropStopId;
                    $checkMultiOrderDropStops = $this->common->gettblrowdata("order_id != '" . $shipdata['orderid'] . "' AND shift_id ='" . $ship_id . "' AND status ='1' AND drop_stopid ='" . $stopleg2_id . "' ", "id", "tb_employee", 0, 0);
                    if (!empty($checkMultiOrderDropStops)) {
                        $checkDStopLocations = $this->common->gettblrowdata(['shipment_id' => $ship_id, 'stopname' => $shipdata['pickdrops'][1]['drop_company'], 'stopcity' => $shipdata['pickdrops'][1]['drop_city'], 'stoptype' => 'D', 'status' => '1'], "id", "tb_shiporder_stops", 0, 0);
                        if (!empty($checkDStopLocations)) {
                            $stopleg2_id = $checkDStopLocations['id'];
                            $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", $shiporder, ['id' => $stopleg2_id]);
                        } else {
                            $deleteOldStops = $this->common->updatetbledata("tb_shiporder_stops", ['status' => '0'], ['id' => $stopleg2_id]);
                            $stopleg2_id = $this->common->insertTableData("tb_shiporder_stops", $shiporder);
                        }
                    } else {
                        $checkDStopLocations = $this->common->gettblrowdata(['shipment_id' => $ship_id, 'stopname' => $shipdata['pickdrops'][1]['drop_company'], 'stopcity' => $shipdata['pickdrops'][1]['drop_city'], 'stoptype' => 'D', 'status' => '1'], "id", "tb_shiporder_stops", 0, 0);
                        if (!empty($checkDStopLocations)) {
                            $stopLegId = $checkDStopLocations['id'];
                            if ($stopLegId != $stopleg2_id) {
                                $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", ['status' => '0'], ['id' => $stopleg2_id]);
                                $stopleg2_id = $stopLegId;
                            }
                        } else {
                            $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", $shiporder, ['id' => $stopleg2_id]);
                        }
                    }
                    $updateEmployee = $this->common->updatetbledata("tb_employee", ['drop_stopid' => $stopleg2_id], ['id' => $employeeId]);
                } else {
                    $chkstoplegs = $this->common->gettblrowdata(['stopname' => $shipdata['pickdrops'][1]['drop_company'], 'stopcity' => $shipdata['pickdrops'][1]['drop_city'], 'stoptype' => 'D', 'shipment_id' => $ship_id, 'txncode' => $data['truck']['ordernum'], 'status' => '1'], "id", "tb_shiporder_stops", 0, 0);
                    if (!empty($chkstoplegs)) {
                        $stopleg2_id = $chkstoplegs['id'];
                        $updateLegs = $this->common->updatetbledata("tb_shiporder_stops", ['address' => $stop2, 'plat' => $endlat, 'plng' => $endlong, 'stoptype' => 'D', 'startdate' => $delivery_datetime, 'enddate' => $drop_endtime, 'weight' => $shipdata['gross_weight'], 'volume' => $shipdata['volume'], 'serviceprovider' => $data['header']['sendapp'], 'ship_units' => $shipdata['pkgs_count'], 'updated_on' => $curdt], ['id' => $stopleg2_id]);
                    } else {
                        $stopleg2_id = $this->common->insertTableData("tb_shiporder_stops", $shiporder);
                    }
                }
                /*stops*/
                $chkemp = $this->db->select("id")->get_where("tb_employee", ['assoc_id' => $data['truck']['ordernum'], 'order_id' => $shipdata['orderid'], 'shift_id' => $ship_id, 'stop_id' => $stopleg1_id, 'drop_stopid' => $stopleg2_id], 1, 0);
                $checkEmployee = $this->common->gettblrowdata(['assoc_id' => $data['truck']['ordernum'], 'order_id' => $shipdata['orderid'], 'shift_id' => $ship_id], "id", "tb_employee", 0, 0);
                if (!empty($checkEmployee)) {
                    $stop_id = $checkEmployee['id'];
                    $stops = [
                        'pickup' => $pickup_company,
                        'drop' => $drop_company,
                        'pickup_city' => $pickup_city,
                        'plat' => $startlat,
                        'plng' => $startlong,
                        'drop_city' => $drop_city,
                        'dlat' => $endlat,
                        'dlng' => $endlong,
                        'pickup_datetime' => $pickup_datetime,
                        'drop_datetime' => $delivery_datetime,
                        'name' => $shipdata['cargo_content'],
                        'address' => $stop1,
                        'user_id' => $user_id,
                        'updatedon' => $curdt,
                        'capacity' => $shipdata['gross_weight'],
                        'shipment_weight' => $shipdata['gross_weight'],
                        'shipment_volume' => $shipdata['volume'],
                        'ship_type' => 'P',
                        'customer_id' => $customer_id,
                        'vendor_id' => $carrier_id,
                        'startdate' => $pickup_datetime,
                        'enddate' => $delivery_datetime,
                        'pkgitemid' => $shipdata['cargo_content'],
                        'no_of_pkgs' => $shipdata['pkgs_count'],
                        'domainname' => $data['header']['lsender']
                    ];
                    $updateEmployee = $this->common->updatetbledata("tb_employee", $stops, ['id' => $stop_id]);
                } else {
                    $jk = 1;
                    $stops = [
                        'assoc_id' => $data['truck']['ordernum'],
                        'pickup' => $pickup_company,
                        'plat' => $startlat,
                        'plng' => $startlong,
                        'drop' => $drop_company,
                        'dlat' => $endlat,
                        'dlng' => $endlong,
                        'pickup_city' => $pickup_city,
                        'drop_city' => $drop_city,
                        'pickup_datetime' => $pickup_datetime,
                        'drop_datetime' => $delivery_datetime,
                        'name' => $shipdata['cargo_content'],
                        'phone' => "",
                        'address' => $stop1,
                        'user_id' => $user_id,
                        'password' => RandomString::generate(10),
                        'status' => 1,
                        'createdon' => $curdt,
                        'updatedon' => $curdt,
                        'material_id' => 0,
                        'capacity' => $shipdata['gross_weight'],
                        'information' => "",
                        'shipment_weight' => $shipdata['gross_weight'],
                        'shipment_volume' => $shipdata['volume'],
                        'ship_type' => 'P',
                        'customer_id' => $customer_id,
                        'vendor_id' => $carrier_id,
                        'shipment_id' => $sship_id,
                        'startdate' => $pickup_datetime,
                        'enddate' => $delivery_datetime,
                        'shift_id' => $ship_id,
                        'stop_order' => $jk,
                        'drop_order' => $jk,
                        'basic_stop' => 1,
                        'stop_id' => $stopleg1_id,
                        'drop_stopid' => $stopleg2_id,
                        'order_id' => $shipdata['orderid'],
                        'pkgitemid' => $shipdata['cargo_content'],
                        'no_of_pkgs' => $shipdata['pkgs_count'],
                        'domainname' => $data['header']['lsender']
                    ];
                    $stop_id = $this->common->insertTableData("tb_employee", $stops);
                }
                /*driver info*/
                $driver_id = 0;
                if (isset($data['driver'])) {
                    if (isset($data['driver']['driverid'])) {
                        $data['driver']['driverid'] = trim($data['driver']['driverid']);
                        $driverMobileNumber = trim($data['driver']['driver_mobile_no'] ?? '');
                        if ($driverMobileNumber == '') {
                            $driverMobileNumber = (string)$data['driver']['driverid'];
                        }
                        $chk_driver = $this->db->select("id")->get_where("tb_truck_drivers", ["contact_num" => $driverMobileNumber], 1, 0);
                        if ($chk_driver->num_rows() === 0) {
                            //added by mahendra
                            if ($drivercity == "") {
                                $drivercity = $pickup_city;
                            }
                            $driverFirstname = isset($data['driver']['firstname']) ? $data['driver']['firstname'] : "SVK";
                            $driverlastname = isset($data['driver']['lastname']) ? $data['driver']['lastname'] : "DRIVER";
                            if ($driverFirstname == "") {
                                $driverFirstname = "KN DRIVER";
                            }

                            
                            $md5Password = password_hash($driverMobileNumber,PASSWORD_DEFAULT);
                            $driver = ['name' => sprintf('%s %s', $driverFirstname, $driverlastname), 'company_code' => $shipdata['sendercmpcode'], 'branch_code' => $shipdata['senderbranchcode'],'password' => $md5Password, 'contact_num' => $driverMobileNumber, 'age' => 0, 'driving_since' => '0', 'driving_licence_num' => '', 'city' => $drivercity, 'createdon' => $curdt, 'updatedon' => $curdt, 'createdby' => $user_id, 'updatedby' => $user_id, 'user_id' => $user_id, 'vendor_id' => $carrier_id, 'status' => 'Active'];
                            $driver_id = $this->common->insertTableData("tb_truck_drivers", $driver);
                        } 


                        else {
                          
                            $driver_id = $chk_driver->row()->id;
                            $driverFirstname = isset($data['driver']['firstname']) ? $data['driver']['firstname'] : "SVK";
                            $driverlastname = isset($data['driver']['lastname']) ? $data['driver']['lastname'] : "DRIVER";
                            $updateDriverQry = ['name' => sprintf('%s %s', $driverFirstname, $driverlastname), 'vendor_id' => $carrier_id, 'status' => 'Active'];
                            //added by mahendra
                            if ($drivercity != "") {
                                $updateDriverQry['city'] = $drivercity;
                            }
                            //
                            $updqry = $this->db->where(array("id" => $driver_id))->update("tb_truck_drivers", $updateDriverQry);
                        }
                    }
                }
                $rand = mt_rand(1111111111, 9999999999);

                $vehtype = $data['truck']['veh_type'];
                $trailerName  = $trailer = $data['truck']['trailer'] ?? '';
                $vehnumchk = $vehicleid = "";

                $vehnum = $data['truck']['veh_number'];
                if ($vehnum != "") {
                    $vehnumchk = $vehnum;
                }

                $trailerId = null;
                if ($vehnumchk != "") {
                    $chkveh = $this->db->select("id,register_number,truck_number")->get_where(
                        "tb_trucks_data",
                        [
                            'register_number' => $vehnumchk,
                        ],
                        1,
                        0
                    );
                    if ($chkveh->num_rows() > 0) {
                        $vehicleid = $chkveh->row()->id;
                        if ($trailer != "") {
                            $vehicletrailer = $chkveh->row()->truck_number;
                            if ($trailer === $vehicletrailer) {
                                $set = [
                                    'vendor_id' => $carrier_id,
                                    'user_id' => $user_id,
                                    'status' => 'Active',
                                ];
                                $whr = ["id" => $vehicleid];
                                $upd = $this->db->set($set)->where($whr)->update("tb_trucks_data");
                            } else {
                                $set = [
                                    "truck_number" => $trailer,
                                    'vendor_id' => $carrier_id,
                                    'user_id' => $user_id,
                                    'status' => 'Active',
                                ];
                                $whr = ["id" => $vehicleid];
                                $upd = $this->db->set($set)->where($whr)->update("tb_trucks_data");
                                $chktrip = $this->db->select("trip_id")->get_where(
                                    "tb_orders",
                                    ["shift_id" => $ship_id],
                                    1,
                                    0
                                );
                                if ($chktrip->row()->trip_id != 0) {
                                    $postdata = [
                                        "shipment_id" => $ship_id,
                                        "trip_id" => $chktrip->row()->trip_id,
                                        "driver_id" => $driver_id,
                                        "stop_id" => 0,
                                        "order_id" => $shipdata['orderid'],
                                        "inc_id" => 0,
                                        "pod_type" => '',
                                        "stop_type" => '',
                                        "vehicle_id" => $vehicleid,
                                        "curtz" => $curtz,
                                        "status_code" => '0212',
                                        "ord_id" => $ord_id,
                                    ];
                                    $this->shippeomodel->triggerShippeoPairmeanIfOrderExists($ship_id, $vehicleid, $driver_id,(new DateTime($curdt))->getTimezone()->getName());
                                }
                            }
                        }
                    } else {
                        $ttype1 = $this->db->select("id")->get_where("tb_trucktypes", array("trucktype" => $vehtype), 1, 0);
                        if ($ttype1->num_rows() > 0) {
                            $ttype = $ttype1->row()->id;
                        } else {
                            $arrvehtype = array("trucktype" => $vehtype, "description" => $vehtype, "company_code" => $shipdata['sendercmpcode'], "branch_code" => $shipdata['senderbranchcode'], "status" => "Active", 'createdon' => $curdt, 'updatedon' => $curdt);
                            $ttype = $this->common->insertTableData("tb_trucktypes", $arrvehtype);
                        }
                        if ($trailer == "") {
                            $trailer = $vehnumchk;
                        }
                        $arr = array('truck_number' => $trailer, 'length' => "100", 'breadth' => "100", 'truck_capacity' => "100", 'truck_type' => $ttype, 'available_type' => "", 'description' => "", 'register_number' => $vehnumchk, 'insurence' => "Yes", 'insuredby' => "", 'insurestart' => $curdt, 'insureexp' => $curdt, 'route' => $rand, 'user_id' => $user_id, 'vendor_id' => $carrier_id, 'createdby' => "0", 'updatedby' => "0", 'status' => 'Active', 'createdon' => $curdt, 'updatedon' => $curdt);
                        $vehicleid = $this->common->insertTableData("tb_trucks_data", $arr);
                    }
                }

                if (!empty($trailerName)) {
                    $trailerId = $this->trailerMasterHandler($trailerName);
                }

                $shipvehid = "";
                if ($vehicleid != "") {
                    $assignarr = array("carrier_id" => $carrier_id, "driver_id" => $driver_id, "vehicleid" => $vehicleid, "user_id" => $user_id, "curdt" => $curdt);
                    $chkvehfun = $this->setvehiclewithin($assignarr);
                    /*assign to carrier*/
                    $veharrs = array("user_id" => $user_id, "shft_id" => $ship_id);
                    $chkvehs = $this->db->select("id")->get_where("tb_shft_veh", $veharrs, 1, 0);

                    $veharr = ['user_id' => $user_id, 'shft_id' => $ship_id, 'carrier_id' => $carrier_id, 'vehicle_id' => $vehicleid];
                    $chkveh = $this->db->select("id")->get_where("tb_shft_veh", $veharr, 1, 0);
                    if ($chkveh->num_rows() == 0) {
                        $updvehs = array("status" => 0, 'updated_on' => $curdt);
                        $upds = $this->db->where($veharrs)->update("tb_shft_veh", $updvehs);

                        $insveh = [
                            'user_id' => $user_id,
                            'shft_id' => $ship_id,
                            'carrier_id' => $carrier_id,
                            'vehicle_id' => $vehicleid,
                            'register_number' => $vehnumchk,
                            'status' => 1,
                            'created_on' => $curdt,
                            'updated_on' => $curdt,
                            'trailer_id' => $trailerId
                        ];
                        $shipvehid = $this->common->insertTableData("tb_shft_veh", $insveh);

                        $shfth = $this->common->gettblrowdata(array('shft_id' => $ship_id), 'id', 'tb_shft_veh_history', 0, 0);
                        if (count($shfth) > 0) {
                            $veharr = array("user_id" => $user_id, "shft_id" => $ship_id);
                            $upddveh = array("carrier_id" => $carrier_id, "vehicle_id" => $vehicleid, "driver_id" => $driver_id, "register_number" => $vehnumchk, 'updated_on' => $curdt);
                            $updd = $this->common->updatetbledata("tb_shft_veh_history", $upddveh, $veharr);
                        } else {
                            $vehar = array('vehicle_id' => $vehicleid, 'status' => 1);
                            $insvehold = array("user_id" => $user_id, "shft_id" => $ship_id, "carrier_id" => $carrier_id, "vehicle_id" => $vehicleid, "driver_id" => $driver_id, "register_number" => $vehnumchk, "status" => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                            $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $insvehold);
                        }
                    } else {
                        $shipvehid = $chkveh->row()->id;
                        $updveh = ["status" => 1, 'updated_on' => $curdt, 'trailer_id' => $trailerId];
                        $upd = $this->db->where(['id' => $shipvehid])->update('tb_shft_veh', $updveh);
                        $upddveh = array("carrier_id" => $carrier_id, "vehicle_id" => $vehicleid, "driver_id" => $driver_id, "register_number" => $vehnumchk, 'updated_on' => $curdt);
                        $updveharr = array("user_id" => $user_id, "shft_id" => $ship_id);
                        $updd = $this->common->updatetbledata("tb_shft_veh_history", $upddveh, $updveharr);
                    }
                }
                $chktrip = $this->db->select("trip_id")->get_where(
                    "tb_orders",
                    ["shift_id" => $ship_id],
                    1,
                    0
                );

                if ($chktrip->row()->trip_id != 0) {
                    $this->shippeomodel->updateTrip(
                        $ship_id,
                        $vehicleid,
                        $driver_id,
                        $curdt,
                        (new DateTime($curdt))->getTimezone()->getName(),
                        $data['truck']['origindate']
                    );
                }

                /*assign to priority stops */
                if ($shipvehid != "") {
                    $veharr = array("shft_veh_id" => $shipvehid);
                    $chkveh = $this->db->select("id")->get_where("tb_shft_veh_emp", $veharr, 1, 0);
                    if ($chkveh->num_rows() == 0) {
                        $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array("shift_id" => $ship_id));
                        if ($getemp->num_rows() > 0) {
                            $pri = 1;
                            foreach ($getemp->result() as $gt) {
                                $insveh1 = array("user_id" => $user_id, "shft_veh_id" => $shipvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime);
                                $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                $pri++;
                            }
                        }
                    } else {
                        $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array("shift_id" => $ship_id));
                        if ($getemp->num_rows() > 0) {
                            $pri = 1;
                            foreach ($getemp->result() as $gt) {
                                $veharr = array("user_id" => $user_id, "shft_veh_id" => $shipvehid, "emp_id" => $gt->id);
                                $chkveh = $this->db->select("id")->get_where("tb_shft_veh_emp", $veharr, 1, 0);
                                if ($chkveh->num_rows() == 0) {
                                    $insveh1 = array("user_id" => $user_id, "shft_veh_id" => $shipvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime);
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                } else {
                                    $veharr11 = array("id" => $chkveh->row()->id);
                                    $updveh1 = array("priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime);
                                    $upd = $this->db->where($veharr11)->update("tb_shft_veh_emp", $updveh1);
                                }
                                $pri++;
                            }
                        }
                    }
                }
                /*assign to driver*/
                if ($vehicleid != "" && $driver_id != 0) {
                    $veharr1 = array("vehicle_id" => $vehicleid, "driver_id" => $driver_id);
                   
                    $updveho = array("vehicle_id" => $vehicleid, "status" => 1);
                    $updvehod = array("driver_id" => $driver_id, "status" => 1);
                    $updveho1 = array("status" => 0, 'updated_on' => $curdt);
                    $upd = $this->common->updatetbledata("tbl_assigned_drivers", $updveho1, $updveho);
                    $chkveh1 = $this->db->select("id")->get_where("tbl_assigned_drivers", $veharr1, 1, 0);
                    if ($chkveh1->num_rows() == 0) {
                        $insveh1 = array("vehicle_id" => $vehicleid, "user_id" => $user_id, "driver_id" => $driver_id, "from_time" => $curdt, "to_time" => $curdt, "status" => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                        $ins = $this->common->insertTableData("tbl_assigned_drivers", $insveh1);
                    } else {
                        $updveh1 = array("status" => 1, 'updated_on' => $curdt);
                        $upd = $this->db->where($veharr1)->update("tbl_assigned_drivers", $updveh1);
                    }
                }
                $checkvendors = $this->db->select("id")->get_where("tb_vendors", array('id' => $carrier_id, 'tms_auto_accept' => 1), 1, 0);
                if ($checkvendors->num_rows() != 0 && $vehicleid != "") {
                    $this->shippeomodel->updateTrip(
                        $ship_id,
                        $vehicleid,
                        $driver_id,
                        $curdt,
                        (new DateTime($curdt))->getTimezone()->getName(),
                        $data['truck']['origindate']
                    );
                }
            }
        }
        return $responseord;
    }

    function setvehiclewithin($data)
    {
        $driver_id = $data['driver_id'];
        $carrier_id = $data['carrier_id'];
        $vehicleid = $data['vehicleid'];
        $user_id = $data['user_id'];
        $curdt = $data['curdt'];
        $chkvveh = $this->db->select("id")->get_where("tb_vendor_vehicles", array("vendor_id" => $carrier_id, "vehicle_id" => $vehicleid), 1, 0);
        if ($chkvveh->num_rows() > 0) {
            $upd = $this->db->where(array("id" => $chkvveh->row()->id))->update("tb_vendor_vehicles", array("status" => "1"));
        } else {
            $arr1 = array('vendor_id' => $carrier_id, 'vehicle_id' => $vehicleid, 'status' => 1);
            $ins = $this->common->insertTableData("tb_vendor_vehicles", $arr1);
        }
        if ($driver_id != 0) {
            $chkdrive = $this->db->select("id,vehicle_id")->get_where("tb_vehicles_drivers", array("vehicle_id" => $vehicleid, "driver_id" => $driver_id), 1, 0);
            if ($chkdrive->num_rows() > 0) {
                $ischk = array("id" => $chkdrive->row()->id);
                $upd = $this->db->set(array("status" => 1))->where($ischk)->update("tb_vehicles_drivers");
            } else {
                $arr1 = array('vehicle_id' => $vehicleid, 'driver_id' => $driver_id, 'imei' => "", 'status' => "1");
                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr1);
            }
        }
        $response['vehicleid'] = $vehicleid;
        return $response;
    }

    function setvehiclewithout($data)
    {
        $driver_id = $data['driver_id'];
        $carrier_id = $data['carrier_id'];
        $user_id = $data['user_id'];
        $vehnumchk = $data['vehnumchk'];
        $rand = $data['rand'];
        $curdt = $data['curdt'];
        $response = array();
        $chkdrive = $this->db->select("id,vehicle_id")->get_where("tb_vehicles_drivers", array("driver_id" => $driver_id, "status" => 1), 1, 0);
        if ($chkdrive->num_rows() > 0) {
            $vehicleid = $chkdrive->row()->vehicle_id;
            $chkvveh = $this->db->select("id")->get_where("tb_vendor_vehicles", array("vendor_id" => $carrier_id, "vehicle_id" => $vehicleid), 1, 0);
            if ($chkvveh->num_rows() > 0) {
                $upd = $this->db->where(array("vehicle_id" => $vehicleid))->update("tb_vendor_vehicles", array("status" => "0"));
                $upd = $this->db->where(array("id" => $chkvveh->row()->id))->update("tb_vendor_vehicles", array("status" => "1"));
            } else {
                $arr1 = array('vendor_id' => $carrier_id, 'vehicle_id' => $vehicleid, 'status' => "1");
                $ins = $this->common->insertTableData("tb_vendor_vehicles", $arr1);
            }
        } else {
            $chk = $this->db->query("SELECT id,register_number FROM tb_trucks_data WHERE id NOT IN(SELECT vehicle_id FROM tb_vendor_vehicles WHERE vendor_id=$carrier_id AND status=1 GROUP BY vehicle_id) AND user_id=$user_id AND status='Active' LIMIT 1");
            if ($chk->num_rows() > 0) {
                $vehicleid = $chk->row()->id;
                $vehnumchk = $chk->row()->register_number;
            } else {
                $arr = array('truck_number' => $driver_id, 'length' => "100", 'breadth' => "100", 'truck_capacity' => "100", 'truck_type' => "1", 'available_type' => "", 'description' => "", 'register_number' => $vehnumchk, 'insurence' => "Yes", 'insuredby' => "", 'insurestart' => $curdt, 'insureexp' => $curdt, 'route' => $rand, 'user_id' => $user_id, 'vendor_id' => $carrier_id, 'createdby' => "0", 'updatedby' => "0", 'status' => 'Active', 'createdon' => $curdt, 'updatedon' => $curdt);
                $vehicleid = $this->common->insertTableData("tb_trucks_data", $arr);
            }
            $chkd = $this->db->select("id,driver_id,status")->order_by("status", "DESC")->get_where("tb_vehicles_drivers", array("vehicle_id" => $vehicleid, "driver_id" => $driver_id));

            $chkv = $this->db->select("id,driver_id,status")->order_by("status", "DESC")->get_where("tb_vehicles_drivers", array("vehicle_id" => $vehicleid));
            $upd = $this->db->where(array("id" => $chkv->row()->id))->update("tb_vehicles_drivers", array("status" => 0));

            if ($chkd->num_rows() > 0) {
                $upd = $this->db->where(array("id" => $chkd->row()->id))->update("tb_vehicles_drivers", array("status" => 1));
            } else {
                $arr = array('vehicle_id' => $vehicleid, 'driver_id' => $driver_id, 'imei' => "", 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt);
                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
            }
            $chkvveh = $this->db->select("id")->get_where("tb_vendor_vehicles", array("vendor_id" => $carrier_id, "vehicle_id" => $vehicleid), 1, 0);
            if ($chkvveh->num_rows() > 0) {
                /*$upd = $this->db->where(array("vehicle_id"=>$vehicleid))->update("tb_vendor_vehicles",array("status"=>"0"));*/
                $upd = $this->db->where(array("id" => $chkvveh->row()->id))->update("tb_vendor_vehicles", array("status" => "1"));
            } else {
                $chkvveh1 = $this->db->select("id")->get_where("tb_vendor_vehicles", array("vehicle_id" => $vehicleid), 1, 0);
                if ($chkvveh1->num_rows() > 0) {
                    $upvh = array('vendor_id' => $carrier_id, 'vehicle_id' => $vehicleid, 'status' => "1");
                    $upd = $this->db->where(array("id" => $chkvveh1->row()->id))->update("tb_vendor_vehicles", $upvh);
                } else {
                    $arr1 = array('vendor_id' => $carrier_id, 'vehicle_id' => $vehicleid, 'status' => "1");
                    $ins = $this->common->insertTableData("tb_vendor_vehicles", $arr1);
                }
            }
        }
        $response['vehicleid'] = $vehicleid;
        $response['vehnumchk'] = $vehnumchk;
        return $response;
    }

    function getlatlongbylocname($address)
    {
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }

    public function checkconsignee($customer, $cmpcode, $branchcode, $uid, $custtype)
    {
        $cwhr1 = ['code' => $customer['custid'],'company_code' => $cmpcode, 'branch_code' => $branchcode];
        $pwhr1 = array("code" => $customer['custid'],"company_code"=>$cmpcode);
        $cselect = 'id';
        $cpselect = 'id,party_type_id,party_types';
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $curdt = $getactual['datetime'];
        $cust_id = 0;
        if ($custtype == "CN") {
            $ctable = 'tb_customers';
            $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, $ctable, 0, 0);
            if (count($chkcust) > 0) {
                $cust_id = $chkcust['id'];
                $upddata = array('location' => $customer['city'], 'address' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updatedon' => $curdt);
                $upd = $this->db->where(array("id" => $cust_id))->update('tb_customers', $upddata);
            } else {
                $randnum = $customer['custid'];
                $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                $cinsdata = array('name' => $customer['name'], 'phone' => $customer['custid'], 'location' => $customer['city'], 'address' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'password' => $pwd, 'user_id' => $uid, 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt);
                $cust_id = $this->common->insertTableData('tb_customers', $cinsdata);
            }
            $party_type_id = 0;
            $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", array("name" => "Customer", "user_id" => $uid, 'company_code' => $cmpcode), 1, 0);
            if ($chkpartytype->num_rows() > 0) {
                $party_type_id = $chkpartytype->row()->id;
            }
            if ($party_type_id > 0) {
                $chkcust = $this->common->gettblrowdata($pwhr1, $cpselect, "tbl_party_master", 0, 0);

                if (count($chkcust) > 0) {
                    $custid = $chkcust['id'];
                    $party_types = $chkcust['party_types'];
                    $prsnt_partytype = $chkcust['party_type_id'];
                    $upddata = array('location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updated_on' => $curdt);
                    $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
                    $this->updateuserpartytypes($prsnt_partytype, $party_types, $custid, $party_type_id, $cmpcode, $branchcode, $uid, "Customer");
                } else {
                    $randnum = $customer['custid'];
                    $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                    $cinsdata = array('party_type_id' => $party_type_id, 'name' => $customer['name'], 'email' => 'svkonekt@kuehne-nagel.com', 'mobile' => $customer['custid'], 'location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                    $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
                }
            }
        }
        $cwhr['party_type_id'] = 3;
        $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", array("name" => "Consignee", "user_id" => $uid, 'company_code' => $cmpcode), 1, 0);
        if ($chkpartytype->num_rows() > 0) {
            $cwhr['party_type_id'] = $chkpartytype->row()->id;
        }
        $chkcust = $this->common->gettblrowdata($pwhr1, $cpselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $party_types = $chkcust['party_types'];
            $prsnt_partytype = $chkcust['party_type_id'];
            $upddata = array('location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updated_on' => $curdt);
            $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
            $this->updateuserpartytypes($prsnt_partytype, $party_types, $custid, $cwhr['party_type_id'], $cmpcode, $branchcode, $uid, "Consignee");
        } else {
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array('party_type_id' => $cwhr['party_type_id'], 'name' => $customer['name'], 'email' => 'svkonekt@kuehne-nagel.com', 'mobile' => $customer['custid'], 'location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $cwhr['party_type_id'];
        return $res;
    }

    public function checkshipper($customer, $cmpcode, $branchcode, $uid, $custtype)
    {
        $cwhr1 = ['code' => $customer['custid'],'company_code' => $cmpcode, 'branch_code' => $branchcode];
        $pwhr1 = array("code" => $customer['custid'],"company_code"=>$cmpcode);
        $cselect = 'id';
        $cpselect = "id,party_type_id,party_types";
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $curdt = $getactual['datetime'];
        $cust_id = 0;
        if ($custtype == "SH") {
            $ctable = 'tb_customers';
            $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, $ctable, 0, 0);
            if (count($chkcust) > 0) {
                $cust_id = $chkcust['id'];
                $upddata = array('location' => $customer['city'], 'address' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updatedon' => $curdt);
                $upd = $this->db->where(array("id" => $cust_id))->update('tb_customers', $upddata);
            } else {
                $randnum = $customer['custid'];
                $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                $cinsdata = array('name' => $customer['name'], 'phone' => $customer['custid'], 'location' => $customer['city'], 'address' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'password' => $pwd, 'user_id' => $uid, 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt);
                $cust_id = $this->common->insertTableData('tb_customers', $cinsdata);
            }
            $party_type_id = 0;
            $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", array("name" => "Customer", "user_id" => $uid, 'company_code' => $cmpcode), 1, 0);
            if ($chkpartytype->num_rows() > 0) {
                $party_type_id = $chkpartytype->row()->id;
            }
            if ($party_type_id > 0) {
                $chkcust = $this->common->gettblrowdata($pwhr1, $cpselect, "tbl_party_master", 0, 0);
                if (count($chkcust) > 0) {
                    $custid = $chkcust['id'];
                    $party_types = $chkcust['party_types'];
                    $prsnt_partytype = $chkcust['party_type_id'];
                    $upddata = array('location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updated_on' => $curdt);
                    $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
                    $this->updateuserpartytypes($prsnt_partytype, $party_types, $custid, $party_type_id, $cmpcode, $branchcode, $uid, "Customer");
                } else {
                    $randnum = $customer['custid'];
                    $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                    $cinsdata = array('party_type_id' => $party_type_id, 'name' => $customer['name'], 'email' => 'svkonekt@kuehne-nagel.com', 'mobile' => $customer['custid'], 'location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                    $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
                }
            }
        }
        $cwhr['party_type_id'] = 1;
        $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", array("name" => "Shipper", "user_id" => $uid, 'company_code' => $cmpcode), 1, 0);
        if ($chkpartytype->num_rows() > 0) {
            $cwhr['party_type_id'] = $chkpartytype->row()->id;
        }
        $chkcust = $this->common->gettblrowdata($pwhr1, $cpselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $party_types = $chkcust['party_types'];
            $prsnt_partytype = $chkcust['party_type_id'];
            $upddata = array('location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updated_on' => $curdt);
            $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
            $this->updateuserpartytypes($prsnt_partytype, $party_types, $custid, $cwhr['party_type_id'], $cmpcode, $branchcode, $uid, "Shipper");
        } else {
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array('party_type_id' => $cwhr['party_type_id'], 'name' => $customer['name'], 'email' => 'svkonekt@kuehne-nagel.com', 'mobile' => $customer['custid'], 'location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $cwhr['party_type_id'];
        return $res;
    }

    public function checkcustomer($customer, $cmpcode, $branchcode, $uid, $custtype)
    {
        $cwhr1 = ['code' => $customer['custid'],'company_code' => $cmpcode, 'branch_code' => $branchcode];
        $pwhr1 = array("code" => $customer['custid'],"company_code" =>$cmpcode);
        $cselect = 'id';
        $cpselect = 'id,party_type_id,party_types';
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $curdt = $getactual['datetime'];
        $cust_id = 0;
        if ($custtype == "PF") {
            $ctable = 'tb_customers';
            $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, $ctable, 0, 0);
            if (count($chkcust) > 0) {
                $cust_id = $chkcust['id'];
                $upddata = array('location' => $customer['city'], 'address' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updatedon' => $curdt);
                $upd = $this->db->where(array("id" => $cust_id))->update('tb_customers', $upddata);
            } else {
                $randnum = $customer['custid'];
                $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                $cinsdata = array('name' => $customer['name'], 'phone' => $customer['custid'], 'location' => $customer['city'], 'address' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'password' => $pwd, 'user_id' => $uid, 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt);
                $cust_id = $this->common->insertTableData('tb_customers', $cinsdata);
            }
            $party_type_id = 0;
            $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", array("name" => "Customer", "user_id" => $uid, 'company_code' => $cmpcode), 1, 0);
            if ($chkpartytype->num_rows() > 0) {
                $party_type_id = $chkpartytype->row()->id;
            }
            if ($party_type_id > 0) {
                $chkcust = $this->common->gettblrowdata($pwhr1, $cpselect, "tbl_party_master", 0, 0);
                if (count($chkcust) > 0) {
                    $custid = $chkcust['id'];
                    $party_types = $chkcust['party_types'];
                    $prsnt_partytype = $chkcust['party_type_id'];
                    $upddata = array('location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updated_on' => $curdt);
                    $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
                    $this->updateuserpartytypes($prsnt_partytype, $party_types, $custid, $party_type_id, $cmpcode, $branchcode, $uid, "Customer");
                } else {
                    $randnum = $customer['custid'];
                    $pwd = password_hash($randnum, PASSWORD_DEFAULT);
                    $cinsdata = array('party_type_id' => $party_type_id, 'name' => $customer['name'], 'email' => 'svkonekt@kuehne-nagel.com', 'mobile' => $customer['custid'], 'location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                    $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
                }
            }
        }
        $cwhr['party_type_id'] = 7;
        $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", array("name" => "FREIGHT_PAYER", "user_id" => $uid, 'company_code' => $cmpcode), 1, 0);
        if ($chkpartytype->num_rows() > 0) {
            $cwhr['party_type_id'] = $chkpartytype->row()->id;
        }
        $chkcust = $this->common->gettblrowdata($pwhr1, $cpselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $party_types = $chkcust['party_types'];
            $prsnt_partytype = $chkcust['party_type_id'];
            $upddata = array('location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'user_id' => $uid, 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'updated_on' => $curdt);
            $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
            $this->updateuserpartytypes($prsnt_partytype, $party_types, $custid, $cwhr['party_type_id'], $cmpcode, $branchcode, $uid, "FREIGHT_PAYER");
        } else {
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum, PASSWORD_DEFAULT);
            $cinsdata = array('party_type_id' => $cwhr['party_type_id'], 'name' => $customer['name'], 'email' => 'svkonekt@kuehne-nagel.com', 'mobile' => $customer['custid'], 'location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'code' => $customer['custid'], 'country' => $customer['country'], 'user_id' => $uid, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $cmpcode, 'branch_code' => $branchcode, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
            $custid = $this->common->insertTableData('tbl_party_master', $cinsdata);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $cwhr['party_type_id'];
        return $res;
    }

    public function checkcarrier($customer, $companyCode, $branchCode, $userId)
    {
        $response = [];
        $currentDatetime = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $currentDatetime, $curtz);
        $currentDatetime = $getactual['datetime'];
        $partyTypeId = 2;
        $partyMasterWhere = ['code' => $customer['custid'],'company_code' =>$companyCode,'branch_code' =>$branchCode];
        $checkPartyType = $this->db->select('id')->get_where('tbl_party_types', ['name' => 'Carrier', 'user_id' => $userId, 'company_code' => $companyCode], 1, 0);
        if ($checkPartyType->num_rows() > 0) {
            $partyTypeId = $checkPartyType->row()->id;
        }
        if (isset($customer['custid'])) {
            $vendorWhereCondition = ['code' => $customer['custid'],'company_code' => $companyCode, 'branch_code' => $branchCode];
            $checkVendor = $this->common->gettblrowdata($vendorWhereCondition, 'id', 'tb_vendors', 0, 0);
            if (count($checkVendor) > 0) {
                $vendorId = $checkVendor['id'];
                $addressess = $customer['street'] . ", " . $customer['street1'] . ", " . $customer['city'] . ", " . $customer['country'] . ", " . $customer['zip'];
                $updateData = ['location' => $customer['city'], 'address' => $addressess, 'pincode' => $customer['zip'], 'country' => $customer['country'], 'effective_date' => date('Y-m-d'), 'expiry_date' => date('Y-m-d'), 'service_id' => $customer['custid'], 'service_name' => $customer['partyid'], 'user_id' => $userId, 'company_code' => $companyCode, 'branch_code' => $branchCode, 'status' => 1, 'updated_on' => $currentDatetime];
                $updateVendor = $this->db->where(['id' => $vendorId])->update('tb_vendors', $updateData);
            } else {
                $vendorId = 0;
                $checkIdVendor = [];
                if (in_array($companyCode,self::CHECK_CARRIERS_WITH_COMPANY_CODE)) {
                    $checkIdVendor = $this->common->gettblrowdata(['code' => $customer['custid'], 'company_code' => $companyCode, 'status' => '1'], 'id', 'tb_vendors', 0, 0);
                    if (!empty($checkIdVendor)) {
                        $vendorId = $checkIdVendor['id'];
                        $address = $customer['street'] . ", " . $customer['street1'] . ", " . $customer['city'] . ", " . $customer['country'] . ", " . $customer['zip'];
                        $this->common->updatetbledata("tb_vendors", ['location' => $customer['city'], 'address' => $address, 'pincode' => $customer['zip'], 'country' => $customer['country'], 'effective_date' => date('Y-m-d'), 'expiry_date' => date('Y-m-d'), 'service_id' => $customer['custid'], 'service_name' => $customer['partyid'], 'company_code' => $companyCode, 'status' => 1, 'updated_on' => $currentDatetime], ['id' => $vendorId]);
                    }
                }
                if (empty($checkIdVendor)) {
                    $randNumber = trim($customer['custid']);
                    $randNumber = str_replace([" ", "+", "-"], "", $randNumber);
                    $password = password_hash($randNumber, PASSWORD_DEFAULT);
                    $addressess = $customer['street'] . ", " . $customer['street1'] . ", " . $customer['city'] . ", " . $customer['country'] . ", " . $customer['zip'];
                    $vendorInsertData = [
                        'name' => $customer['name'],
                        'mobile' => $customer['custid'],
                        'location' => $customer['city'],
                        'address' => $addressess,
                        'pincode' => $customer['zip'],
                        'country' => $customer['country'],
                        'password' => $password,
                        'email' => '',
                        'code' => $customer['custid'],
                        'offering_type' => 'FTL',
                        'carrier_grade' => 'ABC',
                        'effective_date' => date('Y-m-d'),
                        'expiry_date' => date('Y-m-d'),
                        'service_id' => $customer['custid'],
                        'service_name' => $customer['partyid'],
                        'user_id' => $userId,
                        'company_code' => $companyCode,
                        'branch_code' => $branchCode,
                        'status' => 1,
                        'created_on' => $currentDatetime,
                        'updated_on' => $currentDatetime
                    ];
                    $vendorId = $this->common->insertTableData('tb_vendors', $vendorInsertData);
                }
            }
            $checkCarrier = $this->common->gettblrowdata($partyMasterWhere, 'id,party_type_id,party_types', 'tbl_party_master', 0, 0);
            if (count($checkCarrier) > 0) {
                $carrierId = $checkCarrier['id'];
                $partyTypes = $checkCarrier['party_types'];
                $presentPartytype = $checkCarrier['party_type_id'];
                $carrierUpdateData = ['location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'user_id' => $userId, 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $companyCode, 'branch_code' => $branchCode, 'status' => 1, 'updated_on' => $currentDatetime];
                $updateCarrier = $this->db->where(["id" => $carrierId])->update('tbl_party_master', $carrierUpdateData);
                $this->updateuserpartytypes($presentPartytype, $partyTypes, $carrierId, $partyTypeId, $companyCode, $branchCode, $userId, "Carrier");
            } else {
                $carrierId = 0;
                $checkPartyMaster = [];
                if (in_array($companyCode, self::CHECK_CARRIERS_WITH_COMPANY_CODE)) {
                    $checkPartyMaster = $this->common->gettblrowdata(['code' => $customer['custid'], 'company_code' => $companyCode, 'status' => '1'], 'id,party_type_id,party_types', 'tbl_party_master', 0, 0);
                    if (!empty($checkPartyMaster)) {
                        $carrierId = $checkPartyMaster['id'];
                        $partyTypes = $checkPartyMaster['party_types'];
                        $presentPartytype = $checkPartyMaster['party_type_id'];
                        $this->common->updatetbledata("tbl_party_master", ['location_id' => $customer['city'], 'street' => $customer['street'], 'pincode' => $customer['zip'], 'country' => $customer['country'], 'customeridentifier' => $customer['custid'], 'partyindetifier' => $customer['partyid'], 'company_code' => $companyCode, 'status' => 1, 'updated_on' => $currentDatetime], ['id' => $carrierId]);
                        $this->updateuserpartytypes($presentPartytype, $partyTypes, $carrierId, $partyTypeId, $companyCode, $branchCode, $userId, "Carrier");
                    }
                }
                if (empty($checkPartyMaster)) {
                    $randNumber = trim($customer['custid']);
                    $randNumber = str_replace([" ", "+", "-"], "", $randNumber);
                    $password = password_hash($randNumber, PASSWORD_DEFAULT);
                    $carrierInsertData = [
                        'party_type_id' => $partyTypeId,
                        'name' => $customer['name'],
                        'email' => 'svkonekt@kuehne-nagel.com',
                        'mobile' => $customer['custid'],
                        'location_id' => $customer['city'],
                        'street' => $customer['street'],
                        'pincode' => $customer['zip'],
                        'code' => $customer['custid'],
                        'country' => $customer['country'],
                        'user_id' => $userId,
                        'customeridentifier' => $customer['custid'],
                        'partyindetifier' => $customer['partyid'],
                        'company_code' => $companyCode,
                        'branch_code' => $branchCode,
                        'status' => 1,
                        'created_on' => $currentDatetime,
                        'updated_on' => $currentDatetime
                    ];
                    $carrierId = $this->common->insertTableData('tbl_party_master', $carrierInsertData);
                }
            }
        } else {
            $randNumber = time();
            $password = password_hash($randNumber, PASSWORD_DEFAULT);
            if (strlen($companyCode) > 2) {
                $countryCode = substr($companyCode, 0, 2);
            } else {
                $countryCode = $companyCode;
            }
            $address = $countryCode;
            $effectiveDate = date('Y-m-d');
            $vendorInsertData = ['name' => $countryCode . "_Carrier", 'mobile' => $randNumber, 'location' => $countryCode, 'address' => $address, 'pincode' => $address, 'country' => $countryCode, 'password' => $password, 'email' => '', 'code' => $randNumber, 'offering_type' => 'FTL', 'carrier_grade' => 'ABC', 'effectiveDate' => $effectiveDate, 'expiry_date' => "", 'service_id' => $randNumber, 'service_name' => "", 'user_id' => $userId, 'company_code' => $companyCode, 'branch_code' => $branchCode, 'status' => 1, 'created_on' => $currentDatetime, 'updated_on' => $currentDatetime];
            $vendorId = $this->common->insertTableData('tb_vendors', $vendorInsertData);
            $carrierInsertData = ['party_type_id' => $partyTypeId, 'name' => $countryCode . "_Carrier", 'email' => 'svkonekt@kuehne-nagel.com', 'mobile' => $randNumber, 'location_id' => $countryCode, 'address' => $address, 'pincode' => '1111', 'code' => $randNumber, 'country' => $countryCode, 'user_id' => $userId, 'company_code' => $companyCode, 'branch_code' => $branchCode, 'status' => 1, 'created_on' => $currentDatetime, 'updated_on' => $currentDatetime];
            $carrierId = $this->common->insertTableData('tbl_party_master', $carrierInsertData);
        }
        $response['id'] = $vendorId;
        $response['party_id'] = $carrierId;
        $response['party_type'] = $partyTypeId;
        return $response;
    }

    public function updatestatus()
    {
        $postData = file_get_contents('php://input');
        $xml = new SimpleXMLElement($postData);
        $userid = 1;
        $response = 0;
        $statusmsg = "";
        if ($xml === false) {
            $statusmsg = "Invalid request,Please try again!";
        } else {
            /*log_message("error","req_status_data ".json_encode($postData));*/
            $shipdata = $this->read_shipmentstatus($xml);
            $logdate = date('Y-m-d H:i:s');
            if (!empty($shipdata)) {
                // print_r($shipdata);
                /*log_message("error","parsed_status_data ".json_encode($shipdata));
			   $response = $this->111insert_ShipmentData($shipdata,$logdate);*/
            }
            if ($response > 0) {
                $statusmsg = "Success";
            } else {
                $statusmsg = "Failed for unformatted request,Please try again!";
            }
        }
        echo $statusmsg;
    }

    public function read_shipmentstatus($xml)
    {
        self::mapXmlNamespaces($xml);

        $res = array();
        $mdata = $xml->xpath('//eTN_ns9:RoadStatus');
        $data = $xml->xpath('eTN_ns2:MessageHeader');
        $physicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->PhysicalReceiver);
        $logicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->LogicalReceiver);
        $physicalsender = (string)($data[0]->xpath('PhysicalSender')[0]);
        $logicalsender = (string)($data[0]->xpath('LogicalSender')[0]);
        $lreceiver = $preceiver = $psender = $lsender = "";
        $driver = $carrier = array();
        $preceiver = $physicalreceiver;
        $lreceiver = $logicalreceiver;
        $psender = $physicalsender;
        $lsender = $logicalsender;
        $sendapp = (string)($data[0]->xpath('SendingApplication')[0]);
        $msgtype = (string)($data[0]->xpath('MessageType')[0]);
        $version = (string)($data[0]->xpath('VersionNumber')[0]);
        $createdtime = (string)($data[0]->xpath('CreationDateTime')[0]);
        if ($createdtime != "") {
            $createdtime = date("Y-m-d H:i:s", strtotime($createdtime));
        } else {
            $createdtime = date("Y-m-d H:i:s");
        }
        $res['header'] = array("preceiver" => $preceiver, "lreceiver" => $lreceiver, "psender" => $psender, "lsender" => $lsender, "sendapp" => $sendapp, "msgtype" => $msgtype, "version" => $version, "createdtime" => $createdtime);
        /* truck and trailer info */

        // ligne 241 04 74 09 30 00
        // Régulation de la ligne 241
        //
        $arr = array();
        $msgdata = $xml->Message;
        $titledata = $msgdata->xpath('//eTN_ns4:MessageLevel');
        $arr['orderid'] = (string)($titledata[0]->xpath('TrackingNumber')[0]);
        $arr['sendercmpcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->CompanyCode);
        $arr['senderbranchcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->BranchCode);
        $arr['senderdepcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->DepartmentCode);
        $arr['sendertransmode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport);
        $arr['refcode'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Code);
        $arr['refvalue'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Value);
        $stsdata = $msgdata->xpath('//eTN_ns5:StatusInformation');
        $arr['status_code'] = (string) $stsdata[0]->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->StatusCode;
        $arr['status_date'] = (string)($stsdata[0]->xpath('StatusDate')[0]);
        $arr['status_time'] = (string)($stsdata[0]->xpath('StatusTime')[0]);
        $arr['status_time'] = date('H:i:s', strtotime($arr['status_time']));
        $arr['status_loc'] = (string)($stsdata[0]->xpath('StatusLocation')[0]);
        $arr['status_loc1'] = (string)($stsdata[0]->xpath('StatusLocation')[1]);
        $arr['status_additionaltime'] = "";
        if (isset($stsdata[0]->xpath('AdditionalStatusInformation')[0]->StatusEntryDateTime)) {
            $arr['status_additionaltime'] = (string)($stsdata[0]->xpath('AdditionalStatusInformation')[0]->StatusEntryDateTime);
            $arr['status_additionaltime'] = date('H:i:s', strtotime($arr['status_additionaltime']));
        }
        $infodata1 = $mdata[0]->xpath('Message')[0]->Shipment;
        $refdetail = $infodata1->xpath('//eTN_ns6:ReferencesDetails');
        $arr['ref_type'] = (string) $refdetail[0]->attributes(self::getNamespaceFromPrefix('eTN_ns1'))->AddressType;
        $arr['ref_code'] = (string)($refdetail[0]->xpath('Code')[0]);
        $arr['ref_value'] = (string)($refdetail[0]->xpath('Value')[0]);
        $res['general'] = $arr;
        return $res;
    }
    //dhanu added
    //generating QR codes and storing as foreigh key with tb_order_cargo_details table id column with tb_order_cargo_qrdetails table order_cargo_details_id
    public function generateQRCodes($cargo_id, $cargodata)
    {
        $this->load->library('barcode');
        $qrid = array();
        $handling_unit = $cargodata["handling_unit"];
        $quantity = $cargodata["quantity"] ?? 0;
        $data = [];
        $data["order_cargo_details_id"] = $cargo_id;
        $data["handling_unit"] = $handling_unit;
        $data["quantity"] = $quantity;
        $data["path"] = $qrid['qr_path'] = $this->barcode->generate(json_encode(array("cargo_id" => $handling_unit, "quantity" => $quantity)));
        $qrid['id'] = $this->common->insertTableData("tb_order_cargo_qrdetails", $data);
        return $qrid;
    }

    public function barcode()
    {
        $data["path"] = "";
        $this->load->library('barcode');
        if (!empty($_POST["qr_text"])) {
            $data["path"] = $this->barcode->generate($_POST["qr_text"]);
        }
        $this->load->view("barcode", $data);
    }

    public function sendQRmail($cust)
    {
        $chkcust = $this->db->select("name,email_id")->get_where("tb_customers", array("id" => $cust['cust_id'], "email_id <>" => ""), 1, 0);
        if ($chkcust->num_rows() > 0) {
            $this->load->library('email');
            $receivecc = "external.ram.k@kuehne-nagel.com";
            $receivemail = $chkcust->row()->email_id;
            $receivename = $chkcust->row()->name;
            if ($receivemail == "seeta.krishnan@kuehne-nagel.com") {
            } else {
                $this->email->to($receivemail, $receivename);
                if ($receivecc != "") {
                    $this->email->cc($receivecc, "RCREDDY");
                }
                $data['page_title'] = "QR CODE";
                $data['receivename'] = $receivename;
                $data['weight'] = isset($cust['gross_weight']) ? $cust['gross_weight'] : 1;
                $data['volume'] = isset($cust['volume']) ? $cust['volume'] : 1;
                $data['quantity'] = isset($cust['pkgs_count']) ? $cust['pkgs_count'] : 1;
                $data['quantity_type'] = isset($cust['pkgs_uom']) ? $cust['pkgs_uom'] : "PCS";
                $data['cargo_content'] = isset($cust['cargo_content']) ? $cust['cargo_content'] : "Boxes";
                $data['order_id'] = isset($cust['order_id']) ? $cust['order_id'] : "NA";
                $data['qr_path'] = isset($cust['qr_path']) ? $cust['qr_path'] : "NA";
                $data['subject'] = "svkonekt :: QR Code for your order cargo";
                $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                $this->email->subject($data['subject']);
                $this->email->set_mailtype('html');
                $body = $this->load->view('mail_forms/orderqrinfo', $data, true);
                $this->email->message($body);
                $send = $this->email->send();
                $this->sendnotify('booking_create', $data['order_id']);
            }
        }
    }

    public function updateuserpartytypes($prsnt_partytype, $party_types, $custid, $party_type_id, $cmpcode, $branchcode, $uid, $type)
    {
        $strrec_types = "";
        $party_ar = $names = $recent_types = array();
        if ($custid > 0) {
            if ($party_types != "") {
                $party_ar = explode(',', $party_types);
            }
            $sts = 0;
            if (empty($party_ar)) {
                $sts = 1;
                $party_ar[] = $party_type_id;
            }

            if (!empty($party_ar)) {
                if (!empty($party_ar)) {
                    array_unique($party_ar);
                    $getpartytypes_id = $this->db->query("SELECT id FROM tbl_party_types WHERE id IN (" . implode(',', $party_ar) . ") GROUP BY name");
                    if ($getpartytypes_id->num_rows() > 0) {
                        foreach ($getpartytypes_id->result() as $res) {
                            $recent_types[] = $res->id;
                        }
                    }
                    if (strtoupper($type) == "CUSTOMER" || strtoupper($type) == "CARRIER") {
                        if (!empty($recent_types)) {
                            if ($sts == 1) {
                                $strrec_types = $prsnt_partytype;
                            } else {
                                array_push($recent_types, $prsnt_partytype);
                                $r_types = array_unique($recent_types);
                                foreach (array_keys($r_types, $party_type_id) as $key) {
                                    unset($r_types[$key]);
                                }
                                $strrec_types = implode(",", $r_types);
                            }
                            $upddata = array('party_type_id' => $party_type_id, 'party_types' => $strrec_types);
                            $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
                        }
                    } else {
                        if (!empty($recent_types)) {
                            if ($sts == 0) {
                                array_push($recent_types, $party_type_id);
                            }
                            $r_types = array_unique($recent_types);
                            /* foreach (array_keys($r_types, $party_type_id) as $key) {
                            unset($r_types[$key]);
                        }*/
                            $strrec_types = implode(",", $r_types);
                            $upddata = array('party_types' => $strrec_types);
                            $upd = $this->db->where(array("id" => $custid))->update('tbl_party_master', $upddata);
                        }

                    }
                }
            }
        }
    }

    public function sendnotify($action, $orderid)
    {
        if (!empty($orderid)) {
            $this->load->library('notifytrigger');
            $info['page_title'] = 'Booking Notification';
            $info['orderid'] = $bookingId = $orderid;
            $orderinfo = $this->common->gettblrowdata(array('order_id' => $orderid, 'status' => 1), 'id', 'tb_orders', 0, 0);
            if (count($orderinfo) > 0) {
                $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
                $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
                $info['order_id'] = $orderinfo['id'];
                $info['action'] = $action;
                $info['cargos'] = $this->common->gettbldata(array('order_id' => $info['order_id']), 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $this->notifytrigger->sendordernotify($info);
            }/* else {
				log_message('error','No Order info');
			}*/
        }
    }

    /**
     * @param string $statusMessage
     */
    private function saveToEdiLog(string $statusMessage): void
    {
        $this->edi_logger->setEdi_type(1);
        $this->edi_logger->setTransaction_id(time());
        $this->edi_logger->setEdi_name('ROADLOG');
        $this->edi_logger->setBounded_type(1);
        $this->edi_logger->setEdi_format_type('XML');
        $this->edi_logger->setStatus(($statusMessage == 'Success' ? 1 : 0));
        $this->edi_logger->setEdi_response($statusMessage);
        $this->edi_logger->setObj_type_name('Tour Number');
        $this->edi_logger->saveToEdiLogs();
    }

    private function checkCargodetails(string $orderId): array
    {
        $this->db->select('cd.id');
        $this->db->from("tb_cargo_details cd");
        $this->db->join('tb_order_cargodetails ocd', 'cd.id = ocd.cargo_id', 'LEFT');
        $this->db->where('ocd.order_id', $orderId);
        $this->db->where('ocd.status', 1);
        $data = $this->db->get();
        return $data->result_array();
    }

    private function trailerMasterHandler(string $trailerName): int
    {
        $this->load->model('TrailerMasterModel');
        return $this->TrailerMasterModel->add($trailerName);
    }

    private static function mapXmlNamespaces(\SimpleXMLElement $xml): void
    {
        foreach (self::$namespaces as $prefix => $namespace) {
            $xml->registerXPathNamespace($prefix, $namespace);
        }
    }

    private static function getNamespaceFromPrefix(string $prefix): string
    {
        if (! isset(self::$namespaces[$prefix])) {
            throw new \RuntimeException('XML prefix is unknown');
        }

        return self::$namespaces[$prefix];
    }
    private function getOrderIdByReference(array $shipdata): int
    {
        $orderNumber = 0;
        if (!empty($shipdata['references'])) {
            foreach ($shipdata['references'] as $shipref) {
                if ($shipref['code'] == "INN" && $shipref['value'] != "") {
                    $checkReference = $this->common->gettblrowdata(['order_id' => str_replace("ET", "", $shipref['value'])], "id", "tb_orders", 0, 0);
                    if (!empty($checkReference)) {
                        $orderNumber = $checkReference['id'];
                    }
                }
            }
        }
        if ($orderNumber == 0) {
            $checkOrder = $this->common->gettblrowdata(["order_id" => $shipdata['orderid']], "id", "tb_orders", 0, 0);
            if (!empty($checkOrder)) {
                $orderNo = $checkOrder['id'];
            }
            //log_message("error", "Order Table" . $orderNo);
        }
        //log_message("error", "Order Reference Table" . $orderNumber);
        return $orderNo ?? $orderNumber;
    }
}
