<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Routevehicleinfo extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('routevehmodel');       
    }

    public function index(){
        $data = $result = $post = array();
        $company_code = $this->session->userdata('company_code');
        $data['page_title'] = $this->lang->line('route_veh_opt');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }
        if (! empty($post)) {
            $whr = $this->searchorders($post);
            if(!empty($whr)){
                if($company_code != ""){
                    $ordersdata = $this->routevehmodel->getcountrywiseordersdetails($company_code,$whr,$curtz);
					
                    if(!empty($ordersdata)){
                        foreach ($ordersdata as $row) {
                            $ddate = $row['delivered_date'];
							$trip_id=$row['trip_id'];
							$shift_id=$row['shift_id'];
                            if($ddate == ""){
                                $ddate = $row['ealry_delivery'];
                            }
                            $time_diff ="";
                            $driver_accept = $row['driver_accept'];
                            if($ddate != "" && $driver_accept != ""){
                                $date1 = new DateTime($driver_accept);
                                $date2 = new DateTime($ddate);
                                $interval = date_diff($date1,$date2);
                                $time_diff = $interval->format('%h:%i')." hrs";
                            }
                            $vehicle_type = $vehicle_no =  "";
							$distance  = 0;
                           
							if($trip_id>0){								
								$tripsdata = $this->routevehmodel->gettripdetails($trip_id);
								if(!empty($tripsdata)){
									foreach ($tripsdata as $tripsdatarow) {
										$vehicle_type=$tripsdatarow['register_number'];
										$vehicle_no=$tripsdatarow['trucktype'];
										$distance  =$tripsdatarow['distance'];
									}
								}	
							}else{
								if($shift_id>0){
									$shift_data = $this->routevehmodel->getshipmentdetails($shift_id);
									if(!empty($shift_data)){
										foreach ($shift_data as $shift_row) {
											$vehicle_type=$shift_row['register_number'];
											$vehicle_no=$shift_row['trucktype'];
											$distance  =$shift_row['distance'];
										}
									}
									
								}						
								
							}
							$distance=number_format((float)$distance, 2, '.', '');
							
							
                            $result[] = array('order_id'=>$row['order_id'],'pickup_company'=>$row['pickup_company'],'delivery_company'=>$row['delivery_company'],'pickup_country'=>$row['pickup_country'],'delivery_country'=>$row['delivery_country'],'pickup_city'=>$row['pickup_city'],'delivery_city'=>$row['delivery_city'],'pickup_pincode'=>$row['pickup_pincode'],'delivery_pincode'=>$row['delivery_pincode'],'totwg'=>$row['totwg'],'totvol'=>$row['totvol'],'delivered_date'=>$ddate,'driver_accept'=>$driver_accept,'customer_name'=>$row['customer_name'],'customer_country'=>$row['customer_country'],'transport_mode'=>$row['transport_mode'],"time_diff"=>$time_diff,'vehicle_type'=>$vehicle_type,'vehicle_no'=>$vehicle_no,'distance'=>$distance);
                        }
                    }
                }
            }
        }
        $data['result'] = $result;
        $this->newtemplate->dashboard('routevehicleinfo/index', $data);
    }
     public function searchorders($post){
        $whr = array();
        $cdate = date('Y-m-d H:i:s');
        $curtz  = $this->session->userdata("usr_tzone")['timezone'];
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate = date('Y-m-d', strtotime($post['fromdate'])); 
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;
            if (isset($post['todate'])) {
                if ($post['todate'] != "") {
                    $todate = date('Y-m-d', strtotime($post['todate']));
                    $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
                }
            } else {
                $todate = date('Y-m-d', strtotime($cdate));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
            }
        }
        return $whr;
    }
}
?>