<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Routing extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['routingauto', 'ordertypemodel', 'common', 'bpartners', 'triptemplatemodel']);
        $this->load->library(['session', 'form_validation']);
        if (!checkUrlAccessForUser('ROUTING')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data['reftypes'] = $data['getparties'] = $data['tran_types'] = $data['products'] = $data['incoterms'] = $data['services'] = $data['transmodes'] = [];
        $data['page_title'] = "Trip Automation";
        $data['sub_title'] = "Routing";
        $custcode = $custname = $transtype = $triggerat = $ordertype = $sproduct = $sservice = $smot = $sinco_terms = '';

        $post1 = $this->input->post(null, true);
        if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
            $post = $post1;
        } else {
            $post = [];
        }
        $whr = $templateIds = [];
        if (!empty($post)) {
            if (isset($post['customer_code']) && $post['customer_code'] != "") {
                $whr['ra.cust_code'] = $post['customer_code'];
                $custcode = $post['customer_code'];
            }
            if (isset($post['customer_name']) && $post['customer_name'] != "") {
                $whr['c.name'] = $post['customer_name'];
                $custname = $post['customer_name'];
            }
            if (isset($post['trans_type']) && $post['trans_type'] != "") {
                $whr['ra.trans_type'] = $post['trans_type'];
                $transtype = $post['trans_type'];
            }
            if (isset($post['triggeredAt']) && $post['triggeredAt'] != "") {
                $whr['ra.trigger_at'] = $post['triggeredAt'];
                $triggerat = $post['triggeredAt'];
            }
            if (isset($post['order_type']) && $post['order_type'] != "") {
                $whr['ra.order_type'] = $post['order_type'];
                $ordertype = $post['order_type'];
            }
            if (isset($post['product']) && $post['product'] != "") {
                $whr['ra.product'] = $post['product'];
                $sproduct = $post['product'];
            }
            if (isset($post['service']) && $post['service'] != "") {
                $whr['ra.service'] = $post['service'];
                $sservice = $post['service'];
            }
            if (isset($post['mot']) && $post['mot'] != "") {
                $whr['ra.mot'] = $post['mot'];
                $smot = $post['mot'];
            }
            if (isset($post['inco_terms']) && $post['inco_terms'] != "") {
                $whr['ra.inco_terms'] = $post['inco_terms'];
                $sinco_terms = $post['inco_terms'];
            }
        }

        $uid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $list_val = [];

        if (!empty($post)) {
            $getalldata = $this->routingauto->getroutedata($uid, $whr);
        } else {
            $getalldata = $this->routingauto->getalldata($uid);
        }

        if ($getalldata != false && count($getalldata->result_array()) > 0) {
            foreach ($getalldata->result_array() as $res) {
                $action = $incoterm = $product = $mot = $carrier_name = $service = $order_type = $trucktype = $vehicleid = $driverid = '';
                $trans_type = $res['trans_type'];

                $where = ['id' => $trans_type];
                $chkaction = $this->common->gettblrowdata($where, "name", "tbl_txn_actions", 0, 0);
                if (count($chkaction) > 0) {
                    $action = $chkaction['name'];
                }
                $where = ['id' => $res['inco_terms']];
                $chkincoterm = $this->common->gettblrowdata($where, "name", "tb_incoterms_master", 0, 0);
                if (count($chkincoterm) > 0) {
                    $incoterm = $chkincoterm['name'];
                }

                $where = ['id' => $res['product']];
                $getproducts = $this->common->gettblrowdata($where, "id,name", "tb_products_master", 0, 0);
                if (count($getproducts) > 0) {
                    $product = $getproducts['name'];
                }

                $where = ['id' => $res['mot']];
                $getmot = $this->common->gettblrowdata($where, "id,code", "tb_transportmode", 0, 0);
                if (count($getmot) > 0) {
                    $mot = $getmot['code'];
                }

                $where = ['id' => $res['carrier_id']];
                $vendor_list = $this->common->gettblrowdata($where, "id,name,code", "tb_vendors", 0, 0);
                if (count($vendor_list) > 0) {
                    $carrier_name = $vendor_list['name'];
                }

                $where = ['id' => $res['order_type']];
                $getordertypes = $this->common->gettblrowdata($where, "id,type_name", "tb_order_types", 0, 0);
                if (count($getordertypes) > 0) {
                    $order_type = $getordertypes['type_name'];
                }

                $where = ['id' => $res['service']];
                $getservices = $this->common->gettblrowdata($where, "id,name", "tb_service_master", 0, 0);
                if (count($getservices) > 0) {
                    $service = $getservices['name'];
                }

                $where = ['id' => $res['vehicle_type']];
                $vehicletypeinfo = $this->common->gettblrowdata($where, "trucktype", "tb_trucktypes", 0, 0);
                if (count($vehicletypeinfo) > 0) {
                    $trucktype = $vehicletypeinfo['trucktype'];
                }
                $data['products'] = getProductMasterData();
                $data['services'] = getServiceMasterData();
                $data['transmodes'] = gettransportmode();

                if ($res['vehicle_id'] != '' && $res['vehicle_id'] != 0) {
                    $where = ['id' => $res['vehicle_id']];
                    $vehicleidinfo = $this->common->gettblrowdata($where, "truck_number", "tb_trucks_data", 0, 0);
                    if (count($vehicleidinfo) > 0) {
                        $vehicleid = $vehicleidinfo['truck_number'];
                    }
                }

                if ($res['driver_id'] != '' && $res['driver_id'] != 0) {
                    $where = ['id' => $res['driver_id']];
                    $driveridinfo = $this->common->gettblrowdata($where, "name", "tb_truck_drivers", 0, 0);
                    if (count($driveridinfo) > 0) {
                        $driverid = $driveridinfo['name'];
                    }
                }
                $templateId = $res['template_id'];
                if ($templateId > 0) {
                    $templateIds[] = $templateId;
                }
                $list_val[] = [
                    'id' => $res['id'],
                    'route_id' => $res['route_id'],
                    'cust_id' => $res['cust_code'],
                    'cust_name' => $res['cust_name'],
                    'trans_type' => $action,
                    'trigger_at' => $res['trigger_at'],
                    'triggered_type' => $res['triggered_type'],
                    'order_type' => $order_type,
                    'product' => $product,
                    'service' => $service,
                    'carrier_name' => $carrier_name,
                    'mot' => $mot,
                    'incoterm' => $incoterm,
                    'trucktype' => $trucktype,
                    'driverid' => $driverid,
                    'vehicleid' => $vehicleid,
                    'templateId' => $templateId
                ];
            }
        }
        $templatesData = [];
        $data['checkCrossBorderCondition'] = checkAccessConditions('RELATED_2_CROSSBORDER', $company_code);
        if (!empty($templateIds)) {
            $templateWhereCondition = "id IN (" . implode(',', $templateIds) . " ) AND status =1";
            $getTemplateData = $this->common->gettbldata($templateWhereCondition, "id,template_id,template_name", "route_templates", 0, 0);
            foreach ($getTemplateData as $eachLine) {
                $templatesData[$eachLine['id']] = $eachLine['template_id'] . " - " . $eachLine['template_name'];
            }
        }
        $transtypes = $this->db->select("id,name")->get_where("tbl_txn_actions", ['status' => 1]);

        if ($transtypes->num_rows() > 0) {
            foreach ($transtypes->result() as $actions) {
                $data['tran_types'][] = ['id' => $actions->id, 'name' => $actions->name];
            }
        }

        if (checkAccessConditions('RELATED_2_PL_RU_VN', $company_code)) {
            $getincoterms = $this->db->query("SELECT id,name FROM tb_incoterms_master WHERE company_code LIKE '" . $company_code . "' AND status ='1'");
        } else {
            $getincoterms = $this->db->query("SELECT id,name FROM tb_incoterms_master WHERE (company_code ='' OR company_code IS NULL) AND status ='1'");
        }

        if ($getincoterms->num_rows() > 0) {
            foreach ($getincoterms->result() as $incoterms) {
                $data['incoterms'][] = ['id' => $incoterms->id, 'name' => $incoterms->name];
            }
        }

        $data['list_val'] = $list_val;
        $data['custcode'] = $custcode;
        $data['custname'] = $custname;
        $data['transtype'] = $transtype;
        $data['triggerat'] = $triggerat;

        $data['ordertype'] = $ordertype;
        $data['sproduct'] = $sproduct;
        $data['sservice'] = $sservice;
        $data['smot'] = $smot;
        $data['sinco_terms'] = $sinco_terms;
        $data['templatesData'] = $templatesData ?? [];
        
        $this->newtemplate->dashboard("routing/index", $data);
    }

    public function add()
    {
        $data = $contracts = $accounts = $data['actions'] = $data['ordertypes'] = $data['products'] = $data['services'] = $data['editypes'] = $data['transmodes'] = $data['incoterms'] = [];
        $data['page_title'] = "Trip Automation";
        $data['sub_title'] = "Add Routing";
        $uid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $data['checkCrossBorderCondition'] = checkAccessConditions('RELATED_2_CROSSBORDER', $company_code);
        $data['checkBrnReferenceCondition'] = checkAccessConditions('RELATED_2_BRN_REF_FOR_ROUTING', $company_code);
        $getactions = $this->db->select("id,name")->get_where("tbl_txn_actions", ['status' => 1]);
        if ($getactions->num_rows() > 0) {
            foreach ($getactions->result() as $actions) {
                $data['actions'][] = ['id' => $actions->id, 'name' => $actions->name];
            }
        }

        $data['products'] = getProductMasterData();
        $data['services'] = getServiceMasterData();
        $data['transmodes'] = gettransportmode();
        $custid = 0;
        $data['ordertypes'] = getOrderTypes($custid, $company_code);
        $geteditypes = $this->db->select("id,name")->get_where("tbl_edi_types", ['status' => 1]);
        if ($geteditypes->num_rows() > 0) {
            foreach ($geteditypes->result() as $editypes) {
                $data['editypes'][] = ['id' => $editypes->id, 'name' => $editypes->name];
            }
        }
        if ($company_code == "PLKN" || $company_code == 'RUKN' || $company_code == 'VNKN') {
            $getincoterms = $this->db->query("SELECT id,name FROM tb_incoterms_master WHERE company_code LIKE '" . $company_code . "' AND status ='1'");
        } else {
            $getincoterms = $this->db->query("SELECT id,name FROM tb_incoterms_master WHERE (company_code ='' OR company_code IS NULL) AND status ='1'");
        }
        if ($getincoterms->num_rows() > 0) {
            foreach ($getincoterms->result() as $incoterms) {
                $data['incoterms'][] = ['id' => $incoterms->id, 'name' => $incoterms->name];
            }
        }
        $data['contracts'] = $contracts;
        $data['accounts'] = $accounts;
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $company_code = $this->session->userdata('company_code');
        $vendors = [];
        $getTripTemplates = $this->triptemplatemodel->getTripTemplatesByUser($company_code);
        foreach ($getTripTemplates as $eachRow) {
            $data['templates'][] = ['id' => $eachRow['id'], 'templateId' => $eachRow['template_id'], 'templateName' => $eachRow['template_name']];
        }
        $permission = checkuserpermissions();

        if ($company_code == "KNAU") {
            $company_code = "AUKN";
        }

        if (in_array("carrier", $permission)) {
            $vendor_list = $this->db->select("id,name,code")->get_where("tb_vendors", ['status' => 1, 'company_code' => $company_code]);
        } else {
            $vendor_list = $this->db->select("id,name,code")->get_where("tb_vendors", ['status' => 1, 'user_id' => $uid]);
        }
        if ($vendor_list->num_rows() > 0) {
            foreach ($vendor_list->result() as $res) {
                $vendors[] = ['id' => $res->id, 'name' => $res->name, 'code' => $res->code];
            }
        }
        $permission = checkuserpermissions();

        if (in_array("vehicletypes", $permission)) {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active', 'company_code' => $company_code]);
        } else {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active']);
        }
        $data['carrierlist'] = $vendors;
        //$this->newtemplate->dashboard("routing/add", $data);
        $this->load->view("routing/add", $data);
    }


    public function save()
    {
        $post = $this->input->post(null, true);

        $uid = $this->session->userdata('user_id');
        $cust_primary = (isset($post['cust_primary']) && !empty($post['cust_primary'])) ? (string)($post['cust_primary']) : 0;
        $automation_id = (isset($post['automation_id']) && !empty($post['automation_id'])) ? (string)($post['automation_id']) : "";
        $customer_id = (isset($post['customer_id']) && !empty($post['customer_id'])) ? (string)($post['customer_id']) : 0;
        $trans_action = (isset($post['trans_action']) && !empty($post['trans_action'])) ? (string)($post['trans_action']) : 0;
        $company_code = (isset($post['company_code']) && !empty($post['company_code'])) ? (string)($post['company_code']) : "";
        $triggered_at = (isset($post['triggeredAt']) && !empty($post['triggeredAt'])) ? (string)($post['triggeredAt']) : 0;
        $order_type = (isset($post['order_type']) && !empty($post['order_type'])) ? (string)($post['order_type']) : 0;
        $order_status = (isset($post['order_status']) && !empty($post['order_status'])) ? (string)($post['order_status']) : "";
        $branch_code = (isset($post['branch_code']) && !empty($post['branch_code'])) ? (string)($post['branch_code']) : "";
        $product = (isset($post['product']) && !empty($post['product'])) ? (string)($post['product']) : 0;
        $mot = (isset($post['mot']) && !empty($post['mot'])) ? (string)($post['mot']) : 0;
        $service = (isset($post['service']) && !empty($post['service'])) ? (string)($post['service']) : 0;
        $inco_terms = (isset($post['inco_terms']) && !empty($post['inco_terms'])) ? (string)($post['inco_terms']) : 0;
        $pickup_type = (isset($post['pickup_type']) && !empty($post['pickup_type'])) ? (string)($post['pickup_type']) : "";
        $pic_value = (isset($post['pic_value']) && !empty($post['pic_value'])) ? (string)($post['pic_value']) : "";
        $delivery_type = (isset($post['delivery_type']) && !empty($post['delivery_type'])) ? (string)($post['delivery_type']) : "";
        $del_value = (isset($post['del_value']) && !empty($post['del_value'])) ? (string)($post['del_value']) : "";
        $cargo_type = (isset($post['cargo_type']) && !empty($post['cargo_type'])) ? (string)($post['cargo_type']) : 0;
        $item_id = (isset($post['item_id']) && !empty($post['item_id'])) ? (string)($post['item_id']) : 0;
        $ship_identifer = (isset($post['ship_identifer']) && !empty($post['ship_identifer'])) ? (string)($post['ship_identifer']) : "";
        $consi_identifer = (isset($post['consi_identifer']) && !empty($post['consi_identifer'])) ? (string)($post['consi_identifer']) : "";
        $notify_identifer = (isset($post['notify_identifer']) && !empty($post['notify_identifer'])) ? (string)($post['notify_identifer']) : "";
        $carrierid = (isset($post['carrierid']) && !empty($post['carrierid'])) ? (string)($post['carrierid']) : "0";

        $min_weight = (isset($post['min_weight']) && !empty($post['min_weight'])) ? $post['min_weight'] : "0.00";
        $max_weight = (isset($post['max_weight']) && !empty($post['max_weight'])) ? $post['max_weight'] : "0.00";
        $min_volume = (isset($post['min_volume']) && !empty($post['min_volume'])) ? $post['min_volume'] : "0.00";
        $max_volume = (isset($post['max_volume']) && !empty($post['max_volume'])) ? $post['max_volume'] : "0.00";

        $min_weight_uom = (isset($post['min_weight_uom']) && !empty($post['min_weight_uom'])) ? $post['min_weight_uom'] : "0.00";
        $max_weight_uom = (isset($post['max_weight_uom']) && !empty($post['max_weight_uom'])) ? $post['max_weight_uom'] : "0.00";


        $min_volume_uom = (isset($post['min_volume_uom']) && !empty($post['min_volume_uom'])) ? $post['min_volume_uom'] : "0.00";


        $max_volume_uom = (isset($post['max_volume_uom']) && !empty($post['max_volume_uom'])) ? $post['max_volume_uom'] : "0.00";

        $min_weight_ac = (isset($post['min_weight_ac']) && !empty($post['min_weight_ac'])) ? $post['min_weight_ac'] : "0.00";
        $max_weight_ac = (isset($post['max_weight_ac']) && !empty($post['max_weight_ac'])) ? $post['max_weight_ac'] : "0.00";
        $min_weight_uom_ac = (isset($post['min_weight_uom_ac']) && !empty($post['min_weight_uom_ac'])) ? $post['min_weight_uom_ac'] : "0.00";
        $max_weight_uom_ac = (isset($post['max_weight_uom_ac']) && !empty($post['max_weight_uom_ac'])) ? $post['max_weight_uom_ac'] : "0.00";

        $min_volume_ac = (isset($post['min_volume_ac']) && !empty($post['min_volume_ac'])) ? $post['min_volume_ac'] : "0.00";
        $max_volume_ac = (isset($post['max_volume_ac']) && !empty($post['max_volume_ac'])) ? $post['max_volume_ac'] : "0.00";
        $min_volume_uom_ac = (isset($post['min_volume_uom_ac']) && !empty($post['min_volume_uom_ac'])) ? $post['min_volume_uom_ac'] : "0.00";
        $max_volume_uom_ac = (isset($post['max_volume_uom_ac']) && !empty($post['max_volume_uom_ac'])) ? $post['max_volume_uom_ac'] : "0.00";


        if ($carrierid == "") {
            $carrierid = 0;
        }
        $vehicle_type = (isset($post['vehicle_type']) && !empty($post['vehicle_type'])) ? (string)($post['vehicle_type']) : "0";
        if ($vehicle_type == "") {
            $vehicle_type = 0;
        }
        $vehicle_id = (isset($post['vehicle_id']) && !empty($post['vehicle_id'])) ? (string)($post['vehicle_id']) : "0";
        if ($vehicle_id == "") {
            $vehicle_id = 0;
        }
        $driver_id = (isset($post['driver_id']) && !empty($post['driver_id'])) ? (string)($post['driver_id']) : "0";
        if ($driver_id == '') {
            $driver_id = 0;
        }
        $triggered_type = (isset($post['triggered_type']) && !empty($post['triggered_type'])) ? ($post['triggered_type']) : 0;

        $routingdata = [
            'route_id' => $automation_id,
            'cust_id' => $cust_primary,
            'trans_type' => $trans_action,
            'trigger_at' => $triggered_at,
            'order_type' => $order_type,
            'order_status' => $order_status,
            'product' => $product,
            'mot' => $mot,
            'service' => $service,
            'inco_terms' => $inco_terms,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'pick_type' => $pickup_type,
            'pick_val' => $pic_value,
            'deli_type' => $delivery_type,
            'deli_val' => $del_value,
            'cargo_type' => $cargo_type,
            'cargo_item' => $item_id,
            'ship_identifier' => $ship_identifer,
            'cons_identifier' => $consi_identifer,
            'notify_identifier' => $notify_identifer,
            'carrier_id' => $carrierid,
            'vehicle_type' => $vehicle_type,
            'vehicle_id' => $vehicle_id,
            'driver_id' => $driver_id,
            'template_id' => $post['templateId'] ?? 0,
            'status' => 1,
            'cust_code' => $customer_id,
            'user_id' => $uid,
            'triggered_type' => $triggered_type,
            'min_weight' => $min_weight,
            'max_weight' => $max_weight,
            'min_volume' => $min_volume,
            'max_volume' => $max_volume,
            'min_weight_uom' => $min_weight_uom,
            'max_weight_uom' => $max_weight_uom,
            'min_volume_uom' => $min_volume_uom,
            'max_volume_uom' => $max_volume_uom,
            'min_weight_ac' => $min_weight_ac,
            'max_weight_ac' => $max_weight_ac,
            'min_weight_uom_ac' => $min_weight_uom_ac,
            'max_weight_uom_ac' => $max_weight_uom_ac,
            'min_volume_ac' => $min_volume_ac,
            'max_volume_ac' => $max_volume_ac,
            'min_volume_uom_ac' => $min_volume_uom_ac,
            'max_volume_uom_ac' => $max_volume_uom_ac,
            'brn_reference' => $post['brnReference'] ?? "",
        ];


        $newfileid = $this->common->insertTableData("tb_routing_auto", $routingdata);
        $round_row_id = $this->db->insert_id();
        $ccode = mb_substr($company_code, 0, 2);
        $idlength = strlen($round_row_id);
        $id = $round_row_id;
        if ($idlength == '1') {
            $id = "0000" . $id;
        } else {
            if ($idlength == '2') {
                $id = "000" . $id;
            } else {
                if ($idlength == '3') {
                    $id = "00" . $id;
                } else {
                    if ($idlength == '4') {
                        $id = "0" . $id;
                    } else {
                        $id = $id;
                    }
                }
            }
        }
        $routingid = $ccode . "TA" . $id;
        $data = ['route_id' => $routingid];
        $upd = $this->routingauto->updatedata("tb_routing_auto", $round_row_id, $data);

        $this->session->set_flashdata('success_msg', 'Trip Automation Created Successfully...');
        redirect('routing');
    }

    public function view($id)
    {
        $data["page_title"] = "Routing";
        $data["page_sub"] = "View Routing";

        $uid = $this->session->userdata('user_id');
        $data['routing_row'] = $this->routingauto->getsingleRouting($uid, $id);

        $where = ['id' => $data['routing_row']->inco_terms];
        $chkincoterm = $this->common->gettblrowdata($where, "name", "tb_incoterms_master", 0, 0);
        if (count($chkincoterm) > 0) {
            $row_data['row_incoterm'] = $chkincoterm['name'];
        }

        $where = ['id' => $data['routing_row']->mot];
        $getmot = $this->common->gettblrowdata($where, "id,code", "tb_transportmode", 0, 0);
        if (count($getmot) > 0) {
            $row_data['row_mot'] = $getmot['code'];
        }

        $where = ['id' => $data['routing_row']->carrier_id];
        $vendor_list = $this->common->gettblrowdata($where, "id,name,code", "tb_vendors", 0, 0);
        if (count($vendor_list) > 0) {
            $row_data['row_carrier_name'] = $vendor_list['name'];
        }

        $where = ['id' => $data['routing_row']->order_type];
        $getordertypes = $this->common->gettblrowdata($where, "id,name", "tbl_order_types", 0, 0);
        if (count($getordertypes) > 0) {
            $row_data['row_order_type'] = $getordertypes['name'];
        }

        $where = ['id' => $data['routing_row']->service];
        $getservices = $this->common->gettblrowdata($where, "id,name", "tb_service_master", 0, 0);
        if (count($getservices) > 0) {
            $row_data['row_service'] = $getservices['name'];
        }

        $where = ['id' => $data['routing_row']->vehicle_type];
        $vehicletypeinfo = $this->common->gettblrowdata($where, "trucktype", "tb_trucktypes", 0, 0);
        if (count($vehicletypeinfo) > 0) {
            $row_data['row_trucktype'] = $vehicletypeinfo['trucktype'];
        }

        if ($data['routing_row']->vehicle_id != '' && $data['routing_row']->vehicle_id != 0) {
            $where = ['id' => $data['routing_row']->vehicle_id];
            $vehicleidinfo = $this->common->gettblrowdata($where, "truck_number", "tb_trucks_data", 0, 0);
            if (count($vehicleidinfo) > 0) {
                $row_data['row_vehicleid'] = $vehicleidinfo['truck_number'];
            }
        }

        $where = ['id' => $data['routing_row']->trans_type];
        $chkaction = $this->common->gettblrowdata($where, "name", "tbl_txn_actions", 0, 0);
        if (count($chkaction) > 0) {
            //print_r($chkaction['name']);exit;
            $row_data['row_trans_type'] = $chkaction['name'];
        }

        $where = ['id' => $data['routing_row']->product];
        $getproducts = $this->common->gettblrowdata($where, "id,name", "tb_products_master", 0, 0);
        if (count($getproducts) > 0) {
            $row_data['row_product'] = $getproducts['name'];
        }

        if ($data['routing_row']->driver_id != '' && $data['routing_row']->driver_id != 0) {
            $where = ['id' => $data['routing_row']->driver_id];
            $driveridinfo = $this->common->gettblrowdata($where, "name", "tb_truck_drivers", 0, 0);
            if (count($driveridinfo) > 0) {
                $row_data['row_driverid'] = $driveridinfo['name'];
            }
        }

        $where = ['id' => $id];
        $row_data['row_status'] = $this->common->gettblrowdata($where, "status", "tb_routing_auto", 0, 0);


        //edit
        $data = $contracts = $accounts = $data['actions'] = $data['ordertypes'] = $data['products'] = $data['services'] = $data['editypes'] = $data['transmodes'] = $data['incoterms'] = [];
        // $data['page_title'] = "Trip Automation";
        // $data['sub_title'] = "Edit Routing";
        $item_name = $cargoname = '';
        //$uid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');

        $getactions = $this->db->select("id,name")->get_where("tbl_txn_actions", ['status' => 1]);
        if ($getactions->num_rows() > 0) {
            foreach ($getactions->result() as $actions) {
                $data['actions'][] = ['id' => $actions->id, 'name' => $actions->name];
            }
        }

        $custid = 0;
        $data['ordertypes'] = getOrderTypes($custid, $company_code);
        $geteditypes = $this->db->select("id,name")->get_where("tbl_edi_types", ['status' => 1]);
        if ($geteditypes->num_rows() > 0) {
            foreach ($geteditypes->result() as $editypes) {
                $data['editypes'][] = ['id' => $editypes->id, 'name' => $editypes->name];
            }
        }
        if ($company_code == 'RUKN') {
            $getincoterms = $this->db->query("SELECT id,name FROM tb_incoterms_master WHERE name IN ('DAP','EXW') AND status ='1'");
        } else {
            $getincoterms = $this->db->select("id,name")->get_where("tb_incoterms_master", ['status' => 1]);
        }
        if ($getincoterms->num_rows() > 0) {
            foreach ($getincoterms->result() as $incoterms) {
                $data['incoterms'][] = ['id' => $incoterms->id, 'name' => $incoterms->name];
            }
        }

        $vendors = [];
        $permission = checkuserpermissions();
        if (in_array("carrier", $permission)) {
            $company_code = $this->session->userdata('company_code');
            $vendor_list = $this->db->select("id,name,code")->get_where("tb_vendors", ['status' => 1, 'company_code' => $company_code]);
        } else {
            $vendor_list = $this->db->select("id,name,code")->get_where("tb_vendors", ['status' => 1, 'user_id' => $uid]);
        }
        if ($vendor_list->num_rows() > 0) {
            foreach ($vendor_list->result() as $res) {
                $vendors[] = ['id' => $res->id, 'name' => $res->name, 'code' => $res->code];
            }
        }
        $company_code = $this->session->userdata('company_code');
        $permission = checkuserpermissions();
        if (in_array("vehicletypes", $permission)) {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active', 'company_code' => $company_code]);
        } else {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active']);
        }
        $data['carrierlist'] = $vendors;

        $getroutinginfo = $this->db->select("*")->get_where("tb_routing_auto", ['id' => $id]);
        $drivers_list = $vehile_idlist = $getorder_types = '';
        if ($getroutinginfo->num_rows() > 0) {
            $carrier_id = $getroutinginfo->row()->carrier_id;
            $vehi_id = $getroutinginfo->row()->vehicle_type;
            $drivers_list = $this->db->select("id,name")->get_where("tb_truck_drivers", ['vendor_id' => $carrier_id, 'status' => 'Active']);
            $vehile_idlist = $this->db->select("id,truck_number,register_number")->get_where("tb_trucks_data", ['truck_type' => $vehi_id, 'vendor_id' => $carrier_id]);

            $cargo_type = $getroutinginfo->row()->cargo_type;
            $cargo_item = $getroutinginfo->row()->cargo_item;
            if ($cargo_type != '' && $cargo_type != 0) {
                $cargochkqry = $this->db->query("SELECT cd.id,cd.cargo_type FROM  tb_cargo_details cd,tbl_cargo_types tc WHERE cd.cargotype_id=tc.id and cd.id=" . $cargo_type);
                if ($cargochkqry->num_rows() > 0) {
                    $cargoname = $cargochkqry->row()->cargo_type;
                }
            }
            if ($cargo_item != '' && $cargo_item != 0) {
                $itemchkqry = $this->db->query("SELECT item_id,item_name FROM tb_items WHERE id=" . $cargo_item);
                if ($itemchkqry->num_rows() > 0) {
                    $item_name = $itemchkqry->row()->item_id;
                }
            }
        }
        $data['routinfo'] = $getroutinginfo;
        $data['drivers_list'] = $drivers_list;
        $data['vehile_idlist'] = $vehile_idlist;
        $data['route_id'] = $id;
        $data['cargoname'] = $cargoname;
        $data['item_name'] = $item_name;
        $data['row_routing'] = $row_data;

        //$this->newtemplate->dashboard("routing/view", $data);
        $this->load->view("routing/view", $data);
    }

    public function edit($id)
    {
        $data = $contracts = $accounts = $data['actions'] = $data['ordertypes'] = $data['products'] = $data['services'] = $data['editypes'] = $data['transmodes'] = $data['incoterms'] = [];
        $data['page_title'] = "Trip Automation";
        $data['sub_title'] = "Edit Routing";
        $item_name = $cargoname = '';
        $uid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $data['checkCrossBorderCondition'] = checkAccessConditions('RELATED_2_CROSSBORDER', $company_code);
        $data['checkBrnReferenceCondition'] = checkAccessConditions('RELATED_2_BRN_REF_FOR_ROUTING', $company_code);
        $getactions = $this->db->select("id,name")->get_where("tbl_txn_actions", ['status' => 1]);
        if ($getactions->num_rows() > 0) {
            foreach ($getactions->result() as $actions) {
                $data['actions'][] = ['id' => $actions->id, 'name' => $actions->name];
            }
        }

        $data['products'] = getProductMasterData();
        $data['services'] = getServiceMasterData();
        $data['transmodes'] = gettransportmode();
        $custid = 0;
        $data['ordertypes'] = getOrderTypes($custid, $company_code);
        $geteditypes = $this->db->select("id,name")->get_where("tbl_edi_types", ['status' => 1]);
        if ($geteditypes->num_rows() > 0) {
            foreach ($geteditypes->result() as $editypes) {
                $data['editypes'][] = ['id' => $editypes->id, 'name' => $editypes->name];
            }
        }
        if ($company_code == "PLKN" || $company_code == 'RUKN' || $company_code == 'VNKN') {
            $getincoterms = $this->db->query("SELECT id,name FROM tb_incoterms_master WHERE company_code LIKE '" . $company_code . "' AND status ='1'");
        } else {
            $getincoterms = $this->db->query("SELECT id,name FROM tb_incoterms_master WHERE (company_code ='' OR company_code IS NULL) AND status ='1'");
        }
        if ($getincoterms->num_rows() > 0) {
            foreach ($getincoterms->result() as $incoterms) {
                $data['incoterms'][] = ['id' => $incoterms->id, 'name' => $incoterms->name];
            }
        }
        $data['contracts'] = $contracts;
        $data['accounts'] = $accounts;
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $vendors = [];
        $permission = checkuserpermissions();
        if (in_array("carrier", $permission)) {
            $company_code = $this->session->userdata('company_code');
            $vendor_list = $this->db->select("id,name,code")->get_where("tb_vendors", ['status' => 1, 'company_code' => $company_code]);
        } else {
            $vendor_list = $this->db->select("id,name,code")->get_where("tb_vendors", ['status' => 1, 'user_id' => $uid]);
        }
        if ($vendor_list->num_rows() > 0) {
            foreach ($vendor_list->result() as $res) {
                $vendors[] = ['id' => $res->id, 'name' => $res->name, 'code' => $res->code];
            }
        }
        $permission = checkuserpermissions();
        $company_code = $this->session->userdata('company_code');
        if (in_array("vehicletypes", $permission)) {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active', 'company_code' => $company_code]);
        } else {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active']);
        }
        $data['carrierlist'] = $vendors;

        $getroutinginfo = $this->db->select("*")->get_where("tb_routing_auto", ['id' => $id]);
        $drivers_list = $vehile_idlist = '';

        if ($getroutinginfo->num_rows() > 0) {
            $getTripTemplates = $this->triptemplatemodel->getTripTemplatesByUser($company_code);
            foreach ($getTripTemplates as $eachRow) {
                $data['templates'][] = ['id' => $eachRow['id'], 'templateId' => $eachRow['template_id'], 'templateName' => $eachRow['template_name']];
            }
            $carrier_id = $getroutinginfo->row()->carrier_id;
            $vehi_id = $getroutinginfo->row()->vehicle_type;
            $drivers_list = $this->db->select("id,name")->get_where("tb_truck_drivers", ['vendor_id' => $carrier_id, 'status' => 'Active']);
            $vehile_idlist = $this->db->select("id,truck_number,register_number")->get_where("tb_trucks_data", ['truck_type' => $vehi_id, 'vendor_id' => $carrier_id]);

            $cargo_type = $getroutinginfo->row()->cargo_type;
            $cargo_item = $getroutinginfo->row()->cargo_item;
            if ($cargo_type != '' && $cargo_type != 0) {
                $cargochkqry = $this->db->query("SELECT cd.id,cd.cargo_type FROM  tb_cargo_details cd,tbl_cargo_types tc WHERE cd.cargotype_id=tc.id and cd.id=" . $cargo_type);
                if ($cargochkqry->num_rows() > 0) {
                    $cargoname = $cargochkqry->row()->cargo_type;
                }
            }
            if ($cargo_item != '' && $cargo_item != 0) {
                $itemchkqry = $this->db->query("SELECT item_id,item_name FROM tb_items WHERE id=" . $cargo_item);
                if ($itemchkqry->num_rows() > 0) {
                    $item_name = $itemchkqry->row()->item_id;
                }
            }
        }

        $data['routinfo'] = $getroutinginfo;
        $data['drivers_list'] = $drivers_list;
        $data['vehile_idlist'] = $vehile_idlist;
        $data['route_id'] = $id;
        $data['cargoname'] = $cargoname;
        $data['item_name'] = $item_name;
        //$this->newtemplate->dashboard("routing/edit", $data);
        $this->load->view("routing/edit", $data);
    }

    /* update function */
    public function update()
    {
        $post = $this->input->post(null, true);
        
        $routeid = $post['routeid'] ?? "";

        $automation_id = (isset($post['automation_id']) && !empty($post['automation_id'])) ? (string)($post['automation_id']) : "";
        $customer_id = (isset($post['customer_id']) && !empty($post['customer_id'])) ? (string)($post['customer_id']) : 0;
        $trans_action = (isset($post['trans_action']) && !empty($post['trans_action'])) ? (string)($post['trans_action']) : 0;
        $company_code = (isset($post['company_code']) && !empty($post['company_code'])) ? (string)($post['company_code']) : "";
        $triggered_at = (isset($post['triggeredAt']) && !empty($post['triggeredAt'])) ? (string)($post['triggeredAt']) : 0;
        $order_type = (isset($post['order_type']) && !empty($post['order_type'])) ? (string)($post['order_type']) : 0;
        $order_status = (isset($post['order_status']) && !empty($post['order_status'])) ? (string)($post['order_status']) : "";
        $branch_code = (isset($post['branch_code']) && !empty($post['branch_code'])) ? (string)($post['branch_code']) : "";
        $product = (isset($post['product']) && !empty($post['product'])) ? (string)($post['product']) : 0;
        $mot = (isset($post['mot']) && !empty($post['mot'])) ? (string)($post['mot']) : 0;
        $service = (isset($post['service']) && !empty($post['service'])) ? (string)($post['service']) : 0;
        $inco_terms = (isset($post['inco_terms']) && !empty($post['inco_terms'])) ? (string)($post['inco_terms']) : 0;
        $pickup_type = (isset($post['pickup_type']) && !empty($post['pickup_type'])) ? (string)($post['pickup_type']) : "";
        $pic_value = (isset($post['pic_value']) && !empty($post['pic_value'])) ? (string)($post['pic_value']) : "";
        $delivery_type = (isset($post['delivery_type']) && !empty($post['delivery_type'])) ? (string)($post['delivery_type']) : "";
        $del_value = (isset($post['del_value']) && !empty($post['del_value'])) ? (string)($post['del_value']) : "";
        $cargo_type = (isset($post['cargo_type']) && !empty($post['cargo_type'])) ? (string)($post['cargo_type']) : "";
        $item_id = (isset($post['item_id']) && !empty($post['item_id'])) ? (string)($post['item_id']) : "";
        $ship_identifer = (isset($post['ship_identifer']) && !empty($post['ship_identifer'])) ? (string)($post['ship_identifer']) : "";
        $consi_identifer = (isset($post['consi_identifer']) && !empty($post['consi_identifer'])) ? (string)($post['consi_identifer']) : "";
        $notify_identifer = (isset($post['notify_identifer']) && !empty($post['notify_identifer'])) ? (string)($post['notify_identifer']) : "";
        $carrierid = (isset($post['carrierid']) && !empty($post['carrierid'])) ? (string)($post['carrierid']) : "0";

        $min_weight = (isset($post['min_weight']) && !empty($post['min_weight'])) ? $post['min_weight'] : "0.00";
        $max_weight = (isset($post['max_weight']) && !empty($post['max_weight'])) ? $post['max_weight'] : "0.00";
        $min_volume = (isset($post['min_volume']) && !empty($post['min_volume'])) ? $post['min_volume'] : "0.00";
        $max_volume = (isset($post['max_volume']) && !empty($post['max_volume'])) ? $post['max_volume'] : "0.00";

        $min_weight_uom = (isset($post['min_weight_uom']) && !empty($post['min_weight_uom'])) ? $post['min_weight_uom'] : "";
        $max_weight_uom = (isset($post['max_weight_uom']) && !empty($post['max_weight_uom'])) ? $post['max_weight_uom'] : "";

        $min_volume_uom = (isset($post['min_volume_uom']) && !empty($post['min_volume_uom'])) ? $post['min_volume_uom'] : "";

        $max_volume_uom = (isset($post['max_volume_uom']) && !empty($post['max_volume_uom'])) ? $post['max_volume_uom'] : "";

        $min_weight_ac = (isset($post['min_weight_ac']) && !empty($post['min_weight_ac'])) ? $post['min_weight_ac'] : "0.00";
        $max_weight_ac = (isset($post['max_weight_ac']) && !empty($post['max_weight_ac'])) ? $post['max_weight_ac'] : "0.00";
        $min_weight_uom_ac = (isset($post['min_weight_uom_ac']) && !empty($post['min_weight_uom_ac'])) ? $post['min_weight_uom_ac'] : "";
        $max_weight_uom_ac = (isset($post['max_weight_uom_ac']) && !empty($post['max_weight_uom_ac'])) ? $post['max_weight_uom_ac'] : "";

        $min_volume_ac = (isset($post['min_volume_ac']) && !empty($post['min_volume_ac'])) ? $post['min_volume_ac'] : "0.00";
        $max_volume_ac = (isset($post['max_volume_ac']) && !empty($post['max_volume_ac'])) ? $post['max_volume_ac'] : "0.00";
        $min_volume_uom_ac = (isset($post['min_volume_uom_ac']) && !empty($post['min_volume_uom_ac'])) ? $post['min_volume_uom_ac'] : "";
        $max_volume_uom_ac = (isset($post['max_volume_uom_ac']) && !empty($post['max_volume_uom_ac'])) ? $post['max_volume_uom_ac'] : "";


        if ($carrierid == "") {
            $carrierid = 0;
        }
        $vehicle_type = (isset($post['vehicle_type']) && !empty($post['vehicle_type'])) ? (string)($post['vehicle_type']) : "0";
        if ($vehicle_type == "") {
            $vehicle_type = 0;
        }
        $vehicle_id = (isset($post['vehicle_id']) && !empty($post['vehicle_id'])) ? (string)($post['vehicle_id']) : "0";
        if ($vehicle_id == "") {
            $vehicle_id = 0;
        }
        $driver_id = (isset($post['driver_id']) && !empty($post['driver_id'])) ? (string)($post['driver_id']) : "0";
        if ($driver_id == "") {
            $driver_id = 0;
        }
        $status = $post['status'] ?? "";
        $chkcust = $this->common->gettblrowdata(["code" => $customer_id], "id", "tb_customers", 0, 0);
        if (count($chkcust) > 0) {
            $customerRowId = $chkcust['id'];
        }
        $triggered_type = (isset($post['triggered_type']) && !empty($post['triggered_type'])) ? ($post['triggered_type']) : 0;

        $routingdata = [
            'route_id' => $automation_id,
            'cust_id' => $customerRowId ?? 0,
            'trans_type' => $trans_action,
            'trigger_at' => $triggered_at,
            'order_type' => $order_type,
            'order_status' => $order_status,
            'product' => $product,
            'mot' => $mot,
            'service' => $service,
            'inco_terms' => $inco_terms,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'pick_type' => $pickup_type,
            'pick_val' => $pic_value,
            'deli_type' => $delivery_type,
            'deli_val' => $del_value,
            'cargo_type' => $cargo_type,
            'cargo_item' => $item_id,
            'ship_identifier' => $ship_identifer,
            'cons_identifier' => $consi_identifer,
            'notify_identifier' => $notify_identifer,
            'cust_code' => $customer_id,
            'carrier_id' => $carrierid,
            'vehicle_type' => $vehicle_type,
            'vehicle_id' => $vehicle_id,
            'driver_id' => $driver_id,
            'template_id' => $post['templateId'] ?? 0,
            'status' => $status,
            'triggered_type' => $triggered_type,
            'min_weight' => $min_weight,
            'max_weight' => $max_weight,
            'min_volume' => $min_volume,
            'max_volume' => $max_volume,
            'min_weight_uom' => $min_weight_uom,
            'max_weight_uom' => $max_weight_uom,
            'min_volume_uom' => $min_volume_uom,
            'max_volume_uom' => $max_volume_uom,
            'min_weight_ac' => $min_weight_ac,
            'max_weight_ac' => $max_weight_ac,
            'min_weight_uom_ac' => $min_weight_uom_ac,
            'max_weight_uom_ac' => $max_weight_uom_ac,
            'min_volume_ac' => $min_volume_ac,
            'max_volume_ac' => $max_volume_ac,
            'min_volume_uom_ac' => $min_volume_uom_ac,
            'max_volume_uom_ac' => $max_volume_uom_ac,
            'brn_reference' => $post['brnReference'] ?? "",
        ];


        $this->db->where('id', $routeid);
        $this->db->update('tb_routing_auto', $routingdata);
        $this->session->set_flashdata('success_msg', 'Trip Automation Updated Successfully...');
        redirect('routing');
    }

    /**
     *  This method is used to show all customer details from company code
     *    return :array (consits of both customer and order types)
     */
    public function getshipperdetailsbyID(): void
    {
        $parties = [];
        $code = $this->input->post('id', true);
        $customerId = "";
        $companyCode = $this->session->userdata('company_code');
        $where = "id = '" . $code . "' ";
        if (checkAccessConditions('RELATED_2_SG_MY', $companyCode)) {
            $where = "code LIKE '" . $code . "' AND status ='1'";
        }
        $checkCustomer = $this->routingauto->getAllPartyTypeDetailsForRouting($companyCode, $where, $code, 'CUSTOMER');
        if (!empty($checkCustomer)) {
            $customerId = $checkCustomer['id'];
            $parties['customer_details'][] = [
                'id' => $checkCustomer['id'],
                'name' => $checkCustomer['name'],
                'phone' => $checkCustomer['phone'],
                'street' => $checkCustomer['street'],
                'city' => $checkCustomer['location'],
                'pincode' => $checkCustomer['pincode'],
                'code' => $checkCustomer['code'],
                'country' => $checkCustomer['country'],
                'email_id' => $checkCustomer['email_id'],
                'fax' => $checkCustomer['fax'],
                'state' => $checkCustomer['state'],
                'location' => $checkCustomer['location'],
                'address' => $checkCustomer['address'],
                'company_code' => $checkCustomer['company_code'],
                'branch_code' => $checkCustomer['branch_code']
            ];
        }
        $parties['customer_id'] = $customerId;
        $parties['ordparties'] = [];
        if ($companyCode != "") {
            $getOrderTypes = $this->ordertypemodel->selectlist("id,type_name", "tb_order_types", ['company_code' => $companyCode, 'customer_id' => $customerId, 'status' => '1'], "type_name");
            if (!empty($getOrderTypes)) {
                foreach ($getOrderTypes as $orderTypes) {
                    $parties['ordparties'][] = [
                        'type_id' => $orderTypes['id'],
                        'type_name' => $orderTypes['type_name']
                    ];
                }
            } else {
                $getCompanyOrderTypes = $this->ordertypemodel->selectlist("id,type_name", "tb_order_types", ['company_code' => $companyCode, 'status' => '1'], "type_name");
                if (!empty($getCompanyOrderTypes)) {
                    foreach ($getCompanyOrderTypes as $orderTypes) {
                        $parties['ordparties'][] = [
                            'type_id' => $orderTypes['id'],
                            'type_name' => $orderTypes['type_name']
                        ];
                    }
                } else {
                    $getDefaultOrderTypes = $this->ordertypemodel->selectlist("id,type_name", "tb_order_types", ['company_code' => 'SGKN', 'status' => '1'], "type_name");
                    foreach ($getDefaultOrderTypes as $orderTypes) {
                        $parties['ordparties'][] = [
                            'type_id' => $orderTypes['id'],
                            'type_name' => $orderTypes['type_name']
                        ];
                    }
                }
            }
        }
        echo json_encode($parties);
    }

    public function deleterouting($id)
    {
        if ($id != '' || $id != 0) {
            $chk = $this->db->select('id')->get_where("	tb_routing_auto", ['id' => $id]);
            if ($chk->num_rows() > 0) {
                $sts = ['status' => 0];
                $upd = $this->bpartners->updatedata('tb_routing_auto', $id, $sts);
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
           // redirect('routing');
            
        }
    }

    public function getitemListID()
    {
        $parties = [];

        $chkqry = $this->db->query("SELECT id,item_id,item_name,length,length_unit,width,width_unit,height,height_unit,weight,weight_unit,volume,volume_unit,description FROM tb_items WHERE status ='1'  ORDER BY createdon DESC");
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = [
                    'check' => "<input class='listitem' type='radio' name='selectitem' id='listitem_" . $res->id . "' value='" . $res->id . "' onchange=selectitem(" . $res->id . ")>",
                    'id' => $res->id,
                    'item_id' => $res->item_id,
                    'item_name' => $res->item_name,
                    'length' => $res->length . " " . $res->length_unit,
                    'width' => $res->width . " " . $res->width_unit,
                    'height' => $res->height . " " . $res->height_unit,
                    'weight' => $res->weight . " " . $res->weight_unit,
                    'volume' => $res->volume . " " . $res->volume_unit,
                    'description' => $res->description
                ];
            }
        }
        echo json_encode($parties);
    }

    public function viewcargolist()
    {
        $parties = [];

        $company_code = $this->session->userdata('company_code');
        $whr = "";

        $post = $this->input->post(null, true);
        $cargotype = isset($post['cargotype']) ? $post['cargotype'] : "";
        if ($cargotype != "") {
            $whr = " cd.cargo_type LIKE '" . $cargotype . "' AND ";
        }

        $chkqry = $this->db->query("SELECT cd.id,cd.cargo_type,cd.handling_unit,cd.length,cd.length_unit,cd.width,cd.width_unit,cd.height,cd.height_unit,cd.weight,cd.weight_unit,cd.volume,cd.volume_unit FROM tb_cargo_details cd,tbl_cargo_types tc WHERE " . $whr . " cd.cargotype_id=tc.id and cd.status ='1' and tc.company_code='" . $company_code . "' ORDER BY cd.createdon DESC");
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = [
                    'check' => "<input class='listcargo' type='radio' name='selectcargo' id='listcargo_" . $res->id . "' value='" . $res->id . "' onchange=selectcargo(" . $res->id . ")>",
                    'id' => $res->id,
                    'cargo_type' => $res->cargo_type,
                    'handling_unit' => $res->handling_unit,
                    'length' => $res->length . " " . $res->length_unit,
                    'width' => $res->width . " " . $res->width_unit,
                    'height' => $res->height . " " . $res->height_unit,
                    'weight' => $res->weight . " " . $res->weight_unit,
                    'volume' => $res->volume . " " . $res->volume_unit
                ];
            }
        }
        echo json_encode($parties);
    }


    public function getitemdetailslist()
    {
        $item = '';
        $item_id = $this->input->post('item_id', true);
        $chkqry = $this->db->query("SELECT item_id,item_name FROM tb_items WHERE id=" . $item_id);
        if ($chkqry->num_rows() > 0) {
            $item = $chkqry->row()->item_id;
        }
        echo $item;
    }

    public function getcargodetailslist()
    {
        $item = '';
        $item_id = $this->input->post('item_id', true);
        $chkqry = $this->db->query("SELECT cd.id,cd.cargo_type FROM  tb_cargo_details cd,tbl_cargo_types tc WHERE cd.cargotype_id=tc.id and cd.id=" . $item_id);
        if ($chkqry->num_rows() > 0) {
            $item = $chkqry->row()->cargo_type;
        }
        echo $item;
    }

    /* code for trip management */
    public function gettripcarinfo($id)
    {
        $result = [];
        if ($id != "") {
            $vendor_list = $this->db->select("code")->get_where("tb_vendors", ['id' => $id]);
            if ($vendor_list->num_rows() > 0) {
                $result['carrier_name'] = $vendor_list->row()->code;
            }
            $drivers = '<select class="add_company form-control tripcar_id" name="driver_id" id="tdri_name" onchange="getdrid()"
      form="basic-form">
      <option value="">--Select--</option>';
            $drivers_list = $this->db->select("id,name")->get_where("tb_truck_drivers", [
                'vendor_id' => $id,
                'status' => 'Active'
            ]);
            if ($drivers_list->num_rows() > 0) {
                foreach ($drivers_list->result() as $row) {
                    $drivers .= '<option value="' . $row->id . '">' . $row->name . '</option>';
                }
            }
            $drivers .= '</select>';
            $result['drivers'] = $drivers;
        }
        echo json_encode($result);
    }

    public function getdriverdetailsbyvehicle()
    {
        $drivers = [];
        $veh_no = $this->input->post('tvehnum', true);
        if ($veh_no != "") {
            $chk_assigneddrivers = $this->common->gettblrowdata(['vehicle_id' => $veh_no, 'status' => '1'], "driver_id", "tbl_assigned_drivers", 0, 0);
            if (!empty($chk_assigneddrivers)) {
                $driver_id = $chk_assigneddrivers['driver_id'];
                if ($driver_id > 0) {
                    $get_drivername = $this->common->gettblrowdata(['id' => $driver_id, 'status' => 'Active'], "id,name", "tb_truck_drivers", 0, 0);
                    if (!empty($get_drivername)) {
                        $drivers[] = ['id' => $get_drivername['id'], 'name' => $get_drivername['name']];
                    }
                }
            }
        }
        echo json_encode($drivers);
    }

    public function gettripvelinfo()
    {
        $result = [];

        $post = $this->input->post(null, true);
        $id = $post['vtype'];
        $carrierid = $post['carrierid'];
        $res = '';
        $vtypename = $this->db->select("description")->get_where(
            "tb_trucktypes",
            ['id' => $id]
        );
        if ($vtypename->num_rows() > 0) {
            $res = $vtypename->row()->description;
        }
        $result['typename'] = $res;
        /*removed onchnage ='myfunc()*/
        $vehres = '<select name="vehicle_id" id="tvehnum" onchange="getdriverdetailsbyvehicle();"
    form="basic-form" class="form-control tripcar_id"><option value="">--Select--</option>';
        $vehile_list = $this->db->select("id,truck_number,register_number")->order_by('register_number')->get_where("tb_trucks_data", ['truck_type' => $id, 'vendor_id' => $carrierid]);
        if ($vehile_list->num_rows() > 0) {
            foreach ($vehile_list->result() as $vehi) {
                $vehres .= '<option value="' . $vehi->id . '">' . $vehi->truck_number . '</option>';
            }
        }
        $vehres .= '</select>';
        $result['vehiclenum'] = $vehres;
        echo json_encode($result);
    }

    public function getvelinfo($id)
    {
        $result = [];
        $result['transit'] = 0;
        if ($id != "") {
            $vendor_list = $this->db->select("truck_number")->get_where("tb_trucks_data", ['id' => $id]);
            if ($vendor_list->num_rows() > 0) {
                $result['vehid'] = $vendor_list->row()->truck_number;
            }
            $trip_transit = $this->db->select("id")->get_where("tb_trips", ['vehicle_id' => $id, 'status' => 1]);
            if ($trip_transit->num_rows() > 0) {
                $result['vehid'] = '';
                $result['transit'] = 1;
            }
        }
        echo json_encode($result);
    }

    public function getdriverid($id)
    {
        $res = '';
        if ($id != "") {
            $driver_list = $this->db->select("contact_num")->get_where("tb_truck_drivers", ['id' => $id], 1, 0);
            if ($driver_list->num_rows() > 0) {
                $res = $driver_list->row()->contact_num;
            }
        }
        echo $res;
    }

    public function getpartyrouteinfo()
    {
        $item = '';
        $item_id = $this->input->post('id', true);
        $chkqry = $this->db->query("SELECT code FROM tbl_party_master where id=" . $item_id);
        if ($chkqry->num_rows() > 0) {
            $item = $chkqry->row()->code;
        }
        echo $item;
    }

    public function getAllPartyTypeList(): void
    {
        $parties = [];
        $companyCode = $this->session->userdata('company_code');

        $post = $this->input->post(null, true);
        $code = $post['code'] ?? "";
        $type = $post['type'] ?? "";
        $partytype = '"' . $type . '"';
        $getPartyDetails = $this->routingauto->getAllPartyTypeDetailsForRouting($companyCode, "", $code, $type);
        foreach ($getPartyDetails as $partyDetails) {
            $inputField = "<input type='radio' name='partylist' id='partylist_" . $partyDetails['id'] . "' class='partylistclass' onchange='selectpartylist(" . $partyDetails['id'] . "," . $partytype . ")' value='" . $partyDetails['code'] . "'>";
            $parties[] = [
                'check' => $inputField,
                'id' => $partyDetails['code'],
                'name' => $partyDetails['name'],
                'email' => $partyDetails['email'],
                'mobile' => $partyDetails['mobile'],
                'party_name' => $partyDetails['role'],
                'company_code' => $partyDetails['company_code'],
                'branch_code' => $partyDetails['branch_code']
            ];
        }
        echo json_encode($parties);
    }

    public function getnotidentifierlist(): void
    {
        $parties = [];
        $user_id = $this->session->userdata('user_id');
        $where = [];
        $post = $this->input->post(null, true);
        $code = $post['code'] ?? "";

        if ($code) {
            $where = ['code' => $code, 'action' => 'byCode'];
        }
        if ($this->session->userdata('company_code')) {
            $where = ['notifyId' => $this->routingauto->getNotifyIdOfParty($this->session->userdata('company_code'), $user_id), 'companyCode' => $this->session->userdata('company_code'), 'action' => 'byCompanyCode'];
        }
        $result = $this->routingauto->getNotifyList($where);
        if (empty($result)) {
            return;
        }
        foreach ($result as $res) {
            $check = "<input type='radio' name='notidenlist' id='notidenlist_" . $res->id . "' class='notidenlist' onchange='selectnotidenlist(" . $res->id . ")' value='" . $res->code . "'>";
            $parties[] = [
                'check' => $check,
                'id' => $res->code,
                'name' => $res->name,
                'email' => $res->email,
                'mobile' => $res->mobile,
                'party_name' => $res->role,
                'company_code' => $res->company_code,
                'branch_code' => $res->branch_code,
            ];
        }

        echo json_encode($parties);
    }

}
