<?php defined('BASEPATH') OR exit('No direct script access allowed'); header('Content-Type: application/json');
class Rtandroid extends CI_Controller {

	/**
	 * Android Page for this controller.
	 *
	 * Maps to the following URL
	 * 		https://elog360.app/svkonekt_test/index.php/rtandroid
	 *	- or -
	 * 		https://elog360.app/svkonekt_test/index.php/rtandroid/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://service.citytrucks.in/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/android/<method_name>
	 * @see https://elog360.app/svkonekt_test/user_guide/general/urls.html
	 */

	public function __construct()
	{
		parent::__construct();
		if (isset($_SERVER['HTTP_ORIGIN'])) {
		header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
		header('Access-Control-Allow-Credentials: true');
		header('Access-Control-Max-Age: 86400');    // cache for 1 day
    	}
    // Access-Control headers are received during OPTIONS requests
    	if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
            header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

        if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
            header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

        }

		// decoding the json array
	    $post = json_decode(file_get_contents("php://input"), true);

		//Codiginite helpers
		$this->load->helper('date');

		//Load data base model
		//$this->load->model('Android_model', 'adb', TRUE);
	}

	public function index()
	{
		//$this->load->view('welcome_message');
		echo "Welcome to Track247 Android services";
		//echo "getServices<br>";
		$data['user'] = "";
	}

	/*=======================================================================================================*/
	/*==============================Receiving Requestes from Android Devices=================================*/
	/*=======================================================================================================*/

    public function service(){
		/*Below json_decode statement is requied to decode the android request with params(in json)*/
		$post = json_decode(file_get_contents("php://input"), true);

		$action = $post["action"];
		$authkey = $post["authkey"];//"1234567890";

		$response = array();
        $response['error'] = TRUE;
        if($this->checkAuthorKey($authkey)){
			if($action != null){
				switch($action)
				{
					case 'truckslist':
					$this->getvehiclesonlyAsync($post);
					break;
					case 'gcmregister':
					$this->gcmregister($post);
					break;
					case 'insertusermobiletracker':
					$this->insertuser_mobile_tracker($post);
					break;
					case 'genaratetracklink':
					$this->genaratetracklink($post);
					break;
					case 'getcordinates':
					$this->getcordinates($post);
					break;
					case 'getReportSummary':
					$this->getReportSummary($post);
					break;
					case 'getReportBreakup':
					$this->getReportBreakup($post);
					break;
					case 'getReportSummaryFORRT':
					$this->getReportSummaryFORRT($post);
					break;
					case 'getReportBreakupFORRT':
					$this->getReportBreakupFORRT($post);
					break;
					case 'getcordinatesFORRT':
					$this->getcordinatesFORRT($post['imei']);
					break;

				}
			}else{
				$response['error_msg'] = "Action Not Found";
				echo json_encode($response);
			}

        }
    }


	public function sendnotfication($phonenum,$msg){
		$params = array('wk' => '115948kz7517216zm1sl', 'apiurl' => 'alerts.sinfini.com/api/','sd'=>'RTRUCK');
		$this->load->library('sendsms', $params);
		$this->sendsms->send_sms($phonenum, $msg, "https://elog360.app/svkonekt_test", "xml");
	}

	public function vPushNotificationtoCustome($userid)
	{
		$stmt = "select gcm_id from tb_users where id='$userid'";
		$res = $this->db->query($stmt);

		if($res->num_rows() > 0)
		{
		  	$row = $res->row();
			$gcmregid = $row->gcm_id;
		  	//echo "GCM ID\t". $row->gcm_id . "\n";

			$msgTruck="Welcome to Trac247..!! Powered by Svkonekt";
			//$msgTruck = $this->getGoogleNotifyTruckLocation();

			//$msg = array("lastposition"=>$msgTruck);
			$msg = array("userwelcome"=>$msgTruck);
			$registatoin_ids  = array();

			array_push($registatoin_ids, $gcmregid);
			$message = array("welcome"=>$msg);
			$this->load->library('trackgcm');
			$result = $this->trackgcm->send_notification($registatoin_ids,$message);

			//echo "\nGoogle Responce\t".json_encode($result);
		}


	}



	public function gcmregister(){
		$post = json_decode(file_get_contents("php://input"), true);
		$userid = $post["user_id"];
		$regid  = $post["gcm_id"];
		$test_msg = "Values are".$userid.$regid;
		$q1 = $this->db->query("INSERT INTO `TB_LOG`(`msg`) VALUES ('$test_msg')");
		$q = $this->db->query("update tb_users set gcm_id='$regid' where id='$userid'");
		$responce = array("affected_rows"=>$this->db->affected_rows(),"gcm_id"=>$regid);
		echo json_encode($responce);
		$this->vPushNotificationtoCustome($userid);
	}


	public function dogetgcmlist($userid ,$empid){
		 // echo "select * from tb_user_notifications where bdeleted=0 and userid='$userid' and empid='$empid'";
	      $res = $this->db->query("select * from tb_user_notifications where bdeleted=0 and userid='$userid' and empid='$empid'");
		  $ret_array = array();
		  $notifys = array();
		  if($res->num_rows() > 0){

			  foreach ($res->result_array() as $row)
				{
				  array_push($notifys,$row);
				}

		  }

		  $ret_array['notifylist'] = $notifys;
		   echo json_encode($ret_array) ;

	}

	public function getcordinatesmap(){
		$imei =  isset($_REQUEST['imei'])?$_REQUEST['imei']:$imei='0';
		$this->db = $this->load->database('default', TRUE);
        $res = $this->db->query("select * from tb_gps_devices where imei = '".$imei."' order by id desc limit 1");
        $ret = array();

        if($res->num_rows() > 0){
		    $temp = array();
            $cords = $res->row();
            $stime = '';
            $temp['location'] = $this->getLocationName($cords->lat,$cords->lng);
            $obj =  $this->secondsToTime($this->getstoptime($cords->imei,$cords));
            // print_r($obj);
            if($obj['h']!= '0')
                $stime .= $obj['h']." Hrs ";
            if($obj['m']!= '0')
                $stime .= $obj['m']." Mins ";
            if($obj['s']!= '0')
                $stime .= $obj['s']." Secs ";
            $temp['stoppedTime'] = $stime;
			$temp['course'] = $cords->course;
			$temp['id'] =$cords->id;
			$temp['imei'] = $cords->imei;
			$temp['trucknum'] = $this->gettrucknum($imei);
			$temp['lng'] = $cords->lng;
			$temp['lat'] = $cords->lat;
			$temp['receivedon'] = $this->checkGpsHeartbeat($cords->heartbeat,$cords->receivedon);
			/* $temp['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon)); */
			$temp['speed'] = $cords->speed;

            $ret[] = $temp;
        }
		echo json_encode($ret);

	}

	/* get Heart Beat*/
	function checkGpsHeartbeat($heartbeat,$receivedon)
	{
		$presentdate=date('Y-m-d  h:i:s');
		$curdate=date('Y-m-d');
		$speed = -1;
		if($heartbeat != "" && $heartbeat != "0000-00-00 00:00:00")
		{
			$recDate = $heartbeat;
		}
		else
		{
			$rdt  = date('Y-m-d',strtotime($receivedon));
			$chkdt = strtotime($rdt);
			$recdt = strtotime($curdate);
			if($chkdt > $recdt)
			{
				$recDate = date('Y-m-d H:i:s', strtotime('-1 day', strtotime($receivedon)));
			}else
			{
				$recDate = $receivedon;
			}
		}
		$receivedon = date('d-m-Y h:i:s a ', strtotime($recDate));

		return $receivedon;
	}

    public function getcordinates($imei){
		//$imei=$_REQUEST['imei'];
	    if($imei != "All")
		{
       // $this->db = $this->load->database('default', TRUE);
        $res = $this->db->query("select * from tb_gps_devices where imei = '".$imei."' order by id desc limit 1");
        $ret = array();

        if($res->num_rows() > 0){
		    $temp = array();
            $cords = $res->row();
            $stime = '';
            $temp['location'] = $this->getLocationName($cords->lat,$cords->lng);
            $obj =  $this->secondsToTime($this->getstoptime($cords->imei,$cords));
            // print_r($obj);
            if($obj['h']!= '0')
                $stime .= $obj['h']." Hrs ";
            if($obj['m']!= '0')
                $stime .= $obj['m']." Mins ";
            if($obj['s']!= '0')
                $stime .= $obj['s']." Secs ";
            $temp['stoppedtime'] = $stime;
			$temp['course'] = round($cords->course);
			$temp['id'] =$cords->id;
			$temp['imei'] = $cords->imei;
			$temp['lng'] = $cords->lng;
			$temp['lat'] = $cords->lat;
			$temp['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
			$temp['speed'] = round($cords->speed);

            $ret['lastposition'] = $temp;
        }
		}
		else{
            $trucks = array();
            $result = $this->db->query("select register_number,imei from tb_trucks_data where user_id='".$userid."' and gpsstatus = 1");
            if($result->num_rows() > 0){
                foreach ($result->result() as $row){
                   // $this->db = $this->load->database('default', TRUE);

					}
				}

		}
        echo json_encode($ret);
    }


	public function getReportSummary()
	{
		$imei = $_REQUEST['imei'];//$this->input->post('imei');//$_POST['imei'];//"0359710049386460";//
		$fromdate =$_REQUEST['fromDate'];//$this->input->post('fromDate');//$_POST['fromDate'];//"2015-09-08";//
		$todate =$_REQUEST['toDate']; //$this->input->post('toDate');//$_POST['toDate'];//"2015-09-08";//
		$new_array=array();
		$data1=array();
		$data=array();
        if($fromdate != '' && $todate != '' && $imei != '')
		{
            $res = array();
			$sql="select imei,sum(running_hrs) as worktime,sum(idletime) as idletime,sum(distance_travelled) as dist from tb_gps_summary where imei=".$imei." and report_date between '".$fromdate."' and '".$todate."'";
			$query=$this->db->query($sql);
		if($query->num_rows()>0)
		{
			$ret_array=array('imei'=>$query->row()->imei,'worktime'=>round($query->row()->worktime,1)." hrs",'dist'=>round($query->row()->dist,1)." km",'idletime'=>round($query->row()->idletime,1)." hrs");


		}

			 $sum_array = array("error"=>false,'summary'=>$ret_array);
             echo json_encode($sum_array) ;

		}
	}

	/*=======================================================================================================================================================*/
	/*venkat create on 13022016 while checking on ReturnTruck Because: The inputs getting/receiving for getReportSummary() is wrong;
	  so i created a new getReportSummaryFORRT($post); NEED TO CHECK IN Trac247 & ReturnTruck and then delete getReportSummaryFORRT();*/
	public function getReportSummaryFORRT($post)
	{

		$imei= $post['imei'];//"0359710049386700";//
		$fromdate =$post['fromDate'];//"2016-02-12";//
		$todate = $post['toDate'];//"2016-02-12";//
		$new_array=array();
		$data1=array();
		$data=array();
        if($fromdate != '' && $todate != '' && $imei != '')
		{
            $res = array();
			$sql="select imei,sum(running_hrs) as worktime,sum(idletime) as idletime,sum(distance_travelled) as dist from tb_gps_summary where imei=".$imei." and report_date between '".$fromdate."' and '".$todate."'";
			$query=$this->db->query($sql);
		if($query->num_rows()>0)
		{
			$ret_array=array('imei'=>$query->row()->imei,'worktime'=>round($query->row()->worktime,1)." hrs",'dist'=>round($query->row()->dist,1)." km",'idletime'=>round($query->row()->idletime,1)." hrs");
				$sum_array = array("error"=>false,'summary'=>$ret_array);

		}else{
			$sum_array = array("error"=>true,'error_msg'=>"No Records Found");
		}


             echo json_encode($sum_array) ;

		}
	}

	public function getReportBreakupFORRT($post){
		//$this->db = $this->load->database('default', TRUE);

		$imei= $post['imei'];//"0359710049386700";//
		$fromdate =$post['fromDate'];//"2016-02-12";//
		$todate = $post['toDate'];//"2016-02-12";//
		$rid = 0;
        if($fromdate != '' && $todate != '' && $imei != '')
        {
			$todate = $todate." 24:00:00";
			$bloop = true;
			$ret_array = array();
			while($bloop)
			{
				$bloop = false;
				if($rid == 0)
				 $q = $this->db->query("select * from tb_gps_devices where imei = '".$imei."' and receivedon >= '".$fromdate."' and receivedon < '".$todate."' order by id asc limit 1");
				else
				 $q = $this->db->query("select * from tb_gps_devices where imei = '".$imei."' and id > $rid and receivedon >= '".$fromdate."' and receivedon < '".$todate."' order by id asc limit 1");


				 if($q->num_rows()>0)
				 {
				  $timediff = 0;
				  $stime = "";
				  $temp = array();
				  $bloop = true;
				  $cords = $q->row();
				  list($timediff,$rid) =  $this->getstoptimefwd($cords->imei,$cords);
				  $obj = $this->secondsToTime($timediff);
				  if($obj['h']!= '0')
					  $stime .= $obj['h']." Hrs ";
				  if($obj['m']!= '0')
					   $stime .= $obj['m']." Mins ";
				  if($obj['s']!= '0')
					   $stime .= $obj['s']." Secs ";
				   $temp['stoppedtime'] = $stime;
				   //$temp['receivedon'] = $cords->receivedon;
				   $temp['lat'] = $cords->lat;
				   $temp['lng'] = $cords->lng;
				   $temp['location'] = $this->getLocationName($cords->lat,$cords->lng);
				   $temp['speed'] = $cords->speed;
				   $temp['id'] = $cords->id;
				   $temp['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
				   array_push($ret_array,$temp);


				   $response['cords'] = $ret_array;
				   $response['error'] = FALSE;
				 }else{
					$response['error'] = TRUE;
					$response['error_msg'] = "Coordinates not found in between dates";
				 }

			}

	  }else{
			$response['error'] = TRUE;
			$response['error_msg'] = "Required Inputs not Found";
	  }

		echo json_encode($response);

	}

	public function getcordinatesFORRT($imei){
		//$imei=$_REQUEST['imei'];
	    if($imei != "All")
		{
       // $this->db = $this->load->database('default', TRUE);
        $res = $this->db->query("select * from tb_gps_devices where imei = '".$imei."' order by id desc limit 1");
        $ret = array();

			if($res->num_rows() > 0){
				$temp = array();
				$cords = $res->row();
				$stime = '';
				$temp['location'] = $this->getLocationName($cords->lat,$cords->lng);
				$obj =  $this->secondsToTime($this->getstoptime($cords->imei,$cords));
				// print_r($obj);
				if($obj['h']!= '0')
					$stime .= $obj['h']." Hrs ";
				if($obj['m']!= '0')
					$stime .= $obj['m']." Mins ";
				if($obj['s']!= '0')
					$stime .= $obj['s']." Secs ";
				$temp['stoppedtime'] = $stime;
				$temp['course'] = round($cords->course);
				$temp['id'] =$cords->id;
				$temp['imei'] = $cords->imei;
				$temp['lng'] = $cords->lng;
				$temp['lat'] = $cords->lat;
				$temp['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
				$temp['speed'] = round($cords->speed);


				$ret['lastposition'] = $temp;
				$ret['error'] = false;
			}else{
				$ret['error'] = true;
				$ret['error_msg'] = "Getting last postion..";
			}

			echo json_encode($ret);
		}



    }

	/*=================================================================END ======================================================================================*/



	public function getReportBreakup(){
		//$this->db = $this->load->database('default', TRUE);

		$imei = $_REQUEST['imei'];//$this->input->post('imei');
		$fromdate = $_REQUEST['fromDate'];// $this->input->post('fromDate');
		$todate = $_REQUEST['toDate'];// $this->input->post('toDate');
		$response['error'] = TRUE;
		$rid = 0;
        if($fromdate != '' && $todate != '' && $imei != '')
        {
			$todate = $todate." 24:00:00";
			$bloop = true;
			$ret_array = array();
			while($bloop)
			{
				$bloop = false;
				if($rid == 0)
				 $q = $this->db->query("select * from tb_gps_devices where imei = '".$imei."' and receivedon >= '".$fromdate."' and receivedon < '".$todate."' order by id asc limit 1");
				else
				 $q = $this->db->query("select * from tb_gps_devices where imei = '".$imei."' and id > $rid and receivedon >= '".$fromdate."' and receivedon < '".$todate."' order by id asc limit 1");
				 if($q->num_rows() > 0)
				 {
				  $timediff = 0;
				  $stime = "";
				  $temp = array();
				  $bloop = true;
				  $cords = $q->row();
				  list($timediff,$rid) =  $this->getstoptimefwd($cords->imei,$cords);
				  $obj = $this->secondsToTime($timediff);
				  if($obj['h']!= '0')
					  $stime .= $obj['h']." Hrs ";
				  if($obj['m']!= '0')
					   $stime .= $obj['m']." Mins ";
				  if($obj['s']!= '0')
					   $stime .= $obj['s']." Secs ";
				   $temp['stoppedtime'] = $stime;
				   //$temp['receivedon'] = $cords->receivedon;
				   $temp['lat'] = $cords->lat;
				   $temp['lng'] = $cords->lng;
				   $temp['location'] = $this->getLocationName($cords->lat,$cords->lng);
				   $temp['speed'] = $cords->speed;
				   $temp['id'] = $cords->id;
				   $temp['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
				   array_push($ret_array,$temp);

				   $response['error'] = FALSE;
				   $response['cords'] = $ret_array;
				 }else{
					$response['error'] = TRUE;
					$response['error_msg'] = "Required Inputs not Found";
				 }

			}

	  }else{
			$response['error'] = TRUE;
			$response['error_msg'] = "Required Inputs not Found";
	  }


	  echo json_encode($response);
	}

	public function getstoptimefwd($imei,$cords){
        $this->db = $this->load->database('default', TRUE);
        $bloop = true;
        $timediff = 0;
		$lastid = $cords->id;
        while($bloop){
            $bloop = false;
            $q ="select  * from tb_gps_devices where imei ='".$cords->imei."' and id > '$cords->id' order by id asc limit 1";

           // $qry = "select * from tb_gps_devices where imei = '".$imei."' and id = ".($cords->id)." and (( ( 3959 * acos( cos( radians(".$cords->lat.") ) * cos( radians(lat) ) * cos( radians(lng) - radians(".$cords->lng.") ) + sin( radians(".$cords->lat.") ) * sin( radians(lat) ) ) ))) < 0.10 order by id desc limit 1";
            $qres =  $this->db->query($q);
            if($qres->num_rows() > 0){
                $pcords = $qres->row();
                $diff = (float) $this->distance($cords->lat,$cords->lng,$pcords->lat,$pcords->lng,"K");
                 if($diff< 0.02)
                 {
					 $lastid = $cords->id;
                     $diff =  strtotime($pcords->receivedon) - strtotime($cords->receivedon);
                     $timediff = $timediff + $diff;
                     $cords = $pcords;
                     $bloop = true;
                 }
                else
                    break;

              //  $timediff = $timediff + $diff;
            }
        }
		$retarray = array();
		array_push($retarray,$timediff);
		array_push($retarray,$lastid);
        return $retarray;

    }


	    public function getGoogleNotifyTruckLocation()
	    {
		$this->db = $this->load->database('default', TRUE);
                   // $qres = $this->db->query("select * from tb_gps_devices where imei = '".$row->imei."' order by id desc limit 1");
		$qres = $this->db->query("select * from tb_gps_devices where imei = '0359710049386015' order by id desc limit 1");

                    if($qres->num_rows() > 0)
					{
                        $r = array();
                        $stime = '';
                        $cords = $qres->row();
                        $r['lat'] = $cords->lat;
			$r['lng'] = $cords->lng;
                        $r['location'] =  $this->getLocationName($cords->lat,$cords->lng);
                        $r['register_number'] = "AP31TD3321";
                        $r['imei'] = "0359710049386015";
			$r['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
			$r['speed'] = $cords->speed;
			$r['course'] = $cords->course;

			$msg = json_encode($r);

			return $msg;
                    }
	    }



    public function getvehicles($userid){
        if($userid != ''){

            $trucks = array();
            $result = $this->db->query("select register_number,imei from tb_trucks_data where user_id='".$userid."' and gpsstatus = 1");
            if($result->num_rows() > 0){
                foreach ($result->result() as $row){
                    $this->db = $this->load->database('default', TRUE);
                    $qres = $this->db->query("select * from tb_gps_devices where imei = '".$row->imei."' order by id desc limit 1");
                    if($qres->num_rows() > 0){
                        $r = array();
                        $stime = '';
                        $cords = $qres->row();
                       //  print_r($cords);
                        $r['location'] =  $this->getLocationName($cords->lat,$cords->lng);
                        $obj =  $this->secondsToTime($this->getstoptime($row->imei,$cords));
                       // print_r($obj);
                        if($obj['h']!= '0')
                            $stime .= $obj['h']." Hrs ";
                        if($obj['m']!= '0')
                            $stime .= $obj['m']." Mins ";
                        if($obj['s']!= '0')
                            $stime .= $obj['s']." Secs ";
                        $r['imei'] = $row->imei;
                        $r['register_number'] = $row->register_number;
                        $r['stoppedtime'] = $stime;
                        //$r['imei'] = $row->imei;
						$r['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
						$r['lat'] = $cords->lat;
						$r['lng'] = $cords->lng;
						$r['speed'] = $cords->speed;
						$r['course'] = $cords->course;
                        $trucks [] = $r;


                    }
                }
            }

        }
        $ret['trucks_list'] = $trucks;
        echo json_encode($ret);
    }

	public function getvehiclesonly(){
		/*Below json_decode statement is requied to decode the android request with params(in json)*/
		$post = json_decode(file_get_contents("php://input"), true);
		$userid = $post["user_id"];

		$response = array("error" => FALSE);

        if($userid != '')
		{

            $trucks = array();
            $result = $this->db->query("select register_number,imei from tb_trucks_data where user_id='".$userid."' and gpsstatus = 1");
            if($result->num_rows() > 0)
			{
                foreach ($result->result() as $row)
				{
                    $this->db = $this->load->database('default', TRUE);
                    $qres = $this->db->query("select * from tb_gps_devices where imei = '".$row->imei."' order by id desc limit 1");
                    if($qres->num_rows() > 0)
					{
                        $r = array();
                        $stime = '';
                        $cords = $qres->row();
                       //  print_r($cords);
   					    $r['lat'] = $cords->lat;
						$r['lng'] = $cords->lng;
                        $r['location'] =  $this->getLocationName($cords->lat,$cords->lng);
                        $r['imei'] = $row->imei;
                        $r['register_number'] = $row->register_number;
                        $r['imei'] = $row->imei;
						$r['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
						$r['speed'] = $cords->speed;
						$r['course'] = $cords->course;
                        $trucks [] = $r;
                    }
					/*else
					{
						//TODO for if no register number and imei found
						$response["error"] = TRUE;
						$response["error_msg"] = "Devices\t".$row->imei."\tNot Assigned To This User";
						echo json_encode($response);

					}*/
                }

        		//$ret['trucks_list'] = $trucks;
				$response["error"] = FALSE;
				$response['trucks_list'] = $trucks;
				echo json_encode($response);
            }
			else
			{
				//TODO for if no register number and imei found
				$response["error"] = TRUE;
				$response["error_msg"] = "User id Not Found or User is Inactive";//User IMEI & Register No. are Not Found";
				echo json_encode($response);
			}

        }
		else
		{
			//TODO for user_id is null
			$response["error"] = TRUE;
			$response["error_msg"] = "Found User Id Is Null";
			echo json_encode($response);
		}

    }


	public function getvehiclesonlyAsync($requestObj){

		$userid = $requestObj['user_id'];

        if($userid != '')
		{

            $trucks = array();
            $result = $this->db->query("select id,register_number,imei from tb_trucks_data where user_id='".$userid."' and gpsstatus = 1");
            if($result->num_rows() > 0)
			{
                foreach ($result->result() as $row)
				{
                   $this->db = $this->load->database('default', TRUE);
                    $qres = $this->db->query("select * from tb_gps_devices where imei = '".$row->imei."' order by id desc limit 1");
                    if($qres->num_rows() > 0)
					{
                        $r = array();
                        $stime = '';
                        $cords = $qres->row();
                       //  print_r($cords);
   					    $r['truckid'] = $row->id;
   					    $r['lat'] = $cords->lat;
						$r['lng'] = $cords->lng;
                        $r['location'] =  $this->getLocationName($cords->lat,$cords->lng);
                        $r['imei'] = $row->imei;

                        $r['register_number'] = $row->register_number;
                        $r['imei'] = $row->imei;
						$r['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
						$r['speed'] = $cords->speed;
						$r['course'] = $cords->course;
                        $trucks [] = $r;
                    }
					else
					{
						$r = array();
                        $stime = '';
                        $cords = '';
                       //  print_r($cords);
   					    $r['truckid'] = $row->id;
   					    $r['lat'] = '';
						$r['lng'] = '';
                        $r['location'] =  '';
                        $r['imei'] = $row->imei;

                        $r['register_number'] = $row->register_number;
                        /* $r['imei'] = $row->imei; */
						$r['receivedon'] = '';
						$r['speed'] = '';
						$r['course'] = '';
                        $trucks [] = $r;
					}
                }

        		//$ret['trucks_list'] = $trucks;
				$response["error"] = FALSE;
				$response['trucks_list'] = $trucks;
				echo json_encode($response);

            }
			else
			{
				//TODO for if no register number and imei found
				$response["error"] = TRUE;
				$response["error_msg"] = "User id Not Found or User is Inactive";//User IMEI & Register No. are Not Found";
				echo json_encode($response);
			}

        }
		else
		{
			//TODO for user_id is null
			$response["error"] = TRUE;
			$response["error_msg"] = "Found User Id Is Null";
			echo json_encode($response);
		}

    }



    /*User Mobile Tracker*/
    public function insertuser_mobile_tracker()
    {
		//$json = file_get_contents('php://input');



		$mobileLocationarr = $this->input->post("locations");

		$array_of_mobile_locations = json_decode($mobileLocationarr, true);
		if(is_array($array_of_mobile_locations))
		{

			foreach($array_of_mobile_locations as $arrindex)
			{

				/*$inserArr['user_id'] = $arrindex["userid"];
				$inserArr[] = $arrindex["latitude"];
				$mlongitude = $arrindex["longitude"];
				$mtimestamp = $arrindex["timestamp"];*/

				$this->db->insert("tb_gps_mobiletracker", $arrindex);

			}


		}else{
			echo "Not Array";
		}

	}


	public function gettrucknum($imei)
	{
		$trucknum = "";
		$trucksobj = $this->getroutesRET();
		foreach($trucksobj as $truck)
		{
			if($truck->imei == $imei)
			{
			    $trucknum = $truck->register_number;
				break;
			}
		}
		return $trucknum;
	}
	function getroutesRET()
	{

		/*$imei = $this->session->userdata('trucks');
		echo json_encode($imei);*/
		$user_id = $this->session->userdata('user_id');
		$trucks = $this->db->query("select register_number,imei from tb_trucks_data where gpsstatus = 1 and user_id = ".$user_id);

		foreach($trucks->result() as $row)
		{
			$imei[] = $row;
		}
		$this->load->database('default',TRUE);
		return $imei;
	}


	public function getvehiclesntr(){
		$userid = $this->session->userdata('user_id');
        if($userid != ''){

            $trucks = array();
            $result = $this->db->query("select register_number,imei from tb_trucks_data where user_id='".$userid."' and gpsstatus = 1");
            if($result->num_rows() > 0){
                foreach ($result->result() as $row){
                    $this->db = $this->load->database('default', TRUE);
                    $qres = $this->db->query("select * from tb_gps_devices where imei = '".$row->imei."' order by id desc limit 1");
                    if($qres->num_rows() > 0){
                        $r = array();
                        $stime = '';
                        $cords = $qres->row();
                       //  print_r($cords);
                        $r['location'] =  $this->getLocationName($cords->lat,$cords->lng);
                        $obj =  $this->secondsToTime($this->getstoptime($row->imei,$cords));
                       // print_r($obj);
                        if($obj['h']!= '0')
                            $stime .= $obj['h']." Hrs ";
                        if($obj['m']!= '0')
                            $stime .= $obj['m']." Mins ";
                        if($obj['s']!= '0')
                            $stime .= $obj['s']." Secs ";
                        $r['imei'] = $row->imei;
                        $r['register_number'] = $row->register_number;
                        $r['stoppedtime'] = $stime;
                        $r['imei'] = $row->imei;
						$r['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
						$r['lat'] = $cords->lat;
						$r['lng'] = $cords->lng;
						$r['speed'] = $cords->speed;
						$r['course'] = $cords->course;
                        $trucks [] = $r;


                    }
                }
            }

        }
        $ret['trucks_list'] = $trucks;
        echo json_encode($ret);
    }

	public function getvehiclesntrsearchall(){
		$userid = $this->session->userdata('user_id');
		$selectDistrict=$this->input->post("selectDistrict");
		 $selectMandal=$this->input->post("selectMandal");
		 $selectPanchayat=$this->input->post("selectPanchayat");
		  $appendQuery ='';
		 if($selectDistrict!='0')
		  {
		     $appendQuery.= " and subdivisions='$selectDistrict'";
		  }
		  if($selectMandal!='0')
		  {
		     $appendQuery.= " and mandal='$selectMandal'";
		  }
		  if($selectPanchayat!='0')
		  {
		    $appendQuery.= " and grampanchayat='$selectPanchayat'";
		  }
        if($userid != ''){
			 $this->db = $this->load->database('default', TRUE);
             $trucks = array();
            $result = $this->db->query("select register_number,gps_imei from tbl_install_new where user_id='".$userid."' $appendQuery ");
            if($result->num_rows() > 0){
                foreach ($result->result() as $row){

                    $qres = $this->db->query("select * from tb_gps_devices where imei = '".$row->gps_imei."' order by id desc limit 1");
                    if($qres->num_rows() > 0){
                        $r = array();
                        $stime = '';
                        $cords = $qres->row();
                       //  print_r($cords);
                        $r['location'] =  $this->getLocationName($cords->lat,$cords->lng);
                        $obj =  $this->secondsToTime($this->getstoptime($row->gps_imei,$cords));
                       // print_r($obj);
                        if($obj['h']!= '0')
                            $stime .= $obj['h']." Hrs ";
                        if($obj['m']!= '0')
                            $stime .= $obj['m']." Mins ";
                        if($obj['s']!= '0')
                            $stime .= $obj['s']." Secs ";
                        $r['imei'] = $row->gps_imei;
                        $r['register_number'] = $row->register_number;
                        $r['stoppedtime'] = $stime;
                        $r['imei'] = $row->gps_imei;
						$r['receivedon'] = date('d-m-Y h:i:s a ', strtotime($cords->receivedon));
						$r['lat'] = $cords->lat;
						$r['lng'] = $cords->lng;
						$r['speed'] = $cords->speed;
						$r['course'] = $cords->course;
                        $trucks [] = $r;


                    }
                }
            }

        }
        $ret['trucks_list'] = $trucks;
        echo json_encode($ret);
    }

    function getLocationName($lat,$lng)
    {
		return getLocationName($lat, $lng);
    }

	function getdatafromlocaldb($lat,$lng)
	{
	   $qry=$this->db->query("select * from tb_location_data where (((3959 * acos(cos(radians(".$lat.")) * cos(radians(lat)) * cos(radians(lng) - radians(".$lng.")) + sin(radians(".$lat.")) * sin(radians(lat)))))) < 0.30") ;
		$qryres = $qry->row();
		return $qryres->name1;
 	}

    public function secondsToTime($seconds)
    {
        // extract hours
        $hours = floor($seconds / (60 * 60));

        // extract minutes
        $divisor_for_minutes = $seconds % (60 * 60);
        $minutes = floor($divisor_for_minutes / 60);

        // extract the remaining seconds
        $divisor_for_seconds = $divisor_for_minutes % 60;
        $seconds = ceil($divisor_for_seconds);

        // return the final array
        $obj = array(
            "h" => (int) $hours,
            "m" => (int) $minutes,
            "s" => (int) $seconds,
        );
        return $obj;
    }

    public function getstoptime($imei,$cords){
        $this->db = $this->load->database('default', TRUE);
        $bloop = true;
        $timediff = 0;
        while($bloop){
            $bloop = false;
            $q ="select  * from tb_gps_devices where imei ='".$cords->imei."' and id <'$cords->id' order by id desc limit 1";

           // $qry = "select * from tb_gps_devices where imei = '".$imei."' and id = ".($cords->id)." and (( ( 3959 * acos( cos( radians(".$cords->lat.") ) * cos( radians(lat) ) * cos( radians(lng) - radians(".$cords->lng.") ) + sin( radians(".$cords->lat.") ) * sin( radians(lat) ) ) ))) < 0.10 order by id desc limit 1";
            $qres =  $this->db->query($q);
            if($qres->num_rows() > 0){
                $pcords = $qres->row();
                $diff = (float) $this->distance($cords->lat,$cords->lng,$pcords->lat,$pcords->lng,"K");
                 if($diff< 0.02)
                 {

                     $diff = strtotime($cords->receivedon) - strtotime($pcords->receivedon);
                     $timediff = $timediff + $diff;
                     $cords = $pcords;
                     $bloop = true;
                 }
                else
                    break;

              //  $timediff = $timediff + $diff;
            }
        }
        return $timediff;

    }

    function distance($lat1, $lon1, $lat2, $lon2, $unit) {

        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
        $dist = acos($dist);
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;
        $unit = strtoupper($unit);

        if ($unit == "K") {
            return ($miles * 1.609344);
        } else if ($unit == "N") {
            return ($miles * 0.8684);
        } else {
            return $miles;
        }
    }

    function calculateDistance($latitude1, $longitude1, $latitude2, $longitude2)
    {
        $theta = $longitude1 - $longitude2;
        //echo "theta = ".$theta."<br>";
        $miles = (sin(deg2rad($latitude1)) * sin(deg2rad($latitude2))) + (cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta)));
        if($miles<=1 && $miles>=-1){
            $miles = acos($miles);
            $miles = rad2deg($miles);
            $kmts = $miles * 60 * 1.1515 * 1.609344;
        }else{$kmts = 0; }
        return $kmts;
    }

    public function checkAuthorKey($authkey){
	    return ($authkey == "1234567890");
    }

    function passwordEncrypt($str)
    {
        return password_hash($str, PASSWORD_DEFAULT);
    }


function genaratetracklink()
{


		$userid = isset($_REQUEST['userid'])?$_REQUEST['userid']:$userid='0';
		$empid = isset($_REQUEST['empid'])?$_REQUEST['empid']:$empid='0';
		$mobileimei = isset($_REQUEST['mobileimei'])?$_REQUEST['mobileimei']:$mobileimei='0';
		$response = array("error" =>FALSE);
		$p_date=date("Y-m-d H:i:s");

		$enddays=date('Y-m-d H:i:s', strtotime('+5 days'));
		if($userid != "0" || $mobileimei != "0"){
			$sql="select * from tb_link where user_id=".$userid." and empid=".$empid." and mobileimei=".$mobileimei." and end_time>='".$p_date."'";
			$query=$this->db->query($sql);

			$id="";
			if($query->num_rows()>0)
			{
				$id=$query->row()->id;
			}
			else
			{
				$inser_array=array('user_id'=>$userid,'mobileimei'=>$mobileimei,'empid'=>$empid,'start_time'=>$p_date,
				'end_time'=>$enddays,'create_date'=>$p_date);
				$this->db->insert("tb_link",$inser_array);
				$id = $this->db->insert_id();
			}

			/*
			 * Here id won't be null.Because it will come from database in either of the cases above.
			 * */
			$longUrl = "https://elog360.app/svkonekt_test/index.php/android_map/openmap?id=".$id;

			//TODO Call for Google Shortener Server // sample short url"http:\/\/goo.gl\/3qxTna"
			/*$shortURL = $this->getGoogleShortenerUrl($longUrl, "short");*/
			//$longURL = $this->getGoogleShortenerUrl($shortURL, "long");

			if($longUrl != null)
			{
				$response["error"] = FALSE;
				$response["short_url"] = $longUrl;
			}else{

				$response["error"] = TRUE;
				$response["error_msg"] = "No responce from server";
			}
	}else{
			$response["error"] = TRUE;
			$response["error_msg"] = "User and Mobile are not active";
	}

		echo json_encode($response);


}


/*
 * This getGoogleShortenerUrl will help to get the shorturl from the Google Shortener Server
 * @params long Url
 * */
function getGoogleShortenerUrl($url, $reqFor)
{
	$this->load->library('googleshortener');
	if($reqFor == "short"){
		$googleresponce = $this->googleshortener->shorten($url, false);
	}else if($reqFor == "long"){
		$googleresponce = $this->googleshortener->expand($url, false);
	}else{
		$googleresponce = "";
	}
	return $googleresponce;
}

/** End ***/


}
?>
