<?php

class Ruexpcronjob extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['ruexp_status', 'edi/ediStatusProcess']);
        $this->load->model('common');
        $this->load->helper('log');
    }

    function index(): void
    {
        $getVendorId = $this->common->gettblrowdata(['name' => 'РУС-ЭКСПРЕСС ООО'], 'id', 'tb_vendors', 1, 0);
        if (!empty($getVendorId)) {
            $getOrders = $this->edistatusprocess->get_vendor_related_orders($getVendorId['id']);
            if ((!empty($getOrders))) {
                foreach ($getOrders as $order) {
                    $this->ruexp_status->getrequest($order['ref_value'], $order['id']);
                }
            } else {
                log_error('Ruexpcronjob >> RusExpress orders not found');
            }
        } else {
            log_error('Ruexpcronjob >> RusExpress vendor not found');
        }

    }

}
