<?php

defined('BASEPATH') or exit('No direct script access allowed');

class SVKCustomerAddress extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('cust_id') == "") {
            redirect("login");
        }
        $this->customerId = $this->session->userdata('cust_id');
        $this->userId = $this->session->userdata('user_id');
        $this->load->library('form_validation');
        $this->load->model(["common", "Customeraddress"]);
    }

    public function index(): void
    {
        $customerId = $this->session->userdata('cust_id');
        $companyCode = $this->session->userdata('company_code');
        $customerCID = $this->common->gettblrowdata(["id"=>$customerId],"code","tb_customers",0,0);
        $data["page_title"] = $this->lang->line('customer_address');
        $data["sub_title"] = $this->lang->line('general_search');
        $companyCode = $this->session->userdata('company_code');
        $post = $this->input->post(null, true);
        if (isset($post['searchsubmit']) && $post['searchsubmit'] == "Search") {
            $cid = $this->input->post('cid');
            $customerName = $this->input->post('customerName');
            $emailId = $this->input->post('emailId');
            $phone = $this->input->post('phone');
            $where1 = ['status'=>1,'customer_code'=>$customerCID['code'],'company_code'=>$companyCode];
            if (isset($cid) && $cid != "") {
                $where1['code'] = $cid;
            }
            if (isset($customerName) && $customerName != "") {
                $where1['name'] = $customerName;
            }
            if (isset($emailId) && $emailId != "") {
                $where1['email'] = $emailId;
            }
            if (isset($phone) && $phone != "") {
                $where1['mobile'] = $phone;
            }
            $whr = [];
            $data['getAddresses'] = $this->Customeraddress->getsearchdata($where1, $whr);
            $this->newtemplate->dashboard("customerAddress/index", $data);
        }elseif (isset($post['searchsubmita']) && $post['searchsubmita'] == "Search") {
            $cid2 = $this->input->post('cid2');
            $customerName2 = $this->input->post('customerName2');
            $emailId2 = $this->input->post('emailId2');
            $phone2 = $this->input->post('phone2');
            $street = $this->input->post('street');
            $country = $this->input->post('country');
            $pinCode = $this->input->post('pinCode');
            $where1 = $whr = [];
            if (isset($cid2) && $cid2 != "") {
                $where1['code'] = $cid2;
            }
            if (isset($customerName2) && $customerName2 != "") {
                $where1['name'] = $customerName2;
            }
            if (isset($emailId2) && $emailId2 != "") {
                $where1['email'] = $emailId2;
            }
            if (isset($phone2) && $phone2 != "") {
                $where1['mobile'] = $phone2;
            }
            if (isset($street) && $street != "") {
                $where1['street'] = $street;
            }
            if (isset($country) && $country != "") {
                $where1['country'] = $country;
            }
            if (isset($pinCode) && $pinCode != "") {
                $where1['pincode'] = $pinCode;
            }
            $data['getAddresses'] = $this->Customeraddress->getsearchdata($where1, $whr);
            $this->newtemplate->dashboard("customerAddress/index", $data);
        }else {
            $where = ['status'=>1,'customer_code'=>$customerCID['code'],'company_code'=>$companyCode];
            $whr = [];
            $data['getAddresses'] = $this->Customeraddress->getsearchdata($where, $whr);
            $this->newtemplate->dashboard("customerAddress/index", $data);
        }
    }

    public function add(): void
    {
        $data["page_title"] = $this->lang->line('customer_address');
        $data["sub_title"] = $this->lang->line('general_add');
        $data = $this->getDefaultUserLatLngs($data);
        //$this->newtemplate->dashboard("customerAddress/add", $data);
        $this->load->view("customerAddress/add", $data);
    }

    public function view(int $id): void
    {
        $data['masterData'] = $this->Customeraddress->getData($id);
        $data["page_title"] = $this->lang->line('customer_address');
        $data["sub_title"] = $this->lang->line('general_view');
        $data = $this->getDefaultUserLatLngs($data);
        //$this->newtemplate->dashboard('customerAddress/view', $data);
        $this->load->view("customerAddress/view", $data);
    }

    private function getDefaultUserLatLngs(array $data): array
    {
        $getCustomerDetails = $this->common->gettblrowdata(['id' => $this->customerId], "lat,lng", "tb_customers", 0, 0);
        $data['userLat'] = $getCustomerDetails['lat'] ?? "";
        $data['userLng'] = $getCustomerDetails['lng'] ?? "";
        if (in_array("", [$data['userLat'], $data['userLng']])) {
            $userDetails = $this->common->gettblrowdata(["id" => $this->userId], "lat,lng", "tb_users", 0, 0);
            $data['userLat'] = $userDetails['lat'] ?? "";
            $data['userLng'] = $userDetails['lng'] ?? "";
        }
        return $data;
    }

    public function edit(int $id): void
    {
        $data['masterData'] = $this->Customeraddress->getData($id);
        $data["page_title"] = $this->lang->line('customer_address');
        $data["sub_title"] = $this->lang->line('general_edit');
        $data = $this->getDefaultUserLatLngs($data);
        //$this->newtemplate->dashboard('customerAddress/edit', $data);
        $this->load->view("customerAddress/edit", $data);
    }
    public function fetchProvinces(): void
    {
        $post = $this->input->post(null, true);
        $country = $post['country'];
        $whr = ['status' => 1, 'country' => $country, 'province != '=>''];
        $getProvinceCode = $this->Customeraddress->selectlist('province', 'tb_kn_geocodes', $whr, 'province');
        $option = '<option value="" selected>Select Province</option>';
        foreach ($getProvinceCode as $row) {
            $option .= '<option value="' . $row['province'] . '">' . $row['province'] . '</option>';
        }
        $result['provinces'] = $option;
        echo json_encode($result);
    }
    public function fetchCities(): void
    {
        $post = $this->input->post(null, true);
        $province = $post['province'];
        $country = $post['country'];
        $whr = ['status' => 1, 'province' => $province,'country' => $country, 'city != '=>''];
        $getProvinceCode = $this->Customeraddress->selectlist('city', 'tb_kn_geocodes', $whr, 'city');
        $option = '<option value="" selected>Select City</option>';
        foreach ($getProvinceCode as $row) {
            $option .= '<option value="' . $row['city'] . '">' . $row['city'] . '</option>';
        }
        $result['cities'] = $option;
        echo json_encode($result);
    }
    public function fetchPinCodes(): void
    {
        $post = $this->input->post(null, true);
        $city = $post['city'];
        $province = $post['province'];
        $country = $post['country'];
        $whr = ['status' => 1, 'city' => $city,'province' => $province,'country' => $country];
        $getProvinceCode = $this->Customeraddress->selectlist('postal_code', 'tb_kn_geocodes', $whr, 'postal_code');
        $option = '<option value="" selected>Select Pincode</option>';
        foreach ($getProvinceCode as $row) {
            $option .= '<option value="' . $row['postal_code'] . '">' . $row['postal_code'] . '</option>';
        }
        $result['pinCodes'] = $option;
        echo json_encode($result);

    }
    public function customerAddress(): void {
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        $customerId = $this->session->userdata('cust_id');
        $customerCID = $this->common->gettblrowdata(["id"=>$customerId],"code","tb_customers",0,0);
        $allCustomerIds =['Shipper','consignee','pickup','delivery'];
        $getParties = $this->Customeraddress->getPartyTypes($companyCode,$branchCode,$allCustomerIds);
        $partytypes2 = implode(',', $getParties);
        $post = $this->input->post(null, true);
        extract($post);
        $cid = $cid ?? "";
        $customerName = $customerName ?? "";
        $email = $email  ?? "";
        $phone = $phone ?? "";
        $street = $street ?? "";
        $country = $country ?? "";
        $province = $province ?? "";
        $house_number = $house_number ?? "1";
        $city = $city ?? "";
        $pinCode = $pinCode ?? "";
        $add1 = implode(",", [$street, $city, $country, $pinCode]);
        $data = getlatlngsbyplace($add1);
        $lat1 = @$data[0];
        $lng1 = @$data[1];
        $address = "";
        if($street != ""){
            $address .= $street;
        }
        if($city != ""){
            $address .= ','.$city;
        }
        if($province != ""){
            $address .= ','.$province;
        }
        if($country != ""){
            $address .= ','.$country;
        }
        $masterData = [
            'party_type_id' => $getParties[0],
            'code' => $cid,
            'name' => $customerName,
            'email' => $email,
            'mobile' => $phone,
            'street' => $street,
            'country' => $country,
            'state' => $province,
            'location_id' => $city,
            'pincode' => $pinCode,
            'house_number' => $house_number,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'user_id' => $userId,
            'party_types' => $partytypes2,
            'customer_code' => $customerCID['code'],
            'address' => $address,
            'customeridentifier' => $cid,
            'partyindetifier' => $cid,
            'latitude' =>  $lat1,
            'longitude' => $lng1,
            'status' => '1'
        ];
        $result = $this->common->insertTableData("tbl_party_master", $masterData);
        $partyId = str_pad($result, 4, '0', STR_PAD_LEFT);
        $year          = date('y');
        $week          = date('W');
        $countryCode   = substr($companyCode, 0, 2);

        $get_country_master = $this->common->gettblrowdata(array('status' => 1, 'country_code' => $countryCode), "phone_code", "tbl_country_master", 0, 0);
        if (isset($get_country_master['phone_code']) && $get_country_master['phone_code'] != '') {
            $countryCode = $get_country_master['phone_code'];
        }

        $partyCode = $countryCode . $year . $week . $partyId;
        $upd           = $this->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'customeridentifier' => $partyCode, 'partyindetifier' => $partyCode,], ['id' => $partyId]);

        $status = 0;
        $message = 'Failed to create customer information';
        if ($result) {
            $status = 1;
            $message = 'Customer address created successfully!';
        }
        echo json_encode(compact('status', 'message', 'result', 'masterData'));
    }
    
    public function updateCustomerAddress(): void {
        $post = $this->input->post(null, true);
        extract($post);
        $id = $id;
        $cid = $cid ?? "";
        $ajaxCall = $ajaxCall ?? 0;
        $customerName = $customerName ?? "";
        $email = $email  ?? "";
        $phone = $phone ?? "";
        $house_number = $house_number ?? "1";
        $street = $street ?? "";
        $country = $country ?? "";
        $province = $province ?? "";
        $city = $city ?? "";
        $pinCode = $pinCode ?? "";
        $address = "";
        if($street != ""){
            $address .= $street;
        }
        if($city != ""){
            $address .= ','.$city;
        }
        if($province != ""){
            $address .= ','.$province;
        }
        if($country != ""){
            $address .= ','.$country;
        }
        $add1 = implode(",", [$street, $city, $country, $pinCode]);
        $data = getlatlngsbyplace($add1);
        $lat1 = @$data[0];
        $lng1 = @$data[1];
        $masterData = [
            'name' => $customerName,
            'email' => $email,
            'mobile' => $phone,
            'street' => $street,
            'house_number' => $house_number,
            'country' => $country,
            'state' => $province,
            'location_id' => $city,
            'pincode' => $pinCode,
            'address' => $address,
            'latitude' =>  $lat1,
            'longitude' => $lng1,
        ];
        $customerAddressInfo = $this->common->gettblrowdata(["id"=>$id], 'street,house_number,country,state,pincode', 'tbl_party_master', 0, 0);
        $result2 = $this->common->updatetbledata("tbl_party_master", $masterData, ["id"=>$id]);
        if ($ajaxCall > 0) {
            echo json_encode(['masterData' => $masterData, 'status' => '1']);
        } else {
            redirect("SVKCustomerAddress");
        }

    }
    public function delete($id = null): void
    {
        if ($id == null) {
            redirect("SVKCustomerAddress");
        } else {
            if ($id != '0') {
                $this->common->updatetbledata('tbl_party_master', ["status"=>0],["id" =>$id]);
            }

            redirect("SVKCustomerAddress");
        }
    }

    public function checkname() {
        $isExistingCustomer = 0;
        $customerName   = $this->input->post('customerName',TRUE);
        $country        = $this->input->post('country',TRUE);
        $id = $this->input->post('id',TRUE);
        $whereCondition = [
            'name'=>$customerName,
            'country'=>$country,
        ];
        if ($id > 0) {
            $whereCondition['id !='] = $id;
        }
        $customerInfo = $this->common->gettblrowdata($whereCondition, 'name', 'tbl_party_master', 0, 0);
        if (!empty($customerInfo)) {
            $isExistingCustomer = 1;
        }
        echo json_encode(['isExistingCustomer'=>$isExistingCustomer]);
    }
}
