<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";
require_once './vendor/autoload.php';
use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Message\AMQPMessage;
use PhpAmqpLib\Connection\AMQPSSLConnection;
use PhpAmqpLib\Wire;

class Sendmultipleaconedi extends CI_Controller {
	public function __construct(){
		parent::__construct();
		$this->load->library('Exchangerate');
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('aconedimodel');
		$this->load->model('multipleaconedimodel');
		$this->load->model('common');
		$this->load->model('sgmyjfrmodel');
	}

	public function index(){
		echo "SEND MULTIPLE ACON INVOICES";
	}

	public function filetrasnferfor_selectedorders(){
		ini_set('max_execution_time', 300);
	    $post = $invoiceddata = $tobeinvoiced = $sendorders = $norevenues = $invoiced_orders = $tobeinvoice_orders = $send_orders = $norev_orders = $ids = $all_ordids = $invoiced_revids = $notrip_ids = $notrip_orders = $leg_row_ids = array();
		$post = $this->input->post(NULL,TRUE);
		$responce = $booking_id = "";
		$sts = $shift_id = 0;
		$order_ids = isset($post['order_ids']) ? $post['order_ids'] : array();
		if(!empty($order_ids)){
			foreach ($order_ids as $oids) {
				$sts =0;
				if($oids['ids'] > 0){
					$chktrip = $this->common->gettblrowdata(array( 'id' => $oids['ids'] ), "order_id,shift_id,trip_id", "tb_orders", 0, 0);
					if(!empty($chktrip)){
						$trip_id    = $chktrip['trip_id'];
						$booking_id = $chktrip['order_id'];
						$shift_id   = $chktrip['shift_id'];
						if($trip_id >0){
							$sts = 1;
						}else{
							$sts =0;
							if($shift_id > 0){
								$getleg_ids = $this->common->gettbldata(array( 'shift_leg_id' => $shift_id,'status'=>'1'), "id", "tb_shifts", 0, 0);
								if(!empty($getleg_ids)){
									foreach ($getleg_ids as $res){
										$leg_row_ids[] = $res['id'];
									}
								}
								if(!empty($leg_row_ids)){
									$sts = $this->sgmyjfrmodel->checkactivetripornot($leg_row_ids);
								}
							}
						}
					}
					if($sts == '1'){
						$ids[] = $oids['ids'];
					}else{
						$notrip_ids[] = $oids['ids'];
					}
				}
			}
			$response = $this->multipleaconedimodel->checkmultiple_ordersinternlbu($ids);
			if(!empty($response)){
				foreach ($response as $row) {
					$all_ordids[] = $row['order_id'];
					$invoice_status = $row['invoice_status'];
					if($invoice_status == "1"){
					/* send fto f code here */
						$invoiced_revids[] = $row['rev_id'];

						$invoiceddata[] = $row['order_id'];
					}else if($invoice_status == '0'){
						$tobeinvoiced[] = $row['order_id'];
					}else if($invoice_status >2){
						$sendorders[] = $row['order_id'];
					}
				}
			}
			if(!empty($invoiced_revids)){
				$this->mumtiplefiletransfer($invoiced_revids);
			}
		}
		if(!empty($all_ordids)){
			$norevenues = array_diff($ids, $all_ordids);
		}else{
			$norevenues = $ids;
		}
		if(!empty($invoiceddata)){
			$invoiced_orders = $this->multipleaconedimodel->checkfile_sendornot($invoiceddata);
		}
		if(!empty($tobeinvoiced)){
			$tobeinvoice_orders = $this->multipleaconedimodel->getbookingid($tobeinvoiced,'Order status is not in "Ready To Invoice"');
		}
		if(!empty($sendorders)){
			$send_orders = $this->multipleaconedimodel->getbookingid($sendorders,'File Transfer is already Done');
		}
		if(!empty($norevenues)){
			$norev_orders = $this->multipleaconedimodel->getbookingid($norevenues,'Internal Bu not found for these order');
		}
		if(!empty($notrip_ids)){
			$notrip_orders = $this->multipleaconedimodel->getbookingid($notrip_ids,'Driver Acceptence not done');
		}
		$result = array();
		if(!empty($send_orders)){
			foreach ($send_orders as $ord) {
				$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
			}
		}
		if(!empty($tobeinvoice_orders)){
			foreach ($tobeinvoice_orders as $ord) {
				$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
			}
		}
		if(!empty($invoiced_orders)){
			foreach ($invoiced_orders as $ord) {
				$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
			}
		}
		if(!empty($norev_orders)){
			foreach ($norev_orders as $ord) {
				$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
			}
		}
		if(!empty($notrip_orders)){
			foreach ($notrip_orders as $ord) {
				$result[] = array('id'=>$ord['bookingid'],'status'=>$ord['status']);
			}
		}
		echo json_encode($result);
	}

	public function mumtiplefiletransfer($revids){
		$bu_data = $rev_ids = $order_ids = array();
		$curdt = date('Y-m-d H:i:s');
		if(!empty($revids)){
			$zonecode = $this->session->userdata("usr_tzone");
			$curtz = $zonecode['timezone'];
			$cntryname = $zonecode['country_name'];
			$cntrycode = $zonecode['country'];
			$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
			$timestamp = $getactual['date']."T".$getactual['time']."Z";
			$company_code = $this->session->userdata("company_code");
			$branch_code = $this->session->userdata("branch_code");
			$country_code = substr($company_code, 0,2);
			$invoice_no = $acon_code = $currency = $invoice_date = $routing_company =  "";
			$user_id = $this->session->userdata('user_id');
			$user_name = "";
			$getuserdetails = $this->common->gettblrowdata(array('id' => $user_id),'name','tb_users',0,0);
			if(!empty($getuserdetails)){
				$user_name = $getuserdetails['name'];
			}
			$acon_country = $logical_sender = "";
			$getacon_country = $this->aconedimodel->gettblrowdata(array("branch_code"=>$branch_code,'company_code'=>$company_code),"logical_sender,acon_country","tb_branch_master",0,0);
			if(count($getacon_country)>0){
				$acon_country = $routing_company = $getacon_country['acon_country'];
				$logical_sender = $getacon_country['logical_sender'];
			}
			$invoice_date = $getactual['date'];
			$fileperiod = date('Ym',strtotime($getactual['date']));
			$where = "p.status ='1' AND p.acon_debitor_code <> ''  AND r.amount >0 AND r.invoice_status ='1' AND r.status ='1'";
			$get_burevenue= $this->multipleaconedimodel->getbudetails_forrevenue($revids,$where);
			if(!empty($get_burevenue)){
				foreach ($get_burevenue as $bu_rev) {
					$order_id = $bu_rev['order_id'];
					$order_weight = 0;
					$createdon = $ordernum ="";
					if($order_id >0){
						$order_ids[] = $order_id;
						$getorderdetails = $this->common->gettblrowdata(array('id' => $order_id,'status>'=>'0'),'order_id,weight,createdon','tb_orders',0,0);
						if(!empty($getorderdetails)){
							$ordernum = $getorderdetails['order_id'];
							$createdon = $getorderdetails['createdon'];
							$order_weight = $getorderdetails['weight'];
						}
						$currency = $bu_rev['currency'];
						$type = $bu_rev['type'];
						$debtor_jfr = $bu_rev['debtor_jfr'];
						$bu_jfr = $bu_rev['bu_jfr'];
						$acon_code = $bu_rev['acon_debitor_code'];
						$revenue_id= $bu_rev['id'];
						$bucharges = array();
						$getcharges = $this->aconedimodel->getcharges($revenue_id);
						if ($getcharges->num_rows() > 0) {
							foreach($getcharges->result() as $bucharge) {
								$bucharges[] = array('amount'=>$bucharge->amount,"debtor_jfr"=>$debtor_jfr,'local_amount'=>$bucharge->local_amount,'local_currency'=>$bucharge->local_currency);
							}
						}
						if(!empty($bucharges)){
							$rev_ids[] = $revenue_id;
							$bu_data[] = array('acon_country'=>$routing_company,'acon_code'=>$acon_code,'issuedate'=>$fileperiod,'currency'=>$currency,'invoice_no'=>$invoice_no ,'charges'=>$bucharges,'invoice_date'=>$invoice_date,'debtor_jfr'=>$debtor_jfr,'bu_jfr'=>$bu_jfr,'ordernum'=>$ordernum,'type'=>$type);
						}
					}
				}
			}
			if(!empty($bu_data)){
				$this->load->library('uuid');
				$uuid = $this->uuid->v4();
				$headerdata = array('uuid'=>$uuid,'routing_country'=>$country_code,'routing_company'=>$routing_company);
				if(!empty($rev_ids)){
					$updar = array('invoice_number'=>"",'invoice_date'=>$invoice_date,'invoice_creation_date'=>$curdt,'invoice_receivdon_date'=>$curdt,'invoice_status'=>3);
					$upd_rev = $this->multipleaconedimodel->updatemultiplerevs($rev_ids,$updar);
					$ShipmentPayLoad = array();
					foreach ($bu_data as $budata) {
						$ShipmentPayLoad[] = $this->multiplefiletransferxml($budata,$fileperiod);
					}
					if(!empty($ShipmentPayLoad)){
						$sendfilexml = $this->publish_multiplefiletransferxml($ShipmentPayLoad,$headerdata);
					}
				}
			}
			$chkaccrl = $this->check_accrualtosend($order_ids);
		}
		return '1';
	}

	function check_accrualtosend($ids){
		$curdt = date('Y-m-d H:i:s');
		$invoiced_ids = $norev_orders = $rev_orders = $cost_ids = $order_ids = array();
		$company_code = $this->session->userdata("company_code");
		$branch_code = $this->session->userdata("branch_code");
		$zonecode = $this->session->userdata("usr_tzone");
		$cntryname = $zonecode['country_name'];
		$cntrycode = $zonecode['country'];
		$session_currency = isset($zonecode['currency']) ? $zonecode['currency'] : "";
		$curtz = $zonecode['timezone'];
		$getactual = getdatetimebytimezone($curtz,$curdt,DFLT_TZ);
		$timestamp = $getactual['date']."T".$getactual['time']."Z";
		if(!empty($ids)){
			$ids = $this->multipleaconedimodel->check_revenueexistsornot($ids);
			if(!empty($ids)){
				$norev_orders = isset($ids['norev_orders']) ? $ids['norev_orders'] : array();
				$rev_orders = isset($ids['rev_orders']) ? $ids['rev_orders'] : array();
				if(!empty($norev_orders)){
					$invoiced_ids = getdebitorcode_multiplerevenue($norev_orders);
					if(!empty($invoiced_ids)){
						$country_code = substr($company_code, 0,2);
						$invoice_no = $acon_code = $currency = $invoice_date = $routing_company =  "";
						$user_id = $this->session->userdata('user_id');
						$user_name = "";
						$getuserdetails = $this->common->gettblrowdata(array('id' => $user_id),'name','tb_users',0,0);
						if(!empty($getuserdetails)){
							$user_name = $getuserdetails['name'];
						}
						$acon_country = $logical_sender = "";
						$getacon_country = $this->aconedimodel->gettblrowdata(array("branch_code"=>$branch_code,'company_code'=>$company_code),"logical_sender,acon_country","tb_branch_master",0,0);
						if(count($getacon_country)>0){
							$acon_country = $routing_company = $getacon_country['acon_country'];
							$logical_sender = $getacon_country['logical_sender'];
						}
						$where = "p.status ='1' AND p.acon_debitor_code <> '' AND r.type='1' AND r.amount >0 AND r.invoice_status ='1' AND r.status ='1'";
						$get_cost= $this->multipleaconedimodel->getbudetails_forrevenue($invoiced_ids,$where);
						if(!empty($get_cost)){
							foreach ($get_cost as $cost) {
								$order_id         = $cost['order_id'];
								$cost_row_id      = $cost['id'];
								$cost_ids[]       = $cost['id'];
								$carrier_code     = $cost['recipient_code'];
								$carrier_aconcode = $cost['acon_debitor_code'];
								$debtor_jfr       = $cost['debtor_jfr'];
								$currency         = $cost['currency'];
								$invoice_number   = $cost['invoice_number'];
								$invoice_no       =  $invoice_number;
								$invoice_date     = date('Y-m-d',strtotime($curdt));
								$fileperiod       = date('Ym',strtotime($invoice_date));
								if($company_code == "PLKN"){
									$session_currency = "PLN";
								}
								$charges = array();
								if($debtor_jfr != "" && $carrier_aconcode != ""){
									$getcharges = $this->aconedimodel->getcharges($cost_row_id);
									if ($getcharges->num_rows() > 0) {
										foreach ($getcharges->result() as $charge) {
											$charge_currency = $charge->currency;
											if($charge_currency != $session_currency){
												$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>round($charge->local_amount,2),'local_currency'=>$charge->local_currency);
											}else {
												$charges[] = array('amount'=>round($charge->amount,2),'currency'=> $charge_currency ,'local_amount'=>0,'local_currency'=>"");
											}
										}
									}
									$order_weight = 0;
									$getorderdetails = $this->common->gettblrowdata(array('id' => $order_id),'weight','tb_orders',0,0);
									if(!empty($getorderdetails)){
										$order_weight = $getorderdetails['weight'];
									}
									$updar = array('debtor_jfr'=>$debtor_jfr,'invoice_number'=>$debtor_jfr,'invoice_date'=>$invoice_date,'invoice_creation_date'=>$getactual['datetime'],'invoice_receivdon_date'=>$getactual['datetime'],'invoice_status'=>2);
									$cstid = array($cost_row_id);
									$upd_rev = $this->multipleaconedimodel->updatemultiplerevs($cstid,$updar);
									$order_ids[] = $order_id;
									$data_arr[] = array('order_id'=>$order_id,'carrier_aconcode'=>$carrier_aconcode,'order_weight'=>$order_weight,'invoice_date'=>$invoice_date,'currency'=>$currency ,'charges'=>$charges,'fileperiod'=>$fileperiod,'user_name'=>$user_name,'acon_country'=>$acon_country,'debtor_jfr'=>$debtor_jfr);
								}
							}
							if(!empty($charge)){
								$this->load->library('uuid');
								if(!empty($data_arr)){
									if(!empty($cost_ids)){
										$accuralxml[] = $this->multipleaccuralxml($data_arr);
										$uuid = $this->uuid->v4();
										$headerdata = array('uuid'=>$uuid,'logical_sender'=>$logical_sender,'country_code'=>$country_code ,'acon_country'=>$acon_country,'branch_code'=>$branch_code,'routing_department'=>"");
										$sendaccuralxml = $this->send_multiplepublishaccuralxml($accuralxml,$headerdata);
									}
								}
							}
						}
					}
				}
			}
		}
		return '1';
	}

	public function send_multiplepublishaccuralxml($accuralxml,$headerdata){
		$ssl_options = array(
			'verify_peer' => false,
			'verify_peer_name' => false
		);
		if(!empty($accuralxml)){
			 $headers = new Wire\AMQPTable
			(array(
				'uuid' => $headerdata['uuid'],
				'KN_MS_PhysSenderID' => 'KNRLG01',
				'KN_MS_LogSenderID' => $headerdata['logical_sender'],
				'KNESB_Routing_SenderId' => ACON_USRNAME,
				'KNESB_Routing_SenderInstance' => 'TEST_ACCEPTANCE',
				'KNESB_Routing_ReceiverId' => 'KNBILL',
				'KNESB_Routing_ReceiverInstance' => 'ACCEPTT',
				'KNESB_Routing_Country' => $headerdata['country_code'],
				'KNESB_Routing_Company' => $headerdata['acon_country'],
				'KNESB_Routing_Branch' => $headerdata['branch_code'],
				'KNESB_Routing_Department' => 'CTP'
			));

			$headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
			$connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME,ACON_PWD, ACON_ESB, $ssl_options);
			$channel = $connection->channel();
			foreach ($accuralxml as $generalxml) {
				$Xmldata = new AMQPMessage($generalxml,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::	DELIVERY_MODE_PERSISTENT));
				$Xmldata->set('application_headers', $headers);
			    $channel->basic_publish($Xmldata,ACON_ACCRUAL_URL,null);
			}
			$channel->close();
			$connection->close();
		}
		return '1';
	}

	public function multipleaccuralxml($data_arr){
	$accuralxml = "";
	$accuralxml .= '<?xml version="1.0" encoding="UTF-8"?>';
	$accuralxml .= '<AccruedExpenses xmlns="http://services.kn.com/xsd/acon/fsl/AccuredExpenses/v1">';
	$i =1;
	foreach ($data_arr as $data) {
		foreach($data['charges'] as $charges){
			$accuralxml .= '<AccruedExpense>';
			$accuralxml .= '<CompanyCode>'.$data['acon_country'].'</CompanyCode>';
			$accuralxml .= '<CallingApplication>ETRUCACC</CallingApplication>';
			$accuralxml .= '<TxDate>'.$data['invoice_date'].'</TxDate>';
			$accuralxml .= '<CreditorCode>'.$data['carrier_aconcode'].'</CreditorCode>';
			$accuralxml .= '<JobFileNo>'.$data['debtor_jfr'].'</JobFileNo>';
			$accuralxml .= '<FilePeriod>'.$data['fileperiod'].'</FilePeriod>';
			$accuralxml .= '<ChargeCategory>045</ChargeCategory>';
			if($charges['local_amount'] > 0){
				$accuralxml .= '<CurrencyCode>'.$charges['local_currency'].'</CurrencyCode>';
				$accuralxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
				$accuralxml .= '<AccrualLCAmount>'.$charges['local_amount'].'</AccrualLCAmount>';
			}else{
				$accuralxml .= '<CurrencyCode>'.$charges['currency'].'</CurrencyCode>';
				$accuralxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
				$accuralxml .= '<AccrualLCAmount>'.$charges['amount'].'</AccrualLCAmount>';
			}
			$accuralxml .= '<Weight>'.$data['order_weight'].'</Weight>';
			$accuralxml .= '<SequenceNo>'.$i.'</SequenceNo>';
			$accuralxml .= '<InterfaceStatus>A</InterfaceStatus>';
			$accuralxml .= '<CostType>R</CostType>';
			if($charges['local_amount'] > 0){
				$accuralxml .= '<ForeignCurrencyCode>'.$charges['currency'].'</ForeignCurrencyCode>';
				$accuralxml .= '<AccrualFCAmount>'.$charges['amount'].'</AccrualFCAmount>';
			}

			$accuralxml .= '<LastUpdatedUser>'.$data['user_name'].'</LastUpdatedUser>';
			$accuralxml .= '</AccruedExpense>';
			$i++;
		}
	}
	$accuralxml .= '</AccruedExpenses>';
	return $accuralxml;
}

	public function publish_multiplefiletransferxml($filexml,$headerdata){
		if(!empty($filexml)){
			$ssl_options = array(
				'verify_peer' => false,
				'verify_peer_name' => false
			);
			$headers = new Wire\AMQPTable
			(array(
				'uuid' => $headerdata['uuid'],
				'KNESB_Routing_SenderId' => ACON_SENDERID,
				'KNESB_Routing_SenderInstance' => 'PROD',
				'KNESB_Routing_Country' => $headerdata['routing_country'],
				'KNESB_Routing_Company' => $headerdata['routing_company']

			));
			$headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
			$connection = new AMQPSSLConnection(ACON_URL, 5671, ACON_USRNAME,ACON_PWD, ACON_ESB, $ssl_options);
			$channel = $connection->channel();
			foreach ($filexml as $aconxml) {
				$Xmldata = new AMQPMessage($aconxml,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
				$Xmldata->set('application_headers', $headers);
				$channel->basic_publish($Xmldata,ACON_FILE_PUBLISHURL,null);
			}
			$channel->close();
			$connection->close();
		}
		return '1';
	}


	public function multiplefiletransferxml($revenue,$yearmonth){
		$company_code = $this->session->userdata('company_code');
		$transferlcamount = $type = 0;
		foreach($revenue['charges'] as $charge){
			$local_currency = $charge['local_currency'];
			$transferlcamount += $charge['local_amount'];
		}
		$type = isset($revenue['type']) ? $revenue['type'] : "0";
		$date = date('Y-m-d');
		$transferxml = "";
		$transferxml .= '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$transferxml .= '<FileTransfers xmlns="http://services.kn.com/xsd/acon/fsl/FileTransfers/v1">';
		$transferxml .= '<FileTransfer>';
		$transferxml .= '<CompanyCodeFrom>'.$revenue['acon_country'].'</CompanyCodeFrom>';
		$transferxml .= '<FilePeriodFrom>'.$yearmonth.'</FilePeriodFrom>';
		if($company_code == "RUKN"){
			$revenue['bu_jfr'] =  substr($revenue['bu_jfr'],2);
			$transferxml .= '<JobFileNoFrom>'.$revenue['bu_jfr'].'</JobFileNoFrom>';
		}else{
			if($type == 1){
				$revenue['bu_jfr'] =  substr($revenue['bu_jfr'],2);
				$transferxml .= '<JobFileNoFrom>'.$revenue['bu_jfr'].'</JobFileNoFrom>';
			}else{
				$transferxml .= '<JobFileNoFrom>'.$revenue['debtor_jfr'].'</JobFileNoFrom>';
			}
		}
		$transferxml .= '<BillingCompletedInFrom>Y</BillingCompletedInFrom>';
		$transferxml .= '<CompanyCodeTo>'.$revenue['acon_country'].'</CompanyCodeTo>';
		if($company_code == "RUKN"){
			$transferxml .= '<FilePeriodTo>'.$yearmonth.'</FilePeriodTo>';
			$transferxml .= '<JobFileNoTo>'.$revenue['debtor_jfr'].'</JobFileNoTo>';
		}else{
			if($type == 1){
				$transferxml .= '<FilePeriodTo>'.$yearmonth.'</FilePeriodTo>';
				$transferxml .= '<JobFileNoTo>'.$revenue['debtor_jfr'].'</JobFileNoTo>';
			}else{
				$trackingno = $profitcentre = '';
				if(strlen($revenue['bu_jfr'])==15){
					if (strpos($revenue['bu_jfr'], '-') !== false) {
						$track_profit = explode("-", $revenue['bu_jfr']);
						if(isset($track_profit[0])){
							$trackingno = $track_profit[0];
						}
						if(isset($track_profit[1])){
							$profitcentre = $track_profit[1];
						}
						if($trackingno !='' && $profitcentre !=''){
							$transferxml .= '<TrackingNoTo>'.$trackingno.'</TrackingNoTo>';
							$transferxml .= '<ProfitCentreTo>'.$profitcentre.'</ProfitCentreTo>';
							$transferxml .= '<FilePeriodTo>'.$yearmonth.'</FilePeriodTo>';
						}
					}
				}else if(strlen($revenue['bu_jfr'])==16){
					$revenue['bu_jfr'] =  substr($revenue['bu_jfr'],2);
					$transferxml .= '<FilePeriodTo>'.$yearmonth.'</FilePeriodTo>';
					$transferxml .= '<JobFileNoTo>'.$revenue['bu_jfr'].'</JobFileNoTo>';
				}
			}
		}

		$transferxml .= '<CallingApplication>ETRUCTXF</CallingApplication>';
		$transferxml .= '<TransferDate>'.$date.'</TransferDate>';
		$transferxml .= '<CreditorCode>'.$revenue['acon_code'].'</CreditorCode>';
		$transferxml .= '<ChargeCode>045</ChargeCode>';
		$transferxml .= '<ChargeCategory>045</ChargeCategory>';
		$transferxml .= '<TransferType>I</TransferType>';
		$transferxml .= '<CurrencyCode>'.$local_currency.'</CurrencyCode>';
		$transferxml .= '<LCDecimalPlace>2</LCDecimalPlace>';
		$transferxml .= '<TransferLCAmount>'.round($transferlcamount,2).'</TransferLCAmount>';
		$transferxml .= '<ItemType>I</ItemType>';
		$transferxml .= '<ItemNo>'.$revenue['ordernum'].'</ItemNo>';
		$transferxml .= '<SequenceNo>1</SequenceNo>';
		$transferxml .= '</FileTransfer>';
		$transferxml .= '</FileTransfers>';
		return $transferxml;
	}
}
?>
