<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Services extends CI_Controller {

    public function __construct() {
		parent::__construct();
		if($this->session->userdata('user_id') == ''){
			redirect('login');
        }
		$this->load->library('form_validation');
        $this->load->model('common');
        $this->load->model('servicesmodel');
        if (!checkUrlAccessForUser('SERVICES')) {
            redirect("Forbiddenaccess");
        }
	}

    public function index()	{
		$data['page_title'] = $this->lang->line('bpartner_service');
		$data['sub_title'] = $this->lang->line('bpartner_service');
        $user_id = $this->session->userdata('user_id');
        if(!empty($this->input->post('from_date')) && !empty($this->input->post('to_date'))){
            $from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
            $to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
        } else {
            $from_date = null;
            $to_date = null;
        }
        //$where['status'] = 1;
        $where = array();
        if($this->input->post('company_code')){
            $where['tsm.company_code'] = $this->input->post('company_code');
        }
        if($this->input->post('branch_code')){
            $where['tsm.branch_code'] = $this->input->post('branch_code');
        }
        $search = !empty($this->input->post('search_string'))?$this->input->post('search_string'):null;
        $data['services'] = $this->servicesmodel->getcustomerwiseServices($search,$where,$from_date,$to_date);
		$this->newtemplate->dashboard("services/index", $data);
    }

    public function checkBranchCode($branch_code){
        if(empty($branch_code)){
            $this->form_validation->set_message('checkBranchCode','branch Code  Required');
            return FALSE;
        } else {
            $where = array('branch_code'=>$branch_code,'company_code'=>$this->input->post('company_code'));
            $user = $this->common->gettblrowdata($where,'id','tb_users',0,0);
            if($user){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkBranchCode',"User not existed for this company and branch");
                return FALSE;
            }
        }
    }

    public function checkServiceid($serviceid){
        if(empty($serviceid)){
            $this->form_validation->set_message('checkServiceid','Service ID  Required');
            return FALSE;
        } else {
            $where = array('service_id'=>$serviceid,'company_code'=>$this->input->post('company_code'));
            $id = $this->uri->segment(3);
            if($id){
                $where['id !='] = $id;
            }
            $service = $this->common->gettblrowdata($where,'id','tb_service_master',0,0);
            if($service){
                $this->form_validation->set_message('checkServiceid',"Service ID existed");
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function add()   {
        $data['page_title'] = $this->lang->line('bpartner_service');
        $data['sub_title'] = $this->lang->line('bpartner_service');
        $data['cmp_branch'] = $this->db->get_where("tb_branch_master", array("status" => 1));
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        if(!empty($post)){
            
            $this->form_validation->set_rules('service_id', 'Service ID', 'required');
            if ($this->form_validation->run() == false) {
                $this->newtemplate->dashboard('services/add', $data);
            } else {
                $user = $this->common->gettblrowdata(array('company_code'=>$this->input->post('company_code',TRUE),'branch_code'=>$this->input->post('branch_code',TRUE)),'id','tb_users',0,0);
                $array['company_code'] = $companycode = $this->input->post('company_code',true);
                $array['branch_code'] = $branchcode =$this->input->post('branch_code',true);
                $array['user_id'] = (!empty($user['id']))?$user['id']:0;
                $array['service_id'] = $service_id = $this->input->post('service_id',true);
                $array['name'] = $this->input->post('name',true);
                $array['status'] = $this->input->post('status',true);
                $array['createdon'] = date('Y-m-d H:i:s');
                $array['updatedon'] = date('Y-m-d H:i:s');
                $customer_id = $this->input->post('getcustomer_id');
                $checkdata = $this->checkservicedata($companycode,$branchcode,$service_id);
                if(!empty($checkdata)){
                    if(!empty($customer_id)){
                        $sub_data['customer_id'] = $customer_id;
                        $sub_data['servicerow_id'] = $checkdata;
                        $service_data = $this->common->gettblrowdata($sub_data, 'id', 'customer_servicedata', 0, 0);
                        if ($service_data['id'] == '') {
                            $this->common->insertTableData('customer_servicedata', $sub_data);
                            redirect('services');
                        }
                        else{
                            $this->session->set_flashdata('checkServicecustid', "Service ID existed with this Customer");
                        }
                    }else {
                        $this->session->set_flashdata('checkServiceid', "Service ID existed");
                    }
                    redirect('services/add');
                }
                else{
                    $result_id = $this->common->insertTableData('tb_service_master',$array);
                    if(!empty($customer_id)) {
                        $sub_data['customer_id'] = $customer_id;
                        $sub_data['servicerow_id'] = $result_id;
                        $this->common->insertTableData('customer_servicedata', $sub_data);
                    }
                    redirect('services');
                }

            }
        } else {
            $this->newtemplate->dashboard('services/add', $data);
        }
    }

    public function edit($id,$cid='') {
        $data['page_title'] = $this->lang->line('bpartner_service');
        $data['sub_title'] = $this->lang->line('bpartner_service');
        $data['service']   = $this->common->gettblrowdata(array('id'=>$id),'*','tb_service_master',1,1);
        $data['customer_id'] = $cid;
        if(!empty($data['service']['company_code'])) {
            $swhere['company_code'] = $data['service']['company_code'];
        }
        if(!empty($data['service']['branch_code'])) {
            $swhere['branch_code'] = $data['service']['branch_code'];
        }

        if(!empty($swhere)) {
            $customer = $this->db->select('id,name,code')->get_where("tb_customers", $swhere);
            $data['customers'] = $customer->result_array();
        }
        else{
            $data['customers'] = [];
        }
        if(isset($data['service']['id'])) {
            $post = array();
            $post = $this->input->post(NULL,TRUE);
            if(!empty($post)){

                $this->form_validation->set_rules('service_id', 'Service ID', 'required');
                if ($this->form_validation->run() == false) {
                    $this->newtemplate->dashboard('services/edit', $data);
                } else {
				
                    $user = $this->common->gettblrowdata(array('company_code'=>$this->input->post('company_code',true),'branch_code'=>$this->input->post('branch_code',true)),'id','tb_users',0,0);
                    $array['company_code'] = $companycode = $this->input->post('company_code',true);
                    $array['branch_code'] = $branchcode = $this->input->post('branch_code',true);
                    $array['user_id'] = (!empty($user['id']))?$user['id']:0;
                    $array['service_id'] = $service_id = $this->input->post('service_id',true);
                    $array['name'] = $this->input->post('name',true);
                    $array['updatedon'] = date('Y-m-d H:i:s');
                    $array['status'] = $this->input->post('status',true);
                    $customer_id = $this->input->post('getcustomer_id');
                    $checkdata = $this->checkservicedata($companycode,$branchcode,$service_id);
                    if(!empty($checkdata) && !empty($customer_id)) {
                        if(!empty($cid)) {
                            $where['servicerow_id'] = $checkdata;
                            $where['customer_id'] = $cid;
                        }else{
                            $where['servicerow_id'] = $checkdata;
                            $where['customer_id'] = $customer_id;
                        }
                        $service_data = $this->common->gettblrowdata($where,'id','customer_servicedata',0,0);
                        if($service_data['id'] == '') {
                            $sub_data['customer_id']   = $customer_id;
                            $sub_data['servicerow_id'] = $checkdata;
                            $this->common->insertTableData('customer_servicedata', $sub_data);
                        }
                        else{
                            $sub_data['customer_id']   = $customer_id;
                            $this->common->updatetbledata('customer_servicedata',$sub_data,array('id'=>$service_data['id']));
                        }
                    }
                    $this->common->updatetbledata('tb_service_master',$array,array('id'=>$id));
                    redirect('services');
                }
            } else {
                $this->newtemplate->dashboard('services/edit', $data);
            }
        } else {
            show_error('The Service you are trying to Edit does not exist.');
        }
    }

    public function deleteservice($id){
		if($id != '' || $id != 0){
            $chk = $this->common->gettblrowdata(array('id'=>$id),'id','tb_service_master',0,0);
			if($chk){
				$upd = $this->common->updatetbledata('tb_service_master',array('status'=>0),array('id'=>$id));
				if($upd){
                    $this->common->updatetbledata('customer_servicedata',array('status'=>0),array('servicerow_id'=>$id));
					echo "1";
				}else{
					echo "0";
				}
			}else{
				echo "0";
			}
		}
    }

    public function view($id,$cid=''){
        $data['page_title'] = $this->lang->line('bpartner_service');
        $data['sub_title'] = $this->lang->line('bpartner_service');
        $data['service'] = $this->common->gettblrowdata(array('id'=>$id),'*','tb_service_master',1,1);
        $data['service_customer'] = $this->servicesmodel->getCustomerdata($id,$cid);
        $this->newtemplate->dashboard('services/view', $data);
    }

    public function checkservicedata( string $companycode , string $branchcode, string $service_id): int{
         if(!empty($companycode) && !empty($service_id)){
            $sdata =  $this->common->gettblrowdata(array('company_code'=>$companycode,'branch_code'=>$branchcode,'service_id'=>$service_id),'id','tb_service_master',0,0);
            if($sdata){
                return $sdata['id'];
            }else{
                $maindata =  $this->common->gettblrowdata(array('company_code'=>'','branch_code'=>'','service_id'=>$service_id),'id','tb_service_master',0,0);
                return ($maindata) ? $maindata['id'] : 0 ;
            }
         }
         else{
             return 0;
         }
    }

    public function viewcustomerslist()
    {
        $ccode = $this->input->post('cid') ?? "";
        $bcode = $this->input->post('bid') ?? "";
        $result = array();
        $where = [];
        if(!empty($ccode)){
            $where['company_code'] =  $ccode;
        }
        if(!empty($bcode)) {
            $where['branch_code'] =  $bcode;
        }
        $c_list = $this->servicesmodel->getCustomerList($where);
        $customer = '<select class="form-control" id="getcustomer_id" name="getcustomer_id">
                      <option value="">--select customer--</option>';
        if ($c_list) {
            foreach ( $c_list as $cust ) {
                $customer .= '<option value="' . $cust->id . '">' . $cust->name . ' - '.$cust->code .'</option>';
            }
        }
        $customer .='</select>';
        $result['customers'] = $customer ?? "";
        echo json_encode( $result );
    }
}

