<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Shift extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('cabmodel');
        $this->load->model('common');
        $this->load->model('truckwaybillmodel');
        $this->load->library('sendfirebase');
        $this->load->library(['smsnotifier', 'TripCreateFromOrders']);
        $userRoleId = $this->session->userdata('user_role_id');
        if ($userRoleId !== "5" && !checkUrlAccessForUser('SHIFT')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data["table_search"] = $whr = "";
        if ($_GET) {
            $data["table_search"] = $s = $_GET["table_search"];
            $whr = " AND (s.splace like '%" . $s . "%' OR s.eplace like '%" . $s . "%' OR s.empshift_start like '%" . $s . "%')";
        }
        $user = $this->session->userdata('user_id');
        $data['page_title'] = "Shipments";
        $data['sub_title'] = "Shipments List";
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $data["normal_shifts"] = $this->db->query(
            "SELECT s.id,s.splace,s.eplace,convertToClientTZ(s.startdate,'" . $curtz . "') as startdate,convertToClientTZ(s.enddate,'" . $curtz . "') as enddate, s.shipment_name, s.carrier_type, IFNULL(CONCAT(t.status,'@', t.transit_status),'New') AS astatus FROM `tb_shifts` s LEFT JOIN tb_trips t ON s.id=t.shift_id WHERE s.`user_id` = " . $user . " AND s.status='1'" . $whr . " and s.trip_type=0 order by s.startdate ASC"
        );
        $this->settemplate->dashboard("shift/shifts", $data);
    }

    public function newShift($id = null)
    {
        $user = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $data['trip_sequence_no'] = $data['drivername'] = "";
        $data['trip_customers'] = array();
        $data['user_role_id'] = $this->session->userdata('user_role_id');
        $data['page_title'] = "Shipments";
        $data['sub_title'] = "New Shipment";
        if ($id != "") {
            $data['sub_title'] = "Edit Shipment";
        }
        $data["id"] = $id;
        $data["zones"] = $this->db->where("user_id", $user)->get("tb_shift_zones");
        $whr = array('status' => '1', 'user_id' => $user);
        $data["customers"] = $this->db->get_where('tb_customers', $whr)->result();
        $data["vendors"] = $this->db->get_where("tb_vendors", $whr);
        $data['materials'] = $this->db->get_where('tb_materials', array('status' => 'Active'))->result();
        $data['rateCategories'] = $this->db->get_where('tb_shipment_rate_categories', array('status' => '1'))->result();
        $data["type"] = "add";
        if ($id != null) {
            $data["type"] = "edit";
            $data["shift"] = $this->db->query(
                "SELECT * FROM `tb_shifts` WHERE `user_id` = '" . $user . "' AND status='1' AND id=" . $id
            );
            if ($data["shift"]->num_rows() == 0) {
                redirect("shift/newShift");
            }
            if ($company_code == "RUKN") {
                if ($data["shift"]->num_rows() > 0) {
                    $created_on = $data["shift"]->row()->created_on;
                    $data['trip_sequence_no'] = get_trip_sequence_no($id, $created_on);
                }
                $get_driver_info = $this->truckwaybillmodel->get_driver_info($id);
                if (!empty($get_driver_info)) {
                    $data['drivername'] = $get_driver_info['name'];
                }
            }
        }
        if ($id != null) {
            $gettrip_customers = $this->truckwaybillmodel->getcustomers_by_shiftid($id);
            if (!empty($gettrip_customers)) {
                foreach ($gettrip_customers as $trip_customers) {
                    $data['trip_customers'][] = array(
                        'id' => $trip_customers['customer_id'],
                        'name' => $trip_customers['name'],
                        'email' => $trip_customers['email_id']
                    );
                }
            }
        }
        //$this->newtemplate->dashboard("shift/add_new", $data);
        $this->load->view("shift/add_new", $data);
        /*$this->settemplate->dashboard("shift/add", $data);*/
    }
    public function add($id = null)
    {
        $user = $this->session->userdata('user_id');
        $data['page_title'] = "Shipments";
        $data['sub_title'] = "New Shipment";
        if ($id != "") {
            $data['sub_title'] = "Edit Shipment";
        }
        $data["id"] = $id;
        $data["zones"] = $this->db->where("user_id", $user)->get("tb_shift_zones");
        $whr = array('status' => '1', 'user_id' => $user);
        $data["customers"] = $this->db->get_where('tb_customers', $whr)->result();
        $post = array();
        $post = $this->input->post(null, true);
        if ($id == null) {
            $data["type"] = "add";
            if (!empty($post)) {
                //$post = $_POST;
                $post["stime"] = date("H.i", strtotime($post["stime"]));
                $post["etime"] = date("H.i", strtotime($post["etime"]));
                $post["startdate"] = $post["startdate"];
                $post["enddate"] = $post["enddate"];
                $post["empshift_start"] = $post["stime"];
                $post["empshift_end"] = $post["etime"];
                $post['startdate'] = $post["startdate"] . ' ' . date("H:i:s", strtotime($post["stime"]));
                $post['enddate'] = $post["enddate"] . ' ' . date("H:i:s", strtotime($post["etime"]));
                $zone = isset($post['zone_id']) ? $post['zone_id'] : "";
                if ($zone == "") {
                    $post['zone_id'] = 0;
                }
                $post["updated_on"] = date('Y-m-d H:i:s');
                unset($post['submit']);
                $post["user_id"] = $user;
                $post['shipmentid'] = $post['txnid'] = "";
                $shipmentid = $this->db->select('shipmentid,txnid')->order_by('id', 'DESC')->get_where(
                    'tb_shifts',
                    array(
                        'user_id' => $user,
                        'shipmentid <>' => ''
                    ),
                    1,
                    0
                );
                if ($shipmentid->num_rows() > 0) {
                    $chk = preg_split('/(?<=[a-z])(?=[0-9]+)/i', $shipmentid->row()->shipmentid);
                    $shipidchk = "";
                    if (count($chk) > 1) {
                        $shipidchk .= $chk[0];
                        $shipidchk .= ($chk[1] + 1);
                    } else {
                        $shipidchk = ($chk[0] + 1);
                    }
                    $post['shipmentid'] = $shipidchk;
                    $chk1 = preg_split('/(?<=[a-z])(?=[0-9]+)/i', $shipmentid->row()->txnid);
                    $shipidchk1 = "";
                    if (count($chk1) > 1) {
                        $shipidchk1 .= $chk1[0];
                        $shipidchk1 .= ($chk1[1] + 1);
                    } else {
                        $shipidchk1 = ($chk1[0] + 1);
                    }
                    $post['txnid'] = $shipidchk1;
                }
                $scity = explode(", ", $post['splace'])[0];
                if ($scity != "") {
                    $post['scity'] = $scity;
                }
                $dcity = explode(", ", $post['eplace'])[0];
                if ($dcity != "") {
                    $post['dcity'] = $dcity;
                }
                $post['company_code'] = $this->session->userdata('company_code');
                $post['branch_code'] = $this->session->userdata('branch_code');
                $res = $this->db->insert("tb_shifts", $post);
                $shipment_id = $this->db->insert_id();
                $this->createPrimaryStop($shipment_id, false);
                echo json_encode(array("status" => "1", "shipment_id" => $shipment_id));
            } else {
                echo json_encode(array("status" => "0"));
            }
        } else {
            $data["type"] = "edit";
            $data["shift"] = $this->db->query(
                "SELECT id FROM `tb_shifts` WHERE `user_id` = '" . $user . "' AND status='1' AND id=" . $id
            );
            if ($data["shift"]->num_rows() == 0) {
                //redirect("shift/newShift");
                echo json_encode(array("status" => "0"));
                exit;
            }
            if (!empty($post)) {
                //$post = $_POST;
                $post["stime"] = date("H.i", strtotime($post["stime"]));
                $post["etime"] = date("H.i", strtotime($post["etime"]));
                $post["startdate"] = $post["startdate"] . ' ' . date("H:i:s", strtotime($post["stime"]));
                $post["enddate"] = $post["enddate"] . ' ' . date("H:i:s", strtotime($post["etime"]));
                $post["empshift_start"] = $post["stime"];
                $post["empshift_end"] = $post["etime"];
                $post["updated_on"] = date('Y-m-d H:i:s');
                $zone = isset($post['zone_id']) ? $post['zone_id'] : "";
                if ($zone == "") {
                    $post['zone_id'] = 0;
                }
                unset($post['submit']);
                unset($post['hour']);
                unset($post['minute']);
                unset($post['meridian']);
                unset($post['trip_type']);
                unset($post['submitform']);
                $upd = $this->db->where("id", $id)->update("tb_shifts", $post);
                /*$this->sendnotify('trip_edit',$id);*/
                echo json_encode(array("status" => "1", "shipment_id" => $id));
            } else {
                echo json_encode(array("status" => "0"));
            }
        }
    }

    public function delete($id = null)
    {
        if ($id == null) {
            redirect("visibility/shipment");
        } else {
            if ($this->db->where(array("shift_id" => $id, "status" => '1'))->get("tb_trips")->num_rows() > 0) {
                $this->session->set_flashdata('error', "You can't delete a Shipment while its Trip is RUNNING");
            } else {
                $this->db->where("id", $id)->update("tb_shifts", array("status" => '0'));
                $this->db->where("shft_id", $id)->update("tb_shft_veh", array("status" => '0'));
            }
            //redirect("visibility/shipment");
            redirect("shipmentplan");
        }
    }

    public function parse()
    {
        $all_data = array();
        $data = array();
        if (isset($_FILES)) {
            //load the excel library
            $ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
            if ($ext == "xls" || $ext == "xlsx") {
                $all_data["data"] = array();
                $dt = array();
                if (move_uploaded_file($_FILES['file']['tmp_name'], "./assets/shifts/" . $_FILES['file']['name'])) {
                    require_once APPPATH . "/libraries/Excel.php";
                    $filepath = base_url() . "assets/shifts/" . $_FILES['file']['name'];
                    //read file from path
                    try {
                        $fileType = PHPExcel_IOFactory::identify($filepath);
                        $objReader = PHPExcel_IOFactory::createReader($filepath);
                        $objPHPExcel = $objReader->load($tempfile);
                        $all_data = array();
                        foreach ($objPHPExcel->getAllSheets() as $sheet) {
                            //echo $sheet->getTitle()."<br>";
                            $cell_collection = $sheet->getCellCollection();
                            //print_r($cell_collection);
                            foreach ($cell_collection as $cell) {
                                $c = $sheet->getCell($cell);
                                $column = $c->getColumn();
                                $row = $c->getRow();
                                $data_value = $c->getValue();
                                if (strstr($data_value, '=') == true) {
                                    $data_value = $c->getOldCalculatedValue();
                                }
                                if ($row == 3) {
                                    if (count($data_value) > 0) {
                                        $a = explode("Shift: ", $data_value);
                                        $data["timing"] = array_map('trim', explode("-", $a[1]));
                                    }
                                } else {
                                    if ($row == 4) {
                                        if ($column != 'A' && $column != 'B' && $column != 'C') {
                                            if (PHPExcel_Shared_Date::isDateTime($c)) {
                                                $data_value = PHPExcel_Shared_Date::ExcelToPHPObject(
                                                    $c->getValue()
                                                )->format('Y-m-d');
                                            }
                                            if (count($data_value) > 0) {
                                                $data["header"][$row][$column] = $data_value;
                                            }
                                        }
                                    } else {
                                        if ($row > 4) {
                                            if ($column == 'B') {
                                                if (count($data_value) > 0) {
                                                    $data_value = array_map('trim', explode("/", $data_value));
                                                }
                                            }
                                            if ($column == 'C') {
                                                if (PHPExcel_Shared_Date::isDateTime($c)) {
                                                    $data_value = PHPExcel_Shared_Date::ExcelToPHPObject(
                                                        $c->getValue()
                                                    )->format('h:i A');
                                                }
                                            }
                                            if (count($data_value) > 0) {
                                                $data["arr_data"][$row][$column] = $data_value;
                                            }
                                        }
                                    }
                                }
                            }
                            array_push($dt, $data);
                            $data = array();
                        }
                        $all_data["status"] = "";
                        $all_data["data"] = $dt;
                    } catch (Exception $ex) {
                        $all_data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
	<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
	Warning! Uploaded File is not valid, Please choose appropiate File.
</div>
</div>
</div>
EOT;
                    }
                }
            } else {
                $all_data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
	<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
	Warning! Uploaded File is not valid, Please choose appropiate File.
</div>
</div>
</div>
EOT;
            }
        } else {
            $all_data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
	<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
	Warning! Please Select File before Submitting.
</div>
</div>
</div>
EOT;
        }
        echo $this->load->view("excel_parse", $all_data, true);
    }

    public function uploadpopup()
    {
        return $this->load->view("upload_popup", true);
    }

    public function savedata()
    {
        $post = array();
        $post = $this->input->post(null, true);
        if (!empty($post)) {
            $data = $post;
            print_r($data);
            exit;
            foreach ($data as $d) {
                $em = getEmployee($d['C']);
                $emp = $em->id;
                $veh = getVehicle($d['B']);
                $svid = $this->getshftvehid($d['A'], $veh);
            }
            $s = array();
            foreach ($data as $d) {
                array_push($s, $d["A"]);
            }
            $shifts = array_unique($s);
            sort($shifts);
            $v = array();
            foreach ($shifts as $s) {
                foreach ($data as $d) {
                    if ($s == $d["A"]) {
                        array_push($v, $d["A"] . "," . $d["B"]);
                    }
                }
            }
            $vehs = array_unique($v);
            sort($vehs);
            $e = array();
            foreach ($vehs as $v) {
                $va = explode(",", $v);
                $sql1 = $this->db->where(
                    array("shft_id" => $va[0], "register_number" => $va[1], "status" => "1")
                )->order_by("id", "desc")->get("tb_shft_veh");
                if ($sql1->num_rows() > 0) {
                    $v = $sql1->row()->id;
                } else {
                    $arr = array(
                        "user_id" => $this->session->userdata("user_id"),
                        "shft_id" => $va[0],
                        "register_number" => $va[1],
                        "created_on" => date("Y-m-d H:i:s"),
                        "status" => "1"
                    );
                    $this->db->insert("tb_shft_veh", $arr);
                    $v = $this->db->insert_id();
                }
                foreach ($data as $d) {
                    if ($va[0] == $d["A"] && $va[1] == $d["B"]) {
                        array_push($e, $v . "," . $d["C"] . ",", $d["D"] . ",", $d["A"]);
                    }
                }
            }
            $emps = array_unique($e);
            sort($emps);
            foreach ($emps as $v) {
                $va = explode(",", $v);
                print_r($va);
                exit;
                $em = getEmployee($va[1]);
                $va[1] = $em->id;
                $date = date("Y-m-d H:i:s");
                $sql1 = $this->db->query(
                    "select e.id from tb_shft_veh_emp e,tb_shft_veh v where e.shft_veh_id=v.id and v.shft_id=" . $va[3] . " and e.emp_id=" . $va[1] . " and v.status='1' and e.status='1'"
                );
                if ($sql1->num_rows() > 0) {
                    $this->db->query(
                        "update tb_shft_veh_emp e,tb_shft_veh v set e.status='0',e.updated_on='" . $date . "' where e.shft_veh_id=v.id and v.shft_id=" . $va[3] . " and e.emp_id=" . $va[1] . " and v.status='1' and e.status='1'"
                    );
                }
                $arr1 = array(
                    "user_id" => $this->session->userdata("user_id"),
                    "shft_veh_id" => $va[0],
                    "emp_id" => $va[1],
                    "created_on" => date("Y-m-d H:i:s"),
                    "status" => "1",
                    "priority" => $va[2]
                );
                $this->db->insert("tb_shft_veh_emp", $arr1);
            }
            echo "1";
        }
    }

    public function downloadreport()
    {
        $shifts = 'SELECT s.id as Shift_ID,splace as Shift_Start_Place,stime as Start_Time,eplace as Shift_End_Place,etime as End_Time,v.register_number as Vehicle,em.name as Employee_Name,em.pickup as Pickup_Location,em.drop as Dropping_Location FROM tb_employee em,tb_shifts s,tb_shft_veh v,tb_shft_veh_emp e where s.user_id=' . $this->session->userdata(
            "user_id"
        ) . ' AND s.id=v.shft_id AND v.id=e.shft_veh_id AND s.status="1" AND v.status="1" AND e.status="1" AND e.emp_id=em.id';
        $sql = $this->db->query($shifts);
        $this->load->dbutil();
        $this->load->helper('file');
        $this->load->helper('download');
        $delimiter = ",";
        $newline = "\r\n";
        $file = 'Shifts' . date("Ymdhis") . '.csv';
        $data = $this->dbutil->csv_from_result($sql, $delimiter, $newline);
        force_download($file, $data);
        header('Content-Type: application/csv');
    }

    public function dashboard()
    {
        $data = array();
        /*$cdate = date('Y-m-d');*/
        $curtz1 = $this->session->userdata('usr_tzone');
        $curtz = $curtz1['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $cdate = $getactual['date'];
        $pdate = $ddate = array();
        $btype = $this->session->userdata("business_type");
        $company_code = $this->session->userdata('company_code');
        $whr = $whr2 = $whr3 = $whr4 = "";
        $userid = 0;
        /*if ($btype == "Carrier") {
            redirect("carrier/dashboard");
        }*/
        if ($btype == "Country Admin") {
            $userids = $this->session->userdata('country_user_ids');
            if (count($userids) > 0) {
                $whr .= " AND e.user_id IN(" . implode(",", $userids) . ") ";
                $whr2 .= " user_id IN(" . implode(",", $userids) . ") ";
                $whr3 .= " AND o.company_code like '%" . $company_code . "%' ";
            } else {
                $whr .= " AND e.user_id IN(-1) ";
                $whr2 .= " user_id IN(-1) ";
                $whr3 .= " AND o.user_id IN(-1) ";
            }
            $data['branches'] = $this->db->get_where('tb_branch_master', ['company_code' => $company_code])->result();
        } else {
            if ($btype == "Truck_Owner") {
                $userid = $this->session->userdata("user_id");
                $whr .= " AND e.user_id=$userid ";
                $whr2 .= " user_id=$userid ";
                $whr3 .= " AND o.user_id IN ($userid) ";
                $data['branches'] = $this->db->get_where('tb_branch_master', ['company_code' => $company_code])->result();
            } else {
                if ($btype == "Customer") {
                    $userid = $this->session->userdata("user_id");
                    $cid = $this->session->userdata("cust_id");
                    $whr .= " AND e.customer_id=$cid ";
                    $whr2 .= " user_id=$userid ";
                    $whr3 .= " AND o.company_code like '%" . $company_code . "%' ";
                } else {
                    if ($btype == "Carrier") {
                        $userid = $this->session->userdata("id");
                        $whr .= " AND e.vendor_id=$userid ";
                        $whr2 .= " user_id=$userid ";
                        $whr3 .= " AND o.vendor_id = $userid ";
                    }
                }
            }
        }

        if ($this->session->userdata("company_code") == 'NZKN') {
            $whr4 .= ' AND (o.order_status != "READY" OR o.order_status IS NULL) ';
        }

        $mainqry = "SELECT o.id FROM tb_orders o WHERE  (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.status!=0 AND o.trip_sts=0 $whr3 GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $actbk = $this->db->query($mainqry);
        $data['activebooks'] = $actbk->num_rows();
        /*pending bookings*/
        $mainqry = "SELECT o.id FROM tb_orders o WHERE  o.status!=0 AND o.trip_id=0  $whr3 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $pendbk = $this->db->query($mainqry);
        $data['pendbooks'] = $pendbk->num_rows();

        /*completed bookings*/
        $mainqry = "SELECT o.id FROM tb_orders o WHERE o.trip_sts=1 and o.trip_id !=0 $whr3 ORDER BY o.updatedon";
        $donebk = $this->db->query($mainqry);
        $data['donebooks'] = $donebk->num_rows();
        /*alerts*/
        $mainqry = "SELECT count(id) as cnts FROM tb_trip_alerts WHERE $whr2 AND DATE(created_on)='" . $cdate . "'";
        $alertbk = $this->db->query($mainqry);
        $data['alertbooks'] = 0;
        if ($alertbk->num_rows() > 0) {
            $data['alertbooks'] = $alertbk->row()->cnts;
        }
        /*$mainqry2 = $this->db->query("SELECT COUNT(a.id) AS ordcount, DATE_FORMAT(merge_date,'%Y-%m-%d') AS ordtime FROM ( SELECT DATE(now()) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 1 DAY) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 2 DAY) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 3 DAY) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 4 DAY) AS merge_date  UNION SELECT DATE_ADD(NOW(), INTERVAL 5 DAY) AS merge_date  UNION SELECT DATE_ADD(NOW(), INTERVAL 6 DAY) AS merge_date ) AS m LEFT JOIN tb_orders a ON DATE(m.merge_date) = DATE(a.pickup_datetime) AND a.id IN(SELECT o.id FROM tb_trips t,tb_employee e,tb_orders o WHERE t.shift_id=e.shift_id AND e.order_id=o.order_id AND t.status=1 AND DATE(o.pickup_datetime)>='".$cdate."' $whr) AND DATE(a.pickup_datetime)>='".$cdate."' GROUP BY m.merge_date ORDER BY 1+1 LIMIT 7");*/
        $mainqry2 = $this->db->query(
            "SELECT COUNT(e.id) AS ordcount, DATE_FORMAT(merge_date,'%Y-%m-%d') AS ordtime FROM ( SELECT DATE(now()) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 1 DAY) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 2 DAY) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 3 DAY) AS merge_date UNION SELECT DATE_ADD(NOW(), INTERVAL 4 DAY) AS merge_date  UNION SELECT DATE_ADD(NOW(), INTERVAL 5 DAY) AS merge_date  UNION SELECT DATE_ADD(NOW(), INTERVAL 6 DAY) AS merge_date ) AS m LEFT JOIN tb_orders e ON DATE(m.merge_date) = DATE(e.pickup_datetime) $whr AND e.trip_id!=0 AND DATE(e.pickup_datetime)>='" . $cdate . "' AND e.trip_sts=0 GROUP BY m.merge_date ORDER BY 1+1 LIMIT 7"
        );
        $data['forcat'] = array();
        if ($mainqry2->num_rows() > 0) {
            foreach ($mainqry2->result() as $rs) {
                $ordt = $rs->ordtime;
                $getactual = getdatetimebytimezone($curtz, $rs->ordtime, DFLT_TZ);
                $ordtime = $getactual['date'];
                $mainqry1 = $this->db->query(
                    "SELECT e.trip_id FROM tb_orders e WHERE e.trip_id!=0 AND e.trip_sts=0 AND DATE(e.delivery_datetime)='" . $ordt . "' $whr"
                );
                if ($mainqry1->num_rows() > 0) {
                    $data['forcat'][] = array(
                        "pickup" => $rs->ordcount,
                        "tdate" => $ordtime,
                        "deliver" => $mainqry1->num_rows()
                    );
                } else {
                    $data['forcat'][] = array("pickup" => '0', "tdate" => $ordtime, "deliver" => $mainqry1->num_rows());
                }
            }
        }
        /*customers for chat*/
        $country = $curtz1['country'];/*substr($this->session->userdata("company_code"), 0,2);*/
        $data['chatusers'] = array();
        $cusers = $this->db->query(
            "(SELECT id,name,phone,'Customer' as utype FROM tb_customers WHERE status=1 and user_id=$userid ORDER BY online DESC LIMIT 20) UNION (SELECT id,name,mobile as phone,'Carrier' as utype FROM tb_vendors WHERE status=1 and user_id=$userid ORDER BY online DESC LIMIT 10)"
        );
        if ($cusers->num_rows() > 0) {
            $data['chatusers'] = $cusers->result_array();
        }
        if ($this->session->userdata('company_code') === "CNKN") {
            $this->settemplate->dashboard("shift/dashboard_china", $data);
        } elseif ($this->session->userdata('company_code') == "TWKN") {
            $this->settemplate->dashboard("shift/dashboard_taiwan", $data);
        } elseif ($this->session->userdata('map_type') == 0) {
            $this->settemplate->dashboard("shift/dashboard", $data);
        } else {
            if ($this->session->userdata('map_type') == 1) {
                $this->settemplate->dashboard("shift/dashboard_eu", $data);
            } else {
                $this->settemplate->dashboard("shift/dashboard", $data);
            }
        }
    }

    public function ajaxdashboard()
    {
        $user = $this->session->userdata("user_id");
        $data1["data"][] = array();
        echo print_r($data1);
    }

    public function mapview($veh = null)
    {
        if ($veh != null) {
            $d["loc"] = $this->db->query(
                "select latitude as lat,longitude as lng,receivedon as time from tb_trucks_data where id='$veh' limit 1"
            )->result_array();
            $this->settemplate->dashboardtemp("mapview", $d);
        }
    }

    public function updfile()
    {
        $this->load->view("shift_upload");
    }

    public function saveupload()
    {
        $this->load->helper(array('form', 'url'));
        $all_data = array();
        $data = array();
        $config = array(
            'upload_path' => './assets/shifts/',
            'allowed_types' => 'xls|xlsx',
            'overwrite' => 1,
        );
        $image1 = $this->input->post('file', true);
        $this->load->library('upload');
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file')) {
            $all_data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
	<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
	Warning! Please Select File before Submitting.
</div>
</div>
</div>
EOT;
        } else {
            $upload_data = $this->upload->data();
            $file_name = $upload_data['file_name'];
            $file_path = $upload_data['full_path'];
            $all_data["data"] = array();
            $dt = array();
            $this->load->library('excel');
            //read file from path
            try {
                $fileType = PHPExcel_IOFactory::identify($file_path);
                $objReader = PHPExcel_IOFactory::createReader($fileType);
                $objPHPExcel = $objReader->load($file_path);
                $all_data = array();
                foreach ($objPHPExcel->getAllSheets() as $sheet) {
                    $cell_collection = $sheet->getCellCollection();
                    foreach ($cell_collection as $cell) {
                        $c = $sheet->getCell($cell);
                        $column = $c->getColumn();
                        $row = $c->getRow();
                        $data_value = $c->getValue();
                        if (strstr($data_value, '=') == true) {
                            $data_value = $c->getOldCalculatedValue();
                        }
                        if ($row == 3) {
                            if (count($data_value) > 0) {
                                $a = explode("Shift: ", $data_value);
                                $data["timing"] = array_map('trim', explode("-", $a[1]));
                            }
                        } else {
                            if ($row == 4) {
                                if ($column != 'A' && $column != 'B' && $column != 'C') {
                                    if (PHPExcel_Shared_Date::isDateTime($c)) {
                                        $data_value = PHPExcel_Shared_Date::ExcelToPHPObject($c->getValue())->format(
                                            'Y-m-d'
                                        );
                                    }
                                    if (count($data_value) > 0) {
                                        $data["header"][$row][$column] = $data_value;
                                    }
                                }
                            } else {
                                if ($row > 4) {
                                    if ($column == 'B') {
                                        if (count($data_value) > 0) {
                                            $data_value = array_map('trim', explode("/", $data_value));
                                        }
                                    }
                                    if ($column == 'C') {
                                        if (PHPExcel_Shared_Date::isDateTime($c)) {
                                            $data_value = PHPExcel_Shared_Date::ExcelToPHPObject(
                                                $c->getValue()
                                            )->format('h:i A');
                                        }
                                    }
                                    if (count($data_value) > 0) {
                                        $data["arr_data"][$row][$column] = $data_value;
                                    }
                                }
                            }
                        }
                    }
                    //print_r($data);exit;
                    array_push($dt, $data);
                    $data = array();
                }
                $all_data["status"] = "";
                $all_data["data"] = $dt;
            } catch (Exception $ex) {
                $all_data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
	<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
	Warning! Uploaded File is not valid, Please choose appropiate File.
</div>
</div>
</div>
EOT;
            }
        }
        echo $this->load->view("excel_parse", $all_data, true);
    }


    public function newupdfile()
    {
        $this->load->view("newshift_upload");
    }

    public function newsaveupload()
    {
        $this->load->helper(array('form', 'url'));
        $all_data = array();
        $all_data["status"] = "";
        $all_data["data"] = array();
        $data = array();
        $config = array(
            'upload_path' => './assets/shifts/',
            'allowed_types' => 'xls|xlsx',
            'overwrite' => 1,
        );
        $image1 = $this->input->post('file', true);
        $this->load->library('upload');
        $this->upload->initialize($config);
        if (!$this->upload->do_upload('file')) {
            $all_data["status"] = $all_data["status"] . '<div class="row"><div class="col-md-12"><div class="alert alert-danger">	<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>  	Warning! Please Select File before Submitting.</div></div></div>';
        } else {
            $upload_data = $this->upload->data();
            $file_name = $upload_data['file_name'];
            $file_path = $upload_data['full_path'];
            $data["arr_data"] = array();
            $dt = array();
            $this->load->library('excel');
            try {
                $fileType = PHPExcel_IOFactory::identify($file_path);
                $objReader = PHPExcel_IOFactory::createReader($fileType);
                $objPHPExcel = $objReader->load($file_path);
                foreach ($objPHPExcel->getAllSheets() as $sheet) {
                    $cell_collection = $sheet->getCellCollection();
                    foreach ($cell_collection as $cell) {
                        $c = $sheet->getCell($cell);
                        $column = $c->getColumn();
                        $row = $c->getRow();
                        $data_value = $c->getValue();
                        if (strstr($data_value, '=') == true) {
                            $data_value = $c->getOldCalculatedValue();
                        }
                        if ($row == 1) {
                            if ($column == 'A') {
                                $data["endplace"] = $data_value;
                            }
                        }
                        if ($row == 3) {
                            if ($column != 'A' && $column != 'B' && $column != 'C' && $column != 'D' && $column != 'E' && $column != 'F' && $column != 'G' && $column != 'H' && $column != 'I' && $column != 'J') {
                                if (PHPExcel_Shared_Date::isDateTime($c)) {
                                    $data_value = PHPExcel_Shared_Date::ExcelToPHPObject($c->getValue())->format(
                                        'Y-m-d'
                                    );
                                }
                                if (count($data_value) > 0) {
                                    $data["header"][$row][$column] = $data_value;
                                }
                            }
                        } else {
                            if ($row > 3) {
                                if ($column == 'A') {
                                    if (isset($data["arr_data"])) {
                                        if (count($data["arr_data"]) > 0) {
                                            foreach ($data["arr_data"] as $d) {
                                                if (isset($d['A'])) {
                                                    if ($d["A"] == $data_value) {
                                                        $all_data["status"] = $all_data["status"] . '<div class="row"><div class="col-md-12"><div class="alert alert-danger">	<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>  	Warning! Uploaded File contains repeated shipment with id ' . $data_value . ', In row ' . $row . '.</div></div></div>';
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if ($column == 'E') {
                                    $data_value = isset($data_value) ? $data_value : "0";
                                }
                                if ($column == 'F') {
                                    if (PHPExcel_Shared_Date::isDateTime($c)) {
                                        $data_value = PHPExcel_Shared_Date::ExcelToPHPObject($c->getValue())->format(
                                            'h:i A'
                                        );
                                    }
                                }
                                if ($column == 'G') {
                                    if (preg_match(
                                        '/^(?:0[1-9]|1[0-2]|[1-9]):[0-5][0-9] (am|pm|AM|PM)( |)-( |)(?:0[1-9]|1[0-2]|[1-9]):[0-5][0-9] (am|pm|AM|PM)$/',
                                        $data_value
                                    ) == "1") {
                                        $data_value = $c->getValue();
                                    } else {
                                        $all_data["status"] = $all_data["status"] . '<div class="row"><div class="col-md-12"><div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Warning! Uploaded File contains Not Well formated Shift time as ' . $data_value . ', In row ' . $row . '.</div></div></div>';
                                    }
                                }
                                if (count($data_value) > 0) {
                                    $data["arr_data"][$row][$column] = $data_value;
                                }
                            }
                        }
                    }
                    array_push($dt, $data);
                    $data = array();
                }
                $all_data["data"] = $dt;
            } catch (Exception $ex) {
                $all_data["status"] = $all_data["status"] . '<div class="row"><div class="col-md-12"><div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>Warning! Uploaded File is not valid, Please choose appropiate File.</div></div></div>';
            }
        }
        echo $this->load->view("newexcel_parse", $all_data, true);
        /*$this->load->view("newexcel_parse", $all_data);*/
    }

    public function lrv($id)
    {
        if (isset($id)) {
            $row = array();
            if ($id != "") {
                $row = gettripstopdetails(["id" => $id]);
            }
            /*if($id == 91){
				log_message('error', "lrv_".json_encode($row));
			}*/
            $row["shipment_id"] = $id;
            $this->load->view('loadroutevehs.php', $row);
        }
    }

    public function loadstops($id)
    {
        $user = $this->session->userdata('user_id');
        $carrier_id = $this->session->userdata('id');
        $whr = array('user_id' => $user, 'status' => 1, 'shift_id' => $id, "vendor_id" => $carrier_id);
        $stops = $this->db->query(
            "SELECT * from tb_shiporder_stops WHERE shipment_id = '$id' AND status=1 ORDER BY ordernumber ASC"
        );
        $rowres = array();
        foreach ($stops->result() as $stop) {
            $rowres[] = array(
                "id" => $stop->id,
                "address" => $stop->stopname,
                "lat" => $stop->plat,
                "lng" => $stop->plng,
                "datetime" => $stop->startdate,
                "weight" => $stop->weight,
                "volume" => $stop->volume,
                "ship_type" => $stop->stoptype
            );
        }
        // $emps = $this->db->query('SELECT e.*,sv.vehicle_id,sv.register_number,sve.id as sve_id,sv.carrier_id as vendor_id from tb_shft_veh sv JOIN tb_shft_veh_emp sve on sve.shft_veh_id=sv.id AND sve.status="1" JOIN tb_employee e ON e.id=sve.emp_id WHERE sv.shft_id='.$id.' AND sv.user_id='.$user.' AND sv.status="1" ORDER BY sve.priority asc');
        // $res = array();

        // foreach($emps->result() as $key) {
        //     $rowres['id'] = $key->id;
        //     $rowres['name'] = $key->name;
        //     $rowres['assoc_id'] = $key->assoc_id;
        //     $rowres['pickup_datetime'] = $key->pickup_datetime;
        //     $rowres['pickup'] = $key->pickup;
        //     $rowres['plat'] = $key->plat;
        //     $rowres['plng'] = $key->plng;
        //     $rowres['dlat'] = $key->dlat;
        //     $rowres['dlng'] = $key->dlng;
        //     $rowres['drop'] = $key->drop;
        //     $rowres['drop_datetime'] = $key->drop_datetime;
        //     $rowres['type'] = $key->ship_type;
        //     $rowres['order'] = $key->stop_order;
        //     $rowres['ship_type'] = $key->ship_type;
        //     $rowres['shipment_weight'] = $key->shipment_weight;
        //     $rowres['shipment_volume'] = $key->shipment_volume;
        //     $rowres['startdate'] = $key->startdate;
        //     $rowres['vehicle_id'] = $key->vehicle_id;
        //     $rowres['register_number'] = $key->register_number;
        //     $rowres['sve_id'] = $key->sve_id;
        //     $rowres['vendor_id'] = $key->vendor_id;
        //     $rowres['vendor'] = @$this->db->where(array("id"=>$key->vendor_id))->get("tb_vendors")->row()->name;
        //     $rowres['chklive'] = $this->checkstopstatus($key->id,$id,1);
        //     array_push($res, $rowres);
        // }
        return $rowres;
    }

    public function checkstopstatus($stopid, $shipid, $sts)
    {
        $result = array();
        $this->db->select('e.id,e.trip_id,e.status,e.check_in,e.pd_status,e.absent_reason');
        $this->db->from('tb_trip_employee e');
        $this->db->join('tb_trips t', 'e.trip_id=t.id', 'INNER');
        $this->db->where('e.employee_id', $stopid);
        $this->db->where('t.shift_id', $shipid);
        $this->db->where('t.status', $sts);
        $this->db->order_by('t.id', 'DESC');
        $this->db->limit(1);
        $res = $this->db->get();
        if ($res->num_rows() > 0) {
            $result = array(
                'status' => $res->row()->status,
                'check_in' => $res->row()->check_in,
                'pd_status' => $res->row()->pd_status,
                'absent_reason' => $res->row()->absent_reason,
                'trip_id' => $res->row()->trip_id
            );
        }
        return $result;
    }

    public function loadRouteVehs()
    {
        $post = array();
        $post = $this->input->post(null, true);
        $data['id'] = isset($post['id']) ? $post['id'] : "";
        $this->lrv($data['id']);
    }

    public function asnveh()
    {
        $post = array();
        $post = $this->input->post(null, true);
        $shft_id = $post["shft"];
        $veh = $post["veh"];
        $route_id = $post["route_id"];
        $userid = $this->session->userdata('user_id');
        if ($veh != "-1") {
            $q = $this->db->select('register_number')->where("id", $veh)->where("user_id", $userid)->get(
                "tb_trucks_data"
            );
            if ($q->num_rows() > 0) {
                $reg = $q->row()->register_number;
                $old_q = $this->db->select('id,vehicle_id,register_number')->order_by("status", "DESC")->get_where(
                    "tb_shft_veh",
                    array("shft_id" => $shft_id, "route_id" => $route_id, "status" => "1", "user_id" => $userid)
                );
                if ($old_q->num_rows() > 0) {
                    $old_veh = $old_q->row()->vehicle_id;
                    $old_reg = $old_q->row()->register_number;
                    $old_id = $old_q->row()->id;
                    $cnt = $this->db->select('id')->where(
                        array("shift_id" => $shft_id, "vehicle_id" => $old_veh, "status" => '1')
                    )->get("tb_trips")->num_rows();
                    if ($cnt == 0) {
                        /*log_message('error','firstupdate');*/
                        /*$ccnt = $this->db->select('id')->where(array("shift_id"=>$shft_id,"vehicle_id"=>$veh,"status"=>'1'))->get("tb_trips")->num_rows();
						if($ccnt == 0){*/
                        $this->newmoveasnveh($shft_id, $veh, $route_id, $userid, $reg, $old_veh, $old_reg, $old_id);
                        /*}else{
							$this->session->set_flashdata('error',"You can't Change a Route while Trip is RUNNING");
						}*/
                    } else {
                        $this->session->set_flashdata('error', "You can't Change a Route while Trip is RUNNING");
                    }
                } else {
                    /*log_message('error','firstinsert');*/
                    $this->moveasnveh($shft_id, $veh, $route_id, $userid, $reg);
                }
            }
        }
        echo $this->lrv($shft_id);
    }

    public function newmoveasnveh($shft_id, $veh, $route_id, $userid, $reg, $old_veh, $old_reg, $old_id)
    {
        $curdt = date("Y-m-d H:i:s");
        $q = $this->db->select('id,status')->order_by("status", "DESC")->get_where(
            "tb_shft_veh",
            array(
                "shft_id" => $shft_id,
                "vehicle_id" => $veh,
                "user_id" => $userid
            )
        );
        if ($q->num_rows() > 0) {
            foreach ($q->result() as $re) {
                if ($re->id != $old_id) {
                    $removeemps = $this->db->where(array('shft_veh_id' => $re->id))->update(
                        'tb_shft_veh_emp',
                        array(
                            'status' => 0,
                            'updated_on' => $curdt
                        )
                    );
                }
            }
            $updold1 = $this->db->where(
                array("shft_id" => $shft_id, "vehicle_id" => $veh, "user_id" => $userid)
            )->update("tb_shft_veh", array("status" => "0", "updated_on" => $curdt));
            $updold = $this->db->where("id", $old_id)->update(
                "tb_shft_veh",
                array(
                    "status" => "1",
                    "vehicle_id" => $veh,
                    "register_number" => $reg,
                    "updated_on" => $curdt
                )
            );
            // get driver data to push notify and sms
            $re = $this->sendsmspushnotify($veh, 'update');
        } else {
            $this->moveasnveh($shft_id, $veh, $route_id, $userid, $reg);
        }
    }

    public function sendsmspushnotify($veh, $type)
    {
        $curdt = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $this->db->select('d.id,d.name,d.contact_num,s.vehicle_id');
        $this->db->from('tbl_assigned_drivers s');
        $this->db->join('tb_truck_drivers d', 's.driver_id=d.id', 'INNER');
        $this->db->where('s.vehicle_id', $veh);
        $this->db->order_by('d.id', 'DESC');
        $this->db->limit(1);
        $driver = $this->db->get();
        if ($driver->num_rows() > 0) {
            $did = $driver->row()->id;
            $name = $driver->row()->name;
            $contact_num = $driver->row()->contact_num;
            $veh = $driver->row()->vehicle_id;
            $r = $this->db->select('register_number')->get_where('tb_trucks_data', array('id' => $veh), 1, 0);
            $reg = $r->row()->register_number;
            $nw = date('d M,y H:i a', strtotime($curdt));
            if ($type == 'insert') {
                $message = "Dear $name,Your truck $reg ($contact_num) got assigned new shipment on $nw,check once.";
                $module = "Shipment Assign Auto Alert";
            } else {
                $message = "Dear $name,Your truck $reg ($contact_num) shipment data updated on $nw,check once.";
                $module = "Shipment Update Auto Alert";
            }
            $smsdata = array(
                "mobile" => $contact_num,
                "module" => $module,
                "user_id" => $user_id,
                "message" => $message,
                "emp_id" => $did,
                "trip_id" => 0,
                'callcenter' => 0,
                'sent_on' => $curdt,
                'latitude' => 0,
                'longitude' => 0,
                'register_number' => $reg,
                'alert_reason' => 'shipment insert/update alert to driver',
                'response' => '',
                'status' => 0
            );
            $sendalrt = @$this->smsnotifier->driverarrivalsms($smsdata);
            $fire_set = @$this->sendfirebase->sendSinglePush(
                array("title" => $module, "message" => $message, "emp_id" => $did, 'type' => 'Driver')
            );
        }
    }

    public function moveasnveh($shft_id, $veh, $route_id, $userid, $reg)
    {
        $curdt = date("Y-m-d H:i:s");
        $q = $this->db->select('id')->get_where(
            "tb_shft_veh",
            array("shft_id" => $shft_id, "status" => "1", "vehicle_id" => $veh)
        );
        if ($q->num_rows() == 0) {
            $this->db->query(
                "update tb_shft_veh set status=0 where shft_id=$shft_id and route_id=$route_id and user_id=$userid"
            );
            $cnt = $this->db->select('id')->get_where(
                "tb_shft_veh",
                array(
                    "shft_id" => $shft_id,
                    "route_id" => $route_id,
                    "vehicle_id" => $veh,
                    "user_id" => $userid
                )
            );
            if ($cnt->num_rows() > 0) {
                $shft_veh_id = $cnt->row()->id;
                $upvemp = $this->db->where(
                    array("shft_id" => $shft_id, "route_id" => $route_id, "vehicle_id" => $veh, "user_id" => $userid)
                )->update("tb_shft_veh", array("status" => '1', "updated_on" => $curdt));
                // assign shipment stops
                $whr = array('user_id' => $userid, 'status' => 1, 'shift_id' => $shft_id);
                $emps = $this->db->get_where('tb_employee', $whr);
                foreach ($emps->result() as $key) {
                    $whr = array('user_id' => $userid, 'shft_veh_id' => $shft_veh_id, 'emp_id' => $key->id);
                    $chk = $this->db->get_where('tb_shft_veh_emp', $whr);
                    if ($chk->num_rows() == 0) {
                        $empdata = array(
                            'user_id' => $userid,
                            'shft_veh_id' => $shft_veh_id,
                            'emp_id' => $key->id,
                            'priority' => $key->stop_order,
                            'pickup_time' => $key->startdate,
                            'created_on' => $curdt,
                            'updated_on' => $curdt,
                            'status' => 1,
                            'drop_time' => $key->enddate
                        );
                        $insemp = $this->db->insert('tb_shft_veh_emp', $empdata);
                    } else {
                        $updata = array(
                            'priority' => $key->stop_order,
                            'pickup_time' => $key->startdate,
                            'updated_on' => $curdt,
                            'status' => 1,
                            'drop_time' => $key->enddate
                        );
                        $insemp = $this->db->where($whr)->update('tb_shft_veh_emp', $updata);
                    }
                }
                // update the manual/auto shipments table
                $autowhr = array('shipment_id' => $shft_id, 'user_id' => $userid);
                $updmanual = $this->db->where($autowhr)->update('tb_automanual_ships', array('status' => 2));
                // get driver data to push notify and sms
                $re = $this->sendsmspushnotify($veh, 'update');
            } else {
                $insdata = $this->db->insert(
                    "tb_shft_veh",
                    array(
                        "shft_id" => $shft_id,
                        "route_id" => $route_id,
                        "register_number" => $reg,
                        "vehicle_id" => $veh,
                        "status" => '1',
                        "updated_on" => $curdt,
                        "user_id" => $userid
                    )
                );
                $shft_veh_id = $this->db->insert_id();
                // assign shipment stops
                $whr = array('user_id' => $userid, 'status' => 1, 'shift_id' => $shft_id);
                $emps = $this->db->get_where('tb_employee', $whr);
                foreach ($emps->result() as $key) {
                    $whr = array('user_id' => $userid, 'shft_veh_id' => $shft_veh_id, 'emp_id' => $key->id);
                    $chk = $this->db->get_where('tb_shft_veh_emp', $whr);
                    if ($chk->num_rows() == 0) {
                        $empdata = array(
                            'user_id' => $userid,
                            'shft_veh_id' => $shft_veh_id,
                            'emp_id' => $key->id,
                            'priority' => $key->stop_order,
                            'pickup_time' => $key->startdate,
                            'created_on' => $curdt,
                            'updated_on' => $curdt,
                            'status' => 1,
                            'drop_time' => $key->enddate
                        );
                        $insemp = $this->db->insert('tb_shft_veh_emp', $empdata);
                    } else {
                        $updata = array(
                            'priority' => $key->stop_order,
                            'pickup_time' => $key->startdate,
                            'updated_on' => $curdt,
                            'status' => 1,
                            'drop_time' => $key->enddate
                        );
                        $insemp = $this->db->where($whr)->update('tb_shft_veh_emp', $updata);
                    }
                }
                // update the manual/auto shipments table
                $autowhr = array('shipment_id' => $shft_id, 'user_id' => $userid);
                $updmanual = $this->db->where($autowhr)->update('tb_automanual_ships', array('status' => 2));
                // get driver data to push notify and sms
                $re = $this->sendsmspushnotify($veh, 'insert');
            }
        } else {
            $this->session->set_flashdata(
                'error',
                "You can't Assign Vehicle $reg to this Shift,it is already assigned"
            );
        }
    }

    public function asn_shftroute2veh()
    {
        $post = array();
        $post = $this->input->post(null, true);
        $userid = $this->session->userdata('user_id');
        $shftid = isset($post['shftid']) ? $post['shftid'] : '';
        $items = isset($post['shftrout']) ? $post['shftrout'] : '';
        $splace = isset($post['splace']) ? $post['splace'] : '';
        $slat = isset($post['slat']) ? $post['slat'] : '0';
        $slng = isset($post['slng']) ? $post['slng'] : '0';
        $ost = $post['ost' . $shftid];
        $oet = $post['oet' . $shftid];
        $shft = $post['shft' . $shftid];
        if ($slat != "0" && $slng != "0") {
            $a = array('slat' => $slat, 'slng' => $slng, 'updated_on' => date('Y-m-d H:i:s'));
            $wr = array("id" => $shft);
            $update = $this->db->set($a)->where($wr)->update("tb_shifts");
        }
        $data = array();
        if ($items != "") {
            $items = explode(',', $items);
        }
        if (count($items) > 0) {
            foreach ($items as $itm) {
                $route = $itm;
                $vehicle = $post['vehselect' . $route];
                if ($vehicle != "") {
                    $data = array(
                        'route_id' => $route,
                        'shift_id' => $shft,
                        'vehicle_number' => $vehicle,
                        'user_id' => $userid,
                        'status' => 1,
                        'createdon' => date('Y-m-d H:i:s')
                    );
                    $whr = array(
                        'route_id' => $route,
                        'shift_id' => $shft,
                        "status" => 1,
                        'vehicle_number' => $vehicle,
                        "user_id" => $userid
                    );
                    $chk = $this->db->select('id')->get_where("tb_shift_route_vehicles", $whr, 1, 0);
                    if ($chk->num_rows() > 0) {
                        $rid = $chk->row()->id;
                        $this->db->set($whr)->where(array("id" => $rid))->update("tb_shift_route_vehicles");
                        $this->add2shftvah($shft, $vehicle, $ost, $oet, $itm);
                    } else {
                        $this->db->insert("tb_shift_route_vehicles", $data);
                        $this->add2shftvah($shft, $vehicle, $ost, $oet, $itm);
                    }
                }
            }
        }
        echo '1';
    }

    public function add2shftvah($id, $imei, $ost, $oet, $route)
    {
        $user = $this->session->userdata('user_id');
        $sql = "select DISTINCT shft_id from tb_shft_veh where register_number='$imei' and user_id=$user and status=1 and shft_id=$id";
        $vehs = $this->db->query($sql);
        if ($vehs->num_rows() > 0) {
            foreach ($vehs->result() as $vs) {
                $time = array();
                $time1 = array($ost, $oet);
                $nsi = $vs->shft_id;
                $time = $this->get_shft_time($nsi);
                if ($this->matchtimings($time1, $time)) {
                    $data = array('status' => 0, "updated_on" => date("Y-m-d H:i:s"));
                    $this->db->where(array('register_number' => $imei, 'shft_id' => $nsi));
                    $this->db->update('tb_shft_veh', $data);
                }
            }
        }
        $this->addshftrow($imei, $id, $route);
    }

    public function get_shft_time($shft_id)
    {
        $user = $this->session->userdata('user_id');
        $sql = "select stime,etime from tb_shifts where user_id=" . $user . " and id=" . $shft_id;
        $shifts = $this->db->query($sql);
        $time[0] = $time[1] = 0;
        foreach ($shifts->result() as $sr) {
            $time[0] = $sr->stime;
            $time[1] = $sr->etime;
        }
        return $time;
    }

    public function matchtimings($time, $time1)
    {
        if ($this->time2Str($time[0]) == $this->time2Str($time1[0]) || $this->time2Str($time[1]) == $this->time2Str(
            $time1[1]
        )) {
            return true;
        } else {
            return false;
        }
    }

    public function time2Str($time)
    {
        $hr = $time[0] . $time[1];
        $mn = $time[3] . $time[4];
        return $hr * 60 + $mn;
    }

    public function addshftrow($imei, $shft_id, $routeid)
    {
        $user = $this->session->userdata('user_id');
        $this->load->model("empmodel");
        $sql = "select id from tb_shft_veh where shft_id=$shft_id and register_number='" . $imei . "'";
        $veh = $this->db->query($sql);
        if ($veh->num_rows() > 0) {
            $data = array('status' => 1, "updated_on" => date("Y-m-d H:i:s"));
            $this->db->where(
                array('user_id' => $user, 'shft_id' => $shft_id, 'register_number' => $imei, 'status' => 0)
            );
            $this->db->update('tb_shft_veh', $data);
            /*$shftvehid = $veh->row()->id;
			$getshifttime = $this->db->select('stime,etime')->get_where('tb_shifts',array('id'=>$shft_id),1,0)->row();
			$getwhr = array('user_id'=>$user,'shft_route'=>$routeid,'stime'=>$getshifttime->stime,'etime'=>$getshifttime->etime,'date'=>date('Y-m-d'),'status'=>1); //'2017-03-27'
			$getshft = $this->db->order_by('pickup','ASC')->get_where("tbl_shifts",$getwhr);
			if($getshft->num_rows() > 0){
				$i = 1;
				foreach($getshft->result() as $rw){
					$arr = array('user_id'=>$user,'shft_veh_id'=>$shftvehid,'emp_id'=>$rw->emp_id,'priority'=>$i,'pickup_time'=>$rw->pickup,
				'created_on'=>date('Y-m-d H:i:s'),'updated_on'=>date('Y-m-d H:i:s'),'status'=>1);
				$shftvehempid = $this->empmodel->insert('tb_shft_veh_emp', $arr);
				$i++;
				}
			}*/
        } else {
            $data = array(
                'user_id' => $user,
                'shft_id' => $shft_id,
                'register_number' => $imei,
                'status' => 1,
                "updated_on" => date("Y-m-d H:i:s")
            );
            $shftvehid = $this->empmodel->insert('tb_shft_veh', $data);
            if ($shftvehid) {
                $getshifttime = $this->db->select('stime,etime')->get_where(
                    'tb_shifts',
                    array('id' => $shft_id),
                    1,
                    0
                )->row();
                $getwhr = array(
                    'user_id' => $user,
                    'route_id' => $routeid,
                    'stime' => $getshifttime->stime,
                    'etime' => $getshifttime->etime,
                    'date' => date('Y-m-d'),
                    'status' => 1
                ); //'2017-03-27'
                $getshft = $this->db->order_by('pickup', 'ASC')->get_where("tb_shft_veh", $getwhr);
                if ($getshft->num_rows() > 0) {
                    $i = 1;
                    foreach ($getshft->result() as $rw) {
                        $arr = array(
                            'user_id' => $user,
                            'shft_veh_id' => $shftvehid,
                            'emp_id' => $rw->emp_id,
                            'priority' => $i,
                            'pickup_time' => $rw->pickup,
                            'created_on' => date('Y-m-d H:i:s'),
                            'updated_on' => date('Y-m-d H:i:s'),
                            'status' => 1
                        );
                        $shftvehempid = $this->empmodel->insert('tb_shft_veh_emp', $arr);
                        $i++;
                    }
                }
            }
        }
    }

    public function returntrip($shiftid)
    {
        $curdt = date('Y-m-d H:i:s');
        $shiftdetail = $this->db->get_where('tb_shifts', array('id' => $shiftid), 1, 0);
        if ($shiftdetail->num_rows() > 0) {
            $shft = $shiftdetail->row();
            /* insert in shift table */
            //$rtshiftfinalTime = date("H.i", strtotime('+120 minutes', strtotime($shft->empshift_end)));
            $rtshiftstartTime = date("H.i", strtotime('-15 minutes', strtotime($shft->empshift_end)));
            $timediff = round(abs(strtotime($shft->etime) - strtotime($shft->stime)) / 60, 2);
            $rtshiftendTime = date("H.i", strtotime('+' . $timediff . ' minutes', strtotime($rtshiftstartTime)));
            $rtdata = array(
                'user_id' => $shft->user_id,
                'splace' => $shft->eplace,
                'stime' => $rtshiftstartTime,
                'eplace' => $shft->splace,
                'etime' => $rtshiftendTime,
                'trip_type' => 1
            );
            $chkrt = $this->db->select('id')->get_where('tb_shifts', $rtdata, 1, 0);
            if ($chkrt->num_rows() == 0) {
                $company_code = $shft->company_code;
                $branch_code = $shft->branch_code;
                $rtdata = array(
                    'user_id' => $shft->user_id,
                    'splace' => $shft->eplace,
                    'stime' => $rtshiftstartTime,
                    'eplace' => $shft->splace,
                    'etime' => $rtshiftendTime,
                    'slat' => $shft->elat,
                    'slng' => $shft->elng,
                    'elat' => $shft->slat,
                    'elng' => $shft->slng,
                    'updated_on' => $curdt,
                    'status' => 1,
                    'empshift_start' => $shft->empshift_start,
                    'empshift_end' => $shft->empshift_end,
                    'trip_type' => 1,
                    'zone_id' => $shft->zone_id,
                    "company_code" => $company_code,
                    "branch_code" => $branch_code
                );
                $shiftid2 = $this->db->insert('tb_shifts', $rtdata);
                $shiftrtid = $this->db->insert_id();
            } else {
                $shiftrtid = $chkrt->row()->id;
                $whr1 = array('id' => $shiftrtid);
                $update1 = $this->db->set(array('status' => 1))->where($whr1)->update('tb_shifts');
            }
            /* insert in shift_veh table */
            $getshtveh = $this->db->order_by('id', 'DESC')->get_where(
                'tb_shft_veh',
                array('shft_id' => $shft->id),
                1,
                0
            );
            if ($getshtveh->num_rows() > 0) {
                $routchk1 = array(
                    'user_id' => $shft->user_id,
                    'shft_id' => $shiftrtid,
                    'route_id' => $getshtveh->row()->route_id
                );
                $chktbl1 = $this->db->select('id')->get_where('tb_shft_veh', $routchk1, 1, 0);
                if ($chktbl1->num_rows() == 0) {
                    $shftvehdata1 = array(
                        'user_id' => $shft->user_id,
                        'route_id' => $getshtveh->row()->route_id,
                        'shft_id' => $shiftrtid,
                        'vehicle_id' => $getshtveh->row()->vehicle_id,
                        'register_number' => $getshtveh->row()->register_number,
                        'updated_on' => $curdt,
                        'status' => 1
                    );
                    $shiftvehid11 = $this->db->insert('tb_shft_veh', $shftvehdata1);
                    $shiftrtvehid = $this->db->insert_id();
                } else {
                    $shiftrtvehid = $chktbl1->row()->id;
                    $whr1 = array('id' => $shiftrtvehid);
                    $upddata1 = array(
                        'user_id' => $shft->user_id,
                        'route_id' => $getshtveh->row()->route_id,
                        'shft_id' => $shiftrtid,
                        'vehicle_id' => $getshtveh->row()->vehicle_id,
                        'register_number' => $getshtveh->row()->register_number,
                        'updated_on' => $curdt,
                        'status' => 1
                    );
                    $update1 = $this->db->set($upddata1)->where($whr1)->update('tb_shft_veh');
                }
                /* insert in shift_veh_emp table */
                $empchk = array('user_id' => $shft->user_id, 'shft_veh_id' => $getshtveh->row()->id);
                $empchktbl = $this->db->get_where('tb_shft_veh_emp', $empchk);
                if ($empchktbl->num_rows() > 0) {
                    foreach ($empchktbl->result_array() as $rw) {
                        $routchk1 = array(
                            'user_id' => $shft->user_id,
                            'shft_veh_id' => $shiftrtvehid,
                            'emp_id' => $rw['emp_id']
                        );
                        $chktbl1 = $this->db->select('id')->get_where('tb_shft_veh_emp', $routchk1, 1, 0);
                        if ($chktbl1->num_rows() == 0) {
                            $shftvehdata1 = array(
                                'user_id' => $shft->user_id,
                                'shft_veh_id' => $shiftrtvehid,
                                'emp_id' => $rw['emp_id'],
                                'priority' => $rw['priority'],
                                'pickup_time' => $rw['pickup_time'],
                                'updated_on' => $curdt,
                                'status' => 1
                            );
                            $shiftvehempid1 = $this->db->insert('tb_shft_veh_emp', $shftvehdata1);
                            $shiftvehempid1 = $this->db->insert_id();
                        } else {
                            $shiftvehempid1 = $chktbl1->row()->id;
                            $whr1 = array('id' => $shiftvehempid1);
                            $upddata1 = array(
                                'user_id' => $shft->user_id,
                                'shft_veh_id' => $shiftrtvehid,
                                'emp_id' => $rw['emp_id'],
                                'pickup_time' => $rw['pickup_time'],
                                'updated_on' => $curdt,
                                'status' => 1,
                                'priority' => $rw['priority']
                            );
                            $update1 = $this->db->set($upddata1)->where($whr1)->update('tb_shft_veh_emp');
                        }
                    }
                }
            }
        }
        redirect('shift');
    }

    public function loadvehicleinfo()
    {
        $uid = $this->session->userdata("user_id");
        $users[] = $uid;
        if ($this->session->userdata("business_type") == "Country Admin") {
            $users = $this->session->userdata("country_user_ids");
        }
        if (count($users) == 0) {
            $users = [0];
        }
        $usrs = implode(",", $users);
        $data = array();
        $start = isset($_GET["start"]) ? $_GET["start"] : "";
        $length = isset($_GET["length"]) ? $_GET["length"] : "";
        $search = isset($_GET["search"]) ? $_GET["search"] : "";
        $order = isset($_GET["order"]) ? $_GET["order"] : "";
        $sql = "select d.id,d.name,t.id as vehicle_id,t.register_number from tb_truck_drivers d,tbl_assigned_drivers a,tb_trucks_data t where d.id=a.driver_id AND a.vehicle_id=t.id AND d.user_id IN ($usrs) AND d.status='Active' AND a.status=1 AND t.status='Active' ";
        $qr = $this->db->query($sql);
        $tot = $qr->num_rows();
        if ($_GET) {
            if ($search != "") {
                if (!is_array($search)) {
                    $sql .= " and (name like '%" . $search . "%' or register_number like '%" . $search . "%')";
                }
            }
            $o = isset($order["0"]["column"]) ? $order["0"]["column"] : "";
            $so = isset($order["0"]["dir"]) ? $order["0"]["dir"] : "";
            if ($o != "") {
                if ($o == "0") {
                    $sql .= " order by name $so";
                } else {
                    if ($o == "1") {
                        $sql .= " order by register_number $so";
                    }
                }
            }
            if ($start != "") {
                $sql .= " limit $start,$length";
            }
        }
        $qr1 = $this->db->query($sql);
        $cnt = $qr1->num_rows();
        if ($cnt > 0) {
            $data["recordsTotal"] = $tot;
            $data["recordsFiltered"] = $cnt;
            $data["columns"]["2"]["searchable"] = "false";
            $data["columns"]["3"]["searchable"] = "false";
            $data["columns"]["4"]["searchable"] = "false";
            $data["columns"]["2"]["orderable"] = "false";
            $data["columns"]["3"]["orderable"] = "false";
            $data["columns"]["4"]["orderable"] = "false";
            foreach ($qr1->result() as $row) {
                $d = array();
                $d[] = $row->name;
                $d[] = $row->register_number;
                $qry = $this->db->query(
                    "SELECT CONCAT(latitude,'@',longitude,'@',speed,'@',receivedon,'@',battery) as dtt FROM tb_trucks_data WHERE id='" . $row->vehicle_id . "' LIMIT 1"
                );
                $dt = array();
                if ($qry->num_rows() > 0) {
                    $dt = explode("@", $qry->row()->dtt);
                }
                if (count($dt) != 6) {
                    $dt = array("", "", "", "", "", "");
                }
                $d[] = getLocationName(
                    $dt[0],
                    $dt[1]
                ) . "<input type='hidden' id='position' value='" . $dt[0] . "," . $dt[1] . "'><input type='hidden' id='speed' value='" . $dt[2] . "'><input type='hidden' id='imei' value='" . $dt[5] . "'>";
                if (strlen($dt[2]) > 0) {
                    $d[] = uom_string($dt[2], 'kph');
                } else {
                    $d[] = "";
                }
                $d[] = (strlen(trim($dt[4])) > 0 ? $dt[4] . " %" : "");
                $d[] = getShipDetailByVeh($row->id);
                if (strlen($dt[3]) > 0) {
                    $d[] = date('d M,Y H:i a', strtotime($dt[3]));
                } else {
                    $d[] = "";
                }
                $data["data"][] = $d;
            }
        }
        echo json_encode($data);
    }

    public function loadMapVehicles()
    {
        $uid = $this->session->userdata("user_id");
        $tzone = $this->session->userdata("usr_tzone")['timezone'];
        $data = array();
        $users[] = $uid;
        if ($uid == 36) {
            $users[] = 7;
        }
        if ($uid == 37) {
            $users[] = 7;
        }
        if ($uid == 38) {
            $users[] = 7;
        }
        if ($this->session->userdata("business_type") == "Country Admin") {
            $users = $this->session->userdata("country_user_ids");
        }
        if (count($users) == 0) {
            $users = [0];
        }
        $usrs = implode(",", $users);
        $companyCode = $this->session->userdata('company_code');
        $checkAccessConditions = checkAccessConditions('RELATED_2_TW_CN', $companyCode);
        if ($checkAccessConditions) {
            $countryCode = $companyCode === "CNKN" ? "CN" : "TW";
            $userqr = $this->db->query(
                "SELECT GROUP_CONCAT(id SEPARATOR ', ') AS userids FROM tb_users WHERE country_code ='" . $countryCode . "' GROUP BY country_code"
            );
            $users = $userqr->result_array();
            $cnUsers = $users[0]['userids'];

            $sql = "SELECT id,register_number,truck_number FROM tb_trucks_data WHERE user_id IN (" . $cnUsers . ") AND status='Active'";
        } else {
            $sql = "SELECT id,register_number,truck_number FROM tb_trucks_data WHERE user_id IN (" . $usrs . ") AND status='Active'";
        }
        $qr = $this->db->query($sql);
        $data["data"] = array();
        if ($qr->num_rows() > 0) {
            foreach ($qr->result() as $row) {
                $veh = $row->id;
                $d = $d1 = array();
                $sql1 = "SELECT tr.id as trip_id,tr.vehicle_id,d.id,d.name FROM tb_trips tr,tb_truck_drivers d WHERE tr.driver_id=d.id AND tr.vehicle_id=$veh AND tr.status=1 GROUP BY tr.id LIMIT 1";
                $qr1 = $this->db->query($sql1);
                $currentdate = date("Y-m-d");
                if ($qr1->num_rows() > 0) {
                    $tripdata = $qr1->row();
                    $d[] = $d1[] = $tripdata->name;
                    $d[] = $row->register_number;

                    if ($checkAccessConditions) {
                        $currentdate = date("Y-m-d H:i:s");
                        $rt_q = $this->db->query(
                            "SELECT td.latitude,td.longitude,td.trailer_latitude,td.trailer_longitude,td.speed,td.battery,td.imei as mobileimei,td.trailer_imei as mobiletrailerimei,convertToClientTZ(td.receivedon,'" . $tzone . "') as timestamp,td.fuel,td.bearing,td.azimuth,td.key_exist,td.inouts,o.order_id AS orderid, o.shipmentid as shipmentid,o.trip_id as tripid FROM tb_trips tr  LEFT JOIN tb_orders o ON o.trip_id = tr.id LEFT JOIN tb_trucks_data td ON td.id = tr.vehicle_id  LEFT JOIN tb_stop_status s ON s.order_id =o.id AND s.trip_id =tr.id WHERE td.id='" . $tripdata->vehicle_id . "'  AND tr.status=1 AND s.status_code='0212' AND o.pickup_datetime <= '" . $currentdate . "'  AND TIMESTAMPDIFF(HOUR, '" . $currentdate . "', o.pickup_datetime) <= 2 AND o.company_code LIKE " . $this->db->escape(
                                $companyCode
                            ) . " GROUP BY tr.id LIMIT 1"
                        );
                    } else {
                        $rt_q = $this->db->query(
                            "SELECT td.latitude,td.longitude,td.trailer_latitude,td.trailer_longitude,td.speed,td.battery,td.imei as mobileimei,td.trailer_imei as mobiletrailerimei,convertToClientTZ(td.receivedon,'" . $tzone . "') as timestamp,td.fuel,td.bearing,td.azimuth,td.key_exist,td.inouts,o.order_id AS orderid, o.shipmentid as shipmentid,o.trip_id as tripid FROM tb_trips tr  LEFT JOIN tb_orders o ON o.trip_id = tr.id LEFT JOIN tb_trucks_data td ON td.id = tr.vehicle_id  LEFT JOIN tb_stop_status s ON s.order_id =o.id AND s.trip_id =tr.id WHERE td.id='" . $tripdata->vehicle_id . "'  AND tr.status=1 AND s.status_code='0212' AND o.pickup_datetime <= '" . $currentdate . "'  AND TIMESTAMPDIFF(HOUR, '" . $currentdate . "', o.pickup_datetime) <= 2 AND o.user_id IN (" . $usrs . ") GROUP BY tr.id LIMIT 1"
                        );
                    }
                    if ($rt_q->num_rows() > 0) {
                        $rec = $rt_q->row();
                        if ($checkAccessConditions) {
                            $d[] = getLocationName(
                                $rec->latitude,
                                $rec->longitude
                            ) . "<input type='hidden' id='position' value='" . $rec->latitude . "," . $rec->longitude . "'>
							<input type='hidden' id='imei' value='" . $rec->mobileimei . "'><input type='hidden' id='shipid' value='" . $rec->shipmentid . "'><input type='hidden' id='orderid' value='" . $rec->orderid . "'><input type='hidden' id='tripid' value='" . $rec->tripid . "'>";
                            if ($row->truck_number != '' && $row->truck_number != $row->register_number && ($rec->trailer_latitude != '' && $rec->trailer_longitude != '')) {
                                $d1[] = $row->truck_number;
                                $d1[] = getLocationName(
                                    $rec->trailer_latitude,
                                    $rec->trailer_longitude
                                ) . "<input type='hidden' id='position' value='" . $rec->trailer_latitude . "," . $rec->trailer_longitude . "'><input type='hidden' id='trailer_imei' value='" . $rec->mobiletrailerimei . "'><input type='hidden' id='shipid' value='" . $rec->shipmentid . "'><input type='hidden' id='orderid' value='" . $rec->orderid . "'><input type='hidden' id='tripid' value='" . $rec->tripid . "'>";
                            }
                        } else {
                            $d[] = getLocationName(
                                $rec->latitude,
                                $rec->longitude
                            ) . "<input type='hidden' id='position' value='" . $rec->latitude . "," . $rec->longitude . "'>
							<input type='hidden' id='speed' value='" . round(
                                (float) $rec->speed
                            ) . "'><input type='hidden' id='imei' value='" . $rec->mobileimei . "'><input type='hidden' id='fuel' value='" . $rec->fuel . "'><input type='hidden' id='bearing' value='" . round(
                                (float) $rec->bearing
                            ) . "'><input type='hidden' id='azimuth' value='" . $rec->azimuth . "'><input type='hidden' id='key_exist' value='" . $rec->key_exist . "'><input type='hidden' id='inouts' value='" . $rec->inouts . "'><input type='hidden' id='shipid' value='" . $rec->shipmentid . "'><input type='hidden' id='orderid' value='" . $rec->orderid . "'><input type='hidden' id='tripid' value='" . $rec->tripid . "'>";
                            if ($row->truck_number != '' && $row->truck_number != $row->register_number && ($rec->trailer_latitude != '' && $rec->trailer_longitude != '')) {
                                $d1[] = $row->truck_number;
                                $d1[] = getLocationName(
                                    $rec->trailer_latitude,
                                    $rec->trailer_longitude
                                ) . "<input type='hidden' id='position' value='" . $rec->trailer_latitude . "," . $rec->trailer_longitude . "'><input type='hidden' id='speed' value='" . round(
                                    (float) $rec->speed
                                ) . "'><input type='hidden' id='trailer_imei' value='" . $rec->mobiletrailerimei . "'><input type='hidden' id='fuel' value='" . $rec->fuel . "'><input type='hidden' id='bearing' value='" . round(
                                    (float) $rec->bearing
                                ) . "'><input type='hidden' id='azimuth' value='" . $rec->azimuth . "'><input type='hidden' id='key_exist' value='" . $rec->key_exist . "'><input type='hidden' id='inouts' value='" . $rec->inouts . "'><input type='hidden' id='shipid' value='" . $rec->shipmentid . "'><input type='hidden' id='truck_number' value='" . $row->truck_number . "'><input type='hidden' id='orderid' value='" . $rec->orderid . "'><input type='hidden' id='tripid' value='" . $rec->tripid . "'>";
                            }
                            if (strlen($rec->speed ?? "") > 0) {
                                $d[] = $d1[] = uom_string($rec->speed, 'kph');
                            } else {
                                $d[] = $d1[] = "";
                            }
                            $d[] = $d1[] = (strlen(trim($rec->battery ?? "")) > 0 ? $rec->battery . " %" : "");
                            $d[] = $d1[] = getShipDetailByVeh($tripdata->id);
                        }
                        if (strlen($rec->timestamp) > 0) {
                            $d[] = $d1[] = date('d M,Y H:i a', strtotime($rec->timestamp));
                        } else {
                            $d[] = $d1[] = "";
                        }
                        $data["data"][] = $d;
                        if ($row->truck_number != '' && $row->truck_number != $row->register_number && ($rec->trailer_latitude != '' && $rec->trailer_longitude != '')) {
                            $data["data"][] = $d1;
                        }
                        //log_message('error', 'data:' . json_encode($data));
                    }
                }/*else{
	            	if($this->session->userdata("company_code")!="PLKN"){
	            	$sql1 = "SELECT d.id,d.name FROM tbl_assigned_drivers a,tb_truck_drivers d WHERE a.driver_id=d.id AND a.vehicle_id=$veh AND a.status=1 AND d.status='Active' AND d.track_type!=1 GROUP BY d.id ORDER BY a.updated_on DESC LIMIT 1";
	                $qr11 = $this->db->query($sql1);
	                if($qr11->num_rows() > 0){
		            	$d[] = $qr11->row()->name;

		                //$d[] = $row->truck_number==""?$row->register_number:$row->truck_number;
		                $d[] = $row->register_number;

		                $rt_q = $this->db->query("SELECT latitude,longitude,speed,battery,imei as mobileimei,convertToClientTZ(receivedon,'".$tzone."') as timestamp,fuel,bearing,azimuth,key_exist,inouts FROM tb_trucks_data WHERE id = '".$veh."' LIMIT 1 ");
		                if($rt_q->num_rows()>0){
		                    $rec = $rt_q->row();
		                   $d[] = getLocationName($rec->latitude, $rec->longitude) . "<input type='hidden' id='position' value='" . $rec->latitude . "," . $rec->longitude. "'>
		                    <input type='hidden' id='speed' value='" . round($rec->speed) . "'><input type='hidden' id='imei' value='" . $rec->mobileimei . "'><input type='hidden' id='bearing' value='" . round($rec->bearing) . "'><input type='hidden' id='azimuth' value='" . $rec->azimuth . "'><input type='hidden' id='key_exist' value='" . $rec->key_exist . "'><input type='hidden' id='inouts' value='" . $rec->inouts . "'><input type='hidden' id='fuel' value='" . $rec->fuel . "'><input type='hidden' id='shipid' value=''>";
		                    if (strlen($rec->speed) > 0) {
		                        $d[] = round($rec->speed) . " KMPH";
		                    } else {
		                        $d[] = "";
		                    }
		                    $d[] = (strlen(trim($rec->battery)) > 0 ? $rec->battery . " %" : "");
		                    $d[] = getShipDetailByVeh($qr11->row()->id);
		                    if (strlen($rec->timestamp) > 0) {
		                        $d[] = date('d M,Y H:i a', strtotime($rec->timestamp));
		                    } else {
		                        $d[] = "";
		                    }
		                    $data["data"][] = $d;
		                }
		            }
		     	   }
	            }*/
            }
        }
        if ($checkAccessConditions) {
            $this->db->select("o.id,o.order_id as orderid,o.plat as latitude,o.plng as longitude,o.trip_sts");
            $this->db->from("tb_orders o");
            $where = "o.user_id IN (" . $cnUsers . ") AND o.trip_id=0 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.status!=0 AND o.trip_sts=0 AND o.plat!='' AND o.plng!=''";
            $this->db->where($where);
            $this->db->group_by('o.order_id');
            $this->db->order_by('o.pickup_datetime', 'DESC');
            $results = $this->db->get();
            if ($results->num_rows() > 0) {
                foreach ($results->result() as $orderData) {
                    $ordersData = [];
                    $ordersData[] = $orderData->id;
                    $ordersData[] = $orderData->trip_sts;
                    $ordersData[] = getLocationName(
                        $orderData->latitude,
                        $orderData->longitude
                    ) . "<input type='hidden' id='position' value='" . $orderData->latitude . "," . $orderData->longitude . "'>
						<input type='hidden' id='imei' value='0'><input type='hidden' id='shipid' value=''><input type='hidden' id='orderid' value='" . $orderData->orderid . "'><input type='hidden' id='tripid' value='0'>";
                    $ordersData[] = "";
                    $data["data"][] = $ordersData;
                }
            }
        }
        $checkAccessConditions = checkAccessConditions('WHEELS_EYE_COUNTRIES', $companyCode);
        if ($checkAccessConditions) {
            $results = $this->common->getWheelsEyeOrderVehicles();
            if ($results) {
                foreach ($results as $orderData) {
                    $orderData = (object) $orderData;
                    $ordersData = [];
                    $ordersData[] = $orderData->name;
                    $ordersData[] = $orderData->register_number;
                    $ordersData[] = getLocationName(
                        $orderData->latitude,
                        $orderData->longitude
                    ) . "<input type='hidden' id='position' value='" . $orderData->latitude . "," . $orderData->longitude . "'><input type='hidden' id='imei' value='" . $orderData->trailer_imei . "'><input type='hidden' id='shipid' value='" . $orderData->shipmentid . "'><input type='hidden' id='orderid' value='" . $orderData->orderid . "'><input type='hidden' id='tripid' value='0'><input type='hidden' id='fuel' value='" . $orderData->fuel . "'><input type='hidden' id='bearing' value='" . round((float) $orderData->bearing) . "'><input type='hidden' id='azimuth' value=''><input type='hidden' id='key_exist' value=''><input type='hidden' id='inouts' value=''>";
                    $ordersData[] = "";
                    $ordersData[] = "";
                    $ordersData[] = "";
                    $data["data"][] = $ordersData;
                }
            }
        }
        echo json_encode($data);
    }

    public function getNextStop($trip_id, $lat, $lng)
    {
        $temp = $this->db->query(
            "SELECT employee_id,stop_id FROM tb_trip_employee where trip_id = '$trip_id' ORDER BY stime DESC limit 1"
        );
        $trip = $this->db->query("SELECT shift_id FROM tb_trips where id = '$trip_id' limit 1");
        $next_stop = null;
        if ($temp->num_rows() > 0) {
            $emp = $temp->row()->employee_id;
            $stop_id = $temp->row()->stop_id;
            $shift_id = $trip->row()->shift_id;
            $next_stop = $this->db->query(
                "SELECT stopname,plat,plng FROM tb_shiporder_stops WHERE shipment_id = '$shift_id' AND id > '$stop_id' ORDER BY ordernumber ASC"
            )->row();
        } else {
            if ($temp->num_rows() > 0) {
                $next_stop = $this->db->query(
                    "SELECT stopname,plat,plng FROM tb_shiporder_stops WHERE shipment_id = '$shift_id' ORDER BY ordernumber ASC"
                )->row();
            }
        }
        if ($next_stop != null) {
            $res = distancemetrixship($lat, $lng, $next_stop->plat, $next_stop->plng);
            return "<input type='hidden' id='next_stop' value='" . implode(
                " - ",
                [
                    $next_stop->stopname,
                    $res["disttext"],
                    $res["duratext"]
                ]
            ) . "'>";
        } else {
            return "";
        }
    }

    public function addroute($shift)
    {
        $uid = $this->session->userdata("user_id");
        $route_id = $this->db->query(
            "select IFNULL(max(route_id),'0') as route_id from tb_shft_veh order by route_id desc limit 1"
        )->row()->route_id;
        $route_id++;
        $dummy = $this->db->where(array("user_id" => $uid, "register_number" => "DUMMYVEHICLE"))->get("tb_trucks_data");
        $did = 0;
        if ($dummy->num_rows() > 0) {
            $did = $dummy->row()->id;
        } else {
            $this->db->query(
                "INSERT INTO `tb_trucks_data` (`id`, `truck_number`, `length`, `breadth`, `truck_capacity`, `truck_type`, `available_type`, `description`, `register_number`, `insurence`, `chassisnumber`, `insuredby`, `insurestart`, `insureexp`, `route`, `user_id`, `createdby`, `updatedby`, `status`, `createdon`, `updatedon`, `gpsstatus`, `imei`, `phone`, `port`, `speedLimit`, `parent_id`, `contact_name`) VALUES (NULL, 'DUMMYVEHICLE', '0', '0', '9', '94', NULL, NULL, 'DUMMYVEHICLE', 'No', NULL, NULL, NULL, NULL, NULL, '$uid', '0', '0', 'Active', '2017-04-26 11:41:01', '2017-04-26 11:41:01', '0', NULL, NULL, NULL, NULL, '0', NULL)"
            );
            $did = $this->db->insert_id();
        }
        $this->db->insert(
            "tb_shft_veh",
            array(
                "user_id" => $uid,
                "shft_id" => $shift,
                "register_number" => "DUMMYVEHICLE",
                "vehicle_id" => $did,
                "route_id" => $route_id,
                "status" => "1"
            )
        );
        echo $this->lrv($shift);
    }

    public function delroute()
    {
        $post = array();
        $post = $this->input->post(null, true);
        $shft_id = $post["shft"];
        $route_id = $post["route_id"];
        $dt = date('Y-m-d H:i:s');
        $old_q = $this->db->get_where(
            "tb_shft_veh",
            array("shft_id" => $shft_id, "route_id" => $route_id, "status" => "1")
        );
        if ($old_q->num_rows() > 0) {
            $old_veh = $old_q->row()->vehicle_id;
            $cnt = $this->db->select('id')->where(
                array("shift_id" => $shft_id, "vehicle_id" => $old_veh, "status" => '1')
            )->get("tb_trips")->num_rows();
            if ($cnt == 0) {
                $this->db->where(array("shft_id" => $shft_id, "route_id" => $route_id, "status" => "1"))->update(
                    "tb_shft_veh",
                    array("status" => '0', 'updated_on' => $dt)
                );
            } else {
                $this->session->set_flashdata('error', "You can't Delete a Route while its Trip is RUNNING");
            }
        } else {
            $this->db->where(array("shft_id" => $shft_id, "route_id" => $route_id, "status" => "1"))->update(
                "tb_shft_veh",
                array("status" => '0', 'updated_on' => $dt)
            );
        }
        echo $this->lrv($shft_id);
    }

    public function updateshftemporder()
    {
        $response['status'] = 'fail';
        $user = $this->session->userdata('user_id');
        $post = array();
        $post = $this->input->post(null, true);
        if (isset($post)) {
            $shftid = $post['shftid'];
            $oldord = trim($post['oldord']);
            $neword = trim($post['neword']);
            if ($neword != "") {
                $routedata = explode(',', $neword);
                $oldord = explode(',', $oldord);
                foreach ($routedata as $key => $td) {
                    $whr = array('id' => $oldord[$td]);
                    $set = array('stop_order' => $key, 'updatedon' => date('Y-m-d H:i:s'));
                    $update = $this->db->set($set)->where($whr)->update('tb_employee');
                }
                /*$whr = array('user_id'=>$user,'status'=>1,'shift_id'=>$shftid);
				$emps = $this->db->order_by('stop_order','ASC')->get_where('tb_employee',$whr);
				$response = array();
				if($emps->num_rows() > 0){
					$i = 0;
					foreach($emps->result() as $emp){
						if(isset($routedata[$i])){
							$priority = $routedata[$i];
							if($i == $priority){
								$whr = array('id'=>$emp->id);
								$set = array('stop_order'=>$priority,'updatedon'=>date('Y-m-d H:i:s'));
								$update = $this->db->set($set)->where($whr)->update('tb_employee');
							}
						}
						$i++;
					}
				}*/
                $response['status'] = 'pass';
            }
        }
        echo json_encode($response);
    }

    public function assignCarrierToShipment()
    {
        $shift_id = $this->input->post("shift_id", true);
        $vendor_id = $this->input->post("vendor_id", true);
        $this->db->where(array("id" => $shift_id))->update("tb_shifts", array("vendor_id" => $vendor_id));
        $this->db->where(array("shft_id" => $shift_id, "status" => "1"))->update(
            "tb_shft_veh",
            array("carrier_id" => $vendor_id)
        );
    }

    public function emp_save($id = null)
    {
        $input = $this->input->post(null, true);
        $this->createUpdateStop($input, $id);
    }

    public function createUpdateStop($input, $id)
    {
        if ($id != null) {
            $upd = $this->updateStop($input, $id);
        } else {
            /*$this->removePrimaryStop(trim($input['shift_id']));*/
            $ins = $this->createStop($input);
        }
    }

    public function updateStop($input, $id, $logs = true)
    {
        $curdt = date('Y-m-d H:i:s');
        $data['name'] = $input['empName'];
        $data['shift_id'] = trim($input['shift_id']);
        if ($data['shift_id'] != "") {
            $data['assoc_id'] = $input['assoc_id'];
            $data['phone'] = $input['phone'];
            $data['pickup'] = $input['pickup'];
            $data['emailid'] = $input['emailid'];
            $data['drop'] = $input['drop'];
            $data['dlat'] = $input['dlat'];
            $data['dlng'] = $input['dlng'];
            $data['plat'] = $input['plat'];
            $data['stop_id'] = $input['stop_id'];
            $data['drop_stopid'] = $input['drop_stopid'];
            $data['plng'] = $input['plng'];
            $data['pickup_datetime'] = $input['pickup_datetime'];
            $data['drop_datetime'] = $input['drop_datetime'];
            $data['address'] = $input['address'];
            $data['capacity'] = $input['capacity'];
            $data['material_id'] = $input['material_id'];
            $data['information'] = $input['information'];
            $data["shipment_weight"] = $input['shipment_weight'];
            $data["shipment_volume"] = $input['shipment_volume'];
            $data["ship_type"] = $input['ship_type'];
            $data["customer_id"] = $input['customer_id'];
            $data["vendor_id"] = $input['carrier_id'];
            $data['stop_order'] = $input['stop_order'];
            $data['order_id'] = $input['order_id'];
            if ($data['order_id'] == "") {
                $data['order_id'] = "ORDER_" . time();
            }
            $data["basic_stop"] = "0";
            $pwd = rand(100000, 999999);
            $data['password'] = $pwd;
            $this->uploadImage($input);
            $sql = $this->db->query("select id from tb_employee where id='" . $id . "' and status='1'")->num_rows();
            if ($sql == 0) {
                if ($logs) {
                    echo json_encode(array("status" => "0", "message" => "Shipment Stop does not Exist!"));
                }
            } else {
                $data['user_id'] = $uid = $user_id = $this->session->userdata('user_id');
                $upd = $this->db->where("id", $id)->update("tb_employee", $data);
                $pickup = $this->db->select("stopname,plat,plng,stopcity,address,startdate,enddate")->get_where(
                    "tb_shiporder_stops",
                    array("id" => $input['stop_id']),
                    1,
                    0
                );
                $pickup_company = $pickup->row()->stopname;
                $startdate = $pickup->row()->startdate;
                $enddate = $pickup->row()->enddate;
                $pickup_city = $pickup->row()->stopcity;
                $pickup_address = $pickup->row()->address;

                $delivery = $this->db->select("stopname,plat,plng,stopcity,address,startdate,enddate")->get_where(
                    "tb_shiporder_stops",
                    array("id" => $input['drop_stopid']),
                    1,
                    0
                );
                $drop_company = $delivery->row()->stopname;
                $dstartdate = $delivery->row()->startdate;
                $denddate = $delivery->row()->enddate;
                $drop_city = $delivery->row()->stopcity;
                $drop_address = $delivery->row()->address;

                $chechord = $this->db->select("id")->get_where(
                    "tb_orders",
                    array("order_id" => $data['order_id']),
                    1,
                    0
                );
                if ($chechord->num_rows() > 0) {
                    $orddata = array(
                        'pickup_datetime' => $startdate,
                        'pickup_endtime' => $enddate,
                        'delivery_datetime' => $dstartdate,
                        'drop_endtime' => $denddate,
                        'pickup_company' => $pickup_company,
                        'delivery_company' => $drop_company,
                        'pickup_city' => $pickup_city,
                        'delivery_city' => $drop_city,
                        'pickup_address1' => $pickup_address,
                        'delivery_address1' => $drop_address,
                        'quantity' => $data['capacity'],
                        'weight' => $data['shipment_weight'],
                        'volume' => $data['shipment_volume'],
                        'user_id' => $user_id,
                        'customer_id' => $data["customer_id"],
                        'vendor_id' => $data["vendor_id"],
                        'plat' => $data['plat'],
                        'plng' => $data['plng'],
                        'dlat' => $data["dlat"],
                        'dlng' => $data["dlng"],
                        'shift_id' => $data['shift_id'],
                        'updatedon' => $curdt
                    );
                    $ord_id = $chechord->row()->id;
                    $upd = $this->db->where(array("id" => $ord_id))->update('tb_orders', $orddata);
                } else {
                    $orddata = array(
                        "order_id" => $data['order_id'],
                        'pickup_datetime' => $startdate,
                        'pickup_endtime' => $enddate,
                        'delivery_datetime' => $dstartdate,
                        'drop_endtime' => $denddate,
                        'pickup_company' => $pickup_company,
                        'delivery_company' => $drop_company,
                        'pickup_city' => $pickup_city,
                        'delivery_city' => $drop_city,
                        'pickup_address1' => $pickup_address,
                        'delivery_address1' => $drop_address,
                        'quantity' => $data['capacity'],
                        'weight' => $data['shipment_weight'],
                        'volume' => $data['shipment_volume'],
                        'user_id' => $user_id,
                        'customer_id' => $data["customer_id"],
                        'vendor_id' => $data["vendor_id"],
                        'plat' => $data['plat'],
                        'plng' => $data['plng'],
                        'dlat' => $data["dlat"],
                        'dlng' => $data["dlng"],
                        'shift_id' => $data['shift_id'],
                        'createdon' => $curdt,
                        'updatedon' => $curdt,
                        "created_source" => '6'
                    );
                    $ord_id = $this->common->insertTableData('tb_orders', $orddata);
                }
                $emp_id = $id;
                $shift_id = $data['shift_id'];
                $carrier_id = $data["vendor_id"];
                $this->updateShiftTables($emp_id, $shift_id, $carrier_id, $data);
                if ($logs) {
                    echo json_encode(array("status" => "1", "message" => "Shipment Stop Updated Successfully!"));
                }
            }
        } else {
            if ($logs) {
                echo json_encode(array("status" => "0", "message" => "Shipment Id should not be null!"));
            }
        }
    }

    public function createStop($input, $logs = true)
    {
        $data['name'] = $data['pkgitemid'] = $input['empName'];
        $data['shift_id'] = trim($input['shift_id']);
        if ($data['shift_id'] != "") {
            $data['phone'] = $input['phone'];
            $pwd = rand(100000, 999999);
            $data['password'] = $pwd;
            $data['pickup'] = $input['pickup'];
            $data['emailid'] = $input['emailid'];
            $data['drop'] = $input['drop'];
            $data['dlat'] = $input['dlat'];
            $data['dlng'] = $input['dlng'];
            $data['plat'] = $input['plat'];
            $data['plng'] = $input['plng'];
            $data['stop_id'] = $input['stop_id'];
            $data['drop_stopid'] = $input['drop_stopid'];
            $data['pickup_datetime'] = $input['pickup_datetime'];
            $data['drop_datetime'] = $input['drop_datetime'];
            $data['address'] = $input['address'];
            $data['capacity'] = $input['capacity'];
            $data['material_id'] = $input['material_id'];
            $data['information'] = isset($input['information']) ? $input['information'] : 'SHIPMENT';
            $data["shipment_weight"] = $input['shipment_weight'];
            $data["shipment_volume"] = $input['shipment_volume'];
            $data["ship_type"] = $input['ship_type'];
            $data["customer_id"] = $input['customer_id'];
            $data["vendor_id"] = $input['carrier_id'];
            $data["stop_order"] = $input['stop_order'];
            $data["order_id"] = $input['order_id'];
            if ($data['order_id'] == "") {
                $data['order_id'] = $this->session->userdata('usr_tzone')['country'] . time();
            }
            $data["basic_stop"] = isset($input['basic_stop']) ? $input['basic_stop'] : "0";
            $curdt = date('Y-m-d H:i:s');
            $data["createdon"] = $curdt;
            $upd = $this->uploadImage($input);
            $data['user_id'] = $uid = $user_id = $this->session->userdata('user_id');
            $ins = $this->db->insert("tb_employee", $data);
            $lsid = $this->db->insert_id();
            /*put into orders table*/
            $pickup = $this->db->select("stopname,plat,plng,stopcity,address,startdate,enddate")->get_where(
                "tb_shiporder_stops",
                array("id" => $input['stop_id']),
                1,
                0
            );
            $pickup_company = $pickup->row()->stopname;
            $startdate = $pickup->row()->startdate;
            $enddate = $pickup->row()->enddate;
            $pickup_city = $pickup->row()->stopcity;
            $pickup_address = $pickup->row()->address;

            $delivery = $this->db->select("stopname,plat,plng,stopcity,address,startdate,enddate")->get_where(
                "tb_shiporder_stops",
                array("id" => $input['drop_stopid']),
                1,
                0
            );
            $drop_company = $delivery->row()->stopname;
            $dstartdate = $delivery->row()->startdate;
            $denddate = $delivery->row()->enddate;
            $drop_city = $delivery->row()->stopcity;
            $drop_address = $delivery->row()->address;
            $chechord = $this->db->select("id")->get_where("tb_orders", array("order_id" => $data['order_id']), 1, 0);
            if ($chechord->num_rows() > 0) {
                $orddata = array(
                    'pickup_datetime' => $startdate,
                    'pickup_endtime' => $enddate,
                    'delivery_datetime' => $dstartdate,
                    'drop_endtime' => $denddate,
                    'pickup_company' => $pickup_company,
                    'delivery_company' => $drop_company,
                    'pickup_city' => $pickup_city,
                    'delivery_city' => $drop_city,
                    'pickup_address1' => $pickup_address,
                    'delivery_address1' => $drop_address,
                    'quantity' => $data['capacity'],
                    'weight' => $data['shipment_weight'],
                    'volume' => $data['shipment_volume'],
                    'user_id' => $user_id,
                    'customer_id' => $data["customer_id"],
                    'vendor_id' => $data["vendor_id"],
                    'plat' => $data['plat'],
                    'plng' => $data['plng'],
                    'dlat' => $data["dlat"],
                    'dlng' => $data["dlng"],
                    'shift_id' => $data['shift_id'],
                    'updatedon' => $curdt
                );
                $ord_id = $chechord->row()->id;
                $upd = $this->db->where(array("id" => $ord_id))->update('tb_orders', $orddata);
            } else {
                $orddata = array(
                    "order_id" => $data['order_id'],
                    'pickup_datetime' => $startdate,
                    'pickup_endtime' => $enddate,
                    'delivery_datetime' => $dstartdate,
                    'drop_endtime' => $denddate,
                    'pickup_company' => $pickup_company,
                    'delivery_company' => $drop_company,
                    'pickup_city' => $pickup_city,
                    'delivery_city' => $drop_city,
                    'pickup_address1' => $pickup_address,
                    'delivery_address1' => $drop_address,
                    'quantity' => $data['capacity'],
                    'weight' => $data['shipment_weight'],
                    'volume' => $data['shipment_volume'],
                    'user_id' => $user_id,
                    'customer_id' => $data["customer_id"],
                    'vendor_id' => $data["vendor_id"],
                    'plat' => $data['plat'],
                    'plng' => $data['plng'],
                    'dlat' => $data["dlat"],
                    'dlng' => $data["dlng"],
                    'shift_id' => $data['shift_id'],
                    'createdon' => $curdt,
                    'updatedon' => $curdt,
                    "created_source" => '6'
                );
                $ord_id = $this->common->insertTableData('tb_orders', $orddata);
            }
            $emp_id = $lsid;
            $shift_id = $data['shift_id'];
            $carrier_id = $data["vendor_id"];
            $upd = $this->updateShiftTables($emp_id, $shift_id, $carrier_id, $data);
            /*adddefaltsos($lsid);*/
            if ($logs) {
                echo json_encode(array("status" => "1", "message" => "Shipment Stop Added Successfully!"));
            }
        } else {
            if ($logs) {
                echo json_encode(array("status" => "0", "message" => "Shipment Id should not be null!"));
            }
        }
    }

    public function uploadImage($input)
    {
        $config = array(
            'upload_path' => './assets/employee/',
            'allowed_types' => 'jpg|jpeg|png|gif',
            'overwrite' => 1,
        );

        if (isset($_FILES)) {
            if (!empty($_FILES) && isset($input['img'])) {
                $image1 = $input['img'];
                $this->load->library('upload');
                $this->upload->initialize($config);
                if (!$this->upload->do_upload('img')) {
                    //$this->session->set_flashdata('error_msg', "Image format unsupported!");
                } else {
                    $original_size = getimagesize($_FILES['img']['tmp_name']);
                    $actualWidth = $original_size[0];
                    $actualHeight = $original_size[1];
                    //print_r($resize_settings);
                    $name = $_FILES['img']['name'];
                    $maxHeight = 340;
                    $maxWidth = 340;
                    if ($actualWidth > $maxWidth || $actualHeight > $maxHeight) {
                        $config['image_library'] = 'gd2';
                        $config['source_image'] = $this->upload->upload_path . $this->upload->file_name;
                        $config['maintain_ratio'] = true;
                        $config['new_image'] = './assets/employee';
                        $config['width'] = $maxWidth;
                        $config['height'] = $maxHeight;
                        $config['overwrite'] = true;
                        $data['img'] = $this->upload->file_name;
                        $this->load->library('image_lib', $config);
                        $this->image_lib->initialize($config);
                        $this->image_lib->resize();
                    } else {
                        $config['image_library'] = 'gd2';
                        $config['source_image'] = $this->upload->upload_path . $this->upload->file_name;
                        $config['maintain_ratio'] = true;
                        $config['new_image'] = './assets/employee';
                        $config['overwrite'] = true;
                        $data['img'] = $this->upload->file_name;
                        $this->load->library('image_lib', $config);
                        $this->image_lib->initialize($config);
                        $this->image_lib->resize();
                    }
                }
            }
        }
    }

    public function updateShiftTables($emp_id, $shift_id, $carrier_id, $data)
    {
        $uid = $this->session->userdata('user_id');
        $svq = $this->db->where(
            array("shft_id" => $shift_id, "carrier_id" => $carrier_id, "user_id" => $uid, "vehicle_id" => null)
        )->get("tb_shft_veh");
        if ($svq->num_rows() > 0) {
            $this->db->where(
                array("shft_id" => $shift_id, "carrier_id" => $carrier_id, "user_id" => $uid, "vehicle_id" => null)
            )->update("tb_shft_veh", array("status" => "0"));
            $shft_veh_id = $svq->row()->id;
            $this->db->where(array("id" => $shft_veh_id))->update("tb_shft_veh", array("status" => "1"));
        } else {
            $last_route_id = $this->db->query(
                "SELECT IFNULL(max(route_id),0) max_route from tb_shft_veh group by route_id"
            )->row()->max_route;

            $this->db->insert(
                "tb_shft_veh",
                array(
                    "shft_id" => $shift_id,
                    "carrier_id" => $carrier_id,
                    "route_id" => $last_route_id + 1,
                    "user_id" => $uid,
                    "status" => "1"
                )
            );
            $shft_veh_id = $this->db->insert_id();
        }
        $upd = $this->db->where(array("emp_id" => $emp_id))->update("tb_shft_veh_emp", array("status" => "0"));
        $sveq = $this->db->where(array("emp_id" => $emp_id, "shft_veh_id" => $shft_veh_id))->get("tb_shft_veh_emp");
        if ($sveq->num_rows() > 0) {
            $shft_veh_emp_id = $sveq->row()->id;
            $this->db->where(array("id" => $shft_veh_emp_id))->update(
                "tb_shft_veh_emp",
                array(
                    "status" => "1",
                    "priority" => $data['stop_order'],
                    "pickup_time" => $data['pickup_datetime']
                )
            );
        } else {
            $this->db->insert(
                "tb_shft_veh_emp",
                array(
                    "shft_veh_id" => $shft_veh_id,
                    "user_id" => $uid,
                    "emp_id" => $emp_id,
                    "status" => "1",
                    "priority" => $data['stop_order'],
                    "pickup_time" => $data['pickup_datetime']
                )
            );
            $shft_veh_emp_id = $this->db->insert_id();
        }
        $svq = $this->db->where(array("shft_id" => $shift_id, "user_id" => $uid))->get("tb_shft_veh");
        foreach ($svq->result() as $svr) {
            if ($svr->id != $shft_veh_id) {
                $sveq = $this->db->where(array("shft_veh_id" => $svr->id, "status" => "1"))->get("tb_shft_veh_emp");
                if ($sveq->num_rows() == 0) {
                    $this->db->where(array("id" => $svr->id))->update("tb_shft_veh", array("status" => "0"));
                }
            }
        }
    }

    public function getShipmentStopDetails()
    {
        $shift_id = $this->input->post("shift_id", true);
        $stop_id = $this->input->post("stop_id", true);
        $data = array();
        $data["stops"] = $this->db->query(
            "SELECT id,stopname,address,plat,plng,stoptype,stopstatus,ordernumber,startdate,enddate,weight,volume from tb_shiporder_stops WHERE status = '1' AND shipment_id=$shift_id ORDER BY ordernumber ASC"
        )->result_array();
        if ($stop_id == "") {
            if (count($data["stops"]) > 0) {
                $stop_id = $data["stops"][0]["id"];
            }
        }
        $Stop_Details_data = array();
        if ($stop_id == "") {
            echo json_encode(array("status" => "0", "message" => "No stops found for this shipment"));
        } else {
            $data["status"] = "1";
            $stop_details = $this->db->query(
                "SELECT * FROM (SELECT e.id,e.stop_id,e.pickup,e.plat,e.plng,e.`drop`,e.dlat,e.dlng,e.pickup_city,e.	drop_city,e.pickup_datetime,e.drop_datetime,e.name,e.material_id,e.shipment_weight,e.shipment_volume,'P' as ship_type,e.customer_id,e.vendor_id,e.stop_order,e.order_id,c.name as customer_name,v.name as carrier_name,m.material as material_name FROM `tb_employee` e JOIN tb_vendors v ON v.id = e.vendor_id JOIN tb_customers c ON c.id = e.customer_id JOIN tb_materials m ON m.id = e.material_id where e.shift_id=$shift_id AND e.status=1 AND e.stop_id='$stop_id' UNION SELECT e.id,e.drop_stopid,e.pickup,e.plat,e.plng,e.`drop`,e.dlat,e.dlng,e.pickup_city,e.drop_city,e.pickup_datetime,e.drop_datetime,e.name,e.material_id,e.shipment_weight,e.shipment_volume,'D' as ship_type,e.customer_id,e.vendor_id,e.drop_order as stop_order,e.order_id,c.name as customer_name,v.name as carrier_name,m.material as material_name FROM `tb_employee` e JOIN tb_vendors v ON v.id = e.vendor_id JOIN tb_customers c ON c.id = e.customer_id JOIN tb_materials m ON m.id = e.material_id where e.shift_id=$shift_id AND e.status=1 AND e.drop_stopid ='$stop_id') P ORDER BY stop_order"
            )->result_array();
            if (!empty($data)) {
                foreach ($stop_details as $sd) {
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowEditstopdetails(this," . $sd['id'] . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='stopdetailsrowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Stop</a></li><input type='hidden' form='vat_data' name='laneids[]' value='" . $sd['id'] . "'>";

                    $Stop_Details_data[] = array(
                        'Stop_Sequence' => $sd['stop_order'],
                        'Order_No' => $sd['order_id'],
                        'Material' => $sd['material_name'],
                        'Type' => $sd['ship_type'],
                        'Customer_Name' => $sd['customer_name'],
                        'Carrier_Name' => $sd['carrier_name'],
                        'Pickup_Stop' => $sd['pickup'],
                        'Drop_Stop' => $sd['drop'],
                        'Pickup_Date' => $sd['pickup_datetime'],
                        'Drop_Date' => $sd['drop_datetime'],
                        'Pickup_Location' => $sd['pickup_city'],
                        'Droping_Location' => $sd['drop_city'],
                        'Shipment_Capacity' => $sd['ship_type'],
                        'Shipment_Weight' => $sd['shipment_weight'],
                        'Shipment_Volume' => $sd['shipment_volume'],
                        "action" => $action
                    );
                }
            }
            $data['Stop_Details_data'] = $Stop_Details_data;
            echo json_encode($data);
        }
    }

    public function editStopDetails()
    {
        $stop_id = $this->input->post("stop_id", true);
        $data["stop"] = $this->db->query("select * from tb_employee where id=$stop_id")->row_array();
        if (!empty($data['stop'])) {
            $res = $data['stop'];
            $shift_id = $res['shift_id'];
            if ($shift_id != '0') {
                $data["shifts"] = $this->db->query(
                    "SELECT id,stopname,address,plat,plng,stoptype,stopstatus,ordernumber,startdate,enddate,weight,volume from tb_shiporder_stops WHERE status = '1' AND shipment_id=$shift_id ORDER BY ordernumber ASC"
                )->result_array();
            }
        }
        echo json_encode($data);
    }

    public function editStop()
    {
        $stop_id = $this->input->post("stop_id", true);
        $data["stop"] = $this->db->query("select * from tb_shiporder_stops where id=$stop_id")->row_array();
        echo json_encode($data);
    }

    public function getShipmentRates()
    {
        $shift_id = $this->input->post("shift_id", true);
        $data["rates"] = $this->db->query(
            "SELECT r.id,rc.name as category,r.rate from tb_shipment_rates r,tb_shipment_rate_categories rc where r.shift_id=$shift_id AND rc.id=r.category"
        )->result_array();
        echo json_encode($data);
    }

    public function saveShipmentRate($id = null)
    {
        if ($id == null) {
            $data["shift_id"] = $this->input->post("shift_id", true);
            $data["category"] = $this->input->post("category", true);
            $data["rate"] = $this->input->post("rate", true);
            $this->db->insert("tb_shipment_rates", $data);
            echo json_encode(array("status" => "1", "message" => "Shipment Rate Added Successfully!"));
        } else {
            $data["shift_id"] = $this->input->post("shift_id", true);
            $data["category"] = $this->input->post("category", true);
            $data["rate"] = $this->input->post("rate", true);
            $this->db->where(array("id" => $id))->update("tb_shipment_rates", $data);
            echo json_encode(array("status" => "1", "message" => "Shipment Rate Updated Successfully!"));
        }
    }

    public function editRate()
    {
        $rate_id = $this->input->post("rate_id", true);
        $data["rate"] = $this->db->query("select * from tb_shipment_rates where id=$rate_id")->row_array();
        echo json_encode($data);
    }

    public function createPrimaryStop($shipment_id, $logs = true)
    {
        $shipment = $this->db->where("id", $shipment_id)->get("tb_shifts")->row();
        $tb_shiporder_stop = array(
            "stopname" => $shipment->splace,
            "address" => $shipment->splace,
            "plat" => $shipment->slat,
            "plng" => $shipment->slng,
            "stoptype" => "P",
            "shipment_id" => $shipment->id,
            "ordernumber" => "1",
            "startdate" => $shipment->startdate,
            "weight" => "1",
            "volume" => "1",
            "status" => "1"
        );
        $this->db->insert("tb_shiporder_stops", $tb_shiporder_stop);
        $tb_shiporder_stop = array(
            "stopname" => $shipment->eplace,
            "address" => $shipment->eplace,
            "plat" => $shipment->elat,
            "plng" => $shipment->elng,
            "stoptype" => "D",
            "shipment_id" => $shipment->id,
            "ordernumber" => "2",
            "startdate" => $shipment->enddate,
            "weight" => "1",
            "volume" => "1",
            "status" => "1"
        );
        $this->db->insert("tb_shiporder_stops", $tb_shiporder_stop);
    }

    public function removePrimaryStop($shipment_id)
    {
        $uid = $user_id = $this->session->userdata('user_id');
        $bstop = $this->db->where(array("shift_id" => $shipment_id, "basic_stop" => "1", "status" => "1"))->get(
            "tb_employee"
        );
        if ($bstop->num_rows() > 0) {
            $stop_id = $bstop->row()->id;
            $this->db->where(array("id" => $stop_id))->update("tb_employee", array("status" => "0"));
            $this->db->where(array("emp_id" => $stop_id))->update("tb_shft_veh_emp", array("status" => "0"));
        }
        $svq = $this->db->where(array("shft_id" => $shipment_id, "user_id" => $uid))->get("tb_shft_veh");
        foreach ($svq->result() as $svr) {
            $sveq = $this->db->where(array("shft_veh_id" => $svr->id, "status" => "1"))->get("tb_shft_veh_emp");
            if ($sveq->num_rows() == 0) {
                $this->db->where(array("id" => $svr->id))->update("tb_shft_veh", array("status" => "0"));
            }
        }
    }

    public function assignCarrier()
    {
        $uid = $user_id = $this->session->userdata('user_id');
        $shift_id = $this->input->post("shift_id", true);
        $emp_id = $this->input->post("emp_id", true);
        $vendor_id = $this->input->post("vendor_id", true);
        $sve_id = $this->input->post("sve_id", true);
        $emp = $this->db->where(array("id" => $emp_id))->get("tb_employee")->row();
        $data["empName"] = $emp->name;
        $data["assoc_id"] = $emp->assoc_id;
        $data["shift_id"] = $shift_id;
        $data["stop_order"] = $emp->stop_order;
        $data["customer_id"] = $emp->customer_id;
        $data["carrier_id"] = $vendor_id;
        $data["ship_type"] = $emp->ship_type;
        $data["pickup"] = $emp->pickup;
        $data["plat"] = $emp->plat;
        $data["plng"] = $emp->plng;
        $data["pickup_datetime"] = $emp->pickup_datetime;
        $data["drop"] = $emp->drop;
        $data["dlat"] = $emp->dlat;
        $data["dlng"] = $emp->dlng;
        $data["drop_datetime"] = $emp->drop_datetime;
        $data["capacity"] = $emp->capacity;
        $data["shipment_weight"] = $emp->shipment_weight;
        $data["shipment_volume"] = $emp->shipment_volume;
        $data["material_id"] = $emp->material_id;
        $data["phone"] = $emp->phone;
        $data["emailid"] = $emp->emailid;
        $data["information"] = $emp->information;
        $data["address"] = $emp->address;
        $data["img"] = $emp->img;
        $data["basic_stop"] = "0";
        $this->updateStop($data, $emp_id, false);
    }

    public function getShipmentStops()
    {
        $shift_id = $this->input->post("shift_id", true);
        $data = array();
        $stopsqry = $this->db->query(
            "SELECT id,stopname,address,plat,plng,stoptype,stopstatus,ordernumber,startdate,enddate,weight,volume from tb_shiporder_stops WHERE status = '1' AND shipment_id=$shift_id ORDER BY ordernumber ASC"
        );
        if ($stopsqry->num_rows() > 0) {
            foreach ($stopsqry->result_array() as $stops) {
                $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowEditstop(this," . $stops['id'] . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='stoprowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Stop</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='showStopDetails(" . $stops['id'] . ");'><span class='glyphicon glyphicon-plus' > </span>Stop Details</a></li>";

                $data[] = array(
                    'id' => $stops['id'],
                    'Address' => $stops['address'],
                    'SNo' => $stops['ordernumber'],
                    'Stop' => $stops['stopname'],
                    'Type' => $stops['stoptype'],
                    'Start' => $stops['startdate'],
                    'End' => $stops['enddate'],
                    'Weight' => $stops['weight'],
                    'Volumne' => $stops['volume'],
                    "Actions" => $action
                );
            }
        }
        echo json_encode($data);
    }

    public function saveStop($id = null)
    {
        $input = array();
        $input = $this->input->post(null, true);
        if ($id == null) {
            $input["status"] = "1";
            $input['txncode'] = "NP";
            $stopcity = "";
            if (isset($input['stopname'])) {
                $stopcity = explode(", ", $input['stopname'])[0];
            }
            if ($stopcity != "") {
                $input['stopcity'] = $stopcity;
            }
            if (isset($input['enddate'])) {
                if ($input['enddate'] == "") {
                    $input['enddate'] = $input['startdate'];
                }
            } else {
                $input['enddate'] = $input['startdate'];
            }
            $input['ship_units'] = '1';
            if (isset($input['weight'])) {
                if ($input['weight'] == "") {
                    $input['weight'] = 0;
                }
            }
            if (isset($input['volume'])) {
                if ($input['volume'] == "") {
                    $input['volume'] = 0;
                }
            }
            $input['created_on'] = date('Y-m-d H:i:s');
            $ins = $this->db->insert("tb_shiporder_stops", $input) ? $this->db->insert_id() : 0;

            if ($ins) {
                echo json_encode(["status" => "1", "message" => "Shipment Stop Added Successfully!"]);
            } else {
                echo json_encode(["status" => "0", "message" => "Error Adding Shipment Stop!"]);
            }
        } else {
            if (isset($input['weight'])) {
                if ($input['weight'] == "") {
                    $input['weight'] = 0;
                }
            }
            if (isset($input['volume'])) {
                if ($input['volume'] == "") {
                    $input['volume'] = 0;
                }
            }
            $this->db->where(array("id" => $id))->update("tb_shiporder_stops", $input);
            echo json_encode(array("status" => "1", "message" => "Shipment Stop Updated Successfully!"));
        }
    }

    public function sendToServer()
    {
        $org = $this->input->post("org", true);
        $opt = $this->input->post("opt", true);
        foreach ($org as $ind => $row) {
            $this->db->where(array("id" => $row["id"]))->update(
                "tb_shiporder_stops",
                array("ordernumber" => $opt[$ind])
            );
        }
    }

    public function getCompletedTrips()
    {
        $input = $this->input->post(null, true);
        $driver_id = $input["driver_id"] ?? [];
        $trips = [];

        if (!is_array($driver_id)) {
            $driver_id = $driver_id ? [$driver_id] : [];
        }

        if (!empty($driver_id)) {
            $sql = $this->db->select("id,splace,eplace")->where(array("status" => "0"))->where_in(
                "driver_id",
                $driver_id
            )->get("tb_trips");

            foreach ($sql->result() as $row) {
                $trips[] = [
                    "id" => $row->id,
                    "name" => "<div class='btn btn-xs btn-primary' onclick='openTripMap(\"" . $row->id . "\",\"T-" . $row->id . " - " . $row->splace . " - " . $row->eplace . "\")'>T-" . $row->id . "</div> " . $row->splace . " - " . $row->eplace
                ];
            }
        }

        echo json_encode($trips);
    }

    public function superadmin()
    {
        $data = array();
        $pdate = $ddate = [];

        $pqry = $this->db->query(
            "SELECT count(id) as cnt,DATE(pickup_datetime) as pdate FROM tb_orders WHERE DATE(pickup_datetime) >= DATE(NOW()) GROUP  BY DATE(pickup_datetime) ORDER BY pickup_datetime LIMIT 5"
        );
        if ($pqry->num_rows() > 0) {
            foreach ($pqry->result() as $res) {
                $pdate[] = ['cnt' => $res->cnt, 'date' => $res->pdate];
            }
        }
        $dqry = $this->db->query(
            "SELECT count(id) as cnt,DATE(delivery_datetime) as pdate FROM tb_orders WHERE DATE(delivery_datetime) >= DATE(NOW()) GROUP  BY DATE(delivery_datetime) ORDER BY delivery_datetime LIMIT 5"
        );
        if ($dqry->num_rows() > 0) {
            foreach ($dqry->result() as $res) {
                $ddate[] = ['cnt' => $res->cnt, 'date' => $res->pdate];
            }
        }

        $this->settemplate->dashboard("shift/superadmin", $data);
    }

    /* Notify Code*/
    public function sendnotify($action, $shift_id)
    {
        $this->load->library('notifytrigger');
        $info['page_title'] = 'Booking Notification';
        $info['subject'] = 'Booking Notification';
        $data['shift_id'] = $shift_id;
        $data['action'] = $action;
        $info['order_id'] = '';
        $shipinfo = $this->common->gettblrowdata(array('id' => $data['shift_id']), 'shipmentid', 'tb_shifts', 0, 0);
        $data['shiftid'] = (!empty($shipinfo['shipmentid'])) ? $shipinfo['shipmentid'] : '';
        $data['body'] = $this->load->view('mail_forms/notifytrigger/trip_edit', $data, true);
        $this->notifytrigger->sendtripnotify($data);
    }

    public function get_dashboarddata()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            return false;
        }
        $curtz1 = $this->session->userdata('usr_tzone');
        $curtz = $curtz1['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $cdate = $getactual['date'];
        $company_code = $this->session->company_code;
        if ($this->input->post('branchcode') != 'All') {
            $branchcode = $this->input->post('branchcode');
            $whr3 = " AND o.company_code like '%" . $company_code . "%' AND o.branch_code like '%" . $branchcode . "%'";
        } else {
            $whr3 = " AND o.company_code like '%" . $company_code . "%'";
        }
        $userid = $this->session->user_id;
        $whr2 = " user_id=$userid";
        $mainqry = "SELECT o.id FROM tb_orders o WHERE  (o.trip_id!=0 OR (o.trip_id=0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id)>0)) AND o.status!=0 AND o.trip_sts=0 $whr3 GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $actbk = $this->db->query($mainqry);
        $data['activebooks'] = $actbk->num_rows();
        /*pending bookings*/
        $mainqry = "SELECT o.id FROM tb_orders o WHERE  o.status!=0 AND o.trip_id=0  $whr3 AND (`o`.`trip_id` =0 AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) =0) AND o.trip_sts=0 GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
        $pendbk = $this->db->query($mainqry);
        $data['pendbooks'] = $pendbk->num_rows();
        /*completed bookings*/
        $mainqry = "SELECT o.id FROM tb_orders o WHERE o.trip_sts=1 $whr3 ORDER BY o.updatedon";
        $donebk = $this->db->query($mainqry);
        $data['donebooks'] = $donebk->num_rows();
        /*alerts*/
        $mainqry = "SELECT count(id) as cnts FROM tb_trip_alerts WHERE $whr2 AND DATE(created_on)='" . $cdate . "'";
        $alertbk = $this->db->query($mainqry);
        $data['alertbooks'] = 0;
        echo json_encode($data);
    }

    /* public function dashboardSearch()
    {
        $tripId = $this->input->get('trip_id');
        log_message('error', 'trip id:' . json_encode($tripId));
        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        $tripData = $this->dtvmodel->SearchTripData($tripId);


        if ($tripData) {
            echo json_encode([
                'is_valid' => true,
                'data' => [
                    'slat' => $tripData->slat,
                    'slng' => $tripData->slng,
                    'elat' => $tripData->elat,
                    'elng' => $tripData->elng
                ]
            ]);
        } else {
            echo json_encode(['is_valid' => false]);
        }
    }*/
    public function dashboardSearch()
    {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $tripId    = $this->input->get('trip_id') ?? "";
        $carrierId = $this->input->get('carrierType') ?? "";
        $vehicleId = $this->input->get('vehicleId') ?? "";
        $error_msg = '';
       /* log_message('error', 'message:' . json_encode([$tripId, $vehicleId, $carrierId]));*/

        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        $history = [];

        if ($carrierId != "") {
            $shift_ids = $this->dtvmodel->shiftsdata($carrierId);
            $history = $this->allCarrierdata($shift_ids);
            if (!$history) {
                $error_msg = "No Data In This Carrier";
            }

            if ($tripId != "") {
                $history = array_filter($history, function ($his) use ($tripId) {
                    return isset($his['shipmentid']) && $his['shipmentid'] == $tripId;
                });

                if (!$history) {
                    $error_msg = "No Such Trip In This Carrier";
                }

                if ($vehicleId != "") {
                    $first = reset($history);
                    if (!isset($first['register_number']) || $first['register_number'] != $vehicleId) {
                        $history = [];
                        $error_msg = "No Vehicle With The Provided Details";
                    }
                }
            } else {
                if ($vehicleId != "") {
                    $history = array_filter($history, function ($his) use ($vehicleId) {
                        return isset($his['register_number']) && $his['register_number'] == $vehicleId;
                    });
                }
                if (!$history) {
                    $error_msg = "No Such Vehicle In This Carrier";
                }
            }

            //log_message('error', 'data:' . json_encode($history));
            if ($history) {
                $history = array_values($history);
                echo json_encode($history);
            } else {
                echo json_encode(['is_valid' => false, 'error_msg' => $error_msg]);
            }
            return;
        }
        if ($tripId != "") {
            $history = $this->TripData($tripId) ?? [];
            if (empty($history)) {
                $error_msg = "No Such Trip With That Trip Id";
            }
            if (
                isset($history['data']['register_number']) &&
                $vehicleId != "" &&
                $history['data']['register_number'] != $vehicleId
            ) {
                $history = [];
                $error_msg = "Given Vehicle Does Not Match Trip's Vehicle";
            }

            if ($history) {
                $history['is_valid'] = true;
                echo json_encode($history);
            } else {
                echo json_encode(['is_valid' => false, 'error_msg' => $error_msg]);
            }

            return;
        }

        if ($vehicleId != "" && $carrierId == "" && $tripId == "") {
            $history = $this->dashboardSearchByVehicle($vehicleId) ?? [];
            if ($history) {
                $history['byvehicle'] = 1;
                echo json_encode($history);
            } else {
                $error_msg = "No Such Vehicle Exist";
                echo json_encode(['is_valid' => false, 'error_msg' => $error_msg]);
            }
            return;
        }
    }



    public function allCarrierdata($shift_ids)
    {
        $companyCode = $this->session->userdata('company_code');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $all_Ctrips = [];
        $rt_data = [];

        foreach ($shift_ids as $id) {
            if ($id['id']) {
                $shift_id = $id['id'];
                $sql = $this->db->query(
                    "SELECT ts.id,ts.shipment_id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,ts.comment,convertToClientTZ(ts.createdon,?) as createdon,e.address,e.order_id,e.pickup,e.drop,tsv.register_number,ts.driver_id
            FROM tb_stop_status ts 
            LEFT JOIN tb_status_master sm ON sm.id = ts.status_id 
            LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id = ts.stop_id OR e.drop_stopid = ts.stop_id) 
            LEFT JOIN tb_shft_veh tsv on ts.shipment_id=tsv.shft_id
            WHERE ts.shipment_id = ? 
            GROUP BY ts.id 
            ORDER BY ts.createdon DESC
            LIMIT 1",
                    [$curtz, $shift_id]
                );

                $history = $sql->num_rows() > 0 ? $sql->result_array() : [];

                if (!empty($history)) {
                    $query = $this->db->query("SELECT id FROM tb_trucks_data WHERE truck_number = ?", [$history[0]['register_number']]);
                    $row = $query->row();
                    $currentdate = date("Y-m-d H:i:s");
                    if (isset($row->id)) {
                        $rt_q = $this->db->query(
                            "SELECT td.latitude,td.longitude,td.trailer_latitude,td.trailer_longitude,td.speed,td.battery,td.imei as mobileimei,td.trailer_imei as mobiletrailerimei,convertToClientTZ(td.receivedon,'" . $curtz . "') as timestamp,td.fuel,td.bearing,td.azimuth,td.key_exist,td.inouts,o.order_id AS orderid, o.shipmentid as shipmentid,o.trip_id as tripid FROM tb_trips tr  LEFT JOIN tb_orders o ON o.trip_id = tr.id LEFT JOIN tb_trucks_data td ON td.id = tr.vehicle_id  LEFT JOIN tb_stop_status s ON s.order_id =o.id AND s.trip_id =tr.id WHERE td.id='" . $row->id . "'  AND tr.status=1 AND s.status_code='0212' AND o.pickup_datetime <= '" . $currentdate . "'  AND TIMESTAMPDIFF(HOUR, '" . $currentdate . "', o.pickup_datetime) <= 2 AND o.company_code LIKE " . $this->db->escape(
                                $companyCode
                            ) . " GROUP BY tr.id LIMIT 1"
                        );
                        $rt_data = $rt_q->row_array() ?? [];
                    }
                    $sql2 = $this->db->query("select name from tb_truck_drivers where id=?", [$history[0]['driver_id']]);
                    $row2 = $sql2->row_array() ?? [];

                    $ships = $this->getShipingDetailByVeh($history[0]['driver_id']);

                    $trip_data = [
                        'shipmentid' => $id['shipmentid'],
                        'latitude'   => $history[0]['latitude'] ?? '',
                        'longitude'  => $history[0]['longitude'] ?? '',
                        'status'     => $history[0]['status_name'] ?? '',
                        'status_code' => $history[0]['status_code'] ?? '',
                        'register_number' => $history[0]['register_number'],
                        'driver' => $row2,
                        'rt_data' => $rt_data,
                        'ships_data' => $ships
                    ];

                    $all_Ctrips[] = $trip_data;
                }
            }
        }
        return $all_Ctrips;
    }


    /*public function TripData($tripId)
    {
        log_message('error', 'came to tripData controller');
        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        $tripData = $this->dtvmodel->SearchTripData($tripId);
        if ($tripData['trip_data']) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $shift_id = $tripData['trip_data']->id;

            $sql = $this->db->query(
                "SELECT ts.id,ts.shipment_id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,ts.comment,convertToClientTZ(ts.createdon,?) as createdon,e.address,e.order_id,e.pickup,e.drop 
                FROM tb_stop_status ts 
                LEFT JOIN tb_status_master sm ON sm.id = ts.status_id 
                LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id = ts.stop_id OR e.drop_stopid = ts.stop_id) 
                WHERE ts.shipment_id = ? 
                GROUP BY ts.id 
                ORDER BY ts.createdon ASC",
                [$curtz, $shift_id]
            );

            $history = $sql->num_rows() > 0 ? $sql->result_array() : [];

            // foreach ($history as &$his) {
            //     if (empty($his['loc_name']) && !empty($his['latitude']) && !empty($his['longitude'])) {
            //         $location = getLocationName($his['latitude'], $his['longitude']);
            //         $his['loc_name'] = $location;
            //     }
            // }
            unset($his);
            $response = [
                'is_valid' => true,
                'data' => [
                    'slat' => $tripData['trip_data']->slat,
                    'slng' => $tripData['trip_data']->slng,
                    'elat' => $tripData['trip_data']->elat,
                    'elng' => $tripData['trip_data']->elng,
                    'splace' => $tripData['trip_data']->splace ?? "N/A",
                    'eplace' => $tripData['trip_data']->eplace ?? "N/A",
                    'register_number' => $tripData['veh_no'] ?? "N/A",
                    'history' => $history,
                ]
            ];
            return $response;
        }
    }*/

    public function TripData($tripId)
    {
        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        $tripData = $this->dtvmodel->SearchTripData($tripId);
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $shift_id = $tripData['shift_id'];
        $sql = $this->db->query(
            "SELECT ts.id,ts.shipment_id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,ts.comment,convertToClientTZ(ts.createdon,?) as createdon,e.address,e.order_id,e.pickup,e.drop 
                FROM tb_stop_status ts 
                LEFT JOIN tb_status_master sm ON sm.id = ts.status_id 
                LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id = ts.stop_id OR e.drop_stopid = ts.stop_id) 
                WHERE ts.shipment_id = ? 
                ORDER BY ts.id ASC",
            [$curtz, $shift_id]
        );
        /*GROUP BY ts.id ORDER BY ts.createdon ASC*/
        $history = $sql->num_rows() > 0 ? $sql->result_array() : [];
        if ($tripData['trip_data']) {
            $tripdata = $tripData['trip_data'];
            $stops = [];
            unset($his);
            foreach ($tripdata as $stop) {
                //log_message('error', 'leg:' . print_r($stop, true));
                $stops[] = [
                    'transport_mode'  => $stop['transport_mode'],
                    'slat'            => $stop['slat'],
                    'slng'            => $stop['slng'],
                    'elat'            => $stop['elat'],
                    'elng'            => $stop['elng'],
                    'splace'          => $stop['splace'] ?? "N/A",
                    'eplace'          => $stop['eplace'] ?? "N/A",
                    'register_number' => $tripData['veh_no'] ?? "N/A",
                    'history'         => $history,
                ];
            }
            $response = [
                'is_valid' => true,
                'is_multi_leg' => true,
                'data' => $stops
            ];
            //log_message('error', 'response:' . print_r($response, true));
            return $response;
        }
        return ['is_valid' => false, 'data' => []];
    }


    public function dashboardSearchByVehicle($vehicleId)
    {
        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        $tripData = $this->dtvmodel->SearchTripDataByVehicle($vehicleId);
        return $this->_sendTripResponse($tripData);
    }

    private function _sendTripResponse($tripData)
    {
        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        if ($tripData['trip_data']) {
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $trip_data = $tripData['trip_data'];
            $shift_ids = array_column($trip_data, 'id');
            $trips_veh = [];
            foreach ($trip_data as $data) {
                $trips_veh[] = $data;
            }

            $veh_no = $trip_data[0]['veh_no'];
            $vehicleCurrentLocation = $this->dtvmodel->getCurrentLocation($veh_no);
            $vehData = [
                'is_valid' => true,
                'data' => $trips_veh,
                'clat' => $vehicleCurrentLocation->latitude,
                'clang' => $vehicleCurrentLocation->longitude
            ];
            //log_message('error', 'final_trip_data:' . print_r($vehData, true));
            return $vehData;
        } else {
            return [];
        }
    }
    
    public function getCarrierData()
    {
        $btype = $this->session->userdata('business_type');
        if ($btype == "Customer" && $custId = $this->session->userdata('cust_id')) {
            $carriers = $this->db
                ->distinct()
                ->select('v.id,v.name')
                ->from('tb_vendors v')
                ->join('tb_orders o', 'v.id = o.vendor_id')
                ->where('o.customer_id', $custId)
                ->get()
                ->result_array();
        }
        elseif ($btype == "Carrier" && $vid=$this->session->userdata('id')) {
            $carriers = $this->db
                ->distinct()
                ->select('id,name')
                ->from('tb_vendors v')
                ->where('id', $vid)
                ->get()
                ->result_array();
        } else {
            $companyCode = $this->session->userdata('company_code');
            $carriers = $this->db
                ->distinct()
                ->select('id,name')
                ->from('tb_vendors')
                ->where('company_code', $companyCode)
                ->get()
                ->result_array();
        }
        if (! empty($carriers)) {
            log_message('error', 'vendors:' . json_encode($carriers));
            echo json_encode($carriers);
        } else {
            echo json_encode(['is_valid' => false]);
        }
    }
    
    public function allLoadTrips()
    {

        if ($onloadtrips = $this->session->userdata("onloadtrips")) {
            log_message("error", "this is form session");
            echo json_encode($onloadtrips);
            return;
        }

        // log_message('error', 'shifts:' . json_encode($this->session->userdata()));
        $btype = $this->session->userdata('business_type');
        $companyCode = $this->session->userdata('company_code');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $branch_code = "";
        $cid = "";
        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        $this->db->select('shipmentid,shift_id');
        $this->db->from('tb_orders');
        if ($this->session->userdata('cust_id')) {
            $cid = $this->session->userdata('cust_id');
            $this->db->where('customer_id', $cid);
        } elseif ($btype == "Carrier") {
            $vid = $this->session->userdata('id');
            $this->db->where('vendor_id', $vid);
        } else {
            $branch_code = $this->session->userdata('branch_code');
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->where('trip_id >', 0);
        $this->db->where('trip_sts', 0);
        $query = $this->db->get();
        $result = $query->result_array();
        // log_message('error', 'Query: ' . $this->db->last_query());
        // log_message('error', 'BRAnch:' . json_encode([$companyCode, $branch_code, $cid]));
        // log_message('error', 'shifts:' . json_encode($result));

        $all_trips = [];
        $i = 0;
        foreach ($result as $id) {
            $i += 1;
            $shift_id = $id['shift_id'];
            if ($shift_id) {
                $sql = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,ts.comment,convertToClientTZ(ts.createdon,?) as createdon,e.address,e.order_id,e.pickup,e.drop,tsv.register_number,ts.driver_id
             FROM tb_stop_status ts 
             LEFT JOIN tb_status_master sm ON sm.id = ts.status_id 
             LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id = ts.stop_id OR e.drop_stopid = ts.stop_id)
             LEFT JOIN tb_shft_veh tsv on ts.shipment_id=tsv.shft_id 
             WHERE ts.shipment_id = ?
             GROUP BY ts.id 
             ORDER BY ts.createdon DESC
             LIMIT 1",
                    [$curtz, $shift_id]
                );
                $history = $sql->num_rows() > 0 ? $sql->result_array() : [];
                if (!empty($history)) {
                    $rt_data = [];
                    $query = $this->db->query("SELECT id FROM tb_trucks_data WHERE truck_number = ?", [$history[0]['register_number']]);
                    $row = $query->row();
                    if (isset($row->id)) {
                        $rt_q = $this->db->query(
                            "SELECT td.latitude, td.longitude, td.trailer_latitude, td.trailer_longitude, td.speed, td.battery, td.imei as mobileimei, td.trailer_imei as mobiletrailerimei, convertToClientTZ(td.receivedon, ?) as timestamp, td.fuel, td.bearing, td.azimuth, td.key_exist, td.inouts 
                             FROM tb_trucks_data td 
                             WHERE truck_number = ?",
                            [$curtz, $history[0]['register_number']]
                        );
                        $rt_data = $rt_q->row_array() ?? [];
                    }
                    $sql2 = $this->db->query("select name from tb_truck_drivers where id=?", [$history[0]['driver_id']]);
                    $row2 = $sql2->row_array();
                    $ships = $this->getShipingDetailByVeh($history[0]['driver_id']);
                    //$place = getLocationName($history[0]['latitude'] ?? '', $history[0]['longitude'] ?? '');
                    $next_stop = $this->db->query(
                        "SELECT stopname FROM tb_shiporder_stops WHERE shipment_id = ? ORDER BY ordernumber ASC",
                        [$shift_id]
                    )->row();

                    $trip_data = [
                        'shipmentid' => $id['shipmentid'],
                        'latitude'   => $history[0]['latitude'] ?? '',
                        'longitude'  => $history[0]['longitude'] ?? '',
                        'status'  => $history[0]['status_name'] ?? '',
                        'status_code' => $history[0]['status_code'] ?? '',
                        'register_number' => $history[0]['register_number'] ?? '',
                        'driver' => $row2,
                        'rt_data' => $rt_data,
                        'ships_data' => $ships,
                        'place' => '',
                        'next_stop' => $next_stop->stopname
                    ];
                    $all_trips[] = $trip_data;
                }
            }
        }
        log_message("error", 'no of shifts:' . $i);
        if ($all_trips) {
            // log_message("error", "branch:" . json_encode($all_trips));
            $this->session->set_userdata("onloadtrips", $all_trips);
            echo json_encode($all_trips);
        } else {
            log_message("error", "branch:" . json_encode($all_trips));
            echo json_encode(['is_valid' => false]);
        }
    }



    /*public function getCarrierData()
    {
        if ($custId = $this->session->userdata('cust_id')) {
            $carriers = $this->db
                ->distinct()
                ->select('v.id,v.name')
                ->from('tb_vendors v')
                ->join('tb_orders o', 'v.id = o.vendor_id')
                ->where('o.customer_id', $custId)
                ->get()
                ->result_array();
        } else {
            $companyCode = $this->session->userdata('company_code');
            $carriers = $this->db
                ->distinct()
                ->select('id,name')
                ->from('tb_vendors')
                ->where('company_code', $companyCode)
                ->get()
                ->result_array();
        }

        if (! empty($carriers)) {
            //log_message('error', 'vendors:' . json_encode($carriers));
            echo json_encode($carriers);
        } else {
            echo json_encode(['is_valid' => false]);
        }
    }*/



    /*public function allLoadTrips()
    {
        // log_message('error', 'shifts:' . json_encode($this->session->userdata()));
        $companyCode = $this->session->userdata('company_code');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $branch_code = "";
        $cid = "";
        $this->load->model('DashboardTripViewModel', 'dtvmodel');
        $this->db->select('shipmentid,shift_id');
        $this->db->from('tb_orders');
        if ($this->session->userdata('cust_id')) {
            $cid = $this->session->userdata('cust_id');
            $this->db->where('customer_id', $cid);
        } else {
            $branch_code = $this->session->userdata('branch_code');
            $this->db->where('branch_code', $branch_code);
        }
        $this->db->where('status', 2);
        $query = $this->db->get();
        $result = $query->result_array();

        // log_message('error', 'Query: ' . $this->db->last_query());
        // log_message('error', 'BRAnch:' . json_encode([$companyCode, $branch_code, $cid]));
        // log_message('error', 'shifts:' . json_encode($result));


        $all_trips = [];

        foreach ($result as $id) {
            $shift_id = $id['shift_id'];
            if ($shift_id) {
                $sql = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,ts.comment,convertToClientTZ(ts.createdon,?) as createdon,e.address,e.order_id,e.pickup,e.drop,tsv.register_number,ts.driver_id
             FROM tb_stop_status ts 
             LEFT JOIN tb_status_master sm ON sm.id = ts.status_id 
             LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id = ts.stop_id OR e.drop_stopid = ts.stop_id)
             LEFT JOIN tb_shft_veh tsv on ts.shipment_id=tsv.shft_id 
             WHERE ts.shipment_id = ?
             GROUP BY ts.id 
             ORDER BY ts.createdon DESC
             LIMIT 1",
                    [$curtz, $shift_id]
                );
                $history = $sql->num_rows() > 0 ? $sql->result_array() : [];

                if (!empty($history)) {
                    $rt_data = [];
                    $query = $this->db->query("SELECT id FROM tb_trucks_data WHERE truck_number = ?", [$history[0]['register_number']]);
                    $row = $query->row();
                    if (isset($row->id)) {
                        $rt_q = $this->db->query(
                            "SELECT td.latitude, td.longitude, td.trailer_latitude, td.trailer_longitude, td.speed, td.battery, td.imei as mobileimei, td.trailer_imei as mobiletrailerimei, convertToClientTZ(td.receivedon, ?) as timestamp, td.fuel, td.bearing, td.azimuth, td.key_exist, td.inouts 
                             FROM tb_trucks_data td 
                             WHERE truck_number = ?",
                            [$curtz, $history[0]['register_number']]
                        );
                        $rt_data = $rt_q->row_array() ?? [];
                    }
                    $sql2 = $this->db->query("select name from tb_truck_drivers where id=?", [$history[0]['driver_id']]);
                    $row2 = $sql2->row_array();

                    $ships = $this->getShipingDetailByVeh($history[0]['driver_id']);
                    //$place = getLocationName($history[0]['latitude'] ?? '', $history[0]['longitude'] ?? '');
                    $next_stop = $this->db->query(
                        "SELECT stopname FROM tb_shiporder_stops WHERE shipment_id = ? ORDER BY ordernumber ASC",
                        [$shift_id]
                    )->row();


                    $trip_data = [
                        'shipmentid' => $id['shipmentid'],
                        'latitude'   => $history[0]['latitude'] ?? '',
                        'longitude'  => $history[0]['longitude'] ?? '',
                        'status'  => $history[0]['status_name'] ?? '',
                        'status_code' => $history[0]['status_code'] ?? '',
                        'register_number' => $history[0]['register_number'] ?? '',
                        'driver' => $row2,
                        'rt_data' => $rt_data,
                        'ships_data' => $ships,
                        'place' => '',
                        'next_stop' => $next_stop->stopname
                    ];
                    $all_trips[] = $trip_data;
                }
            }
        }
        if ($all_trips) {
            // log_message("error", "branch:" . json_encode($all_trips));
            echo json_encode($all_trips);
        } else {
            //log_message("error", "branch:" . json_encode($all_trips));
            echo json_encode(['is_valid' => false]);
        }
    }*/

    function getShipingDetailByVeh($veh)
    {
        $ci = &get_instance();
        $ships = "";
        if ($veh != "") {
            if ($cid = $this->session->userdata('cust_id')) {
                $sql = $ci->db->query("select e.id,e.name,e.shipment_weight,e.shipment_volume,e.ship_type from tb_employee e,tb_trips t,tb_shft_veh sv where e.shift_id=t.shift_id and t.shift_id=sv.shft_id and t.vehicle_id=sv.vehicle_id AND t.driver_id=$veh and sv.status=1 AND e.customer_id=$cid GROUP BY t.driver_id ORDER BY t.id DESC");
                $ships = $sql->row();
            } else {
                $sql = $ci->db->query("select e.id,e.name,e.shipment_weight,e.shipment_volume,e.ship_type from tb_employee e,tb_trips t,tb_shft_veh sv where e.shift_id=t.shift_id and t.shift_id=sv.shft_id and t.vehicle_id=sv.vehicle_id AND t.driver_id=$veh and sv.status=1 GROUP BY t.driver_id ORDER BY t.id DESC");
                $ships = $sql->row();
            }
        }
        return $ships;
    }
}
