<?php

use App\Order\Models\OrderReference;

defined( 'BASEPATH' ) or exit( 'No direct script access allowed' );

class Shifts extends CI_Controller {
    private $_userId = null;

    /**
    * Class Constructor
    */

    public function __construct() {
        parent::__construct();

        // User Session Check
        if ( $this->session->userdata( 'user_id' ) == '' ) {
            redirect( 'login' );
        }
        $this->_userId = $this->session->userdata( 'user_id' );

        $this->load->helper( 'jwt' );
        $this->load->model( 'shifts_model' );
        $this->load->model( 'common' );
    }

    /**
    * Displays all active shifts
    */

    public function index() {
        try {
            $where = array();
            if ( $_POST ) {
                $where['shipmentid'] = $this->input->post( 'shipmentid' );
                $where['carrier_type'] = $this->input->post( 'carrier_type' );
                $where['startdate'] = $this->input->post( 'fromdate' );
                $where['todate'] = $this->input->post( 'todate' );
            }

            $userId = $this->session->userdata( 'user_id' );
            $data['shifts'] = $this->shifts_model->getShifts( $userId, $where );

            // Load View
            $this->newtemplate->dashboard( 'shifts/index', $data );
        } catch ( \Exception $ex ) {
            log_message( 'error', $ex->getMessage() );
        }
    }

    /**
    * This action displays shift details
    */

    public function editshift() {
        try {
            // Variables
            $userId = $this->session->userdata( 'user_id' );
            $shiftId = $this->uri->segment( 3 );
            $branchCode = $this->session->userdata( 'branch_code' );
            $companyCode = $this->session->userdata( 'company_code' );

            // Data for Views
            $data['page_title'] = 'Shipments';
            $data['sub_title'] = 'Edit Shipment';
            $data['shiftId'] = $shiftId;
            $data['branchCode'] = $branchCode;
            $data['companyCode'] = $companyCode;
            $data['details'] = $this->shifts_model->getShiftById( $shiftId, $userId );
            $data['shiftOrders'] = $this->shifts_model->getShiftOrders( $shiftId );

            $data['vendors'] = $this->shifts_model->getVendors( $userId );
            $data['vehicletypes'] = $this->shifts_model->getVehicleTypes( $userId );
            $data['trucks'] = $this->shifts_model->getTrucksData( $userId );
            $data['truckdrivers'] = $this->shifts_model->getTruckDrivers( $userId );
            $data['shiftvehicles'] = $this->shifts_model->getShiftVehicles( $shiftId, $userId );
            $data['shiftdrivers'] = [];
            if ( isset( $data['shiftvehicles']['vehicle_id'] ) ) {
                $data['shiftdrivers'] = $this->shifts_model->getShiftAssignedDrivers( $userId, $data['shiftvehicles']['vehicle_id'] );
            }
            $data['departments'] = $this->shifts_model->getDepartments();
            // $data['documents'] = $this->shifts_model->getShiftDocuments( $shiftId );

            // load view
            $this->newtemplate->dashboard( 'shifts/editshift', $data );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    public function getnoshiporders() {
        try {
            $orders_info = $orders = array();
            $limit = $start = 0;
            if ( $this->_userId != '0' ) {
                $where = array( 'status' => '1', 'shift_id' => '0', 'trip_id' => '0' );
                $table = 'tb_orders';
                $select = 'id,order_id,pickup_company,delivery_company,quantity,weight,volume,transport_mode,';
                $orders_info = $this->common->gettbldata( $where, $select, $table, $limit, $start );
            }
            if ( !empty( $orders_info ) ) {
                foreach ( $orders_info as $res ) {
                    $checkbox = "<input type='checkbox' class='noshift_list' name='noshift_list[]' value='" . $res['id'] . "' id='noshift_" . $res['id'] . "'>";
                    $orders[] = array( 'checkbox' => $checkbox, 'id' => $res['id'], 'order_id' => $res['order_id'], 'pickup_company' => $res['pickup_company'], 'delivery_company' => $res['delivery_company'], 'quantity' => $res['quantity'], 'weight' => $res['weight'], 'volume' => $res['volume'], 'transport_mode' => $res['transport_mode'] );
                }
            }
            echo json_encode( $orders );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    /**
    * Fetches Order Details by Order Id
    */

    public function getorderdetailsbyid() {
        try {
            $order_id = isset( $_POST['order_id'] ) ? $_POST['order_id'] : '';
            $data['orders'] = $data['legs'] = array();
            if ( $order_id != '' ) {
                $getid = $this->common->gettblrowdata( array( 'id' => $order_id ), 'order_id, pickup_datetime,delivery_datetime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,shift_id', 'tb_orders', 0, 0 );

                if ( !empty( $getid ) ) {
                    $shift_id = $getid['shift_id'];
                    if ( $shift_id != '0' && $shift_id != '' ) {
                        $select = 'id,pickup,drop,pickup_city,drop_city,stop_order,plat,plng,dlat,dlng';
                        $where = array( 'shift_id' => $shift_id, 'order_id' => $getid['order_id'] );
                        $tbemployee = $this->common->gettbldata( $where, $select, 'tb_employee', 0, 0 );

                        if ( !empty( $tbemployee ) ) {
                            foreach ( $tbemployee as $row ) {
                                $data['legs'] = array( 'id' => $row['id'], 'pickup' => getLocationName($row['plat'], $row['plng']), 'drop' => getLocationName($row['dlat'], $row['dlng']), 'pickup_city' => $row['pickup_city'], 'drop_city' => $row['drop_city'], 'stop_order' => $row['stop_order'] );
                            }
                        }
                    }
                    $data['orders'] = array( 'pname' => $getid['pickup_company'], 'dname' => $getid['delivery_company'], 'pcountry' => $getid['pickup_country'], 'dcountry' => $getid['delivery_country'], 'pcity' => $getid['pickup_city'], 'dcity' => $getid['delivery_city'], 'ppincode' => $getid['pickup_pincode'], 'dpincode' => $getid['delivery_pincode'], 'pstreet' => $getid['pickup_address1'], 'pstate' => $getid['pickup_address2'], 'dstreet' => $getid['delivery_address1'], 'dstate' => $getid['delivery_address2'] );
                }
            }
            echo json_encode( $data );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    /**
    * This method updates shift
    * @noparam
    */

    public function update() {
        try {
            $shiftId = $this->input->post( 'shiftId' );
            $update['carrier_type'] = $this->input->post( 'carrier_type' );
            $update['border_type'] = $this->input->post( 'border_type' );
            $update['vendor_id'] = $this->input->post( 'vendor_id' );
            $update['company_code'] = $this->input->post( 'company_code' );
            $update['vehicle_type'] = $this->input->post( 'vehicle_type' );
            $update['branch_code'] = $this->input->post( 'branch_code' );
            // $update['department_code'] = $this->input->post( 'department_code' );
            $update['startdate'] = $this->input->post( 'startdate' );
            $update['enddate'] = $this->input->post( 'enddate' );
            $update['updated_on'] = date( 'Y-m-d H:i:s' );

            // Update Shifts
            $this->shifts_model->updateShift( $shiftId, $update );

            // Update Shift Vehicle
            $updateVeh['vehicle_id'] = $this->input->post( 'vehicle_id' );
            $this->shifts_model->updateShiftVeh( $shiftId, $updateVeh );
            //            $updateDr['driver_id'] = $this->input->post( 'driver' );
            //            $this->shifts_model->updateDriver();

            echo json_encode( array( 'status' => '1', 'shipment_id' => $shiftId ) );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    /**
    * Soft Delete Shift
    */

    public function delete() {
        try {
            $shiftId = $this->uri->segment( 3 );
            $data['status'] = 0;
            $curdt = date( 'Y-m-d H:i:s' );
            $params = array( 'status' => 0, 'updated_on' => $curdt );
            $update = $this->shifts_model->updatedata( 'tb_shifts', $shiftId, $params );
            if ( $update ) {
                $data['status'] = 1;
            }

            echo json_encode( $data );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    /**
    * Adds new order( s )
    */

    public function addorders() {
        try {
            $ids = $this->input->post( 'orderids' );
            $shiftId = $this->input->post( 'shift_id' );

            $orderIds = explode( ',', $ids );
            $response = $this->shifts_model->addOrder( $orderIds, $shiftId );

            if ( $response ) {
                $data['status'] = 1;
            }
            echo json_encode( $data );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    /**
    * Deletes an Order
    */

    public function deleteOrder() {
        try {
            $orderId = $this->input->post( 'order_id' );
            $shiftId = $this->input->post( 'shift_id' );

            $update = $this->shifts_model->updateOrder( $orderId, $shiftId );

            if ( $update ) {
                $refs = new OrderReference();
                $refs->deleteForOrder($orderId, ['DQ']);

                $data['status'] = 1;
            }

            echo json_encode( $data );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    /**
    * This method fetches Order Documents
    */

    public function orddocsdetails() {
        try {
            $status = array();
            $shiftId = $this->input->post( 'shift_id' );

            $ordersIds = $this->shifts_model->getOrdersByShiftId( $this->_userId, $shiftId );
            foreach ( $ordersIds as $order_id ) {
                $curtz = $this->session->userdata( 'usr_tzone' )['timezone'];
                $sql1 = $this->db->query( "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.order_id = $order_id AND ts.status='1' GROUP BY ts.id" );
                if ( $sql1->num_rows() > 0 ) {
                    foreach ( $sql1->result() as $res ) {
                        $location_name = getLocationName( $res->latitude, $res->longitude );
                        if ( $res->imgpath != '' ) {
                            $base64DocumentData = getBase64DocumentData($res->imgpath);
                            $extention = $base64DocumentData['extention'];
                            $stringData = "'" . $base64DocumentData['file_content'] . "'," . "'" . $extention . "'";
                            if ($extention != "") {
                                if (in_array($extention, ['pdf'])) {
                                    $path = '<a onclick="return downloadDocument(' . $stringData . ')"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                                } else {
                                    $path = '<a onclick="return downloadDocument(' . $stringData . ')"><img src="' . $base64DocumentData['file_content'] . '" class="img-responsive" style="width: 10%;"></a>';
                                }
                            } else {
                                $path = 'N/A';
                            }
                            $driver = getDrivernameById( $res->createdby )['name'];
                            $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' style='left: 0 !important;' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowdocAdd(this," . $shiftId . ");'><span class='glyphicon glyphicon-plus' > </span>Add Doc</a></li></li></ul>";
                            $status[] = array( 'id' => $res->id, 'type_name' => $res->type_name, 'imgpath' => $path, 'stop_id' => $res->stop_id, 'stop_type' => $res->stop_type, 'date' => date( 'd M,y h:i A', strtotime( $res->createdon ) ), 'action' => $action, 'location' => $location_name, 'driver' => $driver );
                        }
                    }
                }
            }
            echo json_encode( $status );
        } catch ( \Exception $e ) {
            echo $e->getMessage();
        }
    }

    public function addorderdoc() {
        $shiftId = isset( $_POST['shift_id'] ) ? $_POST['shift_id'] : '0';
        $data['stops'] = $data['document_types'] = array();
        $data['booking_id'] = $data['shift_id'] = $data['trip_id'] = $booking_id = 0;
        $data['company_code'] = $data['branch_code'] = '';

        $ordersIds = $this->shifts_model->getOrdersByShiftId( $this->_userId, $shiftId );
        $data['orders'] = $ordersIds;
        foreach ( $ordersIds as $order_id ) {
            $ord = $order_id;
            $getorderdetails = $this->db->select( 'id,order_id,company_code,branch_code,shift_id,trip_id' )->get_where( 'tb_orders', array( 'id' => $order_id ) );
            if ( $getorderdetails->num_rows() > 0 ) {

                $data['order_row_id'] = $getorderdetails->row()->id;
                $data['booking_id'] = $booking_id = $getorderdetails->row()->order_id;
                $data['company_code'] = $getorderdetails->row()->company_code;
                $data['branch_code'] = $getorderdetails->row()->branch_code;
                $data['shift_id'] = $getorderdetails->row()->shift_id;
                $data['trip_id'] = $getorderdetails->row()->trip_id;
            }
            $sql = "SELECT o.id,o.stopname FROM tb_shiporder_stops o,tb_employee e WHERE o.shipment_id=e.shift_id AND e.order_id='" . $booking_id . "' AND o.status=1 AND e.status=1 AND o.stoptype='D' ORDER BY o.ordernumber ASC";
            $stops = $this->db->query( $sql );
            if ( $stops->num_rows() > 0 ) {
                $data['stops'] = $stops->result_array();
                $data['document_types'] = $this->db->select( 'id,type_name' )->get_where( 'tb_document_types', array( 'status' => 1 ) )->result_array();
            } else {
                $data['document_types'] = $this->db->select( 'id,type_name' )->get_where( 'tb_document_types', array( 'status' => 1, 'type_name' => 'Others' ) )->result_array();
            }
        }

        echo json_encode( $data );
    }

    /**
    * Displays Order( s ) Cost Details Per Shift
    */

    public function getCostDetailsByShiftId() {
        $shiftId = $this->input->post( 'shift_id' );
        $cost_ids = $this->input->post( 'cost_ids' );
        $costs    = array();

        $ordersIds = $this->shifts_model->getOrdersByShiftId( $this->_userId, $shiftId );

        // Loop through Order Ids
        foreach ( $ordersIds as $order_id ) {
            $revenue = $this->common->gettbldata( array( 'order_id' => $order_id, 'status' => 1, 'type' => '1' ), '*', 'tb_reveneus', 0, 0 );
            // Loop Over $revenue
            if ( !empty( $revenue ) ) {
                foreach ( $revenue as $row ) {

                }
            }
        }
		echo json_encode($costs);
    }

	/**
	 * Display's Cost Details Add Form
	 */
	public function addCostDetail(){
		try{
			$details = array();
			$shiftId = $this->input->post( 'shift_id' );
			$ordersIds = $this->shifts_model->getOrdersByShiftId( $this->_userId, $shiftId );

			$details['orders'] = $ordersIds;
			$details['shift_id'] = $shiftId;

			echo json_encode($details);
		}catch(\Exception $e){
			echo $e->getMessage();
		}
	}
}
