<?php if (! defined('BASEPATH')) {exit('No direct script access allowed');}

class Shipmentplan extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['common', 'shippeomodel', 'ShipmentPlanningModel', 'DeliveryDocumentModel','frieghttrack']);
        $this->load->library(['ratemanagement', 'TripChargesRecalculation', 'newjfrlogic_sgmy', 'shippeostatusintigration', 'sendfirebase']);
        if (! checkUrlAccessForUser('SHIPMENTPLAN')) {
            redirect("Forbiddenaccess");
        }
    }

    public function new_view()
    {
        $data["page_title"] = $data['sub_title'] = $this->lang->line('shipment_plan');
        $uid                = $this->session->userdata("user_id");
        $company_code       = $this->session->userdata('company_code');
        $permission         = checkuserpermissions();
        if (in_array("trips", $permission)) {
            $data["customers"] = $this->db->select("id,name")->where(["status" => "1", "company_code" => $company_code])->get("tb_customers");
        } else {
            $data["customers"] = $this->db->select("id,name")->where(["status" => "1", "user_id" => $uid])->get("tb_customers");
        }
        $this->settemplate->dashboard("shipments/planview_new", $data);
    }
    public function index()
    {
        $data["page_title"] = $data['sub_title'] = "Trip Planning";
        $userId             = $this->session->userdata("user_id");
        $permission         = checkuserpermissions();
        if (in_array("trips", $permission)) {
            $company_code      = $this->session->userdata('company_code');
            $data["customers"] = $this->db->select("id,name")->where(["status" => "1", "company_code" => $company_code])->get("tb_customers");
            $data["carriers"]  = $this->db->query("SELECT v.id, v.name,v.code FROM tb_vendors as v JOIN tbl_party_master as pm ON (pm.code=v.code  and v.code IS NOT NULL and  pm.company_code=v.company_code) where pm.status=1 and v.status=1 and  v.company_code='" . $company_code . "' ORDER BY v.name asc ");
        } else {
            $data["customers"] = $this->db->select("id,name")->where(["status" => "1", "user_id" => $userId])->get("tb_customers");
            $data["carriers"]  = $this->db->query("SELECT v.id, v.name, v.code FROM tb_vendors as v JOIN tbl_party_master as pm ON (pm.code=v.code  and v.code IS NOT NULL and  pm.user_id=v.user_id) where pm.status=1 and v.status=1 and  v.user_id='" . $userId . "' ORDER BY v.name asc ");
        }
        $this->settemplate->dashboard("shipments/planview_new", $data);
    }
    public function filterOrders()
    {
        //log_message("errpr","Request:".json_encode($_POST));
        $customer_id = isset($_POST["customer_id"]) ? $_POST["customer_id"] : "";
        $shipmentid  = isset($_POST["shipmentid"]) ? $_POST["shipmentid"] : "";
        $orderid     = isset($_POST["orderid"]) ? $_POST["orderid"] : "";
        $range       = isset($_POST["range"]) ? $_POST["range"] : "";
        if (strlen($range) > 0) {
            $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : "";
            $orders      = $this->filterOrdersByCustomers();
            if (strlen($shipment_id) > 0) {
                $shipment = $this->db->select("slat,slng,elat,elng")->where(["id" => $shipment_id])->get("tb_shifts")->row();
                $stops    = $this->db->select("plat,plng")->order_by("ordernumber", "ASC")->where(["shipment_id" => $shipment_id, "status" => "1"])->get("tb_shiporder_stops");
                $pos      = [];
                if ($stops->num_rows() > 0) {
                    foreach ($stops->result() as $row) {
                        $pos[] = [$row->plat, $row->plng];
                    }
                }
                if (count($pos) == 0) {
                    $pos[] = [$shipment->slat, $shipment->slng];
                    $pos[] = [$shipment->elat, $shipment->elng];
                }
                foreach ($orders as $index => $order) {
                    $check = false;
                    foreach ($pos as $po) {
                        if (distance($order["plat"], $order["plng"], $po[0], $po[1]) <= $range) {
                            $check = true;
                        }
                        if ($check) {
                            break;
                        }

                    }
                    if (! $check) {
                        foreach ($pos as $po) {
                            if (distance($order["dlat"], $order["dlng"], $po[0], $po[1]) <= $range) {
                                $check = true;
                            }
                            if ($check) {
                                break;
                            }

                        }
                        if (! $check) {
                            unset($orders[$index]);
                        }
                    }
                }
            }
            //log_message("errpr","Response:".json_encode($orders));
            echo json_encode($orders);
        } else if (strlen($shipmentid) > 0) {
            $custid = "";
            $orders = $this->filterOrdersByCustomers($custid, $shipmentid);
            echo json_encode($orders);
        } else if (strlen($orderid) > 0) {
            $custid = "";
            $orders = $this->filterOrdersByCustomers($custid, $shipmentid, $orderid);
            echo json_encode($orders);
        } else {
            $orders = $this->filterOrdersByCustomers($customer_id);
            echo json_encode($orders);
        }
    }
    
    public function filterOrdersByCustomers($customer_id = '', $shipmentid = '', $orderid = '')
    {
        $table      = "tb_orders s";
        $table1     = "tb_shifts ts";
        $table2     = "tb_customers c";
        $uid        = $this->session->userdata("user_id");
        $curtz      = $this->session->userdata("usr_tzone")['timezone'];
        $limit      = 100;
        $start      = 0;
        $where      = [];
        $permission = checkuserpermissions();
        if (in_array("trips", $permission)) {
            $company_code = $this->session->userdata('company_code');
            if (strlen($customer_id) > 0) {
                $where = ["s.status" => 1, "s.company_code" => $company_code, "c.id" => $customer_id, "s.trip_sts" => 0];
            } else if (strlen($shipmentid) > 0) {
                $where = ["s.company_code" => $company_code, "ts.shipmentid" => $shipmentid, "s.status !=" => 0];
            } else if (strlen($orderid) > 0) {
                $where = ["s.company_code" => $company_code, "s.order_id" => $orderid, "s.trip_sts" => 0, "s.status" => 1];
            } else {
                $where = ["s.status" => 1, "s.company_code" => $company_code, "s.trip_sts" => 0];
            }
        } else {
            if (strlen($customer_id) > 0) {
                $where = ["s.status" => 1, "s.user_id" => $uid, "c.id" => $customer_id, "s.trip_sts" => 0];
            } else if (strlen($shipmentid) > 0) {
                $where = ["s.user_id" => $uid, "ts.shipmentid" => $shipmentid, "s.status !=" => 0];
            } else if (strlen($orderid) > 0) {
                $where = ["s.user_id" => $uid, "s.order_id" => $orderid, "s.trip_sts" => 0, "s.status" => 1];
            } else {
                $where = ["s.status !=" => 0, "s.user_id" => $uid, " ( s.shipmentid is null OR ts.shipmentid ='0') AND s.trip_id = " => 0, "(SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=s.order_id) = " => 0];
            }
        }
        
        $legs_count = $this->db
            ->from('tb_shifts ts')
            ->where("
                IF(
                    INSTR(ts.shipmentid, '-') > 0,
                    SUBSTRING_INDEX(ts.shipmentid, '-', 1),
                    ts.shipmentid
                ) LIKE CONCAT(
                    IF(
                        INSTR('".$shipmentid."', '-') > 0,
                        SUBSTRING_INDEX('".$shipmentid."', '-', 1),
                        '".$shipmentid."'
                    ), '%'
                )
            ", NULL, FALSE)
            ->count_all_results();

            
        /*log_message("error","legs_count_qry:".$this->db->last_query());
        
        log_message("error","legs_count:".$legs_count);*/
        
        if ($legs_count > 1) {
            $this->db->select("s.id, ts.slat as plat, ts.slng as plng, ts.elat as dlat, ts.elng as dlng, s.order_id, 
                   ts.splace as pickup_city, ts.eplace as delivery_city,
                   convertToClientTZ(ts.startdate, 'Asia/Kolkata') AS pickup_datetime,
                   convertToClientTZ(ts.enddate, 'Asia/Kolkata') AS delivery_datetime,
                   s.quantity, s.weight, s.volume, s.transport_mode, 
                   s.shift_id, s.order_status, c.name");
        } else {
            $this->db->select("s.id, s.plat,s.plng,s.dlat,s.dlng,s.order_id,s.pickup_city,s.delivery_city,convertToClientTZ(s.pickup_datetime,'" . $curtz . "') as pickup_datetime,convertToClientTZ(s.delivery_datetime,'" . $curtz . "') as delivery_datetime,
                   s.quantity, s.weight, s.volume, s.transport_mode, 
                   s.shift_id, s.order_status, c.name");
        }

        
        $this->db->from('tb_orders s');
        $this->db->join('tb_shifts ts', "s.shipmentid = IF(INSTR(ts.shipmentid,'-')>0,SUBSTRING_INDEX(ts.shipmentid,'-',1),ts.shipmentid)", 'inner');
        $this->db->join('tb_customers c', 's.customer_id = c.id', 'left');
        
        // Correct way to pass variables
        $this->db->where('s.user_id', $uid);
        $this->db->where('ts.shipmentid', $shipmentid);
        $this->db->where('s.status !=', 0);
        
        $this->db->order_by('pickup_datetime', 'DESC');
        $this->db->limit(100);
        
        $res = $this->db->get();
        
        if ($res && $res->num_rows() > 0) {
            $orders = $res->result_array();
        } else {
            $orders = array();
        }

        return $orders;
    }
   
    /*public function filterOrdersByCustomers($customer_id = '', $shipmentid = '', $orderid = '')
    {
        $table      = "tb_orders s";
        $table2     = "tb_customers c";
        $uid        = $this->session->userdata("user_id");
        $curtz      = $this->session->userdata("usr_tzone")['timezone'];
        $limit      = 100;
        $start      = 0;
        $where      = [];
        $permission = checkuserpermissions();
        if (in_array("trips", $permission)) {
            $company_code = $this->session->userdata('company_code');
            if (strlen($customer_id) > 0) {
                $where = ["s.status" => 1, "s.company_code" => $company_code, "c.id" => $customer_id, "s.trip_sts" => 0];
            } else if (strlen($shipmentid) > 0) {
                $where = ["s.company_code" => $company_code, "s.shipmentid" => $shipmentid, "s.status !=" => 0];
            } else if (strlen($orderid) > 0) {
                $where = ["s.company_code" => $company_code, "s.order_id" => $orderid, "s.trip_sts" => 0, "s.status" => 1];
            } else {
                $where = ["s.status" => 1, "s.company_code" => $company_code, "s.trip_sts" => 0];
            }
        } else {
            if (strlen($customer_id) > 0) {
                $where = ["s.status" => 1, "s.user_id" => $uid, "c.id" => $customer_id, "s.trip_sts" => 0];
            } else if (strlen($shipmentid) > 0) {
                $where = ["s.user_id" => $uid, "s.shipmentid" => $shipmentid, "s.status !=" => 0];
            } else if (strlen($orderid) > 0) {
                $where = ["s.user_id" => $uid, "s.order_id" => $orderid, "s.trip_sts" => 0, "s.status" => 1];
            } else {
                $where = ["s.status !=" => 0, "s.user_id" => $uid, " ( s.shipmentid is null OR s.shipmentid ='0') AND s.trip_id = " => 0, "(SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=s.order_id) = " => 0];
            }
        }
        $select = "s.id,s.plat,s.plng,s.dlat,s.dlng,s.order_id,s.pickup_city,s.delivery_city,convertToClientTZ(s.pickup_datetime,'" . $curtz . "') as pickup_datetime,convertToClientTZ(s.delivery_datetime,'" . $curtz . "') as delivery_datetime, s.quantity,s.weight,s.volume,s.transport_mode,s.shift_id,s.order_status,c.name";
        $orders = $this->common->getordertbldata($table, $table2, $where, $select, $limit, $start);
        log_message("error","query:".$this->db->last_query());
        log_message("errpr","Response111:".json_encode($orders));
        return $orders;
    }*/
    
    public function filterShipments()
    {
        $customer_id = isset($_POST["customer_id"]) ? $_POST["customer_id"] : "";
        $vendor_id   = isset($_POST["vendor_id"]) ? $_POST["vendor_id"] : "";
        $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : "";
        $range       = isset($_POST["range"]) ? $_POST["range"] : "";
        if (strlen($range) > 0) {
            $order_id  = isset($_POST["order_id"]) ? $_POST["order_id"] : "";
            $shipments = $this->filterShipmentsByCustomer($customer_id);
            if (strlen($order_id) > 0) {
                $order = $this->db->select("plat,plng,dlat,dlng")->where(["id" => $order_id])->get("tb_orders")->row();
                $pos   = [];
                $pos[] = [$order->plat, $order->plng];
                $pos[] = [$order->dlat, $order->dlng];
                foreach ($shipments as $index => $shipment) {
                    $check = 0;
                    if ($shipment["slat"] != "" && $shipment["slng"] != "") {
                        foreach ($pos as $po) {
                            if ($po[0] != "" && $po[1] != "") {
                                $dist = distance($shipment["slat"], $shipment["slng"], $po[0], $po[1]);
                                if ($dist <= $range) {
                                    $check = 1;
                                }
                            }
                        }
                    }
                    if ($check == 0) {
                        if ($shipment["elat"] != "" && $shipment["elng"] != "") {
                            foreach ($pos as $po) {
                                if ($po[0] != "" && $po[1] != "") {
                                    $dist = distance($shipment["elat"], $shipment["elng"], $po[0], $po[1]);
                                    if ($dist <= $range) {
                                        $check = 1;
                                        //log_message("error", "range dest " . $dist . "-" . $shipment['id']);
                                    }
                                }
                            }
                        }
                    }
                    if ($check == 0) {
                        unset($shipments[$index]);
                    }
                }
            }
            //log_message("error","Shipments111:".json_encode($shipments));
            echo json_encode($shipments);
        } else {
            $shipments = $this->filterShipmentsByCustomer($customer_id, $vendor_id, $shipment_id);
            //log_message("error","Shipments:".json_encode($shipments));
            echo json_encode($shipments);
        }
    }

    private function filterShipmentsByCustomer($customerId = '', $vendorId = '', $shipmentId = ''): array
    {
        $uid         = $this->session->userdata('user_id');
        $curtz       = $this->session->userdata('usr_tzone')['timezone'];
        $permissions = checkuserpermissions() ?? [];
        $companyCode = $this->session->userdata('company_code') ?? '';

        $shipments = $this->ShipmentPlanningModel->getShipments($customerId, $vendorId, $shipmentId, $uid, $companyCode, $permissions, $curtz);
        //log_message("error","shipments:".json_encode($shipments));
        foreach ($shipments as $key => $shipment) {
            $cust_id = $shipment['id'];
            if ($cust_id != 0) {
                $shfth = $this->common->gettblrowdata(['shft_id' => $cust_id], 'id', 'tb_shft_veh_history', 0, 0);
                if (count($shfth) > 0) {
                    $shftvehhistory = $this->common->chkShftvehhistory($cust_id, $uid);
                    if (count($shftvehhistory) > 0) {
                        $shipment['drivername'] = $shftvehhistory['name'];
                        $shipments[$key]        = $shipment;
                    }
                }
            }
        }

        return $shipments;
    }

    public function filterIntransitShipments()
    {
        $customer_id = isset($_POST["customer_id"]) ? $_POST["customer_id"] : "";
        $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : "";
        $range       = isset($_POST["range"]) ? $_POST["range"] : "";
        if (strlen($range) > 0) {
            $order_id  = isset($_POST["order_id"]) ? $_POST["order_id"] : "";
            $shipments = $this->filterIntransitShipmentsByCustomer();
            if (strlen($order_id) > 0) {
                $order = $this->db->select('plat,plng,dlat,dlng')->where(["id" => $order_id])->get("tb_orders")->row();
                $pos   = [];
                $pos[] = [$order->plat, $order->plng];
                $pos[] = [$order->dlat, $order->dlng];
                foreach ($shipments as $index => $shipment) {
                    $check = 0;
                    if ($shipment["slat"] != "" && $shipment["slng"] != "") {
                        foreach ($pos as $po) {
                            if ($po[0] != "" && $po[1] != "") {
                                $dist = distance($shipment["slat"], $shipment["slng"], $po[0], $po[1]);
                                if ($dist <= $range) {
                                    $check = 1;
                                }
                            }
                        }
                    }
                    if ($check == 0) {
                        if ($shipment["elat"] != "" && $shipment["elng"] != "") {
                            foreach ($pos as $po) {
                                if ($po[0] != "" && $po[1] != "") {
                                    $dist = distance($shipment["elat"], $shipment["elng"], $po[0], $po[1]);
                                    if ($dist <= $range) {
                                        $check = 1;
                                    }
                                }
                            }
                        }
                    }
                    if ($check == 0) {
                        unset($shipments[$index]);
                    }
                }
            }
            echo json_encode($shipments);
        } else if (strlen($shipment_id) > 0) {
            $shipments = $this->filterIntransitShipmentsByCustomer($customer_id, $shipment_id);
            echo json_encode($shipments);
        } else {
            $shipments = $this->filterIntransitShipmentsByCustomer($customer_id);
            echo json_encode($shipments);
        }
    }
    
    public function filterIntransitShipmentsByCustomer($customer_id = '', $shipment_id = '')
    {
        $table      = "tb_shifts s";
        $table2     = "tb_customers c";
        $uid        = $this->session->userdata("user_id");
        $limit      = 100;
        $start      = 0;
        $where      = [];
        $permission = checkuserpermissions();
        if (in_array("trips", $permission)) {
            $company_code = $this->session->userdata('company_code');
            if (strlen($customer_id) > 0) {
                $where = ["s.status" => 1, "v.status" => 1, "s.company_code" => $company_code, "c.id" => $customer_id];
            } else if (strlen($shipment_id) > 0) {
                $where = ["s.status" => 1, "v.status" => 1, "s.company_code" => $company_code, "s.shipmentid" => $shipment_id];
            } else {
                $where = ["s.status" => 1, "v.status" => 1, "s.company_code" => $company_code];
            }
        } else {
            if (strlen($customer_id) > 0) {
                $where = ["s.status" => 1, "v.status" => 1, "s.user_id" => $uid, "c.id" => $customer_id];
            } else if (strlen($shipment_id) > 0) {
                $where = ["s.status" => 1, "v.status" => 1, "s.user_id" => $uid, "s.shipmentid" => $shipment_id];
            } else {
                $where = ["s.status" => 1, "v.status" => 1, "s.user_id" => $uid];
            }
        }

        $curtz     = $this->session->userdata("usr_tzone")['timezone'];
        $select    = "s.id,s.splace,s.slat,s.slng,s.eplace,s.elat,s.elng,convertToClientTZ(s.startdate,'" . $curtz . "') as startdate,convertToClientTZ(s.enddate,'" . $curtz . "') as enddate, s.shipmentid,s.transport_mode,s.txnid,s.weight,s.volume,s.units,s.domainname,s.vehicle_type,c.name,v.register_number,td.name as drivername";
        $shipments = $this->common->getintransitshipmenttbldata($table, $table2, $where, $select, $limit, $start);
        foreach ($shipments as $i => $shipment) {
            $capacity             = getOccupancy($shipment['id']);
            $shipment["capacity"] = $capacity;
            $shipments[$i]        = $shipment;
            if ($shipment['id'] != 0) {
                $shfth = $this->common->gettblrowdata(['shft_id' => $shipment['id']], 'id', 'tb_shft_veh_history', 0, 0);
                if (count($shfth) > 0) {
                    $shftvehhistory = $this->common->chkShftvehhistory($shipment['id'], $uid);
                    if (count($shftvehhistory) > 0) {
                        $shipment['drivername'] = $shftvehhistory['name'];
                        $shipments[$i]          = $shipment;
                    }
                }
            }
        }
        return $shipments;
    }
    
    public function linesintoshipment()
    {
        $userid       = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        $input        = $this->input->post();
        $curtz        = $this->session->userdata("usr_tzone")['timezone'];
        $logdate      = date('Y-m-d H:i:s');
        $getactual    = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt        = $getactual['datetime'];
        if ($input['ship_id'] > 0 && $input['ordid'] > 0 && count($input["lines"]) > 0) {
            $where  = ["id" => $input['ordid']];
            $select = "*";
            $table  = "tb_orders";
            $order  = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($order) > 0) {
                /*$shift_idchk = $order['shift_id'];
				if($shift_idchk == 0){*/
                $associd = time();
                $pickup  = $order['pickup_address1'];
                if ($pickup == "") {$pickup = $order['pickup_city'];}
                $delivery = $order['delivery_address1'];
                if ($delivery == "") {$delivery = $order['delivery_city'];}
                $address = $dropaddr = "";
                if ($order['pickup_address1'] != "") {
                    $address .= $order['pickup_address1'];
                    $dropaddr .= $order['delivery_address1'];
                }
                if ($order['pickup_company'] != "") {
                    $address .= ", " . $order['pickup_company'];
                    $dropaddr .= ", " . $order['delivery_company'];
                }
                if ($order['pickup_country'] != "") {
                    $address .= ", " . $order['pickup_country'];
                    $dropaddr .= ", " . $order['delivery_country'];
                }
                if ($order['pickup_city'] != "") {
                    $address .= ", " . $order['pickup_city'];
                    $dropaddr .= ", " . $order['delivery_city'];
                }
                if ($order['pickup_pincode'] != "") {
                    $address .= ", " . $order['pickup_pincode'];
                    $dropaddr .= ", " . $order['delivery_pincode'];
                }
                $plat      = $order['plat'];
                $plng      = $order['plng'];
                $dlat      = $order['dlat'];
                $dlng      = $order['dlng'];
                $sid       = $input["ordid"];
                $lines     = $input["lines"];
                $vendor_id = $order['vendor_id'];
                $where     = ["id" => $input['ship_id']];
                $select    = "id,splace,slat,slng,eplace,elat,elng,vendor_id,shipmentid,weight,volume,units";
                $table     = "tb_shifts";
                $shipment  = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if ($vendor_id == 0) {
                    if (count($shipment) > 0) {
                        $vendor_id = $shipment['vendor_id'];
                        $updwhr1   = ['id' => $input['ordid']];
                        $setwhr1   = ['vendor_id' => $vendor_id, "shift_id" => $input['ship_id'], "shipmentid" => $shipment['shipmentid']];
                        $ins       = $this->db->where($updwhr1)->update("tb_orders", $setwhr1);
                        $this->sendnotify('trip_create', $input['ordid']);
                        $info = ['ordid' => $input['ordid'], 'carrierid' => $vendor_id];
                        $this->ratemanagement->addrecodfortripinsertion($info);
                    }
                } else {
                    $setarr1['shift_id'] = $input['ship_id'];
                    if (count($shipment) > 0) {
                        $setarr1['shipmentid'] = $shipment['shipmentid'];
                    }
                    $setwhr1 = ['id' => $input['ordid']];
                    $ins     = $this->db->where($setwhr1)->update("tb_orders", $setarr1);
                    $this->sendnotify('trip_create', $input['ordid']);
                    $info = ['ordid' => $input['ordid'], 'carrierid' => $vendor_id];
                    $this->ratemanagement->addrecodfortripinsertion($info);
                }
                $invtypes        = makeorderinvolvedpartiestype($vendor_id, $input['ordid'], "CARRIER", $userid, $company_code);
                $stops_units     = $this->db->query("SELECT oc.id,oc.handling_unit,oc.length,oc.width,oc.height,oc.weight,oc.quantity,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.id in ('" . implode("','", $lines) . "') AND im.id = oc.handling_unit AND oc.status='1'");
                $act_stops_units = $this->db->query("SELECT oc.id,oc.length,oc.width,oc.height,oc.weight,oc.quantity,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id='$sid' AND im.id = oc.handling_unit AND oc.status='1'");
                $totalcargos     = $act_stops_units->num_rows();
                if ($stops_units->num_rows() == 0) {
                    /*create one*/
                    $cargoarr = ['order_id' => $sid, 'cargo_id' => 0, 'handling_unit' => 1, 'length' => 1.00, 'width' => 1.00, 'height' => 1.00, 'weight' => $order['weight'], 'volume' => $order['volume'], 'quantity' => $order['quantity'], 'quantity_type' => 'PKG', 'cargo_content' => 'Goods', 'status' => 1, 'createdon' => $curdt];
                    $newline  = $this->common->insertTableData("tb_order_cargodetails", $cargoarr);
                    array_push($lines, $newline);
                    $stops_units = $this->db->query("SELECT oc.id,oc.length,oc.width,oc.height,oc.weight,oc.quantity,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.id in ('" . implode("','", $lines) . "') AND im.id = oc.handling_unit AND oc.status='1'");
                }
                foreach ($stops_units->result() as $unit) {
                    $vol       = @(($unit->height * $unit->width * $unit->length) * $unit->quantity);
                    $insarr    = ['assoc_id' => $associd, 'pickup' => $pickup, 'plat' => $plat, 'plng' => $plng, 'drop' => $delivery, 'dlat' => $dlat, 'dlng' => $dlng, 'pickup_city' => $order['pickup_city'], 'drop_city' => $order['delivery_city'], 'pickup_datetime' => $order['pickup_datetime'], 'drop_datetime' => $order['delivery_datetime'], 'name' => $unit->unit_name, 'phone' => $order['customer_phone'], 'address' => $address, 'emailid' => $order['customer_email'], 'user_id' => $userid, 'status' => 1, 'createdon' => $curdt, 'material_id' => $unit->handling_unit, 'capacity' => $unit->weight, 'information' => $order['customer_comments'], 'shipment_weight' => $unit->weight, 'shipment_volume' => $vol, 'ship_type' => 'P', 'customer_id' => $order['customer_id'], 'vendor_id' => $vendor_id, 'shipment_id' => 0, 'startdate' => $order['pickup_datetime'], 'enddate' => $order['delivery_datetime'], 'shift_id' => $input['ship_id'], 'stop_order' => 1, 'drop_order' => 0, 'basic_stop' => 0, 'stop_id' => 0, 'drop_stopid' => 0, 'order_id' => $order['order_id'], 'pkgitemid' => 'BOXES', 'no_of_pkgs' => $unit->quantity, 'domainname' => 'INFD'];
                    $ins       = $this->db->insert("tb_employee", $insarr);
                    $detail_id = $this->db->insert_id();
                    if ($detail_id > 0) {
                        $upd = $this->common->updatetbledata("tb_order_cargodetails", ['stop_detail_id' => $detail_id], ['id' => $unit->id]);
                        /*update orders table*/
                        $updwhr = ['id' => $input['ordid']];
                        $setwhr = ['status' => 2];
                        if ($totalcargos == count($lines)) {
                            $ins = $this->common->updatetbledata("tb_orders", $setwhr, $updwhr);
                        }
                        /*insert stops records */
                        $where   = ["shipment_id" => $input['ship_id'], 'plat' => $plat, 'plng' => $plng, "stopcity" => $order['pickup_city']];
                        $select  = "id";
                        $table   = "tb_shiporder_stops";
                        $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkstop) == 0) {
                            $insarr        = ['stopname' => $order['pickup_city'], 'plat' => $plat, 'plng' => $plng, 'stopcity' => $order['pickup_city'], 'address' => $address, 'stoptype' => 'P', 'stopstatus' => 0, 'shipment_id' => $input['ship_id'], 'ordernumber' => 1, 'startdate' => $order['pickup_datetime'], 'enddate' => $order['pickup_endtime'], 'weight' => $order['weight'], 'volume' => $order['volume'], 'shipmentstopid' => 0, 'ship_units' => $order['quantity'], 'txncode' => 'NP', 'status' => 1, 'created_on' => $curdt];
                            $ins           = $this->db->insert("tb_shiporder_stops", $insarr);
                            $pickupstop_id = $this->db->insert_id();
                        } else {
                            $pickupstop_id     = $chkstop['id'];
                            $update_pickupstop = $this->db->where(["id" => $pickupstop_id])->update("tb_shiporder_stops", ["status" => "1"]);
                        }
                        $where   = ["shipment_id" => $input['ship_id'], 'plat' => $dlat, 'plng' => $dlng, "stopcity" => $order['delivery_city']];
                        $select  = "id";
                        $table   = "tb_shiporder_stops";
                        $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                        if (count($chkstop) == 0) {
                            $insarr      = ['stopname' => $order['delivery_city'], 'plat' => $dlat, 'plng' => $dlng, 'stopcity' => $order['delivery_city'], 'address' => $dropaddr, 'stoptype' => 'D', 'stopstatus' => 0, 'shipment_id' => $input['ship_id'], 'ordernumber' => 2, 'startdate' => $order['delivery_datetime'], 'enddate' => $order['drop_endtime'], 'weight' => $order['weight'], 'volume' => $order['volume'], 'shipmentstopid' => 0, 'ship_units' => $order['quantity'], 'txncode' => 'NP', 'status' => 1, 'created_on' => $curdt];
                            $ins         = $this->db->insert("tb_shiporder_stops", $insarr);
                            $dropstop_id = $this->db->insert_id();
                        } else {
                            $dropstop_id     = $chkstop['id'];
                            $update_dropstop = $this->db->where(["id" => $dropstop_id])->update("tb_shiporder_stops", ["status" => "1"]);
                        }
                        /*update pickupstop and drop stop id into details/tb_employee table */
                        $setarr = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id];
                        $setwhr = ['id' => $detail_id];
                        $ins    = $this->db->where($setwhr)->update("tb_employee", $setarr);
                        /*check shipment pickup and drop*/
                        if (count($shipment) > 0) {
                            $pickuploc   = ['pickup_country' => $order['pickup_country'], 'pickup_city' => $order['pickup_city'], 'pickup_location' => $order['pickup_address1']];
                            $droploc     = ['drop_country' => $order['delivery_country'], 'drop_city' => $order['delivery_city'], 'drop_location' => $order['delivery_address1']];
                            $border_type = getshipbordertype($pickuploc, $droploc);
                            $updarr      = [];
                            if ($border_type == 1) {
                                $updarr['border_type'] = $border_type;
                            }
                            if ($shipment['splace'] == "") {
                                $updarr['splace'] = $order['pickup_city'];
                                $updarr['scity']  = $order['pickup_city'];
                            }
                            if ($shipment['eplace'] == "") {
                                $updarr['eplace'] = $order['delivery_city'];
                                $updarr['dcity']  = $order['delivery_city'];
                            }
                            if ($shipment['slat'] == "") {$updarr['slat'] = $plat;}
                            if ($shipment['slng'] == "") {$updarr['slng'] = $plng;}
                            if ($shipment['elat'] == "") {$updarr['elat'] = $dlat;}
                            if ($shipment['elng'] == "") {$updarr['elng'] = $dlng;}
                            $updarr['weight']      = ($shipment['weight'] + $order['weight']);
                            $updarr['volume']      = ($shipment['volume'] + $order['volume']);
                            $updarr['units']       = ($shipment['units'] + $order['quantity']);
                            $updarr['customer_id'] = $order['customer_id'];
                            if (! empty($updarr)) {
                                $setwhr = ['id' => $input['ship_id']];
                                $ins    = $this->db->where($setwhr)->update("tb_shifts", $updarr);
                            }
                            $shipid = $input['ship_id'];
                            $chk1   = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $shipid], 1, 0);
                            if ($chk1->num_rows() > 0) {
                                $shftvehid = $chk1->row()->id;
                                $chk       = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                                if ($chk->num_rows() == 0) {
                                    $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $shipid]);
                                    if ($getemp->num_rows() > 0) {
                                        $pri = 1;
                                        foreach ($getemp->result() as $gt) {
                                            $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                            $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                } else {
                                    $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1], 1, 0);
                                    if ($chkemp->num_rows() == 0) {
                                        $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime']];
                                        $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                    }
                                }
                            }
                        }
                    }
                }
                /*if($company_code == 'INKN' && $branch_code == 'INDEL') {
						if( $input['ship_id'] != ""){
							$ship_id = $input['ship_id'];
							$driver_id = $vehicle_id = "";
							$driver = $this->db->query("select v.vehicle_id,driver_id from tb_shft_veh v,tbl_assigned_drivers a WHERE v.vehicle_id=a.vehicle_id AND v.shft_id='$ship_id' AND v.status=1 AND a.status=1 LIMIT 1");
							if($driver->num_rows()>0){
								$driver_id = $driver->row()->driver_id;
								$vehicle_id = $driver->row()->vehicle_id;
							}
							if($driver_id != "" && $vehicle_id != "" ){
								$data = array("ord_id"=>$input['ordid'],"vehicle_id"=>$vehicle_id,"driver_id"=>$driver_id,"ship"=>$input['ship_id'],"plat"=>$plat,"plng"=>$plng);
								log_message("error","autoaccept data".json_encode($data));
								$autoaccepttrip = autoaccepttrip($data);
							}
						}
					}*/
                $response = 1;
            }
            /* Push notification to mobile using Firebase */
            $tripNo       = $this->common->gettblrowdata(["id" => $input['ship_id']], "shipmentid", "tb_shifts", 0, 0);
            $vehicleId    = $this->common->gettblrowdata(["shft_id" => $input['ship_id']], "vehicle_id", "tb_shft_veh", 0, 0);
            $driverId     = $this->common->gettblrowdata(["vehicle_id" => $vehicleId['vehicle_id']], "driver_id", "tbl_assigned_drivers", 0, 0);
            $customerName = $this->common->gettblrowdata(["id" => $order['customer_id']], "name", "tb_customers", 0, 0);
            if ($order['created_source'] == 18) {
                $getTrackingNumber = $this->common->gettblrowdata(["order_id" => $order['id'], 'reference_id' => 'AWB', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                $knTrackingNo      = $getTrackingNumber['ref_value'] ?? "";
            } else {
                $getTrackingNumber = $this->common->gettblrowdata(["order_id" => $order['id'], 'reference_id' => 'DQ', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                $knTrackingNo      = $getTrackingNumber['ref_value'] ?? "";
            }
            if ($tripNo['shipmentid'] != "" && $driverId['driver_id'] > 0) {
                $message = "New trip is assigned" . " "
                . "Pickup Date: " . substr($order['pickup_datetime'], 0, 10) . " "
                    . "Customer Name: " . $customerName['name'] . " "
                    . "Booking ID: " . $order['order_id'] . " "
                    . "KN tracking no: " . $knTrackingNo . " "
                    . "Trip No: " . $tripNo['shipmentid'];
                $messageData = json_encode(["msg" => $message, "info" => (object) [], "type" => 1], JSON_UNESCAPED_UNICODE);
                $fire_ret    = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driverId['driver_id'], 'type' => 'Driver']);
            }
        }
    }
    public function orderintoshipment()
    {
        $response     = 0;
        $userid       = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        $curtz        = $this->session->userdata("usr_tzone")['timezone'];
        $logdate      = date('Y-m-d H:i:s');
        $getactual    = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt        = $getactual['datetime'];
        $input        = $this->input->post();
        if ($input['ship_id'] > 0 && $input['ordid'] > 0) {
            $sid         = $input['ordid'];
            $stops_units = $this->db->query("SELECT oc.id,oc.length,oc.width,oc.height,oc.weight,oc.quantity,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND (oc.stop_detail_id is NULL OR oc.stop_detail_id=0) AND oc.status='1'");
            if ($stops_units->num_rows() > 1) {
                echo $this->load->view("shipments/orderLines", ["lines" => $stops_units], true);
                exit;
            }
            $where  = ["id" => $input['ordid']];
            $select = "*";
            $table  = "tb_orders";
            $order  = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($order) > 0) {
                $shift_idchk = $order['shift_id'];
                if ($shift_idchk == 0) {
                    /*$stops_units = $this->db->query("SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");*/
                    $associd = time();
                    $pickup  = $order['pickup_address1'];
                    if ($pickup == "") {$pickup = $order['pickup_city'];}
                    $delivery = $order['delivery_address1'];
                    if ($delivery == "") {$delivery = $order['delivery_city'];}
                    $address = $dropaddr = "";
                    if ($order['pickup_address1'] != "") {
                        $address .= $order['pickup_address1'];
                        $dropaddr .= $order['delivery_address1'];
                    }
                    if ($order['pickup_company'] != "") {
                        $address .= ", " . $order['pickup_company'];
                        $dropaddr .= ", " . $order['delivery_company'];
                    }
                    if ($order['pickup_country'] != "") {
                        $address .= ", " . $order['pickup_country'];
                        $dropaddr .= ", " . $order['delivery_country'];
                    }
                    if ($order['pickup_city'] != "") {
                        $address .= ", " . $order['pickup_city'];
                        $dropaddr .= ", " . $order['delivery_city'];
                    }
                    if ($order['pickup_pincode'] != "") {
                        $address .= ", " . $order['pickup_pincode'];
                        $dropaddr .= ", " . $order['delivery_pincode'];
                    }
                    $plat         = $order['plat'];
                    $plng         = $order['plng'];
                    $dlat         = $order['dlat'];
                    $dlng         = $order['dlng'];
                    $vendor_id    = $order['vendor_id'];
                    $vehicle_type = $order['vehicle_type'];
                    $where        = ["id" => $input['ship_id']];
                    $select       = "id,splace,slat,slng,eplace,elat,elng,vendor_id,shipmentid,weight,volume,units,vehicle_type";
                    $table        = "tb_shifts";
                    $shipment     = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if ($vendor_id == 0) {
                        if (count($shipment) > 0) {
                            $vendor_id             = $shipment['vendor_id'];
                            $setwhr1['vendor_id']  = $vendor_id;
                            $setwhr1['shift_id']   = $input['ship_id'];
                            $setwhr1['shipmentid'] = $shipment['shipmentid'];
                            if ($shipment['vehicle_type'] != "") {
                                $vehicle_type            = $shipment['vehicle_type'];
                                $setwhr1['vehicle_type'] = $vehicle_type;
                            }
                            $updwhr1 = ['id' => $input['ordid']];
                            $ins     = $this->db->where($updwhr1)->update("tb_orders", $setwhr1);
                            $this->sendnotify('trip_create', $input['ordid']);
                            $info = ['ordid' => $input['ordid'], 'carrierid' => $vendor_id];
                            $this->ratemanagement->addrecodfortripinsertion($info);
                        }
                    } else {
                        $updwhr1             = ['id' => $input['ordid']];
                        $setwhr1['shift_id'] = $input['ship_id'];
                        if (count($shipment) > 0) {
                            $setwhr1['shipmentid'] = $shipment['shipmentid'];
                        }
                        $ins = $this->db->where($updwhr1)->update("tb_orders", $setwhr1);
                    }
                    $invtypes = makeorderinvolvedpartiestype($vendor_id, $input['ordid'], "CARRIER", $userid, $company_code);
                    /*update orders table*/
                    $updwhr = ['id' => $input['ordid']];
                    $setwhr = ['status' => 2];
                    $ins    = $this->db->where($updwhr)->update("tb_orders", $setwhr);
                    /*insert stops records */
                    $where   = ["shipment_id" => $input['ship_id'], "stopcity" => $order['pickup_city'], "stoptype" => "P"];
                    $select  = "id";
                    $table   = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr        = ['stopname' => $order['pickup_city'], 'plat' => $plat, 'plng' => $plng, 'stopcity' => $order['pickup_city'], 'address' => $address, 'stoptype' => 'P', 'stopstatus' => 0, 'shipment_id' => $input['ship_id'], 'ordernumber' => 1, 'startdate' => $order['pickup_datetime'], 'enddate' => $order['pickup_endtime'], 'weight' => $order['weight'], 'volume' => $order['volume'], 'shipmentstopid' => 0, 'ship_units' => $order['quantity'], 'txncode' => 'NP', 'status' => 1, 'created_on' => $curdt];
                        $ins           = $this->db->insert("tb_shiporder_stops", $insarr);
                        $pickupstop_id = $this->db->insert_id();
                    } else {
                        $pickupstop_id     = $chkstop['id'];
                        $update_pickupstop = $this->db->where(["id" => $pickupstop_id])->update("tb_shiporder_stops", ["status" => "1"]);
                    }
                    $where   = ["shipment_id" => $input['ship_id'], "stopcity" => $order['delivery_city'], "stoptype" => "D"];
                    $select  = "id";
                    $table   = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr      = ['stopname' => $order['delivery_city'], 'plat' => $dlat, 'plng' => $dlng, 'stopcity' => $order['delivery_city'], 'address' => $dropaddr, 'stoptype' => 'D', 'stopstatus' => 0, 'shipment_id' => $input['ship_id'], 'ordernumber' => 2, 'startdate' => $order['delivery_datetime'], 'enddate' => $order['drop_endtime'], 'weight' => $order['weight'], 'volume' => $order['volume'], 'shipmentstopid' => 0, 'ship_units' => $order['quantity'], 'txncode' => 'NP', 'status' => 1, 'created_on' => $curdt];
                        $ins         = $this->db->insert("tb_shiporder_stops", $insarr);
                        $dropstop_id = $this->db->insert_id();
                    } else {
                        $dropstop_id     = $chkstop['id'];
                        $update_dropstop = $this->db->where(["id" => $dropstop_id])->update("tb_shiporder_stops", ["status" => "1"]);
                    }
                    /*insert or update in tb_employee table*/
                    $whr_emp = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id, 'order_id' => $order['order_id'], 'shift_id' => $input['ship_id']];
                    $chkemp  = $this->common->gettblrowdata($whr_emp, "id", "tb_employee", 0, 0);
                    if (! empty($chkemp)) {
                        $detail_id  = $chkemp['id'];
                        $update_emp = $this->db->where(["id" => $detail_id])->update("tb_employee", ["status" => "1"]);
                    } else {
                        /*$ins = $this->db->where($setwhr)->update("tb_employee",$setarr);*/
                        $insarr    = ['assoc_id' => $associd, 'pickup' => $pickup, 'plat' => $plat, 'plng' => $plng, 'drop' => $delivery, 'dlat' => $dlat, 'dlng' => $dlng, 'pickup_city' => $order['pickup_city'], 'drop_city' => $order['delivery_city'], 'pickup_datetime' => $order['pickup_datetime'], 'drop_datetime' => $order['delivery_datetime'], 'name' => 'Boxes', 'phone' => $order['customer_phone'], 'address' => $address, 'emailid' => $order['customer_email'], 'user_id' => $userid, 'status' => 1, 'createdon' => $curdt, 'material_id' => 0, 'capacity' => $order['weight'], 'information' => $order['customer_comments'], 'shipment_weight' => $order['weight'], 'shipment_volume' => $order['volume'], 'ship_type' => 'P', 'customer_id' => $order['customer_id'], 'vendor_id' => $vendor_id, 'shipment_id' => 0, 'startdate' => $order['pickup_datetime'], 'enddate' => $order['delivery_datetime'], 'shift_id' => $input['ship_id'], 'stop_order' => 1, 'drop_order' => 0, 'basic_stop' => 0, 'stop_id' => 0, 'drop_stopid' => 0, 'order_id' => $order['order_id'], 'pkgitemid' => 'BOXES', 'no_of_pkgs' => $order['quantity'], 'domainname' => 'INFD'];
                        $ins       = $this->db->insert("tb_employee", $insarr);
                        $detail_id = $this->db->insert_id();
                        /*update pickupstop and drop stop id into details/tb_employee table */
                        $setarr = ['stop_id' => $pickupstop_id, 'drop_stopid' => $dropstop_id];
                        $setwhr = ['id' => $detail_id];
                        $ins    = $this->db->where($setwhr)->update("tb_employee", $setarr);
                    }
                    if ($detail_id > 0) {
                        if ($stops_units->num_rows() > 1) {
                            $odata = $stops_units->row();
                            $upd   = $this->db->query("UPDATE tb_order_cargodetails set stop_detail_id='$detail_id' WHERE id = '" . $odata->id . "'");
                        }

                        /*check shipment pickup and drop*/
                        if (count($shipment) > 0) {
                            $updarr = [];
                            if ($shipment['splace'] == "") {
                                $updarr['splace'] = $order['pickup_city'];
                                $updarr['scity']  = $order['pickup_city'];
                            }
                            if ($shipment['eplace'] == "") {
                                $updarr['eplace'] = $order['delivery_city'];
                                $updarr['dcity']  = $order['delivery_city'];
                            }
                            if ($shipment['slat'] == "") {$updarr['slat'] = $plat;}
                            if ($shipment['slng'] == "") {$updarr['slng'] = $plng;}
                            if ($shipment['elat'] == "") {$updarr['elat'] = $dlat;}
                            if ($shipment['elng'] == "") {$updarr['elng'] = $dlng;}
                            $updarr['weight']      = ($shipment['weight'] + $order['weight']);
                            $updarr['volume']      = ($shipment['volume'] + $order['volume']);
                            $updarr['units']       = ($shipment['units'] + $order['quantity']);
                            $updarr['customer_id'] = $order['customer_id'];
                            if (! empty($updarr)) {
                                $setwhr = ['id' => $input['ship_id']];
                                $ins    = $this->db->where($setwhr)->update("tb_shifts", $updarr);
                            }
                            $shipid = $input['ship_id'];
                            $chk1   = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $shipid], 1, 0);
                            if ($chk1->num_rows() > 0) {
                                $shftvehid = $chk1->row()->id;
                                $chk       = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                                if ($chk->num_rows() == 0) {
                                    $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $shipid]);
                                    if ($getemp->num_rows() > 0) {
                                        $pri = 1;
                                        foreach ($getemp->result() as $gt) {
                                            $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                            $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                            $pri++;
                                        }
                                    }
                                } else {
                                    $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "status" => 1], 1, 0);
                                    if ($chkemp->num_rows() == 0) {
                                        $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $detail_id, "priority" => 3, "pickup_time" => $order['pickup_datetime'], 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $order['delivery_datetime']];
                                        $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                    }
                                }
                            }
                            /* update status */
                            $chk = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $shipid, "status_id" => 9], 1, 0);
                            if ($chk->num_rows() == 0) {
                                $curtz     = $this->session->userdata("usr_tzone")['timezone'];
                                $logdate   = date('Y-m-d H:i:s');
                                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                                $curdt1    = $getactual['datetime'];
                                $ins       = ["shipment_id" => $shipid, "stop_id" => 0, "order_id" => $input['ordid'], "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status" => 1, "status_code" => "SV0100", "reason" => "Coming from E-Booking", "createdon" => $curdt1];
                                $insqry    = $this->db->insert("tb_stop_status", $ins);
                            }

                            $checkvendors = $this->db->select("id")->get_where("tb_vendors", ['id' => $vendor_id, 'tms_auto_accept' => 1], 1, 0);
                            if ($checkvendors->num_rows() != 0) {
                                $shipOrderLit = $this->db->select("id")->get_where(
                                    "tb_orders",
                                    ['shift_id' => $shipid],
                                    1,
                                    0
                                );
                                if ($shipOrderLit->num_rows() != 0) {
                                    $driver_id = $vehicle_id = "";
                                    $driver    = $this->db->query("select v.vehicle_id,driver_id from tb_shft_veh v,tbl_assigned_drivers a WHERE v.vehicle_id=a.vehicle_id AND v.shft_id=$shipid AND v.status=1 AND a.status=1 LIMIT 1");
                                    if ($driver->num_rows() > 0) {
                                        $driver_id  = $driver->row()->driver_id;
                                        $vehicle_id = $driver->row()->vehicle_id;
                                    }
                                    $whr         = ['id' => $driver_id, 'status' => 1];
                                    $chknum      = $this->db->select("contact_num")->get_where("tb_truck_drivers", $whr, 1, 0);
                                    $contact_num = $chknum->row()->contact_num;
                                    if ($vehicle_id != 0 && $driver_id != 0) {
                                        $checkshifts = $this->db->select("id")->get_where("tb_trips", ['shift_id' => $shipid, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id], 1, 0);
                                        if ($checkshifts->num_rows() == 0) {
                                            $triparr = @[
                                                'shift_id'       => $shipid,
                                                'vehicle_id'     => $vehicle_id,
                                                'driver_id'      => $driver_id,
                                                'stime'          => $curdt,
                                                'start_imei'     => $contact_num,
                                                'splace'         => "",
                                                'eplace'         => "",
                                                'start_reading'  => 0,
                                                'end_reading'    => 0,
                                                'created_on'     => $curdt,
                                                'updated_on'     => $curdt,
                                                'status'         => 1,
                                                'trip_type'      => 0,
                                                'transit_status' => 0,

                                            ];
                                            $trip_id = $this->db->insert("tb_trips", $triparr);

                                            $tripid   = ['shift_id' => $shipid, 'vehicle_id' => $vehicle_id, 'status' => 1];
                                            $chktrips = $this->db->select("id")->get_where("tb_trips", $tripid, 1, 0);
                                            $trip_id  = $chktrips->row()->id;
                                            $ordwhr   = ["shift_id" => $shipid];
                                            $ordset   = ["trip_id" => $trip_id];
                                            $upd      = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");

                                            $orderid   = ['shift_id' => $shipid, 'trip_id' => $trip_id];
                                            $chkorders = $this->db->select("id, order_id")->get_where("tb_orders", $orderid, 1, 0);
                                            $chkorders = $chkorders->row();
                                            $order_id  = $chkorders->id;
                                            $insarry   = [
                                                'order_id'       => $order_id,
                                                "shipment_id"    => $shipid,
                                                "stop_id"        => 0,
                                                "stop_detail_id" => 0,
                                                "stop_type"      => "",
                                                "trip_id"        => $trip_id,
                                                "status_id"      => 10,
                                                "latitude"       => "",
                                                "longitude"      => "",
                                                "status"         => 1,
                                                "reason"         => "From Admin",
                                                "vehicle_id"     => $vehicle_id,
                                                "driver_id"      => $driver_id,
                                                "status_code"    => 'SV0120',
                                                "createdon"      => $curdt,
                                            ];
                                            $ins         = $this->db->insert("tb_stop_status", $insarry);
                                            $companyCode = $this->session->userdata('company_code');
                                            $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                                            if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, 'SV0120')) {
                                                $this->load->library('notifytrigger');
                                                $this->notifytrigger->sendNotificationToConsignee($order['id'], 'SV0120');
                                            }
                                            if (checkAccessConditions('WECHAT_COUNTRY', $companyCode)) {
                                                $this->load->library('Wechat');
                                                $this->wechat->orderId = $chkorders->order_id;
                                                $this->wechat->sendNotificationsToWeChat();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                $response = 1;
                /* Push notification to mobile using Firebase */
                $tripNo       = $this->common->gettblrowdata(["id" => $input['ship_id']], "shipmentid", "tb_shifts", 0, 0);
                $vehicleId    = $this->common->gettblrowdata(["shft_id" => $input['ship_id']], "vehicle_id", "tb_shft_veh", 0, 0);
                $driverId     = $this->common->gettblrowdata(["vehicle_id" => $vehicleId['vehicle_id']], "driver_id", "tbl_assigned_drivers", 0, 0);
                $customerName = $this->common->gettblrowdata(["id" => $order['customer_id']], "name", "tb_customers", 0, 0);
                if ($order['created_source'] == 18) {
                    $getTrackingNumber = $this->common->gettblrowdata(["order_id" => $order['id'], 'reference_id' => 'AWB', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                    $knTrackingNo      = $getTrackingNumber['ref_value'] ?? "";
                } else {
                    $getTrackingNumber = $this->common->gettblrowdata(["order_id" => $order['id'], 'reference_id' => 'DQ', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                    $knTrackingNo      = $getTrackingNumber['ref_value'] ?? "";
                }
                if ($tripNo['shipmentid'] != "" && $driverId['driver_id'] > 0) {
                    $message = "New trip is assigned" . " "
                    . "Pickup Date: " . substr($order['pickup_datetime'], 0, 10) . " "
                        . "Customer Name: " . $customerName['name'] . " "
                        . "Booking ID: " . $order['order_id'] . " "
                        . "KN tracking no: " . $knTrackingNo . " "
                        . "Trip No: " . $tripNo['shipmentid'];
                    $messageData = json_encode(["msg" => $message, "info" => (object) [], "type" => 1], JSON_UNESCAPED_UNICODE);
                    $fire_ret    = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driverId['driver_id'], 'type' => 'Driver']);
                }
            }
        }
        echo $response;
    }

    /*public function maproute()
    {
        $sid = $this->input->post('shipment_id');
        //log_message("error","sid:".$sid);
        $response['stops'] = [];
        if ($sid != "") {
            $where = ["shipment_id" => $sid];
            $table = "tb_shiporder_stops";
            $stops = $this->db->select("id,stopname,plat,plng")->order_by("ordernumber", "ASC")->get_where($table, $where);
            log_message("error","stops:".$this->db->last_query());
            if ($stops->num_rows() > 0) {
                $response['stops'] = $stops->result_array();
            }
        }
        $companyCode = $this->session->userdata('company_code');
        /*log_message("error","companyCode:".$companyCode);
         log_message("error","map_type:".$this->session->userdata('map_type'));
         log_message("error","response:".json_encode($response));--
        if ($this->session->userdata('company_code') === "CNKN") {
            echo $this->load->view("shipments/mapview_china", $response, true);
        } elseif ($this->session->userdata('map_type') == 0) {
            echo $this->load->view("shipments/mapview", $response, true);
        } else if ($this->session->userdata('map_type') == 1) {
            echo $this->load->view("shipments/mapview_eu", $response, true);
        } else {
            echo $this->load->view("shipments/mapview", $response, true);
        }
    }*/
    
    public function maproute()
    {
        $sid = $this->input->post('shipment_id');

        //log_message("error","sid:".$sid);
        $response['stops'] = [];
        if ($sid != "") {
            $legs = $this->db->select('id')
                ->from('tb_shifts')
                ->where('shift_leg_id', $sid)
                ->order_by('shift_leg_id', 'ASC')
                ->get();
            $legs = $legs->result_array();
            $legids = [];
            foreach ($legs as $id) {
                $legids[] = $id['id'];
            }
            if (count($legids) > 0) {
                $stops = $this->db->select("
                    o.id,
                    o.stopname,
                    o.plat,
                    o.plng,
                    d.plat AS dlat,
                    d.plng AS dlng,
                    ts.scity as pickup_city,
                    ts.dcity as delivery_city,
                    o.stopcity,
                    o.address,
                    o.stoptype,
                    convertToClientTZ(o.startdate, 'Asia/Kolkata') AS startdate,
                    convertToClientTZ(o.enddate, 'Asia/Kolkata') AS enddate,
                    o.shipment_id,
                    o.weight,
                    o.volume,
                    o.ship_units,
                    o.status,
                    o.ordernumber,
                    ts.transport_mode as tmode,
                    ts.shipmentid")
                    ->from("tb_shiporder_stops AS o")
                    ->join("tb_shiporder_stops AS d", "d.shipment_id = o.shipment_id AND o.stoptype = 'P' AND d.stoptype = 'D'")
                    ->join("tb_shifts AS ts", "ts.id = o.shipment_id", "left")
                    ->where_in("o.shipment_id", $legids)
                    ->where("o.status", 1)
                    ->group_by("o.shipment_id")
                    ->order_by("o.id", "ASC")
                    ->get();
            } else {
                $orders = $this->db->select('id')
                ->from('tb_orders')
                ->where('shift_id', $sid)
                ->get();
                $orders = $orders->result_array();
                $orderIds = [];
                foreach ($orders as $id) {
                    $orderIds[] = $id['id'];
                }
                if (count($orderIds) > 1) {
                    $this->db->distinct();
                    $this->db->select('
                        o.id,
                        o.dlat,
                        o.dlng,
                        o.plat,
                        o.plng,
                        o.transport_mode AS tmode,
                        o.pickup_city,
                        o.delivery_city');
                    $this->db->from('tb_orders AS o');
                    $this->db->where('o.shift_id', $sid);
                    $this->db->order_by('o.id', 'ASC');
                } else
                {
                    $this->db->select('
                    o.id,
                    o.slat as plat,
                    o.slng as plng,
                    o.elat as dlat,
                    o.elng as dlng,
                    o.transport_mode AS tmode,
                    o.splace as pickup_city,
                    o.eplace as delivery_city');
                $this->db->from('tb_shifts AS o');
                $this->db->where('o.id', $sid);
                $this->db->order_by('o.id', 'ASC');
                }
                $stops = $this->db->get();
            }

            if ($stops->num_rows() > 0) {
                $response['stops'] = $stops->result_array();
            }

        }
        $companyCode = $this->session->userdata('company_code');
        if ($this->session->userdata('company_code') === "CNKN") {
            echo $this->load->view("shipments/mapview_china", $response, true);
        } elseif ($this->session->userdata('map_type') == 0) {
            echo $this->load->view("shipments/mapview", $response, true);
        } else if ($this->session->userdata('map_type') == 1) {
            echo $this->load->view("shipments/mapview_eu", $response, true);
        } else {
            echo $this->load->view("shipments/mapview", $response, true);
        }
    }
    
    /*public function maproute()
    {
        $sid = $this->input->post('shipment_id');

        //log_message("error","sid:".$sid);
        $response['stops'] = [];
        if ($sid != "") {
            
            $this->db->distinct();
                $this->db->select('
                    o.id,
                    o.slat as plat,
                    o.slng as plng,
                    o.elat as dlat,
                    o.elng as dlng,
                    o.transport_mode AS tmode,
                    o.splace as pickup_city,
                    o.eplace as delivery_city');
                $this->db->from('tb_shifts AS o');
                $this->db->where('o.id', $sid);
                $this->db->order_by('o.id', 'ASC');
                $stops = $this->db->get();

            if ($stops->num_rows() > 0) {
                $response['stops'] = $stops->result_array();
            }

        }
        $companyCode = $this->session->userdata('company_code');
        if ($this->session->userdata('company_code') === "CNKN") {
            echo $this->load->view("shipments/mapview_china", $response, true);
        } elseif ($this->session->userdata('map_type') == 0) {
            echo $this->load->view("shipments/mapview", $response, true);
        } else if ($this->session->userdata('map_type') == 1) {
            echo $this->load->view("shipments/mapview_eu", $response, true);
        } else {
            echo $this->load->view("shipments/mapview", $response, true);
        }
    }*/

    public function createorder()
    {
        $order_id       = @$this->input->post("order_id");
        $userid         = $this->session->userdata('user_id');
        $data['userid'] = $userid;
        $permission     = checkuserpermissions();
        if (in_array("trips", $permission)) {
            $company_code      = $this->session->userdata('company_code');
            $data['customers'] = $this->db->select('id,name')->get_where("tb_customers", ["company_code" => $company_code, "status" => 1]);
        } else {
            $data['customers'] = $this->db->select('id,name')->get_where("tb_customers", ["user_id" => $userid, "status" => 1]);
        }
        $data["order"] = $this->db->where(["id" => $order_id])->get("tb_orders")->row();
        echo $this->load->view("shipments/createorder", $data, true);
    }

    public function addshipment()
    {
        $userid         = $this->session->userdata('user_id');
        $company_code   = $this->session->userdata('company_code');
        $branch_code    = $this->session->userdata('branch_code');
        $data['userid'] = $userid;
        $permission     = checkuserpermissions();

        if ($company_code == "KNAU") {
            $company_code = "AUKN";
        }

        if (in_array("carrier", $permission)) {
            $data["carriers"] = $this->db->query("SELECT v.id, v.name,v.code FROM tb_vendors as v JOIN tbl_party_master as pm ON (pm.code=v.code  and v.code IS NOT NULL and  pm.company_code=v.company_code) where pm.status=1 and v.status=1 and  v.company_code='" . $company_code . "' ORDER BY v.name asc ");
        } else {
            $data["carriers"] = $this->db->query("SELECT v.id, v.name, v.code FROM tb_vendors as v JOIN tbl_party_master as pm ON (pm.code=v.code  and v.code IS NOT NULL and  pm.user_id=v.user_id) where pm.status=1 and v.status=1 and  v.user_id='" . $userid . "' ORDER BY v.name asc ");
        }
        if (in_array('vehicletypes', $permission)) {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["company_code" => $company_code, "status" => 'Active']);
        } else {
            if ($branch_code == "PLKTW") {
                $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["company_code" => $company_code, "branch_code" => $branch_code, "status" => 'Active']);
            } else {
                $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active']);
            }
        }
        $data['rate_categories'] = $this->db->select('id,name')->get_where("tb_shipment_rate_categories", ["status" => 1]);
        echo $this->load->view("shipments/addshipment", $data, true);
    }

    public function editShipment()
    {
        $shipment_id    = @$this->input->post("shipment_id");
        $company_code   = $this->session->userdata('company_code');
        $branch_code    = $this->session->userdata('branch_code');
        $userid         = $this->session->userdata('user_id');
        $vehicle        = $this->input->post("vehicle");
        $data['driver'] = "";
        $driver         = $this->db->query("select driver_id from tb_shft_veh v,tbl_assigned_drivers a WHERE v.vehicle_id=a.vehicle_id AND v.shft_id='$shipment_id' AND v.status=1 AND a.status=1 LIMIT 1");
        if ($driver->num_rows() > 0) {
            $data['driver'] = $driver->row()->driver_id;
        }
        $data['vehicle'] = $vehicle;
        $data['userid']  = $userid;
        $permission      = checkuserpermissions();
        if (in_array("carrier", $permission)) {
            $data["carriers"] = $this->db->query("SELECT v.id, v.name,v.code FROM tb_vendors as v JOIN tbl_party_master as pm ON (pm.code=v.code  and v.code IS NOT NULL and  pm.company_code=v.company_code) where pm.status=1 and v.status=1 and  v.company_code='" . $company_code . "' ORDER BY v.name asc ");
        } else {
            $data["carriers"] = $this->db->query("SELECT v.id, v.name,v.code FROM tb_vendors as v JOIN tbl_party_master as pm ON (pm.code=v.code  and v.code IS NOT NULL and  pm.user_id=v.user_id) where pm.status=1 and v.status=1 and  v.user_id='" . $userid . "' ORDER BY v.name asc ");
        }
        if (in_array("vehicletypes", $permission)) {
            $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["company_code" => $company_code, "status" => 'Active']);
        } else {
            if ($branch_code == "PLKTW") {
                $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["company_code" => $company_code, "branch_code" => $branch_code, "status" => 'Active']);
            } else {
                $data['vehicletypes'] = $this->db->select('id,trucktype')->get_where("tb_trucktypes", ["status" => 'Active']);
            }
        }
        $data['rate_categories'] = $this->db->select('id,name')->get_where("tb_shipment_rate_categories", ["status" => 1]);
        if (strlen($shipment_id ?? 0) > 0) {
            $data["shipment"]      = $this->db->where(["id" => $shipment_id])->get("tb_shifts")->row();
            $data["shipment_rate"] = $this->db->where(["shift_id" => $shipment_id, "status" => "1"])->get("tb_shipment_rates")->row();
        }
        echo $this->load->view("shipments/editshipment", $data, true);
    }

    public function getdriversbyvendor()
    {
        $user_id = $this->session->userdata('user_id');
        if ($this->session->userdata('business_type') == "Carrier" && checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code'))) {
            $this->load->model('Vendors');
            $carrier_id = $this->Vendors->getChildren($this->session->userdata('id'));
        } else {
            $carrier_id = [$this->input->post('carrier_id')];
        }
        $vehicleId = $this->db->escape($this->input->post('vehicle_id') ?: 0);

        $data["drivers"] = [];
        $permission      = checkuserpermissions();
        $company_code    = $this->session->userdata('company_code');
        $queryValues     = [$carrier_id, 1, 1, 'Active'];
        $pwhr            = '';

        if (in_array("trips", $permission) || (checkAccessConditions('DRIVER_LIST_WITH_CARRIER_COMPANY_CODE', $company_code))) {
            $pwhr        = "AND d.company_code LIKE ? ";
            $queryValues = array_merge($queryValues, [$company_code]);
        } elseif ($this->session->userdata('business_type') != "Carrier") {
            $pwhr        = "AND d.user_id = ? ";
            $queryValues = array_merge($queryValues, [$user_id]);
        }

        if ($vehicleId != 0) {
            $vehicleCondition = " AND vd.vehicle_id = ? ";
            $queryValues      = array_merge($queryValues, [$vehicleId]);
        } else {
            $vehicleCondition = '';
        }

        $drivers = $this->db->query("SELECT
										  d.id,
										  d.name
										from
										  tb_truck_drivers d,
										  tb_vehicles_drivers vd,
										  tb_vendor_vehicles v
										WHERE
										  d.id = vd.driver_id AND vd.vehicle_id = v.vehicle_id AND v.vendor_id IN ?
										    AND v.status = ? AND vd.status = ?
										    AND d.status = ? " . $pwhr . "  " . $vehicleCondition . "
										GROUP BY
										  d.id
										ORDER BY
										  d.name ASC", $queryValues);
        if ($drivers->num_rows() > 0) {
            $data["drivers"] = $drivers->result_array();
        }

        echo json_encode($data);
    }

    public function storeshipment()
    {
        $response    = 0;
        $shipment_id = isset($_POST["id"]) ? $_POST["id"] : "";
        $userid      = $this->session->userdata('user_id');
        $curtz       = $this->session->userdata("usr_tzone")['timezone'];
        $logdate     = date('Y-m-d H:i:s');
        $getactual   = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt       = $getactual['datetime'];
        $input       = $this->input->post();
        $count_code  = $this->session->userdata("usr_tzone")['phone_code'];
        if ($count_code == "") {
            $count_code = $this->session->userdata("usr_tzone")['country'];
        }
        $year              = date('y');
        $week              = date('W');
        $seq_num           = substr(mt_rand(10, 100000), 0, 5);
        $shipmentid        = "T" . $count_code . $week . $year . $seq_num;
        $txnid             = time();
        $startdate         = $input['start_date'];
        $getactual         = getdatetimebytimezone(DFLT_TZ, $startdate, $curtz);
        $startdate         = $getactual['datetime'];
        $starttime         = date('H:i', strtotime($input['start_date']));
        $enddate           = $input['end_date'];
        $getactual         = getdatetimebytimezone(DFLT_TZ, $enddate, $curtz);
        $enddate           = $getactual['datetime'];
        $endtime           = date('H:i', strtotime($input['end_date']));
        $vendor_id         = $input['vendor_id'];
        $transport_mode    = $input['transport_mode'];
        $vehicle_type      = $input['vehicle_type'];
        $driver_id         = isset($input['driver_id']) ? $input['driver_id'] : '';
        $assginedDriverId  = isset($input['driveridhiden']) ? $input['driveridhiden'] : null;
        $assginedVehicleId = isset($input['vehiclehiden']) ? $input['vehiclehiden'] : null;
        $vehicleId         = isset($input['vehicle_id']) ? $input['vehicle_id'] : null;

        $carrier_instructions = isset($input['carrier_instructions']) ? $input['carrier_instructions'] : "";
        
        $weight_capacity                = isset($input['weight_capacity']) ? $input['weight_capacity'] : "";
        $volume_capacity                = isset($input['volume_capacity']) ? $input['volume_capacity'] : "";
        $additional_conditions          = isset($input['additional_conditions']) ? $input['additional_conditions'] : "";
        $temperature_regime             = isset($input['temperature_regime']) ? $input['temperature_regime'] : "";
        $time_for_loading_penality_rate = isset($input['time_for_loading_penality_rate']) ? $input['time_for_loading_penality_rate'] : "";

        $company_code = $this->session->userdata('company_code');
        $branch_code  = $this->session->userdata('branch_code');
        $data         = ['user_id' => $userid, 'stime' => $starttime, 'etime' => $endtime, 'zone_id' => 1, 'empshift_start' => $starttime, 'empshift_end' => $endtime, 'trip_type' => 0, 'startdate' => $startdate, 'enddate' => $enddate, 'shipment_name' => 'Boxes', 'transport_mode' => $transport_mode, 'vendor_id' => $vendor_id, 'carrier_type' => 0, 'txnid' => $txnid, 'domainname' => 'INFD', 'vehicle_type' => $vehicle_type, 'carrier_instructions' => $carrier_instructions, 'weight_capacity' => $weight_capacity, 'volume_capacity' => $volume_capacity, 'additional_conditions' => $additional_conditions, 'temperature_regime' => $temperature_regime, 'time_for_loading_penality_rate' => $time_for_loading_penality_rate, 'status' => 1];


        if ($shipment_id != "" && strlen($shipment_id) > 0) {
            $order_id = $shipment_id;
            $this->db->where(["id" => $order_id])->update("tb_shifts", $data);
            $this->sendnotify('trip_edit', $order_id);
            $this->tripchargesrecalculation->recalculateCharges($order_id);
        } else {
            /*$data['splace'] = $data['eplace'] = "";*/
            $data['shipmentid']   = $shipmentid;
            $data['created_on']   = $curdt;
            $data['company_code'] = $company_code;
            $data['branch_code']  = $branch_code;
            $ins                  = $this->db->insert("tb_shifts", $data);
            $order_id             = $this->db->insert_id();
        }
        /* Push notification to mobile using Firebase */
        if ($shipment_id > 0) {
            $ordersData = $this->common->gettbldata(["shift_id" => $shipment_id], "id,order_id,customer_id,pickup_datetime,shipmentid,created_source", "tb_orders", 0, 0);
        }
        $orderIDs = $bookingIds = $customerIds = $pickUpDates = $createdSource = $customerNames = $knTrackingNos = [];
        foreach ($ordersData as $eachRow) {
            $orderIDs[]      = $eachRow['id'];
            $bookingIds[]    = $eachRow['order_id'];
            $customerIds[]   = $eachRow['customer_id'];
            $pickUpDates[]   = $eachRow['pickup_datetime'];
            $createdSource[] = $eachRow['created_source'];
            $tripNo          = $eachRow['shipmentid'];
        }
        if (! empty($customerIds)) {
            $customerData  = $this->common->gettbldata("id IN (" . implode(",", $customerIds) . ")", "name", "tb_customers", 0, 0);
            $customerNames = array_merge($customerNames, array_column($customerData, 'name'));
        }
        if (! empty($createdSource)) {
            $referenceId    = in_array(18, $createdSource) ? 'AWB' : 'DQ';
            $whereCondition = "order_id IN (" . implode(",", $orderIDs) . ") AND reference_id = '" . $referenceId . "' AND status = '1'";
            $trackingData   = $this->common->gettbldata($whereCondition, "ref_value", "tb_order_references", 0, 0);
            $knTrackingNos  = array_merge($knTrackingNos, array_column($trackingData, 'ref_value'));
        }
        if ($tripNo != "" && $driver_id > 0) {
            $customerName = implode(", ", $customerNames);
            $pickUpDate   = implode(
                ", ",
                array_map(function ($date) {
                    return substr($date, 0, 10);
                }, $pickUpDates)
            );
            $bookingID    = implode(", ", $bookingIds);
            $knTrackingNo = implode(", ", $knTrackingNos);
            $message      = "New trip is assigned" . " "
                . "Pickup Date: " . $pickUpDate . " "
                . "Customer Name: " . $customerName . " "
                . "Booking ID: " . $bookingID . " "
                . "Trip No: " . $tripNo . " "
                . "KN tracking No: " . $knTrackingNo;
            $messageData = json_encode(["msg" => $message, "info" => (object) [], "type" => 1], JSON_UNESCAPED_UNICODE);
            $fire_ret    = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driver_id, 'type' => 'Driver']);
        }
        /* END of Push notification to mobile using Firebase */
        if ($order_id > 0) {
            if ($driver_id > 0) {
                $chkveh1 = "SELECT t.id,t.register_number,t.imei FROM tb_trucks_data t,tb_vehicles_drivers v WHERE t.id=v.vehicle_id AND t.status='Active' AND v.status=1 AND v.driver_id=" . $driver_id . " ORDER BY v.updatedon DESC LIMIT 1";
                $chkveh  = $this->db->query($chkveh1);
                if ($chkveh->num_rows() > 0) {
                    $register_number = $chkveh->row()->register_number;
                    $vehicle_id      = $chkveh->row()->id;
                    $imei            = $chkveh->row()->imei;
                    $chk1            = $this->db->select("id")->get_where("tb_shft_veh", ["shft_id" => $order_id], 1, 0);
                    if ($chk1->num_rows() > 0) {
                        $shftvehid = $chk1->row()->id;
                        $upd       = $this->db->where(["shft_id" => $order_id])->update("tb_shft_veh", ["vehicle_id" => $vehicle_id, "carrier_id" => $vendor_id, "register_number" => $register_number, "status" => "1", 'updated_on' => $curdt]);
                    } else {
                        $ins       = $this->db->insert("tb_shft_veh", ["user_id" => $userid, "shft_id" => $order_id, "vehicle_id" => $vehicle_id, "carrier_id" => $vendor_id, "register_number" => $register_number, "status" => "1", 'created_on' => $curdt]);
                        $shftvehid = $this->db->insert_id();
                    }
                    $getVehicleId = $this->db->select("id")->get_where("tb_vehicles_drivers", ["driver_id" => $assginedDriverId, "vehicle_id" => $assginedVehicleId], 1, 0);
                    if ($getVehicleId->num_rows() > 0) {
                        $this->db->where(["id" => $getVehicleId->row()->id])->update("tb_vehicles_drivers", ["status" => "1", "vehicle_id" => $vehicleId, 'updatedon' => $curdt]);
                    } else {
                        $this->db->insert("tb_vehicles_drivers", ["vehicle_id" => $vehicleId, "driver_id" => $driver_id, "status" => "1", 'createdon' => $curdt]);
                    }
                    /*check driver*/
                    $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id" => $assginedDriverId, "vehicle_id" => $assginedVehicleId], 1, 0);
                    if ($chk11->num_rows() > 0) {
                        $this->db->where(["id" => $chk11->row()->id])->update("tbl_assigned_drivers", ["status" => "1", "driver_id" => $driver_id, 'updated_on' => $curdt]);
                    } else {
                        $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", ["driver_id <>" => $driver_id, "vehicle_id" => $vehicle_id, "status" => 1], 1, 0);
                        if ($chk11->num_rows() == 0) {
                            $this->db->insert("tbl_assigned_drivers", ["vehicle_id" => $vehicle_id, "user_id" => $userid, "driver_id" => $driver_id, "mobile_no" => $driver_id, "imei" => $imei, "from_time" => $curdt, "to_time" => $curdt, "status" => "1", 'created_on' => $curdt]);
                        }
                    }
                    $vendors = $this->db->select("id")->get_where(
                        "tb_vendors",
                        ['id' => $vendor_id, 'tms_auto_accept' => 1],
                        1,
                        0
                    );
                    $vehar      = ['vehicle_id' => $vehicle_id, 'status' => 1];
                    $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                    $driver_id  = $chkdrivers->row()->driver_id;
                    if ($vendors->num_rows() != 0) {
                        $orderLit = $this->db->select("id")->get_where(
                            "tb_orders",
                            ['shift_id' => $order_id],
                            1,
                            0
                        );
                        if ($orderLit->num_rows() != 0) {
                            $curtzs = $this->session->userdata("usr_tzone")['timezone'];
                            if ($vehicle_id != 0 && $driver_id != 0) {
                                $this->shippeomodel->updateTrip($order_id, $vehicle_id, $driver_id, $curdt, $curtzs, $curdt);
                            }
                        }
                    }
                    $checkshifts = $this->db->select("id")->get_where(
                        "tb_trips",
                        [
                            'shift_id' => $order_id,
                        ],
                        1,
                        0
                    );
                    $curtzs = $this->session->userdata("usr_tzone")['timezone'];
                    if ($checkshifts->num_rows() != 0) {
                        $this->shippeomodel->updateTrip($order_id, $vehicle_id, $driver_id, $curdt, $curtzs, $curdt);
                    }

                    $chk = $this->db->select("id")->get_where("tb_shft_veh_emp", ["shft_veh_id" => $shftvehid, "status" => 1], 1, 0);
                    if ($chk->num_rows() == 0) {
                        $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", ["shift_id" => $order_id]);
                        if ($getemp->num_rows() > 0) {
                            $pri = 1;
                            foreach ($getemp->result() as $gt) {
                                $insveh1 = ["user_id" => $userid, "shft_veh_id" => $shftvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime];
                                $ins     = $this->db->insert("tb_shft_veh_emp", $insveh1);
                                $pri++;
                            }
                        }
                    }
                }
            }
            if ($input['rate_category'] != "") {
                $this->db->where(["shift_id" => $order_id, "status" => "1"])->update("tb_shipment_rates", ["status" => "1"]);
                $data = ['shift_id' => $order_id, 'category' => $input['rate_category'], 'rate' => $input['shipment_cost'], 'status' => 1, 'created_on' => $curdt];
                $ins  = $this->db->insert("tb_shipment_rates", $data);
            }
            $response = 1;
        }
        echo $response;
    }

    public function storeorder()
    {
        $response  = 0;
        $userid    = $this->session->userdata('user_id');
        $order_id  = @$this->input->post("id");
        $curtz     = $this->session->userdata("usr_tzone")['timezone'];
        $logdate   = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt     = $getactual['datetime'];
        $input     = $this->input->post();
        $orderid   = $this->session->userdata("usr_tzone")["country"] . time();
        $associd   = time();
        if ($input['weight'] == "") {
            $input['weight'] = 0;
        }
        // $info = $input['pickup_country']."=".$input['delivery_country']."=".$input['pickup_pincode']."=".$input['delivery_pincode']."=".$input['delivery_address']."=".$input['truck_type'];
        // $data = array('assoc_id'=>$associd, 'pickup'=>$input['pickup_location'], 'drop'=>$input['delivery_location'],'pickup_city'=>$input['pickup_location'], 'drop_city'=>$input['delivery_location'], 'pickup_datetime'=>$input['pickup_date'], 'drop_datetime'=>$input['delivery_date'], 'name'=>$input['cargo_name'], 'phone'=>'123456789', 'address'=>$input['pickup_address'], 'user_id'=>$userid, 'status'=>1, 'createdon'=>$curdt, 'material_id'=>0, 'capacity'=>$input['weight'], 'information'=>$info, 'shipment_weight'=>$input['weight'], 'shipment_volume'=>$input['volume'], 'ship_type'=>'P', 'customer_id'=>$input['customer_id'], 'startdate'=>$input['pickup_date'], 'enddate'=>$input['delivery_date'], 'shift_id'=>0, 'stop_order'=>0, 'drop_order'=>0, 'basic_stop'=>0, 'stop_id'=>0, 'drop_stopid'=>0, 'order_id'=>$orderid, 'pkgitemid'=>$input['cargo_name'], 'no_of_pkgs'=>$input['quantity'], 'domainname'=>'INFD');
        // $ins = $this->db->insert("tb_employee",$data);
        $upd = $this->db->where(["id" => $order_id])->update("tb_orders", $input);
        if ($order_id > 0) {
            $response = 1;
        }
        echo $response;
    }

    public function stopdetail()
    {
        $sid           = $this->input->post('shipment_id');
        $data["stops"] = [];
        $curtz         = $this->session->userdata("usr_tzone")['timezone'];
        $stops         = $this->db->query("SELECT id,stopname FROM tb_shiporder_stops WHERE shipment_id = '$sid' AND status='1' order by ordernumber");
       
        foreach ($stops->result() as $stop) {
            $stp["data"]    = $stop->stopname;
            $ssid           = $stop->id;
            $stp["details"] = [];
            $stop_details   = $this->db->query("SELECT * FROM (SELECT convertToClientTZ(startdate,'" . $curtz . "') as startdate,convertToClientTZ(enddate,'" . $curtz . "') as enddate,shipment_weight,shipment_volume,stop_order as iorder,pickup as addr,'p' as dtype FROM tb_employee WHERE shift_id = '$sid' AND stop_id='$ssid' AND status='1' UNION SELECT convertToClientTZ(startdate,'" . $curtz . "') as startdate,convertToClientTZ(enddate,'" . $curtz . "') as enddate,shipment_weight,shipment_volume,drop_order as iorder,`drop` as addr,'D' as dtype FROM tb_employee WHERE shift_id = '$sid' AND drop_stopid='$ssid' AND status='1') T order by iorder asc");
          
            if ($stop_details->num_rows() > 0) {
                foreach ($stop_details->result() as $stop_detail) {
                    $stp["details"][] = $stop_detail->addr . " - " . $stop_detail->dtype . " - " . $stop_detail->shipment_weight . " KG - " . $stop_detail->shipment_volume . " M<sup>3</sup> - " . date("d, M h:i a", strtotime($stop_detail->startdate ?? "")) . "M<sup>3</sup> - " . date("d, M h:i a", strtotime($stop_detail->enddate ?? ""));
                }
            }

            $data["stops"][] = $stp;
        }
       
        echo $this->load->view("shipments/stopdetail", $data, true);
    }

    public function getorderdetail()
    {
        $sid           = $this->input->post('order_id');
        $data["stops"] = $data["shipments"] = $data['orders'] = [];
        $curtz         = $this->session->userdata("usr_tzone")['timezone'];
        $stops         = $this->db->query("SELECT oc.quantity,oc.width,oc.height,oc.length,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='1'");
        foreach ($stops->result() as $stop) {
            $data["orders"][] = $stop->unit_name . "(" . $stop->quantity . ") - " . $stop->length . " M - " . $stop->width . " M - " . $stop->height . " M - " . $stop->quantity . " M<sup>3</sup>";
        }
        $shipments = $this->db->query("SELECT oc.id as order_item_id,im.unit_name,s.scity,s.dcity,convertToClientTZ(s.startdate,'" . $curtz . "') as startdate,convertToClientTZ(s.enddate,'" . $curtz . "') as enddate,s.shipmentid FROM tb_order_cargodetails oc,tbl_shipunit_types im,tb_employee e,tb_shifts s WHERE oc.order_id = '$sid' AND im.id = oc.handling_unit AND oc.status='0' AND oc.stop_detail_id = e.id AND e.shift_id = s.id");
        foreach ($shipments->result() as $shipment) {
            $data["shipments"][] = $shipment->shipmentid . " :: " . $shipment->unit_name . " " . $shipment->scity . " (" . $shipment->startdate . ") - " . $shipment->dcity . " (" . $shipment->enddate . ")";
        }
        echo $this->load->view("shipments/getorderdetail", $data, true);
    }
    
    public function freighttracker()
    {
        $shipmentid = $this->input->post("shipment_id");
        $data       = [];
        if ($shipmentid != "") {
            $this->load->model('frieghttrack');
            $chkship = $this->common->gettblrowdata(["id" => $shipmentid, "splace !=" => ""], "*", "tb_shifts", 0, 0);
            if (count($chkship) > 0) {
                $vehicle_type     = $chkship['vehicle_type'];
                $shiftLegId     = $chkship['shift_leg_id'];
                
                $register_number = $this->frieghttrack->getRegisterNumberByShipment($shipmentid);
                $containerinfo    = $this->frieghttrack->getContainerInfoByType($register_number, $vehicle_type);
                $shipmentid = !empty($shiftLegId) ? $shiftLegId : $shipmentid;
                $tot_cargos       = $this->frieghttrack->getCargoDetailsByShiftid($shipmentid);
                $data             = [];
                $data['packages'] = [];
                if (count($containerinfo) > 0) {
                    $lengthInches  = $this->frieghttrack->convertToInches($containerinfo['length'],  $containerinfo['length_unit']);
                    $breadthInches = $this->frieghttrack->convertToInches($containerinfo['breadth'], $containerinfo['breadth_unit']);
                    $heightInches  = $this->frieghttrack->convertToInches($containerinfo['height'],  $containerinfo['height_unit']);
                    
                    $data['container_data'] = [
                        "label"  => $containerinfo['register_number'],
                        "width"  => round($containerinfo['breadth']),
                        "length" => round($containerinfo['length']),
                        "height" => round($containerinfo['height']),
                        "weight" => round($containerinfo['truck_capacity']),
                    ];
                } else {
                    $data['container_data'] = [
                        "label"  => "IFNOVEHICLE",
                        "width"  => 102,
                        "length" => 576,
                        "height" => 202,
                        "weight" => 88000,
                    ];

                }
                if (count($tot_cargos) > 0) {
                    foreach ($tot_cargos as $cargo) {
                        if ($cargo->weight == "" || $cargo->weight == 0) {
                            $cargo->weight = 30;
                        }
                        $quantity = round($cargo->quantity);
                        $cargoLengthInches  = $this->frieghttrack->convertToInches($cargo->length,  $cargo->length_unit);
                        $cargoWidthInches = $this->frieghttrack->convertToInches($cargo->width, $cargo->width_unit);
                        $cargoHeightInches  = $this->frieghttrack->convertToInches($cargo->height,  $cargo->height_unit);
                        $pack     = [
                            "label"            => $cargo->cargo_content,
                            "width"            => round($cargoWidthInches),
                            "length"           => round($cargoLengthInches),
                            "height"           => round($cargoHeightInches),
                            "weight"           => round($cargo->weight / $quantity),
                            "quantity"         => $quantity,
                            "stackingcapacity" => ($cargo->stackable == 1 || $cargo->stackable == null) ? -1 : 0, //-1 for stackable(we can put one pkg on one pkg) 0 for non-stackable
                            "grounded"         => ($cargo->grounded == 1) ? true : false,                             // true for if we want to put pkg on ground of container only
                        ];
                        $data['packages'][] = $pack;
                    }
                }
            }
        }

        if (empty($data['container_data'])) {
            $data                   = [];
            $data['container_data'] = [
                "label"  => "IFNOVEHICLE",
                "width"  => 102,
                "length" => 576,
                "height" => 202,
                "weight" => 88000,
            ];
            $pack = [
                "label"            => 'Item 1',
                "width"            => 28,
                "length"           => 40,
                "height"           => 30,
                "weight"           => 34,
                "quantity"         => 4,
                "stackingcapacity" => "-1",
                "grounded"         => false,
            ];
            $data['packages'][] = $pack;
        }
        echo json_encode($data);

    }

    public function shipmentFreightTracker($shipmentid)
    {

        $data = [];
        if ($shipmentid != "") {
            $this->load->model('frieghttrack');
            $chkship = $this->common->gettblrowdata(["id" => $shipmentid, "splace !=" => ""], "*", "tb_shifts", 0, 0);
            if (count($chkship) > 0) {
                $vehicle_type     = $chkship['vehicle_type'];
                $shiftLegId     = $chkship['shift_leg_id'];
                
                $register_number = $this->frieghttrack->getRegisterNumberByShipment($shipmentid);
                $containerinfo    = $this->frieghttrack->getContainerInfoByType($register_number, $vehicle_type);
                $shipmentid = !empty($shiftLegId) ? $shiftLegId : $shipmentid;
                $tot_cargos       = $this->frieghttrack->getCargoDetailsByShiftid($shipmentid);
                $data             = [];
                $data['packages'] = [];
                if (count($containerinfo) > 0) {
                    $lengthInches  = $this->frieghttrack->convertToInches($containerinfo['length'],  $containerinfo['length_unit']);
                    $breadthInches = $this->frieghttrack->convertToInches($containerinfo['breadth'], $containerinfo['breadth_unit']);
                    $heightInches  = $this->frieghttrack->convertToInches($containerinfo['height'],  $containerinfo['height_unit']);
                    
                    $data['container_data'] = [
                        "label"  => $containerinfo['register_number'],
                        "width"  => round($breadthInches),
                        "length" => round($lengthInches),
                        "height" => round($heightInches),
                        "weight" => round($containerinfo['truck_capacity']),
                    ];
                } else {
                    $data['container_data'] = [
                        "label"  => "IFNOVEHICLE",
                        "width"  => 102,
                        "length" => 576,
                        "height" => 202,
                        "weight" => 88000,
                    ];
                }
                if (count($tot_cargos) > 0) {
                    foreach ($tot_cargos as $cargo) {
                        if ($cargo->weight == "" || $cargo->weight == 0) {
                            $cargo->weight = 30;
                        }
                        $quantity = round($cargo->quantity);
                        $cargoLengthInches  = $this->frieghttrack->convertToInches($cargo->length,  $cargo->length_unit);
                        $cargoWidthInches = $this->frieghttrack->convertToInches($cargo->width, $cargo->width_unit);
                        $cargoHeightInches  = $this->frieghttrack->convertToInches($cargo->height,  $cargo->height_unit);
                        $pack     = [
                            "label"            => $cargo->cargo_content,
                            "width"            => round($cargoWidthInches),
                            "length"           => round($cargoLengthInches),
                            "height"           => round($cargoHeightInches),
                            "weight"           => round($cargo->weight / $quantity),
                            "quantity"         => $quantity,
                            "stackingcapacity" => ($cargo->stackable == 1 || $cargo->stackable == null) ? -1 : 0, //-1 for stackable(we can put one pkg on one pkg) 0 for non-stackable
                            "grounded"         => ($cargo->grounded == 1) ? false : false,                             // true for if we want to put pkg on ground of container only
                        ];
                        $data['packages'][] = $pack;
                    }
                }
            }
        }
        if (empty($data['container_data'])) {
            $data                   = [];
            $data['container_data'] = [
                "label"  => "IFNOVEHICLE",
                "width"  => 102,
                "length" => 576,
                "height" => 202,
                "weight" => 88000,
            ];
            $quantity = round($cargo->quantity ?? 0);
            $pack     = [
                "label"            => 'Item 1',
                "width"            => 28,
                "length"           => 40,
                "height"           => 30,
                "weight"           => 34,
                "quantity"         => 4,
                "stackingcapacity" => "-1",
                "grounded"         => false,
            ];
            $data['packages'][] = $pack;
        }
       
        $this->newtemplate->dashboard("shipments/freighttracker", $data);

    }
    public function deallocateorder()
    {
        $data['status']   = $data['shipmentid']   = $pickup_drop_status   = $shiporders_status   = 0;
        $data['order_id'] = $this->input->post("orderid");
        if ($data['order_id'] > 0) {
            $order_id = $data['order_id'];
            $order    = $this->common->gettblrowdata(["id" => $order_id], "id,order_id,quantity,weight,volume,shift_id,shipmentid", "tb_orders", 0, 0);
            if (count($order) > 0) {
                $data['shipmentid'] = $order['shipmentid'];
                $shift_id           = $order['shift_id'];
                $order_id_main      = $order['order_id'];
                $company_code       = $this->session->userdata("company_code");
                if (checkAccessConditions('RELATED_2_SG_MY', $company_code)) {
                    $this->newjfrlogic_sgmy->removejfr_fordeallocatedorder($order_id);
                }
                if ($shift_id > 0) {
                    $stops_units = $this->db->query("SELECT stop_detail_id FROM tb_order_cargodetails  WHERE order_id='$order_id'  AND status='1'");
                    if ($stops_units->num_rows() > 0) {
                        foreach ($stops_units->result() as $cargo) {
                            $emp_id = $cargo->stop_detail_id;
                            if ($emp_id > 0) {
                                $getemp = $this->db->select("stop_id,drop_stopid")->get_where("tb_employee", ["id" => $emp_id, "shift_id" => $shift_id]);
                                if ($getemp->num_rows() > 0) {

                                    $stop_id           = $getemp->row()->stop_id;
                                    $drop_stopid       = $getemp->row()->drop_stopid;
                                    $stop_sts_arr      = ["shipment_id" => $shift_id, "stop_detail_id" => $emp_id, "status_id" => 1, "status" => 1];
                                    $pickdropdata      = ['stop_id' => $stop_id, 'drop_stopid' => $drop_stopid, 'shift_id' => $shift_id, 'emp_id' => $emp_id, "order_id_main" => $order_id_main];
                                    $chkpickdropstatus = $this->chkpickdropstatus($pickdropdata);
                                    $shiporders_status = $chkpickdropstatus['shiporders_status'];
                                    if ($shiporders_status != 1) {
                                        $data['status'] = 2;
                                    }
                                }
                            } else {
                                $chk_emp = $this->db->select("id,stop_id,drop_stopid")->get_where("tb_employee", ["order_id" => $order['order_id']]);
                                if ($chk_emp->num_rows() > 0) {
                                    $emp_id            = $chk_emp->row()->id;
                                    $stop_id           = $chk_emp->row()->stop_id;
                                    $drop_stopid       = $chk_emp->row()->drop_stopid;
                                    $pickdropdata      = ['stop_id' => $stop_id, 'drop_stopid' => $drop_stopid, 'shift_id' => $shift_id, 'emp_id' => $emp_id, "order_id_main" => $order_id_main];
                                    $chkpickdropstatus = $this->chkpickdropstatus($pickdropdata);
                                    $shiporders_status = $chkpickdropstatus['shiporders_status'];
                                    if ($shiporders_status != 1) {
                                        $data['status'] = 2;
                                    }
                                }

                            }
                        }
                    } else {
                        $chk_emp = $this->db->select("id,stop_id,drop_stopid")->get_where("tb_employee", ["order_id" => $order['order_id']]);
                        if ($chk_emp->num_rows() > 0) {
                            $emp_id            = $chk_emp->row()->id;
                            $stop_id           = $chk_emp->row()->stop_id;
                            $drop_stopid       = $chk_emp->row()->drop_stopid;
                            $pickdropdata      = ['stop_id' => $stop_id, 'drop_stopid' => $drop_stopid, 'shift_id' => $shift_id, 'emp_id' => $emp_id, "order_id_main" => $order_id_main];
                            $chkpickdropstatus = $this->chkpickdropstatus($pickdropdata);
                            $shiporders_status = $chkpickdropstatus['shiporders_status'];
                            if ($shiporders_status != 1) {
                                $data['status'] = 2;
                            }
                        }
                    }
                    if ($shiporders_status == 1) {
                        $data['status'] = $this->updatedeallocatedorder($order);
                    }

                }
            }
        }
        echo json_encode($data);

    }
   
    public function deleteshipment()
    {
        $shipment_id  = $data['shipmentid']  = $this->input->post("shipmentid", true);
        $setwhr       = ['shipmentid' => $shipment_id];
        $upd_shift    = ['status' => 0];
        $update_shift = $this->db->where($setwhr)->update("tb_shifts", $upd_shift);
        if ($update_shift) {
            $data['status'] = 1;
        }
        echo json_encode($data);
    }
    public function updatedeallocatedorder($order)
    {
        $status       = 0;
        $orders_count = 1;
        $shift_id     = $order['shift_id'];
        $chk_orders   = $this->db->select("id")->get_where("tb_orders", ["shift_id" => $shift_id]);
        if ($chk_orders->num_rows() > 0) {
            $orders_count = $chk_orders->num_rows();
        }
        $upd_shift           = [];
        $upd_shift['status'] = 1;
        $shipment            = $this->common->gettblrowdata(["id" => $shift_id], "weight,volume,units", "tb_shifts", 0, 0);
        if (count($shipment) > 0) {
            if ($orders_count == 1) {
                $update_emp = $this->db->where(["shipment_id" => $shift_id, "status_id" => 9, "status" => "1"])->update("tb_stop_status", ["status" => "0"]);
                $upd_shift  = ['splace' => "", 'scity' => "", 'eplace' => "", 'dcity' => "", 'slat' => 0, 'slng' => 0, 'elat' => 0, 'elng' => 0, 'weight' => 0, 'volume' => 0, 'units' => 0];
            } else {
                if ($order['weight'] > 0) {
                    $upd_shift['weight'] = ($shipment['weight'] - $order['weight']);
                }
                if ($order['volume'] > 0) {
                    $upd_shift['volume'] = ($shipment['volume'] - $order['volume']);
                }
                if ($order['quantity'] > 0) {
                    $upd_shift['units'] = ($shipment['units'] - $order['quantity']);
                }
            }
            if (! empty($upd_shift)) {
                $setwhr       = ['id' => $shift_id];
                $update_shift = $this->db->where($setwhr)->update("tb_shifts", $upd_shift);
                if ($update_shift) {
                    $updateord    = ['vendor_id' => 0, 'shift_id' => 0, 'shipmentid' => 0, 'vehicle_type' => "", 'status' => 1, 'trip_id' => 0];
                    $updwhr1      = ['id' => $order['id']];
                    $update_order = $this->db->where($updwhr1)->update("tb_orders", $updateord);
                    if ($update_order) {
                        $status = 1;
                    }
                }
            }
        }

        return $status;
    }
    public function chkpickdropstatus($pickdropdata)
    {
        $data                       = [];
        $data['pickup_drop_status'] = $data['shiporders_status'] = 0;
        if (! empty($pickdropdata)) {
            $shift_id      = $pickdropdata['shift_id'];
            $stop_id       = $pickdropdata['stop_id'];
            $drop_stopid   = $pickdropdata['drop_stopid'];
            $emp_id        = $pickdropdata['emp_id'];
            $order_id_main = $pickdropdata['order_id_main'];
            $stop_sts_arr  = ["shipment_id" => $shift_id, "stop_detail_id" => $emp_id, "status_id" => 1, "status" => 1];
            if ($stop_id > 0) {
                $stop_sts_arr['stop_id']   = $stop_id;
                $stop_sts_arr['stop_type'] = "P";
                $chk_pick_sts              = $this->db->select("id")->get_where("tb_stop_status", $stop_sts_arr);
                if ($chk_pick_sts->num_rows() > 0) {
                    $data['pickup_drop_status'] = 1;
                }
            }
            if ($drop_stopid > 0) {
                $stop_sts_arr['stop_id']   = $drop_stopid;
                $stop_sts_arr['stop_type'] = "D";
                $chk_drop_sts              = $this->db->select("id")->get_where("tb_stop_status", $stop_sts_arr);
                if ($chk_drop_sts->num_rows() > 0) {
                    $data['pickup_drop_status'] = 1;
                }
            }
            if ($data['pickup_drop_status'] == 0) {
                $update_cargo = $this->db->where(["stop_detail_id" => $emp_id, "status" => "1"])->update("tb_order_cargodetails", ["stop_detail_id" => "0"]);
                $update_emp   = $this->db->where(["order_id" => $order_id_main, "status" => "1"])->update("tb_employee", ["status" => "0", "shift_id" => "0"]);
                $update_shft  = $this->db->where(["emp_id" => $emp_id, "status" => "1"])->update("tb_shft_veh_emp", ["status" => "0"]);

                $stop_sts_arr1             = ["shipment_id" => $shift_id, "status" => 1];
                $stop_sts_arr1['stoptype'] = "P";
                $chk_drop_sts1             = $this->db->select("id")->get_where("tb_shiporder_stops", $stop_sts_arr1);
                if ($chk_drop_sts1->num_rows() > 1) {
                    $update_pickstop = $this->db->where(["id" => $stop_id, "status" => "1"])->update("tb_shiporder_stops", ["status" => "0"]);
                }

                $stop_sts_arr2             = ["shipment_id" => $shift_id, "status" => 1];
                $stop_sts_arr2['stoptype'] = "D";
                $chk_drop_sts2             = $this->db->select("id")->get_where("tb_shiporder_stops", $stop_sts_arr2);
                if ($chk_drop_sts2->num_rows() > 1) {
                    $update_dropstop = $this->db->where(["id" => $drop_stopid, "status" => "1"])->update("tb_shiporder_stops", ["status" => "0"]);

                }
                $stop_sts_arr3 = ["stop_id" => $stop_id, "drop_stopid" => $drop_stopid, "status" => "1"];
                $chk_drop_sts3 = $this->db->select("id")->get_where("tb_employee", $stop_sts_arr3);
                if ($chk_drop_sts3->num_rows() > 0) {
                    $updatepickstop = $this->db->where(["id" => $stop_id])->update("tb_shiporder_stops", ["status" => "1"]);

                    $updatedropstop = $this->db->where(["id" => $drop_stopid])->update("tb_shiporder_stops", ["status" => "1"]);
                }

                $data['shiporders_status'] = 1;

            }
        }
        return $data;
    }
    /* For notify */
    public function sendnotify($action, $orderid)
    {

        $this->load->library('notifytrigger');
        $info['page_title'] = 'Booking Notification';
        $info['subject']    = 'Booking Notification';
        if ($action != 'trip_edit') {
            $info['order_id'] = $orderid;
            $info['action']   = $action;
            $orderinfo        = $this->common->gettblrowdata(['id' => $orderid], 'order_id,shift_id', 'tb_orders', 0, 0);
            if ($orderinfo) {
                $info['orderid']  = $bookingId  = $orderinfo['order_id'];
                $info['cargos']   = $this->common->gettbldata(['order_id' => $orderid], 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
                $info['shift_id'] = $orderinfo['shift_id'];
                $shipinfo         = $this->common->gettblrowdata(['id' => $info['shift_id']], 'shipmentid', 'tb_shifts', 0, 0);
                $info['shiftid']  = (! empty($shipinfo['shipmentid'])) ? $shipinfo['shipmentid'] : '';
                $info['body']     = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $orderDetails     = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
                $info['subject']  = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
                $this->notifytrigger->sendordernotify($info);
            }
        } else {
            $info['shift_id'] = $orderid;
            $info['action']   = $action;
            $orders           = $this->common->gettbldata(['shift_id' => $orderid, 'status' => 1], 'order_id,id', 'tb_orders', 0, 0);
            $shipinfo         = $this->common->gettblrowdata(['id' => $info['shift_id']], 'shipmentid', 'tb_shifts', 0, 0);
            $info['shiftid']  = (! empty($shipinfo['shipmentid'])) ? $shipinfo['shipmentid'] : '';
            foreach ($orders as $li) {
                $info['order_id'] = $li['id'];
                $orderinfo        = $this->common->gettblrowdata(['id' => $li['id']], 'order_id', 'tb_orders', 0, 0);
                $info['orderid']  = $orderinfo['order_id'];
                $info['cargos']   = $this->common->gettbldata(['order_id' => $orderid], 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
                $info['body']     = $this->load->view('mail_forms/notifytrigger/trip_edit', $info, true);
                $this->notifytrigger->sendtripnotify($info);
            }
        }

    }
}
