<?php if (!defined('BASEPATH')) {exit('No direct script access allowed');}
/*SFTP libraries for SALog epods*/

use App\Generators\RandomString;
use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;
use App\ApiRequest\SendDocumentGateOut;

class Shipments extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('cabmodel');
        $this->load->model('common');
    }

    public function index()
    {

    }

    public function add()
    {
        $data               = array();
        $data['page_title'] = "Add Shipment";
        $data['sub_title']  = "Add Shipment";
        $this->settemplate->dashboard("shipments/add", $data);
    }

    public function save()
    {
        $post = $this->input->post();
        if ($post['from_location_id'] != "" && $post['to_location_id'] != "") {
            unset($post['addition_stop_save']);
            unset($post['special_service_save']);
            unset($post['access_code_save']);
            unset($post['eqp_grp_save']);
            $post['createdon'] = date('Y-m-d H:i:s');
            $insrt             = $this->db->insert('tb_shipment_data', $post);
            $shipid            = $this->db->insert_id();
            $request           = '';
            /*$request .= '<?xml version="1.0" encoding="UTF-8"?>';*/
            $request .= '<Transmission>';
            $request .= '<TransmissionHeader>';
            $request .= '<UserName>SGFD/SCAHY.BSCYADAV</UserName>';
            $request .= '<Password>CHANGE4ME</Password>';
            $request .= '<TransmissionType>QUERY</TransmissionType>';
            $request .= '<AckSpec>';
            $request .= '<ComMethodGid>';
            $request .= '<Gid>';
            $request .= '<Xid>EMAIL</Xid>';
            $request .= '</Gid>';
            $request .= '</ComMethodGid>';
            $request .= '<AckOption>YES</AckOption>';
            $request .= '<ContactGid>';
            $request .= '<Gid>';
            $request .= '<Xid>SGFD/SCAHY.BSCYADAV</Xid>';
            $request .= '</Gid>';
            $request .= '</ContactGid>';
            $request .= '</AckSpec>';
            $request .= '</TransmissionHeader>';
            $request .= '<TransmissionBody>';
            $request .= '<GLogXMLElement>';
            $request .= '<RemoteQuery>';
            $request .= '<RIQQuery>';
            $request .= '<RIQRequestType>All</RIQRequestType>';
            $request .= '<SourceAddress>';
            $request .= '<MileageAddress>';
            $request .= '<LocationGid>';
            $request .= '<Gid>';
            $request .= '<DomainName>SGFD/SCAHY</DomainName>';
            $request .= '<Xid>' . $post['from_location_id'] . '</Xid>';
            $request .= '</Gid>';
            $request .= '</LocationGid>';
            $request .= '<City>' . $post['from_city'] . '</City>';
            $request .= '<ProvinceCode></ProvinceCode>';
            $request .= '<PostalCode>' . $post['from_postal_code'] . '</PostalCode>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<Xid>' . $post['from_country'] . '</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';
            $request .= '</MileageAddress>';
            $request .= '</SourceAddress>';
            $request .= '<DestAddress>';
            $request .= '<MileageAddress>';
            $request .= '<LocationGid>';
            $request .= '<Gid>';
            $request .= '<DomainName>SGFD/SCAHY</DomainName>';
            $request .= '<Xid>' . $post['to_location_id'] . '</Xid>';
            $request .= '</Gid>';
            $request .= '</LocationGid>';

            $request .= '<City>'.$post['to_city'].'</City>';
            $request .= '<ProvinceCode></ProvinceCode>';
            $request .= '<PostalCode>'.$post['to_postal_code'].'</PostalCode>';
            $request .= '<CountryCode3Gid>';
            $request .= '<Gid>';
            $request .= '<Xid>'.$post['to_country'].'</Xid>';
            $request .= '</Gid>';
            $request .= '</CountryCode3Gid>';

            $request .= '</MileageAddress>';
            $request .= '</DestAddress>';
            $request .= '<Perspective>B</Perspective>';
            $request .= '<IsPreferred>N</IsPreferred>';
            $request .= '<ShipUnit>';
            $request .= '<ShipUnitCount>' . count($post['handling_unit']) . '</ShipUnitCount>';
            $request .= '<WeightVolume>';
            $request .= '<Weight>';
            $request .= '<WeightValue>' . $post['weight'] . '</WeightValue>';
            $request .= '<WeightUOMGid>';
            $request .= '<Gid>';
            $request .= '<Xid>' . $post['weight_type'] . '</Xid>';
            $request .= '</Gid>';
            $request .= '</WeightUOMGid>';
            $request .= '</Weight>';
            $request .= '<Volume>';
            $request .= '<VolumeValue>' . $post['volume'] . '</VolumeValue>';
            $request .= '<VolumeUOMGid>';
            $request .= '<Gid>';
            $request .= '<Xid>' . $post['volume_type'] . '</Xid>';
            $request .= '</Gid>';
            $request .= '</VolumeUOMGid>';
            $request .= '</Volume>';
            $request .= '</WeightVolume>';
            $request .= '</ShipUnit>';
            $request .= '</RIQQuery>';
            $request .= '</RemoteQuery>';
            $request .= '</GLogXMLElement>';
            $request .= '</TransmissionBody>';
            $request .= '</Transmission>';
            $dom = new DOMDocument;
            //$dom->preserveWhiteSpace = FALSE;
            $dom->loadXML($request);
            $dom->save('xml/example.xml');

            $serviceurl = OTM_URL;
            $headers = array('Content-Type: application/xml');
            $response = otmbookservicecurl($serviceurl,$headers,$request);
            $responsedata = $this->saveresponsedata($response, $shipid);
            redirect('shipments/show/' . $shipid);
        } else {
            redirect('shipments/add');
        }
    }

    public function show($id)
    {
        $data['shipdata']     = $this->db->get_where('tb_shipment_data', array('id' => $id), 1, 0);
        $data['shipcostdata'] = $this->db->order_by('transittime', 'ASC')->get_where('tb_shipment_response_data', array('shipment_id' => $id));
        $data['page_title']   = "Shipment Information";
        $data['sub_title']    = "Cost Information";
        $this->settemplate->dashboard("shipments/shipcostinfo", $data);
    }

    public function saveresponsedata($res, $id)
    {
        if(isset($res['Transmission'])){
            if (isset($res['Transmission']['TransmissionBody'])) {
                $shidata = $this->getshipmentcostdata($res['Transmission']['TransmissionBody']);
            } else {
                $res = $this->getshipxmldata();
                $shidata = $this->getshipmentcostdata($res['TransmissionBody']);
            }
            $response = $this->insertShipCostData($shidata, $id);
        }
    }

    public function getshipmentcostdata($data)
    {
        $res    = array();
        $others = $shipqry = $shipqryres = array();
        if (!empty($data)) {
            $qrydata = $data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RIQQuery'];
            if (!empty($qrydata)) {
                $req_type       = $qrydata['RIQRequestType'];
                $source_addr    = $qrydata['SourceAddress']['MileageAddress']['LocationGid']['Gid']['Xid'];
                $dest_addr      = $qrydata['DestAddress']['MileageAddress']['LocationGid']['Gid']['Xid'];
                $availabledate  = date('Y-m-d H:i:s', strtotime($qrydata['AvailableBy']['AvailableDate']));
                $stimezone      = $qrydata['AvailableBy']['TimeZoneGid']['Gid']['Xid'];
                $perspective    = $qrydata['Perspective'];
                $ispreferred    = $qrydata['IsPreferred'];
                $shipunitweight = $qrydata['ShipUnit']['WeightVolume']['Weight']['WeightValue'];
                $weighttype     = $qrydata['ShipUnit']['WeightVolume']['Weight']['WeightUOMGid']['Gid']['Xid'];
                $shipunitvolume = $qrydata['ShipUnit']['WeightVolume']['Volume']['VolumeValue'];
                $volumetype     = $qrydata['ShipUnit']['WeightVolume']['Volume']['VolumeUOMGid']['Gid']['Xid'];
                $shipunitcount  = $qrydata['ShipUnit']['ShipUnitCount'];
                $shipqry        = array('req_type' => $req_type, 'source_addr' => $source_addr, 'dest_addr' => $dest_addr, 'availabledate' => $availabledate, 'stimezone' => $stimezone, 'perspective' => $perspective, 'ispreferred' => $ispreferred, 'shipunitweight' => $shipunitweight, 'weighttype' => $weighttype, 'shipunitvolume' => $shipunitvolume, 'volumetype' => $volumetype, 'shipunitcount' => $shipunitcount);
            }
            $qryres = $data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RIQResult'];
            if (!empty($qryres)) {
                foreach ($qryres as $qryres1) {
                    $source_id            = isset($qryres1['SourceLocationGid']['Gid']['Xid']) ? $qryres1['SourceLocationGid']['Gid']['Xid'] : '';
                    $serviceprovideid     = isset($qryres1['ServiceProviderGid']['Gid']['Xid']) ? $qryres1['ServiceProviderGid']['Gid']['Xid'] : '';
                    $rateofferid          = isset($qryres1['RateOfferingGid']['Gid']['Xid']) ? $qryres1['RateOfferingGid']['Gid']['Xid'] : '';
                    $rategeoid            = isset($qryres1['RateGeoGid']['Gid']['Xid']) ? $qryres1['RateGeoGid']['Gid']['Xid'] : '';
                    $rateserviceid        = isset($qryres1['RateServiceGid']['Gid']['Xid']) ? $qryres1['RateServiceGid']['Gid']['Xid'] : '';
                    $transportmodeid      = isset($qryres1['TransportModeGid']['Gid']['Xid']) ? $qryres1['TransportModeGid']['Gid']['Xid'] : '';
                    $vehicletypeid        = isset($qryres1['EquipmentGroupGid']['Gid']['Xid']) ? $qryres1['EquipmentGroupGid']['Gid']['Xid'] : '';
                    $delivby = isset($qryres1['DeliveryBy']['DeliveryByDate']) ? $qryres1['DeliveryBy']['DeliveryByDate'] : date('Y-m-d H:i:s');
                    $deliveryby           = date('Y-m-d H:i:s', strtotime($delivby));
                    $deliverytz           = isset($qryres1['DeliveryBy']['TimeZoneGid']['Gid']['Xid']) ? $qryres1['DeliveryBy']['TimeZoneGid']['Gid']['Xid'] : '';
                    $pickby = isset($qryres1['PickupBy']['PickupByDate']) ? $qryres1['PickupBy']['PickupByDate'] : date('Y-m-d H:i:s');
                    $pickupby             = date('Y-m-d H:i:s', strtotime($pickby));
                    $pickuptz             = isset($qryres1['PickupBy']['TimeZoneGid']['Gid']['Xid']) ? $qryres1['PickupBy']['TimeZoneGid']['Gid']['Xid'] : '';
                    $transittime          = isset($qryres1['TransitTime']['Duration']['DurationValue']) ? $qryres1['TransitTime']['Duration']['DurationValue'] : '';
                    $timein               = isset($qryres1['TransitTime']['Duration']['DurationUOMGid']['Gid']['Xid']) ? $qryres1['TransitTime']['Duration']['DurationUOMGid']['Gid']['Xid'] : '';
                    $costcurrcode         = isset($qryres1['Cost']['FinancialAmount']['GlobalCurrencyCode']) ? $qryres1['Cost']['FinancialAmount']['GlobalCurrencyCode'] : '';
                    $costamount           = isset($qryres1['Cost']['FinancialAmount']['MonetaryAmount']) ? $qryres1['Cost']['FinancialAmount']['MonetaryAmount'] : '';
                    $ratetobase           = isset($qryres1['Cost']['FinancialAmount']['RateToBase']) ? $qryres1['Cost']['FinancialAmount']['RateToBase'] : '';
                    $fincurramount        = isset($qryres1['Cost']['FinancialAmount']['FuncCurrencyAmount']) ? $qryres1['Cost']['FinancialAmount']['FuncCurrencyAmount'] : '';
                    $totcostcurrcode      = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['GlobalCurrencyCode']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['GlobalCurrencyCode'] : '';
                    $totcostamount        = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['MonetaryAmount']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['MonetaryAmount'] : '';
                    $totratetobase        = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['RateToBase']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['RateToBase'] : '';
                    $totfincurramount     = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['FuncCurrencyAmount']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['FinancialAmount']['FuncCurrencyAmount'] : '';
                    $totweighttype        = isset($qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['WeightUOMGid']['Gid']['Xid']) ? $qryres1['TotalActualCostPerUOM']['CostPerWeightVolumeUOM']['WeightUOMGid']['Gid']['Xid'] : '';
                    $costdettype          = isset($qryres1['CostDetails']['CostType']) ? $qryres1['CostDetails']['CostType'] : '';
                    $costdetcurrcode      = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['GlobalCurrencyCode']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['GlobalCurrencyCode'] : '';
                    $costdetamount        = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['MonetaryAmount']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['MonetaryAmount'] : '';
                    $costdetratetobase    = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['RateToBase']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['RateToBase'] : '';
                    $costdetfincurramount = isset($qryres1['CostDetails']['Cost']['FinancialAmount']['FuncCurrencyAmount']) ? $qryres1['CostDetails']['Cost']['FinancialAmount']['FuncCurrencyAmount'] : '';
                    $costdetiswaighted    = isset($qryres1['CostDetails']['IsWeighted']) ? $qryres1['CostDetails']['IsWeighted'] : '';
                    $timefeasible         = isset($qryres1['IsTimeFeasible']) ? $qryres1['IsTimeFeasible'] : '';
                    $optimalresult        = isset($qryres1['IsOptimalResult']) ? $qryres1['IsOptimalResult'] : '';
                    $resperspective       = isset($qryres1['Perspective']) ? $qryres1['Perspective'] : '';
                    $distance             = isset($qryres1['Distance']['DistanceValue']) ? $qryres1['Distance']['DistanceValue'] : 0;
                    if ($distance != 0) {
                        $distancetype = isset($qryres1['Distance']['DistanceUOMGid']['Gid']['Xid']) ? $qryres1['Distance']['DistanceUOMGid']['Gid']['Xid'] : 'MI';
                    } else {
                        $distancetype = "MI";
                    }
                    $shipqryres[] = array('source_id' => $source_id, 'serviceprovideid' => $serviceprovideid, 'rateofferid' => $rateofferid, 'rategeoid' => $rategeoid, 'rateserviceid' => $rateserviceid, 'transportmodeid' => $transportmodeid, 'deliveryby' => $deliveryby, 'deliverytz' => $deliverytz, 'pickupby' => $pickupby, 'pickuptz' => $pickuptz, 'transittime' => $transittime, 'timein' => $timein, 'costcurrcode' => $costcurrcode, 'costamount' => $costamount, 'ratetobase' => $ratetobase, 'fincurramount' => $fincurramount, 'totcostcurrcode' => $totcostcurrcode, 'totcostamount' => $totcostamount, 'totratetobase' => $totratetobase, 'totfincurramount' => $totfincurramount, 'totweighttype' => $totweighttype, 'costdettype' => $costdettype, 'costdetcurrcode' => $costdetcurrcode, 'costdetamount' => $costdetamount, 'costdetratetobase' => $costdetratetobase, 'costdetfincurramount' => $costdetfincurramount, 'costdetiswaighted' => $costdetiswaighted, 'timefeasible' => $timefeasible, 'optimalresult' => $optimalresult, 'resperspective' => $resperspective, 'distance' => $distance, 'distancetype' => $distancetype, 'vehicletypeid' => $vehicletypeid);
                }
            }
            $qrystatus = isset($data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RemoteQueryStatus']) ? $data['GLogXMLElement']['RemoteQueryReply']['RIQQueryReply']['RemoteQueryStatus'] : array();
            if (!empty($qrystatus)) {
                $sts        = $qrystatus['RemoteQueryStatusCode'];
                $stssubject = $qrystatus['RemoteQueryStatusSubject'];
                $stsmsg     = $qrystatus['RemoteQueryStatusMessage'];
                $others     = array('status' => $sts, 'subject' => $stssubject, 'message' => $stsmsg);
            }
            $res = array('qrydata' => $shipqry, 'qryres' => $shipqryres, 'others' => $others);
        }
        return $res;
    }

    public function insertShipCostData($shipdata, $id)
    {
        $curdt  = date('Y-m-d H:i:s');
        $result = 0;
        if ($id > 0) {
            if (isset($shipdata['qrydata']) && isset($shipdata['qryres'])) {
                foreach ($shipdata['qryres'] as $res) {
                    $data = $shipdata['qrydata'] + $res;
                    if (isset($shipdata['others']['status'])) {
                        if ($shipdata['others']['status'] == "SUCCESS") {
                            $status = 1;
                        } else {
                            $status = 0;
                        }
                    }
                    $data['status']      = $status;
                    $data['shipment_id'] = $id;
                    $insdata             = $this->db->insert('tb_shipment_response_data', $data);
                }
            }
            $result = 1;
        }
        return $result;
    }

    public function getshipxmldata()
    {
        $request = '<Transmission>
    <TransmissionHeader>
    </TransmissionHeader>
    <TransmissionBody>
        <GLogXMLElement>
            <RemoteQueryReply>
                <RIQQueryReply>
                    <RIQQuery>
                        <RIQRequestType>LowestCost</RIQRequestType>
                        <SourceAddress>
                            <MileageAddress>
                                <LocationGid>
                                    <Gid>
                                        <DomainName>SGFD/SCAHY</DomainName>
                                        <Xid>SG10</Xid>
                                    </Gid>
                                </LocationGid>
                            </MileageAddress>
                        </SourceAddress>
                        <DestAddress>
                            <MileageAddress>
                                <LocationGid>
                                    <Gid>
                                        <DomainName>SGFD/SCAHY</DomainName>
                                        <Xid>1536792</Xid>
                                    </Gid>
                                </LocationGid>
                            </MileageAddress>
                        </DestAddress>
                        <AvailableBy>
                            <AvailableDate>20180516042335</AvailableDate>
                            <TimeZoneGid>
                                <Gid>
                                    <Xid>Asia/Singapore</Xid>
                                </Gid>
                            </TimeZoneGid>
                        </AvailableBy>
                        <Perspective>B</Perspective>
                        <IsPreferred>N</IsPreferred>
                        <ShipUnit>
                            <WeightVolume>
                                <Weight>
                                    <WeightValue>10000</WeightValue>
                                    <WeightUOMGid>
                                        <Gid>
                                            <Xid>KG</Xid>
                                        </Gid>
                                    </WeightUOMGid>
                                </Weight>
                                <Volume>
                                    <VolumeValue>100</VolumeValue>
                                    <VolumeUOMGid>
                                        <Gid>
                                            <Xid>CUCM</Xid>
                                        </Gid>
                                    </VolumeUOMGid>
                                </Volume>
                            </WeightVolume>
                            <ShipUnitCount>1</ShipUnitCount>
                        </ShipUnit>
                    </RIQQuery>
                    <RIQResult>
                        <SourceLocationGid>
                            <Gid>
                                <DomainName>SGFD/SCAHY</DomainName>
                                <Xid>SG10</Xid>
                            </Gid>
                        </SourceLocationGid>
                        <ServiceProviderGid>
                            <Gid>
                                <DomainName>SGFD/SCAHY</DomainName>
                                <Xid>HUB</Xid>
                            </Gid>
                        </ServiceProviderGid>
                        <RateOfferingGid>
                            <Gid>
                                <DomainName>SGFD/SCAHY</DomainName>
                                <Xid>HUB_TL_DAY_RO</Xid>
                            </Gid>
                        </RateOfferingGid>
                        <RateGeoGid>
                            <Gid>
                                <DomainName>SGFD/SCAHY</DomainName>
                                <Xid>HUB_TL_DAY_RR</Xid>
                            </Gid>
                        </RateGeoGid>
                        <RateServiceGid>
                            <Gid>
                                <DomainName>SGFD/SCAHY</DomainName>
                                <Xid>HUB_TL_DAY_SERVICE</Xid>
                            </Gid>
                        </RateServiceGid>
                        <TransportModeGid>
                            <Gid>
                                <Xid>TL</Xid>
                            </Gid>
                        </TransportModeGid>
                        <DeliveryBy>
                            <DeliveryByDate>20180516062335</DeliveryByDate>
                            <TimeZoneGid>
                                <Gid>
                                    <Xid>Asia/Singapore</Xid>
                                </Gid>
                            </TimeZoneGid>
                        </DeliveryBy>
                        <PickupBy>
                            <PickupByDate>20180516042335</PickupByDate>
                            <TimeZoneGid>
                                <Gid>
                                    <Xid>Asia/Singapore</Xid>
                                </Gid>
                            </TimeZoneGid>
                        </PickupBy>
                        <TransitTime>
                            <Duration>
                                <DurationValue>2.0</DurationValue>
                                <DurationUOMGid>
                                    <Gid>
                                        <Xid>H</Xid>
                                    </Gid>
                                </DurationUOMGid>
                            </Duration>
                        </TransitTime>
                        <Cost>
                            <FinancialAmount>
                                <GlobalCurrencyCode>SGD</GlobalCurrencyCode>
                                <MonetaryAmount>1.0</MonetaryAmount>
                                <RateToBase>0.5868544600938967</RateToBase>
                                <FuncCurrencyAmount>0.0</FuncCurrencyAmount>
                            </FinancialAmount>
                        </Cost>
                        <TotalActualCostPerUOM>
                            <CostPerWeightVolumeUOM>
                                <FinancialAmount>
                                    <GlobalCurrencyCode>SGD</GlobalCurrencyCode>
                                    <MonetaryAmount>0.0001</MonetaryAmount>
                                    <RateToBase>0.5868544600938967</RateToBase>
                                    <FuncCurrencyAmount>0.0</FuncCurrencyAmount>
                                </FinancialAmount>
                                <WeightUOMGid>
                                    <Gid>
                                        <Xid>KG</Xid>
                                    </Gid>
                                </WeightUOMGid>
                            </CostPerWeightVolumeUOM>
                        </TotalActualCostPerUOM>
                        <CostDetails>
                            <CostType>B</CostType>
                            <Cost>
                                <FinancialAmount>
                                    <GlobalCurrencyCode>SGD</GlobalCurrencyCode>
                                    <MonetaryAmount>1.0</MonetaryAmount>
                                    <RateToBase>0.5868544600938967</RateToBase>
                                    <FuncCurrencyAmount>0.0</FuncCurrencyAmount>
                                </FinancialAmount>
                            </Cost>
                            <IsWeighted>N</IsWeighted>
                        </CostDetails>
                        <IsTimeFeasible>Y</IsTimeFeasible>
                        <IsOptimalResult>Y</IsOptimalResult>
                        <DimWeight>
                        </DimWeight>
                        <Perspective>B</Perspective>
                        <Distance>
                            <DistanceValue>3.83</DistanceValue>
                            <DistanceUOMGid>
                                <Gid>
                                    <Xid>MI</Xid>
                                </Gid>
                            </DistanceUOMGid>
                        </Distance>
                    </RIQResult>
                    <RemoteQueryStatus>
                        <RemoteQueryStatusCode>SUCCESS</RemoteQueryStatusCode>
                        <RemoteQueryStatusSubject>SUCCESS</RemoteQueryStatusSubject>
                        <RemoteQueryStatusMessage>RATE INQUIRY PROCESSED</RemoteQueryStatusMessage>
                    </RemoteQueryStatus>
                </RIQQueryReply>
            </RemoteQueryReply>
        </GLogXMLElement>
    </TransmissionBody>
</Transmission>';
        $response = json_decode(json_encode(simplexml_load_string($request)), true);
        return $response;
    }

    public function sendEpodToSalog($orderRowId): void
    {
        if ($orderRowId == 0 || $orderRowId == '') {
            $this->session->set_flashdata('error_msg', "Please select Booking Id");
            redirect("orders/orderslist/" . $orderRowId);
        }
        $epodType = getsdtreforder($orderRowId);
        if (!in_array($epodType, ['DEL', 'PUP'])) {
            $epodType = 'DEL';
        }
        $this->load->library('salogintegrateservice');
        $salogEpodStatus = $this->salogintegrateservice->sendePodToSalog(['ord_id' => $orderRowId], $epodType);
        if ($salogEpodStatus == 1) {
            $this->session->set_flashdata('success_msg', "ePOD Sent Successfully!");
        } else {
            $this->session->set_flashdata('error_msg', "ePOD Sending failed!");
        }
        redirect("orders/orderslist/" . $orderRowId);
    }

    public function retriggerSalogStatuses(int $orderRowId): void
    {
        if ($orderRowId == 0 || $orderRowId == '') {
            $this->session->set_flashdata('error_msg', "Please select Booking Id");
            redirect("orders/orderslist/" . $orderRowId);
        }
        $salogData = $this->getOrderDetails($orderRowId);
        $this->load->library('statusintigration');
        $salogPickupStatus = $this->statusintigration->salogshipmentstatus($salogData);
        $salogData['web'] = getdatetimebytimezone($salogData['timezone'], $salogData['deliveryDate'], DFLT_TZ)['datetime'];
        $salogData['status_code'] = '2300';
        $salogDeliveryStatus = $this->statusintigration->salogshipmentstatus($salogData);
        if ($salogPickupStatus && $salogDeliveryStatus) {
            $this->session->set_flashdata('success_msg', "Statuses Triggered Successfully!");
        } else {
            $this->session->set_flashdata('error_msg', "Statuses Triggering Failed!");
        }
        redirect("orders/orderslist/" . $orderRowId);
    }

    public function retriggerEpodToRoadlog($orderRowId): void
    {
        if ($orderRowId == 0 || $orderRowId == '') {
            $this->session->set_flashdata('error_msg', "Please select Booking Id");
            redirect("orders/orderslist/" . $orderRowId);
        }
        $pupStatus = $podStatus = 0;
        $roadlogData = $this->getOrderDetails($orderRowId);
        $getDocumentType = $this->common->checkDocumentSentType($roadlogData['order_id']);
        if ($getDocumentType == 1) {
            $this->load->library('Roadlogsalogdocument');
            $podStatus = $this->roadlogsalogdocument->sendCarrierPODtoRoadlog($orderRowId,"POD", $this);
            $pupStatus = $this->roadlogsalogdocument->sendCarrierPODtoRoadlog($orderRowId,"PUP", $this);
        } else {
            $pupStatus = SendDocumentGateOut::sendepopgateoutnotify($roadlogData, $this);
            $podStatus = SendDocumentGateOut::sendepodgateoutnotify($roadlogData, $this);
        }
        if ($pupStatus == 1 && $podStatus == 0) {
            $this->session->set_flashdata('success_msg', "PUP Sent Successfully!");
        } elseif ($pupStatus == 0 && $podStatus == 1) {
            $this->session->set_flashdata('success_msg', "ePOD Sent Successfully!");
        } elseif ($pupStatus == 1 && $podStatus == 1) {
            $this->session->set_flashdata('success_msg', "PUP and POD Sent Successfully!");
        } else {
            $this->session->set_flashdata('error_msg', "ePOD Sending failed!");
        }

        redirect("orders/orderslist/" . $orderRowId);
    }

    public function retriggerRoadlogStatuses(int $orderRowId): void
    {
        if ($orderRowId == 0 || $orderRowId == '') {
            $this->session->set_flashdata('error_msg', "Please select Booking Id");
            redirect("orders/orderslist/" . $orderRowId);
        }
        $roadlogData = $this->getOrderDetails($orderRowId);
        $this->load->library('statusintigration');
        $roadlogPickupStatus = $this->statusintigration->roadlogshipmentpicked($roadlogData);
        $roadlogData['web'] = getdatetimebytimezone($roadlogData['timezone'], $roadlogData['deliveryDate'], DFLT_TZ)['datetime'];
        $roadlogData['status_code'] = '2300';
        $roadDeliveryStatus = $this->statusintigration->roadlogshipmentdelivered($roadlogData);
        if ($roadlogPickupStatus && $roadDeliveryStatus) {
            $this->session->set_flashdata('success_msg', "Statuses Triggered Successfully!");
        } else {
            $this->session->set_flashdata('error_msg', "Statuses Triggering Failed!");
        }
        redirect("orders/orderslist/" . $orderRowId);
    }

    private function getOrderDetails(int $orderRowId): array
    {
        $timezoneData = $this->session->userdata("usr_tzone");
        $timezone = $timezoneData['timezone'];
        $pickupDate = $deliveryDate = date('Y-m-d H:i:s');
        $pickupDate = getdatetimebytimezone($timezone, $pickupDate, DFLT_TZ)['datetime'];
        $this->load->model('Roadlogtosalogmodel');
        $orderStatusData = $this->Roadlogtosalogmodel->getPickupAndDeliveryStatuses($orderRowId);
        foreach ($orderStatusData as $eachStatusData) {
            if ($eachStatusData['status_code'] == '0500') {
                $pickupDate = $eachStatusData['createdon'];
            }
            if ($eachStatusData['status_code'] == '2300') {
                $deliveryDate = $eachStatusData['createdon'];
            }
            $bookingId = $eachStatusData['order_id'];
            $shiftId = $eachStatusData['shift_id'];
            $tripId = $eachStatusData['trip_id'];
        }
        $countryHours = $timezoneData['hrs'];
        return [
            'shipment_id' => $shiftId ?? 0,
            'trip_id' => $tripId ?? 0,
            'order_id' => $bookingId ?? '',
            'curtz' => $timezone,
            'hrs' => $countryHours,
            'web' => getdatetimebytimezone($timezone, $pickupDate, DFLT_TZ)['datetime'],
            'status_code' => '0500',
            'ord_id' => $orderRowId,
            'driver_id' => '',
            'stop_id' => '',
            'deliveryDate' => $deliveryDate,
            'timezone' => $timezone
        ];
    }


}
