<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Shipmentxmldata extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['Order', 'common']);
        $this->load->library('knlogin');
    }

    public function shipmentxml($id)
    {
        $companyCode = $this->session->userdata('company_code');
        $timeZoneHours = $this->session->userdata("usr_tzone")['hrs'];
        $countryName = $this->session->userdata("usr_tzone")['country_name'];
        $countryCode = $this->session->userdata("usr_tzone")['country'];
        $countries = $finalCountries = $carrierDetails = $packageCodes = $pdetail = $references = $shipperReferences = [];
        $LogicalReceiver = "WWWWW99";
        $checkPfs = 0;
        if ($id != "") {
            $getPackageCode = $this->common->gettbldata("unit_code IS NOT NULL ", "unit_name,unit_code,description", "tb_handling_units", 0, 0);
            foreach ($getPackageCode as $singlePackageCode) {
                $packageCodes[$singlePackageCode['description']] = $packageCodes[$singlePackageCode['unit_name']] = $packageCodes[$singlePackageCode['unit_code']] = $singlePackageCode['unit_code'];
            }
            $getOrderDetails = $this->common->gettblrowdata(['id' => $id], "id,order_id,pickup_datetime,pickup_endtime,shipment_id,delivery_datetime,drop_endtime,pickup_company,delivery_company,pickup_address1,delivery_address1,pickup_address2,delivery_address2,pickup_city,delivery_city,pickup_country,delivery_country,pickup_pincode,delivery_pincode,company_code,branch_code,product,transport_mode,vehicle_type,customer_id,createdon,shipmentid", "tb_orders", 0, 0);
            if (!empty($getOrderDetails)) {
                $orderRowId = $getOrderDetails['id'];
                $customerRowId = $getOrderDetails['customer_id'];
                $checkBeforeSending = $this->common->gettblrowdata(['id' => $customerRowId, 'sendto_knlogin' => '1'], "id", "tb_customers", 0, 0);
                if (!empty($checkBeforeSending)) {
                    $partyTypes = $this->Order->getOrderParties($orderRowId);
                    foreach ($partyTypes as $eachType) {
                        $partyType = $eachType['party_type_name'];
                        $partyTypeCode = "";
                        if ($partyType == "FREIGHT_PAYER") {
                            $partyTypeCode = "PF";
                            $checkPfs = 1;
                        } elseif ($partyType == "Customer") {
                            $partyTypeCode = "PF";
                            $checkPfs = 1;
                        } elseif ($partyType == "Shipper") {
                            $partyTypeCode = "Shipper";
                        } elseif ($partyType == "Consignee") {
                            $partyTypeCode = "Consignee";
                        } elseif ($partyType == "Carrier") {
                            $carrierDetails = ['type' => 'Carrier', 'name' => $eachType['name'], 'cust_id' => $eachType['code'], 'pincode' => $eachType['pincode'], 'country' => strtoupper($eachType['country']), 'street' => $eachType['street'], 'city' => $eachType['location_id'], 'state' => $eachType['state'], 'party_id' => $eachType['partyindetifier'], 'email' => $eachType['email']];
                        }
                        $countries[] = strtoupper($eachType['country']);
                        $pdetail[] = ['type' => $partyTypeCode, 'name' => $eachType['name'], 'cust_id' => $eachType['code'], 'pincode' => $eachType['pincode'], 'country' => strtoupper($eachType['country']), 'street' => $eachType['street'], 'city' => $eachType['location_id'], 'state' => $eachType['state'], 'party_id' => $eachType['partyindetifier']];
                    }
                    if ($checkPfs == 0) {
                        $customerId = $getOrderDetails['customer_id'];
                        $getCustomerDetails = $this->common->gettblrowdata(["status" => 1, "id" => $customerId], "id,name,code,company_code,branch_code,state,street,location,pincode,address,code,country", "tb_customers", 0, 0);
                        if (!empty($getCustomerDetails)) {
                            $countries[] = strtoupper($getCustomerDetails['country']);
                            $pdetail[] = ['type' => 'PF', 'name' => $getCustomerDetails['name'], 'cust_id' => $getCustomerDetails['code'], 'address' => $getCustomerDetails['address'], 'pincode' => $getCustomerDetails['pincode'], 'country' => strtoupper($getCustomerDetails['country']), 'street' => $getCustomerDetails['street'], 'city' => $getCustomerDetails['location'], 'state' => $getCustomerDetails['state'], 'party_id' => $getCustomerDetails['code']];
                        }
                    }
                    $countries[] = strtoupper($getOrderDetails['pickup_country']);
                    $countries[] = strtoupper($getOrderDetails['delivery_country']);
                    if (!empty($countries)) {
                        $countries = array_unique($countries);
                        $finalCountries = $this->Order->getCountryCodesFromMaster($countries);
                    }
                    $cargos = [];
                    $totalVolume = $totalWeight = $totalQuantity = 0;
                    $getcargos = $this->common->gettbldata(["order_id" => $id, 'status' => '1'], "cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content", "tb_order_cargodetails", 0, 0);
                    foreach ($getcargos as $cargores) {
                        $volume = $cargores['volume'] ?: "1";
                        $weight = $cargores['weight'] ?: "1";
                        $weight_unit = "KG";
                        $volume_unit = "CBM";
                        $length_unit = $width_unit = $height_unit = "CM";
                        if ($cargores['cargo_id'] != "") {
                            $chk = $this->common->gettblrowdata(["id" => $cargores['cargo_id']], "length_unit,width_unit,height_unit,weight_unit,volume_unit", "tb_cargo_details", 0, 0);
                            if (!empty($chk)) {
                                $weight_unit = $chk['weight_unit'];
                                $volume_unit = $chk['volume_unit'];
                                $length_unit = $chk['length_unit'];
                                $width_unit = $chk['width_unit'];
                                $height_unit = $chk['height_unit'];
                            }
                        }
                        if ($length_unit == 'M') {
                            $cargores['length'] *= 100;
                        }
                        if ($width_unit == 'M') {
                            $cargores['width'] *= 100;
                        }
                        if ($height_unit == 'M') {
                            $cargores['height'] *= 100;
                        }
                        if ($length_unit == 'Inches') {
                            $cargores['length'] *= 2.54;
                        }
                        if ($width_unit == 'Inches') {
                            $cargores['width'] *= 2.54;
                        }
                        if ($height_unit == 'Inches') {
                            $cargores['height'] *= 2.54;
                        }
                        $content = $cargores['cargo_content'] ?? "";
                        $cargos[] = ['cargo_type' => $cargores['quantity_type'], 'content' => $content, 'length' => $cargores['length'], 'width' => $cargores['width'], 'height' => $cargores['height'], 'weight' => $weight, 'volume' => $volume, 'quantity' => $cargores['quantity'], 'weight_unit' => $weight_unit, 'volume_unit' => $volume_unit, 'height_unit' => $height_unit, 'length_unit' => $length_unit, 'width_unit' => $width_unit];

                        $totalVolume += $volume;
                        $totalWeight += $weight;
                        $totalQuantity += $cargores['quantity'];
                    }
                    $companyCode = $getOrderDetails['company_code'];
                    $branchCode = $getOrderDetails['branch_code'];
                    $shipmentRowId = $getOrderDetails['shipment_id'];
                    $logicalSender = $incoterm = '';
                    $logicalinfo = $this->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode], "logical_sender", "tb_branch_master", 0, 0);
                    if (!empty($logicalinfo)) {
                        $logicalSender = $logicalinfo['logical_sender'];
                    }
                    if ($shipmentRowId > 0) {
                        $chekShipment = $this->common->gettblrowdata(['id' => $shipmentRowId], "logicalreceiver,incoterm", "tb_shipments", 0, 0);
                        if (!empty($chekShipment)) {
                            if ($chekShipment['logicalreceiver'] != "") {
                                $LogicalReceiver = $chekShipment['logicalreceiver'];
                                $incoterm = $chekShipment['incoterm'];
                            }
                        }
                    }
                    $checkReference = $this->common->gettbldata(['order_id' => $id, 'status' => '1'], "reference_id,ref_value", "tb_order_references", 0, 0);
                    foreach ($checkReference as $eachreference) {
                        $referenceId = $eachreference['reference_id'];
                        if (strlen($referenceId) == 2) {
                            $references[] = ["id" => $eachreference['reference_id'], "value" => $eachreference['ref_value']];
                        } else {
                            $shipperReferences[] = ['id' => $referenceId, 'value' => $eachreference['ref_value']];
                        }
                    }
                    $product = $getOrderDetails['product'];
                    if ($product == "") {
                        $product = "KN AsiaDirect";
                    }
                    $serviceType = "";
                    $getService = $this->common->gettblrowdata(["order_row_id" => $id], "service", "tb_order_details", 0, 0);
                    if (!empty($getService)) {
                        $serviceId = $getService['service'];
                        if ($serviceId > 0) {
                            $getServiceName = $this->common->gettblrowdata(["id" => $serviceId], "name", "tb_service_master", 0, 0);
                            if (!empty($getServiceName)) {
                                $serviceType = $getServiceName['name'];
                            }
                        }
                    }

                    $transportMode = 1;
                    $orderTranportMode = $getOrderDetails['transport_mode'];
                    if ($orderTranportMode == "LTL") {
                        $transportMode = 0;
                    }
                    $orderVehicleType = $getOrderDetails['vehicle_type'];
                    if ($orderVehicleType == "") {
                        $orderVehicleType = "F";
                    }
                    $PhysicalSender = 'KNRLG09';
                    $PhysicalReceiver = 'WWDPT01';
                    if (SYS_TYPE == 'TMS') {
                        $PhysicalSender = 'KNRLG01';
                        $PhysicalReceiver = 'WWDPP01';
                    }
                    $data = [
                        'SenderTransmissionNo' => $getOrderDetails['order_id'],
                        'pickup_datetime' => $getOrderDetails['pickup_datetime'],
                        'delivery_datetime' => $getOrderDetails['delivery_datetime'],
                        'pickup_endtime' => $getOrderDetails['pickup_endtime'],
                        'delivery_endtime' => $getOrderDetails['drop_endtime'],
                        'createdon' => $getOrderDetails['createdon'],
                        "delivery_company" => $getOrderDetails['delivery_company'],
                        'delivery_city' => $getOrderDetails['delivery_city'],
                        'delivery_country' => $finalCountries[strtoupper($getOrderDetails['delivery_country'])] ?? $getOrderDetails['delivery_country'],
                        'delivery_address1' => $getOrderDetails['delivery_address1'],
                        'delivery_address2' => $getOrderDetails['delivery_address2'],
                        'delivery_pincode' => $getOrderDetails['delivery_pincode'],
                        'branch_code' => $branchCode,
                        'company_code' => $companyCode,
                        'transport_mode' => $getOrderDetails['transport_mode'],
                        'pickup_country' => $finalCountries[strtoupper($getOrderDetails['pickup_country'])] ?? $getOrderDetails['pickup_country'],
                        'pickup_pincode' => $getOrderDetails['pickup_pincode'],
                        "pickup_company" => $getOrderDetails['pickup_company'],
                        'pickup_city' => $getOrderDetails['pickup_city'],
                        'pickup_address1' => $getOrderDetails['pickup_address1'],
                        'pickup_address2' => $getOrderDetails['pickup_address2'],
                        'cargos' => $cargos,
                        'weight' => $totalWeight,
                        'total_volume' => $totalVolume,
                        "vehicle_type" => $orderVehicleType,
                        "parties" => $pdetail,
                        "physicalreceiver" => $PhysicalReceiver,
                        "logicalreceiver" => $LogicalReceiver,
                        "physicalsender" => $PhysicalSender,
                        "logicalsender" => $logicalSender,
                        "quantity" => $totalQuantity,
                        "freight_term" => "",
                        "freight_termname" => "",
                        "product" => $product,
                        "service_type" => $serviceType,
                        "hrs" => $timeZoneHours,
                        't_mode' => $transportMode,
                        'country_name' => $countryName,
                        "cntrycode" => $countryCode,
                        'shipmentid' => $getOrderDetails['shipmentid'],
                        'carrierDetails' => $carrierDetails,
                        'packageCodes' => $packageCodes,
                        'finalCountries' => $finalCountries,
                        'shipperReferences' => $shipperReferences,
                        'refs' => $references,
                        'incoterm' => $incoterm
                    ];
                    $this->knlogin->sendKNloginOrderxmlservice($data);
                    $upd = $this->common->updatetbledata("tb_orders", ["is_created" => 2], ["id" => $id]);
                }
            }
        }
    }

    public function sendOrderStatusXmlstoKNlogin()
    {
        $post = $this->input->post(null, true);
        $notSentOrders = $ordersToSent = $orderIds = $inTransitData = $orderRowIds = $statusIds = $orderStatusIds = $sentOrders = $statusOrders = [];
        $currentDate = date('Y-m-d H:i:s');
        $updatedDate = date('Y-m-d\TH:i:s', strtotime($currentDate));
        $checkOrders = $this->Order->checkMyknCustomerFromOrders(
            "o.id,
             o.order_id,
             o.pickup_city,
             o.delivery_city,
             o.user_id,
             o.company_code,
             o.branch_code,
             o.modeoftransport,
             o.shift_id,
             o.trip_id,
             o.shipmentid,
             o.is_created,
             o.shift_id,
             c.name,
             c.sendto_knlogin,
             d.department_code",
            $post['ids']
        );
        if (!empty($checkOrders)) {
            $companyCode = $this->session->userdata('company_code');
            $branchCode = $this->session->userdata('branch_code');
            $hours = $this->session->userdata("usr_tzone")['hrs'];
            $timeZoneHours = str_replace(".", ":", $hours);
            $timeZone = $this->session->userdata("usr_tzone")['timezone'];
            $LogicalReceiver = "WWWWW99";
            $PhysicalReceiver = 'WWDPT01';
            $PhysicalSender = 'KNRLG09';
            if (SYS_TYPE == 'TMS') {
                $PhysicalReceiver = 'WWDPP01';
                $PhysicalSender = 'KNRLG01';
            }
            $logicalinfo = $this->common->gettblrowdata(['company_code' => $companyCode, 'branch_code' => $branchCode], "logical_sender", "tb_branch_master", 0, 0);
            $logicalSender = $logicalinfo['logical_sender'] ?: "THPNA74";
            foreach ($checkOrders as $eachOrder) {
                if ($eachOrder['sendto_knlogin'] == 1) {
                    if ($eachOrder['shift_id'] > 0) {
                        if ($eachOrder['is_created'] == 2) {
                            $orderIds[] = $eachOrder['id'];
                            $ordersToSent[$eachOrder['id']] = [
                                'id' => $eachOrder['id'],
                                'order_id' => $eachOrder['order_id'],
                                'pickup_city' => $eachOrder['pickup_city'],
                                'delivery_city' => $eachOrder['delivery_city'],
                                'company_code' => $eachOrder['company_code'],
                                'branch_code' => $eachOrder['branch_code'],
                                'modeoftransport' => $eachOrder['modeoftransport'],
                                'shift_id' => $eachOrder['shift_id'],
                                'trip_id' => $eachOrder['trip_id'],
                                'shipmentid' => $eachOrder['shipmentid']
                            ];
                        } else {
                            $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Order is not Sent To Knlogin', 'status' => 0];
                        }
                    } else {
                        $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Trip is not created for Order', 'status' => 0];
                    }
                } else {
                    $notSentOrders[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'], 'message' => 'Send To KnLogin not enabled', 'status' => 0];
                }
            }
            if (!empty($orderIds)) {
                $getStops = $this->Order->getOrderDetailsWithStopsStatus($orderIds);
                foreach ($getStops as $eachStopId) {
                    if ($eachStopId["driver_id"] != "") {
                        $statusIds[] = $eachStopId['id'];
                    } else {
                        $orderStatusIds[] = $eachStopId['id'];
                    }
                    $orderRowId = $eachStopId['order_id'];
                    if (!in_array($eachStopId['order_id'], $statusOrders, true)) {
                        $statusOrders[] = $eachStopId['order_id'];
                    }
                    $getactual = getdatetimebytimezone($timeZone, $eachStopId['createdon'], DFLT_TZ);
                    $createdon = $getactual['datetime'];
                    $date = $getactual['date'];
                    $time = $getactual['time'] . "" . $timeZoneHours;
                    $statusDateTime = date('Y-m-d\TH:i:s', strtotime($createdon)) . "" . $timeZoneHours;
                    $statusToBeSent = [
                        "shipment_id" => $ordersToSent[$orderRowId]['shipmentid'] ?? "",
                        "shipmentid" => $ordersToSent[$orderRowId]['shipmentid'] ?? "",
                        "latitude" => $eachStopId['latitude'] ?? "",
                        "longitude" => $eachStopId['longitude'] ?? "",
                        "status_code" => $eachStopId['status_code'] ?? "",
                        "status_location" => $eachStopId['loc_name'] ?? "",
                        "company_code" => $companyCode,
                        "branch_code" => $ordersToSent[$orderRowId]['branch_code'] ?? "",
                        "pickup_city" => $ordersToSent[$orderRowId]['pickup_city'] ?? "",
                        "delivery_city" => $ordersToSent[$orderRowId]['delivery_city'] ?? "",
                        "logicalreceiver" => $LogicalReceiver,
                        "physicalreceiver" => $PhysicalReceiver,
                        "physicalsender" => $PhysicalSender,
                        "logicalsender" => $logicalSender,
                        "modeoftransport" => $ordersToSent[$orderRowId]['modeoftransport'] ?? "",
                        "department_code" => $ordersToSent[$orderRowId]['department_code'] ?? "",
                        "trackingnumber" => $ordersToSent[$orderRowId]['order_id'] ?? "",
                        "ref_id" => "INN",
                        "ref_num" => "RL" . $ordersToSent[$orderRowId]['order_id'] ?? "",
                        "createdon" => $createdon,
                        "date" => $date,
                        "time" => $time,
                        'curdt' => $statusDateTime,
                        'curdt1' => $updatedDate,
                        "order_id" => $ordersToSent[$orderRowId]['order_id'] ?? "",
                        "createdon"=> '',

                    ];
                    $getmyknstatuscodes = $this->db->select("mykn_status_code")->get_where("tb_statuscodes_reference", ["svk_status_code" => $eachStopId['status_code']], 1, 0);
                    if ($getmyknstatuscodes->num_rows() > 0) {
                        $eachStopId['status_code'] = $getmyknstatuscodes->row()->mykn_status_code;
                    }
                    if ($eachStopId['status_code'] != '1550') {
                        $this->knlogin->knloginsendorderstatus($statusToBeSent);
                    } else {
                        $inTransitData[$eachStopId['id']] = (object) $statusToBeSent;
                        if (!in_array($eachStopId['order_id'], $orderRowIds, true)) {
                            $orderRowIds[] = $eachStopId['order_id'];
                        }
                    }
                }
                if (!empty($inTransitData)) {
                    $this->knlogin->sendHighestIntransitStatusFORCNTW($inTransitData, $orderRowIds, ['companyCode' => $companyCode, 'branchCode' => $branchCode, 'timeZone' => $timeZone, 'updatedDate' => $updatedDate, 'hours' => $timeZoneHours]);
                }
                if (!empty($statusOrders)) {
                    foreach ($statusOrders as $eachOrder) {
                        $sentOrders[] = ['orderId' => $ordersToSent[$eachOrder]['order_id'] ?? "", 'customer' => $ordersToSent[$eachOrder]['name'] ?? "", 'message' => 'Sent to myKN', 'status' => 1];
                    }
                } else {
                    $notSentOrders[] = ['orderId' => '-', 'customer' => '-', 'message' => 'There are no statuses to send for myKN', 'status' => 1];
                }
            }
            if (!empty($statusIds)) {
                $updateQuery = $this->common->updatetbledata("tb_stop_status", ["sentknlogin" => 1], "id IN (" . implode(',', $statusIds) . ")");
            }
            if(!empty($orderStatusIds))
                $this->common->updatetbledata("tb_order_status", ["sentknlogin" => 1], "id IN (" . implode(',', $orderStatusIds) . ")");
            }

        $excelResponse = array_merge($sentOrders, $notSentOrders);
        if (!empty($excelResponse)) {
            @file_put_contents("assets/ordertemplate/exceluploaddata.txt", json_encode($excelResponse));
        }
        echo "1";
    }

    public function SendMultipleOrdersTomyKN(): void
    {
        $timeZoneHours = $this->session->userdata("usr_tzone")['hrs'];
        $countryName = $this->session->userdata("usr_tzone")['country_name'];
        $countryCode = $this->session->userdata("usr_tzone")['country'];
        $countries = $finalCountries = $carrierDetails = $packageCodes = $references = $shipperReferences = [];
        $post = $this->input->post(null, true);
        $checkOrders = $this->Order->checkMyknCustomerFromOrders(
            "o.id,
             o.order_id,
             o.pickup_datetime,
             o.pickup_endtime,
             o.delivery_datetime,
             o.drop_endtime,
             o.pickup_company,
             o.delivery_company,
             o.pickup_country,
             o.delivery_country,
             o.pickup_city,
             o.delivery_city,
             o.pickup_pincode,
             o.delivery_pincode,
             o.pickup_address1,
             o.delivery_address1,
             o.pickup_address2,
             o.delivery_address2,
             o.transport_mode,
             o.vehicle_type,
             o.user_id,
             o.company_code,
             o.branch_code,
             o.product,
             o.createdon,
             o.shipmentid,
             o.modeoftransport,
             o.shift_id,
             o.trip_id,
             o.shipmentid,
             o.is_created,
             o.shift_id,
             c.name,
             c.location,
             c.address,
             c.pincode,
             c.code,
             c.country,
             c.state,
             c.street,
             c.sendto_knlogin,
             d.service,
             d.incoterm,
             d.department_code",
            $post['ids']
        );
        $checkPfs = 0;
        $OrdersNotToSent = $ordersToSent = [];
        if (!empty($checkOrders)) {
            foreach ($checkOrders as $eachOrder) {
                if ($eachOrder['sendto_knlogin'] != 1) {
                    $OrdersNotToSent[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'] ?? "", 'message' => 'myKN Not enabled for Customer', 'status' => 0];
                    continue;
                }
                $orderIds[] = $eachOrder['id'];
                $ordersToSent[] = ['orderId' => $eachOrder['order_id'], 'customer' => $eachOrder['name'] ?? "", 'message' => 'Sent to myKN', 'status' => 1];
                $branchCodes[] = $eachOrder['branch_code'];
                if ($eachOrder['service'] > 0) {
                    $serviceIds[] = $eachOrder['service'];
                }
            }
            if (!empty($orderIds ?? [])) {
                $getPackageCode = $this->common->gettbldata("unit_code IS NOT NULL ", "unit_name,unit_code,description", "tb_handling_units", 0, 0);
                foreach ($getPackageCode as $singlePackageCode) {
                    $packageCodes[$singlePackageCode['description']] = $packageCodes[$singlePackageCode['unit_name']] = $packageCodes[$singlePackageCode['unit_code']] = $singlePackageCode['unit_code'];
                }
                $partyTypesData = $this->Order->getOrderParties(0, $orderIds);
                foreach ($partyTypesData as $eachRow) {
                    $allPartyTypes[$eachRow['order_id']][] = $eachRow;
                }
                $getallOrdersCargosDetails = $this->common->gettbldata("order_id IN ('" . implode("','", $orderIds) . "') AND status ='1'", "order_id,cargo_id,handling_unit,length,width,height,weight,volume,quantity,quantity_type,cargo_content", "tb_order_cargodetails", 0, 0);
                foreach ($getallOrdersCargosDetails as $eachRow) {
                    $allCargoDetails[$eachRow['order_id']][] = $eachRow;
                    if ($eachRow['cargo_id'] > 0) {
                        $cargoIds[] = $eachRow['cargo_id'];
                    }
                }
                if (!empty($cargoIds ?? [])) {
                    $getCargoUnits = $this->common->gettbldata("id IN ('" . implode("','", $cargoIds) . "') AND status ='1'", "id,length_unit,width_unit,height_unit,weight_unit,volume_unit", "tb_cargo_details", 0, 0);
                    foreach ($getCargoUnits as $eachRow) {
                        $allCargoUnitsData[$eachRow['id']] = ['weightUnit' => $eachRow['weight_unit'], 'volumeUnit' => $eachRow['volume_unit'], 'lengthUnit' => $eachRow['length_unit'], 'widthUnit' => $eachRow['width_unit'], 'heightUnit' => $eachRow['height_unit']];
                    }
                }

                $checkReference = $this->common->gettbldata("order_id IN ('" . implode("','", $orderIds) . "') AND status ='1'", "order_id,reference_id,ref_value", "tb_order_references", 0, 0);
                foreach ($checkReference as $eachRow) {
                    if (strlen($eachRow['reference_id']) == 2) {
                        $allReferences[$eachRow['order_id']][] = ["id" => $eachRow['reference_id'], "value" => $eachRow['ref_value']];
                    } else {
                        $allShipperReferences[$eachRow['order_id']][] = ['id' => $eachRow['reference_id'], 'value' => $eachRow['ref_value']];
                    }
                }
                if (!empty($branchCodes ?? [])) {
                    $branchCodes = array_unique($branchCodes);
                    $getLogicalSenderInformation = $this->common->gettbldata("branch_code IN ('" . implode("','", $branchCodes) . "') AND status ='1'", "branch_code,company_code,logical_sender", "tb_branch_master", 0, 0);
                    foreach ($getLogicalSenderInformation as $eachRow) {
                        $logicalSenderInfo[$eachRow['branch_code']] = $eachRow['logical_sender'];
                    }
                }
                if ($serviceIds ?? []) {
                    $getServiceIds = $this->common->gettbldata("id IN ('" . implode("','", $serviceIds) . "') ", "id,name", "tb_service_master", 0, 0);
                    foreach ($getServiceIds as $eachRow) {
                        $serviceNames[$eachRow['id']] = $eachRow['name'];
                    }
                }
                foreach ($checkOrders as $eachOrder) {
                    if ($eachOrder['sendto_knlogin'] != 1) {
                        continue;
                    }
                    $orderRowId = $eachOrder['id'];
                    $partyTypes = $allPartyTypes[$orderRowId] ?? [];
                    foreach ($partyTypes as $eachType) {
                        $partyType = $eachType['party_type_name'];
                        $partyTypeCode = "";
                        if ($partyType == "FREIGHT_PAYER") {
                            $partyTypeCode = "PF";
                            $checkPfs = 1;
                        } elseif ($partyType == "Customer") {
                            $partyTypeCode = "PF";
                            $checkPfs = 1;
                        } elseif ($partyType == "Shipper") {
                            $partyTypeCode = "Shipper";
                        } elseif ($partyType == "Consignee") {
                            $partyTypeCode = "Consignee";
                        } elseif ($partyType == "Carrier") {
                            $carrierDetails = ['type' => 'Carrier', 'name' => $eachType['name'], 'cust_id' => $eachType['code'], 'pincode' => $eachType['pincode'], 'country' => strtoupper($eachType['country']), 'street' => $eachType['street'], 'city' => $eachType['location_id'], 'state' => $eachType['state'], 'party_id' => $eachType['partyindetifier'], 'email' => $eachType['email']];
                        }
                        $countries[] = strtoupper($eachType['country']);
                        $partnerDetails[] = ['type' => $partyTypeCode, 'name' => $eachType['name'], 'cust_id' => $eachType['code'], 'pincode' => $eachType['pincode'], 'country' => strtoupper($eachType['country']), 'street' => $eachType['street'], 'city' => $eachType['location_id'], 'state' => $eachType['state'], 'party_id' => $eachType['partyindetifier']];
                    }
                    if ($checkPfs == 0) {
                        $countries[] = strtoupper($eachOrder['country']);
                        $partnerDetails[] = ['type' => 'PF', 'name' => $eachOrder['name'], 'cust_id' => $eachOrder['code'], 'address' => $eachOrder['address'], 'pincode' => $eachOrder['pincode'], 'country' => strtoupper($eachOrder['country']), 'street' => $eachOrder['street'], 'city' => $eachOrder['location'], 'state' => $eachOrder['state'], 'party_id' => $eachOrder['code']];
                    }
                    $countries[] = strtoupper($eachOrder['pickup_country']);
                    $countries[] = strtoupper($eachOrder['delivery_country']);
                    if (!empty($countries)) {
                        $countries = array_unique($countries);
                        $finalCountries = $this->Order->getCountryCodesFromMaster($countries);
                    }
                    $cargoDetails = $allCargoDetails[$orderRowId] ?? [];
                    $totalVolume = $totalWeight = $totalQuantity = 0;
                    foreach ($cargoDetails as $eachCargo) {
                        $volume = $eachCargo['volume'] ?: "1";
                        $weight = $eachCargo['weight'] ?: "1";
                        $weight_unit = "KG";
                        $volume_unit = "CBM";
                        $cargoUnits = $allCargoUnitsData[$eachCargo['cargo_id']] ?? [];
                        $length_unit = $cargoUnits['lengthUnit'] ?? "CM";
                        $width_unit = $cargoUnits['widthUnit'] ?? "CM";
                        $height_unit = $cargoUnits['heightUnit'] ?? "CM";
                        if ($length_unit == 'M') {
                            $eachCargo['length'] *= 100;
                        }
                        if ($width_unit == 'M') {
                            $eachCargo['width'] *= 100;
                        }
                        if ($height_unit == 'M') {
                            $eachCargo['height'] *= 100;
                        }
                        if ($length_unit == 'Inches') {
                            $eachCargo['length'] *= 2.54;
                        }
                        if ($width_unit == 'Inches') {
                            $eachCargo['width'] *= 2.54;
                        }
                        if ($height_unit == 'Inches') {
                            $eachCargo['height'] *= 2.54;
                        }
                        $content = $eachCargo['cargo_content'] ?? "";
                        $cargos[] = ['cargo_type' => $eachCargo['quantity_type'], 'content' => $content, 'length' => $eachCargo['length'], 'width' => $eachCargo['width'], 'height' => $eachCargo['height'], 'weight' => $weight, 'volume' => $volume, 'quantity' => $eachCargo['quantity'], 'weight_unit' => $weight_unit, 'volume_unit' => $volume_unit, 'height_unit' => $height_unit, 'length_unit' => $length_unit, 'width_unit' => $width_unit];
                        $totalVolume += $volume;
                        $totalWeight += $weight;
                        $totalQuantity += $eachCargo['quantity'];
                    }
                    $orderTranportMode = $eachOrder['transport_mode'];
                    $transportMode = $orderTranportMode == "LTL" ? "0" : "1";
                    $PhysicalSender = SYS_TYPE == "TMS" ? "KNRLG01" : 'KNRLG09';
                    $PhysicalReceiver = SYS_TYPE == "TMS" ? "WWDPP01" : 'WWDPT01';
                    $data = [
                        'SenderTransmissionNo' => $eachOrder['order_id'],
                        'pickup_datetime' => $eachOrder['pickup_datetime'],
                        'delivery_datetime' => $eachOrder['delivery_datetime'],
                        'pickup_endtime' => $eachOrder['pickup_endtime'],
                        'delivery_endtime' => $eachOrder['drop_endtime'],
                        'createdon' => $eachOrder['createdon'],
                        "delivery_company" => $eachOrder['delivery_company'],
                        'delivery_city' => $eachOrder['delivery_city'],
                        'delivery_country' => $finalCountries[strtoupper($eachOrder['delivery_country'])] ?? $eachOrder['delivery_country'],
                        'delivery_address1' => $eachOrder['delivery_address1'],
                        'delivery_address2' => $eachOrder['delivery_address2'],
                        'delivery_pincode' => $eachOrder['delivery_pincode'],
                        'branch_code' => $eachOrder['branch_code'],
                        'company_code' => $eachOrder['company_code'],
                        'transport_mode' => $eachOrder['transport_mode'],
                        'pickup_country' => $finalCountries[strtoupper($eachOrder['pickup_country'])] ?? $eachOrder['pickup_country'],
                        'pickup_pincode' => $eachOrder['pickup_pincode'],
                        "pickup_company" => $eachOrder['pickup_company'],
                        'pickup_city' => $eachOrder['pickup_city'],
                        'pickup_address1' => $eachOrder['pickup_address1'],
                        'pickup_address2' => $eachOrder['pickup_address2'],
                        'cargos' => $cargos ?? [],
                        'weight' => $totalWeight,
                        'total_volume' => $totalVolume,
                        "vehicle_type" => $eachOrder['vehicle_type'] ?: "F",
                        "parties" => $partnerDetails ?? [],
                        "physicalreceiver" => $PhysicalReceiver,
                        "logicalreceiver" => 'WWWWW99',
                        "physicalsender" => $PhysicalSender,
                        "logicalsender" => $logicalSenderInfo[$eachOrder['branch_code']] ?? "",
                        "quantity" => $totalQuantity,
                        "freight_term" => "",
                        "freight_termname" => "",
                        "product" => $eachOrder['product'] ?: "KN AsiaDirect",
                        "service_type" => $serviceNames[$eachOrder['service']] ?? "",
                        "hrs" => $timeZoneHours,
                        't_mode' => $transportMode,
                        'country_name' => $countryName,
                        "cntrycode" => $countryCode,
                        'shipmentid' => $eachOrder['shipmentid'],
                        'carrierDetails' => $carrierDetails,
                        'packageCodes' => $packageCodes,
                        'finalCountries' => $finalCountries,
                        'shipperReferences' => $allShipperReferences[$orderRowId] ?? [],
                        'refs' => $allReferences[$orderRowId] ?? [],
                        'incoterm' => $eachOrder['incoterm']
                    ];
                    $this->knlogin->sendKNloginOrderxmlservice($data);
                }
                $this->common->updatetbledata("tb_orders", ["is_created" => 2], "id IN ('" . implode("','", $orderIds) . "') ");
            }
        }
        $excelResponse = array_merge($ordersToSent, $OrdersNotToSent);
        if (!empty($excelResponse)) {
            @file_put_contents("assets/ordertemplate/exceluploaddata.txt", json_encode($excelResponse));
        }
        echo "1";
    }
}

?>
