<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Authorization\Authorization;
use App\Order\Models\OrderReference;
use Zebra\Client;
use Zebra\Zpl\Builder;
use Zebra\Zpl\GdDecoder;
use Zebra\Zpl\Image;

class Smtcorders extends CI_Controller {

    /** @var CodeIgniterAuthorization $codeigniterauthorization */
    public $codeigniterauthorization;

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['common','smtcorder','triptemplatemodel', 'DeliveryDocumentModel']);
        $this->load->library(["TripCreateFromOrders","svkonektquote","statusintigration","email","Ratemanagement","form_validation","session","CodeIgniterAuthorization","altovaordercreation", "Standard_status_execution"]);
        $this->load->helper('user_helper');
    }

    public function index($id = NULL) {

		if($this->session->userdata('business_type') == "Carrier")
		{
			redirect('welcome/logout');
		}
        if (!checkUrlAccessForUser('SMTCORDERS')) {
            redirect("Forbiddenaccess");
        }
        if ($id != "") {
            $this->orderslist($id);
        } else {
            $this->orderslist();
        }
    }
    public function orderslist($id = NULL) {

		if($this->session->userdata('business_type') == "Carrier")
		{
			redirect('welcome/logout');
		}
        if (!checkUrlAccessForUser('SMTCORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data['page_title'] = $this->lang->line('order_list');
        $data['sub_title'] = $this->lang->line('menu_orders');
        $order = $country_userids = $excel_uploaddata = $clexcel_uploaddata = $chexcel_uploaddata = $knLoginUploadData = [];
        $userid = $this->session->userdata("user_id");
        $custid = $this->session->userdata("cust_id");
        $country_userids = $this->session->userdata("country_user_ids");
        $whr = $searchids = $ats_parties = $exc_booking_id = $post = array();
        $list_type = $cllist_type = $charge_list_type = $knloginListType = 0;
        //log_message("error","id:".$id);
        if ($id != "") {
            if ($id == "01") {
                $session_companycode = $this->session->userdata('company_code');
                $filedata = @file_get_contents("assets/ordertemplate/exceluploaddata.txt");
                $excel_uploaddata = @json_decode($filedata);
                if (!empty($excel_uploaddata)) {
                    $list_type = 1;
                    @file_put_contents("assets/ordertemplate/exceluploaddata.txt", "");
                    $logs = addordertologs($filedata);
                    foreach ($excel_uploaddata as $exc_data) {
                        $exc_booking_id[] = $exc_data->booking_id;
                    }
                }
                if (!empty($exc_booking_id)) {
                    $booking_ids = $this->smtcorder->getOrderdetailsByOrderId($exc_booking_id, 'order_id');
                    if (!empty($booking_ids)) {
                        foreach ($booking_ids as $bookids) {
                            $ats_parties[] = array('name' => $bookids['pickup_company'], 'street' => $bookids['pickup_address1'], 'city' => $bookids['pickup_city'], 'zipcode' => $bookids['pickup_pincode'], 'country' => $bookids['pickup_country'], 'type' => "shipper", 'booking_id' => $bookids['order_id']);
                            $ats_parties[] = array('name' => $bookids['delivery_company'], 'street' => $bookids['delivery_address1'], 'city' => $bookids['delivery_city'], 'zipcode' => $bookids['delivery_pincode'], 'country' => $bookids['delivery_country'], 'type' => "consignee", 'booking_id' => $bookids['order_id']);
                            $ats_parties[] = array('name' => $bookids['name'], 'street' => $bookids['street'], 'city' => $bookids['location'], 'zipcode' => $bookids['pincode'], 'country' => $bookids['country'], 'type' => "customer", 'booking_id' => $bookids['order_id']);
                        }
                    }
                }
            } elseif ($id == '02') {
                $clfiledata = @file_get_contents("assets/ordertemplate/clexceluploaddata.txt");
                
                $clexcel_uploaddata = @json_decode($clfiledata);
                //log_message("error","clexcel_uploaddata111:".json_encode($clexcel_uploaddata));
                if (!empty($clexcel_uploaddata)) {
                    $cllist_type = 1;
                    @file_put_contents("./assets/ordertemplate/clexceluploaddata.txt", "");
                    $logs = addordertologs($clfiledata);
                }
            } elseif ($id == '03') {
                $chfiledata = @file_get_contents("./assets/ordertemplate/charges_exceluploaddata.txt");
                $chexcel_uploaddata = @json_decode($chfiledata);
                if (!empty($chexcel_uploaddata)) {
                    $charge_list_type = 1;
                    @file_put_contents("assets/ordertemplate/charges_exceluploaddata.txt", "");
                    /* $logs = addordertologs($chfiledata);*/
                }
            } elseif ($id == '04') {
                $fileData = @file_get_contents("assets/ordertemplate/exceluploaddata.txt");
                $knLoginUploadData = @json_decode($fileData);
                if (!empty($knLoginUploadData)) {
                    $knloginListType = 1;
                    @file_put_contents("assets/ordertemplate/exceluploaddata.txt", "");
                }
            } else {
                $searchids = array($id);
                $post['bookingid'] = array();
                $getbooking_id = $this->smtcorder->getOrderdetailsByOrderId($id, 'id');
                if (!empty($getbooking_id)) {
                    $post['bookingid'] = array(
                        $getbooking_id['order_id']
                    );
                    $ats_parties[] = array('name' => $getbooking_id['pickup_company'], 'street' => $getbooking_id['pickup_address1'], 'city' => $getbooking_id['pickup_city'], 'zipcode' => $getbooking_id['pickup_pincode'], 'country' => $getbooking_id['pickup_country'], 'type' => "shipper", 'booking_id' => $getbooking_id['order_id']);
                    $ats_parties[] = array('name' => $getbooking_id['delivery_company'], 'street' => $getbooking_id['delivery_address1'], 'city' => $getbooking_id['delivery_city'], 'zipcode' => $getbooking_id['delivery_pincode'], 'country' => $getbooking_id['delivery_country'], 'type' => "consignee", 'booking_id' => $getbooking_id['order_id']);
                    $ats_parties[] = array('name' => $getbooking_id['name'], 'street' => $getbooking_id['street'], 'city' => $getbooking_id['location'], 'zipcode' => $getbooking_id['pincode'], 'country' => $getbooking_id['country'], 'type' => "customer", 'booking_id' => $getbooking_id['order_id']);
                }
                $data['getbookingid'] = $post['bookingid'];
            }
        }
        $data['ats_parties'] = htmlentities(json_encode($ats_parties));
        $status_search = "";
        $post1 = $this->input->post(NULL, TRUE);
        if (isset($post1['searchsubmit']) && $post1['searchsubmit'] == "Search") {
            $post = $post1;
        }
        if (!empty($post)) {
            $whr = $this->searchorders($post);

            $order_status = isset($post['status']) ? $this->db->escape_str($post['status']) : "";
            $ad_orderstatus = isset($post['order_status']) ? $this->db->escape_str($post['order_status']) : "";
            $status_search = $order_status;
            if ($status_search == "") {
                $status_search = $ad_orderstatus;
            }
            $searchids = isset($post['bookingid']) ? $this->db->escape_str($post['bookingid']) : array();

            /* advanced search order refrance type */
            if (isset($post['order_reftype']) && $post['order_reftype'] != "") {
                $advancedids = $this->getrefnum();
                if (!empty($advancedids)) {
                    $searchids = $advancedids;
                } else {
                    $whr['o.id'] = '0';
                }
            }
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $subcusts = array();
            $role_id = $this->session->userdata('user_role_id');
            if ($role_id == "4") {
                if ($this->session->userdata('sub_cust')) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (!empty($subcusts)) {
                        array_push($subcusts, $custid);
                    }
                }
            }
            $shipper_orders = array();
            $searchshipper_id = isset($post['searchshipper_id']) ? $post['searchshipper_id'] : "";
            if ($searchshipper_id != "") {
                $shipper_orders = $this->smtcorder->getorders_bypartymaster('Shipper', $searchshipper_id, $userid, $country_userids, $subcusts, $custid);
                if (empty($searchids) && !empty($shipper_orders)) {
                    $searchids = $shipper_orders;
                } else if (!empty($searchids) && !empty($shipper_orders)) {
                    $searchids = array_intersect($shipper_orders, $searchids);
                }
            }
            $consignee_orders = array();
            $searchconsignee_id = isset($post['searchconsignee_id']) ? $post['searchconsignee_id'] : "";
            if ($searchconsignee_id != "") {
                $consignee_orders = $this->smtcorder->getorders_bypartymaster('Consignee', $searchconsignee_id, $userid, $country_userids, $subcusts, $custid);
                if (empty($searchids) && !empty($consignee_orders)) {
                    $searchids = $consignee_orders;
                } else if (!empty($searchids) && !empty($consignee_orders)) {
                    $searchids = array_intersect($consignee_orders, $searchids);
                }
            }

            $orderdata = $this->smtcorder->getorderdata($userid, $searchids, $status_search, $custid, $country_userids, $whr, $subcusts);
            //echo "<pre>";print_r($orderdata);exit;
            if (!empty($orderdata['orders'])) {
                $undefinedVariables=array('reference_value','invoice_details','secondweight_uom','secondvolume_uom','second_weight',
                'second_volume','totwg','totvol','totqty','delivered_time');

    foreach ($orderdata['orders'] as $res) {

        foreach($undefinedVariables as $eachVar){
            if(!isset($res[$eachVar])){
                $res[$eachVar]='';
            }
        }

        $delivery_note = $container_no = $manifestno = "";
        $trip_no = $res['shipmentid'];
        if ($trip_no == '0') {
            $trip_no = "";
        }
        $trip_sts = $res['trip_sts'];
        $otherstatus = $res['order_status'];
        $trip_id = $res['trip_id'];
        $created_source = $res['created_source'];
        $order_status = 'PENDING';
        if ($trip_id != 0 && $trip_sts == 0) {
            $order_status = 'ACTIVE';
        }
        if (($trip_id != 0 || $trip_id == 0)  && $trip_sts == 1) {
            $order_status = 'CLOSED';
        }
        if ($res['status'] == 3) {
            $order_status = 'CANCELLED';
        }

        if ($order_status == 'PENDING') {


            $orderIndex=$res['order_id'];
            if(isset($orderdata['tripData'])){
                if(isset($orderdata['tripData'][$orderIndex])){
                   $tripno = $orderdata['tripData'][$orderIndex]['trip_no'];
                    if($tripno>0){
                          if($trip_sts == 1){
                              $order_status = 'CLOSED';
                          }else{
                              $order_status = 'ACTIVE';
                          }
                    }else{
                       $order_status == 'PENDING';
                    }
                }else{
                  $order_status == 'PENDING';
                }
            }

        }

    $otherstatus = strtoupper($res['order_status'] ?? "");
    if ($otherstatus == "") {
        $otherstatus = $res['order_detail_status'];
    }
    if ($otherstatus == 'READY') {
        $otherstatus = 'READY';
    } else if ($otherstatus == 'INVOICE') {
        $otherstatus = 'INVOICE';
    } else {
        $otherstatus = "";
    }
    $manifestno = $delivery_note = $salog_ref = $pq_ref =  $container_no = $referenceData = $loadplanconnote = $pos_ref ="";
    if (isset($res['reference_value'])) {
        $referenceData = $res['reference_value'];
    }
    $pq_ref_value = $delivery_note_value = $manifestno_value = $salog_ref_value = [];
    if ($referenceData != '') {
        $referenceDataArray = explode('?????', $referenceData);
        if (!empty($referenceDataArray) && sizeof($referenceDataArray) > 0) {
            foreach ($referenceDataArray as $eachRefData) {
                $reqArray = $this->giveReferenceParameters($eachRefData);
                if ($reqArray['type'] == "DQ") {
                    $delivery_note_value[] = $reqArray['value'];
                    $delivery_note = implode(", ", $delivery_note_value);
                } else if ($reqArray['type'] == "MN") {
                    $manifestno_value[] = $reqArray['value'];
                    $manifestno =  implode(", ", $manifestno_value);
                }else if ($reqArray['type'] == "XSR") {
                    $salog_ref_value[] = $reqArray['value'];
                    $salog_ref = implode(", ", $salog_ref_value);
                }else if ($reqArray['type'] == "PQ") {
                    $pq_ref_value[] = $reqArray['value'];
                    $pq_ref = implode(", ", $pq_ref_value);
                }
            }
        }
    }

    $chkdate = '2020-07-01 00:00:00';
    $createdon = $res['createdon'];
    $order_str = strtotime($createdon);
    $chk_str = strtotime($chkdate);
    $early_pickup = $res['pickup_datetime'];
    $early_delivery = $res['delivery_datetime'];

    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    if ($order_str > $chk_str) {
        if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
            $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
            $early_pickup = $epickup['datetime'];
        }
        if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
            $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
            $early_delivery = $edelivery['datetime'];
        }
    }
    $orderUpdatedDate = getdatetimebytimezone($curtz, $res['updatedon'], DFLT_TZ);
    $updatedDate = $orderUpdatedDate['datetime'];
    $html = $status = $invoice_status = $internalinvoice = "";
    $delivered_time = $final_delivery = $res['delivered_time'];
    if ($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0") {
        $fdelivery = getdatetimebytimezone($curtz, $delivered_time, DFLT_TZ);
        $final_delivery = date('Y-m-d h:i A', strtotime($fdelivery['datetime']));
    }
    $final_jfr = "";
    if (!empty($res['invoice_details'])) {
        $invoiceDataArray = explode('+++++', $res['invoice_details']);
        $internalinvoice = $this->smtcorder->getinternalinvoice($res['id']);
        foreach ($invoiceDataArray as $eachInvoice) {
            $invoiceData = $this->giveInvoiceParameters($eachInvoice);
            if (!empty($invoiceData)) {
                $invoice_status = isset($invoiceData['invoice_status']) ? $invoiceData['invoice_status'] : "";
                $recipient_name = isset($invoiceData['recipient_name']) ? $invoiceData['recipient_name'] : "";
                $amount = isset($invoiceData['amount']) ? $invoiceData['amount'] : "0";
                $bill_status = isset($invoiceData['status']) ? $invoiceData['status'] : "0";
                $order_jfr = isset($invoiceData['debtor_jfr']) ? $invoiceData['debtor_jfr'] : "";
                $invoice_no = isset($invoiceData['invoice_no']) ? $invoiceData['invoice_no'] : "";
                $acon_invoice_status = isset($invoiceData['acon_invoice_status']) ? $invoiceData['acon_invoice_status'] : "0";
                $recipient_role= isset($invoiceData['recipient_role']) ? $invoiceData['recipient_role'] : "";
                $acon_accrual_status = isset($invoiceData['acon_accrual_status']) ? $invoiceData['acon_accrual_status'] : "0";
                if(strlen($order_jfr) == 14){
                    $final_jfr = $order_jfr;
                }
                if ($bill_status > 0) {
                    if ($bill_status == '1') {
                        $status = 'Ready To Invoice';
                        $status = 'Ready To Be Billed';
                    }
                    if ($bill_status == '2' || $bill_status == '4') {
                        if ($invoiceData['type'] == '0') {
                            $status = 'Billed';
                            if($acon_invoice_status >0){
                                $status ="Invoice Send To ACON";
                            }
                        } else {
                            $status = 'Invoiced';
                            if($acon_accrual_status >0){
                                $status = "Accrual Sent To ACON";
                            }
                        }
                    }
                } else {
                    if ($invoice_status == '0') {
                        $status = 'To be billed';
                    }
                    if ($invoice_status == '1' || $invoice_status == '2') {
                        $status = 'Ready To Invoice';
                        if($invoiceData['type'] == "1" && $invoice_status == "2" && $recipient_role == "Carrier"){
                            $status = 'Accrual Sent To ACON';
                        }
                    }else if($invoice_status == '3'){
                        if($recipient_role == "Internal BU"){
                            $status = "File Sent To ACON";
                        }
                    }
                }
                $invoice = "";
                if ($invoiceData['type'] == '0') {
                    if(strlen($invoice_no) >0){
                        $invoice = "Invoice No. :".$invoice_no;
                    }
                    $html .= "<b>(Rev)</b> " . $recipient_name . " : " . $status . " - [" . $amount . '] '.$invoice.'<br>';
                } else {
                    $html .= "<b>(Cost)</b> " . $recipient_name . " : " . $status . " - [" . $amount . ']<br>';
                }
            }
        }
    }
    $second_weight = $res['second_weight'];
    $second_volume = $res['second_volume'];
    if ($second_volume == "") {
        $second_volume = 0;
    }
    if ($second_weight == "") {
        $second_weight = 0;
    }
    $vehicleType = $vehicleNumber = "";
    if ( (int) $res['shift_id'] > 0 ) {
        $vehicleTypeQry = $this->common->gettblrowdata(['id'=>$res['shift_id']],"vehicle_type","tb_shifts",0,0);
        $vehicleType = $vehicleTypeQry ? $vehicleTypeQry['vehicle_type'] : '';
        $vehicleNumberQry = $this->common->gettblrowdata(['shft_id'=>$res['shift_id']],"register_number,","tb_shft_veh",0,0);
        $vehicleNumber = $vehicleNumberQry ? $vehicleNumberQry['register_number'] : '';
    }
        $order[] = [
            'order_row_id' => $res['id'],
            'order_id' => $res['order_id'],
            'delivery_note' => $delivery_note,
            'salog_ref' => $salog_ref,
            'pq_ref' => $pq_ref,
            'pickup' => $res['pickup'],
            'delivery' => $res['delivery'],
            'trip_no' => $trip_no,
            'order_status' => $order_status,
            'transport_mode' => $res['transport_mode'],
            'vehicle_type' => $vehicleType,
            'vehicle_number' => $vehicleNumber,
            'createdon' => $createdon,
            'total_packages' => round(floatval($res['totqty'])),
            'weight' => $res['totwg'],
            'volume' => $res['totvol'],
            'second_weight' => $second_weight . " " . $res['secondweight_uom'],
            'second_volume' => $second_volume . " " . $res['secondvolume_uom'],
            'company_code' => $res['company_code'],
            'branch_code' => $res['branch_code'],
            'otherstatus' => $otherstatus,
            'delivery_date' => $early_delivery,
            'pickup_date' => $early_pickup,
            'html' => $html,
            'final_delivery' => $final_delivery,
            'created_source' => $created_source,
            'invoice_status' => $invoice_status,
            'internalinvoice' => $internalinvoice,
            'final_jfr' => $final_jfr,
            'customer_name' => $res['customer_name'],
            'updatedDate' => $updatedDate,
            'external_customer' => ($created_source == 5) ? $res['external_customer'] : ''
        ];
    }
            }
        }
$data['order'] = $order;
$data['list_type'] = $list_type;
$data['excel_uploaddata'] = $excel_uploaddata;
$data['cllist_type'] = $cllist_type;
$data['charge_list_type'] = $charge_list_type;
$data['clexcel_uploaddata'] = $clexcel_uploaddata;
$data['chexcel_uploaddata'] = $chexcel_uploaddata;
$data['bill_type'] = "Svkonekt";
$data['knlogin_uploaddata'] = $knLoginUploadData;
$data['knlogin_list_type'] = $knloginListType;
$company_code = $this->session->userdata('company_code');
$branch_code = $this->session->userdata('branch_code');
$getbilltype = $this->db->select("bill_type")->get_where("tb_branch_master", array(
    'branch_code' => $branch_code,
    'company_code' => $company_code
));

$data['user_currency'] = $this->session->userdata("usr_tzone")['currency'];
$res = $this->common->gettbldata(array('status' => '1'),"currency","tbl_country_master",0,0);
if(!empty($res)){
	foreach ($res as $result) {
		$data['currencies'][] = $result['currency'];
	}
}

        if ($getbilltype->num_rows() > 0) {
            $data['bill_type'] = $getbilltype->row()->bill_type;
        }
        $data['ref_names_arr'] = $this->smtcorder->getrefnums();
        $data['postData'] = $this->input->post(null, true);
$this->newtemplate->dashboard("smtcorders/order", $data);
}

public function giveReferenceParameters($referenceParam) {
    $finalArray = array();
    if (!empty($referenceParam) && $referenceParam != '') {
        $requiredArray = explode('=====', $referenceParam);
        if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
            $finalArray['type'] = isset($requiredArray[0]) ? trim($requiredArray[0]) : "";
            $finalArray['value'] = isset($requiredArray[1]) ? trim($requiredArray[1]) : "";
        }
    }

    return $finalArray;
}

public function giveInvoiceParameters($invoiceParam) {
    $finalArray = array();
    if (!empty($invoiceParam) && $invoiceParam != '') {
        $requiredArray = explode(';', $invoiceParam);
        if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
            foreach ($requiredArray as $eachitem) {
                $explodeArray = explode('=====', $eachitem);
                if (!empty($explodeArray) && sizeof($explodeArray) > 0) {
                    $key = isset($explodeArray[0]) ? $explodeArray[0] : "";
                    $value = isset($explodeArray[1]) ? $explodeArray[1] : "";
                    $finalArray[$key] = $value;
                }
            }
        }
    }

    return $finalArray;
}

public function searchorders($post) {
    $whr = array();
    $session_user_id = $this->session->userdata('user_id');
    $cdate = date('Y-m-d H:i:s');
    $user_role_id = $this->session->userdata('user_role_id');


    if (isset($post['fromdate']) && $post['fromdate'] != "") {
        $post_fromdate = $this->db->escape_str($post['fromdate']);
        $fromdate = date('Y-m-d', strtotime($post_fromdate));
        $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;
        if (isset($post['todate'])) {
            if ($post['todate'] == "") {
                $todate = date('Y-m-d', strtotime($cdate));
                $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
            }
        } else {
            $todate = date('Y-m-d', strtotime($cdate));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
        }
    }
    if (isset($post['todate']) && $post['todate'] != "") {
        $post_todate = $this->db->escape_str($post['todate']);
        $todate = date('Y-m-d', strtotime($post_todate));
        $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
    }
    if (isset($post['advfrom_date']) && $post['advfrom_date'] != "") {
        $post_advfrom_date = $this->db->escape_str($post['advfrom_date']);
        $advfrom_date = date('Y-m-d', strtotime($post_advfrom_date));
        $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $advfrom_date;
    }
    if (isset($post['advto_date']) && $post['advto_date'] != "") {
        $post_advto_date = $this->db->escape_str($post['advto_date']);
        $advto_date = date('Y-m-d', strtotime($post_advto_date));
        $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $advto_date;
    }

     /*----------pickup date-----------------------------------------*/
     if (isset($post['advpickupfrom_date']) && !empty($post['advpickupfrom_date'])) {
        $post_advpickupfrom_date = $this->db->escape_str($post['advpickupfrom_date']);
        $advpickupfrom_date = date('Y-m-d', strtotime($post_advpickupfrom_date));
        $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $advpickupfrom_date;
    }
    if (isset($post['advpickupto_date']) && !empty($post['advpickupto_date'])) {
        $post_advpickupto_date = $this->db->escape_str($post['advpickupto_date']);
        $advpickupto_date = date('Y-m-d', strtotime($post_advpickupto_date));
        $whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $advpickupto_date;
    }

    /*----------Delivery date-----------------------------------------*/
    if (isset($post['advdeliveryfrom_date']) && !empty($post['advdeliveryfrom_date'])) {
        $post_advdeliveryfrom_date = $this->db->escape_str($post['advdeliveryfrom_date']);
        $advdeliveryfrom_date = date('Y-m-d', strtotime($post_advdeliveryfrom_date));
        $whr["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') >="] = $advdeliveryfrom_date;
    }
    if (isset($post['advdeliveryto_date']) && !empty($post['advdeliveryto_date'])) {
        $post_advdeliveryto_date = $this->db->escape_str($post['advdeliveryto_date']);
        $advdeliveryto_date = date('Y-m-d', strtotime($post_advdeliveryto_date));
        $whr["DATE_FORMAT(o.delivery_datetime,'%Y-%m-%d') <="] = $advdeliveryto_date;
    }

if (isset($post['order_id']) && $post['order_id'] != "") {
    $whr['o.order_id'] = $this->db->escape_str($post['order_id']);
}
if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
    $getcustomer_id = $this->db->select("id")->get_where("tb_customers", array(
        'code' => $post['searchcustomer_id']
    ));
    if ($getcustomer_id->num_rows() > 0) {
        $whr['o.customer_id'] = $getcustomer_id->row()->id;
    } else {
        $whr['o.id'] = '0';
    }
}

if (isset($post['searchcustomer_name']) && $post['searchcustomer_name'] != "") {
    $query = "SELECT id FROM tb_customers where name like ?";
    $result = $this->db->query($query, [$post['searchcustomer_name'] . '%'])->result_array();
    $ids = is_array($result) ? array_map('current', $result) : null;

    if (isset($whr['o.customer_id']) && $whr['o.customer_id'] != '' && is_array($ids) && count($ids) > 0) {
        $whr['o.customer_id'] = array_merge($ids, !is_array($whr['o.customer_id']) ? [$whr['o.customer_id']] : $whr['o.customer_id']);
    } elseif (is_array($ids) && count($ids) > 0) {
        $whr['o.customer_id'] = $ids;
    }
}

if (isset($post['searchshipper_name']) && $post['searchshipper_name'] != "") {
    $whr['o.pickup_company'] = $this->db->escape_str($this->input->post('searchshipper_name',true));
}

if (isset($post['searchconsignee_name']) && $post['searchconsignee_name'] != "") {
    $whr['o.delivery_company'] = $this->db->escape_str($this->input->post('searchconsignee_name',true));
}
if (isset($post['service']) && $post['service'] != "") {
    $whr['d.service'] = $this->db->escape_str($post['service']);
}

if (isset($post['order_type']) && $post['order_type'] != "") {
    $whr['d.order_type'] = $this->db->escape_str($post['order_type']);
}
if (isset($post['product']) && $post['product'] != "") {
    $whr['o.product'] = $this->db->escape_str($post['product']);
}
if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
    $whr['o.transport_mode'] = $this->db->escape_str($post['modeof_trasnport']);
}

if (isset($post['trip_id']) && $post['trip_id'] != "") {
    $whr['o.shipmentid'] = $this->db->escape_str($post['trip_id']);
}
if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
    /* $getdelivery_noteid = $this->db->select("id")->get_where("tb_shipments",array('shipid'=>$post['delivery_note'])); */
    $getdelivery_noteid = $this->db->select("order_id")->get_where("tb_order_references", array(
        'ref_value' => $this->db->escape_str($post['delivery_note']),
        'status' => '1',
        'reference_id' => 'DQ'
    ));
    if ($getdelivery_noteid->num_rows() > 0) {
        $order_id = $getdelivery_noteid->row()->order_id;
        $whr['o.id'] = $order_id;
    } else {
        $whr['o.id'] = '0';
    }
}
    if (isset($post['salog_ref']) && $post['salog_ref'] != "") {
        $getSalogReference = $this->db->select("order_id")->get_where("tb_order_references", [
            'ref_value' => $this->db->escape_str($post['salog_ref']),
            'status' => '1',
            'reference_id' => 'XSR'
        ]);
        if ($getSalogReference->num_rows() > 0) {
            $order_id = $getSalogReference->row()->order_id;
            $whr['o.id'] = $order_id;
        } else {
            $whr['o.id'] = '0';
        }
    }
if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
    if ($user_role_id == '1') {
        $getpo = $this->db->query("SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.id = r.order_id AND o.status !=0 AND r.reference_id LIKE 'PO' AND r.ref_value ='" . $this->db->escape_str($post['purchase_order']) . "' AND r.status ='1'");
        if ($getpo->num_rows() > 0) {
            $order_id = $getpo->row()->id;
            $whr['o.id'] = $order_id;
        } else {
            $whr['o.id'] = '0';
        }
    } else {
        $postpurchase_order = addslashes($this->db->escape_str($post['purchase_order']));
        $getpo = $this->db->query("SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.id = r.order_id AND o.user_id LIKE '" . $session_user_id . "' AND o.status !=0 AND r.reference_id LIKE 'PO' AND r.ref_value ='" . $postpurchase_order . "' AND r.status ='1'");
        if ($getpo->num_rows() > 0) {
            $order_id = $getpo->row()->id;
            $whr['o.id'] = $order_id;
        } else {
            $whr['o.id'] = '0';
        }
    }
}
if (isset($post['load_plan_connote']) && $post['load_plan_connote'] != "") {
    $getpo = $this->db->query("SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.id = r.order_id AND o.user_id LIKE '" . $session_user_id . "' AND o.status !=0 AND r.reference_id LIKE 'LPC' AND r.ref_value ='" . $post['load_plan_connote'] . "'");
    if ($getpo->num_rows() > 0) {
        $order_id = $getpo->row()->id;
        $whr['o.id'] = $order_id;
    } else {
        $whr['o.id'] = '0';
    }
}
if (isset($post['company_code']) && $post['company_code'] != "") {
    $whr['o.company_code'] = $this->db->escape_str($post['company_code']);
}
if (isset($post['branch_code']) && $post['branch_code'] != "") {
    $whr['o.branch_code'] = $this->db->escape_str($post['branch_code']);
}
if (isset($post['order_jfr']) && $post['order_jfr'] != "") {
    $order_jfr = $this->db->escape_str($post['order_jfr']);
    if(strlen($order_jfr) == 14){
        $getorder_id = $this->common->gettblrowdata(array('debtor_jfr' => $order_jfr,'invoice_status>'=>'0','status' =>'1'),"order_id", "tb_reveneus", 0, 0);
        if(!empty($getorder_id)){
            $order_row_id = $getorder_id['order_id'];
            if($order_row_id >0){
                $whr['o.id'] = $order_row_id;
            }else{
                $whr['o.id'] = '0';
            }
        }else{
            $whr['o.id'] = '0';
        }
    }else{
        $whr['o.id'] = '0';
    }
}
return $whr;
}

public function checkpurchaseordervalue() {
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $p_order = $this->input->post('purchase_order', true);
    $customer = isset($post['customer_id']) ? $post['customer_id'] : "";
    $order_id = isset($post['order_id']) ? $post['order_id']: "0";
    if($order_id == ""){
        $order_id = 0;
    }
    $user_id = $this->session->userdata('user_id');
    $cust_id = 0;
    $permission = checkuserpermissions();
    $company_code = $this->session->userdata('company_code');
    if ($customer != "") {
        if(in_array("orders", $permission)){
            $getcustomerid = $this->common->gettblrowdata(array(
                'code' => $customer,
                'company_code' => $company_code,
                'status' => '1'
            ), "id", "tb_customers", 0, 0);
            if (!empty($getcustomerid)) {
                $cust_id = $getcustomerid['id'];
            }
        }else{
            $getcustomerid = $this->common->gettblrowdata(array(
                'code' => $customer,
                'user_id' => $user_id,
                'status' => '1'
            ), "id", "tb_customers", 0, 0);
            if (!empty($getcustomerid)) {
                $cust_id = $getcustomerid['id'];
            }
        }
    }
    $whr = "";
    if ($cust_id > 0) {
        if(in_array("orders", $permission)){
            $whr = "o.customer_id ='".$cust_id."' AND o.company_code LIKE '".$company_code."' AND o.status != '0' AND r.ref_value LIKE '".$p_order."'";
            if($order_id > 0){
                $whr .= " AND o.id !='".$order_id."'";
            }
        } else {
            $whr = "o.customer_id='" . $cust_id . "' AND o.user_id LIKE '" . $user_id . "' AND o.status != '0'";
            if($order_id > 0){
                $whr .= " AND o.id !='".$order_id."'";
            }
        }
        if($whr != ""){
            $chkorder = $this->smtcorder->checkpurchaseorderexists($whr);
            if ($chkorder > 0) {
                echo '1';
            } else {
                echo '0';
            }
        }else{
            echo "0";
        }
    } else {
        echo '0';
    }
}

public function findcountrybyname() {

    $name = $this->input->post('name', true);
    $result = array();
    $chkqry = $this->db->select('id,company_name,company_code,description')->get_where("tb_company_master", array(
        'company_code' => $name
    ));
    if ($chkqry->num_rows() > 0) {
        foreach ($chkqry->result() as $res) {
            $check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
            $result[] = array(
                'check' => $check,
                'company_code' => $res->company_code,
                'company_name' => $res->company_name,
                'description' => $res->description
            );
        }
    }
    echo json_encode($result);
}

public function findbranchbyname() {
    $name = $this->input->post('name', true);
    $result = array();
    $chkqry = $this->db->select('id,branch_name,company_code,description,branch_code')->get_where("tb_branch_master", array(
        'branch_code' => $name
    ));
    if ($chkqry->num_rows() > 0) {
        foreach ($chkqry->result() as $res) {
            $check = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
            $result[] = array(
                'check' => $check,
                'branch_code' => $res->branch_code,
                'branch_name' => $res->branch_name,
                'company_code' => $res->company_code,
                'description' => $res->description
            );
        }
    }
    echo json_encode($result);
}

public function viewcompanylist() {
    $result = $post = array();
    $check = "";
    $post = $this->input->post(NULL, TRUE);
    $popup = isset($post['popup']) ? $post['popup'] : "";
    $chkqry = $this->db->select("id,company_name,company_code,description")->get_where("tb_company_master", array(
        'status' => 1
    ));
    if ($chkqry->num_rows() > 0) {
        foreach ($chkqry->result() as $res) {
            if ($popup == 'popup') {
                $check = "<input type='radio' name='listpopupcompany' id='listpopupcompany_" . $res->id . "' class='listpopupcompany' onchange='selectpopupcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
            } else {
                $check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
            }
            $result[] = array(
                'check' => $check,
                'id' => $res->id,
                'company_code' => $res->company_code,
                'company_name' => $res->company_name,
                'description' => $res->description
            );
        }
    }
    echo json_encode($result);
}

public function getcompanyname() {
    $post = $result = array();
    $post = $this->input->post(NULL, TRUE);
// $post = $this->input->post();
    $term = $post['term'];
    $check = "";

    $popup = isset($post['popup']) ? $post['popup'] : "";
    $this->db->select("id,company_code,company_name,description");
    $this->db->from("tb_company_master");
    $this->db->like('company_code', $term);
    $this->db->order_by('createdon', 'DESC');
    $getcompanyname = $this->db->get();
    if ($getcompanyname->num_rows() > 0) {
        foreach ($getcompanyname->result() as $res) {
            if ($popup == 'popup') {
                $check = "<input type='radio' name='listpopupcompany' id='listpopupcompany_" . $res->id . "' class='listpopupcompany' onchange='selectpopupcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
            } else {
                $check = "<input type='radio' name='listcompany' id='listcompany_" . $res->id . "' class='listcompany' onchange='selectcompany(" . $res->id . ")' value='" . $res->company_code . "'>";
            }
            $result[] = array(
                'check' => $check,
                'company_code' => $res->company_code,
                'company_name' => $res->company_name,
                'description' => $res->description
            );
        }
    }
    echo json_encode($result);
}


public function getbranchbycompany() {
    $cmp_id = $this->input->post('cmp_code', true);
    $id = $this->input->post('term', true);
    $result = array();
    $this->db->select('id,branch_code');
    $this->db->from('tb_branch_master');
    $this->db->like('company_code', $cmp_id);
    $this->db->like('branch_code', $id);
    $qry = $this->db->get();
    if ($qry->num_rows() > 0) {
        foreach ($qry->result() as $res) {
            $result[] = array(
                'id' => $res->id,
                'branch_code' => $res->branch_code
            );
        }
    }
    echo json_encode($result);
}

public function getbranchbyname() {
    $cmp_id = $this->input->post('name', true);
    $result = array();
    $this->db->select('id,branch_code,branch_name,company_code,description');
    $this->db->from('tb_branch_master');
    $this->db->like('branch_code', $cmp_id);
    $qry = $this->db->get();
    if ($qry->num_rows() > 0) {
        foreach ($qry->result() as $res) {
            $check = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
            $result[] = array(
                'check' => $check,
                'id' => $res->id,
                'branch_code' => $res->branch_code,
                'branch_name' => $res->branch_name,
                'company_code' => $res->company_code,
                'description' => $res->description
            );
        }
    }
    echo json_encode($result);
}

public function viewbranchlist() {
    $result = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $company_code = isset($post['company_code']) ? $post['company_code'] : "";
    $check = "";
    $popup = isset($post['popup']) ? $post['popup'] : "";

    $where = array(
        'status' => 1
    );
    if ($company_code != "") {
        $where['company_code'] = $company_code;
    }
    $this->db->select('id,branch_code,branch_name,company_code,description');
    $this->db->from('tb_branch_master');
    $this->db->where($where);
    $qry = $this->db->get();
    if ($qry->num_rows() > 0) {
        foreach ($qry->result() as $res) {
            if ($popup == 'popup') {
                $check = "<input type='radio' name='listpopupbranch' id='listpopupbranch_" . $res->id . "' class='listpopupbranch' onchange='selectpopupbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
            } else {
                $check = "<input type='radio' name='listbranch' id='listbranch_" . $res->id . "' class='listbranch' onchange='selectbranch(" . $res->id . ")' value='" . $res->branch_code . "'>";
            }
            $result[] = array(
                'check' => $check,
                'id' => $res->id,
                'branch_code' => $res->branch_code,
                'branch_name' => $res->branch_name,
                'company_code' => $res->company_code,
                'description' => $res->description
            );
        }
    }
    echo json_encode($result);
}

public function checkcompanycode() {
    $companys = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $c_code = isset($post['data']) ? $post['data'] : "";
    if (!empty($c_code)) {
        $this->db->select('company_code');
        $this->db->from("tb_company_master");
        $this->db->where_in('company_code', $c_code);
        $chk = $this->db->get();
        if ($chk->num_rows() > 0) {
            foreach ($chk->result() as $res) {
                $companys[] = $res->company_code;
            }
        }
    }
    $diff_companys = array();
    if (!empty($companys)) {
        $diff_companys = array_diff($c_code, $companys);
    }
    echo json_encode($diff_companys);
}

public function neworder() {

	if($this->session->userdata('business_type') == "Carrier")
	{
		redirect('welcome/logout');
	}
    if (!checkUrlAccessForUser('SMTCORDERS')) {
        redirect("Forbiddenaccess");
    }
    $chargecodes = [];
    $data = $transport = array();
    $user_id = $this->session->userdata('user_id');
    $company_code = $this->session->userdata('company_code');
    $branch_code = $this->session->userdata('branch_code');
    $data['currency'] = $data['session_currency'] = $this->session->userdata('usr_tzone')['currency'];


     $res=$this->db->query("SELECT DISTINCT currency  FROM `tbl_country_master`WHERE status=1  ORDER BY currency");
        if($res->num_rows() > 0){
            foreach ($res->result() as $cur) {
                $data['currencies'][] = $cur->currency;
            }
        }
    $transport = gettransportmode();
    $data['transport'] = $transport;
    $data['company_code'] = $company_code;
    $data['branch_code'] = $branch_code;
    $pickup_details = array();
    $custid = $this->session->userdata('cust_id');
    $ordertypes = array();
   if ($custid != "") {
        $getpickupdetails = $this->smtcorder->getpickupdetails($custid);
        if ($getpickupdetails->num_rows() > 0) {
            $pickup_details = array(
                'id' => $getpickupdetails->row()->id,
                'name' => $getpickupdetails->row()->name,
                'party_id' => $getpickupdetails->row()->code,
                'address' => $getpickupdetails->row()->address,
                'pincode' => $getpickupdetails->row()->pincode,
                'country' => $getpickupdetails->row()->country
            );
        }
        $getorders = $this->db->select("id,type_name")
        ->group_by("type_name")
        ->get_where("tb_order_types", array(
            'customer_id' => $custid,
            'company_code' => $company_code,
            'status' => '1'
        ));
        if ($getorders->num_rows() > 0) {
            foreach ($getorders->result() as $res) {
                $ordertypes[] = array(
                    'type_id' => $res->id,
                    'type_name' => $res->type_name
                );
            }
        } else {
            $getorders = $this->db->select("id,type_name")
            ->group_by("type_name")
            ->get_where("tb_order_types", array(
                'company_code' => $company_code,
                "status" => '1'
            ));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = array(
                        'type_id' => $res->id,
                        'type_name' => $res->type_name
                    );
                }
            } else {
                $getorders = $this->db->select("id,type_name")
                ->group_by("type_name")
                ->get_where("tb_order_types", array(
                    'company_code' => "SGKN",
                    "status" => '1'
                ));
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $ordertypes[] = array(
                            'type_id' => $res->id,
                            'type_name' => $res->type_name
                        );
                    }
                }
            }
        }
    } else {

         $getbranchdetail = $this->db->query("SELECT branch_code FROM tb_order_types WHERE status='1' AND branch_code='" . $branch_code . "' AND company_code='" . $company_code . "'");
        if ($getbranchdetail->num_rows() > 0) {
        $getorders = $this->db->query("SELECT id,type_name FROM tb_order_types WHERE status ='1' AND ((company_code= '" . $company_code . "' AND (branch_code='" . $branch_code . "' OR (branch_code= '' OR branch_code IS NULL))) OR ((company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL)))");
        if ($getorders->num_rows() > 0) {
            foreach ($getorders->result() as $res) {
                $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
            }
        }
        }else{
        $getorders = $this->db->query("SELECT id,type_name FROM tb_order_types WHERE status ='1' AND (company_code= '" . $company_code . "' OR (company_code= '' OR company_code IS NULL) AND (branch_code= '' OR branch_code IS NULL))");
        if ($getorders->num_rows() > 0) {
            foreach ($getorders->result() as $res) {
                $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
            }
        }
        }
    }
    $roles = array();
    $qyery = $this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name");
    if ($qyery->num_rows() > 0) {
        foreach ($qyery->result() as $res) {
            $roles[] = array(
                'id' => $res->id,
                'name' => $res->name
            );
        }
    }
    $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array(
        'status' => '1'
    ));
    if ($getchargecodes->num_rows() > 0) {
        foreach ($getchargecodes->result() as $res) {
            $chargecodes[] = array(
                'charge_id' => $res->id,
                'charge_code' => $res->charge_code
            );
        }
    }
    $data['vatcategory'] = array();
    $getvatcategory = $this->common->gettbldata(array(
        'company_code' => $company_code,
        'status' => '1'
    ), "id,description,vat_category,vat_percentage", "tb_vat_category", 0, 0);
    if (!empty($getvatcategory)) {
        foreach ($getvatcategory as $res) {
            $val = $res['id'] . "_" . $res['vat_category'];
            $desc = $res['description'] . " (" . $res['vat_category'] . "-" . $res['vat_percentage'] . ")";
            $data['vatcategory'][] = array(
                'id' => $res['id'],
                'val' => $val,
                'desc' => $desc
            );
        }
    }
    $data['chargecodes'] = $chargecodes;
    $data['pickup_details'] = $pickup_details;
    $data['ordertypes'] = $ordertypes;
    $data['roles'] = $roles;
    $this->newtemplate->dashboard('smtcorders/neworder', $data);
}

public function getdeliverytermvalue() {
    $incoterm = $this->input->post('incoterm', true);
    $terms = array();
    $terms = getDeliverytermsbyIncoterm($incoterm);

    echo json_encode($terms);
}

public function copyorder($id = NULL) {

	if($this->session->userdata('business_type') == "Carrier")
	{
		redirect('welcome/logout');
	}
    if (!checkUrlAccessForUser('SMTCORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data = $order_types = array();
    $order_details = $shipper_details = $drop_details = $shipper_data = $consignee_data = $pickup_details = $delivery_data = $delivery_array = $chargecodes = array();
    $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = $gen_shipper_id = $gen_consignee_id = 0;
    $res=$this->db->query("SELECT DISTINCT currency  FROM `tbl_country_master`WHERE status=1  ORDER BY currency");
        if($res->num_rows() > 0){
            foreach ($res->result() as $cur) {
                $data['currencies'][] = $cur->currency;
            }
        }
    $order_details['type_name'] = $order_details['ordtype_code'] = "";
    if ($id != "") {
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm = $chkorder->row()->incoterm;
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = $purchase_order = "";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='" . $id . "' AND reference_id IN ('DQ','PO','ORD_DLVINST','ORD_PIKINST','CTR')");
            if ($getdnote->num_rows() > 0) {
                foreach ($getdnote->result() as $ref) {
                    $ref_id = $ref->reference_id;
                    if ($ref_id == 'DQ') {
                        $shipment_id = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_DLVINST') {
                        $delivery_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_PIKINST') {
                        $pickup_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'CTR') {
                        $container_no = $ref->ref_value;
                    }
                    if ($ref_id == 'PO') {
                        $purchase_order = $ref->ref_value;
                    }
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $docs_received_datetime = $chkorder->row()->docs_received_datetime;
            $docs_sent_datetime = $chkorder->row()->docs_sent_datetime;
            $order_status = "PENDING";
/*
 * if($trip_id != 0 && $trip_sts == 0){
 * $order_status = 'ACTIVE';
 * }
 * if($trip_id != 0 && $trip_sts == 1){
 * $order_status = 'CLOSED';
 * }
 */
$chkdate = '2020-07-01 00:00:00';
$createdon = $chkorder->row()->createdon;
$order_str = strtotime($createdon);
$chk_str = strtotime($chkdate);
$early_pickup = $chkorder->row()->pickup_datetime;

$early_delivery = $chkorder->row()->delivery_datetime;
$late_pickup = $chkorder->row()->pickup_endtime;
$late_delivery = $chkorder->row()->drop_endtime;
$curtz = $this->session->userdata("usr_tzone")['timezone'];
if ($order_str > $chk_str) {
    if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
        $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
        $early_pickup = $epickup['datetime'];
    }
    if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
        $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
        $early_delivery = $edelivery['datetime'];
    }
    if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
        $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
        $late_pickup = $lpickup['datetime'];
    }
    if ($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00") {
        $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
        $late_delivery = $ldelivery['datetime'];
    }
}
if ($docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00") {
    $docsent = getdatetimebytimezone($curtz, $docs_sent_datetime, DFLT_TZ);
    $docs_sent_datetime = $docsent['datetime'];
}
if ($docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00") {
    $docrec = getdatetimebytimezone($curtz, $docs_received_datetime, DFLT_TZ);
    $docs_received_datetime = $docrec['datetime'];
}
$order_details = array(
    'id' => $chkorder->row()->id,
    'order_id' => $chkorder->row()->order_id,
    'shipment_id' => $shipment_id,
    'early_pickup' => $early_pickup,
    'early_delivery' => $early_delivery,
    'late_pickup' => $late_pickup,
    'late_delivery' => $late_delivery,
    'product' => $chkorder->row()->product,
    'service' => $chkorder->row()->service,
    'delivery_term' => $chkorder->row()->delivery_term,
    'incoterm' => $chkorder->row()->incoterm,
    'delivery_note' => $chkorder->row()->delivery_note,
    'purchase_order' => $purchase_order,
    'notify_party' => $chkorder->row()->notify_party,
    'goods_value' => $chkorder->row()->goods_value,
    'currency' => $chkorder->row()->currency,
    'lane_reference' => $chkorder->row()->lane_reference,
    'distance' => $chkorder->row()->distance,
    'customs_required' => $chkorder->row()->customs_required,
    'high_cargo_value' => $chkorder->row()->high_cargo_value,
    'valorance_insurance' => $chkorder->row()->valorance_insurance,
    'temperature_control' => $chkorder->row()->temperature_control,
    'company_code' => $chkorder->row()->company_code,
    'branch_code' => $chkorder->row()->branch_code,
    'department_code' => $chkorder->row()->department_code,
    'createdon' => $chkorder->row()->createdon,
    'order_type' => $chkorder->row()->order_type,
    'transport_mode' => $chkorder->row()->transport_mode,
    'pickup_inst' => $pickup_inst,
    'delivery_inst' => $delivery_inst,
    'container_no' => $container_no,
    'docs_received_datetime' => $docs_received_datetime,
    'docs_sent_datetime' => $docs_sent_datetime,
    'pickup_custid' => $chkorder->row()->pickup_custid,
    'drop_custid' => $chkorder->row()->drop_custid,
);
    $order_details['order_status'] = $order_status;

    $o_shipper_id = $chkorder->row()->o_shipper_id;
    if($o_shipper_id >0){
        $gen_shipper_id = $o_shipper_id;
    }
    $o_consignee_id = $chkorder->row()->consignee_id;
    if($o_consignee_id >0){
        $gen_consignee_id = $o_consignee_id;
    }
    if ($incoterm != '') {
        $delivery_array = getDeliverytermsbyIncoterm($incoterm);
    }
$pickup_id = $chkorder->row()->customer_id;
$company_code = $this->session->userdata('company_code');
if ($company_code != "") {
    $company_code = $chkorder->row()->company_code;
}
$getorders = $this->db->select("id,type_name")
->group_by("type_name")
->get_where("tb_order_types", array(
    'customer_id' => $pickup_id,
    'company_code' => $company_code,
    'status' => '1'
));
if ($getorders->num_rows() > 0) {
    foreach ($getorders->result() as $res) {
        $order_types[] = array(
            'type_id' => $res->id,
            'type_name' => $res->type_name
        );
    }
} else {


                $getorder_types = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
                if ($getorder_types->num_rows() > 0) {
                 foreach ($getorder_types->result() as $res) {
                     $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                 }
             }else{
              $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
              if($getorders->num_rows() >0){
                  foreach($getorders->result() as $res){
                     $order_types[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
                 }
             }
         }

}
/*$getpickupid = $this->db->select("id")->get_where("tbl_party_master", array(
    "code" => $chkorder->row()->pickup_custid
), 1, 0);
if ($getpickupid->num_rows() > 0) {
$order_details['pickup_id'] = $getpickupid->row()->id;
}
$getdropid = $this->db->select("id")->get_where("tbl_party_master", array(
    "code" => $chkorder->row()->drop_custid
), 1, 0);
if ($getdropid->num_rows() > 0) {
$order_details['drop_id'] = $getdropid->row()->id;
}*/
$getpickupdetails = $this->smtcorder->getpickupdetails($pickup_id);
if ($getpickupdetails->num_rows() > 0) {
    $pickup_details = array(
        'id' => $getpickupdetails->row()->id,
        'name' => $getpickupdetails->row()->name,
        'party_id' => $getpickupdetails->row()->code,
        'address' => $getpickupdetails->row()->address,
        'pincode' => $getpickupdetails->row()->pincode,
        'country' => $getpickupdetails->row()->country
    );
}

$drop_id = $chkorder->row()->drop_custid;
$drop_row_id = $pickup = $drop = 0;
$party_row_ids = array();
$chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
if ($chekparty->num_rows() > 0) {
    foreach ($chekparty->result() as $rr) {

        $ptype = $rr->party_type;
        $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
            "id" => $ptype
        ), 1, 0);
        if ($chktype->num_rows() > 0) {

            if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                $chkconsignee = 1;
                $gen_consignee_id = $rr->id;
                if($chkdelivery == 0){
                    $drop = $rr->id;
                    $drop_details = array( 'id'=>$rr->id,'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                $chkshipper = 1;
                $gen_shipper_id = $rr->id;
                if($chkpickup == 0){
                    $pickup = $rr->id;
                    $shipper_details = array('id'=>$rr->id,'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                $chkdelivery = 1;
                $drop = $rr->id;
                $drop_details = array('id'=>$rr->id, 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_consignee_id >0){
                }else{
                    $gen_consignee_id = $rr->id;
                }
            }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                $chkpickup = 1;
                $pickup = $rr->id;
                $shipper_details = array('id'=>$rr->id,'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_shipper_id > 0){
                }else{
                    $gen_shipper_id = $rr->id;
                }
            } elseif (!in_array(strtoupper($chktype->row()->name), ["CARRIER", "CUSTOMER"])){
                $party_row_ids[] = $rr->id;
            }
        }
    }
}
$order_details['pickup_id'] = $pickup;
$order_details['drop_id'] = $drop;
if($gen_shipper_id >0){
        $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
        if ($getshipperdetails->num_rows() > 0) {
            $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
        }
    }
    if($gen_consignee_id >0){
        $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
        if ($getconsigneedetails->num_rows() > 0) {
            $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
        }
    }
$shipper_details['name'] = $chkorder->row()->pickup;
$shipper_details['street'] = $chkorder->row()->pickup_address1;
$shipper_details['state'] = $chkorder->row()->pickup_address2;
$shipper_details['city'] = $chkorder->row()->pickup_city;
$shipper_details['country'] = $chkorder->row()->pickup_country;
$shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

$drop_details['name'] = $chkorder->row()->delivery;
$drop_details['street'] = $chkorder->row()->delivery_address1;
$drop_details['state'] = $chkorder->row()->delivery_address2;
$drop_details['city'] = $chkorder->row()->delivery_city;
$drop_details['country'] = $chkorder->row()->delivery_country;
$drop_details['pincode'] = $chkorder->row()->delivery_pincode;
$drop_id = $chkorder->row()->drop_custid;
}

$user_id = $this->session->userdata('user_id');
$roles = array();
$qyery = $this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name");
if ($qyery->num_rows() > 0) {
    foreach ($qyery->result() as $res) {
        $roles[] = array(
            'id' => $res->id,
            'name' => $res->name
        );
    }
}
$getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array(
    'status' => '1'
));
if ($getchargecodes->num_rows() > 0) {
    foreach ($getchargecodes->result() as $res) {
        $chargecodes[] = array(
            'charge_id' => $res->id,
            'charge_code' => $res->charge_code
        );
    }
}
$cdate = date('Y-m-d H:i:s');
$cargo_row_ids = array();
$qry = $this->db->query("SELECT c.*,o.id as orderCargoId FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
if ($qry->num_rows() > 0) {
    foreach ($qry->result() as $res) {
        $cargo_ins = [
            'cargo_type' => $res->cargo_type,
            'goods_description' => $res->goods_description,
            'quantity' => $res->quantity,
            'length' => $res->length,
            'length_unit' => $res->length_unit,
            'width' => $res->width,
            'width_unit' => $res->width_unit,
            'height' => $res->height,
            'height_unit' => $res->height_unit,
            'weight' => $res->weight,
            'weight_unit' => $res->weight_unit,
            'volume' => $res->volume,
            'volume_unit' => $res->volume_unit,
            'stackable' => $res->stackable,
            'grounded' => $res->grounded,
            'splittable' => $res->splittable,
            'createdby' => $user_id,
            'volumetric_weight' => $res->volumetric_weight,
            'volweight_uom' => $res->volweight_uom,
            'createdon' => $cdate,
            'ldm' => $res->ldm,
            'second_weight' => $res->second_weight,
            'secondweight_uom' => $res->secondweight_uom,
            'second_volume' => $res->second_volume,
            'secondvolume_uom' => $res->secondvolume_uom,
            'dg_goods' => $res->dg_goods,
        ];
        $cargo_row_ids[] = $cargoRowId = $this->common->insertTableData("tb_cargo_details", $cargo_ins);
        if ($res->dg_goods > 0) {
            $checkDgGoods = $this->common->gettbldata(['order_cargo_id' => $res->orderCargoId, 'status' => '1'], "*", "tb_order_dg_goods", 0, 0);
            foreach ($checkDgGoods as $eachRow) {
                $this->common->insertTableData("tb_order_dg_goods", [
                    'order_id' => 0,
                    'order_cargo_id' => $cargoRowId,
                    'num_pkgs' => $eachRow['num_pkgs'],
                    'pkg_qty_type' => $eachRow['pkg_qty_type'],
                    'quantity' => $eachRow['quantity'],
                    'quantity_type' => $eachRow['quantity_type'],
                    'org_number' => $eachRow['org_number'],
                    'org_name' => $eachRow['org_name'],
                    'org_num_varient' => $eachRow['org_num_varient'],
                    'db_class' => $eachRow['db_class'],
                    'mainrisk' => $eachRow['mainrisk'],
                    'description' => $eachRow['description'],
                    'limitqty_flag' => $eachRow['limitqty_flag'],
                    'exceptqty_flag' => $eachRow['exceptqty_flag'],
                    'limited_quantity' => $eachRow['limited_quantity'],
                    'excepted_quantity' => $eachRow['excepted_quantity'],
                    'tunnel_restriction_code' => $eachRow['tunnel_restriction_code'],
                    'transport_category' => $eachRow['transport_category'],
                    'environment_hazardous' => $eachRow['environment_hazardous'],
                    'nos' => $eachRow['nos'],
                    'adr_multiplicator' => $eachRow['adr_multiplicator'],
                    'total_adr_points' => $eachRow['total_adr_points'],
                    'adr_version' => $eachRow['adr_version'],
                    'subsidiary_risks' => $eachRow['subsidiary_risks'],
                    'packing_group' => $eachRow['packing_group'],
                    'gross_weight' => $eachRow['gross_weight'],
                    'net_weight' => $eachRow['net_weight'],
                    'netexplosive_mass' => $eachRow['netexplosive_mass'],
                    'liters' => $eachRow['liters'],
                    'fire_works' => $eachRow['fire_works']
                ]);
            }
        }
    }
}
}
$transport = array();
$order_date=$createdon;
$less_date ='2021-03-19 00:00:00';
$transport = gettransportmode($order_date,$less_date);
$cargo_id = "";
if (!empty($cargo_row_ids)) {
    $cargo_id = implode(',', $cargo_row_ids);
}
$party_id = "";
if (!empty($party_row_ids)) {
    $party_id = implode(',', $party_row_ids);
}
$sub_cut_parties = array();
if($chkpickup == 0 && $chkdelivery == 0){
    $sub_cut_parties['0'] = 0;
    $sub_cut_parties['1'] = 0;
    $sub_cut_parties['2'] = $gen_shipper_id;
    $sub_cut_parties['3'] = $gen_consignee_id;
}

if (!empty($sub_cut_parties)) {
    subcustpartiesinsert($chkorder->row()->id, $chkorder->row()->order_id, $sub_cut_parties);
}
$order_details['cargo_id'] = $cargo_id;
$order_details['party_id'] = $party_id;
$order_details['shipper_id'] = $gen_shipper_id;
$order_details['consignee_id'] = $gen_consignee_id;
$data['transport'] = $transport;
$data['order_details'] = $order_details;
$data['pickup_details'] = $pickup_details;
$data['drop_details'] = $drop_details;
$data['shipper_details'] = $shipper_details;
$data['order_types'] = $order_types;
$data['delivery_array'] = $delivery_array;
$data['chargecodes'] = $chargecodes;
$data['roles'] = $roles;
$data['shipper_data'] = $shipper_data;
$data['consignee_data'] = $consignee_data;
$data['order_type_flag'] = 'copy';
$this->newtemplate->dashboard('smtcorders/copyorder', $data);
}

public function reverseorder($id = NULL) {

	if($this->session->userdata('business_type') == "Carrier")
	{
		redirect('welcome/logout');
	}
    if (!checkUrlAccessForUser('SMTCORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data = $order_types = [];
    $order_details = $shipper_details = $drop_details = $pickup_details = $delivery_array = $chargecodes = $shipper_data = $consignee_data = [];
    $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = $gen_shipper_id = $gen_consignee_id = 0;
    $order_details['type_name'] = $order_details['ordtype_code'] = "";
    $data['currencies'] = array();
    if ($id != "") {
        $data['currencies'] = $this->smtcorder->getallcurrencies();
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm = $chkorder->row()->incoterm;
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = $purchase_order = "";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='" . $id . "' AND reference_id IN ('DQ','PO','ORD_DLVINST','ORD_PIKINST','CTR')");
            if ($getdnote->num_rows() > 0) {
                foreach ($getdnote->result() as $ref) {
                    $ref_id = $ref->reference_id;
                    if ($ref_id == 'DQ') {
                        $shipment_id = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_DLVINST') {
                        $delivery_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_PIKINST') {
                        $pickup_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'CTR') {
                        $container_no = $ref->ref_value;
                    }
                    if ($ref_id == 'PO') {
                        $purchase_order = $ref->ref_value;
                    }
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
/*
 * if($trip_id != 0 && $trip_sts == 0){
 * $order_status = 'ACTIVE';
 * }
 * if($trip_id != 0 && $trip_sts == 1){
 * $order_status = 'CLOSED';
 * }
 */
$chkdate = '2020-07-01 00:00:00';
$createdon = $chkorder->row()->createdon;
$order_str = strtotime($createdon);
$chk_str = strtotime($chkdate);
$early_pickup = $chkorder->row()->pickup_datetime;
$docs_received_datetime = $chkorder->row()->docs_received_datetime;
$docs_sent_datetime = $chkorder->row()->docs_sent_datetime;
$early_delivery = $chkorder->row()->delivery_datetime;
$late_pickup = $chkorder->row()->pickup_endtime;
$late_delivery = $chkorder->row()->drop_endtime;
$curtz = $this->session->userdata("usr_tzone")['timezone'];
if ($order_str > $chk_str) {
    if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
        $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
        $early_pickup = $epickup['datetime'];
    }
    if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
        $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
        $early_delivery = $edelivery['datetime'];
    }
    if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
        $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
        $late_pickup = $lpickup['datetime'];
    }
    if ($late_delivery != "" && $late_delivery !== "0000-00-00 00:00:00") {
        $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
        $late_delivery = $ldelivery['datetime'];
    }
}
if ($docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00") {
    $docsent = getdatetimebytimezone($curtz, $docs_sent_datetime, DFLT_TZ);
    $docs_sent_datetime = $docsent['datetime'];
}
if ($docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00") {
    $docrec = getdatetimebytimezone($curtz, $docs_received_datetime, DFLT_TZ);
    $docs_received_datetime = $docrec['datetime'];
}
$order_details = array(
    'id' => $chkorder->row()->id,
    'order_id' => $chkorder->row()->order_id,
    'shipment_id' => $shipment_id,
    'early_pickup' => $early_pickup,
    'early_delivery' => $early_delivery,
    'late_pickup' => $late_pickup,
    'late_delivery' => $late_delivery,
    'product' => $chkorder->row()->product,
    'service' => $chkorder->row()->service,
    'delivery_term' => $chkorder->row()->delivery_term,
    'incoterm' => $chkorder->row()->incoterm,
    'delivery_note' => $chkorder->row()->delivery_note,
    'purchase_order' => $purchase_order,
    'notify_party' => $chkorder->row()->notify_party,
    'goods_value' => $chkorder->row()->goods_value,
    'currency' => $chkorder->row()->currency,
    'lane_reference' => $chkorder->row()->lane_reference,
    'distance' => $chkorder->row()->distance,
    'customs_required' => $chkorder->row()->customs_required,
    'high_cargo_value' => $chkorder->row()->high_cargo_value,
    'valorance_insurance' => $chkorder->row()->valorance_insurance,
    'temperature_control' => $chkorder->row()->temperature_control,
    'company_code' => $chkorder->row()->company_code,
    'branch_code' => $chkorder->row()->branch_code,
    'department_code' => $chkorder->row()->department_code,
    'createdon' => $chkorder->row()->createdon,
    'order_type' => $chkorder->row()->order_type,
    'transport_mode' => $chkorder->row()->transport_mode,
    'pickup_inst' => $pickup_inst,
    'delivery_inst' => $delivery_inst,
    'container_no' => $container_no,
    'docs_received_datetime' => $docs_received_datetime,
    'docs_sent_datetime' => $docs_sent_datetime,
    'pickup_custid' => $chkorder->row()->pickup_custid,
    'drop_custid' => $chkorder->row()->drop_custid,
);
$order_details['order_status'] = $order_status;
if ($incoterm != '') {
    $delivery_array = getDeliverytermsbyIncoterm($incoterm);
}
$o_shipper_id = $chkorder->row()->o_shipper_id;
    if($o_shipper_id >0){
        $gen_shipper_id = $o_shipper_id;
    }
    $o_consignee_id = $chkorder->row()->consignee_id;
    if($o_consignee_id >0){
        $gen_consignee_id = $o_consignee_id;
    }
$pickup_id = $chkorder->row()->customer_id;
$company_code = $this->session->userdata('company_code');
if ($company_code != "") {
    $company_code = $chkorder->row()->company_code;
}
$getorder_types = $this->db->select("id,type_name")->get_where("tb_order_types", array(
    'company_code' => $company_code,
    'status' => 1
));
if ($getorder_types->num_rows() > 0) {
    foreach ($getorder_types->result() as $res) {
        $order_types[] = array(
            'type_name' => $res->type_name,
            'type_id' => $res->id
        );
    }
}
$getpickupid = $this->db->select("id")->get_where("tbl_party_master", array(
    "code" => $chkorder->row()->pickup_custid
), 1, 0);
if ($getpickupid->num_rows() > 0) {
$order_details['pickup_id'] = $getpickupid->row()->id;
}
$getdeliveryid = $this->db->select("id")->get_where("tbl_party_master", array(
    "code" => $chkorder->row()->drop_custid
), 1, 0);
if ($getdeliveryid->num_rows() > 0) {
$order_details['drop_id'] = $getdeliveryid->row()->id;
}
$getpickupdetails = $this->smtcorder->getpickupdetails($pickup_id);
if ($getpickupdetails->num_rows() > 0) {
    $pickup_details = array(
        'id' => $getpickupdetails->row()->id,
        'name' => $getpickupdetails->row()->name,
        'party_id' => $getpickupdetails->row()->code,
        'address' => $getpickupdetails->row()->address,
        'pincode' => $getpickupdetails->row()->pincode,
        'country' => $getpickupdetails->row()->country
    );
}

$drop_id = $chkorder->row()->drop_custid;
$drop_row_id = $pickup = $drop = 0;
$party_row_ids = array();
$chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
if ($chekparty->num_rows() > 0) {
    foreach ($chekparty->result() as $rr) {

        $ptype = $rr->party_type;
        $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
            "id" => $ptype
        ), 1, 0);
        if ($chktype->num_rows() > 0) {
            if (strtoupper($chktype->row()->name) == "SHIPPER") {
                $chkshipper = 1;
                $gen_shipper_id = $rr->id;
                if($chkpickup == 0){
                    $pickup = $rr->id;
                    $shipper_details = array('id'=>$rr->id,'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            }else if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                $chkconsignee = 1;
                $gen_consignee_id = $rr->id;
                if($chkdelivery == 0){
                    $drop = $rr->id;
                    $drop_details = array('id'=>$rr->id, 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                }
            }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                $chkpickup = 1;
                $pickup = $rr->id;
                $shipper_details = array('id'=>$rr->id,'name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_shipper_id > 0){
                }else{
                    $gen_shipper_id = $rr->id;
                }
            }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                $chkdelivery = 1;
                $drop = $rr->id;
                $drop_details = array('id'=>$rr->id, 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                if($gen_consignee_id >0){
                }else{
                    $gen_consignee_id = $rr->id;
                }
            } elseif (!in_array(strtoupper($chktype->row()->name), ["CARRIER", "CUSTOMER"])) {
                $party_row_ids[] = $rr->id;
            }
        }
    }
}
$order_details['pickup_id'] = $pickup;
$order_details['drop_id'] = $drop;
if($gen_shipper_id >0){
        $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
        if ($getshipperdetails->num_rows() > 0) {
            $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
        }
    }
    if($gen_consignee_id >0){
        $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
        if ($getconsigneedetails->num_rows() > 0) {
            $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
        }
    }
$drop_details['name'] = $chkorder->row()->pickup;
$drop_details['street'] = $chkorder->row()->pickup_address1;
$drop_details['state'] = $chkorder->row()->pickup_address2;
$drop_details['city'] = $chkorder->row()->pickup_city;
$drop_details['country'] = $chkorder->row()->pickup_country;
$drop_details['pincode'] = $chkorder->row()->pickup_pincode;

$shipper_details['name'] = $chkorder->row()->delivery;
$shipper_details['street'] = $chkorder->row()->delivery_address1;
$shipper_details['state'] = $chkorder->row()->delivery_address2;
$shipper_details['city'] = $chkorder->row()->delivery_city;
$shipper_details['country'] = $chkorder->row()->delivery_country;
$shipper_details['pincode'] = $chkorder->row()->delivery_pincode;
$drop_id = $chkorder->row()->drop_custid;
}

$sub_cut_parties = array();
        if($chkpickup == 0 && $chkdelivery == 0){
            $sub_cut_parties['0'] = 0;
            $sub_cut_parties['1'] = 0;
            $sub_cut_parties['2'] = $gen_shipper_id;
            $sub_cut_parties['3'] = $gen_consignee_id;
        }

        if (!empty($sub_cut_parties)) {
            subcustpartiesinsert($chkorder->row()->id, $chkorder->row()->order_id, $sub_cut_parties);
        }
$user_id = $this->session->userdata('user_id');
$roles = array();
$qyery = $this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name");
if ($qyery->num_rows() > 0) {
    foreach ($qyery->result() as $res) {
        $roles[] = array(
            'id' => $res->id,
            'name' => $res->name
        );
    }
}
$getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array(
    'status' => '1'
));
if ($getchargecodes->num_rows() > 0) {
    foreach ($getchargecodes->result() as $res) {
        $chargecodes[] = array(
            'charge_id' => $res->id,
            'charge_code' => $res->charge_code
        );
    }
}
$cdate = date('Y-m-d H:i:s');
$cargo_row_ids = array();
$qry = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
if ($qry->num_rows() > 0) {
    foreach ($qry->result() as $res) {

        $cargo_ins = array(
            'cargo_type' => $res->cargo_type,
            'goods_description' => $res->goods_description,
            'quantity' => $res->quantity,
            'length' => $res->length,
            'length_unit' => $res->length_unit,
            'width' => $res->width,
            'width_unit' => $res->width_unit,
            'height' => $res->height,
            'height_unit' => $res->height_unit,
            'weight' => $res->weight,
            'weight_unit' => $res->weight_unit,
            'volume' => $res->volume,
            'volume_unit' => $res->volume_unit,
            'stackable' => $res->stackable,
            'grounded' => $res->grounded,
            'splittable' => $res->splittable,
            'volumetric_weight' => $res->volumetric_weight,
            'volweight_uom' => $res->volweight_uom,
            'createdby' => $user_id,
            'createdon' => $cdate,
            'ldm' => $res->ldm
        );
        $ins_cargo = $this->db->insert("tb_cargo_details", $cargo_ins);
        $cargo_row_ids[] = $this->db->insert_id();
        /* array_push($ids,$cargo_row_id); */
    }
}
}
$transport = array();
$order_date=$createdon;
$less_date ='2021-03-19 00:00:00';
$transport = gettransportmode($order_date,$less_date);
$cargo_id = "";
if (!empty($cargo_row_ids)) {
    $cargo_id = implode(',', $cargo_row_ids);
}
$party_id = "";
if (!empty($party_row_ids)) {
    $party_id = implode(',', $party_row_ids);
}
$order_details['cargo_id'] = $cargo_id;
$order_details['party_id'] = $party_id;
$order_details['shipper_id'] = $gen_shipper_id;
$order_details['consignee_id'] = $gen_consignee_id;
$data['transport'] = $transport;
$data['order_details'] = $order_details;
$data['pickup_details'] = $pickup_details;
$data['drop_details'] = $drop_details;
$data['shipper_details'] = $shipper_details;
$data['order_types'] = $order_types;
$data['delivery_array'] = $delivery_array;
$data['chargecodes'] = $chargecodes;
$data['roles'] = $roles;
$data['shipper_data'] = $shipper_data;
$data['consignee_data'] = $consignee_data;
$data['order_type_flag'] = 'reverse';

$this->newtemplate->dashboard('smtcorders/copyorder', $data);
}

public function editorder($id = NULL) {

	if($this->session->userdata('business_type') == "Carrier")
	{
		redirect('welcome/logout');
	}
    if (!checkUrlAccessForUser('SMTCORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data = $order_types = [];
    $data['currencies'] = [];
    $order_details = $shipper_details = $shipper_data = $consignee_data = $drop_details = $pickup_details = $delivery_array = $chargecodes = $vdata = [];
    $gen_shipper_id = $gen_consignee_id =  $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = 0;
    $order_details['type_name'] = $order_details['ordtype_code'] =  $vendor_name = $vendor_code = "";
     $res=$this->db->query("SELECT DISTINCT currency  FROM `tbl_country_master`WHERE status=1  ORDER BY currency");
        if($res->num_rows() > 0){
            foreach ($res->result() as $cur) {
                $data['currencies'][] = $cur->currency;
            }
        }
     if ($id != "") {
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            if ($chkorder->row()->status == 3) {
                redirect("Forbiddenaccess");
            }
            $vendor_id = $chkorder->row()->vendor_id;
            if($vendor_id == ""){
                $vendor_id = 0;
            }

            if($vendor_id >0){
                $getvcode = $this->common->gettblrowdata(array("id"=>$vendor_id),"code,company_code","tb_vendors",0,0);
                if(!empty($getvcode)){
                    $vendor_code = $getvcode['code'];
                    $vendor_company_code = $getvcode['company_code'];
                    if($vendor_company_code == ""){
                        $vendor_company_code = $this->session->userdata('user_id');
                    }
                    if($vendor_code != ""){
                        $getvendor_details = $this->common->gettblrowdata(array("code"=>$vendor_code,'status'=>'1','company_code'=>$vendor_company_code),"name,code","tbl_party_master",0,0);
                        if(!empty($getvendor_details)){
                            $vendor_name = $getvendor_details['name'];
                            $vendor_code = $getvendor_details['code'];
                        }
                    }
                }
            }
            $incoterm = $chkorder->row()->incoterm;
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = $purchase_order = "";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='" . $id . "' AND reference_id IN ('DQ','PO','ORD_DLVINST','ORD_PIKINST','CTR')");
            if ($getdnote->num_rows() > 0) {
                foreach ($getdnote->result() as $ref) {
                    $ref_id = $ref->reference_id;
                    if ($ref_id == 'DQ') {
                        $shipment_id = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_DLVINST') {
                        $delivery_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_PIKINST') {
                        $pickup_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'CTR') {
                        $container_no = $ref->ref_value;
                    }
                    if ($ref_id == 'PO') {
                        $purchase_order = $ref->ref_value;
                    }
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            if ($trip_id != 0 && $trip_sts == 0) {
                $order_status = 'ACTIVE';
            }
            if ($trip_id != 0 && $trip_sts == 1) {
                $order_status = 'CLOSED';
            }
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;

            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $docs_received_datetime = $chkorder->row()->docs_received_datetime;
            $docs_sent_datetime = $chkorder->row()->docs_sent_datetime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if ($order_str > $chk_str) {
                if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                    $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                    $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
                    $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if ($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00") {
                    $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }
            }
            if ($docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00") {
                $docsent = getdatetimebytimezone($curtz, $docs_sent_datetime, DFLT_TZ);
                $docs_sent_datetime = $docsent['datetime'];
            }
            if ($docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00") {
                $docrec = getdatetimebytimezone($curtz, $docs_received_datetime, DFLT_TZ);
                $docs_received_datetime = $docrec['datetime'];
            }

            $order_details = array(
                'id' => $chkorder->row()->id,
                'order_id' => $chkorder->row()->order_id,
                'shipment_id' => $shipment_id,
                'early_pickup' => $early_pickup,
                'early_delivery' => $early_delivery,
                'late_pickup' => $late_pickup,
                'late_delivery' => $late_delivery,
                'product' => $chkorder->row()->product,
                'service' => $chkorder->row()->service,
                'delivery_term' => $chkorder->row()->delivery_term,
                'incoterm' => $chkorder->row()->incoterm,
                'delivery_note' => $chkorder->row()->delivery_note,
                'purchase_order' => $purchase_order,
                'notify_party' => $chkorder->row()->notify_party,
                'goods_value' => $chkorder->row()->goods_value,
                'currency' => $chkorder->row()->currency,
                'lane_reference' => $chkorder->row()->lane_reference,
                'distance' => $chkorder->row()->distance,
                'customs_required' => $chkorder->row()->customs_required,
                'high_cargo_value' => $chkorder->row()->high_cargo_value,
                'valorance_insurance' => $chkorder->row()->valorance_insurance,
                'temperature_control' => $chkorder->row()->temperature_control,
                'company_code' => $chkorder->row()->company_code,
                'branch_code' => $chkorder->row()->branch_code,
                'department_code' => $chkorder->row()->department_code,
                'createdon' => $chkorder->row()->createdon,
                'order_type' => $chkorder->row()->order_type,
                'transport_mode' => $chkorder->row()->transport_mode,
                'pickup_inst' => $pickup_inst,
                'delivery_inst' => $delivery_inst,
                'container_no' => $container_no,
                'docs_received_datetime' => $docs_received_datetime,
                'docs_sent_datetime' => $docs_sent_datetime,
                'pickup_custid' => $chkorder->row()->pickup_custid,
                'drop_custid' => $chkorder->row()->drop_custid,
                'vendor_code'=>$vendor_code,
                'vendor_name'=>$vendor_name
            );
            $o_shipper_id = $chkorder->row()->o_shipper_id;
            if($o_shipper_id >0){
                $gen_shipper_id = $o_shipper_id;
            }
            $o_consignee_id = $chkorder->row()->consignee_id;
            if($o_consignee_id >0){
                $gen_consignee_id = $o_consignee_id;
            }
            $order_details['order_status'] = $order_status;
            $getpickupid = $this->db->select("id")->get_where("tbl_party_master", array(
                "code" => $chkorder->row()->pickup_custid
            ), 1, 0);
            if ($getpickupid->num_rows() > 0) {
            $order_details['pickup_id'] = $getpickupid->row()->id;
            }
            $getdropid = $this->db->select("id")->get_where("tbl_party_master", array(
                "code" => $chkorder->row()->drop_custid
            ), 1, 0);
            if ($getdropid->num_rows() > 0) {
                $order_details['drop_id'] = $getdropid->row()->id;
            }
            if ($incoterm != '') {
                $delivery_array = getDeliverytermsbyIncoterm($incoterm);
            }
            $pickup_id = $chkorder->row()->customer_id;
            $vendor_id = $chkorder->row()->vendor_id;
            $user_id = $this->session->userdata('user_id');
            $pickup_location = array(
                'country' => $chkorder->row()->pickup_country,
                'zipcode' => $chkorder->row()->pickup_pincode,
                'user_id' => $user_id,
                'city' => $chkorder->row()->pickup_city
            );
            $delivery_location = array(
                'country' => $chkorder->row()->delivery_country,
                'zipcode' => $chkorder->row()->delivery_pincode,
                'user_id' => $user_id,
                'city' => $chkorder->row()->delivery_city
            );
            $info = array(
                'order_id' => $id,
                'product' => $chkorder->row()->product
            );
            $data['rates'] = $this->ratemanagement->getcustomerprofiledetailsbyid($pickup_id, $chkorder->row()->service, $pickup_location, $delivery_location, $info);
            $data['vendor_rates'] = $this->ratemanagement->getvendorprofiledetailsbyid($vendor_id, $chkorder->row()->service, $info);
            $company_code = $this->session->userdata('company_code');
            if ($company_code == "") {
                $company_code = $chkorder->row()->company_code;
            }
            $getorders = $this->db->select("id,type_name")
            ->group_by("type_name")
            ->get_where("tb_order_types", array(
                'customer_id' => $pickup_id,
                'company_code' => $company_code,
                'status' => '1'
            ));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $order_types[] = array(
                        'type_id' => $res->id,
                        'type_name' => $res->type_name
                    );
                }
            } else {
                $getorder_types = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
                if ($getorder_types->num_rows() > 0) {
                 foreach ($getorder_types->result() as $res) {
                     $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                 }
             }else{
              $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
              if($getorders->num_rows() >0){
                  foreach($getorders->result() as $res){
                     $order_types[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
                 }
             }
         }



            }

            $getpickupdetails = $this->smtcorder->getpickupdetails($pickup_id);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array(
                    'id' => $getpickupdetails->row()->id,
                    'name' => $getpickupdetails->row()->name,
                    'party_id' => $getpickupdetails->row()->code,
                    'address' => $getpickupdetails->row()->address,
                    'pincode' => $getpickupdetails->row()->pincode,
                    'country' => $getpickupdetails->row()->country
                );
            }
            $drop_id = $chkorder->row()->drop_custid;
            $drop_row_id = 0;
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
                        "id" => $ptype
                    ), 1, 0);
                    if ($chktype->num_rows() > 0) {
                        if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                            $chkconsignee = 1;
                            $gen_consignee_id = $rr->id;
                            if($chkdelivery == 0){
                                $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                            $chkshipper = 1;
                            $gen_shipper_id = $rr->id;
                            if($chkpickup == 0){
                                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                            $chkdelivery = 1;
                            $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($gen_consignee_id >0){
                            }else{
                                $gen_consignee_id = $rr->id;
                            }
                        }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                            $chkpickup = 1;
                            $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($gen_shipper_id > 0){
                            }else{
                                $gen_shipper_id = $rr->id;
                            }
                        }
                    }
                }
            }
            if($gen_shipper_id >0){
                $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
                if ($getshipperdetails->num_rows() > 0) {
                    $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
                }
            }
            if($gen_consignee_id >0){
                $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
                if ($getconsigneedetails->num_rows() > 0) {
                    $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
                }
            }
            $sub_cut_parties = array();
            if($chkpickup == 0 && $chkdelivery == 0){
                $sub_cut_parties['0'] = 0;
                $sub_cut_parties['1'] = 0;
                $sub_cut_parties['2'] = $gen_shipper_id;
                $sub_cut_parties['3'] = $gen_consignee_id;
            }

            if (!empty($sub_cut_parties)) {
                subcustpartiesinsert($chkorder->row()->id, $chkorder->row()->order_id, $sub_cut_parties);
            }
            $order_details['shipper_id'] = $gen_shipper_id;
            $order_details['consignee_id'] = $gen_consignee_id;
            $shipper_details['name'] = $chkorder->row()->pickup;
            $shipper_details['street'] = $chkorder->row()->pickup_address1;
            $shipper_details['state'] = $chkorder->row()->pickup_address2;
            $shipper_details['city'] = $chkorder->row()->pickup_city;
            $shipper_details['country'] = $chkorder->row()->pickup_country;
            $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

            $drop_details['name'] = $chkorder->row()->delivery;
            $drop_details['street'] = $chkorder->row()->delivery_address1;
            $drop_details['state'] = $chkorder->row()->delivery_address2;
            $drop_details['city'] = $chkorder->row()->delivery_city;
            $drop_details['country'] = $chkorder->row()->delivery_country;
            $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
            $drop_id = $chkorder->row()->drop_custid;
        }
        $roles = array();
        $qyery = $this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '" . $user_id . "' AND status=1 GROUP BY name");
        if ($qyery->num_rows() > 0) {
            foreach ($qyery->result() as $res) {
                $roles[] = array(
                    'id' => $res->id,
                    'name' => $res->name
                );
            }
        }
        $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array(
            'status' => '1'
        ));
        if ($getchargecodes->num_rows() > 0) {
            foreach ($getchargecodes->result() as $res) {
                $chargecodes[] = array(
                    'charge_id' => $res->id,
                    'charge_code' => $res->charge_code
                );
            }
        }
    }
    $vas_ids = array();

    $getvas_ids = $this->db->select("id,vas_id,vas_name")->get_where("tb_vas_master", array(
        'status' => '1',
        'company_code!=' => 'RUKN'
    ));
    if ($getvas_ids->num_rows() > 0) {
        foreach ($getvas_ids->result() as $res) {
            $vas_ids[] = array(
                'vas_row_id' => $res->id,
                'vas_id' => $res->vas_id . "-" . addslashes($res->vas_name)
            );
        }
    }
    $transport = array();
    $order_date=$createdon;
    $less_date ='2021-03-19 00:00:00';
    $transport = gettransportmode($order_date,$less_date);
    $data['stoppagecodes'] = $data['resolutioncodes'] = array();
    $select = "id,code";
    $getstoppage = $this->smtcorder->getmasters('tbl_stoppage_master', $select);
    if ($getstoppage->num_rows() > 0) {
        foreach ($getstoppage->result() as $res) {
            $data['stoppagecodes'][] = array(
                'id' => $res->id,
                'code' => $res->code
            );
        }
    }
    $select = "id,name";
    $getresolution = $this->smtcorder->getmasters('tbl_resolution_master', $select);
    if ($getresolution->num_rows() > 0) {
        foreach ($getresolution->result() as $res) {
            $data['resolutioncodes'][] = array(
                'id' => $res->id,
                'name' => $res->name
            );
        }
    }

$data['vatcategory'] = array();
$getvatcategory = $this->common->gettbldata(array(
    'company_code' => $company_code,
    'status' => '1'
), "id,description,vat_category,vat_percentage", "tb_vat_category", 0, 0);
if (!empty($getvatcategory)) {
    foreach ($getvatcategory as $res) {
        $val = $res['id'] . "_" . $res['vat_category'];
        $desc = $res['description'] . " (" . $res['vat_category'] . "-" . $res['vat_percentage'] . ")";
        $data['vatcategory'][] = array(
            'id' => $res['id'],
            'val' => $val,
            'desc' => $desc
        );
    }
}
$data['transport'] = $transport;
$data['order_details'] = $order_details;
$data['pickup_details'] = $pickup_details;
$data['drop_details'] = $drop_details;
$data['shipper_details'] = $shipper_details;
$data['order_types'] = $order_types;
$data['delivery_array'] = $delivery_array;
$data['chargecodes'] = $chargecodes;
$data['roles'] = $roles;
$data['vas_ids'] = $vas_ids;
$data['shipper_data'] = $shipper_data;
$data['consignee_data'] = $consignee_data;
// $data['cargos'] = $cargos;

$this->newtemplate->dashboard('smtcorders/editorder', $data);
}

public function viewroletypelist() {
    $data = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $type = isset($post['type']) ? $post['type'] : "";
    if ($type != "") {
        $user_id = $this->session->userdata('user_id');
        if ($user_id != '0') {
            if ($type == "Vendor") {
                $type = "Carrier";
            }
            $user_whr = "m.user_id ='" . $user_id . "'";
            $company_code = $this->session->userdata('company_code');
            $permission = checkuserpermissions();
            if(in_array("businesspartners", $permission)){
                $xborderdetails  = $this->db->select( "xborder_code" )->get_where( "tb_xborder_country", array( 'company_code' => $company_code ) );
				if ( $xborderdetails->num_rows() > 0 ) {
					 $xborder_code= $xborderdetails->row()->xborder_code;
					 if($xborder_code!=""){
						$xborder_company=explode(",",$xborder_code);
						$user_whr = " m.company_code IN ('" . $company_code . "','" . implode( "','", $xborder_company ) . "')";
					 }else{
						$user_whr = " m.company_code LIKE '" . $company_code . "' ";
					 }
				}else{
					$user_whr = " m.company_code LIKE '" . $company_code . "' ";
				}
            } else {
                $user_whr = "m.user_id ='" . $user_id . "'";
            }
            $this->db->select("m.id,m.name,m.email,m.code,m.company_code,m.branch_code,m.country,m.location_id,m.street");
            $this->db->from("tbl_party_master m");
            $this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
            if ($type == "Overseas OL") {
                $this->db->where('m.category_type', 'Overseas OL');
            } else if ($type == "Internal BU") {
                $this->db->where('m.category_type', 'KN Office');
            } else {
                $this->db->like("p.name", $type);
            }
            $this->db->where($user_whr);
            $where = "m.acon_debitor_code is  NOT NULL";
            $this->db->where($where);
            $getroles = $this->db->get();
            if ($getroles->num_rows() > 0) {
                foreach ($getroles->result() as $res) {
                    $check = "";
                    if ($type == "Customer") {
                        $check = "<input class='rolelist' type='radio' name='selectrole' id='rolelist_" . $res->id . "' value='" . $res->code . "' onchange=selectrolebyid(" . $res->id . ")>";
                    }
                    if ($type == "Carrier") {
                        $check = "<input class='vendorlist' type='radio' name='selectvendor' id='vendorlist_" . $res->id . "' value='" . $res->code . "' onchange=selectvendorbyid(" . $res->id . ")>";
                    }
                    if ($type == "Overseas OL" || $type == "Internal BU") {
                        $check = "<input class='twopartieslist' type='radio' name='selectparties' id='twopartieslist_" . $res->id . "' value='" . $res->code . "' onchange=selectpartiesbyid(" . $res->id . ")>";
                    }
                    $data[] = array(
                        'check' => $check,
                        'id' => $res->id,
                        'code' => $res->code,
                        'name' => $res->name,
                        'email_id' => $res->email,
                        'company_code' => $res->company_code,
                        'branch_code' => $res->branch_code,
                        'country' => $res->country,
                        'street' => $res->street,
                        'city' => $res->location_id
                    );
                }
            }
        }
    }
    echo json_encode($data);
}

    public function getorderstatusdetails()
    {
        $status = $statusCodes = $remainingStatusCodes = [];
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $orderId = $this->input->post('order_id', true);
        if ($orderId > 0) {
            $getOrderDetails = $this->common->gettblrowdata(['id' => $orderId], "shift_id,company_code", "tb_orders", 0, 0);
            if (!empty($getOrderDetails)) {
                $orderCompanyCode = $getOrderDetails['company_code'];
                $orderStatus = $this->common->getjointbldata("tb_order_status o", "tb_status_master s", "o.status_id = s.id", ['o.order_id' => $orderId, 'o.status' => '1'], "o.id,o.latitude,o.longitude,o.status_code,convertToClientTZ(o.status_date, '" . $currentTimeZone . "') as status_date,o.createdon,s.status_name", 0, 0);
                foreach ($orderStatus as $eachStatus) {
                    $locationName = getLocationName($eachStatus['latitude'], $eachStatus['longitude']);
                    $location = '"' . $locationName . '"';
                    $statusCode = '"' . $eachStatus['status_code'] . '"';
                    $createdon = $eachStatus['status_date'];
                    $date = '"' . $createdon . '"';
                    $stop_type = "P";
                    $statusValue = '"' . $eachStatus['status_code'] . '_' . $stop_type . '_' . $eachStatus['status_name'] . '"';
                    $statusName = '"' . $stop_type . '-' . $eachStatus['status_name'] . '"';
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this," . $eachStatus['id'] . "," . $statusCode . "," . $location . "," . $date . "," . $statusValue . "," . $statusName . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
                    $status[] = [
                        'id' => $eachStatus['id'],
                        'status_name' => $eachStatus['status_name'],
                        'date' => $createdon,
                        'action' => $action,
                        'stop_id' => $eachStatus['status_code'],
                        'status_type' => $stop_type,
                        'location' => $locationName
                    ];
                }
                $stopStatus = $this->smtcorder->getStopStatusForOrder(['orderId' => $orderId, 'timeZone' => $currentTimeZone, 'orderCompanyCode' => $orderCompanyCode]);
                foreach ($stopStatus as $eachStatus) {
                    $statusCodes[] = $eachStatus['status_code'];
                }
                $orderShiftId = $getOrderDetails['shift_id'];
                if ($orderShiftId > 0) {
                    if (!in_array('0212', $statusCodes)) {
                        $remainingStatusCodes[] = '0212';
                    }
                    if (!in_array('0100', $statusCodes)) {
                        $remainingStatusCodes[] = '0100';
                    }
                    if (!empty($remainingStatusCodes)) {
                        $getDriverAcceptence = $this->common->gettbldata("status_code IN (" . implode(',', $remainingStatusCodes) . ") and shipment_id ='" . $orderShiftId . "' AND status =1", "id,latitude,longitude,loc_name,stop_id,stop_type,status_code,convertToClientTZ(createdon,'" . $currentTimeZone . "') as createdon,reason", "tb_stop_status", 0, 0);
                        foreach ($getDriverAcceptence as $eachRow) {
                            if ($eachRow['status_code'] == '0100') {
                                $eachRow['status_name'] = "Booked by Supplier";
                            } else {
                                $eachRow['status_name'] = "Accepted by Driver";
                            }
                            $stopStatus[] = $eachRow;
                        }
                    }
                }
                foreach ($stopStatus as $eachStatus) {
                    $locationName = $eachStatus['loc_name'];
                    if ($locationName == "") {
                        $locationName = getLocationName($eachStatus['latitude'], $eachStatus['longitude']);
                    }
                    $location = '"' . $locationName . '"';
                    $statusCode = '"' . $eachStatus['status_code'] . '"';
                    $stopType = $eachStatus['stop_type'];
                    if ($stopType == "") {
                        $stopType = "P";
                    }
                    if ($statusCode == 'KN007') {
                        $name = 'PickUp';
                    } else {
                        $name = $eachStatus['status_name'];
                    }
                    $statusValue = '"' . $eachStatus['status_code'] . '_' . $stopType . '_' . $name . '"';
                    $date = '"' . $eachStatus['createdon'] . '"';
                    $statusName = '"' . $stopType . '-' . $name . '"';
                    $finalStatusName = $eachStatus['status_name'];
                    if(in_array($eachStatus['status_code'],['1500','1600'])){
                        $stopType = "";
                    }
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddstatus(this);'><span class='glyphicon glyphicon-plus' > </span>Add Status</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowEditStatus(this," . $eachStatus['id'] . "," . $statusCode . "," . $location . "," . $date . "," . $statusValue . "," . $statusName . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li></ul></li></ul>";
                    $status[] = [
                        'id' => $eachStatus['id'],
                        'lattitude' => $eachStatus['latitude'],
                        'longitude' => $eachStatus['longitude'],
                        'stop_id' => $eachStatus['status_code'],
                        'status_name' => $finalStatusName,
                        'date' => $eachStatus['createdon'],
                        'action' => $action,
                        'location' => $locationName,
                        'status_type' => $stopType . " ( " . $eachStatus['reason'] . " )"
                    ];
                }
            }
        }
        echo json_encode($status);
    }

public function orddocsdetails() {
    $status = array();
    $order_id = $this->input->post('order_id', true);
    if ($order_id != "") {
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $sql1 = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath,ts.user_id from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.order_id = $order_id AND ts.status='1' GROUP BY ts.id");
        if ($sql1->num_rows() > 0) {
            foreach ($sql1->result() as $res) {
                $location_name = getLocationName($res->latitude, $res->longitude);

                if($location_name==''){

                     $where = array("id"=>$order_id);
                     $getlocationorder=$this->db->select("order_id")->get_where("tb_orders",$where,1,0);
                     if($getlocationorder->num_rows()>0){
                        $getorderrid=$getlocationorder->row()->order_id;
                         $where = array("order_id"=>$getorderrid);
                        $getlocation=$this->db->select(" `pickup`,`drop`")->get_where("tb_employee",$where,1,0);
                        if($getlocation->num_rows()>0){
                            if($res->stop_type=='P'){
                                $location_name = $getlocation->row()->pickup;
                            }
                            if($res->stop_type=='D'){
                                $location_name = $getlocation->row()->drop;
                            }
                        }

                     }
                }
                $imgpath = "";
                $allowed = array(
                    'pdf'
                );
                if ($res->imgpath != "") {
                    $base64DocumentData = getBase64DocumentData($res->imgpath);
                    $extention = $base64DocumentData['extention'];
                    $stringData = "'".$base64DocumentData['file_content']."',"."'".$extention."'";
                    if ($extention!= "") {
                        if (in_array($extention, $allowed)) {
                            $path = '<a onclick="return downloadDocument(' . $stringData . ')"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 10%;" type="application/pdf"></a>';
                        } else {
                            $path = '<a onclick="return downloadDocument(' . $stringData . ')"><img src="' . $base64DocumentData['file_content'] . '" class="img-responsive" style="width: 10%;"></a>';
                        }
                    }
                    $driver = getDrivernameById($res->createdby)["name"];
                    if($driver==""){
                        if($res->user_id!=0){
                            $where = array("id"=>$res->user_id);
                            $getuser=$this->db->select("name")->get_where("tb_users",$where,1,0);
                            if($getuser->num_rows()>0){
                                $driver = $getuser->row()->name;

                            }
                        }else{
                            $where = array("id"=>$this->session->userdata("user_id"));
                            $getuser=$this->db->select("name")->get_where("tb_users",$where,1,0);
                            if($getuser->num_rows()>0){
                                $driver = $getuser->row()->name;

                            }
                        }

                    }
                    $action = "";
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowdocAdd(this," . $order_id . ");'><span class='glyphicon glyphicon-plus' > </span>Add Doc</a></li></li></ul>";
                    $status[] = array(
                        'id' => $res->id,
                        'type_name' => $res->type_name,
                        'imgpath' => $path ?? '',
                        'stop_id' => $res->stop_id,
                        'stop_type' => $res->stop_type,
                        'date' => date("d M,y h:i A", strtotime($res->createdon)),
                        'action' => $action,
                        'location' => $location_name,
                        'driver' => $driver
                    );
                }
            }
        }
    }
    echo json_encode($status);
}

public function addorderdoc() {
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
    $data['stops'] = $data['document_types'] = array();
    $data['booking_id'] = $data['shift_id'] = $data['trip_id'] = $booking_id = 0;
    $data['company_code'] = $data['branch_code'] = "";
    if ($order_id != "" && $order_id != '0') {
        $ord = $order_id;
        $getorderdetails = $this->db->select("id,order_id,company_code,branch_code,shift_id,trip_id")->get_where("tb_orders", array(
            'id' => $order_id
        ));
        if ($getorderdetails->num_rows() > 0) {
            $data['order_row_id'] = $getorderdetails->row()->id;
            $data['booking_id'] = $booking_id = $getorderdetails->row()->order_id;
            $data['company_code'] = $getorderdetails->row()->company_code;
            $data['branch_code'] = $getorderdetails->row()->branch_code;
            $data['shift_id'] = $getorderdetails->row()->shift_id;
            $data['trip_id'] = $getorderdetails->row()->trip_id;
        }
        $sql = "SELECT o.id,o.stopname FROM tb_shiporder_stops o,tb_employee e WHERE o.shipment_id=e.shift_id AND e.order_id='" . $booking_id . "' AND o.status=1 AND e.status=1 ORDER BY o.ordernumber ASC";
        $stops = $this->db->query($sql);
        if ($stops->num_rows() > 0) {
            $data['stops'] = $stops->result_array();
            $data['document_types'] = $this->db->select("id,type_name")
            ->get_where("tb_document_types", array(
                "status" => 1
            ))
            ->result_array();
        } else {
            $data['document_types'] = $this->db->select("id,type_name")
            ->get_where("tb_document_types", array(
                "status" => 1,
                "type_name" => 'Others'
            ))
            ->result_array();
        }
    }
    echo json_encode($data);
}

    public function checktripfororder(): void
    {
        $orderId = $this->input->post('order_id', true);
        $response = $this->tripcreatefromorders->buildOrderStatusesSelect($orderId);
        echo json_encode($response);
    }

public function addstatus($id = NULL) {
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
    $curdt = $getactual['datetime'];
    $hrs = $this->session->userdata("usr_tzone")['hrs'];
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $order_id = isset($post['order_status_id']) ? $post['order_status_id'] : "0";
    $lattitude = $longitude = "";
    $booking_id = 0;
    if ($order_id != "0") {
        $user_id = $this->session->userdata('user_id');
/*
* if($user_id != ""){
* $getloc = $this->db->select('lat,lng')->get_where("tb_users",array('id'=>$user_id));
* if($getloc->num_rows() >0){
* $lattitude = $getloc->row()->lat;
* $longitude = $getloc->row()->lng;
* }
* }
*/
$shift_id = $trip_id = $ord_id = 0;
$createdsource = $plat = $plng = $dlat = $dlng = "";
$chkshft = $this->db->select("id,order_id,plat,plng,dlat,dlng,shift_id,trip_id,created_source")->get_where("tb_orders", array(
    'id' => $order_id
));
if ($chkshft->num_rows() > 0) {
    $booking_id = $chkshft->row()->order_id;
    $shift_id = $chkshft->row()->shift_id;
    $trip_id = $chkshft->row()->trip_id;
    $createdsource = $chkshft->row()->created_source;
    $ord_id = $chkshft->row()->id;
    if ($chkshft->row()->plat != "") {
        $plat = $chkshft->row()->plat;
        $plng = $chkshft->row()->plng;
    } else {
        $chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings", array(
            "user_id" => $user_id
        ), 1, 0);
        if ($chklatlng->num_rows() > 0) {
            $plat = $chklatlng->row()->latitude;
            $plng = $chklatlng->row()->longitude;
        }
    }
    if ($chkshft->row()->dlat != "") {
        $dlat = $chkshft->row()->dlat;
        $dlng = $chkshft->row()->dlng;
    } else {
        $chklatlng = $this->db->select("latitude,longitude")->get_where("tb_site_settings", array(
            "user_id" => $user_id
        ), 1, 0);
        if ($chklatlng->num_rows() > 0) {
            $dlat = $chklatlng->row()->latitude;
            $dlng = $chklatlng->row()->longitude;
        }
    }
}

$status_code = isset($post['status_code']) ? $post['status_code'] : "";
$status_date = isset($post['status_date']) ? $post['status_date'] : "";
if ($status_date == "") {
    $status_date = date('Y-m-d H:i:s');
}
$genstatustime = getdatetimebytimezone(DFLT_TZ, $status_date, $curtz);
$status_date = $genstatustime['datetime'];

$pshipid = isset($post['pshipid']) ? $post['pshipid'] : "0";
$dshipid = isset($post['dshipid']) ? $post['dshipid'] : "0";
$pstopdetailsid = isset($post['pstopdetailsid']) ? $post['pstopdetailsid'] : "0";
$dstopdetailsid = isset($post['dstopdetailsid']) ? $post['dstopdetailsid'] : "0";

$sname = isset($post['status_name']) ? $post['status_name'] : "";
$status_name = "";
if ($sname != "") {
    $sts = explode('_', $sname);
    $stop_type = 'P';
    if (!empty($sts)) {
        $stop_type = isset($sts[1]) ? $sts[1] : "P";
        $status_name = isset($sts[2]) ? $sts[2] : "";
    }
}

$status_id = 0;
if ($status_code == "0420") {
    $status_id = "2";
}
if ($status_code == "0500") {
    $status_id = "1";
}
if ($status_code == "0191") {
    $status_id = "3";
}
if ($status_code == "1550") {
    $status_id = "4";
}
if ($status_code == "0192") {
    $status_id = "2";
}
if ($status_code == "2300") {
    $status_id = "1";
}
if ($status_code == "3000") {
    $status_id = "3";
}
if ($status_id == 0) {
    $getstatusid = $this->db->select("id")->get_where("tb_status_master", array(
        'status_code' => $status_code
    ));
    if ($getstatusid->num_rows() > 0) {
        $status_id = $getstatusid->row()->id;
    }
}

        if (in_array($status_code, ['1013', '1012', '1014'])) {
            if ($id == "") {
                $insertedId = $this->common->insertTableData("tb_order_status", ['order_id' => $order_id, 'status_id' => $status_id, 'latitude' => $plat, 'longitude' => $plng, 'status_code' => $status_code, 'status' => '1', 'status_date' => $status_date, 'createdon' => $status_date]);
                if ($insertedId) {
                    echo "1";
                }
            } else {
                $updatedId = $this->common->updatetbledata("tb_order_status", ['status_date' => $status_date, 'createdon' => $status_date], ['id' => $id]);
                if($updatedId){
                    echo "1";
                }
            }
        } elseif (in_array($status_code, ['1500', '1600'])) {
            if ($id == "") {
                $insertedId = $this->common->insertTableData("tb_stop_status",['order_id' => $order_id, 'status_id' => $status_id,'status_code' => $status_code,'stop_type'=>'', 'status' => '1','reason'=>'From Admin','createdon' => $status_date]);
                if ($insertedId) {
                    echo "1";
                }
            } else {
                $updatedId = $this->common->updatetbledata("tb_stop_status", ['createdon' => $status_date,'sentknlogin'=>'0'], ['id' => $id]);
                if($updatedId){
                    echo "1";
                }
            }
        } else {
    if ($id == "") {
        $vehicle_id = 0;
        $contact_num = "";
        $driver_id = 0;
        $stop_id = $stopdetailid = 0;
        if ($stop_type == 'P') {
            $stop_id = $pshipid;
            $stopdetailid = $pstopdetailsid;
        } else {
            $stop_id = $dshipid;
            $stopdetailid = $dstopdetailsid;
        }
    /*
     * $gentime = getdatetimebytimezone(DFLT_TZ,$status_date,$curtz);
     * $stsdate = $gentime['datetime'];
     */
    $stsdate = $status_date;
    $getvehicleid = $this->db->select("vehicle_id")->get_where("tb_shft_veh", array(
        'shft_id' => $shift_id
    ));
    if ($getvehicleid->num_rows() > 0) {
        $vehicle_id = $getvehicleid->row()->vehicle_id;
    }
    $checktrip = $this->db->query("SELECT id,vehicle_id,driver_id,start_imei FROM tb_trips WHERE shift_id=$shift_id AND status=1");
    if ($checktrip->num_rows() > 0) {
        $contact_num = $checktrip->row()->start_imei;
        $trip_id = $checktrip->row()->id;
        $vehicle_id = $checktrip->row()->vehicle_id;
        $driver_id = $checktrip->row()->driver_id;
    }
    if ($trip_id == 0 && $vehicle_id != "") {
        $checktrip1 = $this->db->query("SELECT d.vehicle_id,d.driver_id,d.imei FROM tbl_assigned_drivers d WHERE d.vehicle_id=$vehicle_id AND d.status=1 LIMIT 1");
        if ($checktrip1->num_rows() > 0) {
            $vehicle_id = $checktrip1->row()->vehicle_id;
            $driver_id = $checktrip1->row()->driver_id;
            $contact_num = $checktrip1->row()->imei;
        }
    }
    if ($status_id == '10' && $trip_id == '0') {
        $chqry = $this->db->select("id")->get_where("tb_trips", array(
            'shift_id' => $shift_id,
            'vehicle_id' => $vehicle_id,
            'driver_id' => $driver_id
        ), 1, 0);
        if ($chqry->num_rows() == 0) {
            if ($contact_num == "") {
                $newimei = $this->db->select("imei")->get_where("tbl_assigned_drivers", array(
                    'vehicle_id' => $vehicle_id,
                    'driver_id' => $driver_id,
                    'status' => 1
                ), 1, 0);
                if ($newimei->num_rows() > 0) {
                    $contact_num = $newimei->row()->imei;
                }
            }
            $lattitude = $plat;
            $longitude = $plng;
            $triparr = array(
                'shift_id' => $shift_id,
                'vehicle_id' => $vehicle_id,
                'driver_id' => $driver_id,
                'stime' => $stsdate,
                'start_imei' => $contact_num,
                'splace' => "",
                'eplace' => "",
                'start_reading' => 0,
                'end_reading' => 0,
                'created_on' => $stsdate,
                'updated_on' => $curdt,
                'status' => 1,
                'trip_type' => 0,
                'transit_status' => 0
            );
            $trip_id = $this->common->insertTableData('tb_trips', $triparr);
            $insarry = array(
                'order_id' => $order_id,
                "shipment_id" => $shift_id,
                "stop_id" => 0,
                "stop_detail_id" => 0,
                "stop_type" => "",
                "trip_id" => $trip_id,
                "status_id" => $status_id,
                "latitude" => $lattitude,
                "longitude" => $longitude,
                "status" => 1,
                "reason" => "From Admin",
                "vehicle_id" => $vehicle_id,
                "driver_id" => $driver_id,
                "status_code" => $status_code,
                "createdon" => $stsdate
            );
            $ins = $this->db->insert("tb_stop_status", $insarry);
            /* update orders table */
            $ordwhr = array(
                "shift_id" => $shift_id
            );
            $ordset = array(
                "trip_id" => $trip_id
            );
            $upd = $this->db->set($ordset)
            ->where($ordwhr)
            ->update("tb_orders");

            $postdata = array(
                "shipment_id" => $shift_id,
                "trip_id" => $trip_id,
                "driver_id" => $driver_id,
                "vehicle_id" => $vehicle_id,
                "order_id" => $booking_id,
                "user_id" => $user_id,
                "stop_id" => '',
                "latitude" => $lattitude,
                "longitude" => $longitude,
                "curtz" => $curtz,
                "hrs" => $hrs,
                "web" => '',
                "status_code" => $status_code,
                "ord_id" => $order_id
            );
            if ($createdsource == "18") {
                $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
            } else if ($createdsource == '9') {
                $postdata['status_code'] = '0212';
                $sts = $this->svkonektquote->getstatusresponse($postdata);
            } else if ($createdsource == '13') {
                $this->load->library("amazonstatusintegration");
                $sts = $this->amazonstatusintegration->outboundTrailerASN($postdata);
            }
        }
        echo '1';
    } else {
        if ($trip_id != "0" && $status_id != "11") {
            $chqry = $this->db->select("id")->get_where("tb_stop_status", array(
                "shipment_id" => $shift_id,
                "stop_id" => $stop_id,
                "stop_detail_id" => $stopdetailid,
                "stop_type" => $stop_type,
                "trip_id" => $trip_id,
                "status_id" => $status_id
            ), 1, 0);
            if ($chqry->num_rows() == 0) {
                if ($status_id == "2" && $stop_type == "P") {
                    $ttdata = array(
                        "id" => $trip_id
                    );
                    $data2["updated_on"] = $curdt;
                    $data2["transit_status"] = '1';
                    $res = $this->db->set($data2)
                    ->where($ttdata)
                    ->update("tb_trips");
                }
                if ($stop_type == "P" || $status_id == "4") {
                    $lattitude = $plat;
                    $longitude = $plng;
                }
                if ($stop_type == "D") {
                    $lattitude = $dlat;
                    $longitude = $dlng;
                }
                $insarry = array(
                    "shipment_id" => $shift_id,
                    'order_id' => $order_id,
                    "stop_id" => $stop_id,
                    "stop_detail_id" => $stopdetailid,
                    "stop_type" => $stop_type,
                    "trip_id" => $trip_id,
                    "status_id" => $status_id,
                    "latitude" => $lattitude,
                    "longitude" => $longitude,
                    "status" => 1,
                    "reason" => "From Admin",
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "status_code" => $status_code,
                    "createdon" => $stsdate
                );
                $ins = $this->db->insert("tb_stop_status", $insarry);
                /* } */
                $chqry1 = $this->db->select("id")->get_where("tb_trip_employee", array(
                    "employee_id" => $stopdetailid,
                    "stop_id" => $stop_id,
                    "trip_id" => $trip_id,
                    "status" => 1
                ), 1, 0);
                if ($chqry1->num_rows() == 0) {
                    $insarr = array(
                        "employee_id" => $stopdetailid,
                        "stop_id" => $stop_id,
                        "trip_id" => $trip_id,
                        "status" => 1,
                        'driver_late' => 0,
                        'emp_late' => 0,
                        'stime' => $curdt,
                        'check_in' => $curdt,
                        'absent_reason' => 'Closed',
                        'created_on' => $curdt,
                        'updated_on' => $curdt,
                        'pd_status' => 1
                    );
                    $ins = $this->db->insert("tb_trip_employee", $insarr);
                }

                $postdata = array(
                    "shipment_id" => $shift_id,
                    "trip_id" => $trip_id,
                    "driver_id" => $driver_id,
                    "stop_id" => $stop_id,
                    "order_id" => $booking_id,
                    "inc_id" => 0,
                    "pod_type" => '',
                    "latitude" => $lattitude,
                    "longitude" => $longitude,
                    "stop_type" => $stop_type,
                    "vehicle_id" => $vehicle_id,
                    "curtz" => $curtz,
                    "hrs" => $hrs,
                    "web" => '',
                    "status_code" => $status_code,
                    "ord_id" => $order_id,
                    "user_id" => $user_id
                );
                if ($createdsource == "18") {
                    if ($status_id == "4") {
                        /* $sts = $this->statusintigration->shipmentintransit($postdata); */
                        /* send to roadlog */
                        $sts = $this->statusintigration->roadlogshipmentintransit($postdata);
                    }
                    if ($status_id == "2" && $stop_type == "P") {
                        /* $sts = $this->statusintigration->shipmentorderpicked($postdata); */
                        $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);
                    }
                    if ($status_id == "1" && $stop_type == "P") {
                        /* $sts = $this->statusintigration->shipmentorderpicked($postdata); */
                        $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                    }
                    if ($status_id == "3" && $stop_type == "P") {
                        /* send to roadlog */
                        $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);
                    }
                    if ($status_id == "2" && $stop_type == "D") {
                        /* $sts = $this->statusintigration->shipmentorderpicked($postdata); */
                        $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);
                    }
                    if ($status_id == "1" && $stop_type == "D") {
                        /* $sts = $this->statusintigration->shipmentdelivered($postdata); */
                        /* send to roadlog */
                        $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                    }
                } else if ($createdsource == "13") {
                    $this->load->library("amazonstatusintegration");
                    if ($status_id == "2" && $stop_type == "P") {
                        /* $sts = $this->statusintigration->shipmentorderpicked($postdata); */
                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                    }
                    if ($status_id == "1" && $stop_type == "P") {
                        /* $sts = $this->statusintigration->shipmentorderpicked($postdata); */
                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                    }
                    if ($status_id == "3" && $stop_type == "P") {
                        /* send to roadlog */
                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                    }
                    if ($status_id == "2" && $stop_type == "D") {
                        /* $sts = $this->statusintigration->shipmentorderpicked($postdata); */
                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                    }
                    if ($status_id == "1" && $stop_type == "D") {
                        /* $sts = $this->statusintigration->shipmentdelivered($postdata); */
                        /* send to roadlog */
                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                    }
                    if ($status_id == "3" && $stop_type == "D") {
                        /* send to roadlog */
                        $sts = $this->amazonstatusintegration->updateOrderStatus($postdata);
                    }
                } else if ($createdsource == '9') {
                    if ($status_id == '4' || ($status_id == "1" && $stop_type == "P") || ($status_id == "3" && $stop_type == "D")) {
                        $postdata['status_code'] = "";
                        if ($status_id == '4') {
                            $postdata['status_code'] = '1550';
                        }
                        if ($status_id == '1' && $stop_type == 'P') {
                            $postdata['status_code'] = '0500';
                        }
                        if ($status_id == '3' && $stop_type == 'D') {
                            $postdata['status_code'] = '3000';
                        }
                        $sts = $this->svkonektquote->getstatusresponse($postdata);
                    }
                } else if ($createdsource == '5') {
                    $postdata['status_code'] = $postdata['ord_id'] = "";
                    if ($status_id == '1' && $stop_type == 'P') {
                        $postdata['status_code'] = '0500';
                    }
                    if ($status_id == '3' && $stop_type == 'D') {
                        $postdata['status_code'] = '3000';
                    }
                    if ($status_id == '1' && $stop_type == 'D') {
                        $postdata['status_code'] = '2300';
                    }
                    if (($postdata['status_code'] == "0500") || ($postdata['status_code'] == "2300") || ($postdata['status_code'] == "3000")) {
                        $postdata['ord_id'] = $ord_id;
                        $sts = $this->statusintigration->salogshipmentstatus($postdata);
                    }
                }
            }
        }
        echo "1";
    }

        try {
            $statusPayload = [
                "trip" => $trip_id,
                "ship" => $shift_id,
                "ord_id" => $order_id,
                "orderid" => $booking_id,
                "stop_id" => 0,
                "stop_detail_id" => 0,
                "vehicle_id" => $vehicle_id,
                "driver_id" => $driver_id,
                "stop_type" => "P",
                "timezone" => $this->session->userdata("timezone"),
                "sts_date" => $stsdate,
                "status_code" => $status_code
            ];
            $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
        }

        $companyCode = $this->session->userdata('company_code');
        $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
        if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, $postdata['status_code'])) {
            $this->load->library('notifytrigger');
            $this->notifytrigger->sendNotificationToConsignee($order_id, $postdata['status_code']);
        }
} else {
    $this->db->where(array(
        'id' => $id
    ))->update("tb_stop_status", array(
        'createdon' => $status_date
    ));
    echo "1";
}
}
}
}

public function vieworder($id = NULL) {
    if (!checkUrlAccessForUser('SMTCORDERS')) {
        redirect("Forbiddenaccess");
    }
    $getCompanyCode = $this->common->gettblrowdata(['id' => $id, 'status !=' => 0], 'company_code', 'tb_orders', 0, 0);
    if (!in_array($getCompanyCode['company_code'], ['SGKN', 'MYKN'])) {
        redirect('smtcorders');
    }
    $company_code = $this->session->userdata('company_code');
    $data = array();
    $order_details = $shipper_details = $drop_details = $pickup_details = $consignee_data = $shipper_data = array();
    $drop_row_id = $chkpickup = $chkdelivery = $chkshipper = $chkconsignee = $gen_shipper_id = $gen_consignee_id = 0;
    if ($id != "") {
        $chkorder = $this->smtcorder->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $transport = $chkorder->row()->transport_mode;
            $transport_mode = "";
            if ($transport != "") {

                $getmode = $this->db->select("name")->get_where("tb_transportmode", array(
                    'code' => $transport
                ));
                if ($getmode->num_rows() > 0) {
                    $transport_mode = $getmode->row()->name;
                }
            }
            $docs_received_datetime = $chkorder->row()->docs_received_datetime;
            $docs_sent_datetime = $chkorder->row()->docs_sent_datetime;
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = $purchase_order = "";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='" . $id . "' AND reference_id IN ('DQ','PO','ORD_DLVINST','ORD_PIKINST','CTR')");
            if ($getdnote->num_rows() > 0) {
                foreach ($getdnote->result() as $ref) {
                    $ref_id = $ref->reference_id;
                    if ($ref_id == 'DQ') {
                        $shipment_id = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_DLVINST') {
                        $delivery_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'ORD_PIKINST') {
                        $pickup_inst = $ref->ref_value;
                    }
                    if ($ref_id == 'CTR') {
                        $container_no = $ref->ref_value;
                    }
                    if ($ref_id == 'PO') {
                        $purchase_order = $ref->ref_value;
                    }
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            if ($trip_id != 0 && $trip_sts == 0) {
                $order_status = 'ACTIVE';
            }
            if ($trip_id != 0 && $trip_sts == 1) {
                $order_status = 'CLOSED';
            }
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;

            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if ($order_str > $chk_str) {
                if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                    $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if ($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00") {
                    $edelivery = getdatetimebytimezone($curtz, $early_delivery, DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if ($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00") {
                    $lpickup = getdatetimebytimezone($curtz, $late_pickup, DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if ($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00") {
                    $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }
            }
            if ($docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00") {
                $docsent = getdatetimebytimezone($curtz, $docs_sent_datetime, DFLT_TZ);
                $docs_sent_datetime = $docsent['datetime'];
            }
            if ($docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00") {
                $docrec = getdatetimebytimezone($curtz, $docs_received_datetime, DFLT_TZ);
                $docs_received_datetime = $docrec['datetime'];
            }
            $order_details = array(
                'id' => $chkorder->row()->id,
                'order_id' => $chkorder->row()->order_id,
                'shipment_id' => $shipment_id,
                'order_status' => $order_status,
                'early_pickup' => $early_pickup,
                'early_delivery' => $early_delivery,
                'late_pickup' => $late_pickup,
                'late_delivery' => $late_delivery,
                'product' => $chkorder->row()->product,
                'incoterm' => $chkorder->row()->incoterm,
                'delivery_note' => $chkorder->row()->delivery_note,
                'purchase_order' => $purchase_order,
                'notify_party' => $chkorder->row()->notify_party,
                'goods_value' => $chkorder->row()->goods_value,
                'currency' => $chkorder->row()->currency,
                'lane_reference' => $chkorder->row()->lane_reference,
                'distance' => $chkorder->row()->distance,
                'customs_required' => $chkorder->row()->customs_required,
                'high_cargo_value' => $chkorder->row()->high_cargo_value,
                'valorance_insurance' => $chkorder->row()->valorance_insurance,
                'temperature_control' => $chkorder->row()->temperature_control,
                'company_code' => $chkorder->row()->company_code,
                'branch_code' => $chkorder->row()->branch_code,
                'department_code' => $chkorder->row()->department_code,
                'createdon' => $chkorder->row()->createdon,
                'transport_mode' => $transport_mode,
                'pickup_inst' => $pickup_inst,
                'delivery_inst' => $delivery_inst,
                'container_no' => $container_no,
                'docs_received_datetime' => $docs_received_datetime,
                'docs_sent_datetime' => $docs_sent_datetime,
                'pickup_custid' => $chkorder->row()->pickup_custid,
                'drop_custid' => $chkorder->row()->drop_custid,
            );
            $delivery_term = "";
            $pickup_id = $chkorder->row()->customer_id;
            $ord_type = $chkorder->row()->order_type;
            $order_details['order_type'] = "";

            $getordertype = $this->db->select("type_name")->get_where("tb_order_types", array(
                'id' => $ord_type,
                'status' => '1',
                'company_code' => $chkorder->row()->company_code
            ));
            if ($getordertype->num_rows() > 0) {
                $order_details['order_type'] = $getordertype->row()->type_name;
            }
            $delivery_term_id = $chkorder->row()->delivery_term;
            if ($delivery_term_id != "") {

                $getdelivery_term = $this->db->select("term_id,name")->get_where("tb_delivery_terms", array(
                    'term_id' => $delivery_term_id
                ));
                if ($getdelivery_term->num_rows() > 0) {
                    $delivery_term = $getdelivery_term->row()->term_id . "-" . $getdelivery_term->row()->name;
                }
            }
            $service = "";
            $service_id = $chkorder->row()->service;
            if ($service_id != "") {

                $getservice = $this->db->select("service_id,name")->get_where("tb_service_master", array(
                    'id' => $service_id
                ));
                if ($getservice->num_rows() > 0) {
                    $service = $getservice->row()->service_id . "-" . $getservice->row()->name;
                }
            }
            $order_details['service'] = $service;
            $order_details['delivery_term'] = $delivery_term;

            $getpickupdetails = $this->db->select("id,name,address,pincode,code,country")->get_where("tb_customers", array(
                'status' => 1,
                'id' => $pickup_id
            ));
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array(
                    'id' => $getpickupdetails->row()->id,
                    'name' => $getpickupdetails->row()->name,
                    'party_id' => $getpickupdetails->row()->code,
                    'address' => $getpickupdetails->row()->address,
                    'pincode' => $getpickupdetails->row()->pincode,
                    'country' => $getpickupdetails->row()->country
                );
            }
            $o_shipper_id = $chkorder->row()->o_shipper_id;
            if($o_shipper_id >0){
                $gen_shipper_id = $o_shipper_id;
            }
            $o_consignee_id = $chkorder->row()->consignee_id;
            if($o_consignee_id >0){
                $gen_consignee_id = $o_consignee_id;
            }
            $drop_id = $chkorder->row()->drop_custid;

            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
                        "id" => $ptype
                    ), 1, 0);
                    if ($chktype->num_rows() > 0) {
                        if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                            $chkconsignee = 1;
                            $gen_consignee_id = $rr->id;
                            if($chkdelivery == 0){
                                $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                            $chkshipper = 1;
                            $gen_shipper_id = $rr->id;
                            if($chkpickup == 0){
                                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                            $chkdelivery = 1;
                            $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($gen_consignee_id >0){
                            }else{
                                $gen_consignee_id = $rr->id;
                            }
                        }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                            $chkpickup = 1;
                            $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($gen_shipper_id > 0){
                            }else{
                                $gen_shipper_id = $rr->id;
                            }
                        }
                    }
                }
            }
            $shipper_details['name'] = $chkorder->row()->pickup;
            $shipper_details['street'] = $chkorder->row()->pickup_address1;
            $shipper_details['state'] = $chkorder->row()->pickup_address2;
            $shipper_details['city'] = $chkorder->row()->pickup_city;
            $shipper_details['country'] = $chkorder->row()->pickup_country;
            $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

            $drop_details['name'] = $chkorder->row()->delivery;
            $drop_details['street'] = $chkorder->row()->delivery_address1;
            $drop_details['state'] = $chkorder->row()->delivery_address2;
            $drop_details['city'] = $chkorder->row()->delivery_city;
            $drop_details['country'] = $chkorder->row()->delivery_country;
            $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
            $drop_id = $chkorder->row()->drop_custid;
        }
    }

    if($gen_shipper_id >0){
        $getshipperdetails = $this->smtcorder->getpartydetailsbyid($gen_shipper_id);
        if ($getshipperdetails->num_rows() > 0) {
            $shipper_data = array('id' => $getshipperdetails->row()->id,'name' => $getshipperdetails->row()->name, 'party_id' => $getshipperdetails->row()->code,'address' => $getshipperdetails->row()->address,'pincode' => $getshipperdetails->row()->pincode,'country' => $getshipperdetails->row()->country);
        }
    }
    if($gen_consignee_id >0){
        $getconsigneedetails = $this->smtcorder->getpartydetailsbyid($gen_consignee_id);
        if ($getconsigneedetails->num_rows() > 0) {
            $consignee_data = array('id' => $getconsigneedetails->row()->id,'name' => $getconsigneedetails->row()->name,'party_id' => $getconsigneedetails->row()->code,'address' => $getconsigneedetails->row()->address,'pincode' => $getconsigneedetails->row()->pincode,'country' => $getconsigneedetails->row()->country);
        }
    }
    $sub_cut_parties = array();
    if($chkpickup == 0 && $chkdelivery == 0){
        $sub_cut_parties['0'] = 0;
        $sub_cut_parties['1'] = 0;
        $sub_cut_parties['2'] = $gen_shipper_id;
        $sub_cut_parties['3'] = $gen_consignee_id;
    }

    if (!empty($sub_cut_parties)) {
        subcustpartiesinsert($chkorder->row()->id, $chkorder->row()->order_id, $sub_cut_parties);
    }
    $data['vatcategory'] = array();
    $getvatcategory = $this->common->gettbldata(array(
        'company_code' => $company_code,
        'status' => '1'
    ), "id,description,vat_category,vat_percentage", "tb_vat_category", 0, 0);
    if (!empty($getvatcategory)) {
        foreach ($getvatcategory as $res) {
            $val = $res['id'] . "_" . $res['vat_category'];
            $desc = $res['description'] . " (" . $res['vat_category'] . "-" . $res['vat_percentage'] . ")";
            $data['vatcategory'][] = array(
                'id' => $res['id'],
                'val' => $val,
                'desc' => $desc
            );
        }
    }
    $data['order_details'] = $order_details;
    $data['pickup_details'] = $pickup_details;
    $data['drop_details'] = $drop_details;
    $data['shipper_details'] = $shipper_details;
    $data['shipper_data'] = $shipper_data;
    $data['consignee_data'] = $consignee_data;

    $this->newtemplate->dashboard('smtcorders/vieworder', $data);
}

public function getshipperID() {
    $parties = array();
    $partytype_id = $this->input->post('partytype_id', true);
    $user_id = $this->session->userdata('user_id');
    $company_code = $this->session->userdata('company_code');
    $permission = checkuserpermissions();
    $whr = " AND user_id ='" . $user_id . "' ";
    if (in_array("businesspartners", $permission)) {
        $whr = "AND company_code LIKE '" . $company_code . "' ";
    } else {
        $whr = " AND user_id ='" . $user_id . "' ";
    }

$where = "status = 1 AND code != '' AND company_code != '' AND company_code IS NOT NULL AND code is NOT NULL AND code != '0' " . $whr . " AND code LIKE '%" . $partytype_id . "%'";
$this->db->select("id,name,phone,code,email_id,company_code,branch_code");
$this->db->from("tb_customers");
$this->db->where($where);
$this->db->group_by('id');
$this->db->order_by('createdon', 'DESC');
$chkqry = $this->db->get();

if ($chkqry->num_rows() > 0) {
    foreach ($chkqry->result() as $res) {
        $parties[] = array(
            'id' => $res->id,
            'party_id' => $res->code,
            'name' => $res->name,
            'phone' => $res->phone,
            'email' => $res->email_id,
            'company_code' => $res->company_code,
            'branch_code' => $res->branch_code
        );
    }
}
if ($company_code != "") {
    $getorder_types = $this->db->select("id,type_name")->get_where("tb_order_types", array(
        'company_code' => $company_code,
        'status' => '1'
    ));
    if ($getorder_types->num_rows() > 0) {
        foreach ($getorder_types->result() as $res) {
            $parties['ordparties'][] = array(
                'type_id' => $res->id,
                'type_name' => $res->type_name
            );
        }
    }
}
echo json_encode($parties);
}

public function getvendordetailsbyID() {
    $list = array();
    $code = $this->input->post('id', true);
    if ($code != "") {
        $getvendordetails = $this->db->query("SELECT name,code FROM tb_vendors WHERE code LIKE '" . $code . "' AND status ='1'");

        if ($getvendordetails->num_rows() > 0) {
            $list = array(
                'name' => $getvendordetails->row()->name,
                'code' => $getvendordetails->row()->code
            );
        }
    }
    echo json_encode($list);
}

public function getshipperdetailsbyID() {
    $parties = array();
    $code = $this->input->post('id', true);
    $customer_id = "";
    $user_id = $this->session->userdata('user_id');
    $company_code = $this->session->userdata('company_code');
    $permission = checkuserpermissions();
    if (in_array("businesspartners", $permission)) {
        $chkqry = $this->db->select("id,name,phone,location,address,street,location,state,pincode,code,country,email_id,fax,company_code,branch_code")->get_where("tb_customers", array(
            'code' => $code,
            'status' => '1'
        ));
    } else {
        $chkqry = $this->db->select("id,name,phone,location,address,street,location,state,pincode,code,country,email_id,fax,company_code,branch_code")->get_where("tb_customers", array(
            'code' => $code,
            'user_id' => $user_id,
            'status' => '1'
        ));
    }
    if ($chkqry->num_rows() > 0) {
        $customer_id = $chkqry->row()->id;
        $parties['customer_details'][] = array(
            'id' => $chkqry->row()->id,
            'name' => $chkqry->row()->name,
            'phone' => $chkqry->row()->phone,
            'street' => $chkqry->row()->street,
            'city' => $chkqry->row()->location,
            'pincode' => $chkqry->row()->pincode,
            'code' => $chkqry->row()->code,
            'country' => $chkqry->row()->country,
            'email_id' => $chkqry->row()->email_id,
            'fax' => $chkqry->row()->fax,
            'state' => $chkqry->row()->state,
            'location' => $chkqry->row()->location,
            'address' => $chkqry->row()->address,
            'company_code' => $chkqry->row()->company_code,
            'branch_code' => $chkqry->row()->branch_code
        );
    }

    $parties['ordparties'] = array();
    if ($customer_id != "") {
        $getorder_types = $this->db->select("id,type_name")
        ->group_by('type_name')
        ->get_where("tb_order_types", array(
            'customer_id' => $customer_id,
            'status' => '1',
            'company_code' => $company_code
        ));
        if ($getorder_types->num_rows() > 0) {
            foreach ($getorder_types->result() as $res) {
                $parties['ordparties'][] = array(
                    'type_id' => $res->id,
                    'type_name' => $res->type_name
                );
            }
        } else {
            $getorders = $this->db->select("id,type_name")
            ->group_by("type_name")
            ->get_where("tb_order_types", array(
                'company_code' => $company_code,
                "status" => 1
            ));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $parties['ordparties'][] = array(
                        'type_id' => $res->id,
                        'type_name' => $res->type_name
                    );
                }
            } else {
                $getorders = $this->db->select("id,type_name")
                ->group_by("type_name")
                ->get_where("tb_order_types", array(
                    'company_code' => "SGKN",
                    "status" => 1
                ));
                if ($getorders->num_rows() > 0) {
                    foreach ($getorders->result() as $res) {
                        $parties['ordparties'][] = array(
                            'type_id' => $res->id,
                            'type_name' => $res->type_name
                        );
                    }
                }
            }
        }
    }

    echo json_encode($parties);
}

public function saveshipper() {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $master_id = "";
    $user_id = $this->session->userdata('user_id');
    $shipper_row_id = isset($post['shipper_row_id']) ? $post['shipper_row_id'] : "";
    $customer_code = isset($post['scustomer_code']) ? $post['scustomer_code'] : "";
    $order_id = isset($post['shipper_orderrow_id']) ? $post['shipper_orderrow_id'] : "0";
    $company_code = isset($post['shipper_company_code']) ? $post['shipper_company_code'] : "";
    $branch_code = isset($post['shipper_branch_code']) ? $post['shipper_branch_code'] : "";
    $cdate = date('Y-m-d H:i:s');
    $status = '1';
    $address = $post['shipper_street'] . ',' . $post['shipper_city'] . ',' . $post['shipper_state'];
    if ($company_code == "") {
        $company_code = $this->session->userdata('company_code');
    }
    if ($branch_code == "") {
        $branch_code = $this->session->userdata('branch_code');
    }
    $master_id = 0;
    $chktype = $this->db->select("id")
    ->order_by('created_on', 'DESC')
    ->get_where("tbl_party_types", array(
        'name' => 'PICKUP',
        'user_id' => $user_id
    ));
    if ($chktype->num_rows() > 0) {
        $party_id = $chktype->row()->id;
    } else {
        $party = array(
            'name' => 'PICKUP',
            'description' => 'PICKUP',
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'created_on' => $cdate,
            'user_id' => $user_id
        );
        $ins = $this->db->insert("tbl_party_types", $party);
        $party_id = $this->db->insert_id();
    }
    $code = $post['shipper_id'];
    if ($code == "") {
        $code = 0;
    }
    $consignee_party_id  = $shipper_party_id = $delivery_party_id = 0;
    $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", array('name' => 'DELIVERY','company_code' => $company_code));
    if ($chktype->num_rows() > 0) {
        $delivery_party_id = $chktype->row()->id;
    }
    $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", array('name' => 'CONSIGNEE','company_code' => $company_code));
    if ($chktype->num_rows() > 0) {
        $consignee_party_id = $chktype->row()->id;
    }
    $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", array('name' => 'SHIPPER','company_code' => $company_code));
    if ($chktype->num_rows() > 0) {
        $shipper_party_id = $chktype->row()->id;
    }
    $party_types = $consignee_party_id.",".$shipper_party_id.",".$delivery_party_id;
    $master = array(
        'party_type_id' => $party_id,
        'name' => $post['shipper_name'],
        'email' => $post['shipper_email'],
        'street' => $post['shipper_street'],
        'state' => $post['shipper_state'],
        'mobile' => $post['shipper_phone'],
        'pincode' => $post['shipper_zipcode'],
        'country' => $post['shipper_country'],
        'code' => $code,
        'customeridentifier' => $code,
        'status' => '1',
        'fax' => $post['shipper_fax'],
        'address' => $address,
        'location_id' => $post['shipper_city'],
    );
    if ($code != '0') {
        $shipper_id = $code;
        $chkmaster = $this->db->select('id,customer_code,party_types')->get_where("tbl_party_master", array(
            'code' => $post['shipper_id']));
        if ($chkmaster->num_rows() > 0) {
            $master_id = $chkmaster->row()->id;
            $db_party_types = $chkmaster->row()->party_types;
            if($db_party_types != ""){
                $party_types = $db_party_types.$party_types;
            }
            $shipper_customer_code = $chkmaster->row()->customer_code;
            if ($order_id > 0) {
                if ($shipper_customer_code == "" || $shipper_customer_code == '0') {
                    $upd = $this->db->where(array(
                        'id' => $master_id
                    ))->update("tbl_party_master", array(
                        'mobile' => $post['shipper_phone'],
                        'email' => $post['shipper_email'],
                        'fax' => $post['shipper_fax'],
                        'customer_code' => $customer_code,
                        'party_types'=>$party_types,
                    ));
                } else {
                    $upd = $this->db->where(array(
                        'id' => $master_id
                    ))->update("tbl_party_master", array(
                        'mobile' => $post['shipper_phone'],
                        'email' => $post['shipper_email'],
                        'fax' => $post['shipper_fax'],
                        'party_types'=>$party_types,
                    ));
                }

                $status = '1';
            } else {
                if ($shipper_customer_code == "" || $shipper_customer_code == '0') {
                    $master['customer_code'] = $customer_code;
                    }
                }
                $upd = $this->db->where(array(
                    'id' => $master_id
                ))->update("tbl_party_master", $master);
                $status = '1';
        } else {

            $master['party_types'] = $party_types;
            $master['created_on'] = $cdate;
            $master['customer_code'] = $customer_code;
			$master['user_id'] = $user_id;
			$master['company_code'] = $company_code;
			$master['branch_code'] = $branch_code;
            $ins = $this->db->insert("tbl_party_master", $master);
            $master_id = $this->db->insert_id();
            $status = '0';
        }
    } else {
        $master['party_types'] = $party_types;
        $master['created_on'] = $cdate;
        $master['customer_code'] = $customer_code;
		$master['user_id'] = $user_id;
		$master['company_code'] = $company_code;
		$master['branch_code'] = $branch_code;
        $ins = $this->db->insert("tbl_party_master", $master);
        $master_id = $this->db->insert_id();
        $country_code = $this->session->userdata("usr_tzone")['phone_code'];
        $year = date('y');
        $week = date('W');
        $shipper_id = $country_code . $year . $week . $master_id;
        $upd = $this->db->where(array(
            'id' => $master_id
        ))->update("tbl_party_master", array(
            'code' => $shipper_id,
            'customeridentifier' => $shipper_id
        ));
        $status = '0';
    }
    if ($order_id > 0) {
        if ($master_id != '0') {
            $chk_address = $this->db->select("id")->get_where("tbl_orderparty_address", array(
                'order_id' => $order_id,
                'party_master_id' => $master_id,
                'status' => '1'
            ));
            if ($chk_address->num_rows() > 0) {
                $address_id = $chk_address->row()->id;
                $upd_ar = array(
                    'order_id' => $order_id,
                    'party_master_id' => $master_id,
                    'location_id' => $post['shipper_city'],
                    'street' => $post['shipper_street'],
                    'state' => $post['shipper_state'],
                    'address' => $address,
                    'pincode' => $post['shipper_zipcode'],
                    'country' => $post['shipper_country'],
                    'user_id' => $user_id
                );
                $updaddress = $this->db->where(array(
                    'id' => $address_id
                ))->update("tbl_orderparty_address", $upd_ar);
            } else {
                $insadd_ar = array(
                    'order_id' => $order_id,
                    'party_master_id' => $master_id,
                    'location_id' => $post['shipper_city'],
                    'street' => $post['shipper_street'],
                    'state' => $post['shipper_state'],
                    'address' => $address,
                    'pincode' => $post['shipper_zipcode'],
                    'country' => $post['shipper_country'],
                    'user_id' => $user_id,
                    'status' => '1',
                    'createdon' => $cdate
                );
                $updaddress = $this->db->insert("tbl_orderparty_address", $insadd_ar);
            }
            $order_whr = array('id'=>$order_id);
            $order_upd = array();

            if($post['shipper_name'] != ""){
                $order_upd['pickup_company'] = $post['shipper_name'];
            }
            if($post['shipper_country'] != ""){
                $order_upd['pickup_country'] = $post['shipper_country'];
            }
            if($post['shipper_city'] != ""){
                $order_upd['pickup_city'] = $post['shipper_city'];
            }
            if($post['shipper_zipcode'] != ""){
                $order_upd['pickup_pincode'] = $post['shipper_zipcode'];
            }
            if($post['shipper_state'] != ""){
                $order_upd['pickup_address2'] = $post['shipper_state'];
            }
            if($post['shipper_street'] != ""){
                $order_upd['pickup_address1'] = $post['shipper_street'];
            }
            if(!empty($order_upd)){
                $upd_ordertbl = $this->common->updatetbledata("tb_orders",$order_upd,$order_whr);
            }
        }
        $status = '1';
    }
    $arr = array(
        'master_id' => $master_id,
        'status' => $status,
        'shipper_id' => $shipper_id
    );
    echo json_encode($arr);
}

public function getconsigneeID() {
    $user_id = 1;
    $parties = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $code = $this->input->post('partytype_id', true);
    $user_id = $this->session->userdata('user_id');
    $custid = "0";
    $party_type = isset($post['type']) ? $post['type'] : "";
    $whr = "";
    $chkcompanycode = $this->session->userdata('company_code');
    $company_code = $this->session->userdata('company_code');
    $permission = checkuserpermissions();
    if ($chkcompanycode != 'NZKN') {
        if ($this->session->userdata('cust_id') !== FALSE) {
            $custid = $this->session->userdata('cust_id');
        }
        $subcusts = array();
        if ($custid != 0) {
            if ($this->session->userdata('sub_cust') !== FALSE) {
                $subcusts = $this->session->userdata('sub_cust');
                if(!empty($subcusts)){
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = $custid;
            // array_push($subcusts, $custid);
                    }
                }
            } else {
                $subcusts = $custid;
    // array_push($subcusts, $custid);
            }
        }
        $customer_code = array();
        if (!empty($subcusts)) {
            $select = "code";
            $table = "tb_customers";
            $customerdetails = $this->smtcorder->getcustomercodebyids($select, $table, $subcusts);
            if (!empty($customerdetails)) {
                foreach ($customerdetails as $cust) {
                    $customer_code[] = $cust['code'];
                }
            }
        }
        if (!empty($customer_code)) {
            $whr = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
        }
    }
    $party_type_whr = "";
    if ($party_type != "") {
        $party_type_whr = " AND p.name LIKE '" . $party_type . "' ";
    }
    $master_ids = array();
    if (in_array("businesspartners", $permission)) {
        $where = "m.code LIKE '%" . $code . "%' AND m.company_code LIKE '" . $company_code . "' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.branch_code IS NOT NULL  AND m.status='1' " . $party_type_whr . " " . $whr;
    } else {
        $where = "m.code LIKE '%" . $code . "%' AND m.user_id='" . $user_id . "' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.branch_code IS NOT NULL  AND m.status='1' " . $party_type_whr . " " . $whr;
    }
/*
* if ( $company_code == 'RUKN' ) {
* $where = "m.code LIKE '%" . $code . "%' AND m.company_code LIKE '" . $company_code . "' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.branch_code IS NOT NULL AND m.status='1' " . $party_type_whr . " " . $whr;
* } else {
* $where = "m.code LIKE '%" . $code . "%' AND m.user_id='" . $user_id . "' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.branch_code IS NOT NULL AND m.status='1' " . $party_type_whr . " " . $whr;
* }
*/

$this->db->select("m.id,m.code");
$this->db->from("tbl_party_master m");
$this->db->join("tbl_party_types p", "p.id=m.party_type_id", "LEFT");
$this->db->where($where);
$this->db->group_by('m.id');
$this->db->order_by('m.id', 'DESC');
$chkqry = $this->db->get();
if ($chkqry->num_rows() > 0) {
    foreach ($chkqry->result() as $res) {
        $master_ids[] = $res->id;
        $parties[] = array(
            'id' => $res->id,
            'party_id' => $res->code
        );
    }
}
$additional_ids = array();
if (!empty($master_ids)) {
    $mwhr = "m.id NOT IN (" . implode(',', $master_ids) . ") AND ";
} else {
    $mwhr = "";
}
if (in_array("businesspartners", $permission)) {
    /* if ( $company_code == "RUKN" ) { */
        $getmultipleparties = $this->db->query("SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE " . $mwhr . " m.code LIKE '%" . $code . "%'  AND m.company_code LIKE '" . $company_code . "' AND m.party_types IS NOT NULL");
    } else {
        $getmultipleparties = $this->db->query("SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE " . $mwhr . " m.code LIKE '%" . $code . "%'  AND m.user_id ='" . $user_id . "' AND m.party_types IS NOT NULL");
    }

    if ($getmultipleparties->num_rows() > 0) {
        foreach ($getmultipleparties->result() as $res) {
            $party_types = explode(',', $res->party_types);
			if(end($party_types)==""){
				array_pop($party_types);
			}
            if (!empty($party_types)) {
                $chkshipper = $this->db->query("SELECT id FROM tbl_party_types WHERE id IN (" . implode(',', $party_types) . ") AND name LIKE '" . $party_type . "'");
                if ($chkshipper->num_rows() > 0) {
                    $additional_ids[] = $res->master_id;
                }
            }
        }
    }
    if (!empty($additional_ids)) {
        if (in_array("businesspartners", $permission)) {
            $get_addids = $this->db->query("SELECT m.id as master_id,m.code FROM tbl_party_master m WHERE m.id IN (" . implode(',', $additional_ids) . ") AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL AND m.company_code LIKE '" . $company_code . "' AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' GROUP BY m.id ORDER BY m.id DESC");
        } else {
            $get_addids = $this->db->query("SELECT m.id as master_id,m.code FROM tbl_party_master m WHERE m.id IN (" . implode(',', $additional_ids) . ") AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL AND m.user_id='" . $user_id . "' AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' GROUP BY m.id ORDER BY m.id DESC");
        }

        if ($get_addids->num_rows() > 0) {
            foreach ($get_addids->result() as $res) {
                $master_ids[] = $res->master_id;
                $parties[] = array(
                    'id' => $res->master_id,
                    'party_id' => $res->code
                );
            }
        }
    }

    echo json_encode($parties);
}

public function getconsigneedetailsbyID() {
    $user_id = 1;
    $parties = array();
    $code = $this->input->post('id', true);
    $company_code = $this->session->userdata('company_code');
    $user_id = $this->session->userdata('user_id');
    $where = array();
    $where['user_id'] = $user_id;
    $permission = checkuserpermissions();
    if(in_array("businesspartners", $permission)){
        $where['company_code'] = $company_code;
    } else {
        $where['user_id'] = $user_id;
    }
    $this->db->select("id,name,email,street,location_id as city,state,mobile,pincode,country,code,fax");
    $this->db->from("tbl_party_master");
    $this->db->where(array(
        "code" => $code
    ));

    $this->db->order_by("id", "DESC");
    $chkqry = $this->db->get();
    if ($chkqry->num_rows() > 0) {
        $parties[] = array(
            'id' => $chkqry->row()->id,
            'name' => $chkqry->row()->name,
            'phone' => $chkqry->row()->mobile,
            'street' => $chkqry->row()->street,
            'city' => $chkqry->row()->city,
            'pincode' => $chkqry->row()->pincode,
            'code' => $chkqry->row()->code,
            'country' => $chkqry->row()->country,
            'email_id' => $chkqry->row()->email,
            'fax' => $chkqry->row()->fax,
            'state' => $chkqry->row()->state
        );
    }

    echo json_encode($parties);
}

public function saveconsignee() {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $master_id = "";

    $c_id = isset($post['consignee_row_id']) ? $post['consignee_row_id'] : "";
    $customer_code = isset($post['ccustomer_code']) ? $post['ccustomer_code'] : "0";
    $order_id = isset($post['consignee_orderrow_id']) ? $post['consignee_orderrow_id'] : "0";
    $company_code = isset($post['consignee_company_code']) ? $post['consignee_company_code'] : "";
    $branch_code = isset($post['consignee_branch_code']) ? $post['consignee_branch_code'] : "";
    $user_id = $this->session->userdata('user_id');
    $cdate = date('Y-m-d H:i:s');
    $status = '1';
    if ($company_code == "") {
        $company_code = $this->session->userdata('company_code');
    }
    if ($branch_code == "") {
        $branch_code = $this->session->userdata('branch_code');
    }
    $user_id = $this->session->userdata('user_id');
    $chktype = $this->db->query("SELECT id FROM tbl_party_types WHERE name='DELIVERY' AND company_code LIKE '" . $company_code . "' ORDER BY created_on DESC");
    if ($chktype->num_rows() > 0) {
        $party_id = $chktype->row()->id;
    } else {
        $party = array(
            'name' => 'DELIVERY',
            'description' => 'DELIVERY',
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'created_on' => $cdate,
            'user_id' => $user_id
        );
        $ins = $this->db->insert("tbl_party_types", $party);
        $party_id = $this->db->insert_id();
    }
    $shipper_party_id = $consignee_party_id = $pickup_party_id = 0;
    $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", array('name' => 'Shipper','user_id' => $user_id));
    if ($chktype->num_rows() > 0) {
        $shipper_party_id = $chktype->row()->id;
    }
    $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", array('name' => 'CONSIGNEE','user_id' => $user_id));
    if ($chktype->num_rows() > 0) {
        $consignee_party_id = $chktype->row()->id;
    }
    $chktype = $this->db->select("id")->order_by('created_on', 'DESC')->get_where("tbl_party_types", array('name' => 'PICKUP','user_id' => $user_id));
    if ($chktype->num_rows() > 0) {
        $pickup_party_id = $chktype->row()->id;
    }
    $party_types = $shipper_party_id.",".$pickup_party_id.",".$consignee_party_id;
    $code = $post['consignee_id'];
    if ($code == "") {
        $code = 0;
    }
    $address = $post['consignee_street'] . ',' . $post['consignee_city'] . ',' . $post['consignee_state'];
    $master = array(
        'party_type_id' => $party_id,
        'name' => $post['consignee_name'],
        'email' => $post['consignee_email'],
        'street' => $post['consignee_street'],
        'state' => $post['consignee_state'],
        'mobile' => $post['consignee_phone'],
        'pincode' => $post['consignee_zipcode'],
        'country' => $post['consignee_country'],
        'code' => $code,
        'customeridentifier' => $code,
        'status' => '1',
        'fax' => $post['consignee_fax'],
        'address' => $address,
        'location_id' => $post['consignee_city'],
        'party_types'=>$party_types
    );
    if ($code != 0) {
        $consignee_id = $code;
        $chkmaster = $this->db->select('id,customer_code')->get_where("tbl_party_master", array(
            'code' => $code
        ));
        if ($chkmaster->num_rows() > 0) {
            $master_id = $chkmaster->row()->id;
            $consginee_customer_code = $chkmaster->row()->customer_code;
            if ($order_id > 0) {
                if ($consginee_customer_code != "" && $consginee_customer_code != '0') {
                    $upd = $this->db->where(array(
                        'id' => $master_id
                    ))->update("tbl_party_master", array(
                        'mobile' => $post['consignee_phone'],
                        'email' => $post['consignee_email'],
                        'fax' => $post['consignee_fax'],
                        'customer_code' => $consginee_customer_code,
                        'party_types'=>$party_types
                    ));
                } else {
                    $upd = $this->db->where(array(
                        'id' => $master_id
                    ))->update("tbl_party_master", array(
                        'mobile' => $post['consignee_phone'],
                        'email' => $post['consignee_email'],
                        'fax' => $post['consignee_fax'],
                        'party_types'=>$party_types
                    ));
                }

                $status = '1';
            } else {
                if ($consginee_customer_code != "" && $consginee_customer_code != '0') {
                    $master['customer_code'] = $consginee_customer_code;
                    }
                }
            $upd = $this->db->where(array(
                    'id' => $master_id
                ))->update("tbl_party_master", $master);
                $status = '1';
        } else {
            if ($company_code != "") {
                $master['company_code'] = $company_code;
            }
            if ($branch_code != "") {
                $master['branch_code'] = $branch_code;
            }
            $custid = "0";
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }

            $master['party_types'] = $party_types;
            $master['created_on'] = $cdate;
            $master['customer_code'] = $customer_code;
            $ins = $this->db->insert("tbl_party_master", $master);
            $master_id = $this->db->insert_id();
            $status = '0';
        }
    } else {
        if ($company_code != "") {
            $master['company_code'] = $company_code;
        }
        if ($branch_code != "") {
            $master['branch_code'] = $branch_code;
        }
        $master['party_types'] = $party_types;
        $master['created_on'] = $cdate;
        $master['customer_code'] = $customer_code;
        $ins = $this->db->insert("tbl_party_master", $master);
        $master_id = $this->db->insert_id();
        $country_code = $this->session->userdata("usr_tzone")['phone_code'];
        $year = date('y');
        $week = date('W');
        $consignee_id = $country_code . $year . $week . $master_id;
        $upd = $this->db->where(array(
            'id' => $master_id
        ))->update("tbl_party_master", array(
            'code' => $consignee_id,
            'customeridentifier' => $consignee_id
        ));
        $status = '0';
    }

    if ($order_id > 0) {
        if ($master_id != '0') {
            $chk_address = $this->db->select("id")->get_where("tbl_orderparty_address", array(
                'order_id' => $order_id,
                'party_master_id' => $master_id,
                'status' => '1'
            ));
            if ($chk_address->num_rows() > 0) {
                $address_id = $chk_address->row()->id;
                $upd_ar = array(
                    'order_id' => $order_id,
                    'party_master_id' => $master_id,
                    'location_id' => $post['consignee_city'],
                    'street' => $post['consignee_street'],
                    'state' => $post['consignee_state'],
                    'address' => $address,
                    'pincode' => $post['consignee_zipcode'],
                    'country' => $post['consignee_country'],
                    'user_id' => $user_id
                );
                $updaddress = $this->db->where(array(
                    'id' => $address_id
                ))->update("tbl_orderparty_address", $upd_ar);
            } else {
                $insadd_ar = array(
                    'order_id' => $order_id,
                    'party_master_id' => $master_id,
                    'location_id' => $post['consignee_city'],
                    'street' => $post['consignee_street'],
                    'state' => $post['consignee_state'],
                    'address' => $address,
                    'pincode' => $post['consignee_zipcode'],
                    'country' => $post['consignee_country'],
                    'status' => '1',
                    'user_id' => $user_id,
                    'createdon' => $cdate
                );
                $updaddress = $this->db->insert("tbl_orderparty_address", $insadd_ar);
            }
            $order_whr = array('id'=>$order_id);
            $order_upd = array();
            if($post['consignee_name'] != ""){
                $order_upd['delivery_company'] = $post['consignee_name'];
            }
             if($post['consignee_country'] != ""){
                $order_upd['delivery_country'] = $post['consignee_country'];
            }
            if($post['consignee_city'] != ""){
                $order_upd['delivery_city'] = $post['consignee_city'];
            }
            if($post['consignee_zipcode'] != ""){
                $order_upd['delivery_pincode'] = $post['consignee_zipcode'];
            }
            if($post['consignee_state'] != ""){
                $order_upd['delivery_address2'] = $post['consignee_state'];
            }
            if($post['consignee_street'] != ""){
                $order_upd['delivery_address1'] = $post['consignee_street'];
            }
            if(!empty($order_upd)){
                $upd_ordertbl = $this->common->updatetbledata("tb_orders",$order_upd,$order_whr);
            }
        }
        $status = '1';
    }
    $arr = array(
        'master_id' => $master_id,
        'status' => $status,
        'consignee_id' => $consignee_id
    );
    echo json_encode($arr);
}

public function getinvolvedpartyId() {
    $user_id = $this->session->userdata('user_id');
    $parties = array();
    $code = $this->input->post('code', true);
    if ($user_id != "") {
        $custid = "0";
        $whr = "";
        $chkcompanycode = $this->session->userdata('company_code');
        if ($chkcompanycode != 'NZKN') {
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }
            $subcusts = array();
            if ($custid != 0) {
                if ($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = $custid;
            // array_push($subcusts, $custid);
                    }
                } else {
                    $subcusts = $custid;
        // array_push($subcusts, $custid);
                }
            }
            $customer_code = array();
            if (!empty($subcusts)) {
                $select = "code";
                $table = "tb_customers";
                $customerdetails = $this->smtcorder->getcustomercodebyids($select, $table, $subcusts);
                if (!empty($customerdetails)) {
                    foreach ($customerdetails as $cust) {
                        $customer_code[] = $cust['code'];
                    }
                }
            }
            if (!empty($customer_code)) {
                $whr = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
            }
        }
        $pwhr = "m.user_id ='" . $user_id . "' AND ";
        $permission = checkuserpermissions();
        if (in_array("businesspartners", $permission)) {
            $company_code = $this->session->userdata('company_code');
            $pwhr = "m.company_code LIKE '" . $company_code . "' AND ";
        } else {
            $pwhr = "m.user_id ='" . $user_id . "' AND ";
        }
        $chkqry = $this->db->query("SELECT m.id,m.code FROM tbl_party_master m,tbl_party_types t WHERE t.id=m.party_type_id AND " . $pwhr . " m.code LIKE '%" . $code . "%' AND m.code IS NOT NULL AND m.code != '' AND m.code !='0' AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL " . $whr . " GROUP BY m.id ORDER BY m.created_on DESC");
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = array(
                    'id' => $res->id,
                    'customeridentifier' => $res->code
                );
            }
        }
    }

    echo json_encode($parties);
}

public function getpartydetailsbyID() {
    $parties = array();
    $code = $this->input->post('id', true);
    $chkqry = $this->db->query("SELECT m.id,m.name,m.email,m.street,m.location_id as city,m.state,m.mobile,m.address,m.country,m.pincode,m.country,m.code,m.fax,t.id as partytype_id,t.name as role FROM tbl_party_master m,tbl_party_types t WHERE m.code LIKE '%" . $code . "%' AND t.id=m.party_type_id ORDER BY m.id DESC");
    if ($chkqry->num_rows() > 0) {
        $parties[] = array(
            'id' => $chkqry->row()->id,
            'name' => $chkqry->row()->name,
            'phone' => $chkqry->row()->mobile,
            'street' => $chkqry->row()->street,
            'city' => $chkqry->row()->city,
            'pincode' => $chkqry->row()->pincode,
            'code' => $chkqry->row()->code,
            'country' => $chkqry->row()->country,
            'email_id' => $chkqry->row()->email,
            'fax' => $chkqry->row()->fax,
            'state' => $chkqry->row()->state,
            'role' => $chkqry->row()->role,
            'partytype_id' => $chkqry->row()->partytype_id,
            'address' => $chkqry->row()->address,
            'country' => $chkqry->row()->country
        );
    }
    echo json_encode($parties);
}

public function addinvolvedpartyfororder($order_id = NULL) {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $cdate = date('Y-m-d H:i:s');
    $party_id = 0;
    $inner_id = $data = array();
    $user_id = $this->session->userdata('user_id');

    $company_code = isset($post['party_company_id']) ? $post['party_company_id'] : "";
    $branch_code = isset($post['party_branch_id']) ? $post['party_branch_id'] : "";
    if ($user_id != "") {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $address = $post['street'] . ',' . $post['city'] . ',' . $post['city'];
        $party = array(
            'customeridentifier' => $post['party_id'],
            'code' => $post['party_id'],
            'name' => $post['party_name'],
            'street' => $post['street'],
            'pincode' => $post['zipcode'],
            'country' => $post['country'],
            'state' => $post['state'],
            'mobile' => $post['mobile'],
            'fax' => $post['fax'],
            'email' => $post['email'],
            'created_on' => $cdate,
            'address' => $address,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'location_id' => $post['city']
        );
        $role_id = 0;
        if ($post['role'] != "") {
            $getroleid = $this->db->select("id")->get_where("tbl_party_types", array(
                'name' => $post['role'],
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => 1,
                'user_id' => $user_id
            ));
            if ($getroleid->num_rows() > 0) {
                $role_id = $getroleid->row()->id;
            } else {
                $getroleid_nobranch = $this->db->select("id")->get_where("tbl_party_types", array(
                    'name' => $post['role'],
                    'company_code' => $company_code,
                    'status' => 1,
                    'user_id' => $user_id
                ));
                if ($getroleid_nobranch->num_rows() > 0) {
                    $role_id = $getroleid_nobranch->row()->id;
                } else {
                    $ins_role = array(
                        'name' => $post['role'],
                        'description' => $post['role'],
                        'company_code' => $company_code,
                        'branch_code' => $branch_code,
                        'user_id' => $user_id,
                        'status' => '1',
                        'created_on' => $cdate
                    );
                    $insqry = $this->db->insert("tbl_party_types", $ins_role);
                    $role_id = $this->db->insert_id();
                }
            }
        }

        $party['party_type_id'] = $role_id;
        $party_type = "";
        $getpartytype = $this->db->select("name")->get_where("tbl_party_types", array(
            'id' => $party_id
        ));
        if ($getpartytype->num_rows() > 0) {
            $party_type = $getpartytype->row()->name;
        }
        $parties = array(
            'party_id' => $post['party_id'],
            'party_type' => $party_type,
            'name' => $post['party_name'],
            'street' => $post['street'],
            'zipcode' => $post['zipcode'],
            'city' => $post['city'],
            'country' => $post['country'],
            'state' => $post['state'],
            'mobile' => $post['mobile'],
            'fax' => $post['fax'],
            'emailid' => $post['email'],
            'action' => "<button id=" . $post['party_id'] . " class='btn btn-primary btn-xs editparties' onclick='editpartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $post['party_id'] . " class='btn btn-primary btn-xs deleteround' onclick='deletepartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>"
        );

        $chk = $this->db->select('id')->get_where('tbl_party_master', array(
            'code' => $post['party_id']
        ));
        if ($chk->num_rows() > 0) {
            $party_id = $chk->row()->id;
            $upd = $this->db->where(array(
                'id' => $party_id
            ))->update("tbl_party_master", $party);
        } else {
            $ins = $this->db->insert("tbl_party_master", $party);
            $party_id = $this->db->insert_id();
        }
        if ($order_id != NULL) {
            $chk = $this->db->select('id,status')->get_where('tb_order_parties', array(
                'party_id' => $party_id,
                'order_id' => $order_id
            ));
            if ($chk->num_rows() > 0) {
                $id = $chk->row()->id;
                $status = $chk->row()->status;
                if ($status == '1') {
                    echo "2";
                } else if ($status == '0') {

                    $upd = $this->db->where(array(
                        'id' => $id
                    ))->update('tb_order_parties', array(
                        'status' => '1'
                    ));
                    if ($upd) {
                        echo "1";
                    }
                }
                if ($role_id != "0") {
                    $upd = $this->db->where(array(
                        'id' => $id
                    ))->update("tb_order_parties", array(
                        'party_type' => $role_id
                    ));
                }
            } else {
                $getorder_number = $this->db->select("order_id")->get_where("tb_orders", array(
                    'id' => $order_id
                ));
                $order_number = $getorder_number->row()->order_id;
                $party_type = 1;
                if ($role_id != "0") {
                    $party_type = $role_id;
                } else {
                    $getpartytype = $this->db->query("SELECT party_type_id FROM tbl_party_master WHERE id='" . $party_id . "'");
                    if ($getpartytype->num_rows() > 0) {
                        $party_type = $getpartytype->row()->party_type_id;
                    }
                }
                $order_ins = array(
                    'party_id' => $party_id,
                    'order_id' => $order_id,
                    'createdon' => $cdate,
                    'status' => '1',
                    'party_type' => $party_type,
                    'order_number' => $order_number
                );
                $ins = $this->db->insert("tb_order_parties", $order_ins);
                if ($ins) {
                    echo "1";
                } else {
                    echo "0";
                }
            }
        }
    }
}

public function updateorder() {

    $post = array();
    $order_consignee_id = $order_shipper_id = $chkshipper = $chkconsignee = $chkpickup = $chkdelivery =  0;
    $post = $this->input->post(NULL, TRUE);
    $order_id = isset($post['order_id']) ? $post['order_id'] : '0';
    if ($order_id != "0") {
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $booking_id = isset($post['booking_id']) ? $post['booking_id'] : "";
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        $department_code = isset($post['department_code']) ? $post['department_code'] : "";
        $product = isset($post['product']) ? $post['product'] : "";
        $service = isset($post['service']) ? $post['service'] : "";
        $delivery_terms = isset($post['delivery_terms']) ? $post['delivery_terms'] : "";
        $modeof_trasnport = isset($post['modeof_trasnport']) ? $post['modeof_trasnport'] : "TL";
        $order_type = isset($post['order_type']) ? $post['order_type'] : "";
        $incoterm = isset($post['incoterm']) ? $post['incoterm'] : "";
        $shipment_id = isset($post['delivery_note']) ? $post['delivery_note'] : "";
        $container_no = isset($post['container_num']) ? $post['container_num'] : "";
        $porder = isset($post['purchase_order']) ? $post['purchase_order'] : "";
        $order_shipper_id = isset($post['order_shipper_id']) ? $post['order_shipper_id'] : "0";
        $order_consignee_id = isset($post['order_consignee_id']) ? $this->db->escape_str($post['order_consignee_id']) : "";
        $customer_id = isset($post['customer_id']) ? $post['customer_id'] : "";
        $pickup_custidd = isset($post['pickup_custid']) ? $post['pickup_custid'] : "0";
        $drop_custidd = isset($post['drop_custid']) ? $post['drop_custid'] : "0";
        $pickup = isset($post['order_pickup_id']) ? $post['order_pickup_id'] : "0";
        $delivery = isset($post['order_delivery_id']) ? $post['order_delivery_id'] : "0";
        $docs_sent_datetime = isset($post['docs_sent_datetime']) ? $post['docs_sent_datetime'] : "";
        $docs_received_datetime = isset($post['docs_received_datetime']) ? $post['docs_received_datetime'] : "";
        if ($customer_id != "") {
            $getcustomerid = $this->db->select("id")->get_where("tb_customers", array(
                'code' => $customer_id,
                'status' => '1'
            ));
            if ($getcustomerid->num_rows() > 0) {
                $customer_id = $getcustomerid->row()->id;
            }
        }
        $getbookingid = $this->common->gettblrowdata(array(
            'id' => $order_id
        ), "order_id", "tb_orders", 0, 0);
        if (!empty($getbookingid)) {
            $booking_id = $getbookingid['order_id'];
        }

        if($order_shipper_id > 0){
        }else{
            $order_shipper_id = $pickup;
        }
        if($order_consignee_id > 0){
        }else{
            $order_consignee_id = $delivery;
        }

        $notify_party = isset($post['notify_party']) ? $post['notify_party'] : "";
        $driver_pickup_instructions = isset($post['driver_pickup_instructions']) ? $post['driver_pickup_instructions'] : "";
        $driver_delivery_instructions = isset($post['driver_delivery_instructions']) ? $post['driver_delivery_instructions'] : "";

        if ($shipment_id != "") {
            $upddq = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'DQ' AND r.name=o.reference_id AND o.order_id='" . $order_id . "' AND o.ref_value LIKE '" . $shipment_id . "'");
            if ($upddq->num_rows() > 0) {
                /* $this->db->where( array( 'id' => $upddq->row()->id ) )->update( 'tb_order_references', array( 'ref_value' => $shipment_id ) ); */
            } else {
                $arr = array(
                    'order_id' => $order_id,
                    'reference_id' => 'DQ',
                    'ref_value' => $shipment_id,
                    'createdon' => $cdate
                );
                $this->db->insert('tb_order_references', $arr);
            }
        }
        if ($company_code == 'AUKN' || $company_code == 'UKKN') {
            if ($container_no != "") {
                $upddq = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'CTR' AND r.name=o.reference_id AND o.order_id=" . $order_id);
                if ($upddq->num_rows() > 0) {
                    $this->db->where(array(
                        'id' => $upddq->row()->id
                    ))
                    ->update('tb_order_references', array(
                        'ref_value' => $container_no
                    ));
                } else {
                    $arr = array(
                        'order_id' => $order_id,
                        'reference_id' => 'CTR',
                        'ref_value' => $container_no,
                        'createdon' => $cdate
                    );
                    $this->db->insert('tb_order_references', $arr);
                }
            }
        }
        if ($driver_pickup_instructions != "") {
            $updporder = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'ORD_PIKINST' AND r.name=o.reference_id AND o.order_id=" . $order_id);
            if ($updporder->num_rows() > 0) {
                $this->db->where(array(
                    'id' => $updporder->row()->id
                ))
                ->update('tb_order_references', array(
                    'ref_value' => $driver_pickup_instructions
                ));
            } else {
                $arr = array(
                    'order_id' => $order_id,
                    'reference_id' => 'ORD_PIKINST',
                    'ref_value' => $driver_pickup_instructions,
                    'createdon' => $cdate
                );
                $this->db->insert('tb_order_references', $arr);
            }
        }
        if ($driver_delivery_instructions != "") {
            $updporder = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'ORD_DLVINST' AND r.name=o.reference_id AND o.order_id=" . $order_id);
            if ($updporder->num_rows() > 0) {
                $this->db->where(array(
                    'id' => $updporder->row()->id
                ))
                ->update('tb_order_references', array(
                    'ref_value' => $driver_delivery_instructions
                ));
            } else {
                $arr = array(
                    'order_id' => $order_id,
                    'reference_id' => 'ORD_DLVINST',
                    'ref_value' => $driver_delivery_instructions,
                    'createdon' => $cdate
                );
                $this->db->insert('tb_order_references', $arr);
            }
        }
        if ($porder != "") {
            $updporder = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'PO' AND r.name=o.reference_id AND o.order_id='" . $order_id . "' AND o.ref_value LIKE '" . $porder . "' ");
            if ($updporder->num_rows() > 0) {
                /* $this->db->where( array( 'id' => $updporder->row()->id ) )->update( 'tb_order_references', array( 'ref_value' => $porder ) ); */
            } else {
                $arr = array(
                    'order_id' => $order_id,
                    'reference_id' => 'PO',
                    'ref_value' => $porder,
                    'createdon' => $cdate
                );
                $this->db->insert('tb_order_references', $arr);
            }
        }

        $goods_value = isset($post['goods_value']) ? $post['goods_value'] : "0.00";
        if ($goods_value == "") {
            $goods_value = 0.00;
        }

        $currency = isset($post['currency']) ? $post['currency'] : "0";
        $party_row_id = isset($post['order_party_row_id']) ? $post['order_party_row_id'] : "0";
        $reference_ids = isset($post['reference_ids']) ? $post['reference_ids'] : "0";
        $order_inv_row_id = isset($post['order_inv_row_id']) ? $post['order_inv_row_id'] : '0';
        $order_cargo_id = isset($post['order_cargo_id']) ? $post['order_cargo_id'] : "";
        $early_pickup = isset($post['early_pickup']) ? $post['early_pickup'] : "";
        $late_pickup = isset($post['late_pickup']) ? $post['late_pickup'] : "";
        $early_delivery = isset($post['early_delivery']) ? $post['early_delivery'] : "";
        $late_delivery = isset($post['late_delivery']) ? $post['late_delivery'] : "";
        $e_pickup = date('Y-m-d H:i:s');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if ($early_pickup != "") {
            $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
        }
        if ($late_pickup != "") {
            $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
        } else {
            $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
        }
        $e_delivery = date('Y-m-d H:i:s');
        if ($early_delivery != "") {
            $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
        }
        if ($late_delivery != "") {
            $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
        } else {
            $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
        }
        if ($docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00") {
            $getdocsent = getdatetimebytimezone(DFLT_TZ, $docs_sent_datetime, $curtz);
            $docs_sent_datetime = $getdocsent['datetime'];
        }
        if ($docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00") {
            $getdocrec = getdatetimebytimezone(DFLT_TZ, $docs_received_datetime, $curtz);
            $docs_received_datetime = $getdocrec['datetime'];
        }
        $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = "";
        $drop_id = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $drop_state = $pickup_state = $drop_state = $pickup_address = $drop_address = "";
        $pickup_custid = $drop_custid = $pickup_id = 0;

        $drop_row_id = $shipper_party_id = $consignee_party_id = 0;
        $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name,p.code,p.mobile,p.email,p.fax,o.id as order_party_id,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type");
        if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", array("id" => $ptype), 1, 0);
                    if ($chktype->num_rows() > 0) {
                    $party_name= strtoupper($chktype->row()->name);
                     if (strtoupper($chktype->row()->name) == "CONSIGNEE") {
                            $chkconsignee = 1;
                            if($order_consignee_id >0){
                            }else{
                                $order_consignee_id = $rr->id;
                            }
                            if($chkdelivery == 0){
                                $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        } else if (strtoupper($chktype->row()->name) == "SHIPPER") {
                            $chkshipper = 1;
                            if($order_shipper_id > 0){
                            }else{
                                $order_shipper_id = $rr->id;
                            }
                            if($chkpickup == 0){
                                $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            }
                        }else if (strtoupper($chktype->row()->name) == "DELIVERY") {
                            $chkdelivery = 1;
                            $drop_details = array( 'name' => $rr->name,'phone' => $rr->mobile,'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($order_consignee_id >0){
                            }else{
                                $order_consignee_id = $rr->id;
                            }
                        }else if (strtoupper($chktype->row()->name) == "PICKUP") {
                            $chkpickup = 1;
                            $shipper_details = array('name' => $rr->name, 'phone' => $rr->mobile, 'email' => $rr->email,'fax' => $rr->fax,'party_id' => $rr->code);
                            if($order_shipper_id > 0){
                            }else{
                                $order_shipper_id = $rr->id;
                            }
                        }


                    }
                }

        }
        $sub_cut_parties = array();
        $sub_cut_parties['0'] = $order_shipper_id;
        $sub_cut_parties['1'] = $order_consignee_id;
        $sub_cut_parties['2'] = $pickup;
        $sub_cut_parties['3'] = $delivery;
        if (!empty($sub_cut_parties)) {
            subcustpartiesinsert($order_id, $booking_id, $sub_cut_parties);
        }
        /* if ($pickup_id != $order_shipper_id) {*/
            if ($pickup != "0") {
                $getshippercustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $pickup . "'");
                if ($getshippercustid->num_rows() > 0) {
                    $pickup_custid = $getshippercustid->row()->code;
                    $pickup_name = $getshippercustid->row()->name;
                    $pickup_state = $getshippercustid->row()->state;
                    $pickup_address = $getshippercustid->row()->address;
                    $pickup_country = $getshippercustid->row()->country;
                    $pickup_street = $getshippercustid->row()->street;
                    $pickup_pincode = $getshippercustid->row()->pincode;
                    $pickup_city = $getshippercustid->row()->city;

                        $chkprevious_shipperaddress = $this->db->select('id')->get_where("tbl_orderparty_address", array(
                            'order_id' => $order_id,
                            'party_master_id' => $pickup_id,
                            'status' => '1'
                        ));
                        if ($chkprevious_shipperaddress->num_rows() > 0) {
                            $upd_oldsaddress = $this->db->where(array(
                                'id' => $chkprevious_shipperaddress->row()->id
                            ))
                            ->update("tbl_orderparty_address", array(
                                'status' => '0'
                            ));
                        }
                    $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
                        'order_id' => $order_id,
                        'party_master_id' => $order_shipper_id,
                        'status' => '1'
                    ));
                    $shipper_address = array(
                        'order_id' => $order_id,
                        'party_master_id' => $order_shipper_id,
                        'location_id' => $pickup_city,
                        'street' => $pickup_street,
                        'state' => $pickup_state,
                        'address' => $pickup_address,
                        'pincode' => $pickup_pincode,
                        'country' => $pickup_country,
                        'user_id' => $user_id,
                        'status' => '1'
                    );
                    if ($chkpartyaddress->num_rows() > 0) {
                        $pickup_addressid = $chkpartyaddress->row()->id;
                        $upd = $this->db->where(array(
                            'id' => $pickup_addressid
                        ))->update("tbl_orderparty_address", $shipper_address);
                    } else {
                        $shipper_address['createdon'] = $cdate;
                        $this->db->insert("tbl_orderparty_address", $shipper_address);
                    }
                }
            }
        /* } else if ($order_shipper_id == $pickup_id) {*/
            /*if ($pickup != 0) {
                $chk_shipperaddress = $this->db->select("name,code,location_id,street,state,address,pincode,country")->get_where("tbl_party_master", array(

                    'id' => $pickup
                ));
                if ($chk_shipperaddress->num_rows() > 0) {
                    $pickup_city = $chk_shipperaddress->row()->location_id;
                    $pickup_country = $chk_shipperaddress->row()->country;
                    $pickup_street = $chk_shipperaddress->row()->street;
                    $pickup_pincode = $chk_shipperaddress->row()->pincode;
                    $pickup_state = $chk_shipperaddress->row()->state;
                    $pickup_address = $chk_shipperaddress->row()->address;
                }
            }*/
        /* }*/
        /* if ($drop_row_id != $delivery) {*/
            if ($delivery != "0") {
                $getdropcustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $delivery . "'");
                if ($getdropcustid->num_rows() > 0) {
                    $drop_id = $delivery;
                    $drop_custid = $getdropcustid->row()->code;
                    $drop_name = $getdropcustid->row()->name;
                    $drop_state = $getdropcustid->row()->state;
                    $drop_address = $getdropcustid->row()->address;
                    $drop_country = $getdropcustid->row()->country;
                    $drop_street = $getdropcustid->row()->street;
                    $drop_pincode = $getdropcustid->row()->pincode;
                    $drop_city = $getdropcustid->row()->city;
                    if ($drop_row_id != 0) {
                        $chkprevious_dropaddress = $this->db->select('id')->get_where("tbl_orderparty_address", array(
                            'order_id' => $order_id,
                            'party_master_id' => $drop_row_id,
                            'status' => '1'
                        ));
                        if ($chkprevious_dropaddress->num_rows() > 0) {
                            $upd_olddaddress = $this->db->where(array(
                                'id' => $chkprevious_dropaddress->row()->id
                            ))
                            ->update("tbl_orderparty_address", array(
                                'status' => '0'
                            ));
                        }
                    }

                    $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
                        'order_id' => $order_id,
                        'party_master_id' => $delivery,
                        'status' => '1'
                    ));
                    $drop_address = array(
                        'order_id' => $order_id,
                        'party_master_id' => $delivery,
                        'location_id' => $drop_city,
                        'street' => $drop_street,
                        'state' => $drop_state,
                        'address' => $drop_address,
                        'pincode' => $drop_pincode,
                        'country' => $drop_country,
                        'user_id' => $user_id,
                        'status' => '1'
                    );
                    if ($chkpartyaddress->num_rows() > 0) {
                        $drop_addressid = $chkpartyaddress->row()->id;
                        $upd = $this->db->where(array(
                            'id' => $drop_addressid
                        ))->update("tbl_orderparty_address", $drop_address);
                    } else {
                        $drop_address['createdon'] = $cdate;
                        $this->db->insert("tbl_orderparty_address", $drop_address);
                    }
                }
            }
        /* } else if ($drop_row_id == $delivery) {*/
           /* if ($delivery != 0) {
                $chkdrop = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array(
                    'order_id' => $order_id,
                    'party_master_id' => $delivery,
                    'status' => '1'
                ));
                if ($chkdrop->num_rows() > 0) {
                    $drop_city = $chkdrop->row()->location_id;
                    $drop_state = $chkdrop->row()->state;
                    $drop_country = $chkdrop->row()->country;
                    $drop_street = $chkdrop->row()->street;
                    $drop_pincode = $chkdrop->row()->pincode;
                    $drop_address = $chkdrop->row()->address;
                }
            }*/
        /* }*/

        $inv_customer = makeorderinvolvedpartiestype($customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
        $ship_row_id = 0;
        $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid = $tname = "";
        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
        if ($gettrasnportmode->num_rows() > 0) {
            $tid = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        $ship_arr = array(
            'unitspec' => 1,
            'shipid' => $shipment_id,
            'txnid' => $shipment_id,
            'trucktype' => $tname,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $pickup_custid,
            'carrier' => '0',
            'insertuserdate' => $cdate,
            'enddate' => $enddate,
            'insdate' => $cdate,
            'upddate' => $cdate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $cdate,
            'transport_mode' => $modeof_trasnport,
            'domainname' => $branch_code,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'product' => $product,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm' => $incoterm,
            'modeoftransport' => $tid
        );
        $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");
        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array(
                'id' => $ship_row_id
            ))->update("tb_shipments", $ship_arr);
        } else {

            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id = $this->db->insert_id();
        }

        $getpickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $curtz);
        $e_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $curtz);
        $l_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $curtz);
        $e_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $curtz);
        $l_delivery = $getldelivery['datetime'];
        $ins = [
            'shipment_id' => $ship_row_id,
            'product' => $product,
            'pickup_datetime' => $e_pickup,
            'delivery_datetime' => $e_delivery,
            'pickup_endtime' => $l_pickup,
            'drop_endtime' => $l_delivery,
            'goods_value' => $goods_value,
            'currency' => $currency,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'transport_mode' => $modeof_trasnport,
            'shipper_id' => $order_shipper_id,
            'consignee_id' => $order_consignee_id,
            'updatedon' => date('Y-m-d H:i:s')
        ];
        if ($pickup_name != "") {
            $ins['pickup_company'] = $pickup_name;
        }
        if ($pickup_country != "") {
            $ins['pickup_country'] = $pickup_country;
        }
        if ($drop_name != "") {
            $ins['delivery_company'] = $drop_name;
        }
        if ($drop_country != "") {
            $ins['delivery_country'] = $drop_country;
        }
        if ($pickup_street != "") {
            $ins['pickup_address1'] = $pickup_street;
        }
        if ($pickup_city != "") {
            $ins['pickup_city'] = $pickup_city;
        }
        if ($drop_custid != "") {
            $ins['drop_custid'] = $drop_custidd;
        }
        if ($drop_custid != "") {
            $ins['drop_partyid'] = $drop_custidd;
        }
        if ($pickup_custid != "") {
            $ins['pickup_custid'] = $pickup_custidd;
        }
        if ($pickup_custid != "") {
            $ins['pickup_partyid'] = $pickup_custidd;
        }
        if ($pickup_pincode != "") {
            $loc = [];
            $add1 = implode(",", [
                $pickup_street,
                $pickup_city,
                $pickup_country,
                $pickup_pincode
            ]);
            $loc = getlatlngsbyplace($add1);
            $ins['plat'] = @$loc[0];
            $ins['plng'] = @$loc[1];
            $ins['pickup_pincode'] = $pickup_pincode;
        }
        if ($pickup_state != "") {
            $ins['pickup_address2'] = $pickup_state;
        }
        if ($drop_street != "") {
            $ins['delivery_address1'] = $drop_street;
        }
        if ($drop_state != "") {
            $ins['delivery_address2'] = $drop_state;
        }
        if ($drop_city != "") {
            $ins['delivery_city'] = $drop_city;
        }
        if ($customer_id > 0) {
            $ins['customer_id'] = $customer_id;
        }
        if ($drop_pincode != "") {
            $loc = [];
            $add2 = implode(",", [
                $drop_street,
                $drop_city,
                $drop_country,
                $drop_pincode
            ]);
            $loc = getlatlngsbyplace($add2);
            $ins['dlat'] = @$loc[0];
            $ins['dlng'] = @$loc[1];
            $ins['delivery_pincode'] = $drop_pincode;
            $ins['delivery_pincode'] = $drop_pincode;
        }
        $this->db->where(array(
            'id' => $order_id
        ))->update('tb_orders', $ins);
        $details_ins = array(
            'service' => $service,
            'delivery_term' => $delivery_terms,
            'incoterm' => $incoterm,
            /*  'purchase_order'         => $porder, */
            'notify_party' => $notify_party,
            'lane_reference' => "LR",
            'distance' => '0',
            'department_code' => $department_code,
            'temperature_control' => '0',
            'valorance_insurance' => '0',
            'high_cargo_value' => '0',
            'customs_required' => '0',
            'order_type' => $order_type,
            'docs_received_datetime' => $docs_received_datetime,
            'docs_sent_datetime' => $docs_sent_datetime
        );
        $chk = $this->db->select("id")->get_where("tb_order_details", array(
            'order_row_id' => $order_id
        ));
        if ($chk->num_rows() > 0) {
            $upd_details = $this->db->where(array(
                'order_row_id' => $order_id
            ))->update("tb_order_details", $details_ins);
        } else {
            $details_ins['createdon'] = $cdate;
            $details_ins['order_row_id'] = $order_id;
            $details_ins['order_id'] = $booking_id;
            $ins = $this->db->insert("tb_order_details", $details_ins);
        }


		$chkshipment = $this->db->select( "shift_id" )->get_where( "tb_orders", array( 'id' => $order_id ) );
		if ( $chkshipment->num_rows() > 0 ) {
			$shiftid = $chkshipment->row()->shift_id;
			$chkshipmentemp = $this->db->select( "id,stop_id,drop_stopid" )->get_where( "tb_employee", array( 'shift_id' => $shiftid,'order_id' => $booking_id ) );
			$empid_ins = $pickupstops = $deliverystops = array();
			if ( $chkshipmentemp->num_rows() > 0 ) {
				$empid = $chkshipmentemp->row()->id;
				$empid_ins['pickup_datetime']    = $e_pickup;
				$empid_ins['drop_datetime'] = $l_delivery;
				$empid_ins['startdate']     = $e_pickup;
				$empid_ins['enddate']     = $l_delivery;
				$upd_details = $this->db->where( array( 'id' => $empid ) )->update( "tb_employee", $empid_ins);


				$pickupstops['startdate']= $e_pickup;
				$pickupstops['enddate']= $l_pickup;
				$empstop_id = $chkshipmentemp->row()->stop_id;
				$upd_pickup_details = $this->db->where( array( 'id' => $empstop_id ) )->update( "tb_shiporder_stops", $pickupstops);


				$deliverystops['startdate']= $e_delivery;
				$deliverystops['enddate']= $l_delivery;
				$empdrop_stopid = $chkshipmentemp->row()->drop_stopid;
				$upd_drop_details = $this->db->where( array( 'id' => $empdrop_stopid ) )->update( "tb_shiporder_stops", $deliverystops);

			}

		}


        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "' AND status ='1'");
        if ($gettotal->num_rows() > 0) {
            $total_volume = $gettotal->row()->total_volume;
            $total_weight = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $upd_order = $this->db->where(array(
            'id' => $order_id
        ))->update("tb_orders", array(
            'volume' => $total_volume,
            'weight' => $total_weight,
            'quantity' => $total_quantity
        ));
        $this->ordernotify('booking_edit', $order_id);
    }
    if ($order_id != "" && $order_id != '0') {
        $this->session->set_flashdata('success_msg', 'Order Updated Successfully - ' . $booking_id);
        redirect('smtcorders/orderslist/' . $order_id);
    } else {
        redirect('orders');
    }

}

public function insertinvolvedparties($id = NULL) {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $cdate = date('Y-m-d H:i:s');
    $party_id = 0;
    $inner_id = $data = array();
    $user_id = $this->session->userdata('user_id');

    $order_id = isset($post['party_order_id']) ? $post['party_order_id'] : "0";
    if ($user_id != "") {
        $custid = "0";
        if ($this->session->userdata('cust_id') !== FALSE) {
            $custid = $this->session->userdata('cust_id');
        }
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');

        $address = $post['street'] . ',' . $post['city'] . $post['state'];
        $party = array(
            'customeridentifier' => $post['party_id'],
            'code' => $post['party_id'],
            'name' => $post['party_name'],
            'street' => $post['street'],
            'pincode' => $post['zipcode'],
            'country' => $post['country'],
            'state' => $post['state'],
            'mobile' => $post['mobile'],
            'fax' => $post['fax'],
            'email' => $post['email'],
            'created_on' => $cdate,
            'address' => $address,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'user_id' => $user_id,
            'location_id' => $post['city']
        );
        $party_type = "";
        $getpartyname = $this->db->select("name")->get_where("tbl_party_types", array(
            'id' => $post['party_id']
        ));
        if ($getpartyname->num_rows() > 0) {
            $party_type = $getpartyname->row()->name;
        }

        $parties = array(
            'party_id' => $post['party_id'],
            'party_type' => $post['role'],
            'name' => $post['party_name'],
            'street' => $post['street'],
            'zipcode' => $post['zipcode'],
            'city' => $post['city'],
            'country' => $post['country'],
            'state' => $post['state'],
            'mobile' => $post['mobile'],
            'fax' => $post['fax'],
            'emailid' => $post['email'],
            'action' => "<button id=" . $post['party_id'] . " class='btn btn-primary btn-xs editparties' onclick='editpartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $post['party_id'] . " class='btn btn-primary btn-xs deleteround' onclick='deletepartydetails(" . $post['party_id'] . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>"
        );
        $role_id = 0;
        if ($post['role'] != '') {
            $getroleid = $this->db->select("id")->get_where("tbl_party_types", array(
                'name' => $post['role'],
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => 1,
                'user_id' => $user_id
            ));
            if ($getroleid->num_rows() > 0) {
                $role_id = $getroleid->row()->id;
            } else {
                $getroleid_nobranch = $this->db->select("id")->get_where("tbl_party_types", array(
                    'name' => $post['role'],
                    'company_code' => $company_code,
                    'status' => 1,
                    'user_id' => $user_id
                ));
                if ($getroleid_nobranch->num_rows() > 0) {
                    $role_id = $getroleid_nobranch->row()->id;
                } else {
                    $ins_role = array(
                        'name' => $post['role'],
                        'description' => $post['role'],
                        'company_code' => $company_code,
                        'branch_code' => $branch_code,
                        'user_id' => $user_id,
                        'status' => '1',
                        'created_on' => $cdate
                    );
                    $insqry = $this->db->insert("tbl_party_types", $ins_ar);
                    $role_id = $this->db->insert_id();
                }
            }
        }
        if ($id == NULL) {
            if ($custid != "0") {
                $getcustomer_code = $this->db->select("code")->get_where("tb_customers", array(
                    'id' => $custid
                ));
                if ($getcustomer_code->num_rows() > 0) {
                    $party['customer_code'] = $getcustomer_code->row()->code;
                }
            }
            $chk = $this->db->select('id')->get_where('tbl_party_master', array(
                'code' => $post['party_id']
            ));
            if ($chk->num_rows() > 0) {
                $party_id = $chk->row()->id;
                $upd = $this->db->where(array(
                    'id' => $party_id
                ))->update("tbl_party_master", $party);
            } else {

                $party['party_type_id'] = $role_id;
                $ins = $this->db->insert("tbl_party_master", $party);
                $party_id = $this->db->insert_id();
            }

            $data = array(
                'party_id' => $party_id
            );
        } else {
            $party_id = $id;
            $upd = $this->db->where(array(
                'id' => $party_id
            ))->update("tbl_party_master", $party);
            if ($order_id != "0") {
                $chkorderparty = $this->db->select("id")->get_where("tb_order_parties", array(
                    'order_id' => $order_id,
                    'party_id' => $party_id
                ));
                if ($chkorderparty->num_rows() > 0) {
                    $rowid = $chkorderparty->row()->id;
                    if ($role_id != "0") {
                        $upd = $this->db->where(array(
                            'id' => $rowid
                        ))->update("tb_order_parties", array(
                            'party_type' => $role_id
                        ));
                    }
                }
            }
            $data = array(
                'party_id' => $party_id
            );
        }
        echo json_encode($data);
    }
}

public function getorderinvolvedparties() {
    $user_id = $this->session->userdata('user_id');
    $parties = array();
    $order_id = isset($_REQUEST['order_id']) ? $_REQUEST['order_id'] : "";
    $cust_id = $this->session->userdata("cust_id");
    if ($order_id != "") {
        $getparties = $this->db->query("SELECT m.id as party_master_id,m.name as username,m.email as emailid,m.mobile as mobile,m.location_id as city,m.state,m.street as street,m.pincode as zipcode,m.country,m.partyindetifier,m.code,m.fax,p.name,p.id as party_type_id,p.name as party_name,p.company_code,p.branch_code,t.id as party_id FROM tbl_party_master m,tbl_party_types p,tb_order_parties t WHERE t.order_id='" . $order_id . "' AND t.status =1 AND m.id=t.party_id AND t.party_type=p.id GROUP BY t.party_type ORDER BY m.id DESC");
        if ($getparties->num_rows() > 0) {
            foreach ($getparties->result() as $res) {
                $id = '"' . $res->party_master_id . '"';
                $code = '"' . $res->code . '"';
                $name = '"' . $res->username . '"';
                $street = '"' . $res->street . '"';
                $emailid = '"' . $res->emailid . '"';
                $state = '"' . $res->state . '"';
                $country = '"' . $res->country . '"';
                $fax = '"' . $res->fax . '"';
                $city = '"' . $res->city . '"';
                $role = '"' . $res->party_name . '"';
                $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowPartyEdit(this," . $id . "," . $code . "," . $name . "," . $street . "," . $emailid . "," . $res->mobile . "," . $state . "," . $country . "," . $res->zipcode . "," . $fax . "," . $city . "," . $role . "," . $order_id . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletepartydetailswithorder(" . $id . ");'><span class='glyphicon glyphicon-trash'> </span>Remove<li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddParty(this);'><span class='glyphicon glyphicon-plus' > </span>Add Parties</a></li></ul></li></ul>";
                if ($cust_id == "") {
                    $parties[] = array(
                        'id' => $res->party_master_id,
                        'party_id' => $res->code,
                        'street' => $res->street,
                        'party_type' => $res->party_name,
                        'name' => $res->name,
                        'username' => $res->username,
                        'email' => $res->emailid,
                        'mobile' => $res->mobile,
                        'zipcode' => $res->zipcode,
                        'street' => $res->street,
                        'customeridentifier' => $res->code,
                        'partyindetifier' => $res->partyindetifier,
                        'fax' => $res->fax,
                        'code' => $res->code,
                        'name' => $res->name,
                        'city' => $res->city,
                        'state' => $res->state,
                        'country' => $res->country,
                        'company_code' => $res->company_code,
                        'branch_code' => $res->branch_code,
                        'action' => $action
                    );
                } else {
                    if (strtoupper($res->party_name) != 'CARRIER') {
                        $parties[] = array(
                            'id' => $res->party_master_id,
                            'party_id' => $res->code,
                            'street' => $res->street,
                            'party_type' => $res->party_name,
                            'name' => $res->name,
                            'username' => $res->username,
                            'email' => $res->emailid,
                            'mobile' => $res->mobile,
                            'zipcode' => $res->zipcode,
                            'street' => $res->street,
                            'customeridentifier' => $res->code,
                            'partyindetifier' => $res->partyindetifier,
                            'fax' => $res->fax,
                            'code' => $res->code,
                            'name' => $res->name,
                            'city' => $res->city,
                            'state' => $res->state,
                            'country' => $res->country,
                            'company_code' => $res->company_code,
                            'branch_code' => $res->branch_code,
                            'action' => $action
                        );
                    }
                }
            }
        }
    }

    echo json_encode($parties);
}

public function showinvolvedparties() {
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $user_id = $this->session->userdata('user_id');
    $parties = $ids = array();
    $party_row_id = isset($post['party_row_id']) ? $post['party_row_id'] : "";
    if ($party_row_id != "") {
        $ids = implode(',', $party_row_id);
        if (!empty($ids)) {
            $getparties = $this->db->query("SELECT m.id as party_master_id,m.name as username,m.email as emailid,m.mobile as mobile,m.location_id as city,m.state,m.street as street,m.pincode as zipcode,m.country,m.partyindetifier,m.code,m.fax,m.code,p.id as party_type_id,p.name as party_type,p.company_code,p.branch_code FROM tbl_party_master m,tbl_party_types p WHERE m.id IN (" . $ids . ") AND m.party_type_id=p.id GROUP BY m.id ORDER BY m.id DESC");
            if ($getparties->num_rows() > 0) {
                foreach ($getparties->result() as $res) {
                    $id = '"' . $res->party_master_id . '"';
                    $code = '"' . $res->code . '"';
                    $name = '"' . $res->username . '"';
                    $street = '"' . $res->street . '"';
                    $emailid = '"' . $res->emailid . '"';
                    $state = '"' . $res->state . '"';
                    $country = '"' . $res->country . '"';
                    $fax = '"' . $res->fax . '"';
                    $city = '"' . $res->city . '"';
                    $role = '"' . $res->party_type . '"';
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowPartyEdit(this," . $id . "," . $code . "," . $name . "," . $street . "," . $emailid . "," . $res->mobile . "," . $state . "," . $country . "," . $res->zipcode . "," . $fax . "," . $city . "," . $role . ");'><span class='glyphicon glyphicon-pencil' > </span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowPartyElim(this," . $id . ");'><span class='glyphicon glyphicon-trash'> </span>Remove<li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddParty(this);'><span class='glyphicon glyphicon-plus' > </span>Add Parties</a></li></ul></li></ul>";

                    $parties[] = array(
                        'party_id' => $res->code,
                        'party_type' => $res->party_type,
                        'party_type_id' => $res->party_type_id,
                        'street' => $res->street,
                        'username' => $res->username,
                        'email' => $res->emailid,
                        'mobile' => $res->mobile,
                        'zipcode' => $res->zipcode,
                        'street' => $res->street,
                        'customeridentifier' => $res->code,
                        'partyindetifier' => $res->partyindetifier,
                        'fax' => $res->fax,
                        'code' => $res->code,
                        'city' => $res->city,
                        'state' => $res->state,
                        'country' => $res->country,
                        'company_code' => $res->company_code,
                        'branch_code' => $res->branch_code,
                        'action' => $action
                    );
                }
            }
        }
    }
    echo json_encode($parties);
}

public function editpartydetails() {
    $id = $this->input->post('id', true);
    $parties = array();
    $chk = $this->db->select('id')->get_where("tbl_party_master", array(
        'id' => $id
    ));
    if ($chk->num_rows() > 0) {
        $get_parties = $this->db->query("SELECT m.id,m.party_type_id,m.name,m.email,m.mobile,m.location_id,m.street,m.state,m.fax,m.address,m.pincode,m.country,m.user_id,m.customeridentifier,p.id as party_type_id FROM tbl_party_master m,tbl_party_types p WHERE m.id='" . $id . "' AND p.id=m.party_type_id ORDER BY m.id DESC");
        if ($get_parties->num_rows() > 0) {
            $parties = array(
                'name' => $get_parties->row()->name,
                'street' => $get_parties->row()->street,
                'zipcode' => $get_parties->row()->pincode,
                'city' => $get_parties->row()->location_id,
                'country' => $get_parties->row()->country,
                'state' => $get_parties->row()->state,
                'phone' => $get_parties->row()->mobile,
                'email' => $get_parties->row()->email,
                'fax' => $get_parties->row()->fax,
                'code' => $get_parties->row()->customeridentifier,
                'type_id' => $get_parties->row()->party_type_id
            );
        }
    }
    echo json_encode($parties);
}

public function additem() {
    $cdate = date('y-m-d H:i:s');
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $item_id = $post['item_id'];
    $item_name = $post['item_name'];
    $description = $post['description'];
    $user_id = $this->session->userdata('user_id');
    $length = isset($post['length']) ? $post['length'] : "0";
    $width = isset($post['width']) ? $post['width'] : "0";
    $weight = isset($post['weight']) ? $post['weight'] : "0";
    $height = isset($post['height']) ? $post['height'] : "0";
    $volume = isset($post['volume']) ? $post['volume'] : "0";
    $second_volume = isset($post['second_volume']) ? $post['second_volume'] : "0";
    $second_weight = isset($post['second_weight']) ? $post['second_weight'] : "0";
    $volumentric_weight = isset($post['volumentric_weight']) ? $post['volumentric_weight'] : "0";
    $volumentric_weight = isset($post['volumentric_weight']) ? $post['volumentric_weight'] : "0";
    $secondvolume_uom = isset($post['secondvolume_uom']) ? $post['secondvolume_uom'] : "cbm";
    $item_number = isset($post['item_number']) ? $post['item_number'] : "";
    $hsn_code = isset($post['hsn_code']) ? $post['hsn_code'] : "";
    $color_code = isset($post['color_code']) ? $post['color_code'] : "";
    $color_code_name = isset($post['color_code_name']) ? $post['color_code_name'] : "";
    $size_code = isset($post['size_code']) ? $post['size_code'] : "";
    $size_code_name = isset($post['size_code_name']) ? $post['size_code_name'] : "";
    $unit_price = isset($post['unit_price']) ? $post['unit_price'] : "0.00";
	if($unit_price==""){
		$unit_price="0.00";
	}
    if ($secondvolume_uom == "") {
        $secondvolume_uom = 'cbm';
    }
    $secondweight_uom = isset($post['secondweight_uom']) ? $post['secondweight_uom'] : "kg";
    $item_number = isset($post['item_number']) ? $post['item_number'] : "";
    $hsn_code = isset($post['hsn_code']) ? $post['hsn_code'] : "";
    $color_code = isset($post['color_code']) ? $post['color_code'] : "";
    $color_code_name = isset($post['color_code_name']) ? $post['color_code_name'] : "";
    $size_code = isset($post['size_code']) ? $post['size_code'] : "";
    $size_code_name = isset($post['size_code_name']) ? $post['size_code_name'] : "";

    if ($secondweight_uom == "") {
        $secondweight_uom = 'kg';
    }
    if ($length == "") {
        $length = 0;
    }
    if ($second_volume == "") {
        $second_volume = 0;
    }
    if ($second_weight == "") {
        $second_weight = 0;
    }
    if ($width == "") {
        $width = 0;
    }
    if ($weight == "") {
        $weight = 0;
    }
    if ($height == "") {
        $height = 0;
    }
    if ($volume == "") {
        $volume = 0;
    }
    if ($volumentric_weight == "") {
        $volumentric_weight = 0;
    }
    $ins_ar = array(
        'item_id' => $item_id,
        'item_name' => $item_name,
        'description' => $description,
        'status' => '1',
        'createdby' => $user_id,
        'length' => $length,
        'length_unit' => $post['length_uom'],
        'width' => $width,
        'width_unit' => $post['width_uom'],
        'weight' => $weight,
        'weight_unit' => $post['weight_uom'],
        'height' => $height,
        'height_unit' => $post['height_uom'],
        'volume' => $volume,
        'volume_unit' => $post['volume_uom'],
        'volumetric_weight' => $volumentric_weight,
        'volweight_uom' => $post['volumeticweight_uom'],
        'second_volume' => $second_volume,
        'second_weight' => $second_weight,
        'secondweight_uom' => $secondweight_uom,
        'secondvolume_uom' => $secondvolume_uom,
        'item_number' => $item_number,
        'hsn_code' => $hsn_code,
        'color_code' => $color_code,
        'color_code_name' => $color_code_name,
        'size_code' => $size_code,
        'size_code_name' => $size_code_name,
        'unit_price' => $unit_price
    );
    $chk = $this->db->select('id')->get_where('tb_items', $ins_ar);
    if ($chk->num_rows() == 0) {
        $ins = $this->common->insertTableData('tb_items', $ins_ar);
        if ($ins) {
            $ins_id = $ins;
            $ins_type = 'ins';
        } else {
            $ins_id = 0;
            $ins_type = '';
        }
    } else {
        $ins_id = $chk->row()->id;
        $ins_type = 'upd';
    }
    $res = array(
        'id' => $ins_id,
        'ins' => $ins_type
    );
    echo json_encode($res);
}

public function getitemid() {
// $post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $term = $post['term'];
    $result = array();
    $whr = "";
    $outer_cargo = isset($post['outer_cargo']) ? $post['outer_cargo'] : "";
    if ($outer_cargo != "") {
        $whr .= " AND item_id NOT LIKE '" . $outer_cargo . "' ";
    }
    $whr1 = $whr2 = "";
    if ($this->session->userdata('cust_id') !== FALSE) {
        $custid = $this->session->userdata('cust_id');
        $ironmountain_ids = array(
            '415',
            '187',
            '188',
            '192',
            '226',
            '428',
            '431',
            '430',
            '426',
            '427',
            '418',
            '417',
            '429',
            '419',
            '423',
            '416',
            '422',
            '425',
            '420',
            '424',
            '489',
            '421'
        );
        if ($custid != "" && $custid != '0') {
            if (in_array($custid, $ironmountain_ids)) {
                $whr1 = "AND item_id IN ('Docs','Non-Docs') ";
            }
            $company_code = $this->session->userdata('company_code');
            if ($company_code == "NZKN") {
                $whr2 = " AND description LIKE 'APPLIANCES' ";
            }
        }
    }
    $getitemname = $this->db->query("SELECT id,item_id FROM tb_items WHERE item_id LIKE '%" . $term . "%' " . $whr . " " . $whr1 . " " . $whr2 . " ORDER BY createdon DESC");
    if ($getitemname->num_rows() > 0) {
        foreach ($getitemname->result() as $res) {
            $result[] = array(
                'id' => $res->id,
                'item_id' => $res->item_id
            );
        }
    }
    echo json_encode($result);
}

public function searchviewitem() {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $term = $post['term'];
    $result = array();
    $getitemname = $this->db->query("SELECT * FROM tb_items WHERE item_id LIKE '%" . $term . "%' GROUP BY id ORDER BY createdon DESC");
    if ($getitemname->num_rows() > 0) {
        foreach ($getitemname->result() as $res) {
            $second_weight = $res->second_weight;
            $second_volume = $res->second_volume;
            if ($second_weight == "") {
                $second_weight = 0;
            }
            if ($second_volume == "") {
                $second_volume = 0;
            }
            $check = "<input type='radio' name='listitem' id='listitem_" . $res->id . "' class='listitem' onchange='selectitem(" . $res->id . ")' value='" . $res->id . "'>";
            $result[] = array(
                'check' => $check,
                'id' => $res->id,
                'item_id' => $res->item_id,
                'item_name' => $res->item_name,
                'description' => $res->description,
                'length' => $res->length . $res->length_unit,
                'width' => $res->width . $res->width_unit,
                'height' => $res->height . $res->height_unit,
                'weight' => $res->weight . $res->weight_unit,
                'volume' => $res->volume . $res->volume_unit,
                'volumetric_weight' => $res->volumetric_weight . $res->volweight_uom,
                'second_weight' => $second_weight . $res->secondweight_uom,
                'second_volume' => $second_volume . $res->secondvolume_uom
            );
        }
    }
    echo json_encode($result);
}

public function finditembyid() {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $term = $post['item'];
    $result = array();
    $getitemname = $this->db->query("SELECT * FROM tb_items WHERE item_id LIKE '%" . $term . "%' GROUP BY id ORDER BY createdon DESC");
    if ($getitemname->num_rows() > 0) {
        foreach ($getitemname->result() as $res) {
            $second_weight = $res->second_weight;
            $second_volume = $res->second_volume;
            if ($second_weight == "") {
                $second_weight = 0;
            }
            if ($second_volume == "") {
                $second_volume = 0;
            }
            $check = "<input type='radio' name='listitem' id='listitem_" . $res->id . "' class='listitem' onchange='selectitem(" . $res->id . ")' value='" . $res->item_id . "'>";
            $result[] = array(
                'check' => $check,
                'id' => $res->id,
                'item_id' => $res->item_id,
                'item_name' => $res->item_name,
                'description' => $res->description,
                'length' => $res->length . $res->length_unit,
                'width' => $res->width . $res->width_unit,
                'height' => $res->height . $res->height_unit,
                'weight' => $res->weight . $res->weight_unit,
                'volume' => $res->volume . $res->volume_unit,
                'second_weight' => $second_weight . $res->secondweight_uom,
                'second_volume' => $second_volume . $res->secondvolume_uom
            );
        }
    }
    echo json_encode($result);
}

public function viewitemslist() {
    $items = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $type = isset($post['ctype']) ? $post['ctype'] : "";
    $popup = isset($post['popup']) ? $post['popup'] : "";
    $whr = "";
    if ($type != "") {
        $whr .= " AND item_id NOT LIKE '%" . $type . "%'";
    }
    $check = $whr1 = $whr2 = "";
    if ($this->session->userdata('cust_id') !== FALSE) {
        $custid = $this->session->userdata('cust_id');
        $ironmountain_ids = array(
            '415',
            '187',
            '188',
            '192',
            '226',
            '428',
            '431',
            '430',
            '426',
            '427',
            '418',
            '417',
            '429',
            '419',
            '423',
            '416',
            '422',
            '425',
            '420',
            '424',
            '489',
            '421'
        );
        if ($custid != "" && $custid != '0') {
            if (in_array($custid, $ironmountain_ids)) {
                $whr1 = "AND item_id IN ('Docs','Non-Docs') ";
            }
            $company_code = $this->session->userdata('company_code');
            if ($company_code == 'NZKN') {
                $whr2 = " AND description LIKE 'APPLIANCES' ";
            }
        }
    }

    $qry = $this->db->query("SELECT * FROM tb_items WHERE status='1'" . $whr . " " . $whr1 . " " . $whr2 . "  GROUP BY id ORDER BY id DESC");
    if ($qry->num_rows() > 0) {
        foreach ($qry->result() as $res) {
            $second_weight = $res->second_weight;
            $second_volume = $res->second_volume;
            if ($second_weight == "") {
                $second_weight = 0;
            }
            if ($second_volume == "") {
                $second_volume = 0;
            }
            $check = "<input type='radio' name='listitem' id='listitem_" . $res->id . "' class='listitem' onchange='selectitem(" . $res->id . ")' value='" . $res->id . "'>";
            $items[] = array(
                'check' => $check,
                'item_name' => $res->item_name,
                'item_id' => $res->item_id,
                'description' => $res->description,
                'length' => $res->length . $res->length_unit,
                'width' => $res->width . $res->width_unit,
                'height' => $res->height . $res->height_unit,
                'weight' => $res->weight . $res->weight_unit,
                'volume' => $res->volume . $res->volume_unit,
                'volumentric_weight' => $res->volumetric_weight . $res->volweight_uom,
                'second_weight' => $second_weight . $res->secondweight_uom,
                'second_volume' => $second_volume . $res->secondvolume_uom
            );
        }
    }
    echo json_encode($items);
}

public function getitemdetailsbyId() {
    $items = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $item_id = $post['item_id'];
    $qry = $this->db->query("SELECT * FROM tb_items WHERE status='1' and item_id LIKE '" . $item_id . "' ORDER BY createdon DESC");
    if ($qry->num_rows() > 0) {
        foreach ($qry->result() as $res) {
            $second_weight = $res->second_weight;
            $second_volume = $res->second_volume;
            if ($second_weight == "") {
                $second_weight = 0;
            }
            if ($second_volume == "") {
                $second_volume = 0;
            }
            $items[] = array(
                'item_name' => $res->item_name,
                'item_id' => $res->item_id,
                'description' => $res->description,
                'length' => $res->length,
                'length_uom' => $res->length_unit,
                'width' => $res->width,
                'width_uom' => $res->width_unit,
                'height' => $res->height,
                'height_uom' => $res->height_unit,
                'weight' => $res->weight,
                'weight_uom' => $res->weight_unit,
                'volume' => $res->volume,
                'volume_uom' => $res->volume_unit,
                'second_weight' => $second_weight . $res->secondweight_uom,
                'second_volume' => $second_volume . $res->secondvolume_uom
            );
        }
    }
    echo json_encode($items);
}

public function getitemdetailslist() {
    $items = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $item_id = isset($post['item_id']) ? $post['item_id'] : "";
    if ($item_id != "") {
        $qry = $this->db->query("SELECT * FROM tb_items WHERE status='1' and id = '" . $item_id . "' ORDER BY createdon DESC");
        if ($qry->num_rows() > 0) {
            foreach ($qry->result() as $res) {
                $second_weight = $res->second_weight;
                $second_volume = $res->second_volume;
                if ($second_weight == "") {
                    $second_weight = 0;
                }
                if ($second_volume == "") {
                    $second_volume = 0;
                }
                $items[] = array(
                    'item_name' => $res->item_name,
                    'item_id' => $res->item_id,
                    'description' => $res->description,
                    'length' => $res->length,
                    'length_uom' => ucfirst($res->length_unit),
                    'width' => $res->width,
                    'width_uom' => ucfirst($res->width_unit),
                    'height' => $res->height,
                    'height_uom' => ucfirst($res->height_unit),
                    'weight' => $res->weight,
                    'weight_uom' => ucfirst($res->weight_unit),
                    'volume' => $res->volume,
                    'volume_uom' => ucfirst($res->volume_unit),
                    'volumetric_weight' => $res->volumetric_weight,
                    'volweight_uom' => ucfirst($res->volweight_uom),
                    'second_volume' => $second_volume,
                    'second_weight' => $second_weight,
                    'secondweight_uom' => ucfirst($res->secondweight_uom),
                    'secondvolume_uom' => ucfirst($res->secondvolume_uom),
                    'item_num_id' => $res->id,
                    'item_number' => $res->item_number,
                    'hsn_code' => $res->hsn_code,
                    'color_code' => $res->color_code,
                    'color_code_name' => $res->color_code_name,
                    'size_code' => $res->size_code,
                    'size_code_name' => $res->size_code_name,
                    'unit_price' => $res->unit_price
                );
            }
        }
    }

    echo json_encode($items);
}

public function getordercargodetails() {
    $cargos =  array();

    $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
    if ($order_id != "") {
        $qry = $this->db->query("SELECT c.id,c.cargo_type,c.length_unit,c.width_unit,c.height_unit,c.weight_unit,c.volume_unit,c.secondweight_uom,c.secondvolume_uom,c.goods_description,c.stackable,c.grounded,c.splittable,c.dg_goods,o.id as ordcargoid,o.length,o.width,o.height,o.weight,o.second_weight,o.volume,o.second_volume,o.volumetric_weight,o.volweight_uom,c.ldm,o.quantity,o.scanned_quantity,o.qr_code,o.reference_order_num,o.marks_numbers FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $order_id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");

        if ($qry->num_rows() > 0) {
            $totalqty = count($qry->result());
            $i = 0;
            foreach ($qry->result() as $res) {
                $i++;
                $stackable = 'Off';
                if ($res->stackable == 0) {
                    $stackable = 'Off';
                } else if ($res->stackable == 1) {
                    $stackable = 'On';
                }
                $grounded = 'Off';
                if ($res->grounded == 0) {
                    $grounded = 'Off';
                } else if ($res->grounded == 1) {
                    $grounded = 'On';
                }
                $splittable = 'Off';
                if ($res->splittable == 0) {
                    $splittable = 'Off';
                } else if ($res->splittable == 1) {
                    $splittable = 'On';
                }
                $dg_goods = 'Off';
                if ($res->dg_goods == 0) {
                    $dg_goods = 'Off';
                } else if ($res->dg_goods == 1) {
                    $dg_goods = 'On';
                }
                $cargo_type = '"' . $res->cargo_type . '"';
                $goods_desc = '"' . $res->goods_description . '"';
                $marks_numbers       = '"' . $res->marks_numbers . '"';
                $length_unit = '"' . $res->length_unit . '"';
                $width_unit = '"' . $res->width_unit . '"';
                $height_unit = '"' . $res->height_unit . '"';
                $weight_unit = '"' . $res->weight_unit . '"';
                $volume_unit = '"' . $res->volume_unit . '"';
                $volweight_uom = '"' . $res->volweight_uom . '"';
                $secondweight_uom = '"' . $res->secondweight_uom . '"';
                $secondvolume_uom = '"' . $res->secondvolume_uom . '"';
                $scanned_quantity = $res->scanned_quantity;
                $second_weight = $res->second_weight;
                $second_volume = $res->second_volume;
                if ($scanned_quantity == "") {
                    $scanned_quantity = 0;
                }
                if ($second_volume == "") {
                    $second_volume = 0;
                }
                if ($second_weight == "") {
                    $second_weight = 0;
                }
                if ($scanned_quantity == 0) {
                    $alertmsg = "'There is no Labels Scanned for this cargo..!'";
                    $label = '<a href="#" onclick="alert(' . $alertmsg . ')"><span class="icon tru-icon-pdf"></span></a>';
                } else {
                    $label = '<a href="' . base_url("aulabel/index?order_car_id=" . $res->ordcargoid . "&tot=" . $totalqty . "&cargo_row_id=" . $i) . '" target="_blank" title="' . $this->lang->line('print_label') . '"><span class="icon tru-icon-pdf"></span></a>';
                }
                $volumetric_weight = $res->volumetric_weight;
                if ($volumetric_weight == "") {
                    $volumetric_weight = 0;
                }
                $ldm = $res->ldm;
                if ($ldm == "") {
                    $ldm = 0;
                }

                $qrcode = $res->qr_code;
                if ($this->session->userdata('company_code') == "NZKN" && $this->session->userdata('cust_id') != "") {
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcuscargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . "," . $marks_numbers . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $ldm . "," . $scanned_quantity . "," . $second_weight . "," . $secondweight_uom . "," . $second_volume . "," . $secondvolume_uom . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteordercargodetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargos</a></li>";

                    $empty = "";
                    $cargos[] = array(
                        'id' => $res->id,
                        'cargo_type' => $res->cargo_type,
                        'goods_desc' => $res->goods_description,
                        'marks_numbers'          => $res->marks_numbers,
                        'quantity' => $res->quantity,
                        'length' => $res->length . " " . $res->length_unit,
                        'width' => $res->width . " " . $res->width_unit,
                        'height' => $res->height . " " . $res->height_unit,
                        'weight' => $res->weight . " " . $res->weight_unit,
                        'volume' => $res->volume . " " . $res->volume_unit,
                        'volumetric_weight' => $volumetric_weight . " " . $res->volweight_uom,
                        'stackable' => $stackable,
                        'splittable' => $splittable,
                        'grounded' => $grounded,
                        'action' => $action,
                        'empty' => $empty,
                        'dg_goods' => $dg_goods,
                        "ldm" => $ldm,
                        'scanned_quantity' => $scanned_quantity,
                        'qrcode' => $qrcode,
                        'label' => $label,
                        'reference_order_num' => $res->reference_order_num,
                        'second_weight' => $second_weight . " " . $res->secondweight_uom,
                        'second_volume' => $second_volume . " " . $res->secondvolume_uom
                    );
                } else {
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc .  "," . $marks_numbers . ","  . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $ldm . "," . $scanned_quantity . "," . $second_weight . "," . $secondweight_uom . "," . $second_volume . "," . $secondvolume_uom . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteordercargodetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargos</a></li>";
                    $empty = "";
                    $cargos[] = array(
                        'id' => $res->id,
                        'cargo_type' => $res->cargo_type,
                        'goods_desc' => $res->goods_description,
                        'marks_numbers'          => $res->marks_numbers,
                        'quantity' => $res->quantity,
                        'length' => $res->length . " " . $res->length_unit,
                        'width' => $res->width . " " . $res->width_unit,
                        'height' => $res->height . " " . $res->height_unit,
                        'weight' => $res->weight . " " . $res->weight_unit,
                        'volume' => $res->volume . " " . $res->volume_unit,
                        'volumetric_weight' => $volumetric_weight . " " . $res->volweight_uom,
                        'stackable' => $stackable,
                        'splittable' => $splittable,
                        'grounded' => $grounded,
                        'action' => $action,
                        'empty' => $empty,
                        'dg_goods' => $dg_goods,
                        "ldm" => $ldm,
                        'scanned_quantity' => $scanned_quantity,
                        'qrcode' => $qrcode,
                        'label' => $label,
                        'reference_order_num' => $res->reference_order_num,
                        'second_weight' => $second_weight . " " . $res->secondweight_uom,
                        'second_volume' => $second_volume . " " . $res->secondvolume_uom
                    );
                }
            }
        }
    }
    echo json_encode($cargos);
}

public function deleteorder($id) {
    if ($id != '' || $id != 0) {
        $chk = $this->db->select('id')->get_where("tb_orders", array(
            'id' => $id
        ));

        if ($chk->num_rows() > 0) {
            $upd = $this->db->where(array(
                'id' => $id
            ))->update('tb_orders', array(
                'status' => 0
            ));

            if ($upd) {
                $refs = new OrderReference();
                $refs->deleteForOrder($id, ['DQ']);
            }
        }
        $this->ordernotify('booking_delete', $id);
    }
    echo "1";
}

public function deleteordercargodetails() {
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $order_id = isset($post['order_id']) ? $post['order_id'] : '0';
    $cargo_id = isset($post['cargo_id']) ? $post['cargo_id'] : '0';
    if ($order_id != '0' && $cargo_id != '0') {
        $chk = $this->db->select('id')->get_where('tb_order_cargodetails', array(
            'order_id' => $order_id,
            'cargo_id' => $cargo_id
        ));
        if ($chk->num_rows() > 0) {
            $row_id = $chk->row()->id;
            $upd = $this->db->where(array(
                'id' => $row_id
            ))->update('tb_order_cargodetails', array(
                'status' => '0'
            ));
            if ($upd) {
                echo "1";
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    } else {
        echo "0";
    }
}

public function showcargodetails() {
    $user_id = $this->session->userdata('user_id');
    $cargos = $post = array();
    $post = $this->input->post(NULL);
    $ids = isset($post['cargo_id']) ? $this->db->escape_str($post['cargo_id']) : "";
    $type = isset($post['type']) ? $this->db->escape_str($post['type']) : "";
    if ($ids != "") {
        $cargo_ids = implode(',', $ids);
        if (!empty($cargo_ids)) {
            $qry = $this->db->query("SELECT c.* FROM tb_cargo_details c WHERE c.id IN (" . $cargo_ids . ") AND c.status='1' GROUP BY c.id ORDER BY c.id DESC");
            if ($qry->num_rows() > 0) {
                if ($type == 'popup') {
                    foreach ($qry->result() as $res) {
                        $stackable = 'Off';
                        if ($res->stackable == 0) {
                            $stackable = 'Off';
                        } else if ($res->stackable == 1) {
                            $stackable = 'On';
                        }
                        $grounded = 'Off';
                        if ($res->grounded == 0) {
                            $grounded = 'Off';
                        } else if ($res->grounded == 1) {
                            $grounded = 'On';
                        }
                        $splittable = 'Off';
                        if ($res->splittable == 0) {
                            $splittable = 'Off';
                        } else if ($res->splittable == 1) {
                            $splittable = 'On';
                        }
                        $dg_goods = 'Off';
                        if ($res->dg_goods == 0) {
                            $dg_goods = "Off";
                        } else if ($res->dg_goods == 1) {
                            $dg_goods = "<span title='Click To Get Dgoods' onclick = 'getDangerousGoodsDetails(" . $res->dg_goods . "," . $res->id . ",0)' style='cursor:pointer;'>On</span>";
                        }
                        $second_volume = $res->second_volume;
                        if ($second_volume == "") {
                            $second_volume = 0;
                        }
                        $second_weight = $res->second_weight;
                        if ($second_weight == "") {
                            $second_weight = 0;
                        }
                        $ldm = $res->ldm;
                        if ($ldm == "") {
                            $ldm = 0;
                        }
                        $volumetric_weight = $res->volumetric_weight;
                        if ($volumetric_weight == "") {
                            $volumetric_weight = 0;
                        }
                        $action = "<button id=" . $res->id . " class='btn btn-xs' onclick='editpopupcargodetails(" . $res->id . ",event)'><span class='icon tru-icon-edit' aria-hidden='true'></span></button> <button id=" . $res->id . " class='btn btn-xs' onclick='deletepopupcargodetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                        $cargos[] = array(
                            'cargo_type' => $res->cargo_type,
                            'goods_desc' => $res->goods_description,
                            'marks_numbers'      => $res->marks_numbers,
                            'quantity' => $res->quantity,
                            'length' => $res->length . " " . $res->length_unit,
                            'width' => $res->width . " " . $res->width_unit,
                            'height' => $res->height . " " . $res->height_unit,
                            'weight' => $res->weight . " " . $res->weight_unit,
                            'volume' => $res->volume . " " . $res->volume_unit,
                            'volumentric_weight' => $volumetric_weight . " " . $res->volweight_uom,
                            'stackable' => $stackable,
                            'grounded' => $grounded,
                            'splittable' => $splittable,
                            'dg_goods' => $dg_goods,
                            'ldm' => $ldm,
                            'second_weight' => $second_weight . " " . $res->secondweight_uom,
                            'second_volume' => $second_volume . " " . $res->secondvolume_uom,
                            'action' => $action
                        );
                    }
                } else {
                    foreach ($qry->result() as $res) {
                        $stackable = 'Off';
                        if ($res->stackable == 0) {
                            $stackable = 'Off';
                        } else if ($res->stackable == 1) {
                            $stackable = 'On';
                        }
                        $grounded = 'Off';
                        if ($res->grounded == 0) {
                            $grounded = 'Off';
                        } else if ($res->grounded == 1) {
                            $grounded = 'On';
                        }
                        $splittable = 'Off';
                        if ($res->splittable == 0) {
                            $splittable = 'Off';
                        } else if ($res->splittable == 1) {
                            $splittable = 'On';
                        }
                        $dg_goods = 'Off';
                        if ($res->dg_goods == 0) {
                            $dg_goods = 'Off';
                        } else if ($res->dg_goods == 1) {
                            $dg_goods = "<span title='Click To Get Dgoods' onclick = getDangerousGoodsDetails(" . $res->dg_goods . "," . $res->id . ",0) style='cursor:pointer;'>On</span>";
                        }

                        $cargos_ar = [
                            'id' => $res->id,
                            'cargo_type' => $res->cargo_type,
                            'goods_desc' => $res->goods_description,
                            'marks_numbers' => $res->marks_numbers,
                            'quantity' => $res->quantity,
                            'length' => $res->length . " " . $res->length_unit,
                            'width' => $res->width . " " . $res->width_unit,
                            'height' => $res->height . " " . $res->height_unit,
                            'weight' => $res->weight . " " . $res->weight_unit,
                            'volume' => $res->volume . " " . $res->volume_unit,
                            'stackable' => $stackable,
                            'dg_goods' => $dg_goods,
                        ];
                        $cargo_type = '"' . $res->cargo_type . '"';
                        $goods_desc = '"' . $res->goods_description . '"';
                        $marks_numbers       = '"' . $res->marks_numbers . '"';
                        $length_unit = '"' . $res->length_unit . '"';
                        $width_unit = '"' . $res->width_unit . '"';
                        $height_unit = '"' . $res->height_unit . '"';
                        $weight_unit = '"' . $res->weight_unit . '"';
                        $volume_unit = '"' . $res->volume_unit . '"';
                        $volweight_uom = '"' . $res->volweight_uom . '"';
                        $secondweight_uom = '"' . $res->secondweight_uom . '"';
                        $secondvolume_uom = '"' . $res->secondvolume_uom . '"';
                        $scanned_quantity = 0;
                        $second_volume = $res->second_volume;
                        $second_weight = $res->second_weight;
                        $volumetric_weight = $res->volumetric_weight;
                        $ldm = $res->ldm;
                        if ($second_weight == "") {
                            $second_weight = 0;
                        }
                        if ($second_volume == "") {
                            $second_volume = 0;
                        }
                        if ($volumetric_weight == "") {
                            $volumetric_weight = 0;
                        }
                        if ($ldm == "") {
                            $ldm = 0;
                        }
                        if ($this->session->userdata('company_code') == "NZKN" && $this->session->userdata('cust_id') != "") {
                            $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcuscargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . "," . $marks_numbers . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $ldm . "," . $scanned_quantity . "," . $second_weight . "," . $secondweight_uom . "," . $second_volume . "," . $secondvolume_uom . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowCargoElim(this," . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargo</a></li>";
                        } else {
                            $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . "," . $marks_numbers . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $ldm . "," . $scanned_quantity . "," . $second_weight . "," . $secondweight_uom . "," . $second_volume . "," . $secondvolume_uom . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowCargoElim(this," . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargo</a></li>";
                        }
                        $cargos[] = array(
                            'id' => $res->id,
                            'cargo_type' => $res->cargo_type,
                            'goods_desc' => $res->goods_description,
                            'marks_numbers'         => $res->marks_numbers,
                            'quantity' => $res->quantity,
                            'length' => $res->length . " " . $res->length_unit,
                            'width' => $res->width . " " . $res->width_unit,
                            'height' => $res->height . " " . $res->height_unit,
                            'weight' => $res->weight . " " . $res->weight_unit,
                            'volume' => $res->volume . " " . $res->volume_unit,
                            'volumentric_weight' => $volumetric_weight . " " . $res->volweight_uom,
                            'stackable' => $stackable,
                            'splittable' => $splittable,
                            'grounded' => $grounded,
                            'dg_goods' => $dg_goods,
                            'ldm' => $ldm,
                            'action' => $action,
                            'scanned_quantity' => $scanned_quantity,
                            'second_weight' => $second_weight . " " . $res->secondweight_uom,
                            'second_volume' => $second_volume . " " . $res->secondvolume_uom
                        );
                    }
                }
            }
        }
    }
    echo json_encode($cargos);
}

public function getinnercargo() {
    $cargos = array();
    $post = $this->input->post(NULL,TRUE);
    $cargo_id = isset($post['cargo_id']) ? $this->db->escape_str($post['cargo_id']) : "0";
    if ($cargo_id != "" || $cargo_id != 0) {
        $inner_qry = $this->db->query("SELECT i.id as inner_id,i.cargo_type as inner_cargo,i.goods_description as inner_gd,i.quantity as inner_quantity,i.length as inner_length,i.length_unit as inner_lum,i.width as inner_width,i.width_unit as inner_wum,i.height as inner_height,i.height_unit as inner_hum,i.weight as inner_weight,i.weight_unit as inner_weum,i.volume as inner_volume,i.volume_unit as inner_vum,i.stackable as inner_stackable,i.ref_order_num FROM tb_inner_cargo i WHERE i.cargo_id='" . $cargo_id . "' AND i.status='1' GROUP BY i.id ORDER BY i.id DESC");

        if ($inner_qry->num_rows() > 0) {
            foreach ($inner_qry->result() as $inner) {
                $stackable = 'Off';
                if ($inner->inner_stackable == 0) {
                    $stackable = 'Off';
                } else if ($inner->inner_stackable == 1) {
                    $stackable = 'On';
                }
                $cargo_type = '"' . $inner->inner_cargo . '"';
                $goods_desc = '"' . $inner->inner_gd . '"';
                /* $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default' onclick='rowinnercargoEdit(this," . $inner->inner_id . "," . $cargo_type . "," . $goods_desc . "," . $inner->inner_quantity . "," . $inner->inner_length . "," . $inner->inner_width . "," . $inner->inner_height . "," . $inner->inner_weight . "," . $inner->inner_volume . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteinnercargopackage(" . $inner->inner_id . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='addinnercargo(this," . $cargo_id . ");'><span class='fa fa-archive' > </span>Inner Cargo</a></li>"; */
                $action = "";
                $ref_order_num = $inner->ref_order_num;
                $ref_order_num = (!empty($ref_order_num)) ? ($ref_order_num) : "";
                $cargos[] = array(
                    'inner_id' => $inner->inner_id,
                    'main_cargo_id' => $cargo_id,
                    'ref_order_num' => $ref_order_num,
                    'inner_cargo' => $inner->inner_cargo,
                    'inner_gd' => $inner->inner_gd,
                    'inner_quantity' => $inner->inner_quantity,
                    'inner_width' => $inner->inner_width . " " . $inner->inner_wum,
                    'inner_height' => $inner->inner_height . " " . $inner->inner_hum,
                    'inner_length' => $inner->inner_length . " " . $inner->inner_lum,
                    'inner_weight' => $inner->inner_weight . " " . $inner->inner_weum,
                    'inner_volume' => $inner->inner_volume . " " . $inner->inner_vum,
                    'inner_stackable' => $stackable,
                    'action' => $action
                );
            }
        }
    }
    echo json_encode($cargos);
}

public function deleteorderpartydetails() {
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $order_id = isset($post['order_id']) ? $post['order_id'] : "0";
    $party_id = isset($post['party_id']) ? $post['party_id'] : "0";
    if ($order_id != '0' && $party_id != '0') {
        $getdata = $this->db->query("SELECT id FROM tb_order_parties WHERE status='1' AND party_id='" . $party_id . "' AND order_id ='" . $order_id . "'");
        if ($getdata->num_rows() > 0) {
            $id = $getdata->row()->id;
            $upd = $this->db->where(array(
                'id' => $id
            ))->update("tb_order_parties", array(
                'status' => 0
            ));
            if ($upd) {
                echo "1";
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }
}

public function savecargo($id = NULL) {
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $cdate = date('Y-m-d H:i:s');
    $cargo_id = 0;
    $inner_id = $data = $inner = array();
    $user_id = $this->session->userdata('user_id');
    $stackable = isset($post['stackable']) ? $this->db->escape_str($post['stackable']) : "0";
    $grounded = isset($post['grounded']) ? $this->db->escape_str($post['grounded']) : "0";
    $splittable = isset($post['splittable']) ? $this->db->escape_str($post['splittable']) : "0";
    $dg_goods = isset($post['dg_goods']) ? $this->db->escape_str($post['dg_goods']) : "0";
    $length = isset($post['length']) ? $this->db->escape_str($post['length']) : "0.00";
    $width = isset($post['width']) ? $this->db->escape_str($post['width']) : "0.00";
    $height = isset($post['height']) ? $this->db->escape_str($post['height']) : "0.00";
    $weight = isset($post['weight']) ? $this->db->escape_str($post['weight']) : "0.00";
    $volume = isset($post['volume']) ? $this->db->escape_str($post['volume']) : "0.00";
    $ldm = isset($post['ldm']) ? $this->db->escape_str($post['ldm']) : "0.00";
    $itemid = isset($post['item_num_id']) ? $this->db->escape_str($post['item_num_id']) : 0;
    $secondweight = isset($post['secondweight']) ? $this->db->escape_str($post['secondweight']) : "0.00";
    $secondvolume = isset($post['secondvolume']) ? $this->db->escape_str($post['secondvolume']) : "0.00";
    $marks_numbers = isset($post['marks_numbers']) ? $this->db->escape_str($post['marks_numbers']) : "";
    $dgRowIds = $post['dgRowIds'] ?? [];
    if ($ldm == "" || !(is_numeric($ldm))) {
        $ldm = "0.00";
    }
    if ($secondvolume == "" || !(is_numeric($secondvolume))) {
        $secondvolume = "0.00";
    }
    if ($secondweight == "" || !(is_numeric($secondweight))) {
        $secondweight = "0.00";
    }
    $volumetric_weight = isset($post['volumetric_weight']) ? $post['volumetric_weight'] : "0.00";
    if ($volumetric_weight == "" || !(is_numeric($volumetric_weight))) {
        $volumetric_weight = "0.00";
    }
    if ($length == "") {
        $length = '0.00';
    }
    if ($width == "") {
        $width = '0.00';
    }
    if ($height == "") {
        $height = '0.00';
    }
    if ($weight == "") {
        $weight = '0.00';
    }
    if ($volume == "") {
        $volume = '0.00';
    }
    if ($volumetric_weight == "") {
        $volumetric_weight = '0.00';
    }

    $cargo = array(
        'cargo_type' => $this->db->escape_str($post['cargo_type']),
        'goods_description' => $this->db->escape_str($post['goods_desc']),
        'marks_numbers' => $this->db->escape_str($post['marks_numbers']),
        'quantity' => $this->db->escape_str($post['quantity']),
        'length' => $length,
        'length_unit' => $this->db->escape_str($post['length_uom']),
        'width' => $width,
        'width_unit' => $this->db->escape_str($post['width_uom']),
        'height' => $height,
        'height_unit' => $this->db->escape_str($post['height_uom']),
        'weight' => $weight,
        'weight_unit' => $this->db->escape_str($post['weight_uom']),
        'volume' => $volume,
        'volume_unit' => $this->db->escape_str($post['volume_uom']),
        'volumetric_weight' => $volumetric_weight,
        'volweight_uom' => $this->db->escape_str($post['volweight_uom']),
        'stackable' => $stackable,
        'grounded' => $grounded,
        'splittable' => $splittable,
        'dg_goods' => $dg_goods,
        'createdby' => $user_id,
        'createdon' => $cdate,
        'ldm' => $ldm,
        'second_weight' => $secondweight,
        'second_volume' => $secondvolume,
        'secondvolume_uom' => $this->db->escape_str($post['secondvolume_uom']),
        'secondweight_uom' => $this->db->escape_str($post['secondweight_uom'])
    );
    if ($id == NULL) {
        $cargo['item_id'] = $itemid;
        $ins = $this->db->insert("tb_cargo_details", $cargo);
        $cargo_id = $this->db->insert_id();
        $data = array(
            'cargo_id' => $cargo_id,
            'inner_cargo_id' => $inner_id
        );
    } else {
        $cargo_id = $id;
        $upd = $this->db->where(array(
            'id' => $cargo_id
        ))->update("tb_cargo_details", $cargo);
        $upd = $this->db->where(array(
            'cargo_id' => $cargo_id
        ))->update("tb_order_cargodetails", array(
            'length' => $length,
            'width' => $width,
            'height' => $height,
            'weight' => $weight,
            'volume' => $volume,
            'quantity' => $this->db->escape_str($post['quantity']),
            'quantity_type' => $this->db->escape_str($post['cargo_type']),
            'cargo_content' => $this->db->escape_str($post['goods_desc']),
            'volumetric_weight' => $volumetric_weight,
            'volweight_uom' => $this->db->escape_str($post['volweight_uom']),
            'ldm' => $ldm,
            'second_weight' => $secondweight,
            'marks_numbers'     => $marks_numbers,
            'second_volume' => $secondvolume
        ));
        $data = array(
            'cargo_id' => $cargo_id,
            'inner_cargo_id' => $inner_id
        );
    }
    $order_id = isset($post['order_forcargo']) ? $this->db->escape_str($post['order_forcargo']) : 0;
    if ($order_id == 0) {
        if ($dg_goods > 0) {
            foreach ($dgRowIds as $eachRowId) {
                if ($eachRowId > 0) {
                    $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $cargo_id, 'order_id' => '0'], ['id' => $eachRowId]);
                }
            }
        }
    }
    if ($order_id != '0' && $order_id != "") {
        /*get item details*/
        $qr_code = $hsn_code = $color_code = $color_code_name = $size_code = $size_code_name = "";
        $unit_price = 0;
        $items = $this->common->gettblrowdata(array("id"=>$itemid),"item_number,hsn_code,color_code,color_code_name,size_code,size_code_name,unit_price","tb_items",0,0);
        if(count($items)>0){
            $qr_code = $items['item_number'];
            $hsn_code = $items['hsn_code'];
            $color_code = $items['color_code'];
            $color_code_name = $items['color_code_name'];
            $size_code = $items['size_code'];
            $size_code_name = $items['size_code_name'];
            $unit_price = $items['unit_price'];
        }
        $chk = $this->db->select('id')->get_where('tb_order_cargodetails', array(
            'order_id' => $order_id,
            'cargo_id' => $cargo_id,
            'status' => '1'
        ));

        $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $post['cargo_type'] . "'");
        $handling_unit = "";
        if ($gethandling_unit->num_rows() > 0) {
            $handling_unit = $gethandling_unit->row()->id;
        } else {
            $handlingunit_ar = array(
                'unit_name' => $this->db->escape_str($post['cargo_type']),
                'description' => $this->db->escape_str($post['cargo_type']),
                'user_id' => $user_id,
                'created_at' => $cdate,
                'status' => '1'
            );
            $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
            $handling_unit = $this->db->insert_id();
        }
        if ($chk->num_rows() == 0) {
            $ins = $this->db->insert('tb_order_cargodetails', array(
                'order_id' => $order_id,
                'cargo_id' => $cargo_id,
                'status' => '1',
                'createdon' => $cdate,
                'length' => $length,
                'width' => $width,
                'height' => $height,
                'weight' => $weight,
                'volume' => $volume,
                'quantity' => $this->db->escape_str($post['quantity']),
                'quantity_type' => $this->db->escape_str($post['cargo_type']),
                'cargo_content' => $this->db->escape_str($post['goods_desc']),
                'handling_unit' => $handling_unit,
                'volumetric_weight' => $volumetric_weight,
                'volweight_uom' => $this->db->escape_str($post['volweight_uom']),
                'ldm' => $ldm,
                'second_weight' => $secondweight,
                'second_volume' => $secondvolume,
                'marks_numbers'     => $marks_numbers,
                'qr_code' => $qr_code
            ));
            $cargoId = $this->db->insert_id();
            if ($dg_goods > 0) {
                foreach ($dgRowIds as $eachRowId) {
                    if ($eachRowId > 0) {
                        $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $cargoId, 'order_id' => $order_id], ['id' => $eachRowId]);
                    }
                }
            }
        } else {
            $upd = $this->db->where(array(
                'order_id' => $order_id,
                'cargo_id' => $cargo_id
            ))->update("tb_order_cargodetails", array(
                'length' => $length,
                'width' => $width,
                'height' => $height,
                'weight' => $weight,
                'volume' => $volume,
                'quantity' => $this->db->escape_str($post['quantity']),
                'quantity_type' => $this->db->escape_str($post['cargo_type']),
                'cargo_content' => $this->db->escape_str($post['goods_desc']),
                'handling_unit' => $handling_unit,
                'volumetric_weight' => $volumetric_weight,
                'volweight_uom' => $this->db->escape_str($post['volweight_uom']),
                'ldm' => $ldm,
                'second_weight' => $secondweight,
                'second_volume' => $secondvolume,
                'marks_numbers'     => $marks_numbers,
                'qr_code' => $qr_code
            ));
            if ($dg_goods > 0) {
                foreach ($dgRowIds as $eachRowId) {
                    if ($eachRowId > 0) {
                        $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $chk->row()->id, 'order_id' => $order_id], ['id' => $eachRowId]);
                    }
                }
            }
        }
        if($qr_code != "" && $color_code != "" && $size_code != ""){
            /*check exists*/
            $chkinner = $this->common->gettblrowdata(array('cargo_id'=>$cargo_id,'cargo_type'=>$post['cargo_type']),"id","tb_inner_cargo",0,0);
            $innerarr = array('cargo_id'=>$cargo_id, 'cargo_type'=>$post['cargo_type'], 'goods_description'=>$post['goods_desc'], 'quantity'=>$post['quantity'], 'scanned_quantity'=>0, 'length'=>$length, 'length_unit'=>$cargo['length_unit'], 'width'=>$width, 'width_unit' => $cargo['width_unit'], 'height'=>$height, 'height_unit' => $cargo['height_unit'], 'weight' => $weight, 'weight_unit' => $cargo['weight_unit'], 'volume' => $volume, 'volume_unit' => $cargo['volume_unit'], 'stackable'=>0, 'qr_code'=>$qr_code, 'status'=>1, 'createdby'=>$user_id, 'createdon'=>$cdate, 'updatedon'=>$cdate, 'color_code'=>$color_code, 'color_code_name'=>$color_code_num, 'size_code'=>$size_code, 'size_name'=>$size_code_name, 'unit_price'=>$unit_price, 'd_hsn_code'=>$hsn_code);
            if(count($chkinner)>0){
                $upd = $this->common->updatetbledata("tb_inner_cargo",$innerarr,$whr);
            }else{
                $inner_id = $this->common->insertTableData('tb_inner_cargo',$innerarr);
            }
        }
    }
    echo json_encode($data);
}

public function saveinnercargo($id = NULL) {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $cdate = date('Y-m-d H:i:s');
    $cargo_id = 0;
    $inner_id = $data = $inner = array();
    $main_cargo_id = isset($post['main_cargo_id']) ? $this->db->escape_str($post['main_cargo_id']) : "0";
    $user_id = $this->session->userdata('user_id');

    $stackable = isset($post['stackable']) ? $this->db->escape_str($post['stackable']) : "0";
    $length = isset($post['length']) ? $this->db->escape_str($post['length']) : "0.00";
    $width = isset($post['width']) ? $this->db->escape_str($post['width']) : "0.00";
    $height = isset($post['height']) ? $this->db->escape_str($post['height']) : "0.00";
    $weight = isset($post['weight']) ? $this->db->escape_str($post['weight']) : "0.00";
    $volume = isset($post['volume']) ? $this->db->escape_str($post['volume']) : "0.00";
// if($main_cargo_id != "0"){
    if ($length == "") {
        $length = '0.00';
    }
    if ($width == "") {
        $width = '0.00';
    }
    if ($height == "") {
        $height = '0.00';
    }
    if ($weight == "") {
        $weight = '0.00';
    }
    if ($volume == "") {
        $volume = '0.00';
    }
    if ($id == NULL) {
        $inner_cargo = array(
            'cargo_id' => $main_cargo_id,
            'cargo_type' => $this->db->escape_str($post['cargo_type']),
            'goods_description' => $this->db->escape_str($post['goods_desc']),
            'quantity' => $this->db->escape_str($post['quantity']),
            'length' => $length,
            'length_unit' => $this->db->escape_str($post['length_uom']),
            'width' => $width,
            'width_unit' => $this->db->escape_str($post['width_uom']),
            'height' => $height,
            'height_unit' => $this->db->escape_str($post['height_uom']),
            'weight' => $weight,
            'weight_unit' => $this->db->escape_str($post['weight_uom']),
            'volume' => $volume,
            'volume_unit' => $this->db->escape_str($post['volume_uom']),
            'stackable' => $stackable,
            'createdby' => $user_id,
            'createdon' => $cdate
        );
        $ins = $this->db->insert("tb_inner_cargo", $inner_cargo);
        $innercargo_id = $this->db->insert_id();
        $data = array(
            'main_cargo_id' => $main_cargo_id
        );
    } else {
        $innercargo_id = $id;
        if ($main_cargo_id == "" && $main_cargo_id == 0) {
            $getmaincargo = $this->db->select("cargo_id")->get_where("tb_inner_cargo", array(
                'id' => $innercargo_id
            ));
            if ($getmaincargo->num_rows() > 0) {
                $main_cargo_id = $getmaincargo->row()->cargo_id;
            }
        }
        $inner_cargo = array(
            'cargo_id' => $main_cargo_id,
            'cargo_type' => $this->db->escape_str($post['cargo_type']),
            'goods_description' => $this->db->escape_str($post['goods_desc']),
            'quantity' => $this->db->escape_str($post['quantity']),
            'length' => $length,
            'length_unit' => $this->db->escape_str($post['length_uom']),
            'width' => $width,
            'width_unit' => $this->db->escape_str($post['width_uom']),
            'height' => $height,
            'height_unit' => $this->db->escape_str($post['height_uom']),
            'weight' => $weight,
            'weight_unit' => $this->db->escape_str($post['weight_uom']),
            'volume' => $volume,
            'volume_unit' => $this->db->escape_str($post['volume_uom']),
            'stackable' => $stackable
        );
        $upd = $this->db->where(array(
            'id' => $innercargo_id
        ))->update("tb_inner_cargo", $inner_cargo);
        $data = array(
            'main_cargo_id' => $main_cargo_id
        );
    }
    echo json_encode($data);
}

public function savepopupcargo($id = NULL) {
//$post = $this->input->post();
    $cdate = date('Y-m-d H:i:s');
    $cargo_id = 0;
    $inner_id = $data = $inner = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $user_id = $this->session->userdata('user_id');

    $stackable = isset($post['popupstackable']) ? $this->db->escape_str($post['popupstackable']) : "0";
    $grounded = isset($post['popupgroundable']) ? $this->db->escape_str($post['popupgroundable']) : "0";
    $splittable = isset($post['popupsplittable']) ? $this->db->escape_str($post['popupsplittable']) : "0";
    $popuplength = isset($post['popuplength']) ? $this->db->escape_str($post['popuplength']) : "0";
    $popupwidth = isset($post['popupwidth']) ? $this->db->escape_str($post['popupwidth']) : "0";
    $popupheight = isset($post['popupheight']) ? $this->db->escape_str($post['popupheight']) : "0";
    $popupweight = isset($post['popupweight']) ? $this->db->escape_str($post['popupweight']) : "0";
    $popupvolume = isset($post['popupvolume']) ? $this->db->escape_str($post['popupvolume']) : "0";
    $popupdg_goods = isset($post['popupdg_goods']) ? $this->db->escape_str($post['popupdg_goods']) : "0";
    $popupldm = isset($post['popupldm']) ? $this->db->escape_str($post['popupldm']) : "0";
    $second_weight = isset($post['secondweight']) ? $this->db->escape_str($post['secondweight']) : "0";
    $second_volume = isset($post['secondvolume']) ? $this->db->escape_str($post['secondvolume']) : "0";
    $marks_numbers    = isset( $_POST['marks_numbers'] ) ? $this->db->escape_str($_POST['marks_numbers']) : "";
    $secondweight_uom = isset($post['secondpopupweight_uom']) ? $this->db->escape_str($post['secondpopupweight_uom']) : "";
    if ($secondweight_uom == "") {
        $secondweight_uom = "Kg";
    }
    $secondvolume_uom = isset($post['secondpopupvolume_uom']) ? $this->db->escape_str($post['secondpopupvolume_uom']) : "";
    if ($secondvolume_uom == "") {
        $secondvolume_uom = "cbm";
    }
    if ($popupldm == "" || !(is_numeric($popupldm))) {
        $popupldm = "0.00";
    }
    $popupvolumetric_weight = isset($post['popupvolumetric_weight']) ? $this->db->escape_str($post['popupvolumetric_weight']) : "0";
    if ($popuplength == "") {
        $popuplength = '0.00';
    }
    if ($popupwidth == "") {
        $popupwidth = '0.00';
    }
    if ($popupheight == "") {
        $popupheight = '0.00';
    }
    if ($popupweight == "") {
        $popupweight = '0.00';
    }
    if ($popupvolume == "") {
        $popupvolume = '0.00';
    }
    if ($popupvolumetric_weight == "") {
        $popupvolumetric_weight = '0.00';
    }
    if ($second_weight == "") {
        $second_weight = '0.00';
    }
    if ($second_volume == "") {
        $second_volume = '0.00';
    }

    $cargo = array(
        'cargo_type' => $this->db->escape_str($post['popupcargo_type']),
        'goods_description' => $this->db->escape_str($post['popupgoods_desc']),
        'quantity' => $this->db->escape_str($post['popupquantity']),
        'length' => $popuplength,
        'length_unit' => $this->db->escape_str($post['popuplength_uom']),
        'width' => $popupwidth,
        'width_unit' => $this->db->escape_str($post['popupwidth_uom']),
        'height' => $popupheight,
        'height_unit' => $this->db->escape_str($post['popupheight_uom']),
        'weight' => $popupweight,
        'weight_unit' => $this->db->escape_str($post['popupweight_uom']),
        'volume' => $popupvolume,
        'volume_unit' => $this->db->escape_str($post['popupvolume_uom']),
        'volumetric_weight' => $popupvolumetric_weight,
        'volweight_uom' => $this->db->escape_str($post['popupvow_uom']),
        'stackable' => $stackable,
        'grounded' => $grounded,
        'splittable' => $splittable,
        'createdby' => $user_id,
        'createdon' => $cdate,
        'dg_goods' => $popupdg_goods,
        'ldm' => $popupldm,
        'second_weight' => $second_weight,
        'second_volume' => $second_volume,
        'secondweight_uom' => $secondweight_uom,
        'marks_numbers'  => $marks_numbers,
        'secondvolume_uom' => $secondvolume_uom
    );
    if ($id == NULL) {
        $ins = $this->db->insert("tb_cargo_details", $cargo);
        $cargo_id = $this->db->insert_id();

        $data = array(
            'cargo_id' => $cargo_id
        );
    } else {
        $cargo_id = $id;
        $upd = $this->db->where(array(
            'id' => $cargo_id
        ))->update("tb_cargo_details", $cargo);
        $data = array(
            'cargo_id' => $cargo_id
        );
    }
    if ($popupdg_goods > 0) {
        $dgRowIds = $post['dgRowIds'] ?? [];
        foreach ($dgRowIds as $eachRowId) {
            if ($eachRowId > 0) {
                $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $cargo_id, 'order_id' => '0'], ['id' => $eachRowId]);
            }
        }
    }
    echo json_encode($data);
}

public function editcargodetails()
{
    $id = $this->db->escape_str($this->input->post('id'));
    $cargo = $inner = array();
    if ($id != "") {
        $get_cargo = $this->db->query("SELECT * FROM tb_cargo_details WHERE id='" . $id . "' GROUP BY id");
        if ($get_cargo->num_rows() > 0) {
            $get_inner = $this->db->query("SELECT * FROM tb_inner_cargo WHERE cargo_id='" . $id . "' AND status='1' GROUP BY id");
            if ($get_inner->num_rows() > 0) {
                foreach ($get_inner->result() as $res) {
                    $inner[] = array(
                        'inner_id' => $res->id,
                        'inner_cargo_type' => $res->cargo_type,
                        'inner_goods_description' => $res->goods_description,
                        'inner_quantity' => $res->quantity,
                        'inner_length' => $res->length,
                        'inner_length_uom' => $res->length_unit,
                        'inner_width' => $res->width,
                        'inner_width_uom' => $res->width_unit,
                        'inner_height' => $res->height,
                        'inner_height_uom' => $res->height_unit,
                        'inner_weight' => $res->weight,
                        'inner_weight_uom' => $res->weight_unit,
                        'inner_volume' => $res->volume,
                        'inner_volume_uom' => $res->volume_unit,
                        'inner_stackable' => $res->stackable
                    );
                }
            }
            $cargo = array(
                'id' => $get_cargo->row()->id,
                'cargo_type' => $get_cargo->row()->cargo_type,
                'goods_description' => $get_cargo->row()->goods_description,
                'marks_numbers' => $get_cargo->row()->marks_numbers,
                'quantity' => $get_cargo->row()->quantity,
                'length' => $get_cargo->row()->length,
                'length_uom' => $get_cargo->row()->length_unit,
                'width' => $get_cargo->row()->width,
                'width_uom' => $get_cargo->row()->width_unit,
                'height' => $get_cargo->row()->height,
                'height_uom' => $get_cargo->row()->height_unit,
                'weight' => $get_cargo->row()->weight,
                'weight_uom' => $get_cargo->row()->weight_unit,
                'volume' => $get_cargo->row()->volume,
                'volume_uom' => $get_cargo->row()->volume_unit,
                'volumetric_weight' => $get_cargo->row()->volumetric_weight,
                'volweight_uom' => $get_cargo->row()->volweight_uom,
                'stackable' => $get_cargo->row()->stackable,
                'grounded' => $get_cargo->row()->grounded,
                'splittable' => $get_cargo->row()->splittable,
                'dg_goods' => $get_cargo->row()->dg_goods,
                'ldm' => $get_cargo->row()->ldm,
                'second_weight' => $get_cargo->row()->second_weight,
                'second_volume' => $get_cargo->row()->second_volume,
                'secondvolume_uom' => $get_cargo->row()->secondvolume_uom,
                'secondweight_uom' => $get_cargo->row()->secondweight_uom,
                'inner' => $inner
            );
        }
    }
    echo json_encode($cargo);
}

public function deleteinnercargopackage() {
    $post = array();
    $post = $this->input->post(NULL,TRUE);
    $inner_id = isset($post['inner_id']) ? $this->db->escape_str($post['inner_id']) : '0';
    $cargo_id = 0;
    if ($inner_id != 0) {
        $chk = $this->db->select('id,cargo_id')->get_where('tb_inner_cargo', array(
            'id' => $inner_id
        ));
        if ($chk->num_rows() > 0) {
            $cargo_id = $chk->row()->cargo_id;
            $upd = $this->db->where(array(
                'id' => $inner_id
            ))->update('tb_inner_cargo', array(
                'status' => '0'
            ));
        }
    }
    echo json_encode($cargo_id);
}

public function insertorder() {
    $cdate = date('Y-m-d H:i:s');
    $user_id = $this->session->userdata('user_id');
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $company_code = isset($post['company_code']) ? $this->db->escape_str($post['company_code']) : "";
    $branch_code = isset($post['branch_code']) ? $this->db->escape_str($post['branch_code']) : "";
    $department_code = isset($post['department_code']) ? $this->db->escape_str($post['department_code']) : "";
    $product = isset($post['product']) ? $this->db->escape_str($post['product']) : "";
    $service = isset($post['service']) ? $this->db->escape_str($post['service']) : "";
    $order_shipper_id = isset($post['order_shipper_id']) ? $this->db->escape_str($post['order_shipper_id']) : "";
    $order_consignee_id = isset($post['order_consignee_id']) ? $this->db->escape_str($post['order_consignee_id']) : "";
    if($order_shipper_id == ""){ $order_shipper_id = 0;}
    if($order_consignee_id == ""){ $order_consignee_id = 0;}
    $order_type_flag = isset($post['order_type_flag']) ? $this->db->escape_str($post['order_type_flag']) : "";
/*
* $order_status = isset($_POST['order_status']) ? $_POST['order_status'] : "";
* if ($order_status == "") {
* $order_status = "OPEN";
* }
*/
$delivery_terms = isset($post['delivery_terms']) ? $this->db->escape_str($post['delivery_terms']) : "";
$incoterm = isset($post['incoterm']) ? $this->db->escape_str($post['incoterm']) : "";
$shipment_id = isset($post['delivery_note']) ? $this->db->escape_str($post['delivery_note']) : "";
$container_no = isset($post['container_num']) ? $this->db->escape_str($post['container_num']) : "";
$porder = isset($post['purchase_order']) ? $this->db->escape_str($post['purchase_order']) : "";
$notify_party = isset($post['notify_party']) ? $this->db->escape_str($post['notify_party']) : "";
$currency = isset($post['currency']) ? $this->db->escape_str($post['currency']) : "";

$goods_value = isset($post['goods_value']) ? $this->db->escape_str($post['goods_value']) : "0.00";
if ($goods_value == "") {
    $goods_value = 0.00;
}
$party_row_id = isset($post['order_party_row_id']) ? $this->db->escape_str($post['order_party_row_id']) : "0";
$order_inv_row_id = isset($post['order_inv_row_id']) ? $this->db->escape_str($post['order_inv_row_id']) : '0';
$order_cargo_id = isset($post['order_cargo_id']) ? $this->db->escape_str($post['order_cargo_id']) : "";
$pickup = isset($post['order_pickup_id']) ? $this->db->escape_str($post['order_pickup_id']) : "0";
$delivery = isset($post['order_delivery_id']) ? $this->db->escape_str($post['order_delivery_id']) : "";
if($delivery == ""){ $delivery = 0;}
$early_pickup = isset($post['early_pickup']) ? $this->db->escape_str($post['early_pickup']) : "";
$late_pickup = isset($post['late_pickup']) ? $this->db->escape_str($post['late_pickup']) : "";
$early_delivery = isset($post['early_delivery']) ? $this->db->escape_str($post['early_delivery']) : "";
$late_delivery = isset($post['late_delivery']) ? $this->db->escape_str($post['late_delivery']) : "";
$modeof_trasnport = isset($post['modeof_trasnport']) ? $this->db->escape_str($post['modeof_trasnport']) : "LTL";
$order_type = isset($post['order_type']) ? $this->db->escape_str($post['order_type']) : "";
$rev_row_id = isset($post['rev_row_id']) ? $this->db->escape_str($post['rev_row_id']) : "";
$ordcost_row_id = isset($post['ordcost_row_id']) ? $this->db->escape_str($post['ordcost_row_id']) : "";
$customer_code = isset($post['customer_id']) ? $this->db->escape_str($post['customer_id']) : "";
$driver_pickup_instructions = isset($post['driver_pickup_instructions']) ? $this->db->escape_str($post['driver_pickup_instructions']) : "";
$driver_delivery_instructions = isset($post['driver_delivery_instructions']) ? $this->db->escape_str($post['driver_delivery_instructions']) : "";
$docs_sent_datetime = isset($post['docs_sent_datetime']) ? $this->db->escape_str($post['docs_sent_datetime']) : "";
$docs_received_datetime = isset($post['docs_received_datetime']) ? $this->db->escape_str($post['docs_received_datetime']) : "";
$e_pickup = date('Y-m-d H:i:s');
if ($early_pickup != "") {
    $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
}
if ($late_pickup != "") {
    $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
} else {
    $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
}
$e_delivery = date('Y-m-d H:i:s');
if ($early_delivery != "") {
    $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
}
if ($late_delivery != "") {
    $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
} else {
    $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
}
$same_porder = "0";

if($order_shipper_id =='' || $order_shipper_id == NULL){
    $order_shipper_id = $pickup;
}else{
    $order_shipper_id = $order_shipper_id;
}
if($order_consignee_id =='' || $order_consignee_id == NULL){
    $order_consignee_id = $delivery;
}else{
    $order_consignee_id = $order_consignee_id;
}
/*
* if ( $porder != "" ) {
* $chkporder = $this->db->query( "SELECT id FROM tb_order_details WHERE purchase_order='" . $porder . "' AND status='1'" );
* if ( $chkporder->num_rows() > 0 ) {
* $same_porder = "1";
* }
* }
*/
if ($same_porder == 1) {
    $this->session->set_flashdata('error_msg', 'Purchase Order "' . $porder . '" already exists with One ORDER');
    redirect("orders");
    /* return FALSE; */
} else {
    $drop_id = $pickup_custid = 0;
    $pickup_name = $pickup_country = $pickup_street = $pickup_pincode = $pickup_city = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $pickup_address = $pickup_state = $drop_address = $drop_state = "";
    $getdrop_custid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode,code FROM tbl_party_master WHERE id='" . $delivery . "'");
    if ($getdrop_custid->num_rows() > 0) {
        $drop_id = $getdrop_custid->row()->code;
        $drop_name = $getdrop_custid->row()->name;
        $drop_state = $getdrop_custid->row()->state;
        $drop_address = $getdrop_custid->row()->address;
        $drop_country = $getdrop_custid->row()->country;
        $drop_street = $getdrop_custid->row()->street;
        $drop_pincode = $getdrop_custid->row()->pincode;
        $drop_city = $getdrop_custid->row()->city;
    }

    $getshippercustid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode,code FROM tbl_party_master WHERE id='" . $pickup . "'");
    if ($getshippercustid->num_rows() > 0) {
        $pickup_custid = $getshippercustid->row()->code;
        $pickup_name = $getshippercustid->row()->name;
        $pickup_state = $getshippercustid->row()->state;
        $pickup_address = $getshippercustid->row()->address;
        $pickup_country = $getshippercustid->row()->country;
        $pickup_street = $getshippercustid->row()->street;
        $pickup_pincode = $getshippercustid->row()->pincode;
        $pickup_city = $getshippercustid->row()->city;
    }
    $add1 = implode(",", [
        $pickup_street,
        $pickup_city,
        $pickup_country,
        $pickup_pincode
    ]);
    $add2 = implode(",", [
        $drop_street,
        $drop_city,
        $drop_country,
        $drop_pincode
    ]);
    $data = getlatlngsbyplace($add1);
    $lat1 = @$data[0];
    $lng1 = @$data[1];
    $data = [];
    $data = getlatlngsbyplace($add2);
    $lat2 = @$data[0];
    $lng2 = @$data[1];
    $ship_row_id = 0;
    $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
    $tid = $tname = "";
    $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
    if ($gettrasnportmode->num_rows() > 0) {
        $tid = $gettrasnportmode->row()->id;
        $tname = $gettrasnportmode->row()->name;
    }
    if ($shipment_id == "") {
        $shipment_id = "SVK" . time();
    }

    $ship_arr = array(
        'shipid' => $shipment_id,
        'txnid' => $shipment_id,
        'trucktype' => $tname,
        'pickupcnt' => '1',
        'dropcnt' => '1',
        'unitspec' => 1,
        'insertusr' => $pickup_custid,
        'carrier' => '0',
        'insertuserdate' => $cdate,
        'enddate' => $enddate,
        'insdate' => $cdate,
        'upddate' => $cdate,
        'reason' => 'SHIPMENT',
        'purpose' => 'SEND INTEGRATION',
        'ship_object' => 'SHIPMENT',
        'logdate' => $cdate,
        'transport_mode' => $modeof_trasnport,
        'domainname' => $branch_code,
        'company_code' => $company_code,
        'branch_code' => $branch_code,
        'product' => $product,
        'freight_term' => '60',
        'freight_termname' => 'Free of Charge',
        'incoterm' => $incoterm,
        'modeoftransport' => $tid
    );
    $chkshipmentid = addslashes($shipment_id);
    $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $chkshipmentid . "'");
    if ($chk_shipid->num_rows() > 0) {
        $ship_row_id = $chk_shipid->row()->id;
        $this->db->where(array(
            'id' => $ship_row_id
        ))->update("tb_shipments", $ship_arr);
    } else {
        $ship_arr['createdon'] = $cdate;
        $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
        $ship_row_id = $this->db->insert_id();
    }
    $customer_id = 0;
    $cust_id = $this->session->userdata('cust_id');
    if ($pickup == "") {
        $pickup = 0;
    }

        if ($customer_code != "" && $customer_code != "0") {
            $getcustomerid = $this->db->select("id")->get_where("tb_customers", array(
                'code' => $customer_code,
                'status' => '1'
            ));
            if ($getcustomerid->num_rows() > 0) {
                $customer_id = $getcustomerid->row()->id;
            }
        }

    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
    $logdate = $getactual['datetime'];
    $getpickup = getdatetimebytimezone(DFLT_TZ, $e_pickup, $curtz);
    $e_pickup = $getpickup['datetime'];
    $getlpickup = getdatetimebytimezone(DFLT_TZ, $l_pickup, $curtz);
    $l_pickup = $getlpickup['datetime'];
    $getdelivery = getdatetimebytimezone(DFLT_TZ, $e_delivery, $curtz);
    $e_delivery = $getdelivery['datetime'];
    $getldelivery = getdatetimebytimezone(DFLT_TZ, $l_delivery, $curtz);
    $l_delivery = $getldelivery['datetime'];
    $childid = 0;
    if ($this->session->userdata('childid')) {
        $childid = $this->session->userdata('childid');
    }
    $created_source = '4';
    if($branch_code == "INCL"){
        $created_source = '15';
        $ordtypechk = $this->common->gettblrowdata(array("id"=>$order_type),"ordtype_code","tb_order_types",0,0);
        if(count($ordtypechk)>0){
            if($ordtypechk['ordtype_code'] == "Return"){
                $created_source = '16';
            }
        }
    }
    $orderinfo = array(
        'shipment_id' => $ship_row_id,
        'customer_id' => $customer_id,
        'product' => $product,
        'pickup_datetime' => $e_pickup,
        'delivery_datetime' => $e_delivery,
        'pickup_endtime' => $l_pickup,
        'drop_endtime' => $l_delivery,
        'currency' => $currency,
        'goods_value' => $goods_value,
        'company_code' => $company_code,
        'branch_code' => $branch_code,
        'createdon' => $cdate,
        'drop_custid' => $drop_id,
        'drop_partyid' => $drop_id,
        'user_id' => $user_id,
        'sub_uid' => $childid,
        'pickup_custid' => $pickup_custid,
        'pickup_partyid' => $pickup_custid,
        'pickup_country' => $pickup_country,
        'pickup_city' => $pickup_city,
        'pickup_pincode' => $pickup_pincode,
        'pickup_company' => $pickup_name,
        'pickup_address1' => $pickup_street,
        'pickup_address2' => $pickup_state,
        'delivery_country' => $drop_country,
        'delivery_city' => $drop_city,
        'delivery_pincode' => $drop_pincode,
        'delivery_company' => $drop_name,
        'delivery_address1' => $drop_street,
        'delivery_address2' => $drop_state,
        'is_created' => '1',
        'plat' => $lat1,
        'plng' => $lng1,
        'dlat' => $lat2,
        'dlng' => $lng2,
        'transport_mode' => $modeof_trasnport,
        'created_source' => $created_source,
        'createdon' => $logdate,
        'shipper_id' => $order_shipper_id,
        'consignee_id' => $order_consignee_id
    );
    $ins_order = $this->db->insert("tb_orders", $orderinfo);
    $order_id = $this->db->insert_id();
    $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", array(
        'id' => $user_id
    ));
    $country_code = $get_country->row()->country_code;
    $company_code = $get_country->row()->company_code;
    $genord = array(
        "user_id" => $user_id,
        "order_id" => $order_id,
        "country_code" => $country_code,
        "company_code" => $company_code
    );
    $booking_id = generatebookingid($genord);
    $invtypes = makeorderinvolvedpartiestype($customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
    $upd = $this->db->where(array(
        'id' => $order_id
    ))->update("tb_orders", array(
        'order_id' => $booking_id
    ));
    if ($docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00") {
        $getdocsent = getdatetimebytimezone(DFLT_TZ, $docs_sent_datetime, $curtz);
        $docs_sent_datetime = $getdocsent['datetime'];
    }
    if ($docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00") {
        $getdocrec = getdatetimebytimezone(DFLT_TZ, $docs_received_datetime, $curtz);
        $docs_received_datetime = $getdocrec['datetime'];
    }
    $details = array(
        'service' => $service,
        'delivery_term' => $delivery_terms,
        'incoterm' => $incoterm,
        /* 'purchase_order'         => $porder, */
        'notify_party' => $notify_party,
        'department_code' => $department_code,
        'temperature_control' => '0',
        'valorance_insurance' => '0',
        'high_cargo_value' => '0',
        'customs_required' => '0',
        'order_row_id' => $order_id,
        'order_id' => $booking_id,
        'createdon' => $cdate,
        'shipper_id' => $order_shipper_id,
        'order_type' => $order_type,
        'docs_received_datetime' => $docs_received_datetime,
        'docs_sent_datetime' => $docs_sent_datetime
    );
    $this->db->insert("tb_order_details", $details);
    $shipper_address = array(
        'order_id' => $order_id,
        'party_master_id' => $order_shipper_id,
        'location_id' => $pickup_city,
        'street' => $pickup_street,
        'state' => $pickup_state,
        'address' => $pickup_address,
        'pincode' => $pickup_pincode,
        'country' => $pickup_country,
        'user_id' => $user_id
    );
    $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
        'order_id' => $order_id,
        'party_master_id' => $order_shipper_id,
        'status' => '1'
    ));
    if ($chk_shipperaddress->num_rows() > 0) {
        $shipperadd_id = $chk_shipperaddress->row()->id;
        $upd_add = $this->db->where(array(
            'id' => $shipperadd_id
        ))->update("tbl_orderparty_address", $shipper_address);
    } else {
        $shipper_address['createdon'] = $cdate;
        $this->db->insert("tbl_orderparty_address", $shipper_address);
        $shipperadd_id = $this->db->insert_id();
    }
    $delivery_address = array(
        'order_id' => $order_id,
        'party_master_id' => $delivery,
        'location_id' => $drop_city,
        'street' => $drop_street,
        'state' => $drop_state,
        'address' => $drop_address,
        'pincode' => $drop_pincode,
        'country' => $drop_country,
        'user_id' => $user_id
    );
    $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
        'order_id' => $order_id,
        'party_master_id' => $delivery,
        'status' => '1'
    ));
    if ($chk_deliveryaddress->num_rows() > 0) {
        $dropadd_id = $chk_deliveryaddress->row()->id;
        $upd_add = $this->db->where(array(
            'id' => $dropadd_id
        ))->update("tbl_orderparty_address", $delivery_address);
    } else {
        $delivery_address['createdon'] = $cdate;
        $this->db->insert("tbl_orderparty_address", $delivery_address);
        $dropadd_id = $this->db->insert_id();
    }
    $length = $width = $height = $weight = $volume = $ldm = $volumetric_weight = 0;
    $quantity = 1;
    $cargo_forship = array();
    if ($order_cargo_id != "") {
        $cargo_ids = array();
        $cargo_ids = explode(',', $order_cargo_id);
        if(!empty($cargo_ids)){
            $cargo_ids = array_unique($cargo_ids);
        }
        for ($i = 0; $i < count($cargo_ids); $i++) {
            $length = $width = $height = $weight = $volume = $ldm = $volumetric_weight = $second_volume = $second_weight = 0;
            $quantity = 1;
            $getcargo_details = $this->db->query("SELECT cargo_type,length,width,height,weight,volumetric_weight,ldm,volume,second_weight,second_volume,quantity,goods_description,marks_numbers FROM tb_cargo_details WHERE id='" . $cargo_ids[$i] . "'");
            $cargo_type = $description = "";
            if ($getcargo_details->num_rows() > 0) {
                $length = $getcargo_details->row()->length;
                $width = $getcargo_details->row()->width;
                $height = $getcargo_details->row()->height;
                $weight = $getcargo_details->row()->weight;
                $volume = $getcargo_details->row()->volume;
                $quantity = $getcargo_details->row()->quantity;
                $cargo_type = $getcargo_details->row()->cargo_type;
                $description = $getcargo_details->row()->goods_description;
                $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                $ldm = $getcargo_details->row()->ldm;
                $second_weight = $getcargo_details->row()->second_weight;
                $second_volume = $getcargo_details->row()->second_volume;
                $marks_numbers       = $getcargo_details->row()->marks_numbers;
                $cargo_forship[$i] = $getcargo_details->row()->cargo_type;
            }
            $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargo_type . "'");
            $handling_unit = "";
            if ($gethandling_unit->num_rows() > 0) {
                $handling_unit = $gethandling_unit->row()->id;
            } else {
                $handlingunit_ar = array(
                    'unit_name' => $cargo_type,
                    'description' => $cargo_type,
                    'user_id' => $user_id,
                    'created_at' => $cdate,
                    'status' => '1'
                );
                $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                $handling_unit = $this->db->insert_id();
            }
            $cargo = array(
                'order_id' => $order_id,
                'cargo_id' => $cargo_ids[$i],
                'status' => '1',
                'length' => $length,
                'width' => $width,
                'height' => $height,
                'weight' => $weight,
                'volumetric_weight' => $volumetric_weight,
                'volweight_uom' => 'kg',
                'volume' => $volume,
                'quantity' => $quantity,
                'cargo_content' => $description,
                'quantity_type' => $cargo_type,
                'handling_unit' => $handling_unit,
                'ldm' => $ldm,
                'second_volume' => $second_volume,
                'marks_numbers'     => $marks_numbers,
                'second_weight' => $second_weight
            );
            $orderCargoId = $this->common->insertTableData("tb_order_cargodetails", $cargo);
            $checkDgGoods = $this->common->gettbldata(['order_cargo_id' => $cargo_ids[$i], 'status' => '1'], "id", "tb_order_dg_goods", 0, 0);
            foreach ($checkDgGoods as $eachLine) {
                $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $orderCargoId, 'order_id' => $order_id], ['id' => $eachLine['id']]);
            }
        }
    }
    $unitspec = "1";
    if (!empty($cargo_forship)) {
        $unitspec = implode(',', $cargo_forship);
    }
    $updship = $this->db->where(array(
        'id' => $ship_row_id
    ))->update("tb_shipments", array(
        'unitspec' => $unitspec,
        'txncode' => $booking_id
    ));
    $total_weight = $total_volume = $total_quantity = 0;
    $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "' AND status='1'");
    if ($gettotal->num_rows() > 0) {
        $total_volume = $gettotal->row()->total_volume;
        $total_weight = $gettotal->row()->total_weight;
        $total_quantity = $gettotal->row()->total_quantity;
    }
    $upd_order = $this->db->where(array(
        'id' => $order_id
    ))->update("tb_orders", array(
        'volume' => $total_volume,
        'weight' => $total_weight,
        'quantity' => $total_quantity
    ));
    $ids = array();
    if ($shipment_id != "") {
        $ins_ref = array(
            'order_id' => $order_id,
            'reference_id' => 'DQ',
            'ref_value' => $shipment_id,
            'createdon' => $cdate
        );
        $ins = $this->db->insert('tb_order_references', $ins_ref);
    }
    if ($company_code == 'UKKN' || $company_code == 'AUKN') {
        if ($container_no != "") {
            $ins_ref = array(
                'order_id' => $order_id,
                'reference_id' => 'CTR',
                'ref_value' => $container_no,
                'createdon' => $cdate
            );
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
    }
    if ($porder != "") {
        $ins_ref = array(
            'order_id' => $order_id,
            'reference_id' => 'PO',
            'ref_value' => $porder,
            'createdon' => $cdate
        );
        $ins = $this->db->insert('tb_order_references', $ins_ref);
    }
    if ($driver_pickup_instructions != "") {
        $ins_ref = array(
            'order_id' => $order_id,
            'reference_id' => 'ORD_PIKINST',
            'ref_value' => $driver_pickup_instructions,
            'createdon' => $cdate
        );
        $ins = $this->db->insert('tb_order_references', $ins_ref);
    }
    if ($driver_delivery_instructions != "") {
        $ins_ref = array(
            'order_id' => $order_id,
            'reference_id' => 'ORD_DLVINST',
            'ref_value' => $driver_delivery_instructions,
            'createdon' => $cdate
        );
        $ins = $this->db->insert('tb_order_references', $ins_ref);
    }
    // if ($party_row_id != "0") {
    //     $ids = explode(',', $party_row_id);
    // }
    // $inv_ids = array();
    // if ($order_inv_row_id != 0 || $order_inv_row_id != "") {
    //     $inv_ids = explode(',', $order_inv_row_id);
    //     /* array_push($ids, $order_inv_row_id); */
    // }
    // if (!empty($inv_ids)) {
    //     foreach ($inv_ids as $inv) {
    //         array_push($ids, $inv);
    //     }
    // }
    // if (!empty($ids)) {
    //     for ($i = 0; $i < count($ids); $i++) {
    //         if ($ids[$i] != "") {
    //             $getpartytype = $this->db->query("SELECT party_type_id FROM tbl_party_master WHERE id='" . $ids[$i] . "'");
    //             $party_type = 1;
    //             if ($getpartytype->num_rows() > 0) {
    //                 $party_type = $getpartytype->row()->party_type_id;
    //             }
    //             $party = array(
    //                 'order_id' => $order_id,
    //                 'party_id' => $ids[$i],
    //                 'status' => '1',
    //                 'createdon' => $cdate,
    //                 'status' => '1',
    //                 'party_type' => $party_type,
    //                 'order_number' => $booking_id
    //             );
    //             $chk = $this->db->select("id")->get_where("tb_order_parties", array(
    //                 'order_id' => $order_id,
    //                 'party_id' => $ids[$i],
    //                 'status' => '1',
    //                 'party_type' => $party_type
    //             ));
    //             if ($chk->num_rows() == 0) {
    //                 $ins_party = $this->db->insert("tb_order_parties", $party);
    //             }
    //         }
    //     }
    // }


        $sub_cut_parties = array();
        $sub_cut_parties['0'] = $order_shipper_id;
        $sub_cut_parties['1'] = $order_consignee_id;
        $sub_cut_parties['2'] = $pickup;
        $sub_cut_parties['3'] = $delivery;
        if (!empty($sub_cut_parties)) {
            subcustpartiesinsert($order_id, $booking_id, $sub_cut_parties);
        }
    $rev_ids = array();
    if ($rev_row_id != "" && $rev_row_id != "0") {
        $rev_ids = explode(',', $rev_row_id);
        if ($ordcost_row_id != "") {
            $cost_ids = array();
            $cost_ids = explode(',', $ordcost_row_id);
            foreach ($cost_ids as $ids) {
                array_push($rev_ids, $ids);
            }
        }
        if (!empty($rev_ids)) {
            $upd = $this->db->query("UPDATE tb_reveneus set order_id ='" . $order_id . "' WHERE id IN (" . implode(',', $rev_ids) . ")");
        }
    }
    $shipment_name = "BOXES";
    $total_weight = $total_volume = $total_quantity = 0;
    $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
    if ($gettotal->num_rows() > 0) {
        $total_volume = $gettotal->row()->total_volume;
        $total_weight = $gettotal->row()->total_weight;
        $total_quantity = $gettotal->row()->total_quantity;
    }
    $getcust_details = $this->common->gettblrowdata(array(
        'id' => $customer_id
    ), "name,phone,email_id", 'tb_customers', 0, 0);
    if (!empty($getcust_details)) {
        $customer_email = $getcust_details['email_id'];
        $customer_phone = $getcust_details['phone'];
    }
    /* if($this->session->userdata('usr_tzone')['country'] == "RU"){ */
        if ($order_id != "" && $customer_id != "") {
            $pickupinfo['country'] = trim($pickup_country);
            $pickupinfo['order_country'] = trim($pickup_country);
            $pickupinfo['order_city'] = trim($pickup_city);
            $pickupinfo['order_zipcode'] = trim($pickup_pincode);
            $pickupinfo['state'] = trim($pickup_state);
            $pickupinfo['city'] = trim($pickup_city);
            $pickupinfo['region'] = trim($pickup_street);
            $pickupinfo['zipcode'] = trim($pickup_pincode);

            $pickupinfo['stoptype'] = "P";
            $dropinfo['country'] = trim($drop_country);
            $dropinfo['order_country'] = trim($drop_country);
            $dropinfo['order_city'] = trim($drop_city);
            $dropinfo['order_zipcode'] = trim($drop_pincode);
            $dropinfo['state'] = trim($drop_state);
            $dropinfo['city'] = trim($drop_city);
            $dropinfo['region'] = trim($drop_street);
            $dropinfo['zipcode'] = trim($drop_pincode);
            $dropinfo['stoptype'] = "D";
               //--------------------------------
               $pickupinfo['cargo'] = $cargo; //for auto route
               //--------------------------------
            $pickupgeocode = checkgeocode($pickupinfo);
            $dropgeocode = checkgeocode($dropinfo);
            if (!empty($pickupgeocode) && !empty($dropgeocode)) {
                $pickupgeocode['stoptype'] = "P";
                $dropgeocode['stoptype'] = "D";
                $pickupgeocode['order_country'] = trim($pickup_country);
                $pickupgeocode['order_city'] = trim($pickup_city);
                $pickupgeocode['order_zipcode'] = trim($pickup_pincode);
                $dropgeocode['order_country'] = trim($drop_country);
                $dropgeocode['order_city'] = trim($drop_city);
                $dropgeocode['order_zipcode'] = trim($drop_pincode);
                //-------------------------------- //for auto route
                $pickupgeocode['cargo'] = $cargo;
                $dropgeocode['cargo'] =  $cargo;
                //--------------------------------
                $pickuproute = getcust_routeautomate($customer_id, $pickupgeocode);
                $droproute = getcust_routeautomate($customer_id, $dropgeocode);
                if (!empty($pickuproute) && !empty($droproute)) {
                    $orderinfo['id'] = $order_id;
                    $orderinfo['order_id'] = $booking_id;
                    $orderinfo['shipment_name'] = $shipment_name;
                    $orderinfo['customer_phone'] = $customer_phone;
                    $orderinfo['customer_email'] = $customer_email;
                    $orderinfo['volume'] = $total_volume;
                    $orderinfo['weight'] = $total_weight;
                    $orderinfo['quantity'] = $total_quantity;
                    $orderinfo['quantity'] = $total_quantity;
                    $shipment = createshipmentbyorder($pickuproute, $orderinfo);
                } else {

                     //-------------------------------- //for auto route
                     $pickupinfo['cargo'] = $cargo;
                     $dropinfo['cargo'] =  $cargo;
                     //--------------------------------

                    $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                    $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                    if (!empty($pickuproute1) && !empty($droproute1)) {
                        $orderinfo['id'] = $order_id;
                        $orderinfo['order_id'] = $booking_id;
                        $orderinfo['shipment_name'] = $shipment_name;
                        $orderinfo['customer_phone'] = $customer_phone;
                        $orderinfo['customer_email'] = $customer_email;
                        $orderinfo['volume'] = $total_volume;
                        $orderinfo['weight'] = $total_weight;
                        $orderinfo['quantity'] = $total_quantity;
                        $orderinfo['quantity'] = $total_quantity;
                        $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                    }
                }
            } else {
                //--------------------------------//for auto route
                $pickupinfo['cargo'] = $cargo;
                $dropinfo['cargo'] =  $cargo;
                //--------------------------------
                $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                if (!empty($pickuproute1) && !empty($droproute1)) {
                    $orderinfo['id'] = $order_id;
                    $orderinfo['order_id'] = $booking_id;
                    $orderinfo['shipment_name'] = $shipment_name;
                    $orderinfo['customer_phone'] = $customer_phone;
                    $orderinfo['customer_email'] = $customer_email;
                    $orderinfo['volume'] = $total_volume;
                    $orderinfo['weight'] = $total_weight;
                    $orderinfo['quantity'] = $total_quantity;
                    $orderinfo['quantity'] = $total_quantity;
                    $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                }
            }
            $checkTripForOrder = $this->common->gettblrowdata("id='" . $order_id . "' AND shift_id >0", "id,shift_id", "tb_orders", 0, 0);
            if (!empty($checkTripForOrder)) {
                $this->load->library('notifytrigger');
                $this->notifytrigger->sendNotificationToCarrier($checkTripForOrder['shift_id'], $company_code, 'CR');
            }
        }
        /* } */
        $pref_arr = array(
            'pickup' => strtoupper($pickup_country),
            'pickup_state' => strtoupper($pickup_state),
            'pickup_city' => strtoupper($pickup_city),
            'pickup_pincode' => $pickup_pincode,
            'drop' => strtoupper($drop_country),
            'drop_state' => strtoupper($drop_state),
            'drop_city' => strtoupper($drop_city),
            'drop_pincode' => $drop_pincode,
            'customer_id' => $customer_code,
            'service' => $service,
            'product' => $product,
            'user_id' => $user_id,
            'company_code' => $company_code,
            'order_type' => $order_type,
            'order_id' => $order_id,
            'customer_row_id' => $customer_id
        );

        /* if($company_code == 'PLKN'){ */
            $this->ratemanagement->addrecodfororderinsertion($pref_arr);
            /* } */
            $this->ordernotify('booking_create', $order_id);
            if ($order_id != "" && $order_id != '0') {
                try {
                    $this->altovaordercreation->sendOrderToAltova($order_id);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order to Altova ".$ex->getMessage());
                }
                $this->session->set_flashdata('success_msg', 'Order Created Successfully - ' . $booking_id);
                redirect('smtcorders/orderslist/' . $order_id);
            } else {
                redirect("orders");
            }
        }
    }

    public function savequickbook() {
        $cdate = date('Y-m-d H:i:s');
        $user_id = $this->session->userdata('user_id');
        $cust_id = $this->session->userdata('cust_id');
        $post = array();
        $cargo = array();
        $post = $this->input->post(NULL,TRUE);
        $company_code = isset($post['popupcompany_code']) ? $this->db->escape_str($post['popupcompany_code']) : "";
        $branch_code = isset($post['popupbranch_code']) ? $this->db->escape_str($post['popupbranch_code']) : "";
        $department_code = isset($post['popupdepartment_code']) ? $this->db->escape_str($post['popupdepartment_code']) : "";
        $product = isset($post['productpopup']) ? $this->db->escape_str($post['productpopup']) : "";
        $service = isset($post['servicepopup']) ? $this->db->escape_str($post['servicepopup']) : "";
        $delivery_terms = isset($post['popupdelivery_terms']) ? $this->db->escape_str($post['popupdelivery_terms']) : "";
        $incoterm = isset($post['incoterm_popup']) ? $this->db->escape_str($post['incoterm_popup']) : "";
        $shipment_id = isset($post['popupdelivery_note']) ? $this->db->escape_str($post['popupdelivery_note']) : "";
        $porder = isset($post['purchaseorder_popup']) ? $this->db->escape_str($post['purchaseorder_popup']) : "";
        $notify_party = isset($post['popupnotifyparty']) ? $this->db->escape_str($post['popupnotifyparty']) : "";
        $popuppickup = isset($post['popuppickup']) ? $this->db->escape_str($post['popuppickup']) : "";
        $popupdelivery = isset($post['popupdelivery']) ? $this->db->escape_str($post['popupdelivery']) : "";
        $customer_phone = isset($post['popupshipper_phone']) ? $this->db->escape_str($post['popupshipper_phone']) : "";
        $customer_email = isset($post['popupshipper_email']) ? $this->db->escape_str($post['popupshipper_email']) : "";
        $popupcustomer_id = isset($post['popupcustomer_id']) ? $this->db->escape_str($post['popupcustomer_id']) : "";
        $driverdelivery_popup = isset($post['driverdelivery_popup']) ? $this->db->escape_str($post['driverdelivery_popup']) : "";
        $driverpickup_popup = isset($post['driverpickup_popup']) ? $this->db->escape_str($post['driverpickup_popup']) : "";
        $popupshipper_id = isset($post['quickbookshipper_id']) ? $this->db->escape_str($post['quickbookshipper_id']) : "";
        $popupconsignee_id = isset($post['quickbookconsignee_id']) ? $this->db->escape_str($post['quickbookconsignee_id']) : "";

		$currency       = isset( $_POST['currency'] ) ? $this->db->escape_str($_POST['currency']) : "";
		$goods_value    = isset( $_POST['goods_value'] ) ? $this->db->escape_str($_POST['goods_value']) : "0.00";

        $earlyquickbook_delivery = $latequickbook_delivery = "";
        if ($popupdelivery != "") {
            $earlyquickbook_delivery = date('Y-m-d H:i:s', strtotime($popupdelivery));
            $latequickbook_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_delivery)));
        }
        $earlyquickbook_pickup = $latequickbook_pickup = "";
        if ($popuppickup != "") {
            $earlyquickbook_pickup = date('Y-m-d H:i:s', strtotime($popuppickup));
            $latequickbook_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($earlyquickbook_pickup)));
        }
        $popuporder_type = isset($post['popuporder_type']) ? $this->db->escape_str($post['popuporder_type']) : "";
        $popupmodeof_trasnport = isset($post['popupmodeof_trasnport']) ? $this->db->escape_str($post['popupmodeof_trasnport']) : "LTL";

        $reference_ids = isset($post['quickbookreference_ids']) ? $this->db->escape_str($post['quickbookreference_ids']) : "0";
        $quickbook_order_reference_ids = isset($post['quickbook_order_reference_ids']) ? $this->db->escape_str($post['quickbook_order_reference_ids']) : "0";
        $order_cargo_id = isset($post['quickbookorder_cargo_id']) ? $this->db->escape_str($post['quickbookorder_cargo_id']) : "";
        $inv_parties = array(
            $this->db->escape_str($post['quickbookshipper_id']),
            $this->db->escape_str($post['quickbookconsignee_id'])
        );
        $pickup = isset($post['quickbookpickup_id']) ? $this->db->escape_str($post['quickbookpickup_id']) : "0";
        if ($pickup == "") {
            $pickup = 0;
        }
        $delivery = $this->db->escape_str($post['quickbookdelivery_id']);
        $drop_id = $pickup_custid = 0;
        $pickup_name = $pickup_country = $pickup_street = $pickup_state = $drop_state = $pickup_pincode = $pickup_city = $drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = $customer_id = "";
        $getdrop_custid = $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city,code FROM tbl_party_master WHERE id='" . $delivery . "'");
        if ($getdrop_custid->num_rows() > 0) {
            $drop_id = $getdrop_custid->row()->code;
            $drop_name = $getdrop_custid->row()->name;
            $drop_country = $getdrop_custid->row()->country;
            $drop_state = $getdrop_custid->row()->state;
            $drop_street = $getdrop_custid->row()->street;
            $drop_pincode = $getdrop_custid->row()->pincode;
            $drop_city = $getdrop_custid->row()->city;
        }
        $getshippercustid = $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city,code FROM tbl_party_master WHERE id='" . $pickup. "'");
        if ($getshippercustid->num_rows() > 0) {
            $pickup_custid = $getshippercustid->row()->code;
            $pickup_name = $getshippercustid->row()->name;
            $pickup_country = $getshippercustid->row()->country;
            $pickup_state = $getshippercustid->row()->state;
            $pickup_street = $getshippercustid->row()->street;
            $pickup_pincode = $getshippercustid->row()->pincode;
            $pickup_city = $getshippercustid->row()->city;
        }
        $tname = "Full Truck Load";
        $tid = "FTL";
        $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid = 1;
        $tname = "";
        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $popupmodeof_trasnport . "'");
        if ($gettrasnportmode->num_rows() > 0) {
            $tid = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        if ($shipment_id == "") {
            $shipment_id = "SVK" . time();
        }
        $ship_row_id = 0;
        $ship_arr = array(
            'shipid' => $shipment_id,
            'txnid' => $shipment_id,
            'trucktype' => $tname,
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $pickup_custid,
            'carrier' => '0',
            'insertuserdate' => $cdate,
            'enddate' => $enddate,
            'insdate' => $cdate,
            'upddate' => $cdate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $cdate,
            'transport_mode' => $popupmodeof_trasnport,
            'domainname' => $branch_code,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'product' => $product,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'incoterm' => $incoterm,
            'modeoftransport' => $tid,
            'unitspec' => 1
        );
        $chkshipmentid = addslashes($shipment_id);
        $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $chkshipmentid . "'");

        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array(
                'id' => $ship_row_id
            ))->update("tb_shipments", $ship_arr);
        } else {

            $ship_arr['createdon'] = $cdate;
            $ship_ins = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id = $this->db->insert_id();
        }
        $add1 = implode(",", [
            $pickup_street,
            $pickup_city,
            $pickup_country,
            $pickup_pincode
        ]);
        $add2 = implode(",", [
            $drop_street,
            $drop_city,
            $drop_country,
            $drop_pincode
        ]);
        $data = getlatlngsbyplace($add1);
        $lat1 = @$data[0];
        $lng1 = @$data[1];
        $data = [];
        $data = getlatlngsbyplace($add2);
        $lat2 = @$data[0];
        $lng2 = @$data[1];

            if ($popupcustomer_id != "" && $popupcustomer_id != "0") {
                $getcustomerid = $this->db->select("id")->get_where("tb_customers", array(
                    'code' => $popupcustomer_id,
                    'status' => '1'
                ));
                if ($getcustomerid->num_rows() > 0) {
                    $customer_id = $getcustomerid->row()->id;
                }
            }

        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_pickup, $curtz);
        $earlyquickbook_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ, $latequickbook_pickup, $curtz);
        $latequickbook_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ, $earlyquickbook_delivery, $curtz);
        $earlyquickbook_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ, $latequickbook_delivery, $curtz);
        $latequickbook_delivery = $getldelivery['datetime'];
        $childid = 0;
        if ($this->session->userdata('childid')) {
            $childid = $this->session->userdata('childid');
        }
        $created_source = '3';
        $orderinfo = array(
            'goods_value' => '0.00',
            'shipment_id' => $ship_row_id,
            'customer_id' => $customer_id,
            'product' => $product,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'createdon' => $cdate,
            'pickup_datetime' => $earlyquickbook_pickup,
            'delivery_datetime' => $earlyquickbook_delivery,
            'pickup_endtime' => $latequickbook_pickup,
            'drop_endtime' => $latequickbook_delivery,
			'goods_value'  => $goods_value,
			'currency'     => $currency,
            'drop_custid' => $drop_id,
            'drop_partyid' => $drop_id,
            'user_id' => $user_id,
            'sub_uid' => $childid,
            'pickup_custid' => $pickup_custid,
            'pickup_partyid' => $pickup_custid,
            'pickup_country' => $pickup_country,
            'pickup_city' => $pickup_city,
            'pickup_pincode' => $pickup_pincode,
            'pickup_company' => $pickup_name,
            'pickup_address1' => $pickup_street,
            'pickup_address2' => $pickup_state,
            'delivery_country' => $drop_country,
            'delivery_city' => $drop_city,
            'delivery_pincode' => $drop_pincode,
            'delivery_company' => $drop_name,
            'delivery_address1' => $drop_street,
            'delivery_address2' => $drop_state,
            'transport_mode' => $popupmodeof_trasnport,
            'plat' => $lat1,
            'plng' => $lng1,
            'dlat' => $lat2,
            'dlng' => $lng2,
            'is_created' => '1',
            'modeoftransport' => $tid,
            'created_source' => $created_source,
            'createdon' => $logdate,
            'shipper_id' => $popupshipper_id,
            'consignee_id' => $popupconsignee_id
        );
        $ins_order = $this->db->insert("tb_orders", $orderinfo);
        $order_id = $this->db->insert_id();
        $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", array(
            'id' => $user_id
        ));
        $country_code = $get_country->row()->country_code;
        $company_code = $get_country->row()->company_code;
        $genord = array(
            "user_id" => $user_id,
            "order_id" => $order_id,
            "country_code" => $country_code,
            "company_code" => $company_code
        );
        $booking_id = generatebookingid($genord);
        $invtypes = makeorderinvolvedpartiestype($customer_id, $order_id, "CUSTOMER", $user_id, $company_code);
        $upd = $this->db->where(array(
            'id' => $order_id
        ))->update("tb_orders", array(
            'order_id' => $booking_id
        ));
        $details = array(
            'shipper_id' => $post['quickbookshipper_id'],
            'service' => $service,
            'delivery_term' => $delivery_terms,
            'incoterm' => $incoterm,
            /* 'purchase_order'  => $porder, */
            'notify_party' => $notify_party,
            'department_code' => $department_code,
            'createdon' => $cdate,
            'order_row_id' => $order_id,
            'order_id' => $booking_id,
            'order_type' => $popuporder_type
        );
        $this->db->insert('tb_order_details', $details);

        $order_shipper_id = isset($post['quickbookshipper_id']) ? $post['quickbookshipper_id'] : "";
        $order_consignee_id = isset($post['quickbookconsignee_id']) ? $post['quickbookconsignee_id'] : "";
        if($order_shipper_id >0){
            $order_shipper_id = $order_shipper_id;
        }else{
            $order_shipper_id = $pickup;
        }
        if($order_consignee_id >0){
            $order_consignee_id = $order_consignee_id;
        }else{
            $order_consignee_id = $delivery;
        }
        $pickup_address = $pickup_street . "," . $pickup_city . "," . $pickup_state;
        $shipper_address = array(
            'order_id' => $order_id,
            'party_master_id' => $order_shipper_id,
            'location_id' => $pickup_city,
            'street' => $pickup_street,
            'state' => $pickup_state,
            'address' => $pickup_address,
            'pincode' => $pickup_pincode,
            'country' => $pickup_country,
            'user_id' => $user_id
        );
        $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
            'order_id' => $order_id,
            'party_master_id' => $order_shipper_id,
            'status' => '1'
        ));
        if ($chk_shipperaddress->num_rows() > 0) {
            $shipperadd_id = $chk_shipperaddress->row()->id;
            $upd_add = $this->db->where(array(
                'id' => $shipperadd_id
            ))->update("tbl_orderparty_address", $shipper_address);
        } else {
            $shipper_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $shipper_address);
            $shipperadd_id = $this->db->insert_id();
        }
        $drop_address = $drop_street . "," . $drop_city . "," . $drop_state;
        $delivery_address = array(
            'order_id' => $order_id,
            'party_master_id' => $delivery,
            'location_id' => $drop_city,
            'street' => $drop_street,
            'state' => $drop_state,
            'address' => $drop_address,
            'pincode' => $drop_pincode,
            'country' => $drop_country,
            'user_id' => $user_id
        );
        $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array(
            'order_id' => $order_id,
            'party_master_id' => $delivery,
            'status' => '1'
        ));
        if ($chk_deliveryaddress->num_rows() > 0) {
            $dropadd_id = $chk_deliveryaddress->row()->id;
            $upd_add = $this->db->where(array(
                'id' => $dropadd_id
            ))->update("tbl_orderparty_address", $delivery_address);
        } else {
            $delivery_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $delivery_address);
            $dropadd_id = $this->db->insert_id();
        }
        $shipment_name = "BOXES";
        if ($order_cargo_id != "") {
            $cargo_ids = array();
            $cargo_ids = explode(',', $order_cargo_id);

            for ($i = 0; $i < count($cargo_ids); $i++) {
                $length = $width = $height = $weight = $volume = $ldm = $second_weight = $second_volume = 0;
                $quantity = 1;
                if ($cargo_ids[$i] != "") {
                    $getcargo_details = $this->db->query("SELECT cargo_type,goods_description,length,width,height,weight,volumetric_weight,ldm,volume,second_weight,second_volume,quantity,marks_numbers FROM tb_cargo_details WHERE id='" . $cargo_ids[$i] . "'");
                    $length = $width = $height = $weight = $volume = $quantity = $cargo_type = $description = "";
                    if ($getcargo_details->num_rows() > 0) {
                        $length = $getcargo_details->row()->length;
                        $width = $getcargo_details->row()->width;
                        $height = $getcargo_details->row()->height;
                        $weight = $getcargo_details->row()->weight;
                        $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                        $volume = $getcargo_details->row()->volume;
                        $quantity = $getcargo_details->row()->quantity;
                        $shipment_name = $cargo_type = $this->db->escape_str($getcargo_details->row()->cargo_type);
                        $description = $this->db->escape_str($getcargo_details->row()->goods_description);
                        $ldm = $getcargo_details->row()->ldm;
                        $second_weight = $getcargo_details->row()->second_weight;
                        $marks_numbers          = $getcargo_details->row()->marks_numbers;
                        $second_volume = $getcargo_details->row()->second_volume;
                    }
                    $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargo_type . "'");
                    $handling_unit = "";
                    if ($gethandling_unit->num_rows() > 0) {
                        $handling_unit = $gethandling_unit->row()->id;
                    } else {
                        $handlingunit_ar = array(
                            'unit_name' => $cargo_type,
                            'description' => $cargo_type,
                            'user_id' => $user_id,
                            'created_at' => $cdate,
                            'status' => '1'
                        );
                        $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                        $handling_unit = $this->db->insert_id();
                    }
                    $cargo = array(
                        'order_id' => $order_id,
                        'cargo_id' => $cargo_ids[$i],
                        'status' => '1',
                        'length' => $length,
                        'width' => $width,
                        'height' => $height,
                        'weight' => $weight,
                        'volume' => $volume,
                        'quantity' => $quantity,
                        'cargo_content' => $description,
                        'quantity_type' => $cargo_type,
                        'handling_unit' => $handling_unit,
                        'volumetric_weight' => $volumetric_weight,
                        'volweight_uom' => 'kg',
                        'ldm' => $ldm,
                        'second_weight' => $second_weight,
                        'marks_numbers'     => $marks_numbers,
                        'second_volume' => $second_volume
                    );
                    $orderCargoId = $this->common->insertTableData("tb_order_cargodetails", $cargo);
                    $checkDgGoods = $this->common->gettbldata(['order_cargo_id' => $cargo_ids[$i], 'status' => '1'], "id", "tb_order_dg_goods", 0, 0);
                    foreach ($checkDgGoods as $eachLine) {
                        $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $orderCargoId, 'order_id' => $order_id], ['id' => $eachLine['id']]);
                    }
                }
            }
        }
        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
        if ($gettotal->num_rows() > 0) {
            $total_volume = $gettotal->row()->total_volume;
            $total_weight = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $cargo_forship = array();
        $getcargos = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='" . $order_id . "'");
        if ($getcargos->num_rows() > 0) {
            foreach ($getcargos->result() as $res) {
                $cargo_forship[] = $res->quantity_type;
            }
        }
        $unitspec = "";
        if (!empty($cargo_forship)) {
            $unitspec = implode(',', $cargo_forship);
        }
        $updship = $this->db->where(array(
            'id' => $ship_row_id
        ))->update("tb_shipments", array(
            'unitspec' => $unitspec,
            'txncode' => $booking_id
        ));
        $upd_order = $this->db->where(array(
            'id' => $order_id
        ))->update("tb_orders", array(
            'volume' => $total_volume,
            'weight' => $total_weight,
            'quantity' => $total_quantity
        ));
        $ids = array();
        if ($reference_ids != "0") {
            $refids = explode(',', $reference_ids);
        }
        $order_ref_ids = array();
        if ($quickbook_order_reference_ids != "0") {
            $order_ref_ids = explode(',', $quickbook_order_reference_ids);
        }
        if (!empty($order_ref_ids)) {
            for ($i = 0; $i < count($order_ref_ids); $i++) {
                if ($order_ref_ids[$i] != "") {
                    $upd = $this->db->where(array(
                        'id' => $order_ref_ids[$i]
                    ))->update("tb_order_references", array(
                        'order_id' => $order_id
                    ));
                }
            }
        }
        if ($shipment_id != "") {
            $ins_ref = array(
                'order_id' => $order_id,
                'reference_id' => 'DQ',
                'ref_value' => $shipment_id,
                'createdon' => $cdate
            );
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($driverdelivery_popup != "") {
            $ins_ref = array(
                'order_id' => $order_id,
                'reference_id' => 'ORD_DLVINST',
                'ref_value' => $driverdelivery_popup,
                'createdon' => $cdate
            );
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($driverpickup_popup != "") {
            $ins_ref = array(
                'order_id' => $order_id,
                'reference_id' => 'ORD_PIKINST',
                'ref_value' => $driverpickup_popup,
                'createdon' => $cdate
            );
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        if ($porder != "") {
            $ins_ref = array(
                'order_id' => $order_id,
                'reference_id' => 'PO',
                'ref_value' => $porder,
                'createdon' => $cdate
            );
            $ins = $this->db->insert('tb_order_references', $ins_ref);
        }
        $sub_cut_parties = array();
        $sub_cut_parties['0'] = $order_shipper_id;
        $sub_cut_parties['1'] = $order_consignee_id;
        $sub_cut_parties['2'] = $pickup;
        $sub_cut_parties['3'] = $delivery;
if (!empty($sub_cut_parties)) {
    subcustpartiesinsert($order_id, $booking_id, $sub_cut_parties);
}
$pref_arr = array(
    'pickup' => strtoupper($pickup_country),
    'pickup_state' => strtoupper($pickup_state),
    'pickup_city' => strtoupper($pickup_city),
    'pickup_pincode' => $pickup_pincode,
    'drop' => strtoupper($drop_country),
    'drop_state' => strtoupper($drop_state),
    'drop_city' => strtoupper($drop_city),
    'drop_pincode' => $drop_pincode,
    'customer_id' => $popupcustomer_id,
    'service' => $service,
    'product' => $product,
    'user_id' => $user_id,
    'company_code' => $company_code,
    'order_id' => $order_id,
    'order_type' => $popuporder_type,
    'customer_row_id' => $customer_id
);

        $customerProfileId = $post['customerProfileId'] ?? 0;
        $rateServiceRowId = $post['rateServiceRowId'] ?? 0;
        $rateOfferingRowId = $post['rateOfferingRowId'] ?? 0;
        $rateRecordRowId = $post['rateRecordRowId'] ?? 0;
        $laneRowId = $post['laneRowIdForBook'] ?? 0;
        if (!in_array(0, [$customerProfileId, $rateServiceRowId, $rateOfferingRowId, $rateRecordRowId, $laneRowId], true)) {
            $this->ratemanagement->addratesForOrderFromRateEnquiry(
                ['customerId' => $popupcustomer_id, 'orderRowId' => $order_id, 'customerProfile' => $customerProfileId, 'rateServiceRowId' => $rateServiceRowId, 'rateOfferingRowId' => $rateOfferingRowId, 'rateRecordRowId' => $rateRecordRowId, 'currency' => $this->session->userdata("usr_tzone")['currency'], 'userId' => $user_id, 'laneRowId' => $laneRowId, 'vendorIdFromProfile' => $post['vendorIdFromProfile'] ?? 0, 'vendorCodeFromProfile' => $post['vendorCodeFromProfile'] ?? ""]
            );
        } else {
            $this->ratemanagement->addrecodfororderinsertion($pref_arr);
        }

    /* if($this->session->userdata('usr_tzone')['country'] == "RU"){ */

        if ($order_id != "" && $customer_id != "") {
            $pickupinfo['country'] = trim($pickup_country);
            $pickupinfo['state'] = trim($pickup_state);
            $pickupinfo['city'] = trim($pickup_city);
            $pickupinfo['region'] = trim($pickup_street);
            $pickupinfo['zipcode'] = trim($pickup_pincode);
            $pickupinfo['order_country'] = trim($pickup_country);
            $pickupinfo['order_city'] = trim($pickup_city);
            $pickupinfo['order_zipcode'] = trim($pickup_pincode);
            $pickupinfo['stoptype'] = "P";
            $dropinfo['country'] = trim($drop_country);
            $dropinfo['order_country'] = trim($drop_country);
            $dropinfo['order_city'] = trim($drop_city);
            $dropinfo['order_zipcode'] = trim($drop_pincode);
            $dropinfo['state'] = trim($drop_state);
            $dropinfo['city'] = trim($drop_city);
            $dropinfo['region'] = trim($drop_street);
            $dropinfo['zipcode'] = trim($drop_pincode);

            $dropinfo['stoptype'] = "D";
            $pickupgeocode = checkgeocode($pickupinfo);
            $dropgeocode = checkgeocode($dropinfo);
            if (!empty($pickupgeocode) && !empty($dropgeocode)) {
                $pickupgeocode['stoptype'] = "P";
                $dropgeocode['stoptype'] = "D";
                $pickupgeocode['order_country'] = trim($pickup_country);
                $pickupgeocode['order_city'] = trim($pickup_city);
                $pickupgeocode['order_zipcode'] = trim($pickup_pincode);
                $dropgeocode['order_country'] = trim($drop_country);
                $dropgeocode['order_city'] = trim($drop_city);
                $dropgeocode['order_zipcode'] = trim($drop_pincode);

                //-------------------------------- //for auto route
                $pickupgeocode['cargo'] = $cargo;
                $dropgeocode['cargo'] =  $cargo;
                //--------------------------------

                $pickuproute = getcust_routeautomate($customer_id, $pickupgeocode);
                $droproute = getcust_routeautomate($customer_id, $dropgeocode);

                if (!empty($pickuproute) && !empty($droproute)) {
                    $orderinfo['id'] = $order_id;
                    $orderinfo['order_id'] = $booking_id;
                    $orderinfo['shipment_name'] = $shipment_name;
                    $orderinfo['customer_phone'] = $customer_phone;
                    $orderinfo['customer_email'] = $customer_email;
                    $orderinfo['volume'] = $total_volume;
                    $orderinfo['weight'] = $total_weight;
                    $orderinfo['quantity'] = $total_quantity;
                    $orderinfo['quantity'] = $total_quantity;
                    $shipment = createshipmentbyorder($pickuproute, $orderinfo);
                } else {

                     //-------------------------------- //for auto route
                $pickupinfo['cargo'] = $cargo;
                $dropinfo['cargo'] =  $cargo;
                //--------------------------------

                    $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                    $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                    if (!empty($pickuproute1) && !empty($droproute1)) {
                        $orderinfo['id'] = $order_id;
                        $orderinfo['order_id'] = $booking_id;
                        $orderinfo['shipment_name'] = $shipment_name;
                        $orderinfo['customer_phone'] = $customer_phone;
                        $orderinfo['customer_email'] = $customer_email;
                        $orderinfo['volume'] = $total_volume;
                        $orderinfo['weight'] = $total_weight;
                        $orderinfo['quantity'] = $total_quantity;
                        $orderinfo['quantity'] = $total_quantity;
                        $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                    }
                }
            } else {

                  //-------------------------------- //for auto route
                  $pickupinfo['cargo'] = $cargo;
                  $dropinfo['cargo'] =  $cargo;
                  //--------------------------------


                $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                if (!empty($pickuproute1) && !empty($droproute1)) {
                    $orderinfo['id'] = $order_id;
                    $orderinfo['order_id'] = $booking_id;
                    $orderinfo['shipment_name'] = $shipment_name;
                    $orderinfo['customer_phone'] = $customer_phone;
                    $orderinfo['customer_email'] = $customer_email;
                    $orderinfo['volume'] = $total_volume;
                    $orderinfo['weight'] = $total_weight;
                    $orderinfo['quantity'] = $total_quantity;
                    $orderinfo['quantity'] = $total_quantity;
                    $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                }
            }
            $checkTripForOrder = $this->common->gettblrowdata("id='" . $order_id . "' AND shift_id >0", "id,shift_id", "tb_orders", 0, 0);
            if (!empty($checkTripForOrder)) {
                $this->load->library('notifytrigger');
                $this->notifytrigger->sendNotificationToCarrier($checkTripForOrder['shift_id'], $company_code, 'CR');
            }
        }
        /* } */
        $this->ordernotify('booking_create', $order_id);
        if ($order_id != "" && $order_id != '0') {
            try {
                $this->altovaordercreation->sendOrderToAltova($order_id);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Order to Altova ".$ex->getMessage());
            }
            $this->session->set_flashdata('success_msg', 'Order Created Successfully - ' . $booking_id);
            redirect('smtcorders/orderslist/' . $order_id);
        } else {
            redirect("orders");
        }
    }

    public function addreferencedetails() {
        $post = array();
        $companyCode = $this->session->userdata("company_code");
        $branchCode = $this->session->userdata("branch_code");
        $post = $this->input->post(NULL,TRUE);
        $id = $this->db->escape_str($this->input->post('reference_id',true));
        $name = $this->db->escape_str($this->input->post('reference_name',true));
        $value = $this->db->escape_str($this->input->post('reference_value',true));

        if ($id == "ETA") {
            $chkrtime = getdatetimebytimezone(DFLT_TZ, $value, $this->session->userdata('usr_tzone')['timezone']);
            $value = $chkrtime['datetime'];
        }
        $row_id = isset($post['ref_row_id']) ? $this->db->escape_str($post['ref_row_id']) : "";
        $order_id = isset($post['order_id']) ? $this->db->escape_str($post['order_id']) : "0";
        $order_ref_id = isset($post['order_ref_id']) ? $this->db->escape_str($post['order_ref_id']) : "0";
        $cdate = date('Y-m-d H:i:s');
        $ins_id = $order_ins_id = 0;
        if ($row_id == "") {
            $ins_arr = array(
                'name' => $id,
                'description' => $name,
                'createdon' => $cdate
            );
            $chk_ar = $this->db->select('id')->get_where('tb_reference_master', array(
                'name' => $id,
                'status' => '1'
            ));
            if ($chk_ar->num_rows() == 0) {
                $ins = $this->db->insert("tb_reference_master", $ins_arr);
                $ins_id = $this->db->insert_id();
            } else {
                $ins_id = $chk_ar->row()->id;
            }

            if ($ins_id != "") {
                $ins_order = array(
                    'reference_id' => $id,
                    'ref_value' => $value,
                    'createdon' => $cdate,
                    'order_id' => $order_id
                );
                $ins = $this->db->insert("tb_order_references", $ins_order);
                $order_ins_id = $this->db->insert_id();
                $orderReferenceValueInsert = xbdrNotificationInsert($id, $companyCode, $value, $order_id, $branchCode);
            }
        } else {
            $upd_ar = array(
                'name' => $id,
                'description' => $name
            );
            if ($id == 'PO') {
                $po_val = $value;
                $upd = $this->db->where(array(
                    'order_row_id' => $order_id
                ))->update("tb_order_details", array(
                    'purchase_order' => $po_val
                ));
            }
            if ($id == 'DQ') {
                $dq_val = $value;
                $chkshipment = $this->db->query("SELECT s.id FROM tb_shipments s,tb_orders o WHERE o.id='" . $order_id . "' AND o.shipment_id=s.id");
                if ($chkshipment->num_rows() > 0) {
                    $shipment_id = $chkshipment->row()->id;
                    $upd = $this->db->where(array(
                        'id' => $shipment_id
                    ))->update("tb_shipments", array(
                        'shipid' => $dq_val,
                        'txnid' => $dq_val
                    ));
                }
            }
            $this->db->where(array(
                'id' => $row_id
            ))->update("tb_reference_master", $upd_ar);
            if ($order_id != "") {
                $ins_ar = array(
                    'order_id' => $order_id,
                    'reference_id' => $id,
                    'ref_value' => $value,
                    'createdon' => $cdate
                );
                $chk = $this->db->select('id')->get_where('tb_order_references', array(
                    'order_id' => $order_id,
                    'reference_id' => $id,
                    'status' => '1'
                ));
                if ($chk->num_rows() == 0) {
                    $ins_ar['createdon'] = $cdate;
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $this->db->where(array(
                        'id' => $chk->row()->id
                    ))
                    ->update("tb_order_references", $ins_ar);
                }
            } else {
                $chk = $this->db->select('id')->get_where('tb_order_references', array(
                    'reference_id' => $id,
                    'status' => '1'
                ));
                $ins_ar = array(
                    'order_id' => '0',
                    'reference_id' => $id,
                    'ref_value' => $value,
                    'createdon' => $cdate
                );
                if ($chk->num_rows() == 0) {
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $order_ins_id = $chk->row()->id;
                    $upd = $this->db->where(array(
                        'id' => $order_ins_id
                    ))->update("tb_order_references", $ins_ar);
                }
            }
            $ins_id = $row_id;
        }
        $arr = array(
            'ins_id' => $ins_id,
            'order_ins_id' => $order_ins_id
        );
        echo json_encode($arr);
    }

    public function addpopupreferencedetails() {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $companyCode = $this->session->userdata("company_code");
        $branchCode = $this->session->userdata("branch_code");
        $id = $this->db->escape_str($this->input->post('reference_id',true));
        $name = $this->db->escape_str($this->input->post('reference_name',true));
        $value = $this->db->escape_str($this->input->post('reference_value',true));
        $row_id = isset($post['ref_row_id']) ? $this->db->escape_str($post['ref_row_id']) : "";
        $order_id = isset($post['order_id']) ? $this->db->escape_str($post['order_id']) : "0";
        $order_ref_id = isset($post['order_ref_id']) ? $this->db->escape_str($post['order_ref_id']) : "0";
        $cdate = date('Y-m-d H:i:s');
        $ins_id = $order_ins_id = 0;
        if ($row_id == "") {
            $ins_arr = array(
                'name' => $id,
                'description' => $name,
                'createdon' => $cdate
            );
            $chk_ar = $this->db->select('id')->get_where('tb_reference_master', array(
                'name' => $id,
                'status' => '1'
            ));
            if ($chk_ar->num_rows() == 0) {
                $ins = $this->db->insert("tb_reference_master", $ins_arr);
                $ins_id = $this->db->insert_id();
            } else {
                $ins_id = $chk_ar->row()->id;
            }
            if ($ins_id != "") {
                $ins_order = array(
                    'reference_id' => $id,
                    'ref_value' => $value,
                    'createdon' => $cdate,
                    'order_id' => $order_id
                );
                $ins = $this->db->insert("tb_order_references", $ins_order);
                $order_ins_id = $this->db->insert_id();
                $orderReferenceValueInsert = xbdrNotificationInsert($id, $companyCode, $value, $order_id, $branchCode);
            }
        } else {
            $upd_ar = array(
                'name' => $id,
                'description' => $name
            );

            $this->db->where(array(
                'id' => $row_id
            ))->update("tb_reference_master", $upd_ar);
            if ($order_id != "") {
                $ins_ar = array(
                    'order_id' => $order_id,
                    'reference_id' => $id,
                    'ref_value' => $value,
                    'createdon' => $cdate
                );
                $chk = $this->db->select('id')->get_where('tb_order_references', array(
                    'order_id' => $order_id,
                    'reference_id' => $id,
                    'status' => '1',
                    'id' => $order_ref_id
                ));
                if ($chk->num_rows() == 0) {
                    $ins_ar['createdon'] = $cdate;
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $this->db->where(array(
                        'id' => $chk->row()->id
                    ))
                    ->update("tb_order_references", $ins_ar);
                }
            } else {
                $chk = $this->db->select('id')->get_where('tb_order_references', array(
                    'reference_id' => $id,
                    'status' => '1',
                    'id' => $order_ref_id
                ));
                $ins_ar = array(
                    'order_id' => '0',
                    'reference_id' => $id,
                    'ref_value' => $value,
                    'createdon' => $cdate
                );
                if ($chk->num_rows() == 0) {
                    $order_ins = $this->db->insert("tb_order_references", $ins_ar);
                    $order_ins_id = $this->db->insert_id();
                } else {
                    $order_ins_id = $chk->row()->id;
                    $upd = $this->db->where(array(
                        'id' => $order_ins_id
                    ))->update("tb_order_references", $ins_ar);
                }
            }
            $ins_id = $row_id;
        }
        $arr = array(
            'ins_id' => $ins_id,
            'order_ins_id' => $order_ins_id
        );
        echo json_encode($arr);
    }

    public function deleteorderreferencedetails() {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $this->db->escape_str($post['order_id']) : "0";
        $ref_id = isset($post['ref_id']) ? $this->db->escape_str($post['ref_id']) : "0";
        if ($order_id != '0' && $ref_id != '0') {
            $getref_name = $this->db->select('name')->get_where("tb_reference_master", array(
                'id' => $ref_id
            ));
            if ($getref_name->num_rows() > 0) {
                $ref_id = $getref_name->row()->name;
            }
            $chkdetails = $this->db->select('id')->get_where("tb_order_references", array(
                'order_id' => $order_id,
                'id' => $ref_id,
                'status' => '1'
            ));
            if ($chkdetails->num_rows() > 0) {
                $upd = $this->db->where(array(
                    'id' => $chkdetails->row()->id
                ))
                ->update("tb_order_references", array(
                    'status' => '0'
                ));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        }
    }

    public function getotherreferencedetails() {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $this->db->escape_str($post['order_id']) : "";
        $type = isset($post['type']) ? $this->db->escape_str($post['type']) : "";
        $ref_ids = isset($post['ref_ids']) ? $this->db->escape_str($post['ref_ids']) : array();
        $getrefer_rows = 0;
        $refer = $refids = array();
        $whr = "";
        $action = "";
        if ($order_id != "") {
            $getrefer = $this->db->query("SELECT r.id,r.name,r.description,o.order_shortNo,o.id as order_ref_id,o.reference_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE o.order_id='" . $order_id . "' AND o.reference_id =r.name  AND r.status='1' AND o.status='1' GROUP BY o.id ORDER BY r.createdon DESC");
            $getrefer_rows = $getrefer->num_rows();
        } else {
            $whr = "";
            if ($ref_ids != "") {
                $refids = implode(',', $ref_ids);
                if (!empty($refids)) {
                    $whr .= " AND r.id IN (" . $refids . ") ";
                }
            }
            if (!empty($refids)) {
                $getrefer = $this->db->query("SELECT r.id,r.name,r.description,o.order_shortNo,o.id as order_ref_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE r.name=o.reference_id  AND  o.status='1' AND r.status ='1' " . $whr . " GROUP BY r.id ORDER BY r.createdon DESC");
                $getrefer_rows = $getrefer->num_rows();
            }
        }
        if ($getrefer_rows > 0) {
            foreach ($getrefer->result() as $res) {
                $order_shortNo = $res->order_shortNo;
                if ($type == 'popup') {
                    $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs' onclick='editpopupreferencedetails(" . $res->id . "," . $res->order_ref_id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs' onclick='deletepopupreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                } else {
                    if ($order_id != "") {
                        $info = array('id' => $res->id, 'name' => $res->name, 'desc' => $res->description, 'value' => htmlentities($res->order_value, ENT_QUOTES));
                        $info = htmlentities(json_encode($info));
                        $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='editreferencedetails(this," . $info . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletereferencedetailsbyorder(" . $res->order_ref_id . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowRefAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Reference</a></li>";
                    } else {
                        $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs editparties' onclick='editreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs deleteround' onclick='deletereferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                    }
                }
                $res_val = $res->order_value;
                if ($res_val != "") {
                    if (DateTime::createFromFormat('Y-m-d H:i:s', $res_val) !== FALSE) {
                        $chkrtime = getdatetimebytimezone($this->session->userdata('usr_tzone')['timezone'], $res_val, DFLT_TZ);
                        $res_val = $chkrtime['datetime'];
                    } else {
                        $res_val = $res_val;
                    }
                }
                $refer[] = array(
                    'id' => $res->name,
                    'name' => $res->description,
                    'value' => $res_val,
                    'order_shortNo' => $order_shortNo,
                    'action' => $action
                );
            }
        }
        echo json_encode($refer);
    }

    public function getotherpopupreferencedetails() {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id = isset($post['order_id']) ? $this->db->escape_str($post['order_id']) : "";
        $type = isset($post['type']) ? $this->db->escape_str($post['type']) : "";
        $ref_ids = isset($post['ref_ids']) ? $this->db->escape_str($post['ref_ids']) : "";
        $popupref_order_id = isset($post['popupref_order_id']) ? $this->db->escape_str($post['popupref_order_id']) : "";
        $getrefer_rows = 0;
        $refer = $popupref_order_ids = $refids = array();
        $whr = "";
        $action = "";
        if ($order_id != "") {
            $getrefer = $this->db->query("SELECT r.id,r.name,r.description,o.reference_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE o.order_id='" . $order_id . "' AND o.reference_id =r.name AND r.status='1' AND o.status='1' ORDER BY r.createdon DESC");
            $getrefer_rows = $getrefer->num_rows();
        } else {
            if ($ref_ids != "") {
                $refids = implode(',', $ref_ids);
                if ($popupref_order_id != "") {
                    $popupref_order_ids = implode(',', $popupref_order_id);
                    if (!empty($popupref_order_ids)) {
                        $whr = " AND o.id IN (" . $popupref_order_ids . ") ";
                    }
                }

                if (!empty($refids)) {
                    $whr .= " AND r.id IN (" . $refids . ") ";
                    $getrefer = $this->db->query("SELECT r.id,r.name,r.description,o.id as order_ref_id,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE r.name=o.reference_id AND o.status='1' AND r.status ='1' " . $whr . " GROUP BY r.id ORDER BY r.createdon DESC");
                    $getrefer_rows = $getrefer->num_rows();
                }
            }
        }
        if ($getrefer_rows > 0) {
            foreach ($getrefer->result() as $res) {
                if ($type == 'popup') {
                    $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs' onclick='editpopupreferencedetails(" . $res->id . "," . $res->order_ref_id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs' onclick='deletepopupreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                } else {
                    if ($order_id != "") {
                        $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs editparties' onclick='editreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs deleteround' onclick='deletereferencedetailsbyorder(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                    } else {
                        $action = "<button id=" . $res->id . " class='btn btn-primary btn-xs editparties' onclick='editreferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-pencil'></i></small></button> <button id=" . $res->id . " class='btn btn-danger btn-xs deleteround' onclick='deletereferencedetails(" . $res->id . ",event)'><small><i class='glyphicon glyphicon-trash'></i></small></button>";
                    }
                }
                $refer[] = array(
                    'id' => $res->name,
                    'name' => $res->description,
                    'value' => $res->order_value,
                    'action' => $action
                );
            }
        }
        echo json_encode($refer);
    }

    public function editreferencedetails()
    {
        $id = $this->db->escape_str($this->input->post('id',true));
        $refer = array();
        $get_details = $this->db->query("SELECT r.*,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE r.id='" . $id . "' AND r.name=o.reference_id");
        if ($get_details->num_rows() > 0) {
            $refer = array(
                'id' => $get_details->row()->id,
                'ref_id' => $get_details->row()->name,
                'name' => $get_details->row()->description,
                'value' => $get_details->row()->order_value
            );
        }
        echo json_encode($refer);
    }

    public function editpopupreferencedetails() {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $id = $this->db->escape_str($this->input->post('id',true));
        $order_ref_id = isset($post['order_ref_id']) ? $this->db->escape_str($post['order_ref_id']) : "";
        $refer = array();
        $whr = "";
        if ($order_ref_id != "") {
            $whr .= " AND o.id='" . $order_ref_id . "'";
        }
        $get_details = $this->db->query("SELECT r.*,o.ref_value as order_value FROM tb_reference_master r,tb_order_references o WHERE r.id='" . $id . "' AND r.name=o.reference_id " . $whr);
        if ($get_details->num_rows() > 0) {
            $refer = array(
                'order_ref_id' => $order_ref_id,
                'id' => $get_details->row()->id,
                'ref_id' => $get_details->row()->name,
                'name' => $get_details->row()->description,
                'value' => $get_details->row()->order_value
            );
        }
        echo json_encode($refer);
    }

    public function viewpartylist() {



        $parties     = array();
        $user_id     = $this->session->userdata( 'user_id' );
        $type        = isset( $_POST['type'] ) ? $_POST['type'] : "0";
        $party_type  = isset( $_POST['party'] ) ? $_POST['party'] : "";
        $customer_id = isset( $_POST['customer_id'] ) ? $_POST['customer_id'] : "0";
        $check       = "";
        $custid      = "0";
        $whr         = $usrwhr = "";
        if ( $customer_id == "" ) {
            $customer_id = 0;
        }
        $chkcompanycode = $this->session->userdata( 'company_code' );
        $permission = checkuserpermissions();
        
        if (in_array("businesspartners", $permission)) {
             $xborderdetails  = $this->db->select( "xborder_code" )->get_where( "tb_xborder_country", array( 'company_code' => $chkcompanycode ) );

            if ( $xborderdetails->num_rows() > 0 ) {
                 $xborder_code= $xborderdetails->row()->xborder_code;
                 if($xborder_code!=""){
                    $xborder_company=explode(",",$xborder_code);
                    $usrwhr = " AND m.company_code IN ('" . $chkcompanycode . "','" . implode( "','", $xborder_company ) . "')";
                 }else{
                    $usrwhr = " AND m.company_code LIKE '" . $chkcompanycode . "' ";
                 }
            }else{
                $usrwhr = " AND m.company_code LIKE '" . $chkcompanycode . "' ";
            }

        } else {
            $usrwhr = " AND m.user_id='" . $user_id . "' ";
        }
       
        if ( $this->session->userdata( 'cust_id' ) !== FALSE ) {
            $custid = $this->session->userdata( 'cust_id' );
        }
        $subcusts = array();
        if ( $custid != 0 ) {
            if ( $this->session->userdata( 'sub_cust' ) !== FALSE ) {
                if($this->session->userdata('sub_cust') != ""){
                    $subcusts = $this->session->userdata( 'sub_cust' );
                }
                /*if ( count( $subcusts ) > 0 ) {
                    array_push( $subcusts, $custid );
                } else {
                    $subcusts = $custid;
                }*/
                if(!empty($subcusts) && sizeof($subcusts)>0){
                    array_push( $subcusts, $custid );
                }else{
                    /*$subcusts = $custid;*/
                    array_push($subcusts, $custid);
                }
            } else {
            /*  $subcusts = $custid;*/
                array_push($subcusts, $custid);
            }
        }
        $customer_code = array();
        if ( ! empty( $subcusts ) ) {
            $select          = "code";
            $table           = "tb_customers";
            $customerdetails = $this->Order->getcustomercodebyids( $select, $table, $subcusts );
            if ( ! empty( $customerdetails ) ) {
                foreach ( $customerdetails as $cust ) {
                    $customer_code[] = $cust['code'];
                }
            }
        }
        if ( ! empty( $customer_code ) ) {
            $whr = "AND m.customer_code IN ('" . implode( "','", $customer_code ) . "') ";
        }
        
        $party_type_whr = " ";
        if ( $party_type != "" ) {
            $party_type_whr = " AND t.name LIKE '" . $party_type . "' ";
        }


        $contact_ids = $master_ids = array();
        if ( $customer_id != '0' ) {
            $getid = $this->common->gettblrowdata( array( 'code' => $customer_id ), "id", 'tbl_party_master', 0, 0 );
            if ( ! empty( $getid ) ) {
                $customer_row_id = $getid['id'];
                $get_custparties = $this->db->query( "SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name FROM tbl_party_master m,tbl_party_types t WHERE  m.company_code != '' AND m.company_code IS NOT NULL  AND m.branch_code != '' AND m.branch_code IS NOT NULL " . $usrwhr . " AND m.parent_id ='" . $customer_row_id . "' AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' AND t.id=m.party_type_id  GROUP BY m.id ORDER BY m.id DESC" );

                if ( $get_custparties->num_rows() > 0 ) {
                    foreach ( $get_custparties->result() as $res ) {
                        if ( $type == '1' ) {
                            $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                        } else {
                            $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                        }
                        $contact_ids[] = $res->master_id;
                        $master_ids[]  = $res->master_id;
                        $parties[]     = array(
                            'check'        => $check,
                            'id'           => $res->code,
                            'name'         => $res->master_name,
                            'email'        => $res->master_email_id,
                            'mobile'       => $res->master_mobile,
                            'party_name'   => $res->party_name,
                            'company_code' => $res->company_code,
                            'branch_code'  => $res->branch_code,
                            'party_name'   => $party_type,
                            'city'         => $res->city,
                            'country'      => $res->country,
                            'street'       => $res->street
                        );
                    }
                }
            }
        }

        $get_parties = $this->db->query( "SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,t.name as party_name FROM tbl_party_master m,tbl_party_types t WHERE m.company_code != '' AND m.company_code IS NOT NULL  AND m.branch_code != '' AND m.branch_code IS NOT NULL " . $whr . " " . $usrwhr . " AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' AND t.id=m.party_type_id " . $party_type_whr . " GROUP BY m.id ORDER BY m.id DESC" );
        if ( $get_parties->num_rows() > 0 ) {
            foreach ( $get_parties->result() as $res ) {
                if ( $type == '1' ) {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                } else {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                }
                $master_ids[] = $res->master_id;
                $parties[]    = array(
                    'check'        => $check,
                    'id'           => $res->code,
                    'name'         => $res->master_name,
                    'email'        => $res->master_email_id,
                    'mobile'       => $res->master_mobile,
                    'party_name'   => $res->party_name,
                    'company_code' => $res->company_code,
                    'branch_code'  => $res->branch_code,
                    'party_name'   => $res->party_name,
                    'city'         => $res->city,
                    'country'      => $res->country,
                    'street'       => $res->street
                );
            }
        }
        $master_whr     = "";
        $additional_ids = $party_types = array();
        if ( ! empty( $master_ids ) ) {
            $master_whr = "AND m.id NOT IN (" . implode( ',', $master_ids ) . ")  ";
        }
        $getmultipleparties = $this->db->query( "SELECT m.id as master_id,m.party_types FROM tbl_party_master m WHERE m.code IS NOT NULL " . $master_whr . " " . $whr . " " . $usrwhr . " AND m.party_types IS NOT NULL" );
        if ( $getmultipleparties->num_rows() > 0 ) {
            foreach ( $getmultipleparties->result() as $res ) {
                if ( $res->party_types != "" && $res->party_types != '0' ) {
                    $party_types = explode( ',', $res->party_types );
					if(end($party_types)==""){
						array_pop($party_types);
					}
                    if ( is_array( $party_types ) ) {
                        if ( ! empty( $party_types ) ) {
                            $chkshipper = $this->db->query( "SELECT id FROM tbl_party_types WHERE id IN (" . implode( ',', $party_types ) . ") AND name LIKE '" . $party_type . "'" );
                            if ( $chkshipper->num_rows() > 0 ) {
                                $additional_ids[] = $res->master_id;
                            }
                        }
                    }
                }
            }
        }

        if ( ! empty( $additional_ids ) ) {
            $get_addids = $this->db->query( "SELECT m.id as master_id,m.name as master_name,m.email as master_email_id,m.mobile as master_mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street FROM tbl_party_master m WHERE m.id IN (" . implode( ',', $additional_ids ) . ") AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL  " . $usrwhr . " AND m.parent_id ='0'  AND m.status=1 ANd m.code != '' AND m.code is NOT NULL AND m.code != '0' GROUP BY m.id ORDER BY m.id DESC" );
            if ( $get_addids->num_rows() > 0 ) {
                foreach ( $get_addids->result() as $res ) {
                    if ( $type == '1' ) {
                        $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                    } else {
                        $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->master_id . "' class='consigneelist' onchange='selectparty(" . $res->master_id . ")' value='" . $res->code . "'>";
                    }
                    $master_ids[] = $res->master_id;
                    $parties[]    = array(
                        'check'        => $check,
                        'id'           => $res->code,
                        'name'         => $res->master_name,
                        'email'        => $res->master_email_id,
                        'mobile'       => $res->master_mobile,
                        'party_name'   => $party_type,
                        'company_code' => $res->company_code,
                        'branch_code'  => $res->branch_code,
                        'party_name'   => $party_type,
                        'city'         => $res->city,
                        'country'      => $res->country,
                        'street'       => $res->street
                    );
                }
            }
        }

        echo json_encode( $parties );



    }

    public function getshipperdetailslistbyID() {
        $parties = array();
        $code = $this->input->post('id');
        $company_code = $this->session->userdata("company_code");
        $user_id = $this->session->userdata('user_id');
        $whr = " AND c.user_id ='" . $user_id . "' ";
        $permission = checkuserpermissions();
        if(in_array("businesspartners", $permission)){
            $whr = " AND c.company_code LIKE '" . $company_code . "' ";
        } else {
            $whr = " AND c.user_id ='" . $user_id . "' ";
        }

        $chkqry = $this->db->query("SELECT c.id,c.name,c.phone,c.address,c.street,c.location as city,c.state,c.pincode,c.code,c.country,c.email_id,c.fax,c.company_code,c.branch_code FROM tb_customers c WHERE c.code LIKE '%" . $code . "%' " . $whr . " GROUP BY c.id ORDER BY c.id DESC");
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = array(
                    'check' => "<input class='shipperlist' type='radio' name='selectshipper' id='shipperlist_" . $res->id . "' value='" . $res->code . "' onchange=selectshipper(" . $res->id . ")>",
                    'id' => $res->id,
                    'party_id' => $res->code,
                    'name' => $res->name,
                    'phone' => $res->phone,
                    'email' => $res->email_id,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'city' => $res->city,
                    'country' => $res->country,
                    'street' => $res->street
                );
            }
        }
        echo json_encode($parties);
    }

    public function getshipperListID() {
        $parties = array();
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $whr = " AND c.user_id ='" . $user_id . "' ";
        $permission = checkuserpermissions();
        if (in_array("businesspartners", $permission)) {
            $xborderdetails  = $this->db->select( "xborder_code" )->get_where( "tb_xborder_country", array( 'company_code' => $company_code ) );

			if ( $xborderdetails->num_rows() > 0 ) {
				 $xborder_code= $xborderdetails->row()->xborder_code;
				 if($xborder_code!=""){
					$xborder_company=explode(",",$xborder_code);
					$whr = " AND c.company_code IN ('" . $company_code . "','" . implode( "','", $xborder_company ) . "')";
				 }else{
					$whr = " AND c.company_code LIKE '" . $company_code . "' ";
				 }
			}else{
				$whr = " AND c.company_code LIKE '" . $company_code . "' ";
			}
        } else {
            $whr = " AND c.user_id ='" . $user_id . "' ";
        }
        $chkqry = $this->db->query("SELECT c.id,c.name,c.phone,c.code,c.country,c.street,c.location as city,c.email_id,c.company_code,c.branch_code FROM tb_customers c WHERE  c.status ='1' AND  c.company_code != '' AND c.company_code IS NOT NULL " . $whr . " GROUP BY c.id ORDER BY c.createdon DESC");
        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $parties[] = array(
                    'check' => "<input class='shipperlist' type='radio' name='selectshipper' id='shipperlist_" . $res->id . "' value='" . $res->code . "' onchange=selectshipper(" . $res->id . ")>",
                    'id' => $res->id,
                    'party_id' => $res->code,
                    'name' => $res->name,
                    'phone' => $res->phone,
                    'email' => wordwrap($res->email_id, 25, "<br />\n"),
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'city' => $res->city,
                    'country' => $res->country,
                    'street' => $res->street
                );
            }
        }
        echo json_encode($parties);
    }

    public function getconsigneedetailsListbyID() {
        $user_id = 1;
        $parties = array();
        $code = $this->input->post('id', true);
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $whr = "";
        $permission = checkuserpermissions();
        if(in_array("businesspartners", $permission)){
            $xborderdetails  = $this->db->select( "xborder_code" )->get_where( "tb_xborder_country", array( 'company_code' => $company_code ) );
			if ( $xborderdetails->num_rows() > 0 ) {
				 $xborder_code= $xborderdetails->row()->xborder_code;
				 if($xborder_code!=""){
					$xborder_company=explode(",",$xborder_code);
					$whr = " AND p.company_code IN ('" . $company_code . "','" . implode( "','", $xborder_company ) . "')";
				 }else{
					$whr = " AND p.company_code LIKE '" . $company_code . "' ";
				 }
			}else{
				$whr = " AND p.company_code LIKE '" . $company_code . "' ";
			}
        } else {
            $whr = " AND p.user_id='" . $user_id . "' ";
        }
        $chkqry = $this->db->query("SELECT p.id,p.party_type_id,p.name,p.email,p.street,p.location_id as city,p.state,p.mobile,p.address,p.pincode,p.country,p.code,p.fax FROM tbl_party_master p WHERE p.status=1 AND p.code LIKE '" . $code . "' " . $whr . " ORDER BY p.id DESC");
        if ($chkqry->num_rows() > 0) {
            $role_name = "";
            $getrolename = $this->db->select('name')->get_where("tbl_party_types", array(
                'id' => $chkqry->row()->party_type_id
            ));
            if ($getrolename->num_rows() > 0) {
                $role_name = $getrolename->row()->name;
            }
            $parties[] = array(
                'id' => $chkqry->row()->id,
                'name' => $chkqry->row()->name,
                'phone' => $chkqry->row()->mobile,
                'street' => $chkqry->row()->street,
                'city' => $chkqry->row()->city,
                'pincode' => $chkqry->row()->pincode,
                'code' => $chkqry->row()->code,
                'country' => $chkqry->row()->country,
                'email_id' => $chkqry->row()->email,
                'fax' => $chkqry->row()->fax,
                'state' => $chkqry->row()->state,
                'address' => $chkqry->row()->address,
                'party_type_id' => $chkqry->row()->party_type_id,
                'role_name' => $role_name
            );
        }
        echo json_encode($parties);
    }

    public function getpartydetailsListbyID() {
        $parties = $post = array();
        $post = $this->input->post(NULL, TRUE);
        $code = $this->input->post('id', true);
        $type = isset($post['type']) ? $post['type'] : "";
        $user_id = $this->session->userdata('user_id');
        $company_code = $branch_code = $whr = "";
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $whr = "";
        if ($company_code != "") {
            $whr .= " AND m.company_code LIKE '" . $company_code . "'";
        }
        $custid = "0";
        $whr1 = "";
        if ($company_code != 'NZKN') {
            if ($this->session->userdata('cust_id') !== FALSE) {
                $custid = $this->session->userdata('cust_id');
            }
            $subcusts = array();
            if ($custid != 0) {
                if ($this->session->userdata('sub_cust') !== FALSE) {
                    $subcusts = $this->session->userdata('sub_cust');
                    if (count($subcusts) > 0) {
                        array_push($subcusts, $custid);
                    } else {
                        $subcusts = $custid;
        // array_push($subcusts, $custid);
                    }
                } else {
                    $subcusts = $custid;
    // array_push($subcusts, $custid);
                }
            }
            $customer_code = array();
            if (!empty($subcusts)) {
                $select = "code";
                $table = "tb_customers";
                $customerdetails = $this->smtcorder->getcustomercodebyids($select, $table, $subcusts);
                if (!empty($customerdetails)) {
                    foreach ($customerdetails as $cust) {
                        $customer_code[] = $cust['code'];
                    }
                }
            }
            if (!empty($customer_code)) {
                $whr1 = "AND m.customer_code IN ('" . implode("','", $customer_code) . "') ";
            }
        }
        $chkqry = $this->db->query("SELECT m.id,m.name,m.email,m.street,m.location_id as city,m.state,m.mobile,m.address,m.country,m.pincode,m.country,m.code,m.company_code,m.branch_code,m.location_id as city,m.country,m.street,m.fax,t.id as partytype_id,t.name as role FROM tbl_party_master m,tbl_party_types t WHERE m.code LIKE '%" . $code . "%' " . $whr . " AND m.code Is NOT NULL AND m.code != '0' AND m.code != '' " . $whr1 . " AND t.id=m.party_type_id AND m.company_code != '' AND m.company_code IS NOT NULL AND m.branch_code != '' AND m.branch_code IS NOT NULL GROUP BY m.id ORDER BY m.id DESC");

        if ($chkqry->num_rows() > 0) {
            foreach ($chkqry->result() as $res) {
                $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->id . "' class='consigneelist' onchange='selectparty(" . $res->id . ")' value='" . $res->code . "'>";
                if ($type == 'inv') {
                    $check = "<input type='radio' name='partylist' id='partylist_" . $res->id . "' class='partylist' onchange='selectparty(" . $res->id . ")' value='" . $res->code . "'>";
                } else {
                    $check = "<input type='radio' name='consigneelist' id='consigneelist_" . $res->id . "' class='consigneelist' onchange='selectparty(" . $res->id . ")' value='" . $res->code . "'>";
                }
                $parties[] = array(
                    'check' => $check,
                    'id' => $res->code,
                    'name' => $res->name,
                    'email' => $res->email,
                    'mobile' => $res->mobile,
                    'party_name' => $res->role,
                    'company_code' => $res->company_code,
                    'branch_code' => $res->branch_code,
                    'city' => $res->city,
                    'country' => $res->country,
                    'street' => $res->street
                );
            }
        }
        echo json_encode($parties);
    }

    public function getchargedesc($id) {
        $data['desc'] = "";
        if ($id != "") {
            $getdesc = $this->db->query("SELECT description FROM tb_charge_codes WHERE id=$id AND status=1");
            if ($getdesc->num_rows() > 0) {
                $data['desc'] = $getdesc->row()->description;
            }
        }
        echo json_encode($data);
    }

    /* code for trip management */

    public function gettripcarinfo($id) {
        $result = array();
        if ($id != "") {
            $vendor_list = $this->db->select("code")->get_where("tb_vendors", array(
                'id' => $id
            ));
            if ($vendor_list->num_rows() > 0) {
                $result['carrier_name'] = $vendor_list->row()->code;
            }

			$this->db->select('tpm.acon_debitor_code');
			$this->db->from('tbl_party_master tpm');
            $this->db->join("tb_vendors tv", "tv.code=tpm.code and tv.company_code=tpm.company_code", "LEFT");
			$this->db->where(array("tv.id" => $id,"tpm.status"=>"1"));
			$res = $this->db->get();
			$debtor_code=$res->row()->acon_debitor_code;
			if($debtor_code!=""){
				$debtor_code_status=0;
			}else{
				$debtor_code_status=1;
			}
			$result['debtor_code'] = $debtor_code_status;

			$this->db->select("ttt.id,ttt.trucktype");
			$this->db->from("tb_trucks_data ttd");
			$this->db->join("tb_trucktypes ttt", "ttd.truck_type=ttt.id", "LEFT");
			$this->db->where(array("ttd.vendor_id" => $id,"ttd.status"=>"Active" ));
			$this->db->group_by('ttt.id');
			$this->db->order_by('ttt.id', 'DESC');
			$res = $this->db->get();
			$vehicles='<option value="">-Select-</option>';
			if ($res->num_rows() > 0) {
				foreach ($res->result() as $veh) {
					$vehicles .= '<option value="' . $veh->id . '">' . $veh->trucktype . '</option>';
				}
			}
			$result['vehicle_type'] = $vehicles;

        }
        echo json_encode($result);
    }

    public function gettripvelinfo() {
        $result = $post = array();
        $post = $this->input->post(NULL, TRUE);
// $post = $this->input->post();
        $id = $post['vtype'];
        $carrierid = $post['carrierid'];
        $res = '';
        $vtypename = $this->db->select("description")->get_where("tb_trucktypes", array(
            'id' => $id
        ));
        if ($vtypename->num_rows() > 0) {
            $res = $vtypename->row()->description;
        }
        $result['typename'] = $res;
        $vehres = '<select name="tvehnum" id="tvehnum" onchange="myfun()"
        form="tripcreation" class="Txtfld tripcar_id form-control" style="margin-top:4px;"><option value="">--Select--</option>';
        $vehile_list = $this->db->select("id,truck_number,register_number")->get_where("tb_trucks_data", array(
            'truck_type' => $id,
            'vendor_id' => $carrierid,
			'status'=> "Active"
        ));
        /* $vehile_list = $this->db->select("select td.id,td.truck_number,td.register_number from tb_trips tp,tb_trucks_data td where tp.vehicle_id=td.id and tp.transit_status=0 and td.truck_type='".$id."' AND td.vendor_id='".$carrierid."'"); */
        if ($vehile_list->num_rows() > 0) {
            foreach ($vehile_list->result() as $vehi) {
                $vehres .= '<option value="' . $vehi->id . '">' . $vehi->truck_number . '</option>';
            }
        }
        $vehres .= '</select>';
        $result['vehiclenum'] = $vehres;
        echo json_encode($result);
    }

    public function getvelinfo($id) {
        $result = array();
        $result['transit'] = 0;
        if ($id != "") {
            $vendor_list = $this->db->select("truck_number")->get_where("tb_trucks_data", array(
                'id' => $id
            ));
            if ($vendor_list->num_rows() > 0) {
                $result['vehid'] = $vendor_list->row()->truck_number;
            }

            if (NULL !== $this->session->userdata("company_code") && !in_array($this->session->userdata("company_code"), ["SGKN","MYKN"])) {
                $trip_transit = $this->db->select("id")->get_where("tb_trips", array(
                    'vehicle_id' => $id,
                    'status' => 1
                ));
                if ($trip_transit->num_rows() > 0) {
                    $result['vehid'] = '';
                    $result['transit'] = 1;
                }
            }

        }
        echo json_encode($result);
    }

    public function getorderlistspec() {
        $user_id = $this->session->userdata('user_id');
        $childid = $this->session->userdata('childid');
        if ($childid == '') {
            $childid = 0;
        }
        $res = array();
        $result = array();

        $this->db->select("osc.id,osc.ord_id, osc.created_date, osc.delivery_note, osc.salog_ref,osc.pq_ref, osc.pickup, osc.delivery, osc.trip_no, osc.other_status, osc.pickup_date, osc.estimated_delivery_date, osc.delivery_date, osc.mode_of_transport, osc.total_packages, osc.billing_status, osc.actual_weight, osc.weight, osc.actual_volume, osc.volume, osc.company_code, osc.branch_code, osc.from_source, osc.status, osc.external_customer");
        $this->db->from("tb_orderlist_spec_cols osc");
        $this->db->join("tb_users u", "osc.user_id = u.id", "LEFT");
        $where = "osc.user_id = $user_id and osc.childid = $childid and osc.is_active = 1 ";
        $this->db->where($where);
        $res = $this->db->get();

        $data["columns"] = $columns = array('ord_id' => "Booking ID", 'delivery_note' => "Delivery Note",'salog_ref'=>"SALOG Reference",'pq_ref'=>"Payment Reference",'pickup' => "Pickup", 'delivery' => "Delivery", 'trip_no' => "Trip No.", 'status' => "Status", 'other_status' => "Other Status", 'created_date' => "Created Date", 'pickup_date' => "Pickup Date", 'estimated_delivery_date' => "Estimated Delivery Date", 'delivery_date' => "Delivery Date", 'mode_of_transport' => "Mode Of Transport", 'total_packages' => "Total Packages", 'billing_status' => "Billing Status", 'actual_weight' => "Actual Weight", 'weight' => "Weight", 'actual_volume' => "Actual Volume", 'volume' => "Volume", 'company_code' => "Company Code", 'branch_code' => "Branch Code", 'from_source' => "From Source", 'external_customer' => "External Customer");
        if ($res->num_rows() > 0) {
            $result = $res->row_array();
        }
        $not_selected_colum = $selected_colum = [];
        if (!empty($result)) {
            foreach ($columns as $key => $value) {
                $col_val = explode("_", $result[$key]);
// print_r($col_val);echo $key;
                if (isset($col_val[0])) {
                    if ($col_val[0] == 0) {
                        array_push($not_selected_colum, $col_val[2]);
                    }
                    array_push($selected_colum, $col_val[1] + 1);
                }
            }
        }


        $obj['selected_colum'] = $selected_colum;
        $obj['not_selected_colum'] = $not_selected_colum;
        echo json_encode($obj);
    }

    public function getdriverid($id) {
        $res = '';
        if ($id != "") {
            $driver_list = $this->db->select("contact_num")->get_where("tb_truck_drivers", array(
                'id' => $id
            ), 1, 0);
            if ($driver_list->num_rows() > 0) {
                $res = $driver_list->row()->contact_num;
            }
        }
        echo $res;
    }

    public function tripcreatemultiorder($ordInput)
    {
        $response = 0;
        $orders = $this->common->gettbldata(" id IN(" . $ordInput['ordid'] . ")", "*", "tb_orders", 0, 0);
        for ($i = 0; $i < count($orders); $i++) {
            $orders[$i]['total_weight'] = $orders[$i]['weight'];
        }
        $response = $this->tripcreatefromorders->createMultiTripFromOrdersPage($orders, $ordInput);
        foreach ($orders as $eachOrder) {
            $this->ordernotify('trip_create', $eachOrder['id']);
        }
        return $response;
    }

public function triporderintoshipment() {
    $response = 0;
    $userid = $this->session->userdata('user_id');
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
    $curdt = $getactual['datetime'];
    $input = $this->input->post(NULL, TRUE);
    /* $shipid = $input['ship_id']; */
    /* trip id generation */
    $error_msg = "";
    $edi_res = array();
    $input['user_id'] = $userid;
    $input['curtz'] = $curtz;
    $input['curdt'] = $curdt;
    $input['company_code'] = $this->session->userdata('company_code');
    $input['branch_code'] = $this->session->userdata('branch_code');
    $ordeschk = explode(",", $input['ordid']);
    if (count($ordeschk) > 1) {
        if ($input['trip_type'] == 'multi') {
            $response = $this->tripcreatemultiorder($input);
        } else {
            $getref = $this->db->query("SELECT GROUP_CONCAT(order_id) as orders FROM tb_order_references WHERE order_id IN(" . $input['ordid'] . ") AND reference_id='ROT' AND status=1 GROUP BY ref_value");
            /* log_message("error","0th ".$this->db->last_query()); */
            if ($getref->num_rows() > 0) {
                foreach ($getref->result_array() as $reford) {
                    $input['ordid'] = $reford['orders'];
                    $response = $this->tripcreatemultiorder($input);
                }
            } else {
                $response = $this->eachordercreatetrip($input);
            }
        }
    } else {
        $response = $this->eachordercreatetrip($input);
    }
	$booking=array();
	$orderlist = explode(",", $input['ordid']);
	$ordertest=$this->db->query("select order_id from tb_orders where id IN (" . implode( ',', $orderlist ) . ")");
	if ($ordertest->num_rows() > 0) {
		foreach ($ordertest->result_array() as $ordlist) {
			$booking[] = $ordlist['order_id'];
		}
	}

	 $this->session->set_flashdata('booking',$booking);
    $this->ratemanagement->addrecodfortripinsertion($input);
    if ($response == 1) {
        $this->session->set_flashdata('success_msg', 'Trip Created Successfully.');
    } else if ($response == 2) {
        $this->session->set_flashdata('error_msg', 'Your selected orders are not in same root.(example: Ref. ID (ROT))');
    } else {
        $this->session->set_flashdata('error_msg', 'Oops..Something Went Wrong.');
    }
    if (!empty($error_msg)) {
        $this->session->set_flashdata('edierror_msg', $error_msg);
    }

  redirect('smtcorders');
}

    public function eachordercreatetrip($ordInput)
    {
        $response = 0;
        $ordesChk = explode(",", $ordInput['ordid']);
        foreach ($ordesChk as $chkOrd) {
            $order = $this->common->gettblrowdata(["id" => $chkOrd], "*", "tb_orders", 0, 0);
            if (!empty($order)) {
                $order['currentTime'] = $ordInput['curdt'];
                $order['total_weight'] = $order['weight'];
                if ($order['shift_id'] > 0) {
                    $this->session->set_flashdata('error_msg', 'Trip already created for this order. Please check details.');
                    redirect('orders');
                }
                $response = $this->tripcreatefromorders->createTripFromOrdersPage($order, $ordInput);
                $this->ordernotify('trip_create', $order['id']);
                $orderDetails = $this->common->gettblrowdata(['id' => $order['id']], "id,vendor_id,shift_id", "tb_orders", 0, 0);
                if ($orderDetails && $orderDetails['shift_id'] > 0) {
                    if (checkAccessConditions('CHECK_DELHIVERY_LIMITED_CARRIER', $orderDetails['vendor_id'])) {
                        $this->load->library("DelhiveryB2BEDIServices");
                        $this->delhiveryb2bediservices->triggerDelhiveryAPI($orderDetails['shift_id']);
                    }
                }
            }
        }
        $this->load->helper('pushnotification_helper');
        mobilePushNotification($ordInput);
        return $response;
    }

public function printLabel($label) {
    ini_set('max_execution_time', '300');
    $pipaddr = '10.91.191.50';
    $pport = 9100;
    try {
        $labelpath = "./assets/swiftlog/docketlabel/" . $label;
        $newimgpath = './assets/swiftlog/eTNLabel.png';
        $im = new Imagick();
        $im->setResolution(180, 180);
        $im->readImage($labelpath);
        $im->setImageFormat('png');
        $im->setImageCompression(Imagick::COMPRESSION_JPEG);
        $im->setImageCompressionQuality(100);
        $im->writeImage($newimgpath);
        $im->clear();
        $im->destroy();
        $decoder = GdDecoder::fromPath($newimgpath);
        $image = new Image($decoder);
        $zpl = new Builder();
        $zpl->fo(10, 10)
        ->gf($image)
        ->fs();
        $client = new Client($pipaddr, $pport);
        $client->send($zpl);
    } catch (\Exception $e) {
        return $e->getMessage();
    }
}

/* code for trip management */

public function orderlabel($order_id) {
    if ($this->session->userdata('branch_code') == "INCL" && $order_id != "") {
        $this->load->library("uniqloediservices");
        $ordinfo = array("order_id" => $order_id);
        $refs = $this->common->gettblrowdata(array("order_id" => $order_id, "reference_id" => 'AWB', "ref_value <>" => '', "status" => 1), "id", "tb_order_references", 0, 0);
        if (count($refs) > 0) {
            $lbl = $this->uniqloediservices->generatedocketlabel($ordinfo);
            if ($lbl != "") {
                $chkprint = $this->printLabel($lbl);
            }
        }
    } else {
        $data = $order_types = array();
        require 'vendor/autoload.php';
        $reference = $shipmentnumber = $communication_reference = $date = "";
        $drop_details['name'] = $drop_details['street'] = $drop_details['country'] = $drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = $shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = $data['count'] = $data['weight'] = "";
        $cargos = $drop_details = $shipper_details = $order_type = array();
        if ($order_id != "") {
            if ($this->session->userdata('cust_id') == TRUE) {
                $upd_orderstatus = $this->db->where(array(
                    'id' => $order_id
                ))->update("tb_orders", array(
                    'order_status' => 'READY'
                ));
            }
            $chkorder = $this->smtcorder->getordertoedit($order_id);
            if ($chkorder->num_rows() > 0) {
                $date = $chkorder->row()->pickup_datetime;
                $shipmentnumber = $chkorder->row()->order_id;
                $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='" . $order_id . "' AND reference_id IN ('DQ','PO')");
                if ($getdnote->num_rows() > 0) {
                    foreach ($getdnote->result() as $ref) {
                        $ref_id = $ref->reference_id;
                        if ($ref_id == 'DQ') {
                            $reference = $ref->ref_value;
                        }
                        if ($ref_id == 'PO') {
                            $communication_reference = $ref->ref_value;
                        }
                    }
                }
                $drop_id = $chkorder->row()->drop_custid;
                $drop_row_id = 0;
                $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type");
                if ($chekparty->num_rows() > 0) {
                    foreach ($chekparty->result() as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
                            "id" => $ptype
                        ), 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = array(
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                );
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = array(
                                    'id' => $rr->id,
                                    'name' => $rr->name,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'fax' => $rr->fax,
                                    'party_id' => $rr->code
                                );
                            }
                        }
                    }
                }
                $ordertype = $chkorder->row()->order_type;
                if ($ordertype != "" || $ordertype != null) {
                    $chktype = $this->db->select("type_name")->get_where("tb_order_types", array(
                        "id" => $ordertype
                    ), 1, 0);
                    if ($chktype->num_rows() > 0) {
                        $order_type['name'] = $chktype->row()->type_name;
                    }
                }
                $data['order_type'] = $order_type;
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;

                $qry = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $order_id . "' AND o.cargo_id=c.id AND o.status='1' GROUP BY c.id ORDER BY c.id DESC");
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $units = $res->weight_unit;
                        if ($units == "") {
                            $units = "Kg";
                        }
                        $qty = $res->quantity;
                        $wt = @round(($res->weight / $qty), 2);
                        for ($i = 1; $i <= $qty; $i++) {
                            $cargos[] = array(
                                'id' => $res->id,
                                'weight' => $wt . " " . $units
                            );
                        }
                    }
                }
            }
            $data['drop_details'] = $drop_details;
            $data['shipper_details'] = $shipper_details;
            $data['reference'] = $reference;
            $data['shipmentnumber'] = $shipmentnumber;
            $data['communication_reference'] = $communication_reference;
            if ($date != "") {
                $timestamp = strtotime($date);
                $data['date'] = date('d M Y', $timestamp);
            } else {
                $data['date'] = $date;
            }
            $data['cargos'] = $cargos;
            $ordernumber = $chkorder->row()->order_id;
            $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'format' => [
                    100,
                    110
                ],
                'margin_left' => 0,
                'margin_right' => 0,
                'margin_top' => 0,
                'margin_bottom' => 0,
                'margin_header' => 0,
                'margin_footer' => 0
            ]);
            $html = "";
            $i = 1;
            $data['count'] = count($cargos);
            foreach ($cargos as $cargo) {
                $data['weight'] = $cargo['weight'];
                $data['no'] = $i;
                $html .= $this->load->view('smtcorders/orderlabel', $data, TRUE);
                //$mpdf->WriteHTML($html);
                $i++;
            }
            $shipment_name = "BOXES";
            $customer_phone = $customer_email = $booking_id = $shift_id = "";
            $getorderdetails = $this->common->gettblrowdata(array(
                'id' => $order_id
            ), "id,order_id,pickup_datetime,delivery_datetime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,transport_mode,customer_id,plat,plng,dlat,dlng,shift_id", 'tb_orders', 0, 0);
            if (!empty($getorderdetails)) {
                $customer_id = $getorderdetails['customer_id'];
                $booking_id = $getorderdetails['order_id'];
                $shift_id = $getorderdetails['shift_id'];
                if ($shift_id == '0' || $shift_id == "") {
                    $total_weight = $total_volume = $total_quantity = 0;
                    $getordercargototaldetails = $this->common->gettblrowdata(array(
                        'order_id' => $order_id,
                        'status' => '1'
                    ), "sum(weight) as total_weight,sum(second_weight) as second_weight,sum(volume) as total_volume,sum(second_volume) as second_volume,sum(quantity) as quantity", "tb_order_cargodetails", 0, 0);
                    if (!empty($getordercargototaldetails)) {
                        $total_weight = $getordercargototaldetails['total_weight'];
                        $total_volume = $getordercargototaldetails['total_volume'];
                        $total_quantity = $getordercargototaldetails['quantity'];
                    }
                    if ($order_id != "" && $customer_id != "") {
                        $getcustomerdetils = $this->common->gettblrowdata(array(
                            'id' => $customer_id
                        ), "phone,email_id", "tb_customers", 0, 0);
                        if (!empty($getcustomerdetils)) {
                            $customer_email = $getcustomerdetils['email_id'];
                            $customer_phone = $getcustomerdetils['phone'];
                        }
                        $company_code = $this->session->userdata('company_code');
                        $branch_code = $this->session->userdata('branch_code');
                        $orderinfo['company_code'] = $company_code;
                        $orderinfo['branch_code'] = $branch_code;
                        $orderinfo['order_id'] = $booking_id;
                        $orderinfo['pickup_company'] = $getorderdetails['pickup_company'];
                        $orderinfo['plat'] = $getorderdetails['plat'];
                        $orderinfo['plng'] = $getorderdetails['plng'];
                        $orderinfo['dlat'] = $getorderdetails['dlat'];
                        $orderinfo['dlng'] = $getorderdetails['dlng'];
                        $orderinfo['pickup_datetime'] = $getorderdetails['pickup_datetime'];
                        $orderinfo['delivery_datetime'] = $getorderdetails['delivery_datetime'];
                        $orderinfo['customer_id'] = $getorderdetails['customer_id'];
                        $orderinfo['transport_mode'] = $getorderdetails['transport_mode'];
                        $pickupinfo['country'] = $orderinfo['pickup_country'] = trim($getorderdetails['pickup_country']);
                        $pickupinfo['order_country'] = trim($getorderdetails['pickup_country']);
                        $pickupinfo['order_city'] = $orderinfo['pickup_city'] = trim($getorderdetails['pickup_city']);
                        $pickupinfo['order_zipcode'] = $orderinfo['pickup_pincode'] = trim($getorderdetails['pickup_pincode']);
                        $pickupinfo['state'] = $orderinfo['pickup_address2'] = trim($getorderdetails['pickup_address2']);
                        $pickupinfo['city'] = $orderinfo['pickup_city'] = trim($getorderdetails['pickup_city']);
                        $pickupinfo['region'] = $orderinfo['pickup_address1'] = trim($getorderdetails['pickup_address1']);
                        $pickupinfo['zipcode'] = $orderinfo['pickup_pincode'] = trim($getorderdetails['pickup_pincode']);

                        $pickupinfo['stoptype'] = "P";
                        $dropinfo['country'] = trim($getorderdetails['delivery_country']);
                        $dropinfo['order_country'] = $orderinfo['delivery_country'] = trim($getorderdetails['delivery_country']);
                        $dropinfo['order_city'] = $orderinfo['delivery_city'] = trim($getorderdetails['delivery_city']);
                        $dropinfo['order_zipcode'] = $orderinfo['delivery_pincode'] = trim($getorderdetails['delivery_pincode']);
                        $dropinfo['state'] = $orderinfo['delivery_address2'] = trim($getorderdetails['delivery_address2']);
                        $dropinfo['city'] = $orderinfo['delivery_city'] = trim($getorderdetails['delivery_city']);
                        $dropinfo['region'] = $orderinfo['delivery_address1'] = trim($getorderdetails['delivery_address1']);
                        $dropinfo['zipcode'] = $orderinfo['delivery_pincode'] = trim($getorderdetails['delivery_pincode']);
                        $dropinfo['stoptype'] = "D";
                        $pickupgeocode = checkgeocode($pickupinfo);
                        $dropgeocode = checkgeocode($dropinfo);
                        if (!empty($pickupgeocode) && !empty($dropgeocode)) {
                            $pickupgeocode['stoptype'] = "P";
                            $dropgeocode['stoptype'] = "D";
                            $pickupgeocode['order_country'] = trim($getorderdetails['pickup_country']);
                            $pickupgeocode['order_city'] = trim($getorderdetails['pickup_city']);
                            $pickupgeocode['order_zipcode'] = trim($getorderdetails['pickup_pincode']);
                            $dropgeocode['order_country'] = trim($getorderdetails['delivery_country']);
                            $dropgeocode['order_city'] = trim($getorderdetails['delivery_city']);
                            $dropgeocode['order_zipcode'] = trim($getorderdetails['delivery_pincode']);
                            $pickuproute = getcust_routeautomate($customer_id, $pickupgeocode);
                            $droproute = getcust_routeautomate($customer_id, $dropgeocode);
                            if (!empty($pickuproute) && !empty($droproute)) {
                                $orderinfo['id'] = $order_id;
                                $orderinfo['order_id'] = $booking_id;
                                $orderinfo['shipment_name'] = $shipment_name;
                                $orderinfo['customer_phone'] = $customer_phone;
                                $orderinfo['customer_email'] = $customer_email;
                                $orderinfo['volume'] = $total_volume;
                                $orderinfo['weight'] = $total_weight;
                                $orderinfo['quantity'] = $total_quantity;
                                $orderinfo['quantity'] = $total_quantity;
                                $shipment = createshipmentbyorder($pickuproute, $orderinfo);
                            } else {
                                $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                                $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                                if (!empty($pickuproute1) && !empty($droproute1)) {
                                    $orderinfo['id'] = $order_id;
                                    $orderinfo['order_id'] = $booking_id;
                                    $orderinfo['shipment_name'] = $shipment_name;
                                    $orderinfo['customer_phone'] = $customer_phone;
                                    $orderinfo['customer_email'] = $customer_email;
                                    $orderinfo['volume'] = $total_volume;
                                    $orderinfo['weight'] = $total_weight;
                                    $orderinfo['quantity'] = $total_quantity;
                                    $orderinfo['quantity'] = $total_quantity;
                                    $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                                }
                            }
                        } else {
                            $pickuproute1 = getcust_routeautomate($customer_id, $pickupinfo);
                            $droproute1 = getcust_routeautomate($customer_id, $dropinfo);
                            if (!empty($pickuproute1) && !empty($droproute1)) {
                                $orderinfo['id'] = $order_id;
                                $orderinfo['order_id'] = $booking_id;
                                $orderinfo['shipment_name'] = $shipment_name;
                                $orderinfo['customer_phone'] = $customer_phone;
                                $orderinfo['customer_email'] = $customer_email;
                                $orderinfo['volume'] = $total_volume;
                                $orderinfo['weight'] = $total_weight;
                                $orderinfo['quantity'] = $total_quantity;
                                $shipment = createshipmentbyorder($pickuproute1, $orderinfo);
                            }
                        }
                    }
                }
            }
            $data1['labelcontent'] = $html;
            $output = $this->load->view('smtcorders/order_label', $data1, TRUE);
            $mpdf->WriteHTML($output);
            $mpdf->Output($ordernumber . "_" . date('YmdHis') . ".pdf", 'D');
        }
    }
}

public function getorderdetails($order_id) {
    if ($order_id != "") {
        $cdate = date('Y-m-d H:i:s');
        $chkorder = $this->smtcorder->getordertoedit($order_id);
        $tripsts = "Pending";
        $order_status = "PENDING";
        if ($chkorder->num_rows() > 0) {
            $status = $chkorder->row()->status;
            $trip_sts = $chkorder->row()->trip_sts;
            $trip_id = $chkorder->row()->trip_id;
            if ($trip_id != 0 && $trip_sts == 0) {
                $order_status = 'ACTIVE';
                $tripsts = 'ACTIVE';
            }
            if ($trip_id != 0 && $trip_sts == 1) {
                $order_status = 'ACTIVE';
                $tripsts = 'ACTIVE';
            }
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $createdon = $chkorder->row()->createdon;
            $updatedon = $chkorder->row()->updatedon;
// $getactual = getdatetimebytimezone($curtz,$createdon,DFLT_TZ);
            $curdt = $cdate;
            /* $curdt = $getactual['datetime']; */
// $getactual = getdatetimebytimezone($curtz,$updatedon,DFLT_TZ);
            $upddt = $cdate;
            /* $upddt = $getactual['datetime']; */
            $parties = array();
            $vendor_id = $chkorder->row()->vendor_id;
            if ($vendor_id != 0) {
                $getvendor = $this->db->query("SELECT name,mobile,location,address,pincode,country,email,code FROM tb_vendors where id ='" . $vendor_id . "'");
                if ($getvendor->num_rows() > 0) {
                    $vendordetails = array(
                        'name' => $getvendor->row()->name,
                        'party_id' => $getvendor->row()->code,
                        'address' => $getvendor->row()->address,
                        'pincode' => $getvendor->row()->pincode,
                        'country' => $getvendor->row()->country,
                        'street' => "",
                        'city' => $getvendor->row()->location,
                        'state' => "",
                        'phone' => $getvendor->row()->mobile,
                        'email' => $getvendor->row()->email
                    );
                }
            }
            $pickup_id = $chkorder->row()->customer_id;
            $getpickupdetails = $this->db->query("SELECT name,phone,state,street,location,pincode, address, email_id, code,country FROM tb_customers WHERE id='" . $pickup_id . "' AND status=1 LIMIT 1");
            if ($getpickupdetails->num_rows() > 0) {
                $customerdetails = array(
                    'name' => $getpickupdetails->row()->name,
                    'party_id' => $getpickupdetails->row()->code,
                    'address' => $getpickupdetails->row()->address,
                    'pincode' => $getpickupdetails->row()->pincode,
                    'country' => $getpickupdetails->row()->country,
                    'street' => $getpickupdetails->row()->street,
                    'city' => $getpickupdetails->row()->location,
                    'state' => $getpickupdetails->row()->state,
                    'phone' => $getpickupdetails->row()->phone,
                    'email' => $getpickupdetails->row()->email_id
                );
            }
            $consignee_mobile = $consignor_mobile = $shipper_mobile = $carrier_mobile = "";
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code, p.location_id, p.address, p.country,p.state, p.street, p.pincode, o.party_type, a.party_master_id, a.location_id as plocation_id,a.street as pstreet,a.state as pstate,a.address as paddress,a.pincode as ppincode,a.country as pcountry FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1 LEFT JOIN tbl_orderparty_address a ON o.party_id=a.party_master_id AND o.order_id=a.order_id AND a.status=1 WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type");
            if ($chekparty->num_rows() > 0) {
                foreach ($chekparty->result() as $rr) {
                    $pdetail = array();
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
                        "id" => $ptype
                    ), 1, 0);
                    if ($chktype->num_rows() > 0) {
                        if ($rr->party_master_id != "") {
                            $pdetail = array(
                                'name' => $rr->name,
                                'party_id' => $rr->code,
                                'address' => $rr->paddress,
                                'pincode' => $rr->ppincode,
                                'country' => $rr->pcountry,
                                'street' => $rr->pstreet,
                                'city' => $rr->plocation_id,
                                'state' => $rr->pstate,
                                'phone' => $rr->mobile,
                                'email' => $rr->email
                            );
                        } else {
                            $pdetail = array(
                                'name' => $rr->name,
                                'party_id' => $rr->code,
                                'address' => $rr->address,
                                'pincode' => $rr->pincode,
                                'country' => $rr->country,
                                'street' => $rr->street,
                                'city' => $rr->location_id,
                                'state' => $rr->state,
                                'phone' => $rr->mobile,
                                'email' => $rr->email
                            );
                        }
                        if ($chktype->row()->name == "Consignee") {
                            $pdetail['type'] = "Consignee";
                            $consignee_mobile = $rr->mobile;
                        }
            /*
             * if($chktype->row()->name == "CUSTOMER"){
             * $pdetail['type'] = "Customer";
             * }
             */
            if ($chktype->row()->name == "Consignor") {
                $pdetail['type'] = "Consignor";
                $consignor_mobile = $rr->mobile;
            }
            /*
             * if($chktype->row()->name == "FREIGHT_PAYER"){
             * $pdetail['type'] = "FREIGHT_PAYER";
             * }
             */
            if ($chktype->row()->name == "Shipper") {
                $pdetail['type'] = "Shipper";
                $shipper_mobile = $rr->mobile;
            }
            if ($chktype->row()->name == "Carrier") {
                $pdetail['type'] = "Carrier";
                $carrier_mobile = $rr->mobile;
            }
            $parties[] = $pdetail;
        }
    }
}
$code = "";
$areacodes = array(
    "1",
    "2",
    "3",
    "10",
    "11",
    "12",
    "673",
    "653",
    "645",
    "644",
    "635",
    "629",
    "628",
    "627",
    "624",
    "6",
    "5",
    "4",
    "29",
    "28",
    "27",
    "26",
    "25",
    "24",
    "23",
    "22",
    "21",
    "20",
    "19",
    "18",
    "17",
    "16",
    "15",
    "14",
    "13",
    "675",
    "676",
    "677",
    "678",
    "7",
    "8",
    "9"
);
$zonecode = $this->session->userdata("usr_tzone");
$currency = isset($zonecode['currency']) ? $zonecode['currency'] : "SGD";
$company_code = $this->session->userdata("company_code");
$branch_code = $this->session->userdata("branch_code");
if (isset($zonecode['phone_code'])) {
    $code = $zonecode['phone_code'];
} else {
    if ($company_code == "THKN") {
        $code = "66";
    }
    if ($company_code == "SGKN") {
        $code = "65";
    }
    if ($company_code == "INKN") {
        $code = "91";
    }
}
$cargos = array();
$total_volume = $total_weight = 0;
$getcargos = $this->db->query("select handling_unit,length,width,height,weight,volume,quantity,quantity_type,cargo_content from tb_order_cargodetails where order_id ='" . $order_id . "'");
if ($getcargos->num_rows() > 0) {
    foreach ($getcargos->result() as $res) {
        $volume = $res->volume;
        $weight = $res->weight;
        if ($volume == "") {
            $volume = 1;
        }
        if ($weight == "") {
            $weight = 1;
        }
        $cargos[] = array(
            'cargo_type' => $res->quantity_type,
            'content' => $res->cargo_content,
            'length' => $res->length,
            'width' => $res->width,
            'height' => $res->height,
            'weight' => $weight,
            'volume' => $volume,
            'quantity' => $res->quantity
        );
        $total_volume += $volume;
        $total_weight += $weight;
    }
}
if ($chkorder->row()->company_code != "") {
    $company_code = $chkorder->row()->company_code;
}
if ($chkorder->row()->branch_code != "") {
    $branch_code = $chkorder->row()->branch_code;
}
$shipperdetail = $vendordetails = $consignedetail = $consignordetail = $pfdetails = $customerdetails = array();
$cncontact = $consignee_mobile;
$cacontact = $consignor_mobile;
if ($cacontact == "") {
    $cacontact = $shipper_mobile;
}
$data = array(
    'SenderTransmissionNo' => $chkorder->row()->order_id,
    'order_status' => $order_status,
    'pickup_datetime' => $chkorder->row()->pickup_datetime,
    'delivery_datetime' => $chkorder->row()->delivery_datetime,
    'pickup_endtime' => $chkorder->row()->pickup_endtime,
    'delivery_endtime' => $chkorder->row()->drop_endtime,
    'createdon' => $curdt,
    "delivery_company" => $chkorder->row()->delivery_company,
    'delivery_contact' => $cncontact,
    'delivery_city' => $chkorder->row()->delivery_city,
    'delivery_country' => $chkorder->row()->delivery_country,
    'delivery_address1' => $chkorder->row()->delivery_address1,
    'delivery_address2' => $chkorder->row()->delivery_address2,
    'delivery_pincode' => $chkorder->row()->delivery_pincode,
    'branch_code' => $branch_code,
    'company_code' => $company_code,
    'transport_mode' => $chkorder->row()->transport_mode,
    'pickup_country' => $chkorder->row()->pickup_country,
    'pickup_pincode' => $chkorder->row()->pickup_pincode,
    'country_code' => $code,
    "pickup_company" => $chkorder->row()->pickup_company,
    'pickup_contact' => $cacontact,
    'pickup_city' => $chkorder->row()->pickup_city,
    'pickup_address1' => $chkorder->row()->pickup_address1,
    'pickup_address2' => $chkorder->row()->pickup_address2,
    'cargos' => $cargos,
    'total_weight' => $total_weight,
    'total_volume' => $total_volume,
    'tripsts' => $tripsts,
    'ststime' => $upddt,
    "area_code" => $areacodes[1],
    "goods_value" => $chkorder->row()->goods_value,
    "currency" => $currency,
    "parties" => $parties
);
$this->generateorderxml($data);
}
}
}

public function generateorderxml($data) {
    $date = date('Y-m-d H:i:s');
    $timestamp = strtotime($date);
    $request = '';
    $request .= '<TransmissionMessage>';
    $request .= '<TransmissionHeader>';
    $request .= '<Version>1.0</Version>';
    $request .= '<UserName>INFD/PNQFD.INTEGRATION</UserName>';
    $request .= '<Password>ALLIANCE</Password>';
    $request .= '<SenderTransmissionNo>' . $timestamp . '_' . $data['SenderTransmissionNo'] . '</SenderTransmissionNo>';
    $request .= '<AckSpec>';
    $request .= '<ComMethodGid>transmission</ComMethodGid>';
    $request .= '<ComType>';
    $request .= '<Url>https://elog360.app/svkonekt_test/api/v1/edi</Url>';
    $request .= '<EmailAddress>dummy@email.com</EmailAddress>';
    $request .= '</ComType>';
    $request .= '<AckOption>SUCCESS</AckOption>';
    $request .= '</AckSpec>';
    $request .= '<Source>ETN</Source>';
    $request .= '<Destination>' . $data['branch_code'] . '</Destination>';
    $request .= '<ReferenceId>' . $data['SenderTransmissionNo'] . '</ReferenceId>';
    $modetrans = "FTL";
    if (isset($data['transport_mode'])) {
        if ($data['transport_mode'] == "TL") {
            $modetrans = "FTL";
        } else {
            $modetrans = "LTL";
        }
    }
    $request .= '<ModeOfTransport>' . $modetrans . '</ModeOfTransport>';
    $request .= '<Action>BookingDetails</Action>';
    $request .= '</TransmissionHeader>';
    $request .= '<TransmissionBody>';
    $request .= '<InvolvedParties>';
    foreach ($data['parties'] as $ptype) {
        if (isset($ptype['type'])) {
            if ($ptype['type'] == "Shipper") {
                $request .= '<Shipper>';
            }
            if ($ptype['type'] == "Carrier") {
                $request .= '<Carrier>';
            }
            if ($ptype['type'] == "Consignor") {
                $request .= '<Consignor>';
            }
            if ($ptype['type'] == "Consignee") {
                $request .= '<Consignee>';
            }
            $request .= '<ID>' . $ptype['party_id'] . '</ID>';
            $request .= '<FirstName>' . $ptype['name'] . '</FirstName>';
            $request .= '<LastName>' . $ptype['name'] . '</LastName>';
            $request .= '<FullName>' . $ptype['name'] . '</FullName>';
            if ($ptype['type'] == "Shipper") {
                $request .= '<UserName>ratchanee.limwatthana@kuehne-nagel.com</UserName>';
                $request .= '<Password>$2a$11$7xOpu6cePv2sR4HrzWGyOui1evc5GyHE2/72UQjYK9OJOvIEyKZGW</Password>';
            }
            if ($ptype['type'] == "Carrier") {
                $request .= '<UserName>thananyas@jtclogistics.com</UserName>';
                $request .= '<Password>$2a$11$NrwvCZ2E9RTMdQJSlUGCT.Jeb13bKWkJP.HQ6pOdcSWjV74Y.18c2</Password>';
            }
            $request .= '<ContactNo>';
            $request .= '<CountryCode>' . $data['country_code'] . '</CountryCode>';
            $request .= '<AreaCode>' . $data['area_code'] . '</AreaCode>';
            $request .= '<ContactNo>' . $ptype['phone'] . '</ContactNo>';
            $request .= '</ContactNo>';
            $request .= '<Company>';
            $request .= '<Name>' . $data['pickup_company'] . '</Name>';
            $request .= '<ContactNo>+' . $data['country_code'] . '' . $data['area_code'] . '' . $ptype['phone'] . '</ContactNo>';
            $request .= '<RegistrationNumber>' . $ptype['party_id'] . '</RegistrationNumber>';
            $request .= '<EmailAddress>' . $ptype['email'] . '</EmailAddress>';
            $request .= '</Company>';
            $request .= '<Address>';
            $request .= '<Country>' . $ptype['country'] . '</Country>';
            $request .= '<City>' . $ptype['city'] . '</City>';
            $request .= '<Postal>' . $ptype['pincode'] . '</Postal>';
            $request .= '<Address1>' . $ptype['address'] . '</Address1>';
            $request .= '<Address2>' . $ptype['street'] . '</Address2>';
            $request .= '</Address>';
            if ($ptype['type'] == "Consignor") {
                $request .= '<Comments></Comments>';
            }
            if ($ptype['type'] == "Consignee") {
                $request .= '<Comments></Comments>';
            }
            if ($ptype['type'] == "Shipper") {
                $request .= '</Shipper>';
            }
            if ($ptype['type'] == "Carrier") {
                $request .= '</Carrier>';
            }
            if ($ptype['type'] == "Consignor") {
                $request .= '</Consignor>';
            }
            if ($ptype['type'] == "Consignee") {
                $request .= '</Consignee>';
            }
        }
    }
    $request .= '</InvolvedParties>';
/*
* $request .= '<VehicleDetails>';
* $request .= '<VehicleTypeCode>6WC</VehicleTypeCode>';
* $request .= '<VehicleModelCode>SIX_WHEELER</VehicleModelCode>';
* $request .= '<RegistrationNumber></RegistrationNumber>';
* $request .= '<License></License>';
* $request .= '<ApplicableForDangerousGoods></ApplicableForDangerousGoods>';
* $request .= '<CommodityType>6 Wheeler Cabinet</CommodityType>';
* $request .= '<Properties>';
* $request .= '</Properties>';
* $request .= '</VehicleDetails>';
*/
$request .= '<TripDetails>';
$request .= '<PickUp>';
$request .= '<Company>';
$request .= '<Name>' . $data['pickup_company'] . '</Name>';
$request .= '<ContactNo>' . $data['pickup_contact'] . '</ContactNo>';
$request .= '</Company>';
$request .= '<Address>';
$request .= '<Country>' . $data['pickup_country'] . '</Country>';
$request .= '<City>' . $data['pickup_city'] . '</City>';
$request .= '<Postal>' . $data['pickup_pincode'] . '</Postal>';
$request .= '<Address1>' . $data['pickup_address1'] . '</Address1>';
$request .= '<Address2>' . $data['pickup_address2'] . '</Address2>';
$request .= '</Address>';
$request .= '<DateTime>';
$request .= '<From>' . date("Y-m-d", strtotime($data['pickup_datetime'])) . 'T' . date("H:i:s", strtotime($data['pickup_datetime'])) . '.000</From>';
$request .= '<To>' . date("Y-m-d", strtotime($data['pickup_endtime'])) . 'T' . date("H:i:s", strtotime($data['pickup_endtime'])) . '.000</To>';
$request .= '</DateTime>';
$request .= '</PickUp>';
$request .= '<DropOff>';
$request .= '<Company>';
$request .= '<Name>' . $data['delivery_company'] . '</Name>';
$request .= '<ContactNo>' . $data['delivery_contact'] . '</ContactNo>';
$request .= '</Company>';
$request .= '<Address>';
$request .= '<Country>' . $data['delivery_country'] . '</Country>';
$request .= '<City>' . $data['delivery_city'] . '</City>';
$request .= '<Postal>' . $data['delivery_pincode'] . '</Postal>';
$request .= '<Address1>' . $data['delivery_address1'] . '</Address1>';
$request .= '<Address2>' . $data['delivery_address2'] . '</Address2>';
$request .= '</Address>';
$request .= '<DateTime>';
$request .= '<From>' . date("Y-m-d", strtotime($data['delivery_datetime'])) . 'T' . date("H:i:s", strtotime($data['delivery_datetime'])) . '.000</From>';
$request .= '<To>' . date("Y-m-d", strtotime($data['delivery_endtime'])) . 'T' . date("H:i:s", strtotime($data['delivery_endtime'])) . '.000</To>';
$request .= '</DateTime>';
$request .= '</DropOff>';
$request .= '</TripDetails>';
$request .= '<CargoDetails>';
$request .= '<CargoType>GENERAL CATEGORY</CargoType>';
$request .= '<ValueOfGoods>' . $data['goods_value'] . '</ValueOfGoods>';
$request .= '<Items>';
if (!empty($cargos)) {
    foreach ($cargos as $goods) {
        $request .= '<Item>';
        $request .= '<HandlingUnit>' . $goods['cargo_type'] . '</HandlingUnit>';
        $request .= '<Length>';
        $request .= '<Value>' . $goods['length'] . '</Value>';
        $request .= '<UOM>m</UOM>';
        $request .= '</Length>';
        $request .= '<Width>';
        $request .= '<Value>' . $goods['width'] . '</Value>';
        $request .= '<UOM>m</UOM>';
        $request .= '</Width>';
        $request .= '<Height>';
        $request .= '<Value>' . $goods['height'] . '</Value>';
        $request .= '<UOM>m</UOM>';
        $request .= '</Height>';
        $request .= '<Weight>';
        $request .= '<Value>' . $goods['weight'] . '</Value>';
        $request .= '<UOM>m</UOM>';
        $request .= '</Weight>';
        $request .= '<TotalVolume>';
        $request .= '<Value>' . $data['total_volume'] . '</Value>';
        $request .= '<UOM>cbm</UOM>';
        $request .= '</TotalVolume>';
        $request .= '<TotalWeight>';
        $request .= '<Value>' . $data['total_weight'] . '</Value>';
        $request .= '<UOM>kg</UOM>';
        $request .= '</TotalWeight>';
        $request .= '<Quantity>' . $data['quantity'] . '</Quantity>';
        $request .= '</Item>';
    }
}
$request .= '</Items>';
$request .= '</CargoDetails>';
$request .= '<Rate>';
$request .= '<BuyGroup>';
$request .= '<Freights>';
$request .= '<Freight>';
$request .= '  <FreightBuyRate>2000</FreightBuyRate>';
$request .= '<Description></Description>';
$request .= '<RateUnit>trip</RateUnit>';
$request .= '<Currency>' . $data['currency'] . '</Currency>';
$request .= '<RevisedFreightBuyRate></RevisedFreightBuyRate>';
$request .= '</Freight>';
$request .= '</Freights>';
$request .= '<Addons/>';
$request .= '</BuyGroup>';
$request .= '<SellGroup>';
$request .= '<Freights>';
$request .= '<Freight>';
$request .= '<FreightBuyRate>2000</FreightBuyRate>';
$request .= '<Description></Description>';
$request .= '<RateUnit>trip</RateUnit>';
$request .= '<Currency>' . $data['currency'] . '</Currency>';
$request .= '<KNMarginPercentage>25</KNMarginPercentage>';
$request .= '<KNMarginAbs></KNMarginAbs>';
$request .= '<SellPrice>2500</SellPrice>';
$request .= '</Freight>';
$request .= '</Freights>';
$request .= '<Addons/>';
$request .= '<Discount>500</Discount>';
$request .= '</SellGroup>';
$request .= '</Rate>';
$request .= '<Status>';
$request .= '<Shipper>';
$request .= '<StatusCode>READY_FOR_PICKUP</StatusCode>';
$request .= '<StatusValue>READY_FOR_PICKUP</StatusValue>';
$request .= '<DateTime>' . date("Y-m-d", strtotime($data['createdon'])) . 'T' . date("H:i:s", strtotime($data['createdon'])) . '.049Z</DateTime>';
$request .= '</Shipper>';
$request .= '<Carrier>';
$request .= '<StatusCode>READY_FOR_PICKUP</StatusCode>';
$request .= '<StatusValue>READY_FOR_PICKUP</StatusValue>';
$request .= '<DateTime>' . date("Y-m-d", strtotime($data['createdon'])) . 'T' . date("H:i:s", strtotime($data['createdon'])) . '.049Z</DateTime>';
$request .= '</Carrier>';
$request .= '<Booking>';
$request .= '<StatusCode>' . $data['tripsts'] . '</StatusCode>';
$request .= '<StatusValue>' . $data['tripsts'] . '</StatusValue>';
$request .= '<DateTime>' . date("Y-m-d", strtotime($data['ststime'])) . 'T' . date("H:i:s", strtotime($data['ststime'])) . '.049Z</DateTime>';
$request .= '</Booking>';
$request .= '</Status>';
$request .= '<Remarks>';
$request .= '<ShipperInstructions></ShipperInstructions>';
$request .= '<AddressComments></AddressComments>';
$request .= '<SpecialAddons></SpecialAddons>';
$request .= '</Remarks>';
$request .= '<KNOrgDetails>';
$request .= '<KNCompanycode>' . $data['company_code'] . '</KNCompanycode>';
$request .= '<KNBranchcode>' . $data['branch_code'] . '</KNBranchcode>';
$request .= '</KNOrgDetails>';
$request .= '</TransmissionBody>';
$request .= '</TransmissionMessage>';
$resname = date("Ymdhis");
$dom = new DOMDocument();
$dom->preserveWhiteSpace = FALSE;
$dom->loadXML($request);
$dom->save('xml/response' . $resname . '.xml');
$serviceurl = BOOKING_ETRA_URL;
$username = BOOKING_ETRA_USRNAME;
$password = BOOKING_ETRA_PWD;
$auth = base64_encode($username . ':' . $password);
$headers = array(
    'Content-Type: application/xml',
    'Authorization: Basic ' . base64_encode("$username:$password")
);
$output = thirdpartyservicecurl($serviceurl, $headers, $request);
}

public function creditblock() {
//$post = $this->input->post();
    $post = array();
    $post = $this->input->post(NULL, TRUE);
    $uid = $this->session->userdata('user_id');
    $data['status'] = 0;
    $curdt = date('Y-m-d H:i:s');
    $cb_orderid = isset($post['cb_orderid']) ? $post['cb_orderid'] : 0;
    $creditid = isset($post['creditid']) ? $post['creditid'] : 0;
    $cb_companycode = isset($post['cb_companycode']) ? $post['cb_companycode'] : "";
    $cb_branchcode = isset($post['cb_branchcode']) ? $post['cb_branchcode'] : "";
    $cb_departcode = isset($post['cb_departcode']) ? $post['cb_departcode'] : "";
    $stoppage_id = isset($post['stoppage_id']) ? $post['stoppage_id'] : 0;
    $stoppage_name = isset($post['stoppage_name']) ? $post['stoppage_name'] : "";
    $stoppage_remark = isset($post['stoppage_remark']) ? $post['stoppage_remark'] : "";
    $remainder_date = isset($post['remainder_date']) ? $post['remainder_date'] : date('Y-m-d');
    $return_date = isset($post['return_date']) ? $post['return_date'] : date('Y-m-d');
    $resolution_id = isset($post['resolution_id']) ? $post['resolution_id'] : 0;
    $resolution_date = isset($post['resolution_date']) ? $post['resolution_date'] : date('Y-m-d');
    $extra_cost = isset($post['extra_cost']) ? $post['extra_cost'] : 0;
    $extracost_id = isset($post['extracost_id']) ? $post['extracost_id'] : "";
    $status_id = isset($post['status_id']) ? $post['status_id'] : 0;
    $status_dttime = isset($post['status_dttime']) ? $post['status_dttime'] : date('Y-m-d H:i:s');
    $status_remark = isset($post['status_remark']) ? $post['status_remark'] : "";
    $remainder_date = date('Y-m-d', strtotime($remainder_date));
    $return_date = date('Y-m-d', strtotime($return_date));
    $resolution_date = date('Y-m-d', strtotime($resolution_date));
    if ($creditid == 0) {
        $insdata = array(
            'order_id' => $cb_orderid,
            'stoppage_id' => $stoppage_id,
            'stoppage_name' => $stoppage_name,
            'stoppage_remarks' => $stoppage_remark,
            'remainder_date' => $remainder_date,
            'return_date' => $return_date,
            'resolution_id' => $resolution_id,
            'resolution_date' => $resolution_date,
            'extra_cost' => $extra_cost,
            'extracost_id' => $extracost_id,
            'status_id' => $status_id,
            'status_datetime' => $status_dttime,
            'status_remark' => $status_remark,
            'company_code' => $cb_companycode,
            'branch_code' => $cb_branchcode,
            'department_code' => $cb_departcode,
            'user_id' => $uid,
            'status' => 1,
            'created_on' => $curdt,
            'updated_on' => $curdt
        );
        $ins = $this->db->insert("tbl_credit_blocked", $insdata);
        $creditblockid = $this->db->insert_id();
        $data['status'] = 1;
    } else {
        $updata = array(
            'order_id' => $cb_orderid,
            'stoppage_id' => $stoppage_id,
            'stoppage_name' => $stoppage_name,
            'stoppage_remarks' => $stoppage_remark,
            'remainder_date' => $remainder_date,
            'return_date' => $return_date,
            'resolution_id' => $resolution_id,
            'resolution_date' => $resolution_date,
            'extra_cost' => $extra_cost,
            'extracost_id' => $extracost_id,
            'status_id' => $status_id,
            'status_datetime' => $status_dttime,
            'status_remark' => $status_remark,
            'company_code' => $cb_companycode,
            'branch_code' => $cb_branchcode,
            'department_code' => $cb_departcode,
            'user_id' => $uid,
            'updated_on' => $curdt
        );
        $updatecredit = $this->db->where_in("id", $creditid)->update("tbl_credit_blocked", $updata);
        $data['status'] = 1;
    }
    echo json_encode($data);
}

public function checkcreditblocked() {
// $post = $this->input->post();
    $data = $post = array();
    $post = $this->input->post(NULL, TRUE);
    $order_id = isset($post['order_id']) ? $post['order_id'] : 0;
    if ($order_id > 0) {
        $creditdata = $this->smtcorder->getcreditdata("tbl_credit_blocked", $order_id);
        if ($creditdata->num_rows() > 0) {
            $data = array(
                'creditid' => $creditdata->row()->id,
                'cb_orderid' => $creditdata->row()->order_id,
                'stoppage_id' => $creditdata->row()->stoppage_id,
                'stoppage_name' => $creditdata->row()->stoppage_name,
                'stoppage_remark' => $creditdata->row()->stoppage_remarks,
                'remainder_date' => $creditdata->row()->remainder_date,
                'return_date' => $creditdata->row()->return_date,
                'resolution_id' => $creditdata->row()->resolution_id,
                'resolution_date' => $creditdata->row()->resolution_date,
                'extra_cost' => $creditdata->row()->extra_cost,
                'extracost_id' => $creditdata->row()->extracost_id,
                'status_id' => $creditdata->row()->status_id,
                'status_dttime' => $creditdata->row()->status_datetime,
                'status_remark' => $creditdata->row()->status_remark,
                'cb_companycode' => $creditdata->row()->company_code,
                'cb_branchcode' => $creditdata->row()->branch_code,
                'cb_departcode' => $creditdata->row()->department_code
            );
        }
    }
    echo json_encode($data);
}

public function getstoppagename($id) {
    $data['name'] = "";
    if ($id != "") {
        $getdesc = $this->db->query("SELECT name FROM tbl_stoppage_master WHERE id=$id AND status=1");
        if ($getdesc->num_rows() > 0) {
            $data['name'] = $getdesc->row()->name;
        }
    }
    echo json_encode($data);
}

public function getconinfo($order_row_id) {
    $this->load->model('truckwaybillmodel');
    $serviceurl = SPOTON_URL;
    $username = SPOTON_USRNAME;
    $password = SPOTON_PWD;
    $headers = array(
        'Content-Type: application/json',
        'Authorization: Basic ' . base64_encode("$username:$password")
    );
    $requestinfo = $req_in_arr = array();
    $where = array(
        "id" => $order_row_id
    );
    $select = "order_id,weight,delivery_city,pickup_city,pickup_datetime";
    $table = "tb_orders";
    $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
    $user_id = $this->session->userdata('user_id');
    $company_code = $this->session->userdata('company_code');
    $branch_code = $this->session->userdata('branch_code');
    $order_number = '';
    $request_id = 0;
    if (count($order) > 0) {
        $reference_val = '';
        $where = array(
            "order_id" => $order_row_id
        );
        $select = "length,width,height,quantity";
        $table = "tb_order_cargodetails";
        $dimensions = array();
        $order_cargo = $this->common->gettbldata($where, $select, $table, 0, 0);
        $pickupinfo = $this->truckwaybillmodel->getshipper($order_row_id, 'Shipper');
        $receiverinfo = $this->truckwaybillmodel->getshipper($order_row_id, 'Consignee');
        $order_number = $order['order_id'];
        $order_reference = $this->truckwaybillmodel->orderrefernce($order_number);
        if (count($order_reference) > 0) {
            foreach ($order_reference as $res) {
                $reference_val = $res['ref_value'] . ",";
            }
        }
        $reference_val = trim($reference_val, ",");
        $total_packages = 0;
        if (count($order_cargo) > 0) {
            foreach ($order_cargo as $info) {
                $dimensions[] = [
                    'Length' => round(floatval($info['length'])),
                    'Breadth' => round(floatval($info['width'])),
                    'height' => round(floatval($info['height'])),
                    'Pieces' => round(floatval($info['quantity']))
                ];
                $total_packages = $total_packages + $info['quantity'];
            }
        }
        $picklocationname = isset($pickupinfo['location_id']) ? $pickupinfo['location_id'] : "";
        if ($picklocationname == '') {
            $picklocationname = $order['pickup_city'];
        }
        $pickpincode = isset($pickupinfo['pincode']) ? $pickupinfo['pincode'] : "";

        $pickaddress = isset($pickupinfo['address']) ? $pickupinfo['address'] : "";

        $pickmobile = isset($pickupinfo['mobile']) ? $pickupinfo['mobile'] : "";
        $pickemail = isset($pickupinfo['email']) ? $pickupinfo['email'] : "";

        $pickup_datetime = date("Y-m-d", strtotime($order['pickup_datetime']));
        $requestinfo['UniqueHashValue'] = '#@64@!$%3';
        $requestinfo['CustomerCode'] = $username;
        $requestinfo['PickupPincode'] = substr($pickpincode, 0, 6);
        $requestinfo['PickupDateTime'] = $pickup_datetime;
        $requestinfo['ReceiverPincode'] = substr($receiverinfo['pincode'], 0, 6);
        $requestinfo['PaymentMode'] = 'credit';
        $requestinfo['PickupLocationName'] = $picklocationname;
        $requestinfo['PickupAddress'] = $pickaddress;
        $requestinfo['PickupCity'] = $order['pickup_city'];
        $requestinfo['PickupContactPhone'] = $pickmobile;
        $requestinfo['PickupContactMail'] = $pickemail;

        $requestinfo['ReceiverName'] = $receiverinfo['name'];
        $requestinfo['ReceiverAddress'] = $receiverinfo['address'];
        $requestinfo['ReceiverCity'] = $order['delivery_city'];
        $requestinfo['ReceiverContactPerson'] = $receiverinfo['name'];
        $requestinfo['ReceiverContactPhone'] = $receiverinfo['mobile'];
        $requestinfo['ReceiverMail'] = $receiverinfo['email'];
        $requestinfo['TotalPackages'] = $total_packages;
        $requestinfo['TotalActualWeight'] = $order['weight'];
        $requestinfo['Remarks'] = 'Pickup and delivery notes';
        $requestinfo['SpecialInstruction'] = 'On time';
        $requestinfo['VTCApplicable'] = 'N';
        $requestinfo['VTCAmount'] = '0';
        $requestinfo['ReferenceNumber'] = $reference_val;
        $requestinfo['TINNumber'] = '';
        $requestinfo['AWBConsignmentValue'] = '0';
        $requestinfo['GstIn'] = '';
        $requestinfo['ProductId'] = '';
        $requestinfo['SplInstruction'] = '';
        $requestinfo['Dimensions'] = $dimensions;

// store value to con request table
        $req_in_arr = array(
            'customer_code' => $requestinfo['CustomerCode'],
            'unique_value' => $requestinfo['UniqueHashValue'],
            'order_id' => $order_number,
            'order_rowid' => $order_row_id,
            'user_id' => $user_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'pickup_pincode' => $requestinfo['PickupPincode'],
            'pickupdatetime' => $requestinfo['PickupDateTime'],
            'pickupreadytime' => '',
            'receiverpincode' => $requestinfo['ReceiverPincode'],
            'paymentmode' => $requestinfo['PaymentMode'],
            'pic_loc_name' => $requestinfo['PickupLocationName'],
            'pickupaddress' => $requestinfo['PickupAddress'],
            'pickupcity' => $requestinfo['PickupCity'],
            'pic_contactphone' => $requestinfo['PickupContactPhone'],
            'pic_contactmail' => $requestinfo['PickupContactMail'],
            'receivername' => $requestinfo['ReceiverName'],
            'receiveraddress' => $requestinfo['ReceiverAddress'],
            'receivercontactperson' => $requestinfo['ReceiverContactPerson'],
            'receiver_cont_phone' => $requestinfo['ReceiverContactPhone'],
            'receivermail' => $requestinfo['ReceiverMail'],
            'totalpackages' => $requestinfo['TotalPackages'],
            'tot_actual_weight' => $requestinfo['TotalActualWeight'],
            'remarks' => $requestinfo['Remarks'],
            'special_instruction' => $requestinfo['SpecialInstruction'],
            'vtc_applicable' => $requestinfo['VTCApplicable'],
            'vtc_amount' => $requestinfo['VTCAmount'],
            'refe_number' => $requestinfo['ReferenceNumber'],
            'tin_number' => $requestinfo['TINNumber'],
            'awb_consig_value' => $requestinfo['AWBConsignmentValue'],
            'gst_in' => $requestinfo['GstIn'],
            'product_id' => $requestinfo['ProductId'],
            'spl_instruction' => $requestinfo['SplInstruction'],
            'eway_bill' => '',
            'invoice_no' => '',
            'invoice_amt' => '0',
            'dimensions' => json_encode($dimensions)
        );
        $request_id = $this->common->insertTableData('tb_getcon_request', $req_in_arr);
    }
    $json_request = json_encode($requestinfo);
    $response = thirdpartyservicecurl($serviceurl, $headers, $json_request);
    curl_close($ch);
    if ($response) {
        $startNo = (isset($response->Pieces[0]->StartNo) && !empty($response->Pieces[0]->StartNo)) ? (string) ($response->Pieces[0]->StartNo) : "0";
        $endNo = (isset($response->Pieces[0]->EndNo) && !empty($response->Pieces[0]->EndNo)) ? (string) ($response->Pieces[0]->EndNo) : "0";
        $res_array = array(
            'request_id' => $request_id,
            'order_id' => $order_number,
            'order_rowid' => $order_row_id,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'res_status' => $response->Status,
            'error_remarks' => $response->ErrorRemarks,
            'unique_value' => $response->UniqueValue,
            'customer_refno' => $response->CustomerRefNo,
            'con_num' => $response->ConNo,
            'pickup_sccode' => $response->PickupScCode,
            'delivery_sccode' => $response->DeliveryScCode,
            'pickup_order_no' => $response->PickupOrderNo,
            'pie_startno' => $startNo,
            'pie_endno' => $endNo,
            'error_code' => $response->ErrorCode,
            'user_id' => $user_id
        );
        $resp = $this->common->insertTableData('tb_getcon_response', $res_array);

        $ins_ar = array(
            'order_id' => $order_row_id,
            'reference_id' => 'BN',
            'ref_value' => $response->ConNo,
            'status' => 1
        );
        $chkqry = $this->db->select('id')->get_where("tb_order_references", array(
            'order_id' => $order_row_id,
            'reference_id' => 'BN',
            'ref_value' => $response->ConNo
        ));
        if ($chkqry->num_rows() > 0) {

        } else {
            $ins = $this->db->insert('tb_order_references', $ins_ar);
        }

        /* code for ABH - Pickuporder number */
        if ($response->PickupOrderNo != '') {
            $picins_ar = array(
                'order_id' => $order_row_id,
                'reference_id' => 'ABH',
                'ref_value' => $response->PickupOrderNo,
                'status' => 1
            );
            $chkqry = $this->db->select('id')->get_where("tb_order_references", array(
                'order_id' => $order_row_id,
                'reference_id' => 'ABH',
                'ref_value' => $response->PickupOrderNo
            ));
            if ($chkqry->num_rows() == 0) {
                $ins = $this->db->insert('tb_order_references', $picins_ar);
            }
        }
        /* code for ABH - Pickuporder number */
    }
}

    public function check_trip(): void
    {
        $id = $this->input->post('order_id');
        $vendorcode = "";
        $res = 0;
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $getTripTemplates = $this->triptemplatemodel->getTripTemplatesByUser($companyCode);
        foreach ($getTripTemplates as $eachRow) {
            $templates[] = ['id' => $eachRow['id'], 'templateId' => $eachRow['template_id'], 'templateName' => $eachRow['template_name']];
        }
        $result = ['result' => 0, 'carrier_id' => 0, 'code' => "", 'templates' => $templates ?? []];
        if (!is_array($id)) {
            $where = ["id" => $id];
            $select = "vendor_id,shift_id,status";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (!empty($order)) {
                if ($order['shift_id'] > 0) {
                    $res = 1;
                }
                if ($order['vendor_id'] > 0) {
                    $vendor = $this->common->gettblrowdata(["id" => $order['vendor_id']], "code", "tb_vendors", 0, 0);
                    if (!empty($vendor)) {
                        $vendorcode = $vendor['code'];
                    }
                }
                $result = ['result' => $res, 'carrier_id' => $order['vendor_id'], 'code' => $vendorcode, 'templates' => $templates ?? [], 'status' => $order['status']];
            }
        } else {
            $bookids = implode(",", $id);
            $where = " id IN($bookids) AND shift_id != 0";
            $select = "id,vendor_id,status";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (!empty($order)) {
                $res = 1;
                if ($order['vendor_id'] > 0) {
                    $vendor = $this->common->gettblrowdata(["id" => $order['vendor_id']], "code", "tb_vendors", 0, 0);
                    if (!empty($vendor)) {
                        $vendorcode = $vendor['code'];
                    }
                }
                $result = ['result' => $res, 'carrier_id' => $order['vendor_id'], 'code' => $vendorcode, 'templates' => $templates ?? [], 'status' => $order['status']];
            }
        }
        echo json_encode($result);
    }

public function GetOrderIntoapi($order_id) {
    $url = "https://www.sevasetu.in/sp/index.php/api/tracking/track_v2";
    $headers = array(
        'Content-Type: application/json',
        'Username: maruticourier',
        MARUTI_PASSWORD,
        MARUTI_TOKEN
    );
    $where = array(
        "order_id" => $order_id
    );
    $select = "order_id,pickup_datetime,pickup_endtime,delivery_datetime,drop_endtime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,quantity,weight,volume,goods_value,transport_mode,customer_name,customer_phone,customer_email,company_code,branch_code";

    $table = "tb_orders";
    $data_order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
    if (count($data_order) > 0) {
        $postdata = array(
            'data' => $data_order
        );
        $getdata = thirdpartyservicecurl($url, $headers, $postdata);
// assumption response array
// {"success":"1","message":"Barcode successfully fetched.","data":{"barcode":{"order_id":"123","barcode_no":"589"}}}
        $json = json_decode($getdata, TRUE);
        $get_order_id = $json['data']['barcode']['order_id'];
        $get_barcode_no = $json['data']['barcode']['barcode_no'];
        $where = array(
            "order_id" => $get_order_id
        );
        $select = "order_id,ref_value";
        $table = "tb_order_references";
        $data_ref = $this->common->gettblrowdata($where, $select, $table, 0, 0);
        if (count($data_ref) == 0) {
            $insdata = array(
                'order_id' => $get_order_id,
                'reference_id' => 'DQ',
                'ref_value' => $get_barcode_no,
                'status' => 1
            );
            $this->db->insert("tbl_credit_blocked", $insdata);
        }
    }
}

    public function ordernotify(string $action, int $orderId): void
    {
        $this->load->library('notifytrigger');
        $info['page_title'] = $info['subject'] = 'Booking Notification';
        $info['order_id'] = $orderId;
        $info['action'] = $action;
        $orderInfo = $this->common->gettblrowdata([
            'id' => $orderId
        ], 'order_id,shift_id,shipmentid', 'tb_orders', 0, 0);
        if ($orderInfo) {
            $info['orderid'] = $bookingId = $orderInfo['order_id'];
            $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
            $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
            $info['cargos'] = $this->common->gettbldata([
                'order_id' => $orderId
            ], 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
            if ($action != 'trip_create') {
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $this->notifytrigger->sendordernotify($info);
            } else {
                $info['shift_id'] = $orderInfo['shift_id'];
                $info['shiftid'] = $orderInfo['shipmentid'] ?: '';
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $this->notifytrigger->sendtripnotify($info);
            }
        }
    }

    /*
    * public function testprefer(){
    * $order_id = '1';
    * $company_code = 'PLKN';
    * $pref_arr = array('pickup'=>'GERMANY','drop'=>'POLAND','customer_id'=>'1000739642','service'=>'11','product'=>'KN PharmaChain','user_id'=>'7','company_code'=>$company_code,'order_id'=>$order_id);
    * if($company_code == 'PLKN'){
    * $this->ratemanagement->addrecodfororderinsertion($pref_arr);
    * }
    * }
    */

/* Australia ASN order empty values check */

public function emptycheckasnorder($id) {
    $where = array(
        "status" => 1,
        "id" => $id
    );
    $whr = array(
        "status" => 1,
        "order_id" => $id
    );
    $keys = "missing fields:\n";
    $checkval = 0;
    /* get order data */
    $order_array = $this->smtcorder->getauasnorderdata($where);
    /* get Cargo data */
    $cargo_array = $this->smtcorder->getasncargodetails($whr);
    if (!empty($order_array)) {
        /* get order array empty values */
        $get_order_em = array_filter($order_array, function ($val) {
            return (empty($val));
        });
        if (!empty($get_order_em)) {
            /* get order array only keys */
            $get_order_em_keys = array_keys($get_order_em);
            /* get order array convert string */
            $key = implode("\n", $get_order_em_keys);
            $keys .= $key . "\n";
            $checkval = 1;
        }
    }
    /* log_message("error","check val :::".$checkval); */
    /* cargo empty field keys */
    $cargo_keys = $this->cargofieldscheck($cargo_array);
    if (!empty($cargo_keys)) {
        $keys .= $cargo_keys;
        $checkval = 1;
    }
    /* log_message("error","check val1 :::".$checkval); */
    $get_array = array(
        "keys" => $keys,
        "check_val" => $checkval
    );

    /* log_message("error","order check:::".json_encode($get_array)); */

    return $get_array;
/*
* echo "<pre>";
* print_r($order_array);
* print_r($cargo_array);
* print_r($get_array);
*/
}

/* cargo empty field Check */

private function cargofieldscheck($cargo_array) {
    $keys = "";
    $cargo_keys = "";
    $array_kyes_cargo = array();
    if (!empty($cargo_array)) {
        /* cargo array loop */
        for ($i = 0; $i < count($cargo_array); $i++) {
            /* get cargo array Empty values */
            $cargo_emtty_val[] = array_filter($cargo_array[$i], function ($val) {
                return (empty($val) || $val <= 0);
            });
            if (!empty($cargo_emtty_val)) {
                /* get cargo array keys only */
                $array_kyes_cargo[] = array_keys($cargo_emtty_val[$i]);
            }
        }
        if (!empty($array_kyes_cargo)) {
            /* cargo array multidimensional array to single array */
            $single_array = $this->multiarraytosingle($array_kyes_cargo);
            /* cargo array remove duplicate values */
            $cargo_reslut = array_unique($single_array);
            /* cargo array convert into string */
            $cargo_keys .= implode("\n", $cargo_reslut);
            $keys .= $cargo_keys;
        }
    }

// $get_array=array("keys"=>$keys,"check_val"=>$checkval);
    return $keys;
}

/* cargo multi array to single array conversion */

private function multiarraytosingle($array) {
    if (!is_array($array)) {
        return FALSE;
    }
    $result = array();
    foreach ($array as $key => $value) {
        if (is_array($value)) {
            $result = array_merge($result, $this->multiarraytosingle($value));
        } else {
            $result[$key] = $value;
        }
    }

    return $result;
}

/* Australia save pallets */

public function savepallets() {
    $order_row_id = $this->input->post('order_row_id', true);
    $num_pallets = $this->input->post('num_pallets', true);

    $num_pallets = isset($num_pallets) ? $num_pallets : 0;
    $num_pallets = !empty($num_pallets) ? $num_pallets : 0;
    $upd = $this->common->updatetbledata("tb_order_details", array(
        'num_of_pallets' => $num_pallets
    ), array(
        "order_row_id" => $id
    ));
    /* log_message('error',"post data".json_encode($this->input->post())); */
    echo json_encode($upd);
}

/* Get refrence numbers Advanced search */

public function getrefnum() {
    $result = $res = array();
    $user_id = $this->session->userdata('user_id');
    $post = array();
    $post = $this->input->post(NULL, TRUE);
//$post = $this->input->post();

    if (isset($post['order_reftype']) && $post['order_reftype'] != "") {
        if (isset($post['ref_val']) && $post['ref_val'] != "") {
            $ref_id = trim($post['order_reftype']);
            $ref_val = trim($post['ref_val']);
            $where_like = array(
                'r.ref_value' => $ref_val
            );
            $permission = checkuserpermissions();
            if (in_array("orders", $permission)) {
                $company_code = $this->session->userdata('company_code');
                $whr = array(
                    'o.status!=' => '0',
                    'o.company_code' => $company_code,
                    'r.reference_id' => $ref_id,
                    'r.status' => 1
                );
            } else {
                $whr = array(
                    'o.status!=' => '0',
                    'o.user_id' => $user_id,
                    'r.reference_id' => $ref_id,
                    'r.status' => 1
                );
            }
            $result = $this->smtcorder->getrefvals($whr, $where_like);
            /* log_message("error","order_id get".$this->db->last_query()); */
            if (!empty($result)) {
                $res = array_column($result, "order_id");
            }
        }
    }

    return $res;
}


public function ajaxListing() {
    $this->load->model('Datatables_model');
    $draw = $this->input->get('draw', true);
    $start = $this->input->get('start', true);
    $indexColumn = 'c.id';

    $get = $this->input->get('data');
    $order_id = $get['order_id'];
    $actionType = $get['actionType'];
    $companyCode = $get['company_code'];
    if($companyCode == "AUKN"){
        $indexColumn = 'o.id';
    }

    $selectColumns = [
        'c.id',
        'c.cargo_type',
        'c.length_unit',
        'c.width_unit',
        'c.height_unit',
        'c.weight_unit',
        'c.volume_unit',
        'c.secondweight_uom',
        'c.secondvolume_uom',
        'c.goods_description',
        'c.stackable',
        'c.grounded',
        'c.splittable',
        'c.dg_goods',
        'o.id as ordcargoid',
        'o.length',
        'o.width',
        'o.height',
        'o.weight',
        'o.second_weight',
        'o.volume',
        'o.second_volume',
        'o.volumetric_weight',
        'o.volweight_uom',
        'c.ldm',
        'o.quantity',
        'o.scanned_quantity',
        'o.qr_code',
        'o.reference_order_num',
        'o.marks_numbers'
    ];

    if ($actionType == 'Edit') {
        $dataTableSortOrdering = [
            'c.id',
            'c.cargo_type',
            'c.goods_description',
            'o.quantity',
            'o.scanned_quantity',
            'o.length',
            'o.width',
            'o.height',
            'o.weight',
            'o.second_weight',
            'o.volumetric_weight',
            'o.volume',
            'o.second_volume',
            'o.marks_numbers',
            'c.ldm',
            'c.stackable',
            'c.grounded',
            'c.splittable',
            'c.dg_goods',
            'c.id'
        ];
    } else {
        if ($companyCode == 'AUKN') {
            $dataTableSortOrdering = [
                'c.cargo_type',
                'c.goods_description',
                'o.qr_code',
                'o.quantity',
                'o.scanned_quantity',
                'o.length',
                'o.width',
                'o.height',
                'o.weight',
                'o.second_weight',
                'o.volumetric_weight',
                'o.volume',
                'o.second_volume',
                'o.marks_numbers',
                'c.ldm',
                'c.id',
                'c.stackable',
                'c.grounded',
                'o.id',
                'c.splittable',
                'c.dg_goods',
                'c.id'
            ];
        } else {
            $dataTableSortOrdering = [
                'c.id',
                'c.cargo_type',
                'c.goods_description',
                'o.quantity',
                'o.scanned_quantity',
                'o.length',
                'o.width',
                'o.height',
                'o.weight',
                'o.second_weight',
                'o.volumetric_weight',
                'o.volume',
                'o.second_volume',
                'o.marks_numbers',
                'c.ldm',
                'c.stackable',
                'c.grounded',
                'c.splittable',
                'c.dg_goods',

            ];
        }
    }

    $table_name = 'tb_cargo_details c,tb_order_cargodetails o';
    $joinsArray = array();

    $wherecondition = " o.order_id ='" . $order_id . "' AND o.cargo_id=c.id AND o.status='1'  ";
    $groupBy = 'c.id';

    $getRecordListing = $this->Datatables_model->datatablesQuery($selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, '', $groupBy);

    $totalRecords = $getRecordListing['recordsTotal'];
    $recordsFiltered = $getRecordListing['recordsFiltered'];

    $recordListing = array();
    $content = '[';
    $i = 0;
    $srNumber = $start;

    if (!empty($getRecordListing)) {
        $actionContent = '';
        if (isset($getRecordListing['data'])) {
            $totalqty = sizeof($getRecordListing['data']);
        } else {
            $totalqty = '0';
        }
        foreach ($getRecordListing['data'] as $res) {
            $stackable = 'Off';
            if ($res->stackable == 0) {
                $stackable = 'Off';
            } else if ($res->stackable == 1) {
                $stackable = 'On';
            }
            $grounded = 'Off';
            if ($res->grounded == 0) {
                $grounded = 'Off';
            } else if ($res->grounded == 1) {
                $grounded = 'On';
            }
            $splittable = 'Off';
            if ($res->splittable == 0) {
                $splittable = 'Off';
            } else if ($res->splittable == 1) {
                $splittable = 'On';
            }
            $dg_goods = 'Off';
            if ($res->dg_goods == 0) {
                $dg_goods = 'Off';
            } else if ($res->dg_goods == 1) {
                $dg_goods = "<span title='Click To Get Dgoods' onclick = getDangerousGoodsDetails(" . $res->dg_goods . "," . $res->ordcargoid . ",".$order_id.") style='cursor:pointer;'>On</span>";
            }
            $cargo_type = '"' . $res->cargo_type . '"';
            $goods_desc = '"' . $res->goods_description . '"';
            $marks_numbers       = '"' . $res->marks_numbers . '"';
            $length_unit = '"' . $res->length_unit . '"';
            $width_unit = '"' . $res->width_unit . '"';
            $height_unit = '"' . $res->height_unit . '"';
            $weight_unit = '"' . $res->weight_unit . '"';
            $volume_unit = '"' . $res->volume_unit . '"';
            $volweight_uom = '"' . $res->volweight_uom . '"';
            $secondweight_uom = '"' . $res->secondweight_uom . '"';
            $secondvolume_uom = '"' . $res->secondvolume_uom . '"';
            $scanned_quantity = $res->scanned_quantity;
            $second_weight = $res->second_weight;
            $second_volume = $res->second_volume;
            $qrcode = $res->qr_code;
            $volumetric_weight = $res->volumetric_weight;
            $ldm = $res->ldm;

            if ($scanned_quantity == "") {
                $scanned_quantity = 0;
            }
            if ($second_volume == "") {
                $second_volume = 0;
            }
            if ($second_weight == "") {
                $second_weight = 0;
            }
            if ($volumetric_weight == "") {
                $volumetric_weight = 0;
            }
            if ($ldm == "") {
                $ldm = 0;
            }
            /* au macpac customer checking */
            $aucustomer_name = $this->smtcorder->getcustomername($order_id);
            if (isset($aucustomer_name) && strtoupper($aucustomer_name) == "MACPAC") {
                $label = '<a href="' . base_url("aulabel/index?order_car_id=" . $res->ordcargoid . "&tot=" . $totalqty . "&cargo_row_id=" . $i) . '" target="_blank" title="' . $this->lang->line('print_label') . '"><span class="icon tru-icon-pdf"></span></a>';
            } else {
                if ($scanned_quantity == 0) {
                    $alertmsg = "'There is no Labels Scanned for this cargo..!'";
                    $label = '<a href="#" onclick="alert(' . $alertmsg . ')"><span class="icon tru-icon-pdf"></span></a>';
                } else {
                    $label = '<a href="' . base_url("aulabel/index?order_car_id=" . $res->ordcargoid . "&tot=" . $totalqty . "&cargo_row_id=" . $i) . '" target="_blank" title="' . $this->lang->line('print_label') . '"><span class="icon tru-icon-pdf"></span></a>';
                }
            }

            $empty = "";
            $content .= '[';
            if ($actionType == 'Edit') {
    // edit cargo details is same for all the countries
                if ($this->session->userdata('company_code') == "NZKN" && $this->session->userdata('cust_id') != "") {
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcuscargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . ","  . $marks_numbers . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $ldm . "," . $scanned_quantity . "," . $second_weight . "," . $secondweight_uom . "," . $second_volume . "," . $secondvolume_uom . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteordercargodetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargos</a></li>";
                } else {
                    $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcargoEdit(this," . $res->id . "," . $cargo_type . "," . $goods_desc . ","  . $marks_numbers . "," . $res->quantity . "," . $res->length . "," . $res->width . "," . $res->height . "," . $res->weight . "," . $res->volume . "," . $volumetric_weight . "," . $res->stackable . "," . $res->grounded . "," . $res->splittable . "," . $res->dg_goods . "," . $length_unit . "," . $width_unit . "," . $height_unit . "," . $weight_unit . "," . $volume_unit . "," . $volweight_uom . "," . $ldm . "," . $scanned_quantity . "," . $second_weight . "," . $secondweight_uom . "," . $second_volume . "," . $secondvolume_uom . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteordercargodetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Cargo Details</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default' onclick='getinnercargo(this," . $res->id . ");'><span class='fa fa-archive' > </span>Get Inner Cargos</a></li>";
                }

                $recordListing[ $i ][0]  = $action;
                $recordListing[ $i ][1]  = $res->cargo_type;
                $recordListing[ $i ][2]  = $res->goods_description;
                $recordListing[ $i ][3] = $res->marks_numbers;
                $recordListing[ $i ][4]  = $res->quantity;
                $recordListing[ $i ][5]  = $scanned_quantity;
                $recordListing[ $i ][6]  = $res->length . " " . $res->length_unit;
                $recordListing[ $i ][7]  = $res->width . " " . $res->width_unit;
                $recordListing[ $i ][8]  = $res->height . " " . $res->height_unit;
                $recordListing[ $i ][9]  = $res->weight . " " . $res->weight_unit;
                $recordListing[ $i ][10]  = $second_weight . " " . $res->secondweight_uom;
                $recordListing[ $i ][11] = $volumetric_weight . " " . $res->volweight_uom;
                $recordListing[ $i ][12] = $res->volume . " " . $res->volume_unit;
                $recordListing[ $i ][13] = $second_volume . " " . $res->secondvolume_uom;
                $recordListing[ $i ][14] = $ldm;
                $recordListing[ $i ][15] = $stackable;
                $recordListing[ $i ][16] = $grounded;
                $recordListing[ $i ][17] = $splittable;
                $recordListing[ $i ][18] = $dg_goods;
                $recordListing[ $i ][19] = $res->id;
} else { // view order logic
    if ($companyCode == 'AUKN') {
        $recordListing[$i][0] = $i+1;
        $recordListing[$i][1] = $res->cargo_type;
        $recordListing[$i][2] = $res->goods_description;
        $recordListing[$i][3] = $res->marks_numbers;
        $recordListing[$i][4] = $qrcode;
        $recordListing[$i][5] = $res->quantity;
        $recordListing[$i][6] = $scanned_quantity;
        $recordListing[$i][7] = $res->length . " " . $res->length_unit;
        $recordListing[$i][8] = $res->width . " " . $res->width_unit;
        $recordListing[$i][9] = $res->height . " " . $res->height_unit;
        $recordListing[$i][10] = $res->weight . " " . $res->weight_unit;
        $recordListing[$i][11] = $second_weight . " " . $res->secondweight_uom;
        $recordListing[$i][12] = $volumetric_weight . " " . $res->volweight_uom;
        $recordListing[$i][13] = $res->volume . " " . $res->volume_unit;
        $recordListing[$i][14] = $second_volume . " " . $res->secondvolume_uom;
        $recordListing[$i][15] = $ldm;
        $recordListing[$i][16] = $label;
        $recordListing[$i][17] = $stackable;
        $recordListing[$i][18] = $grounded;
        $recordListing[$i][19] = $splittable;
        $recordListing[$i][20] = $dg_goods;
        $recordListing[$i][21] = $res->id;
    } else {
        $recordListing[ $i ][0]  = $res->cargo_type;
        $recordListing[ $i ][1]  = $res->goods_description;
        $recordListing[$i][2] = $res->marks_numbers;
        $recordListing[ $i ][3]  = $res->quantity;
        $recordListing[ $i ][4]  = $scanned_quantity;
        $recordListing[ $i ][5]  = $res->length . " " . $res->length_unit;
        $recordListing[ $i ][6]  = $res->width . " " . $res->width_unit;
        $recordListing[ $i ][7]  = $res->height . " " . $res->height_unit;
        $recordListing[ $i ][8]  = $res->weight . " " . $res->weight_unit;
        $recordListing[ $i ][9]  = $second_weight . " " . $res->secondweight_uom;
        $recordListing[ $i ][10]  = $volumetric_weight . " " . $res->volweight_uom;
        $recordListing[ $i ][11] = $res->volume . " " . $res->volume_unit;
        $recordListing[ $i ][12] = $second_volume . " " . $res->secondvolume_uom;
        $recordListing[ $i ][13] = $ldm;
        $recordListing[ $i ][14] = $stackable;
        $recordListing[ $i ][15] = $grounded;
        $recordListing[ $i ][16] = $splittable;
        $recordListing[ $i ][17] = $res->id;
        $recordListing[ $i ][18] = $dg_goods;
    }
}
$i++;
$srNumber++;
}
$content .= ']';
$final_data = json_encode($recordListing);
} else {
    $final_data = '[]';
}
// echo '{"draw":'.$draw.',"recordsTotal":'.$totalRecords.',"recordsFiltered":'.$recordsFiltered.',"data":'.$final_data.'}';
echo '{"draw":' . $draw . ',"recordsTotal":' . $recordsFiltered . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
}

public function getpickupdetailsbyID() {
    $user_id = 1;
    $parties = array();
    $code = $this->input->post('id', true);
    $company_code = $this->session->userdata('company_code');
    $user_id = $this->session->userdata('user_id');
    $where = array();
    if ($company_code == 'RUKN') {
        $where['company_code'] = $company_code;
    } else {
        $where['user_id'] = $user_id;
    }
    $this->db->select("id,name,email,street,location_id as city,state,mobile,pincode,country,code,fax");
    $this->db->from("tbl_party_master");
    $this->db->where(array(
        "code" => $code
    ));
    if (!empty($where)) {
        $this->db->where($where);
    }
    $this->db->order_by("id", "DESC");
    $chkqry = $this->db->get();
    if ($chkqry->num_rows() > 0) {
        $parties[] = array(
            'id' => $chkqry->row()->id,
            'name' => $chkqry->row()->name,
            'phone' => $chkqry->row()->mobile,
            'street' => $chkqry->row()->street,
            'city' => $chkqry->row()->city,
            'pincode' => $chkqry->row()->pincode,
            'code' => $chkqry->row()->code,
            'country' => $chkqry->row()->country,
            'email_id' => $chkqry->row()->email,
            'fax' => $chkqry->row()->fax,
            'state' => $chkqry->row()->state
        );
    }

    echo json_encode($parties);
}

public function getvehicledrivers(){
	$vehicle_id = $this->input->post('vehicle_id', true);
	$result=array();
	$drivers = '<option value="">--Select--</option>';
	$this->db->select("ttd.id,ttd.name ");
	$this->db->from("tbl_assigned_drivers tad");
	$this->db->join("tb_truck_drivers ttd", "tad.`driver_id`=ttd.id", "LEFT");
	$this->db->where(array("tad.vehicle_id" => $vehicle_id,"tad.status"=>"1" ));
	$this->db->group_by('ttd.id');
	$this->db->order_by('ttd.id', 'DESC');
	$drivers_list = $this->db->get();
	if ($drivers_list->num_rows() > 0) {
		foreach ($drivers_list->result() as $row) {
			$drivers .= '<option value="' . $row->id . '">' . $row->name . '</option>';
		}
	}
	$drivers .= '</select>';
	$result['drivers'] = $drivers;
	echo json_encode($result);
}

public function threemshipmetsforceclose(){
	$from_date=$this->input->post('forcefromDate', true);
	$to_date=$this->input->post('forcetoDate', true);
	$current_date = date('Y-m-d',strtotime($from_date));
	$force_to_date = date('Y-m-d',strtotime($to_date));
	$today_date = date('Y-m-d H:i:s');
	if((strpos($current_date, "1970-01-01") === false) && (strpos($force_to_date, "1970-01-01") === false)){
		$getthreemhipmentsqry = 'UPDATE tb_orders SET trip_sts="1",updatedon="'.$today_date.'"  WHERE  `customer_id` in (1450,1451,1452,1453,1454) AND DATE(createdon)>="'.$current_date.'" AND DATE(createdon)<="'.$force_to_date.'"  AND trip_sts!=1 AND user_id="5"';
		$getthreemhipmentsRes = $this->db->query($getthreemhipmentsqry);
		echo "ALL the 3M shipments from ".$from_date." to ".$to_date. " are Closed";
	}
}

public function deleteorders(): void
{
	if($_SERVER['REQUEST_METHOD'] === 'POST') {
        $this->load->helper(['log']);
        $ids = $this->input->post('deleteids');
            $tables = [
                ['name' => 'tb_orders', 'column' => 'id'],
                ['name' => 'tb_order_details', 'column' => 'order_row_id'],
                ['name' => 'tb_order_parties', 'column' => 'order_id'],
                ['name' => 'tbl_orderparty_address', 'column' => 'order_id'],
                ['name' => 'tb_order_cargodetails', 'column' => 'order_id'],
                ['name' => 'tb_order_addons', 'column' => 'order_id'],
                ['name' => 'tb_order_references', 'column' => 'order_id'],
            ];
            $result = true;
            foreach ($tables as $table) {
                foreach ($ids as $id) {
                    $this->db->reset_query();
                    $data = $this->db->delete($table['name'], [$table['column'] => $id]);
                    if (!$data) {
                        $error = $this->db->error();
                        log_error(sprintf('While execute query [%s] the following error came back [%s]', $query, $error['message']));
                        $result = false;
                    }
                }
            }
            echo $result ? "success" : "failed";
	}
}
}

?>
