<?php
class Statuscode extends CI_Controller{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Status_code_model');
        if (!checkUrlAccessForUser('STATUSCODE')) {
            redirect("Forbiddenaccess");
        }
    }

    /*
     * Listing of status_codes
     */
    function index($per_page=0)
    {
        $params['limit'] = 10;
        $params['offset'] = isset($per_page) ? $per_page : 0;

        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('statuscode/index');
        $config['total_rows'] = $this->Status_code_model->get_all_status_codes_count();
        $this->pagination->initialize($config);

        $data['status_codes'] = $this->Status_code_model->get_all_status_codes($params);

        $data['_view'] = 'statuscode/index';
        $this->settemplate->dashboard('statuscode/index',$data);
    }

    /*
     * Adding a new status_code
     */
    function add()
    {
        $data['_view'] = 'statuscode/add';
        $this->settemplate->dashboard('statuscode/add',$data);
    }

    /*
     * Save a new status_code
     */
    function statuscodesave()
    {
        if(isset($_POST) && count($_POST) > 0)
        {
            $this->form_validation->set_rules('status_code_id', 'Status Code ID', 'required|is_unique[tb_status_codes.status_code_id]');
            if ($this->form_validation->run() == false) {
                $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                $this->add();
            }else{
                $pk = $this->input->post('domain_name').".".$this->input->post('status_code_id');
                $params = array(
                    'pk' => $pk,
                    'status_code_id' => $this->input->post('status_code_id'),
                    'description' => $this->input->post('description'),
                    'domain_name' => $this->input->post('domain_name'),
                    'user_id' => $this->session->userdata('user_id'),
                    'status'=>"1",
                    'createdon' => date("Y-m-d H:i:s"),
                );

                $status_code_id = $this->Status_code_model->add_status_code($params);
                redirect('statuscode/index');
            }
        }
        else
        {
             redirect('statuscode/index');
        }
    }

    /*
     * Editing a status_code
     */
    public function edit($id)
    {
        // check if the status_code exists before trying to edit it
        $data['status_code'] = $this->Status_code_model->get_status_code($id);

        if(isset($data['status_code']['id']))
        {
            $data['_view'] = 'statuscode/edit';
            $this->settemplate->dashboard('statuscode/edit',$data);
        }else{
            show_error('The status_code you are trying to edit does not exist.');
        }
    }

    public function checkstscodeupdate($statuscode) {
        if($this->input->post('id')){
            $id = $this->input->post('id');
        }else{
            $id = 0;
        }
        $whr = array("status_code_id"=>$statuscode,"id <>"=>$id);
        $res = $this->db->select("id")->where($whr)->get("tb_status_codes")->num_rows();
        if($res == 0){
            $response = true;
        }else {
            $this->form_validation->set_message('checkstscodeupdate','Status Code ID is already exists to another status!');
            $response = false;
        }
        return $response;
    }

    /*
     * Editing a status_code
     */
    public function statuscodeupdate($id)
    {
        // check if the status_code exists before trying to edit it
        $data['status_code'] = $this->Status_code_model->get_status_code($id);

        if(isset($data['status_code']['id']))
        {
            if(isset($_POST) && count($_POST) > 0)
            {
                $this->form_validation->set_rules('status_code_id', 'Status Code ID', 'required|callback_checkstscodeupdate');
                if ($this->form_validation->run() == false) {
                    $this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                    $this->edit($id);
                }else{
                    $pk = $this->input->post('domain_name').".".$this->input->post('status_code_id');
                    $params = array(
                        'pk' => $pk,
                        'status_code_id' => $this->input->post('status_code_id'),
                        'description' => $this->input->post('description'),
                        'domain_name' => $this->input->post('domain_name'),
                        'user_id' => $this->session->userdata('user_id'),
                        'status'=>"1",
                    );
                    $this->Status_code_model->update_status_code($id,$params);
                    redirect('statuscode/index');
                }
            }
            else
            {
                redirect('statuscode/index');
            }
        }else{
            show_error('The status_code you are trying to edit does not exist.');
        }
    }

    /*
     * Deleting status_code
     */
    function remove($id)
    {
        $status_code = $this->Status_code_model->get_status_code($id);

        // check if the status_code exists before trying to delete it
        if(isset($status_code['id']))
        {
            $this->Status_code_model->delete_status_code($id);
            redirect('statuscode/index');
        }
        else
            show_error('The status_code you are trying to delete does not exist.');
    }

}
