<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";

class Statusmaster extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model('common');
        $this->load->model('Status_master_model');
        $this->load->model('Trafficcodemodel');
        $this->load->helper('log_helper');
        if (! checkUrlAccessForUser('STATUSMASTER')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('leftmenu_status');
        $data['sub_title']  = $this->lang->line('general_search');
        $input              = $this->input->post(null, true);

        $where1           = [];
        $whr              = [];
        $company_code     = $this->session->userdata('company_code');
        $whr['sm.status'] = 1;
        if ($company_code == 'RUKN') {
            $whr['sm.company_code'] = $company_code;
        } else {
            $whr['sm.company_code'] = $company_code;
            $whr['sm.branch_code']  = $this->session->userdata('branch_code');
        }
        if (isset($_POST['searchsubmit']) && $this->input->post('searchsubmit', true) == "Searchs") {
            $where = [
                'status_code' => $input['status_code'],
                'status_name' => $input['status_name'],
            ];
            $where1 = [];
            if (isset($where['status_code']) && $where['status_code'] != "") {
                $where1['sm.status_code'] = $where['status_code'];
            }
            if (isset($where['status_name']) && $where['status_name'] != "") {
                $where1['sm.status_name'] = $where['status_name'];
            }
            if (isset($where['customer_id']) && $where['customer_id'] != "") {
                $where1['m.name'] = $where['customer_id'];
            }
        } elseif (isset($_POST['searchsubmita']) && $this->input->post('searchsubmita', true) == "Search") {
            $where = [
                'status_code'  => $input['status_code'],
                'status_name'  => $input['status_name'],
                'company_code' => $input['company_code'],
                'branch_code'  => $input['branch_code'],
                'status'       => $input['status'],
            ];
            $where1 = [];
            if (isset($where['status_code']) && $where['status_code'] != "") {
                $where1['sm.status_code'] = $where['status_code'];
            }
            if (isset($where['status_name']) && $where['status_name'] != "") {
                $where1['sm.status_name'] = $where['status_name'];
            }
            if (isset($where['customer_id']) && $where['customer_id'] != "") {
                $where1['m.name'] = $where['customer_id'];
            }
            if (isset($where['company_code']) && $where['company_code'] != "") {
                $where1['sm.company_code'] = $where['company_code'];
            }
            if (isset($where['branch_code']) && $where['branch_code'] != "") {
                $where1['sm.branch_code'] = $where['branch_code'];
            }
            if (isset($where['status']) && $where['status'] != "") {
                $where1['sm.status'] = $where['status'];
                unset($whr['sm.status']);
            }
        }
        $data['statusm'] = $this->Status_master_model->statuslist($where1, $whr);
        $this->newtemplate->dashboard("statusmaster/index", $data);
    }

    public function add()
    {
        $branch_code          = $this->session->userdata('branch_code');
        $company_code         = $this->session->userdata('company_code');
        $user_id              = $this->session->userdata('user_id');
        $data['branch_code']  = $branch_code;
        $data['company_code'] = $company_code;
        $data['user_id']      = $user_id;
        $data['page_title']   = $this->lang->line('leftmenu_status');
        $data['sub_title']    = $this->lang->line('general_add');
        $table                = 'tb_customers';
        $whr                  = [];
        if ($company_code == 'RUKN') {
            $whr = [
                "company_code" => $company_code,
                "status"       => 1,
            ];
        } else {
            $whr = [
                "user_id" => $user_id,
                "status"  => 1,
            ];
        }
        $cusname         = $this->Status_master_model->selectlist('id,name', $table, $whr);
        $data['cusname'] = $cusname;
        //$this->newtemplate->dashboard("statusmaster/addstatusmaster", $data);
        $this->load->view("statusmaster/addstatusmaster", $data);
    }

    public function statusmasterinsert()
    {
        $user_id = $this->session->userdata('user_id');
        $post    = $this->input->post(null, true);
        extract($post);
        $status_name  = isset($status_name) ? $status_name : "";
        $description  = isset($description) ? $description : "";
        $status_type  = isset($status_type) ? $status_type : "no";
        $status_code  = isset($status_code) ? $status_code : "";
        $customer_id  = isset($customer_id) ? $customer_id : 0;
        $company_code = isset($company_code) ? $company_code : "";
        $branch_code  = isset($branch_code) ? $branch_code : "";
        // $status = isset($status) ? $status : 0;

        $tabledata = [
            'status_name'  => $status_name,
            'description'  => $description,
            'status_type'  => $status_type,
            'status_code'  => $status_code,
            'customer_id'  => $customer_id,
            'company_code' => $company_code,
            'branch_code'  => $branch_code,
            'status'       => 1,
        ];
        $tabledata['createdon'] = date('Y-m-d H:i:s');
        $table                  = 'tb_status_master';
        $result                 = $this->common->insertTableData($table, $tabledata);
        echo json_encode($result);

    }

    public function edit($id)
    {
        $company_code         = $this->session->userdata('company_code');
        $branch_code          = $this->session->userdata('branch_code');
        $user_id              = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code']  = $branch_code;
        $data['user_id']      = $user_id;
        $data['page_title']   = $this->lang->line('leftmenu_status');
        $data['sub_title']    = $this->lang->line('general_edit');
        $where1               = [
            'id' => $id,
        ];
        $table1         = "tb_status_master";
        $edit_d         = $this->common->gettblrowdata($where1, '*', $table1, 0, 0);
        $data['edit_d'] = $edit_d;
        $table          = 'tb_customers';
        $whr            = [];
        if ($company_code == 'RUKN') {
            $whr = [
                "company_code" => $company_code,
                "status"       => 1,
            ];
        } else {
            $whr = [
                "user_id" => $user_id,
                "status"  => 1,
            ];
        }
        $cusname         = $this->Status_master_model->selectlist('id,name', $table, $whr);
        $data['cusname'] = $cusname;
        //$this->newtemplate->dashboard("statusmaster/editstatusmaster", $data);
        $this->load->view("statusmaster/editstatusmaster", $data);
    }

    public function updatedata()
    {
        // $add = $this->input->post('save');
        $id = $this->input->post('id', true);
        if (isset($id)) {
            $user_id = $this->session->userdata('user_id');

            $post = $this->input->post(null, true);
            extract($post);
            $status_name  = isset($status_name) ? $status_name : "";
            $description  = isset($description) ? $description : "";
            $status_type  = isset($status_type) ? $status_type : "no";
            $status_code  = isset($status_code) ? $status_code : "";
            $customer_id  = isset($customer_id) ? $customer_id : 0;
            $company_code = isset($company_code) ? $company_code : "";
            $branch_code  = isset($branch_code) ? $branch_code : "";
            $status       = isset($status) ? $status : 0;

            $tabledata = [
                'status_name'  => $status_name,
                'description'  => $description,
                'status_type'  => $status_type,
                'status_code'  => $status_code,
                'customer_id'  => $customer_id,
                'company_code' => $company_code,
                'branch_code'  => $branch_code,
                'status'       => $status,
            ];
            $tabledata['updatedon'] = date('Y-m-d H:i:s');
            $table                  = ' tb_status_master';
            $whr                    = [
                'id' => $id,
            ];
            $result = $this->common->updatetbledata($table, $tabledata, $whr);
            echo json_encode($result);
            /*
             * if ($result) {
             * $this->session->set_flashdata('success_msg', 'Record Updated Successfully !!');
             * } else {
             * $this->session->set_flashdata('error_msg', "An error occurred while inserting data.");
             * }
             * redirect('Statusmaster');
             */
        }
    }

    public function view($id)
    {
        $data['page_title'] = $this->lang->line('leftmenu_status');
        $data['sub_title']  = $this->lang->line('general_view');
        $where              = [
            'sm.id' => $id,
        ];
        $edit_d = $this->Status_master_model->statusview($where);
        // $data['statusm']=$statusm;
        $data['edit_d'] = $edit_d;
        $this->load->view('statusmaster/viewstatusmaster',$data);
        //$this->newtemplate->dashboard("statusmaster/viewstatusmaster", $data);
    }
    
    public function delete($id)
    {
       
        $result = $this->Status_master_model->delete(['id' => $id], true);  // active_only is set to true by default
         echo $result ? "1" : "0";
    }


    public function checkname()
    {
        $post = $this->input->post(null, true);
        extract($post);

        $id           = isset($id) ? $id : "";
        $status_name  = isset($status_name) ? $status_name : "";
        $where        = [];
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code  = isset($post['branch_code']) ? $post['branch_code'] : "";
        if ($company_code == 'RUKN') {
            $where = [
                'status_name'  => $status_name,
                'company_code' => $company_code,
                'status'       => 1,
            ];
        } else {
            $where = [
                'status_name'  => $status_name,
                'company_code' => $company_code,
                'branch_code'  => $branch_code,
                'status'       => 1,
            ];
        }
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'status_name', 'tb_status_master', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }

    public function checkcode()
    {
        $post = $this->input->post(null, true);
        extract($post);

        $id           = isset($id) ? $id : "";
        $status_code  = isset($status_code) ? $status_code : "";
        $company_code = isset($company_code) ? $company_code : "";
        $branch_code  = isset($branch_code) ? $branch_code : "";
        // $id = $this->uri->segment(3);
        $where = [];
        if ($company_code == 'RUKN') {
            $where = [
                'status_code'  => $status_code,
                'company_code' => $company_code,
                'status'       => 1,
            ];
        } else {
            $where = [
                'status_code'  => $status_code,
                'company_code' => $company_code,
                'branch_code'  => $branch_code,
                'status'       => 1,
            ];
        }

        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'status_code', 'tb_status_master', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }

    public function uploadStatusMasterExcel()
    {
        $login_company_code   = $this->session->userdata('company_code');
        $data["company_code"] = $login_company_code;
        $data["branch_code"]  = $login_branch_code  = $this->session->userdata('branch_code');
        $data["created_on"]   = $created_on   = date("Y-m-d H:i:s");
        $data["user_id"]      = $uid      = $this->session->userdata('user_id');
        $excel_orders         = [];

        try {
            if ($_FILES['import_file']['size'] > 0) {
                $inputExcel = $_FILES['import_file']['tmp_name'];

                $objPHPExcel = PHPExcel_IOFactory::load($inputExcel);
                $sheetData   = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);

                for ($i = 2; $i <= count($sheetData); $i++) {
                    $status_name  = $sheetData[$i]['A'] ?? "";
                    $description  = $sheetData[$i]['B'] ?? "";
                    $status_type  = $sheetData[$i]['C'] ?? "";
                    $status_code  = $sheetData[$i]['D'] ?? "";
                    $company_code = $sheetData[$i]['E'] ?? "";
                    $branch_code  = $sheetData[$i]['F'] ?? "";
                    $status_field = $sheetData[$i]['G'] ?? "";

                    $status = ($status_field == "Active") ? 1 : 0;

                    if ($login_company_code == $company_code) {
                        if (($status_name != "") && ($status_type != "") && ($status_code != "") && ($company_code != "") && ($branch_code != "") && ($status != "")) {
                            $getstatusdata = $this->db->select('id')->get_where("tb_status_master", ['status_name' => $status_name, 'company_code' => $company_code]);

                            if ($getstatusdata->num_rows() > 0) {
                                $excel_orders[] = ['status_name' => $status_name, 'company_code' => $company_code, 'upload_status' => 'Already Exists'];
                            } else {
                                $customer_id = 0;

                                $status_data = [
                                    'status_name'  => $status_name,
                                    'description'  => $description,
                                    'status_type'  => $status_type,
                                    'status_code'  => $status_code,
                                    'customer_id'  => $customer_id,
                                    'company_code' => $company_code,
                                    'branch_code'  => $branch_code,
                                    'status'       => $status,
                                    'createdon'    => $created_on,
                                    'updatedon'    => $created_on];
                                $last_insert_id = $this->common->insertTableData("tb_status_master", $status_data);
                            }

                        } else {
                            $excel_orders[] = ['status_name' => $status_name, 'company_code' => $company_code, 'upload_status' => 'Please Check Excel Columns'];
                        }
                    } else {
                        $excel_orders[] = ['status_name' => $status_name, 'company_code' => $company_code, 'upload_status' => 'Please Check Company Code'];
                    }

                }
            }

            if (! empty($excel_orders)) {
                @file_put_contents("assets/statusmasterlist/status_master_list.txt", json_encode($excel_orders));
            }

            redirect('statusmaster/index/01');

        } catch (\Exception $e) {
            log_info($e->getMessage());
        }

    }

    public function deletestatus()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $deleterecorids = implode(",", $this->input->post('deleteids'));
            $query          = $this->db->query("delete from tb_status_master WHERE id IN ($deleterecorids)");
            echo $query ? "success" : "failed";
        }
    }
}
