<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Subusers extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if($this->session->userdata('user_id') == ''){
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('common');
        if (!checkUrlAccessForUser('SUBUSERS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data['page_title'] = $this->lang->line('sub_user_title');;
        $data['sub_title'] = $this->lang->line('sub_user_title');;
        $data['users'] = $this->common->gettbldata(array("status"=>"Active"),"id,CONCAT_WS(' - ', name,company_code,branch_code) as Name","tb_users",0,0);
        $uselect = "tb_user_logins.id,tb_user_logins.user_id,tb_user_logins.name,tb_user_logins.emailid,tb_user_logins.mobile_no,tb_user_logins.business_type,tb_users.company_code,tb_users.branch_code,tb_user_logins.user_code,tb_users.name as adminname";
        $uwhere = array('tb_user_logins.status'=> 1);
        if($this->input->post('user_id')){
            $data['user_id'] = $this->input->post('user_id');
            $uwhere['tb_user_logins.user_id'] = $data['user_id'];
        }
        if($this->input->post('company_code')){
            $data['company_code'] = $this->input->post('company_code');
            $uwhere['tb_users.company_code'] = $data['company_code'];
        }
        if($this->input->post('branch_code')){
            $data['branch_code'] = $this->input->post('branch_code');
            $uwhere['tb_users.branch_code'] = $data['branch_code'];
        }
        if($this->input->post('name')){
            $data['name'] = $this->input->post('name');
            $uwhere['tb_user_logins.name'] = $data['name'];
        }
        if($this->input->post('mobile')){
            $data['mobile'] = $this->input->post('mobile');
            $uwhere['tb_user_logins.mobile_no'] = $data['mobile'];
        }
        if($this->input->post('email')){
            $data['email'] = $this->input->post('email');
            $uwhere['tb_user_logins.emailid'] = $data['email'];
        }
        $data['subusers'] = $this->common->getsubusertbldata($uwhere,$uselect,'tb_user_logins',0,0);
        $this->newtemplate->dashboard("subusers/index", $data);
    }

    public function valPassword($str){
        if(empty($str)){
            $this->form_validation->set_message('valPassword','Confirm Password Required');
            return FALSE;
        } else {
            if($this->input->post('password') == $str){
                return TRUE;
            } else {
                $this->form_validation->set_message('valPassword',"Confirm Password not match with password");
                return FALSE;
            }
        }
    }

    public function checkMobile($mobile){
        if(empty($mobile)){
            $this->form_validation->set_message('checkMobile','Username No Required');
            return FALSE;
        } else {
            $table = 'tb_user_logins';
            $col = 'tb_user_logins.mobile_no';
            $id = $this->uri->segment(3);
            $where = array($col=>$mobile);
            if($id){
                $where['tb_user_logins.id !='] = $id;
            }
            $user = $this->common->gettblrowdatasubusers($where,$col,$table,0,0);
            if(empty($user)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkMobile',"Already User Existed with this username");
                return FALSE;
            }
        }
    }

    public function checkEmail($email){
        if(empty($email)){
            $this->form_validation->set_message('checkEmail','Email Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $table = 'tb_user_logins';
            $col = 'tb_user_logins.emailid';
            $where = array($col=>$email);
            if($id){
                $where['tb_user_logins.id !='] = $id;
            }
            $user = $this->common->gettblrowdatasubusers($where,$col,$table,0,0);
            if(empty($user)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkEmail',"Already User Existed with this Email");
                return FALSE;
            }
        }
    }

    public function checkusercode($user_code){
        if(empty($user_code)){
            $this->form_validation->set_message('checkusercode','User code Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $table = 'tb_user_logins';
            $col = 'tb_user_logins.user_code';
            $where = array($col=>$user_code);
            if($id){
                $where['tb_user_logins.id !='] = $id;
            }
            $user = $this->common->gettblrowdatasubusers($where,$col,$table,0,0);
            if(empty($user)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkusercode',"Already User Existed with this User Code");
                return FALSE;
            }
        }
    }



    public function add()   {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data['page_title'] = $this->lang->line('sub_user_title');
        $data['sub_title'] = $this->lang->line('sub_user_title');
        $data['users'] = $this->common->gettbldata(array("status"=>"Active"),"id,CONCAT_WS(' - ', name,company_code,branch_code) as Name","tb_users",0,0);
        $data['countries'] = $this->common->gettbldata(array('status'=>1),'id,country_name','tbl_country_master',0,0);

        if($_POST){
            $this->form_validation->set_rules('password', 'Password', 'required');
            $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|callback_valPassword');
            /*$this->form_validation->set_rules('user_code', 'Confirm Password', 'required|callback_checkusercode');*/
            $this->form_validation->set_rules('mobile_no', 'Mobile No', 'required|callback_checkMobile');
            $this->form_validation->set_rules('email', 'Email', 'required|callback_checkEmail');

            if ($this->form_validation->run() == false) {
                $this->newtemplate->dashboard('subusers/add', $data);
            } else {
                $userdata = $this->common->gettblrowdata(array('id'=>$this->input->post('user_id')),'company_code,branch_code','tb_users',0,0);
                $array['user_id'] = $this->input->post('user_id');
                $array['name'] = $this->input->post('name');
                $array['mobile_no'] = $this->input->post('mobile_no');
                $array['business_type'] = $this->input->post('business_type');
                $array['emailid'] = $this->input->post('email');
                $array['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                $array['company_code'] = $userdata['company_code'];
                $array['branch_code'] = $userdata['branch_code'];
                $array['user_code'] = $this->input->post('user_code');
                $array['status'] = 1;
                $array['created_at'] = date('Y-m-d H:i:s');
                $array['updated_at'] = date('Y-m-d H:i:s');
                //print_r($array); exit;
                $this->common->insertTableData('tb_user_logins',$array);

                redirect('subusers');
            }
        } else {
            $this->newtemplate->dashboard('subusers/add', $data);
        }
    }

    public function edit($id) {
        $data['page_title'] = $this->lang->line('sub_user_title');
        $data['sub_title'] = $this->lang->line('sub_user_title');;
        $data['users'] = $this->common->gettbldata(array("status"=>"Active"),"id,CONCAT_WS(' - ', name,company_code,branch_code) as Name","tb_users",0,0);
        $data['user'] = $this->common->gettblrowdatasubusers(array('tb_user_logins.id'=>$id),'tb_user_logins.*','tb_user_logins',0,0);
        //echo '<pre>'; print_r($data['user']); exit;
        if(isset($data['user']['id'])) {
            if($_POST){
                $this->form_validation->set_rules('mobile_no', 'Mobile No', 'required|callback_checkMobile');
                $this->form_validation->set_rules('email', 'Email', 'required|callback_checkEmail');
                /*$this->form_validation->set_rules('user_code', 'User Code', 'required|callback_checkusercode');*/
                if ($this->form_validation->run() == false) {
                    $this->newtemplate->dashboard('subusers/edit', $data);
                } else {
                    $userdata = $this->common->gettblrowdata(array('id'=>$this->input->post('user_id')),'company_code,branch_code','tb_users',0,0);
                    $array['user_id'] = $this->input->post('user_id');
                    $array['name'] = $this->input->post('name');
                    $array['mobile_no'] = $this->input->post('mobile_no');
                    $array['business_type'] = $this->input->post('business_type');
                    $array['emailid'] = $this->input->post('email');
                    $array['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                    $array['company_code'] = $userdata['company_code'];
                    $array['branch_code'] = $userdata['branch_code'];
                    $array['user_code'] = $this->input->post('user_code');
                    $array['status'] = $this->input->post('status');
                    $array['updated_at'] = date('Y-m-d H:i:s');

                    // User Updation
                    $upd = $this->common->updatetbledata('tb_user_logins',$array,array('id'=>$id));
                }
                redirect('subusers');
            } else {
                $this->newtemplate->dashboard('subusers/edit', $data);
            }
        } else {
            show_error('The User you are trying to Edit does not exist.');
        }
    }

    public function deleteuser($id){
        if($id != '' || $id != 0){
            $chk = $this->common->gettblrowdatasubusers(array('tb_user_logins.id'=>$id),'tb_user_logins.status','tb_user_logins',0,0);
            if($chk){
                $upd = $this->common->updatetbledata('tb_user_logins',array('status'=>0),array('id'=>$id));
                if($upd){
                    echo "1";
                }else{
                    echo "0";
                }
            }else{
                echo "0";
            }
        }
    }

    public function view($id){
        $data['page_title'] = $this->lang->line('sub_user_title');
        $data['sub_title'] = $this->lang->line('sub_user_title');
        $uselect = "tb_user_logins.*,tb_users.name as adminname";
        $data['user'] = $this->common->gettblrowdatasubusers(array('tb_user_logins.id'=>$id),$uselect,'tb_user_logins',0,0);
        $this->newtemplate->dashboard('subusers/view', $data);
    }

    public function getParentcid(){
        $term = $this->input->post('term');
        $company_code = $this->input->post('company_code');
        $branch_code = $this->input->post('branch_code');
        $result = array();
        $this->load->model('mastersmodel');
        if(!empty($company_code) && !empty($branch_code)){
            $where = array('company_code'=>$company_code,"branch_code"=>$branch_code,'status'=>1,'code !='=> null);
            $select = 'id,code as cid,name,phone,company_code,branch_code';
            $like = array('code'=>$term);
            // $result = $this->common->gettbldata($where,'id,cid,name,phone,company_code,branch_code','tb_customers',0,0);
            $result = $this->mastersmodel->getsearchdata($like,$where,$select,'tb_customers');
        }
        echo  json_encode($result);
    }

    public function finduserbyname()
    {
       $data = $this->common->gettbldata(array("name"=>$this->input->post('knadmin')),"id,name,company_code,branch_code","tb_users",0,0);
       echo json_encode($data);
    }
    public function viewuserbyname()
    {
       $data = $this->common->gettbldata(array("status"=>'Active'),"id,name,company_code,branch_code","tb_users",0,0);
       echo json_encode($data);
    }

}

