<?php if(!defined('BASEPATH')) { exit( 'No direct script access allowed' ); }
use App\Pagination\Pagination;

class TatKPI extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
		$this->load->model('Tatkpimodel');
        if (!checkUrlAccessForUser('TATKPI')) {
            redirect("Forbiddenaccess");
        }
	}

	public function index()
	{
		$timeZone = $this->session->userdata( "usr_tzone" )['timezone'];
		$data = $bindParams = [];
		$data['page_title'] = $this->lang->line('leftmenu_reports');
		$data['sub_title'] = $this->lang->line('menu_tatkpireport');
		$bindParams[] = $timeZone;
		$bindParams[] = $timeZone;
		$userId 	= $this->session->userdata('user_id');
        $fromDate 	= date('Y-m-01');
        $toDate 	= date('Y-m-d');
        $companyCode = $this->session->userdata("company_code");
        $where = " where o.company_code = ? ";
		$bindParams[] = $companyCode;
        if ($_POST)
        {
			if (isset($_POST['fromdate']) && !empty($_POST['fromdate'])) {
				$where .= " AND DATE(o.createdon) >= ? ";
				$fromDate = date('Y-m-d',strtotime($_POST['fromdate']));
				$bindParams[] = $fromDate;
			}
			if (isset($_POST['todate']) && !empty($_POST['todate'])) {
				$where .= " AND DATE(o.createdon) <= ? ";
				$toDate = date('Y-m-d',strtotime($_POST['todate']));
				$bindParams[] = $toDate;
			}
			if (isset($_POST['bookingid']) && !empty($_POST['bookingid'])) {
				$where .= " AND o.order_id IN ? ";
				$bindParams[] = $_POST['bookingid'];
			}
			if (isset($_POST['tripid']) && !empty($_POST['tripid'])) {
				$where .= " AND o.shipmentid IN ? ";
				$bindParams[] = $_POST['tripid'];
			}
			if (isset($_POST['status']) && in_array($_POST['status'], [0,1,2])) {
				$status = (int)$_POST['status'];
				if($status==0)
				{
					$where .= " AND o.trip_id = ? AND o.status != ? AND o.trip_sts = ? ";
					$bindParams[] = 0; $bindParams[] = 0; $bindParams[] = 0;
				}
				else if($status==1)
				{
					$where .= " AND o.trip_id != ? AND o.status != ? AND o.trip_sts = ? ";
					$bindParams[] = 0; $bindParams[] = 0; $bindParams[] = 0;
				}
				else if($status==2)
				{
					$where .= " AND o.trip_sts= ? ";
					$bindParams[] = 1;
				}
			}
        }
        else
        {
			$where .= " AND date(o.createdon) >= ? ";
			$bindParams[] = $fromDate;
			$where .= " AND date(o.createdon) <= ? ";
			$bindParams[] = $toDate;
        }
        $limit 	= isset($_POST['limit']) && (int) $_POST['limit'] > 0 ? $_POST['limit'] : 100;
        $offset = isset($_POST['offset']) && (int) $_POST['offset'] > 0 ? $_POST['offset'] : 0;
        $tripResult = $this->Tatkpimodel->getReports($where, $bindParams, $limit, $offset);
        $tripData = [];
        if($tripResult)
        {
        	$checkDate    = '2020-07-01 00:00:00';
            $checkTime    = strtotime($checkDate);
        	foreach ($tripResult as $trip) {
        		$trip 			= (object)$trip;
	        	$createdon    	= $trip->createdon ? $trip->createdon : '0000-00-00';
            	$orderStr    	= strtotime( $createdon );
            	$earlyPickup 	= $trip->pickup_datetime;
            	$earlyDelivery  = $trip->delivery_datetime;
            	$latePickup 	= $trip->pickup_endtime;
            	$lateDelivery 	= $trip->drop_endtime;
            	if ($orderStr > $checkTime)
            	{
					if ( $earlyPickup != "" && $earlyPickup != "0000-00-00 00:00:00" ) {
					    $epickup      = getdatetimebytimezone( $timeZone, $earlyPickup, DFLT_TZ );
					    $earlyPickup = $epickup['datetime'];
					}
					if ( $earlyDelivery != "" && $earlyDelivery != "0000-00-00 00:00:00" ) {
					    $edelivery      = getdatetimebytimezone( $timeZone, $earlyDelivery, DFLT_TZ );
					    $earlyDelivery = $edelivery['datetime'];
					}
					if ( $latePickup != "" && $latePickup != "0000-00-00 00:00:00" ) {
					    $lpickup     = getdatetimebytimezone( $timeZone, $latePickup, DFLT_TZ );
					    $latePickup = $lpickup['datetime'];
					}
					if ( $lateDelivery != "" && $lateDelivery != "0000-00-00 00:00:00" ) {
					    $ldelivery     = getdatetimebytimezone( $timeZone, $lateDelivery, DFLT_TZ );
					    $lateDelivery = $ldelivery['datetime'];
					}
            	}
            	$orderPkId = $trip->id;
            	$tripId = $trip->trip_id;
            	$tripPickupDeliveryDetails = ['pickup'=>'','delivery'=>'','pickup_delay'=>'','delivery_delay'=>''];
            	if($tripId > 0)
            	{
            		$tripPickupDeliveryDetails = $this->getActualLatePickupDeliveryDetails($orderPkId, $tripId, $timeZone, $latePickup, $lateDelivery);
            	}
        		$tripData[] = (object)[
        			'id'					=> $orderPkId,
        			'shift_id'				=> $trip->shift_id,
        			'register_number'		=> $trip->register_number,
        			'trip_id'				=> $tripId,
        			'shipmentid'			=> $trip->shipmentid,
        			'order_id'				=> $trip->order_id,
        			'actual_pickup'			=> $tripPickupDeliveryDetails['pickup'],
        			'actual_delivery'		=> $tripPickupDeliveryDetails['delivery'],
        			'pickup_delay'			=> $tripPickupDeliveryDetails['pickup_delay'],
        			'delivery_delay'		=> $tripPickupDeliveryDetails['delivery_delay'],
        			'late_pickup'			=> $latePickup,
        			'late_delivery'			=> $lateDelivery,
        			'start_time'			=> $trip->start_time,
        			'end_time'				=> $trip->end_time,
        			'name'					=> $trip->name,
        			'contact_num'			=> $trip->contact_num,
        			'dvrlate'				=> $trip->dvrlate
        		];
        	}
        }
        $data['fromDate'] 	= $fromDate;
        $data['toDate'] 	= $toDate;
        $data['limit'] 		= $limit;
        $data['offset'] 	= $offset;
		$data['trip_data'] 	= $tripData;
		$data['bookingIds'] = isset($_POST['bookingid']) ? $_POST['bookingid'] : [];
		$data['tripIds'] = isset($_POST['tripid']) ? $_POST['tripid'] : [];
		$data['status'] 	= isset($_POST['status']) ? $_POST['status'] : '';
		$this->newtemplate->dashboard("tatkpi/tatkpireport", $data);
	}

	private function getActualLatePickupDeliveryDetails(int $orderId, int $tripId, string $timeZone, string $latePickup, string $lateDelivery): array
	{
		$response = $this->Tatkpimodel->getTripStopDateTimeInfo($orderId, $tripId, $timeZone);
		$response['pickup_delay']="";
		$response['delivery_delay']="";
		if(!empty($response['pickup']))
		{
			$response['pickup_delay']="<i class='fa fa-check-circle' style='color:green;'></i>";
			$actualPickup = strtotime($response['pickup']);
			$latePickup = strtotime($latePickup);
			if($actualPickup > $latePickup)
			{
				$duration = $actualPickup - $latePickup;
				$response['pickup_delay'] = "<i class='fa fa-times-circle' style='color:red;'></i> ".$this->convertTimeToString($duration);
			}
		}
		if(!empty($response['delivery']))
		{
			$response['delivery_delay']="<i class='fa fa-check-circle' style='color:green;'></i>";
			$actualDelivery = strtotime($response['delivery']);
			$lateDelivery = strtotime($lateDelivery);
			if($actualDelivery > $lateDelivery)
			{
				$duration = $actualDelivery - $lateDelivery;
				$response['delivery_delay'] = "<i class='fa fa-times-circle' style='color:red;'></i> ".$this->convertTimeToString($duration);
			}
		}
		return $response;
	}

	private function convertTimeToString(int $duration): string
	{
		$mins = floor($duration / 60);
		$hours = str_pad(floor($mins /60),2,"0",STR_PAD_LEFT);
		$mins  = str_pad($mins %60,2,"0",STR_PAD_LEFT);
		$mins  = $mins > 0 ? $mins." min(s)" : "";
		$days = "";
		if((int)$hours > 24)
		{
			$days = str_pad(floor($hours /24),2,"0",STR_PAD_LEFT);
			$hours = str_pad($hours %24,2,"0",STR_PAD_LEFT);
		}
		$hours  = $hours > 0 ? $hours." hour(s) " : "";
		if($days) { $days = $days." day(s) ";}
		return $days.$hours.$mins;
	}

	public function getTripIds(): void
	{
		$this->load->library('SearchService');
		$post = $this->input->post(null, true);
        echo json_encode(
            $this->searchservice->searchForTripIds(
                $post['searchTerm'] ?? ''
            )
        );
	}
}
