<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * get the Orders from MFT folder to TOll Carrier Folder (TOLL Carrier)
 *
 *
 *
 * @author          Developer Name external.tirupathi.g@kuehne-nagel.com
 * @date            12-07-2022 18:00:00+05.30
 * @change          Asia
 * @copyright       2022 TMS
 * @authentication  Not Required
 */
use phpseclib\Net\SFTP;

class Tollcarriercronjob extends CI_Controller
{

    public function index()
    {
        $ci = &self::get_instance();
        $ci->load->library('tollcarrieredi');
        $service = $ci->tollcarrieredi;
        $folder_name = "/pub/outbound/etntoll/";
        $toll_folder_name = TOLL_FOLDER;

        $sftp = $service->connect(
            ...$service->sftpBoomiSetup()
        );

        if (empty($files_list = $service->getFilesList($sftp, $folder_name))) {
            return;
        }

        $files = [];

        foreach ($files_list as $fileName) {
            try {
                $files [$fileName] = $sftp->get($folder_name . $fileName);
            } catch (\Exception $e) {
                log_message('error', "Cant read file {$fileName}");
                continue;
            }
        }

        $sftptoll = $service->connectWithProxy(
            ...$service->sftpTollSetup()
        );

        foreach ($files as $fileName => $contents) {
            $service->storeFile(
                $sftptoll,
                $toll_folder_name,
                $fileName,
                $contents
            );
            $sftp->delete($folder_name . $fileName, false);
        }

        log_message('error', 'sftp connection, directory after upload: '.
            print_r ($service->getFilesList($sftptoll, $toll_folder_name), true)
        );
    }

}
