<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Tracking extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('log_helper');
    }

    public function index($param1 = '')
    {
        $this->load->view('tracking/index');
    }

    // the below method will fetch the tracking related details
    public function orderTracking($param1 = '')
    {
        $data = $deliveredStatusArray = array();
        $userId = $statusIcon = '';
        $data['status_icon'] = '';
        if ($this->session->userdata("user_id")) {
            $userId = $this->session->userdata("user_id");
        }
        $this->load->model('TrackingService_model');
        $this->load->model('DataQueryFormatter_model');
        if (($this->input->post('tracking_number') != '')) {
            $tracking_number = $this->input->post('tracking_number', true);
            $result = $this->TrackingService_model->getOrderInfoDetails($tracking_number);
            if (sizeof($result) == 1) {
                $result = $this->TrackingService_model->getOrderInfoFromReference($tracking_number);
            }
            if (!empty($result) && sizeof($result) > 0) {
                $data = $result;
                $data['last_status'] = 'Last Status';
                $data['last_status_date'] = 'N/A';
                $data['vehicle_type'] = 'N/A';
                $data['vehicle_number'] = 'N/A';
                $data['vehicle_location'] = 'N/A';
                $quantity = $data['quantity'];
                $weight = $data['weight'];
                $volume = $data['volume'];
                $branch_code = $data['branch_code'];
                $data['weight_unit'] = 'Kgs';
                $data['volume_unit'] = 'Cbm';
                $data['route_milage'] = $data['delivertime'] = 'N/A';
                $data['no_of_pkgs'] = "Number Of Packages";
                if ($branch_code == "INCL") {
                    $data['no_of_pkgs'] = "Number Of Items";
                }
                $data['shipment_eta'] = 'N/A';
                $data['cargo_type'] = '';
                $data['status_codes'] = array();
                $cargoType = '';
                $order_id = $data['order_id'];
                $oid = $data['id'];
                $shipid = $data['shift_id'];
                if ($data['created_source'] == '16') {
                    $order_type = "Return";
                } else {
                    $order_type = $this->TrackingService_model->getOrderTypeByID($oid);
                }
                $data['order_type'] = $order_type;
                if ($data['order_type'] == "Return") {
                    $data['order_type'] = "Return Order";
                } elseif ($data['order_type'] == "SO" || $data['order_type'] == "Contact Logistics") {
                    $data['order_type'] = "Sale Order";
                } elseif ($data['order_type'] == "CC") {
                    $data['order_type'] = "Click & Collect";
                }
                $data['order_type_name_new'] = 'Booking Type: ';
                $data['accept_sts_name'] = "Accepted";
                $data['transit_sts_name'] = "In Transit";
                $data['deliver_sts_name'] = "Delivered";
                $data['close_sts_name'] = "Completed";
                if ($data['branch_code'] == "INCL" && $data['order_type'] != "CC") {
                    $data['accept_sts_name'] = "Picked up";
                    $data['transit_sts_name'] = "In Transit";
                    $data['deliver_sts_name'] = "Out for delivery";
                    $data['close_sts_name'] = "Delivered";
                    if ($data['created_source'] == '16') {
                        $data['transit_sts_name'] = "In Transit for return";
                        $data['deliver_sts_name'] = "Out for return";
                        $data['close_sts_name'] = "Returned";
                    }
                }
                $containernumber = $rtoType = "";
                if ($data['branch_code'] == "INCL") {
                    $data['cargo_details_under_routing'] = '0';
                    $data['vehicleInformation'] = '0';
                    $data['pickanddelivery'] = '0';
                    $data['shipping_information_block'] = '0';
                    $orderref = $this->db->query(
                        "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$oid AND status=1 AND reference_id IN('DQ','PO','XSR','ORD','AWB','OT','REFAWB') GROUP BY id"

                    );$i = 1;
                    $order_res = "";
                    $uni_shipment = $shipment = $docket = "";
                    if ($orderref->num_rows() > 0) {
                        foreach ($orderref->result_array() as $rres) {
                            if ($rres['reference_id'] == "AWB") {
                                $containernumber = $rres['ref_value'];
                            }
                            if ($rres['reference_id'] == "REFAWB") {
                                $rtoType = $rres['ref_value'];
                            }
                            if ($data['created_source'] == 15) {
                                $data['uni_shipment_name'] = 'UNI Shipment ID:';
                                $data['shipment_name'] = 'Shipment ID:';
                                $data['docket_name'] = 'Carrier Docket No:';
                                if ($rres['reference_id'] == "XSR") {
                                    $data['uni_shipment_ref_value'] = $uni_shipment = $rres['ref_value'];
                                }
                                if ($rres['reference_id'] == "DQ") {
                                    $data['order_id'] = $data['shipment_ref_value'] = $shipment = $rres['ref_value'];
                                }
                            } elseif ($data['created_source'] == 16) {
                                $data['uni_shipment_name'] = 'Return Order No:';
                                $data['shipment_name'] = 'Original Order No:';
                                $data['docket_name'] = 'Carrier Docket No:';
                                if ($rres['reference_id'] == "DQ") {
                                    $data['order_id'] = $data['uni_shipment_ref_value'] = $uni_shipment = $rres['ref_value'];
                                }
                                if ($rres['reference_id'] == "XSR") {
                                    $data['shipment_ref_value'] = $shipment = $rres['ref_value'];
                                }
                            }
                            if ($rres['reference_id'] == "OT") {
                                $order_res .= $rres['ref_value'] . ",";
                            }
                            if ($rres['reference_id'] == "AWB") {
                                $data['docket_ref_value'] = $docket = $rres['ref_value'];
                            }
                        }
                    }
                }
                
                $data['coordinates']['legs']=$data['legs'];
                $data['coordinates']['plat'] = $data['plat'];
                $data['coordinates']['plng'] = $data['plng'];
                $data['coordinates']['dlat'] = $data['dlat'];
                $data['coordinates']['dlng'] = $data['dlng'];
                $data['coordinates']['shift_id'] = $data['shift_id'];
                
                if ($data['plat'] == '' || $data['plng'] == '' || $data['dlat'] == '' || $data['dlng'] == '') {
                    $pickup_street = mb_strtoupper(
                        isset($data['pickup_address1']) ? trim($data['pickup_address1']) : ""
                    );
                    $pickup_city = mb_strtoupper(isset($data['pickup_city']) ? trim($data['pickup_city']) : "");
                    $pickup_country = mb_strtoupper(
                        isset($data['pickup_country']) ? trim($data['pickup_country']) : ""
                    );
                    $pickup_pincode = mb_strtoupper(
                        isset($data['pickup_pincode']) ? trim($data['pickup_pincode']) : ""
                    );
                    $drop_street = mb_strtoupper(
                        isset($data['delivery_address1']) ? trim($data['delivery_address1']) : ""
                    );
                    $drop_city = mb_strtoupper(isset($data['delivery_city']) ? trim($data['delivery_city']) : "");
                    $drop_country = mb_strtoupper(
                        isset($data['delivery_country']) ? trim($data['delivery_country']) : ""
                    );
                    $drop_pincode = mb_strtoupper(
                        isset($data['delivery_pincode']) ? trim($data['delivery_pincode']) : ""
                    );
                    $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
                    $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
                    // overriding the lat lng if they dont present in the orders table
                    if ($data['plat'] == '' || $data['plng'] == '') {
                        $ploc = $this->getLatLngByAddress($add1);
                        $data['plat'] = $ploc['lat'];
                        $data['plng'] = $ploc['lng'];
                    }
                    // overriding the lat lng if they dont present in the orders table
                    if ($data['dlat'] == '' || $data['dlng'] == '') {
                        $dloc = $this->getLatLngByAddress($add2);
                        $data['dlat'] = $dloc['lat'];
                        $data['dlng'] = $dloc['lng'];
                    }
                }
                
                $veh_details = [];
                if ($shipid > 0 and $shipid != '' and $shipid != "0") {
                    $veh_details = $this->TrackingService_model->getVehicleDetails($shipid);
                    $data['coordinates']['clat'] = $veh_details['latitude'] ?? $data['plat'];
                    $data['coordinates']['clng'] = $veh_details['longitude'] ?? $data['plng'];
                    $data['order_veh_num'] = isset($veh_details['truck_number']) ? $veh_details['truck_number'] : 'N/A';
                } else {
                    $data['coordinates']['clat'] = $data['plat'];
                    $data['coordinates']['clng'] = $data['plng'];
                }
                
                //default assigning current location to pickup address
                /*$data['coordinates']['clat'] = $data['plat'];
                $data['coordinates']['clng'] = $data['plng'];*/
                $data['exp_delivertimedonemsg'] = 'Expected Delivery Date: ';
                $data['delivertimedonemsg'] = "Actual Delivered Date: ";
                $data['exp_delivertime'] = 'N/A';
                $curtz = $this->TrackingService_model->getUserTimezone($data['user_id']);
                $data["timezone"] = $timezone = $curtz;
                $manifesttime = "";
                if ($shipid > 0) {
                    if ($data['branch_code'] == "INCL") {
                        $sql = $this->db->query(
                            "SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,ts.status_id,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,sm.status_name,ss.startdate,ss.enddate,ts.reason
                            FROM tb_stop_status ts
                            LEFT JOIN tb_status_master sm ON sm.id=ts.status_id
                            LEFT JOIN tb_shiporder_stops ss ON sm.id=ts.stop_id
                            WHERE ts.shipment_id = '$shipid' AND ts.status_code IN('0470','0420','1550','0500','0191','2990','2989','0192','2300','RTO','3050','3000','2400','DTO','3051') GROUP BY ts.id ORDER BY ts.id ASC"
                        );
                    } else {
                        $sql = $this->db->query(
                            "SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,ts.status_code,ts.status_id,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,sm.status_name,ss.startdate,ss.enddate,ts.reason
                            FROM tb_stop_status ts
                            LEFT JOIN tb_status_master sm ON sm.id=ts.status_id
                            LEFT JOIN tb_shiporder_stops ss ON sm.id=ts.stop_id
                            WHERE ts.shipment_id = '$shipid' GROUP BY ts.id ORDER BY ts.id ASC"
                        );
                    }
                    if ($sql->num_rows() > 0) {
                        foreach ($sql->result_array() as $exp) {
                            if ($exp['status_code'] == '0470') {
                                $manifesttime = $exp['createdon'];
                            }
                            if ($exp['stop_type'] == "D" && (($exp['status_code'] == 'DTO' || $exp['status_code'] == '2300' || $exp['status_id'] == 1) || ($data['vendor_id'] == "310" && $exp['status_code'] == 'RTO'))) {
                                $data['delivertime'] = ucwords(date("d M Y", strtotime($exp['createdon'])));
                            }
                        }
                    }
                    $data["history"] = $sql;
                    $data['epod'] = array();
                    if ($order_type == 'CC' || $branch_code != 'INCL') {
                        $docs = $this->db->select(
                            "id,stop_id,stop_type,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon"
                        )->get_where(
                            "tb_pod_uploads",
                            array("shipment_id" => $shipid, "doc_type" => 3, "status" => 1),
                            1,
                            0
                        );
                        if ($docs->num_rows() > 0) {
                            $data['epod'] = array(
                                "status_code" => "3060",
                                "status_name" => "ePOD Available",
                                "stop_id" => $docs->row()->stop_id,
                                "stop_type" => $docs->row()->stop_type,
                                "location" => getLocationName($docs->row()->latitude, $docs->row()->longitude),
                                "createdon" => $docs->row()->createdon
                            );
                        }
                    }
                }
                if ($containernumber != "") {
                    $chkexpdeliver = $this->getexpdeliverByPushApiData($containernumber,$oid);
                    if ($chkexpdeliver != "") {

                        $data['exp_delivertime'] = ucwords(date("d M Y", strtotime($chkexpdeliver)));
                    }
                    else {
                        if ($data['created_source'] == '16') {
                            $etapincode = $data['pickup_pincode'];
                            $ordtype = 0;
                        } else {
                            $etapincode = $data['delivery_pincode'];
                            $ordtype = 1;
                        }
                        /* get carrier pincode tat values */
                        if (checkAccessConditions('CHECK_UNIQLO_CARRIER', $data['vendor_id'])) {
                            if ($manifesttime != "") {
                                $chkexpdeliver = $this->getexpdeliverByOrderPin(
                                    $etapincode,
                                    $ordtype,
                                    $manifesttime,
                                    $data['vendor_id']
                                );
                                if ($chkexpdeliver != "") {
                                    if (strpos($chkexpdeliver, "1970-01-01") === false) {
                                        $data['exp_delivertime'] = ucwords(date("d M Y", strtotime($chkexpdeliver)));
                                    }
                                }
                            }
                        }
                    }
                }
                $cargoArray = $this->TrackingService_model->getWeightAndVolumeCount($data['id']);
                if (!empty($cargoArray) && sizeof($cargoArray) > 0) {
                    if ($branch_code != 'INCL') {
                        $data['weight'] = $cargoArray['weight'];
                        $data['second_weight'] = $cargoArray['second_weight'];
                        $data['volumetric_weight'] = $cargoArray['volumetric_weight'];
                        $data['quantity'] = round($cargoArray['quantity']);
                        $data['volume'] = $cargoArray['volume'];
                        $data['cargo_type'] = $cargoArray['cargo_type'];
                        if ($cargoArray['weight_unit'] != '') {
                            $data['weight_unit'] = $cargoArray['weight_unit'];
                        }
                        if ($cargoArray['volume_unit'] != '') {
                            $data['volume_unit'] = $cargoArray['volume_unit'];
                        }
                        if ($data['company_code'] == 'INKN') {
                            if (($cargoArray['weight_unit'] == "G") || ($cargoArray['weight_unit'] == "gms") || ($cargoArray['weight_unit'] == "")) {
                                $data['weight_unit'] = "Kgs";
                            }
                            if ($data['weight'] != '0.00' && $data['weight'] > $data['volumetric_weight']) {
                                $data['weight'] = $data['weight'];
                            } elseif ($data['volumetric_weight'] != '' && $data['volumetric_weight'] > $data['weight']) {
                                $data['weight'] = $data['volumetric_weight'];
                            } elseif ($data['volumetric_weight'] == $data['weight']) {
                                $data['weight'] = $data['weight'];
                            }
                        }
                    } else {
                        if (($cargoArray['weight_unit'] == "G") || ($cargoArray['weight_unit'] == "gms") || ($cargoArray['weight_unit'] == "")) {
                            $data['weight_unit'] = "Kgs";
                            $data['weight'] = round(($data['weight'] / 1000), 2);
                        }
                        if ($cargoArray['volume_unit'] != "Cbm") {
                            $data['volume_unit'] = "Cbm";
                            if ($data['volume'] > 0) {
                                $data['volume'] = round(($data['volume'] / 1000000), 2);
                            }
                        }
                    }
                }
                if ($data['weight'] == "N/A" || $data['weight'] == "") {
                    $data['weight'] = '0.00';
                }
                if ($data['volume'] == "N/A" || $data['volume'] == "") {
                    $data['volume'] = '0.00';
                }
                if ($branch_code == 'INCL') {
                    $data['cargo_type'] = $data['product'];
                }
                $pickup_address1 = $pickup_city = $pickup_country = $pickup_pincode = $delivery_address1 = $delivery_city = $delivery_country = $delivery_pincode = $pickup_address2 = $delivery_address2 = $delivery_company = $pickup_company = "";
                $pickup_address1 = (!empty($data['pickup_address1'])) ? $data['pickup_address1'] . ' , ' : "";
                $pickup_address2 = (!empty($data['pickup_address2'])) ? $data['pickup_address2'] . ' , ' : "";
                $pickup_city = (!empty($data['pickup_city'])) ? $data['pickup_city'] . ' , ' : "";
                $pickup_country = (!empty($data['pickup_country'])) ? $data['pickup_country'] . ' , ' : "";
                $pickup_pincode = (!empty($data['pickup_pincode'])) ? $data['pickup_pincode'] . ' , ' : "";

                $delivery_address1 = (!empty($data['delivery_address1'])) ? $data['delivery_address1'] . ' , ' : "";
                $delivery_address2 = (!empty($data['delivery_address2'])) ? $data['delivery_address2'] . ' , ' : "";
                $delivery_city = (!empty($data['delivery_city'])) ? $data['delivery_city'] . ' , ' : "";
                $delivery_country = (!empty($data['delivery_country'])) ? $data['delivery_country'] . ' , ' : "";
                $delivery_pincode = (!empty($data['delivery_pincode'])) ? $data['delivery_pincode'] . ' , ' : "";
                /*logged in check*/
                if ($userId != '') {
                    $data['is_logged_in'] = 1;
                    $pickup_address = $pickup_address1 . ", " . $pickup_address2 . ", " . $pickup_city . ", " . $pickup_country . ", " . $pickup_pincode;
                    $delivery_address = $delivery_address1 . ", " . $delivery_address2 . ", " . $delivery_city . ", " . $delivery_country . ", " . $delivery_pincode;
                } else {
                    $data['is_logged_in'] = 0;
                    $pickup_address = $pickup_city . ", " . $pickup_pincode;
                    $delivery_address = $delivery_city . ", " . $delivery_pincode;
                    if ($branch_code == "INCL") {
                        $pickup_address = $pickup_address1 . ", " . $pickup_address2 . ", " . $pickup_city . ", " . $pickup_country . ", " . $pickup_pincode;
                        $delivery_address = $delivery_address1 . ", " . $delivery_address2 . ", " . $delivery_city . ", " . $delivery_country . ", " . $delivery_pincode;
                    }
                }
                $pickup_addressarr = explode(",", $pickup_address);
                $pickarr = array_map("trim", $pickup_addressarr);
                $pickarr1 = array_unique($pickarr);
                $pickup_address = implode(", ", $pickarr1);
                $delivery_addressarr = explode(",", $delivery_address);
                $deliverarr = array_map("trim", $delivery_addressarr);
                $deliverarr1 = array_unique($deliverarr);
                $delivery_address = implode(", ", $deliverarr1);
                $pickupAndDeliveryTime = $earlyDelivery = $actualDeliveryDate = '';
                $dateToBeConsidered = $data['createdon'];
                if ($branch_code != "INCL") {
                    if ($data['pickup_datetime'] != '' && $data['pickup_datetime'] != "0000-00-00 00:00:00" && $data['pickup_datetime'] != "0") {
                        $dateToBeConsidered = $data['pickup_datetime'];
                        $pickup_status_array = getdatetimebytimezone($curtz, $data['pickup_datetime'], DFLT_TZ);
                        $pickupAndDeliveryTime .= "Pickup : ";
                        $pickupAndDeliveryTime .= $this->formatDate(
                            date('d M Y h:i A', strtotime($pickup_status_array['datetime'])),
                            1
                        );
                    }
                    if ($data['delivery_datetime'] != '' && $data['delivery_datetime'] != "0000-00-00 00:00:00" && $data['delivery_datetime'] != "0") {
                        $delivery_status_array = getdatetimebytimezone($curtz, $data['delivery_datetime'], DFLT_TZ);
                        if ($data['company_code'] == 'INKN') {
                            $pickupAndDeliveryTime .= "</br>Expected Delivery : ";
                            $pickupAndDeliveryTime .= $this->formatDate(
                                date('d M Y h:i A', strtotime($delivery_status_array['datetime'])),
                                1
                            );
                            $pickupAndDeliveryTime .= "</br>Actual Delivery : ";
                        } else {
                            $pickupAndDeliveryTime .= "</br> Delivery : ";
                            $pickupAndDeliveryTime .= $this->formatDate(
                                date('d M Y h:i A', strtotime($delivery_status_array['datetime'])),
                                1
                            );
                        }
                        $earlyDelivery = $this->formatDate(
                            date('d M Y h:i A', strtotime($delivery_status_array['datetime'])),
                            1
                        );
                    }
                }
                $data['pickup_delivery_datetime'] = $pickupAndDeliveryTime;
                $data['pickup_address'] = trim($pickup_address, ' , ');
                $data['delivery_address'] = trim($delivery_address, ' , ');
                if ($order_type == 'CC' || $branch_code != 'INCL') {
                    if ($data['shift_id'] != '' && $data['shift_id'] != 0) {
                        $vehicleDetails = $this->TrackingService_model->getVehicleDetails($data['shift_id']);
                        if (isset($vehicleDetails) && sizeof($vehicleDetails) > 0 && !empty($vehicleDetails)) {
                            $data['vehicle_type'] = $vehicleDetails['trucktype'];
                            if (($vehicleDetails['truck_number']) && (checkAccessConditions('DISPLAY_VEHICLE_NUMBER_IN_PTRACKING', $data['company_code']))) {
                                $data['vehicle_type'] = $vehicleDetails['trucktype'].' <span id="displayVehichleNumber" style="display:none;">( <b><i class="fa fa-truck"></i>'.$vehicleDetails['truck_number'].' )</b></span>';
                            }
                            $vlat = $vehicleDetails['latitude'];
                            $vlong = $vehicleDetails['longitude'];
                            /* get vehicle location based on the lat long details. */
                            if ($vlat != '' && $vlong != '') {
                                $data['vehicle_location'] = $this->getLocationByLatLng($vlat, $vlong);
                                $data['coordinates']['clat'] = $vlat;
                                $data['coordinates']['clng'] = $vlong;
                            }
                        }
                        $deliveredStatusArray = $this->TrackingService_model->getDriverAcceptanceAndDeliveredStatus(
                            $data['shift_id']
                        );
                    }
                }
                if ($branch_code == 'INCL' && $order_type != 'CC') {
                    $lastStatus = ['scan_val' => '', 'scan_datetime' => '', 'status_info' => ''
                    ];$allStatusArray = array();
                    $accordion_index = 1;
                    $shipment_location = "";
                    $transit_status_html = $transit_status_html_table = '';
                    $this->db->query('SET SESSION group_concat_max_len=102400');
                    if ($data['vendor_id'] == '311') {
                        $statusDetails = $this->TrackingService_model->getEcomOrderStatusDetailsNew(
                            $data['id'],
                            $data['created_source'],
                            $rtoType
                        );
                    } else {
                        $statusDetails = $this->TrackingService_model->getOrderStatusDetailsNew(
                            $data['id'],
                            $data['created_source']
                        );
                    }
                    $data['status_codes'][] = array();
                    if (sizeof($statusDetails) > 0) {
                        $tempStatus = end($statusDetails);
                        if (!empty($tempStatus)) {
                            $data['last_status'] = $tempStatus['scan_value'];
                            $last_status_date = date("d M Y", strtotime($tempStatus['scan_datetime']));
                            /* to get the last status value from order scan data */
                            $recentStatus = $tempStatus['status_info'];
                            $lastStatusDateInfo = array();
                            $recentStatusArr = explode("---", $recentStatus);
                            if (!empty($recentStatusArr)) {
                                if (count($recentStatusArr) > 1) {
                                    foreach ($recentStatusArr as $eachRow) {
                                        $lastStatusDateInfo[] = $eachRow;
                                    }
                                } else {
                                    $lastStatusDateInfo[] = $recentStatusArr[0];
                                }
                            }
                            sort($lastStatusDateInfo);
                            if (!empty($lastStatusDateInfo)) {
                                $lastStatusInfo = end($lastStatusDateInfo);
                                $lastStatusArr = explode("###", $lastStatusInfo);
                                if (!empty($lastStatusArr)) {
                                    $last_status_date = date("d M Y", strtotime($lastStatusArr[0]));
                                }
                            }
                            $data['last_status_date'] = $last_status_date;
                        }
                        $j = 0;
                        if ($rtoType == "") {
                            sort($statusDetails);
                        } else {
                            $rtoCodeData = $this->getRtoStatusCode($statusDetails);
                            $rtoStatusKey = $rtoCodeData['rtoStatusKey'];
                            $intransitKey = $rtoCodeData['intransitKey'];
                            if (!empty($rtoCodeData['rtoStatusCodeDetails'])) {
                                $statusDetails[$rtoStatusKey]["status_info"] .= "---" . implode("---", $rtoCodeData['rtoStatusCodeDetails']);
                            }
                            if (!empty($rtoCodeData['intransitCodeDetails'])) {
                                $statusDetails[$intransitKey]["status_info"] = implode("---", $rtoCodeData['intransitCodeDetails']);
                            }
                        }
                        foreach ($statusDetails as $eachStatus) {
                            $shipment_scan_val = $eachStatus['scan_value'];
                            if ($shipment_scan_val == 'In Transit') {
                                $data['status_codes'][] = '0212';
                            }
                            if ($shipment_scan_val == "In Transit" || $shipment_scan_val == "Return In Transit") {
                                $data['status_codes'][] = '1550';
                            }
                            if ($shipment_scan_val == 'Out for delivery' || $shipment_scan_val == 'Out for Return') {
                                $data['status_codes'][] = '3000';
                                if($shipment_scan_val == 'Out for Return'){
                                    $data['deliver_sts_name'] = "Out for return";
                                }
                            }
                            if ($shipment_scan_val == 'Delivered' || $shipment_scan_val == 'Returned' || $shipment_scan_val == 'RTO Delivered') {
                                if ($data['delivertime'] == "N/A") {
                                    $data['delivertime'] = ucwords(
                                        date("d M Y", strtotime($eachStatus['scan_datetime']))
                                    );
                                }
                                $data['status_codes'][] = '2400';
                                if($shipment_scan_val == 'RTO Delivered'){
                                    $data['close_sts_name'] = "RTO Delivered";
                                }
                            }
                            $shipment_scan_datetime = $eachStatus['scan_datetime'];
                            $quantity = $data['quantity'];
                            $weight = $data['weight'];
                            $innests = $eachStatus['status_info'];
                            $StatusTable1 = array();
                            $stsarr = explode("---", $innests);
                            if (!empty($stsarr)) {
                                if (count($stsarr) > 1) {
                                    foreach ($stsarr as $ar) {
                                        $StatusTable1[] = $ar;
                                    }
                                } else {
                                    $StatusTable1[] = $stsarr[0];
                                }
                            }
                            sort($StatusTable1);
                            foreach ($StatusTable1 as $each) {
                                $trackStatus = explode("###", $each);
                                if (!empty($trackStatus)) {
                                    $recentStatusData = end($StatusTable1);
                                    $scan_status_time = $trackStatus[0];
                                    $recentTrackStatus = explode("###", $recentStatusData);
                                    if (!empty($recentTrackStatus)) {
                                        $scan_status_time = $recentTrackStatus[0];
                                    }
                                    $statusLocation = isset($trackStatus[1]) ? $trackStatus[1] : "";
                                    $statusInstructions = isset($trackStatus[2]) ? trim($trackStatus[2]) : "";
                                    if (isset($trackStatus[4])) {
                                        $statusInstructions .= "-".trim($trackStatus[4]);
                                    }
                                    $transit_status_html_table .= '<tr>
									<td class="datetimeclass">' . $trackStatus[0] . '</td>
									<td>' . $statusLocation . '</td>
									<td>' . $statusInstructions . '</td>
									</tr>';
                                }
                            }
                            $j++;
                            $transit_status_html .='<li class="list-item" style="margin-left: 26px;list-style-type: none;">
							<div class="list-box">
								<div class="pickup-block" data-toggle="collapse" data-target="#timeline' . $accordion_index . '">
									<span class="d-title" style="font-weight: bold;">' . $shipment_scan_val . '</span>
									<span class="date">' . $scan_status_time . '</span>
								</div>
								<div id="timeline' . $accordion_index . '" class="collapse table-responsive">
								<table class="table table-bordered slimscrollTable">
								<thead>
								<tr>
								<th class="datetimeclass">Time</th>
								<th>Location</th>
								<th>Instruction</th>
								</tr>
								</thead>
								<tbody>' . $transit_status_html_table;
                            $transit_status_html .= '</tbody>
								</table>
								</div>
							</div>
							</li>';
                            $accordion_index++;
                            $transit_status_html_table = '';
                        }
                    }
                    if ($data['delivertime'] != "N/A" && $data['exp_delivertime'] == "N/A") {
                        $data['exp_delivertime'] = $data['delivertime'];
                    }} else {
                    //fetching all status details
                    $lastStatus = array('status_name' => '', 'status_code' => '', 'createdon' => '');
                    $allStatusArray = array();
                    $statusDetails = $this->TrackingService_model->getOrderStatusDetails($data['id']);
                    //log_message("error","Inn:".json_encode($statusDetails));
                    if(sizeof($statusDetails) > 0){
                        $finalArray = end($statusDetails);
                        if(isset($finalArray['status_icon']) && $finalArray['status_icon'] != ''){
                            $statusIcon = $finalArray['status_icon'];
                        }
                    }
                    $data['status_icon'] = $statusIcon;
                    $dummyArray = $existingStatusCodes = $allStatusArray = [];
                    if (!empty($deliveredStatusArray) && sizeof($deliveredStatusArray) > 0) {
                        foreach ($statusDetails as $each) {
                            $existingStatusCodes[] = $each['status_code'];
                        }
                        //log_message("error","deliveredStatusArray:".json_encode($deliveredStatusArray));
                                  
                        /*foreach ($deliveredStatusArray as $each) {
                            if (isset($each['status_code'])) {
                                if ((!in_array($each['status_code'], $dummyArray)) && (!in_array($each['status_code'], $existingStatusCodes))) {
                                    $statusArr = [
                                        'loc_name' => $each['loc_name'],
                                        'latitude' => $each['latitude'],
                                        'longitude' => $each['longitude'],
                                        'status_name' => $each['status_name'],
                                        'status_code' => $each['status_code'],
                                        'createdon' => $each['createdon'],
                                        'stop_type' => $each['stop_type']
                                    ];
                                    $dummyArray[] = $each['status_code'];
                                    //log_message("error","statusArr:".json_encode($statusArr));
                                    array_push($statusDetails, $statusArr);
                                }
                            }
                        }*/
                    }
                    // sorting the status parameters based on date
                    array_multisort(
                        array_map('strtotime', array_column($statusDetails, 'createdon')),
                        SORT_ASC,
                        $statusDetails
                    );
                    if (!empty($statusDetails)) {
                        $firstCode = $statusDetails[0]['status_code'] ?? '';
                        $secondCode = $statusDetails[1]['status_code'] ?? '';
                        if (!in_array('', [$firstCode, $secondCode])) {
                            if (($statusDetails[0]['status_code'] == "0212") && $statusDetails[1]['status_code'] == "0100") {
                                $firstIndex = $statusDetails[0];
                                $statusDetails[0] = $statusDetails[1];
                                $statusDetails[1] = $firstIndex;
                            }
                        }
                    }
                    if (sizeof($statusDetails) > 0) {
                        $tempStatus = end($statusDetails);
                        if (!empty($tempStatus)) {
                            $data['last_status'] = $this->getStatusNameByCode($tempStatus['status_code']);
                            $data['last_status_date'] = $this->convertDateToClientTZ($tempStatus['createdon'], $curtz);
                        }
                        foreach ($statusDetails as $each) {
                            $status_name = $this->getStatusNameByCode($each['status_code']);
                            $status_date = $this->convertDateToClientTZ($each['createdon'], $curtz, 1);
                            if ($status_name == 'Shipment picked up') {
                                $pickupTime = "Pickup : ";
                                $pickupTime .= date('d M Y h:i A', strtotime($status_date));

                            }
                            if ($status_name == 'Delivered To Consignee') {
                                $deliveryTime = "</br> Delivery : ";
                                $actualDeliveryDate = $deliveryTime .= date('d M Y h:i A', strtotime($status_date));
                            }
                            /* locname fetch*/
                            $location_name = '';
                            
                            if($each['loc_name']!=null && $each['loc_name']!="")
                            {
                                $location_name = $each['loc_name'];
                            }
                            else if($each['latitude']!=null && $each['latitude']!="" &&  $each['longitude']!=null && $each['longitude']!="")
                            {
                                $location_name = getLocationName($each['latitude'], $each['longitude']);
                            }
                            else
                            {
                                if($each['stop_type'] == 'P'){
                                    $location_name = ((!empty($data['pickup_address1'])) ? $data['pickup_address1'] . ' , ' : "") . ((!empty($data['pickup_address2'])) ? $data['pickup_address2'] : "");
                                }
                                else if($each['stop_type'] == 'D'){
                                    $location_name = ((!empty($data['delivery_address1'])) ? $data['delivery_address1'] . ' , ' : "") . ((!empty($data['delivery_address2'])) ? $data['delivery_address2'] : "");
                                }
                            }
                           // if ($this->session->userdata("company_code") == 'INKN') {
                                /*if (($each['latitude'] == '' || $each['latitude'] == 0) && ($each['longitude'] == '' || $each['longitude'] == 0)) {
                                    if ($each['status_code'] == '0212' || $each['status_code'] == '0191' || $each['status_code'] == '0212' || $each['status_code'] == '0420' || $each['status_code'] == '0500') {
                                        $location_name = ((!empty($data['pickup_address1'])) ? $data['pickup_address1'] . ' , ' : "") . ((!empty($data['pickup_address2'])) ? $data['pickup_address2'] : "");
                                    }
                                    if ($each['status_code'] == '1550' || $each['status_code'] == '0100') {
                                        $location_name = "";
                                    }
                                    if ($each['status_code'] == '0192' || $each['status_code'] == '3000' || $each['status_code'] == '2300') {
                                        $location_name = ((!empty($data['delivery_address1'])) ? $data['delivery_address1'] . ' , ' : "") . ((!empty($data['delivery_address2'])) ? $data['delivery_address2'] : "");
                                    }
                                } else {
                                    log_message("error","loc1111:".$each['loc_name']);*/
                                    /*if($each['loc_name']!=null && $each['loc_name']!="")
                                    {
                                        $location_name = $each['loc_name'];
                                    }
                                    else 
                                    {
                                        $location_name = getLocationName($each['latitude'], $each['longitude']);
                                    }*/
                                //}
                            //}
                             //log_message("error","location_name:".$location_name);
                            /*ends locname */
                            if ($each['status_code'] == '0212') {
                                // date condition for eta calculation date if driver accepts then the eta will start from the acceptance
                                $dateToBeConsidered = $each['createdon'];
                            }
                            $stopType = $each['stop_type'];
                            $statusCode = $each['status_code'];
                            $data['status_codes'][] = $statusCode;
                            $statusArr = array(
                                'location_name' => $location_name,
                                'status_name' => $status_name,
                                'status_date' => $status_date,
                                'stop_type' => $stopType,
                                'status_code' => $statusCode
                            );
                            array_push($allStatusArray, $statusArr);
                        }
                    }
                    if ($data['trip_sts'] == '1') {
                        $data['status_codes'][] = '0218';
                    }
                    $shipment_location = "";
                    $transit_status_html = '';
                    $i = 0;
                    //log_message("error","allStatusArray:".json_encode($allStatusArray));
                    if (!empty($allStatusArray) && sizeof($allStatusArray) > 0) {
                        //log_message("Error",'Innn1111:'.json_encode($allStatusArray));
                        foreach ($allStatusArray as $eachStatus) {
                            $shipment_status_name = $eachStatus['status_name'];
                            $shipment_status_date = $eachStatus['status_date'];
                            $shipment_location = $eachStatus['location_name'];
                            if ($eachStatus['stop_type'] == 'P') {
                                $shipment_stop_type = 'Pickup';
                            } elseif ($eachStatus['stop_type'] == 'D') {
                                $shipment_stop_type = 'Delivery';
                            } else {
                                $shipment_stop_type = 'General';
                            }
                            if(in_array($eachStatus['status_code'],['1500','1600'])){
                                $shipment_stop_type = 'General';
                            }
                            $quantity = $data['quantity'];
                            $weight = $data['weight'];
                            $weight_unit = $data['weight_unit'];
                            if ($data['cargo_type'] != '') {
                                $cargoType = $data['cargo_type'];
                            }
                            if ($cargoType == '') {
                                $cargoType = "Pallets";
                            }
                            $cargoType = substr($cargoType, 0, 20);
                            $transit_status_html .= '<li class="list-item">
							<div class="list-box">
							<span class="d-title">' . $shipment_status_name . '</span>
							<span class="date">' . $shipment_status_date . '</span><br/>
							<span class="date">' . $shipment_location . '</span>
							<p class="address">' . $shipment_location . '</p>
							<div class="pickup-block">
							<button class="btn btn-pickup">' . $shipment_stop_type . '</button>
							<span class="location-add">' . $quantity . ' X ' . $cargoType . '</span>
							<span class="item-weight" style="right:-7px;">' . $weight . ' ' . $weight_unit . '</span>
							</div>
							</div>
							</li>';
                        }
                    }
                }
                $data['transit_status_html'] = $transit_status_html;
                if ($branch_code == 'INCL') {
                    $data['additional_details_box'] = '0';
                }
                $slat = $data['plat'];
                $slng = $data['plng'];
                $dlat = $data['dlat'];
                $dlng = $data['dlng'];
                if ($slat != '' && $slng != '' && $dlat != '' && $dlng != '') {
                    $distanceArray = $this->getDistanceBetweenCoordinates($slat, $slng, $dlat, $dlng);
                    if (!empty($distanceArray) && sizeof($distanceArray) > 0) {
                        $data['route_milage'] = (!empty($distanceArray['disttext'])) ? $distanceArray['disttext'] . ' ' : "N/A";
                        if ($distanceArray['duration'] != '') {
                            $seconds = (int)$distanceArray['duration'];
                            $shipmentEta = date("Y-m-d H:i:s", (strtotime(date($dateToBeConsidered)) + $seconds));
                            if ($shipmentEta != '' && $shipmentEta != '0000-00-00 00:00:00' && $shipmentEta != '0') {
                                $data['shipment_eta'] = $this->convertDateToClientTZ($shipmentEta, $curtz);
                            }
                        }
                    }
                }
                $eta = array();
                $eta['time'] = "";
                $chkutime['timezone'] = DFLT_TZ;
                if ($data['company_code'] == 'NZKN' || $data['company_code'] == 'NZ') {
                    $eta = getEDAofNZShipmentbyord($data['id']);
                }
                if (strlen($eta["time"]) > 0) {
                    if ($curtz != $chkutime['timezone']) {
                        $chkrtime = getdatetimebytimezone($curtz, $eta['time'], $chkutime['timezone']);
                        $eta["time"] = ucwords(date("d M Y h:i A", strtotime($chkrtime['datetime'])));
                    } else {
                        $eta["time"] = ucwords(date("d M Y", strtotime($eta["time"])));
                    }
                    $data['shipment_eta'] = $eta["time"];
                }
                /* added to match expected delivery date */
                if ($data['company_code'] == 'INKN' && $branch_code != 'INCL') {
                    $delivery_status_array = getdatetimebytimezone($curtz, $data['delivery_datetime'], DFLT_TZ);
                    $data['exp_delivertime'] = date('d M Y', strtotime($delivery_status_array['datetime']));
                    $getPromisedDeliveryDate = $this->TrackingService_model->getPromisedDeliveryDate($data['id']);
                    if (!empty($getPromisedDeliveryDate)) {
                        $promisedDeliveryDate = $getPromisedDeliveryDate;
                        $data['exp_delivertime'] = date('d M Y', strtotime($getPromisedDeliveryDate));
                    }
                }
                if ($branch_code != "INCL") {
                    if (($pickupTime ?? "") != "" && ($deliveryTime ?? "") != "") {
                        $data['pickup_delivery_datetime'] = $pickupTime . $deliveryTime;
                    }
                    $data['shipment_eta'] = $actualDeliveryDate ?: $earlyDelivery;
                }
                if ($branch_code != 'INCL' && $data['company_code'] != 'INKN') {
                    $data['exp_delivertime'] = $data['shipment_eta'];
                }
                /* ends here match expected delivery daate */
                $data['invoice_number'] = "";
                if ($branch_code != 'INCL') {
                    $data['invoice_number'] = $this->TrackingService_model->getInvoiceNumbers($data['id']);
                }
                $data['bill_of_lading'] = 'N/A';
                $unsetFields = array(
                    'user_id',
                    'pickup_address1',
                    'pickup_address2',
                    'pickup_city',
                    'pickup_country',
                    'pickup_pincode',
                    'delivery_address1',
                    'delivery_address2',
                    'delivery_city',
                    'delivery_country',
                    'delivery_pincode',
                    'pickup_datetime',
                    'delivery_datetime'
                );
                foreach ($unsetFields as $each) {
                    unset($data[$each]);
                }
                $data['order_reference'] = $this->TrackingService_model->getOrderReferenceByID($oid);
            }

            echo json_encode($data);
            exit;
        } else {
            $data['tracking_number'] = $param1;

            $this->load->view('tracking/index', $data);
        }
    }

    // the below method will manage all the status names and codes of shipment
    public function getStatusNameByCode($shipmentStatusCode)
    {
        log_error(UNIQLO_LOG_PREFIX . "getStatusNameByCode inbound data: " . $shipmentStatusCode);

        $statusCodeToMessage = [
            '0100' => 'Booked By Supplier',
            '0212' => 'Accepted By Driver',
            '0420' => 'Pickup Gate In',
            '0500' => 'Shipment picked up',
            '0191' => 'Out for pickup',
            '1550' => 'In Transit (Connected to destination)',
            '0192' => 'Delivery Gate In',
            '3000' => 'Delivered To Consignee',
            '2300' => 'Arrival at Delivery Point',
            '0218' => 'Closed',
            '2990' => 'In Transit (Shipment Received at Facility)',
            '0106' => 'Planned Pickup Date',
            '0213' => 'Rejected by Driver',
            '0217' => 'Trip Update Rejected by Driver',
            '0470' => 'Collection Order Confirmed',
            '0490' => 'Arrival at Collection Point',
            '2400' => 'Planned Delivery Date',
            '2525' => 'Delivery Arranged For',
            '3001' => 'Delivery Not Successful',
            '3050' => 'Delivery Refused',
            '3051' => 'Attempted Delivery',
            'RTO' => 'Return To Origin',
            '1500' => 'Customs Clearance Strated',
            '1600' => 'Customs Clearance Completed at Border',
            'SV0100' => 'Order Booked',
            'SV0110' => 'Order Acknowledged',
            'SV0120' => 'Booking Confirmed By Carrier',
            'SV0130' => 'Arrived for Pickup',
            'SV0131' => 'Pickup Completed',
            'SV0140' => 'Departed from Pickup Point',
            'SV0210' => 'Arrived at In-Transit Hub',
            'SV0220' => 'Departed From In-Transit Hub',
            'SV0230' => 'In-Transit',
            'SV0310' => 'Arrived at Destination Hub',
            'SV0410' => 'Out for Delivery',
            'SV0510' => 'Delivered to Consignee',
            'SV0520' => 'ePOD Available',
            'SV0121' => 'Order Transmitted to Carrier',
            'SV0122' => 'Order Assigned to Carrier',
            'SV0530' => 'ePOD Available',
            'SV0601' => 'Docket Cancelled',
            'SV0602' => 'Order Cancelled',
            'SV0603' => 'Rejected at FC',
            'SV0604' => 'Partial Delivery with Rejection',
            'SV0605' => 'Undelivered',
            'SV0606' => 'RTO Initiated',
            'SV0511' => 'Partially Delivered',
            'SV0123' => 'Order Rescheduled',
            'SV0132' => 'Scan at Origin',
        ];

        $shipmentStatus = $statusCodeToMessage[$shipmentStatusCode] ?? "Open";

        log_error(UNIQLO_LOG_PREFIX . "getStatusNameByCode outbound data: " . $shipmentStatus);

        return $shipmentStatus;
    }

    // below method will format the date and time based on the display criteria
    public function formatDate($date, $timestamp = '')
    {
        if ($date != '' && $date != "0000-00-00 00:00:00" && $date != '0') {
            if ($timestamp) {
                return date("d M Y h:i A", strtotime($date));
            } else {
                return date("d M Y", strtotime($date));
            }
        }
        return false;
    }

    // the below method will convert the datetime to client timezone
    public function convertDateToClientTZ($date, $tz, $includeTimestamp = '')
    {
        if ($date != "" && $date != "0000-00-00 00:00:00" && $date != "0") {
            $shipment_status_array = getdatetimebytimezone($tz, $date, DFLT_TZ);
            $date = $this->formatDate(
                date('d M Y h:i A', strtotime($shipment_status_array['datetime'])),
                $includeTimestamp
            );
        }

        log_error(UNIQLO_LOG_PREFIX . "convertDateToClientTZ outbound data: " . $date);

        return $date;
    }

    // the below method will provide lat and long coordinates based on address
    public function getLatLngByAddress($address)
    {
        log_error(UNIQLO_LOG_PREFIX . "getLatLngByAddress inbound data: " . $address);

        $data = getlatlngsbyplace($address);
        $coordinates = array('lat' => '', 'lng' => '');
        $coordinates['lat'] = $data[0];
        $coordinates['lng'] = $data[1];

        log_error(UNIQLO_LOG_PREFIX . "getLatLngByAddress outbound data: " . implode(', ', $coordinates));

        return $coordinates;
    }

    // the below method will return the location name based on the lat and long coordinates
    public function getLocationByLatLng($lat, $lng)
    {
        $latlng = "$lat,$lng";
        $apiKey = GOOGLE_BKND_API_KEY; // Google maps now requires an API key.

        // if you are using helper class then use the below code
        // getting the location based on lat and lng from the home_helper.php

        return $data = getLocationName($lat, $lng);
        /*
        // if you are using the google api then use the below code
        // getting the location based on lat and lng
        $url='https://maps.googleapis.com/maps/api/geocode/json?latlng='.$latlng.'&key='.$apiKey;
        $output=$this->executeCurlAPI($url);
        return $output['results'][0]['formatted_address'];
        */
    }

    // the below method will return the distance and duration metrics based on lat and long coordinates
    public function getDistanceBetweenCoordinates($lat1, $lng1, $lat2, $lng2)
    {
        $apiKey = GOOGLE_BKND_API_KEY; // Google maps now requires an API key.
        $distanceArray = $output = array();
        $distanceArray['disttext'] = $distanceArray['distval'] = $distanceArray['duration'] = $distanceArray['durationtext'] = '';

        $origin = "$lat1,$lng1";
        $destination = "$lat2,$lng2";

        // if you are using API from helper class then use the below

        $output = distancemetrixship($lat1, $lng1, $lat2, $lng2);
        $distanceArray = array();
        $distanceArray['disttext'] = $output['disttext'];
        $distanceArray['distval'] = $output['distance'];
        $distanceArray['duration'] = $output['duration'];
        $distanceArray['durationtext'] = $output['duratext'];


        /*
        // if you are using the direct google maps api use the below code
        $url='https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&origins='.$origin.'&destinations='.$destination.'&key='.$apiKey;
        $output=$this->executeCurlAPI($url);
        if(!empty($output) && sizeof($output)>0){
            if($output['status']=='OK'){
                $distanceArray['disttext']=$output['rows'][0]['elements'][0]['distance']['text'];
                $distanceArray['distval']=$output['rows'][0]['elements'][0]['distance']['value'];
                $distanceArray['duration']=$output['rows'][0]['elements'][0]['duration']['value'];
                $distanceArray['durationtext']=$output['rows'][0]['elements'][0]['duration']['text'];
            }
        }
        */

        log_error(UNIQLO_LOG_PREFIX . "getDistanceBetweenCoordinates outbound data: " . implode(', ', $distanceArray));

        return $distanceArray;
    }

    // the below method will execute the REST API using CURL
    public function executeCurlAPI($url)
    {
        log_error(UNIQLO_LOG_PREFIX . "executeCurlAPI inbound data: " . $url);

        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_FAILONERROR, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $json = curl_exec($curl);

        log_error(UNIQLO_LOG_PREFIX . "executeCurlAPI outbound data: " . $json);

        return json_decode($json, 1);
    }

    // the below method is used for asynchronously moving the vehicle on the map based on the lat long coordinates from truck_data table
    public function gpsTracking()
    {
        $data = array();
        $shiftId = $this->input->post('shiftId', true);

        $plat = $this->input->post('plat', true);
        $plng = $this->input->post('plng', true);
        $dlat = $this->input->post('dlat', true);
        $dlng = $this->input->post('dlng', true);

        $data['vehicle_location'] = 'N/A';

        if ($shiftId != '' && $shiftId != 0) {
            $this->load->model('TrackingService_model');
            $vehicleDetails = $this->TrackingService_model->getVehicleDetails($shiftId);
            if (isset($vehicleDetails) && sizeof($vehicleDetails) > 0 && !empty($vehicleDetails)) {
                $data['vehicle_type'] = $vehicleDetails['trucktype'];
                $vlat = $vehicleDetails['latitude'];
                $vlong = $vehicleDetails['longitude'];
                /* get vehicle location based on the lat long details. using getLocationName method
                from home_helper.php file */
                if ($vlat != '' && $vlong != '') {
                    $data['coordinates']['plat'] = $plat;
                    $data['coordinates']['plng'] = $plng;
                    $data['coordinates']['dlat'] = $dlat;
                    $data['coordinates']['dlng'] = $dlng;

                    //echo getLocationName('22.5264844','114.025217');
                    $data['vehicle_location'] = $this->getLocationByLatLng($vlat, $vlong);

                    //$data['coordinates']['clat']= '17.385044';
                    //$data['coordinates']['clng']= '78.486671';


                    $data['coordinates']['clat'] = $vlat;
                    $data['coordinates']['clng'] = $vlong;
                }
            }
        }

        echo json_encode($data);
    }

    /*Calculate expected delivery data basedon TAT*/
    public function getexpdeliverByPushApiData($awb,$orderRowId)
    {
        log_error(UNIQLO_LOG_PREFIX . "getexpdeliverByPushApiData inbound data: " . $awb);

        $response = "";

        $sql = "SELECT promise_deliver_date FROM tb_order_details WHERE order_row_id='" . $orderRowId . "' ORDER BY id DESC LIMIT 1";
        $res = $this->db->query($sql);
        if ($res->num_rows() > 0) {
            $response = $res->row()->promise_deliver_date;
            if (strpos($response, "1970-01-01") !== false) {
                $response = "";
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getexpdeliverByPushApiData outbound data: " . $response);

        return $response;
    }

    /*get expected delivery data basedon TAT from customer pincode table*/
    public function getexpdeliverByOrderPin($pincode, $ordtype, $manifestdate, $vendorid)
    {
        $response = "";
        if ($pincode != "" && $vendorid != "") {
            $curdt = $manifestdate;
            $tatval = "";
            $sql = "SELECT carrier_surface_tat,carrier_return_surface_tat FROM tb_customer_pincodes WHERE destination_pin='" . $pincode . "' AND carrier_id=$vendorid AND status=1 ORDER BY id DESC LIMIT 1";
            $res = $this->db->query($sql);
            if ($res->num_rows() > 0) {
                $tatval = $res->row()->carrier_surface_tat;
                if ($ordtype == '0') {
                    $tatval = $res->row()->carrier_return_surface_tat;
                }
            }
            if ($curdt != "" && $tatval != "") {
                $response = date("Y-m-d", strtotime("+$tatval days", strtotime($curdt)));
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getexpdeliverByOrderPin outbound data: " . $response);

        return $response;
    }

    private function getRtoStatusCode($statusDetails){
        $rtoResponse = $statusCodeDetails = [];
        $rtoResponse['rtoStatusKey'] = $rtoResponse['intransitKey'] = $rtoStartTime = "";
        $rtoResponse['rtoStatusCodeDetails'] = $rtoResponse['intransitCodeDetails'] = [];
        foreach ($statusDetails as $key=>$scanStatus) {
            if($scanStatus['scan_value'] == "In Transit"){
                $rtoResponse['intransitKey'] = $key;
                $statusCodeDetails[$key][] = $scanStatus;
            }
            if($scanStatus['scan_value'] == "Return In Transit"){
                $rtoResponse['rtoStatusKey'] = $key;
                $statusCodeDetails[$key][] = $scanStatus;
                $innerStatusRtoData = $scanStatus['status_info'];
                $innerRtoStatus = [];
                $eachRtoScanData = explode("---", $innerStatusRtoData);
                if (!empty($eachRtoScanData)) {
                    if (count($eachRtoScanData) > 1) {
                        foreach ($eachRtoScanData as $ar) {
                            $innerRtoStatus[] = $ar;
                        }
                    } else {
                        $innerRtoStatus[] = $eachRtoScanData[0];
                    }
                }
                foreach ($innerRtoStatus as $rto) {
                    $rtoData = explode("###", $rto);
                    if (!empty($rtoData)) {
                        $rtoStatusCode = isset($rtoData[3]) ? trim($rtoData[3]) : "";
                        if($rtoStatusCode == '777'){
                            $rtoStartTime = $rtoData[0];
                        }
                    }
                }
            }
        }
        if($rtoStartTime != ""){
            foreach ($statusCodeDetails as $rtoCheck) {
                if ($rtoCheck[0]['scan_value'] == "In Transit") {
                    $innerStatusData = $rtoCheck[0]['status_info'];
                    $innerStatus = [];
                    $eachScanData = explode("---", $innerStatusData);
                    if (!empty($eachScanData)) {
                        if (count($eachScanData) > 1) {
                            foreach ($eachScanData as $ar) {
                                $innerStatus[] = $ar;
                            }
                        } else {
                            $innerStatus[] = $eachScanData[0];
                        }
                    }
                    foreach ($innerStatus as $rto) {
                        $rtoData = explode("###", $rto);
                        if (!empty($rtoData)) {
                            $rtoStatusDate = isset($rtoData[0]) ? trim($rtoData[0]) : "";
                            if (strtotime($rtoStatusDate) >= strtotime($rtoStartTime)) {
                                $rtoResponse['rtoStatusCodeDetails'][] = $rto;
                            } else {
                                $rtoResponse['intransitCodeDetails'][] = $rto;
                            }
                        }
                    }
                }
            }
        }
        return $rtoResponse;
    }
}
