<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . "/third_party/PHPExcel.php";


class Trackreport extends CI_Controller {
	public function __construct() {
		parent::__construct();
		$this->load->model('common');
		$this->load->model('orderrevenuesmodel');
        if (!checkUrlAccessForUser('TRACKREPORT')) {
            redirect("Forbiddenaccess");
        }
	}
	public function index(){
		/*ini_set("memory_limit","256M");*/
		$data['page_title']=$this->lang->line('track_report');
		$data['sub_title']=$this->lang->line('track_report');
		$data['orders'] = $data["trip"] = array();
		$curtz = $this->session->userdata("usr_tzone")['timezone'];
		$user_id = $this->session->userdata("user_id");
		$mph = '13.8889';
		$post = $searchids = $getorders = $orders = array();
		if(isset($_POST['searchsubmit'])){
			$post = $_POST;
		}
		$whr = "";

		if(!empty($post)){
			if ( isset( $post['fromdate'] ) && $post['fromdate'] != "" ) {
				$fromdate = date( 'Y-m-d', strtotime( $post['fromdate'] ) );
				$whr   .= " DATE_FORMAT(createdon,'%Y-%m-%d') >= '".$fromdate."' AND";
				/*if ( isset( $post['todate'] ) ) {
					if ( $post['todate'] == "" ) {
						$todate = date( 'Y-m-d', strtotime( $cdate ?? "" ) );
						log_message("error","Date1:".$todate);
						$whr   .= " DATE_FORMAT(createdon,'%Y-%m-%d') <= '".$todate."' AND";
					}
				} else {
					$todate = date( 'Y-m-d', strtotime( $cdate ) );
					log_message("error","Date2:".$todate);
					$whr   .= " DATE_FORMAT(createdon,'%Y-%m-%d') <= '".$todate."' AND";
				}*/
				if ( isset( $post['todate'] ) && $post['todate'] != "" ) {
    				$todate = date( 'Y-m-d', strtotime( $post['todate'] ) );
    				$whr .= " DATE_FORMAT(createdon,'%Y-%m-%d') <= '".$todate."' AND";
    			}
			}
			if ( isset( $post['todate'] ) && $post['todate'] != "" ) {
				$todate = date( 'Y-m-d', strtotime( $post['todate'] ) );
				$whr .= " DATE_FORMAT(createdon,'%Y-%m-%d') <= '".$todate."' AND";
			}
		
			/*if ( isset( $post['todate'] ) && $post['todate'] != "" ) {
				$todate = date( 'Y-m-d', strtotime( $post['todate'] ) );
				log_message("error","Date4:".$todate);
				$whr .= " DATE_FORMAT(createdon,'%Y-%m-%d') <= '".$todate."' AND";
			}*/
			$searchids = isset( $post['bookingid'] ) ? $post['bookingid'] : array();
			$select = "id,order_id,pickup_datetime,pickup_city,delivery_city,pickup_address1,delivery_address1,shift_id,trip_id,plat,plng,dlat,dlng,createdon";
			$whr .= " user_id = '$user_id' AND status !='0' AND trip_id >0 AND trip_sts ='0' ";
			$getorders = $this->orderrevenuesmodel->gettripreports($select,$whr,$searchids);
		}
		if(!empty($getorders)){
			foreach ($getorders as $res) {
				$booking_id   = $res['order_id'];
				$pickup_city  = $res['pickup_city'];
				$delivery_city= $res['delivery_city'];
				$order_row_id = $res['id'];
				$trip_id      = $res['trip_id'];
				$plat         = $res['plat'];
				$plng         = $res['plng'];
				$dlat         = $res['dlat'];
				$dlat         = $res['dlat'];
				$dlng         = $res['dlng'];
				$createdon    = $res['createdon'];
				$vehicleNumber = "";
				$pickupDatetime = $res['pickup_datetime'];
				if (!empty($pickupDatetime)) {
					$dateTime = getdatetimebytimezone( $curtz, $pickupDatetime, DFLT_TZ );
					$pickupDatetime = $dateTime['datetime'];
				}
				$ordcreation  = $createdon;
				if($createdon != ""){
					$odate       = getdatetimebytimezone( $curtz, $createdon, DFLT_TZ );
					$ordcreation = $odate['datetime'];
				}
				$tripinfo = chkTripinfoByOrdertrip($trip_id,$curtz);
				$data['travel_dist'] = '0.00';
				$data['total_distance'] = $delivery_note = "";
				$getdelivery_note = $this->common->gettblrowdata(array('order_id'=>$order_row_id,'reference_id'=>'DQ','status'=>'1'),"ref_value","tb_order_references",0,0);
				if(!empty($getdelivery_note)){
					$delivery_note = $getdelivery_note['ref_value'];
				}
				if(count($tripinfo)>0){
                   $trip_id = $tripinfo['id'];
                    $trip = $tripinfo;
                    $flag = $lat = $lng = $dist = 0;
                    if($tripinfo['status'] == 1){
                        $records = $this->db->query("SELECT latitude,longitude,speed,battery,`timestamp` from tb_rtdrive_locations where trip_id = '$trip_id' ORDER BY `timestamp` ASC");
                        if ($records->num_rows() > 0) {
                            foreach ($records->result() as $row) {
                                if ($flag == 0) {
                                    $flag = 1;
                                    $lat = $row->latitude;
                                    $lng = $row->longitude;
                                    $tstamp = $row->timestamp;
                                } else {
                                    $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                                    if($tstamp != 0){
                                        $datetime1 = new DateTime($tstamp);//start time
                                        $datetime2 = new DateTime($row->timestamp);//end time
                                        $interval = $datetime1->diff($datetime2);
                                        $time = $interval->format('%s');
                                        if($time > 0){
                                            $ratio = ($a*1000)/$time;
                                        }else{
                                            $ratio = 0;
                                        }
                                        if($ratio < 30 || $time < 300){ // 30 is max allowed spped 30 MPS equelent to 108 KMPH
                                            $dist = $dist + $a;
                                            $lat = $row->latitude;
                                            $lng = $row->longitude;
                                            $tstamp = $row->timestamp;
                                        }
                                    }else{
                                        $dist = $dist + $a;
                                    }
                                }
                            }
                        }
                    }else{
                        $tripdist = $this->db->select("trip_distance")->get_where("tb_trip_summary",array("trip_id"=>$trip_id),1,0);
                        if($tripdist->num_rows()>0){
                            $dist = $tripdist->row()->trip_distance;
                        }
                    }
                    $travel_dist = round($dist,2);
                }
			    $ret = (Object) array("plat"=>$plat,"plng"=>$plng,"dlat"=>$dlat,"dlng"=>$dlng);
			    if($plat == null || strlen(trim($plat)) == 0 || $plng == null || strlen(trim($plng)) == 0 || $dlat == null || strlen(trim($dlat)) == 0 || $dlng == null || strlen(trim($dlng)) == 0){
			        $ret = orderAddressUpdate($order_row_id);
			        $ret = (Object) $ret;
			        $response = distancemetrixship($ret->plat,$ret->plng,$ret->dlat,$ret->dlng);
			        $total_distance = $response['disttext'];
			    }else{
			        $response = distancemetrixship($ret->plat,$ret->plng,$ret->dlat,$ret->dlng);
			        $total_distance = $response['disttext'];
			    }
			    $travelled_dist = $travel_dist;
			    $total_distance = $total_distance;
			    $total = 0;
			    $sub1 = str_replace(",", "", $total_distance);
			    $sub2 = str_replace(",", "", $travelled_dist);
			    if(is_numeric($sub1) && is_numeric($sub2)){
				    $pending_dist = $sub1 - $sub2;
				    if($travelled_dist != "" && is_numeric($total_distance) && $total_distance != "" && is_numeric($total_distance)){
				    	$remaining = $total_distance - $travelled_dist;
					    if($remaining >0){
					    	$remaining = ($remaining * 1000)/$mph;
					    	$remaining = $this->secondsTimeSpanToHMS($remaining);
					    	$total = ($total_distance * 1000)/$mph;
					    	if($total != ""){
					    		$total = $total;
					    	}else{
					    		$total = 0;
					    	}
					    	$total = $this->secondsTimeSpanToHMS($total);
					    }
				    }else if($total_distance != "" && is_numeric($total_distance)){
			    		$total = ($total_distance * 1000) / $mph;
			    		if($total != ""){
			    			$total = $total;
			    		}else{
			    			$total = 0;
			    		}
			    		$total = $this->secondsTimeSpanToHMS($total);
				    }else{
			    		$total = $travelled_dist;
			    		$total = ($total*1000) / $mph;
			    		if($total != ""){
			    			$total = $total;
			    		}else{
			    			$total = 0;
		    			}
				    }
				}
				$truckType = "";
				if ($res['shift_id'] > 0) {
					$vehicleNumberResult = $this->common->getjointbldata('tb_shft_veh v','tb_trucks_data d','d.id = v.vehicle_id',['v.shft_id'=>$res['shift_id'],'v.status'=>1], 'd.register_number,d.truck_type', 1, 0);
					if (!empty($vehicleNumberResult)) {
						$vehicleNumber = $vehicleNumberResult[0]['register_number'];
						if ($vehicleNumberResult[0]['truck_type'] > 0) {
							$truckTypeResult = $this->common->gettblrowdata(["id" => $vehicleNumberResult[0]['truck_type']], "trucktype", "tb_trucktypes", 0, 0);
							$truckType = $truckTypeResult ? $truckTypeResult['trucktype'] : '';
						}
					}
					//truck_type
					$vehicleNumber = !empty($vehicleNumberResult) ? $vehicleNumberResult[0]['register_number'] : "";
				}
			    $orders[] = array('eta'=>$total,'pending_dist'=>$pending_dist ?? "",'total_distance'=>$total_distance,'travelled_dist'=>$travelled_dist,'delivery_city'=>$delivery_city,'pickup_city'=>$pickup_city,'delivery_note'=>$delivery_note,'booking_id'=>$booking_id,'order_row_id'=>$order_row_id,'ordcreation'=>$ordcreation,'pickup_address'=>$res['pickup_address1'],'delivery_address'=>$res['delivery_address1'],'pickup_datetime'=>date('d-m-Y h:i A', strtotime($pickupDatetime)),'vehicle_number'=>$vehicleNumber,'truck_type'=>$truckType);
			}

		}
		$data['result'] = $orders;
		$this->newtemplate->dashboard( 'trackreport/index',$data );
	}
	public function secondsTimeSpanToHMS($s) {
        //Get whole hours
        $h = round($s/3600);
        $s -= $h*3600;
       	$m = round($s/60); //Get remaining minutes
        $s -= round(($m*60),2);
        return $h." : ".($m <10 ? '0'.$m : $m)." : ".($s < 10 ? '0'.round($s,0) : round($s,0));
    }

    public function getorderids()
    {
    	$order_ids = array();
    	$post = $this->input->post();
    	$user_id = $this->session->userdata('user_id');
    	$order_id  = isset($post['searchTerm']) ? $post['searchTerm'] : "";
    	$whr = " user_id ='$user_id' AND status !=0 AND trip_id >0 AND trip_sts ='0' ";
    	$select = "order_id";
   		$getorderids = $this->orderrevenuesmodel->getactiveorders($select,$whr,$order_id);
    	if($getorderids->num_rows()>0){
    		foreach ($getorderids->result() as $res) {
    			$order_ids[] = array("id"=>$res->order_id, "text"=>$res->order_id);
    		}
    	}
    	echo json_encode($order_ids);
    }
}
