<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Transitstatusreport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('transitstatusreportmodel');
        $this->load->model('common');
        if (!checkUrlAccessForUser('TRANSITSTATUSREPORT')) {
            redirect("Forbiddenaccess");
        }
    }

    /**
     * display search data for Transit Status Report page
     *
     *
     *
     * @param
     * @return    Array
     * @author    Developer Name external.ravikumar@kuehne-nagel.com
     * @date      25-11-2021 11:00:00+05.30
     * @change    china,taiwan
     */

    public function index()
    {
        $this->TransitStatusReports();
    }

    public function TransitStatusReports()
    {
        $businessType = $this->session->userdata("business_type");
        $data['page_title'] = $this->lang->line('menu_Transitstatusreport');
        $data["table_search"] = $whr = "";
        $userId = $this->session->userdata('user_id');
        $id = $this->session->userdata('id');
        $data=[];
        if ($_POST) {
            $post = $_POST;

        $post['user_id'] = $userId;
        $data['sub_title'] = 'Transit Status Reports';
        $data['transitStatusCount'] = count($this->transitstatusreportmodel->getReports($post, 0, 0));
        $config = [];
        $config["base_url"] = base_url() . "Transitstatusreport";
        $config["total_rows"] = count($this->transitstatusreportmodel->getReports($post, 0, 0));
        $config["per_page"] = count($this->transitstatusreportmodel->getReports($post, 0, 0));
        $config["uri_segment"] = 2;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $data['page'] = $page = $this->uri->segment(2) ?? 0;
        $data['transitStatusdata'] = $this->transitstatusreportmodel->getReports($post, $config["per_page"], $page);
        $data['post'] = $post;
        }

        $carrierListWhere = $businessType != "Carrier" ? ["user_id" => $userId, "status" => 1] : ["id" => $id, "status" => 1];
        $data['carrierlist'] = $this->common->gettbldata($carrierListWhere, "id,name", "tb_vendors", 0, 0);

        $customersListWhere = $businessType != "Customer" ? ["user_id" => $userId, "status" => 1] : ["id" => $id, "status" => 1];
        $data['customerslist'] = $this->common->gettbldata($customersListWhere, "id,name", "tb_customers", 0, 0);

        $this->settemplate->dashboard("Transitstatusreport/Transitstatusreport", $data);
    }
    public function getCustomers(){
            $userId = $this->session->userdata('user_id');
            $customersCode = isset($_POST["cid"]) ? $_POST["cid"] : "";
            $where = [
                'user_id' => $userId,
                'status' => 1
            ];
            $this->db->select('id AS value, name AS label');
            $this->db->where($where);
            $this->db->like('name', $customersCode, 'both');
            $getData = $this->db->get('tb_customers');
            echo json_encode($getData->result_array());
    }
}
