<?php if ( ! defined( 'BASEPATH' ) ) {
	exit( 'No direct script access allowed' );
}

class Transportmodes extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if ( $this->session->userdata( 'user_id' ) == '' ) {
			redirect( 'login' );
		}
		$this->load->library( 'form_validation' );
		$this->load->model( 'common' );
        $this->load->model('transportmodel');
		$this->load->helper( 'generic' );
        if (!checkUrlAccessForUser('TRANSPORTMODES')) {
            redirect("Forbiddenaccess");
        }
	}

	public function index() {
		$data['page_title'] = $this->lang->line( 'transport_mode' );
		$data['sub_title']  = $this->lang->line( 'transport_mode' );
		//$where = array('status'=>1);
		$where = array();
		if($this->input->post('company_code')){
            $where['ttm.company_code'] = $this->input->post('company_code');
        }
		if($this->input->post('branch_code')){
            $where['ttm.branch_code'] = $this->input->post('branch_code');
        }
		if ( $this->input->post( 'trans_name' ) ) {
			$where['ttm.name'] = $this->input->post( 'trans_name' );
		}
		if ( $this->input->post( 'trans_code' ) ) {
			$where['ttm.code'] = $this->input->post( 'trans_code' );
		}
		$data['trans_modes'] = $this->transportmodel->getcustomerwiseTransmodes($where);
		$this->newtemplate->dashboard( "transport_mode/index", $data );
	}

	public function checkTransCode( $trans_mode_code ) {
		if ( empty( $trans_mode_code ) ) {
			$this->form_validation->set_message( 'checkTransCode', 'Transport Code Required' );

			return FALSE;
		} else {
			$id    = $this->uri->segment( 3 );
			$where = array( 'code' => $trans_mode_code );
			if ( $id ) {
				$where['id !='] = $id;
			}
			$trans_mode = $this->common->gettblrowdata( $where, 'code', 'tb_transportmode', 0, 0 );
			if ( empty( $trans_mode ) ) {
				return TRUE;
			} else {
				$this->form_validation->set_message( 'checkTransCode', "Already this Transport Code existed" );

				return FALSE;
			}
		}
	}

	public function checkTransName( $trans_mode_name ) {
		if ( empty( $trans_mode_name ) ) {
			$this->form_validation->set_message( 'checkTransName', 'Transport Name Required' );

			return FALSE;
		} else {
			$id    = $this->uri->segment( 3 );
			$where = array( 'name' => $trans_mode_name );
			if ( $id ) {
				$where['id !='] = $id;
			}
			$trans_mode = $this->common->gettblrowdata( $where, 'name', 'tb_transportmode', 0, 0 );
			if ( empty( $trans_mode ) ) {
				return TRUE;
			} else {
				$this->form_validation->set_message( 'checkTransName', "Already this Transport existed" );

				return FALSE;
			}
		}
	}

	public function add() {
		$data['page_title'] = $this->lang->line( 'transport_mode' );
		$data['sub_title']  = $this->lang->line( 'transport_mode' );
		if ( $_POST ) {

			$this->form_validation->set_rules( 'trans_mode_name', 'Transport name', 'required' );
			$this->form_validation->set_rules( 'trans_mode_code', 'Transport Code', 'required' );
			if ( $this->form_validation->run() == FALSE ) {

				$data['error']['trans_mode_name'] = form_error( 'trans_mode_name' );
				$data['error']['trans_mode_code'] = form_error( 'trans_mode_code' );
				$this->form_validation->set_error_delimiters( '<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>' );
				$this->newtemplate->dashboard( 'transport_mode/add', $data );
			} else {
				$array['company_code']   = $companycode   = $this->input->post( 'company_code' );
				$array['branch_code']    = $branchcode    = $this->input->post( 'branch_code' );
				$array['name']      = $tname = $this->input->post( 'trans_mode_name' );
				$array['code']      = $tcode = $this->input->post( 'trans_mode_code' );
				$array['user_id']   = $this->session->userdata( 'user_id' );
				$array['status']    = $this->input->post( 'status' );
				$array['updatedon'] = date( 'Y-m-d H:i:s' );
				$array['createdon'] = date( 'Y-m-d H:i:s' );
                $customer_id = $this->input->post('getcustomer_id');
                $checkdata = $this->checktransModedata($companycode,$branchcode,$tname,$tcode);
                if(!empty($checkdata)) {
                    if (!empty($customer_id)) {
                        $sub_data['customer_id'] = $customer_id;
                        $sub_data['tranportrow_id'] = $checkdata;
                        $trans_data = $this->common->gettblrowdata($sub_data, 'id', 'customer_moddata', 0, 0);
                        if ($trans_data['id'] == '') {
                            $this->common->insertTableData('customer_moddata', $sub_data);
                            redirect( 'transportmodes' );
                        }
                        else{
                            $this->session->set_flashdata('checkTranscustName', "Transport existed with this Customer");
                        }
                    }else {
                        $this->session->set_flashdata('checkTransName', "Transport Name existed");
                        $this->session->set_flashdata('checkTransCode', "Transport Code existed");
                    }
                    redirect( 'transportmodes/add' );
                }
                else{
                    $result_id = $this->common->insertTableData('tb_transportmode',$array);
                    if(!empty($customer_id)) {
                        $sub_data['customer_id'] = $customer_id;
                        $sub_data['tranportrow_id'] = $result_id;
                        $this->common->insertTableData('customer_moddata',$sub_data);
                    }
                    redirect( 'transportmodes' );
                }
			}
		} else {
			$this->newtemplate->dashboard( 'transport_mode/add', $data );
		}
	}

	public function edit( $id,$cid='' ) {
		$data['page_title'] = $this->lang->line( 'transport_mode' );
		$data['sub_title']  = $this->lang->line( 'transport_mode' );
		$data['trans_mode'] = $this->common->gettblrowdata( array( 'id' => $id ), 'id, name as trans_mode_name, code as trans_mode_code,company_code,branch_code, user_id, status, createdon,updatedon', 'tb_transportmode', 0, 0 );
        $data['customer_id'] = $cid;
        if(!empty($data['trans_mode']['company_code'])) {
            $swhere['company_code'] = $data['trans_mode']['company_code'];
        }
        if(!empty($data['trans_mode']['branch_code'])) {
            $swhere['branch_code'] = $data['trans_mode']['branch_code'];
        }
        if(!empty($swhere)) {
            $customer = $this->db->select('id,name,code')->get_where("tb_customers", $swhere);
            $data['customers'] = $customer->result_array();
        }
        else{
            $data['customers'] = [];
        }
		if ( isset( $data['trans_mode']['id'] ) ) {
			if ( $_POST ) {
				$this->form_validation->set_rules( 'trans_mode_name', 'Transport name', 'required' );
				$this->form_validation->set_rules( 'trans_mode_code', 'Transport Code', 'required' );
				if ( $this->form_validation->run() == FALSE ) {
					$data['error']['trans_mode_name'] = form_error( 'trans_mode_name' );
					$data['error']['trans_mode_code'] = form_error( 'trans_mode_code' );
					$this->form_validation->set_error_delimiters( '<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>' );
					$this->newtemplate->dashboard( 'transport_mode/edit', $data );
				} else {
					$array['name']   = $tname   = $this->input->post( 'trans_mode_name' );
					$array['code']   = $tcode   = $this->input->post( 'trans_mode_code' );
					$array['company_code']  = $companycode     = $this->input->post( 'company_code' );
					$array['branch_code']   = $branchcode  = $this->input->post( 'branch_code' );
					$array['updatedon'] = date( 'Y-m-d H:i:s' );
					$array['user_id']   = $this->session->userdata( 'user_id' );
					$array['status']    = $this->input->post( 'status' );
                    $customer_id = $this->input->post('getcustomer_id');
                    $checkdata = $this->checktransModedata($companycode,$branchcode,$tname,$tcode);
                    if(!empty($checkdata) && !empty($customer_id)) {
                        if(!empty($cid)) {
                            $where['tranportrow_id'] = $checkdata;
                            $where['customer_id'] = $cid;
                        }else{
                            $where['tranportrow_id'] = $checkdata;
                            $where['customer_id'] = $customer_id;
                        }
                        $trans_data = $this->common->gettblrowdata($where,'id','customer_moddata',0,0);
                        if($trans_data['id'] == '') {
                            $sub_data['customer_id']   = $customer_id;
                            $sub_data['tranportrow_id'] = $checkdata;
                            $this->common->insertTableData('customer_moddata', $sub_data);
                        }
                        else{
                            $sub_data['customer_id']   = $customer_id;
                            $this->common->updatetbledata('customer_moddata',$sub_data,array('id'=>$trans_data['id']));
                        }
                    }
					$this->common->updatetbledata( 'tb_transportmode', $array, array( 'id' => $id ) );
					redirect( 'transportmodes' );
				}
			} else {
				$this->newtemplate->dashboard( 'transport_mode/edit', $data );
			}
		} else {
			show_error( 'The transport mode you are trying to Edit does not exist.' );
		}
	}

	public function deleteTransportMode( $id ) {
		if ( $id != '' || $id != 0 ) {
			$chk = $this->common->gettblrowdata( array( 'id' => $id ), 'id', 'tb_transportmode', 0, 0 );
			if ( $chk ) {
				$upd = $this->common->updatetbledata( 'tb_transportmode', array( 'status' => 0 ), array( 'id' => $id ) );
				if ( $upd ) {
                    $this->common->updatetbledata('customer_moddata',array('status'=>0),array('tranportrow_id'=>$id));
					echo "1";
				} else {
					echo "0";
				}
			} else {
				echo "0";
			}
		}
	}

	public function view( $id ,$cid='') {
		$data['page_title'] = $this->lang->line( 'transport_mode' );
		$data['sub_title']  = $this->lang->line( 'transport_mode' );
		$data['trans_mode'] = $this->common->gettblrowdata( array( 'id' => $id ), 'id,company_code,branch_code, name, code, user_id, status, createdon,updatedon', 'tb_transportmode', 0, 0 );
        $data['trans_customer'] = $this->transportmodel->getCustomerdata($id,$cid);
        $this->newtemplate->dashboard( 'transport_mode/view', $data );
	}

    public function checktransModedata( string $companycode , string $branchcode, string $tname, string $tcode): int{
        if(!empty($companycode) && !empty($tname) && !empty($tcode)){
            $sdata =  $this->common->gettblrowdata(array('company_code'=>$companycode,'branch_code'=>$branchcode,'code'=>$tcode,'name'=>$tname),'id','tb_transportmode',0,0);
            if($sdata){
                return $sdata['id'];
            }else{
                $maindata =  $this->common->gettblrowdata(array('company_code'=>'','branch_code'=>'','code'=>$tcode,'name'=>$tname),'id','tb_transportmode',0,0);
                return ($maindata) ? $maindata['id'] : 0 ;
            }
        }
        else{
            return 0;
        }
    }
}

