<?php

use App\Trip\Services\TripService;

if(!defined('BASEPATH')) exit('No direct script access allowed');

class Trip extends CI_Controller {
	public function __Construct()
	{
		parent::__Construct();
		if(!$this->session->userdata('user_id'))
		{
			redirect('login');
		}

        $this->load->model("common");
	}

	public function index(): void
    {
		$pdf_base64 = "./assets/spoton_pdf_response.txt";
		$pdf_base64_handler = fopen($pdf_base64,'r');
		$pdf_content = fread ($pdf_base64_handler,filesize($pdf_base64));
		fclose ($pdf_base64_handler);
		$decoded = base64_decode($pdf_content);
		$file = './assets/spotondocs/invoice.pdf';
		file_put_contents($file, $decoded);

		if (file_exists($file)) {

		    header('Content-Description: File Transfer');
		    header('Content-Type: application/octet-stream');
		    header('Content-Disposition: attachment; filename="'.basename($file).'"');
		    header('Expires: 0');
		    header('Cache-Control: must-revalidate');
		    header('Pragma: public');
		    header('Content-Length: ' . filesize($file));
		    readfile($file);
		    exit;
		}
	}

    /**
     * @param int $orderId
     */
    public function cancel(int $orderId): void
    {
        $shift = $this->common->gettblrowdata(['id' => $orderId] , "shift_id", "tb_orders", 0, 0);

        $canceledSuccess = TripService::cancel($shift['shift_id'] ?? 0, $this->session->userdata('user_id'));

        if ($canceledSuccess) {
            $this->session->set_flashdata('success_msg', "The trip was canceled");
        } else {
            $this->session->set_flashdata('success_msg', "Something went wrong");
        }

        redirect('/orders');
    }
}
