<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Customer\Models\Reference\DeliveryNote;
use Symfony\Component\Validator\Constraints\Length;

class TripRevenues extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['session', 'Ratemanagement', 'Exchangerate', 'newjfrlogic_sgmy', 'SearchService']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['Order', 'common', 'Order_details', 'trips_model', 'common', 'triptemplatemodel']);
    }


    public function getTripRateService()
    {
        $post = $this->input->post(NULL, TRUE);
        $shiftId = $post['shift_id'];
        $data['details']         = $this->common->gettblrowdata(['id' => $shiftId], "id,shipmentid,transport_mode,carrier_type,company_code,branch_code,department_code,border_type,origin_id,destination_id,customer_id", 'tb_shifts', 0, 0);
        $data['shiftOrders'] = $this->trips_model->getShiftOrders($shiftId);
        //log_message("error", "shiftLegsdata:" . json_encode($data['shiftOrders']));
        foreach ($data['shiftOrders'] as $eachRow) {
            //log_message("error", "eachRow:" . json_encode($eachRow));
            $data['shiftOrders'][] = $eachRow;
            $orderId               = $eachRow['orderRowId'];
            $product               = $eachRow['product'];
            $service               = $eachRow['service'];
        }

        $orderId = $orderId ?? "";
        $product = $product ?? "";
        $service = $service ?? "";

        $pickup_id         = $data['details']['customer_id'];
        $orderDetails = $this->trips_model->getOrdersDetailsByShiftId($shiftId);

        $pickup_location = $delivery_location = "";
        if (isset($orderDetails)) {
            $pickup_location   = ['country' => $orderDetails[0]['pickup_country'], 'zipcode' => $orderDetails[0]['pickup_pincode'], 'user_id' => $orderDetails[0]['user_id'], 'city' => $orderDetails[0]['pickup_address2']];
            $delivery_location = ['country' => $orderDetails[count($orderDetails) - 1]['delivery_country'], 'zipcode' => $orderDetails[count($orderDetails) - 1]['delivery_pincode'], 'user_id' => $orderDetails[count($orderDetails) - 1]['user_id'], 'city' => $orderDetails[count($orderDetails) - 1]['delivery_address2']];
        }
        $info              = ['order_id' => $orderId, 'product' => $product];
        $data['rates']  = $this->ratemanagement->getcustomerprofiledetailsbyid($pickup_id, $service, $pickup_location, $delivery_location, $info);
        //log_message('error', 'rate Services:' . print_r($data, true));
        echo json_encode($data);
    }


    public function getlaneids_byservice()
    {
        $lanes = $post = array();
        $post = $this->input->post(NULL, TRUE);
        $service_id = isset($post['service_id']) ? $post['service_id'] : "";
        $order_id = isset($post['order_id']) ? $post['order_id'] : "";
        $shift_id = isset($post['shift_id']) ? $post['shift_id'] : "";
        $consignee_country = isset($post['consignee_country']) ? $post['consignee_country'] : "";
        $shipper_country = isset($post['shipper_country']) ? $post['shipper_country'] : "";
        $shipper_city = isset($post['shipper_city']) ? $post['shipper_city'] : "";
        $consignee_city = isset($post['consignee_city']) ? $post['consignee_city'] : "";
        $shipper_zipcode = isset($post['shipper_zipcode']) ? $post['shipper_zipcode'] : "";
        $consignee_zipcode = isset($post['consignee_zipcode']) ? $post['consignee_zipcode'] : "";
        $source = array('consignee_country' => $consignee_country, 'shipper_country' => $shipper_country, 'shipper_city' => $shipper_city, 'consignee_city' => $consignee_city, 'shipper_zipcode' => $shipper_zipcode, 'consignee_zipcode' => $consignee_zipcode);
        $lanes = $this->ratemanagement->getlaneids_byservice($service_id, $order_id, $source, $shift_id);
        echo json_encode($lanes);
    }

    public function getoffering_bylane()
    {
        $offering = $post = array();
        $post = $this->input->post(NULL, TRUE);
        $lane_id =  isset($post['lane_id']) ? $post['lane_id'] : "";
        $type =  isset($post['type']) ? $post['type'] : "0";
        $service_id =  isset($post['service_id']) ? $post['service_id'] : "0";
        $rate_service =  isset($post['rate_service']) ? $post['rate_service'] : "0";
        $order_id =  isset($post['order_id']) ? $post['order_id'] : "";
        $shift_id = isset($post['shift_id']) ? $post['shift_id'] : "";
        if ($lane_id != '' && $lane_id != '0') {
            $offering = $this->ratemanagement->getoffering_bylane($lane_id, $type, $service_id, $rate_service, $order_id, $shift_id);
        }
        echo json_encode($offering);
    }
    public function getrecord_byoffering()
    {
        $record = $post = array();
        $post = $this->input->post(NULL, TRUE);
        $offering_id =  isset($post['offering_id']) ? $post['offering_id'] : "";
        $order_id =  isset($post['order_id']) ? $post['order_id'] : "";
        $shift_id =  isset($post['shift_id']) ? $post['shift_id'] : "";
        if ($offering_id != '' && $offering_id != '0') {
            $record = $this->ratemanagement->getrecord_byoffering($offering_id, $order_id, $shift_id);
        }
        echo json_encode($record);
    }
    public function addrevchargesbyrecord()
    {
        $cdate = date('Y-m-d H:i:s');
        $response = array();
        $sts = 0;
        $rr_tier_id = $geo_tier_id = null;
        $geo_sts = $rate_sts = $stsid = 1;
        $charge_type = $base_uom = "";
        $user_id = $this->session->userdata('user_id');
        $currency = $this->session->userdata("usr_tzone")['currency'];
        $post = $this->input->post();
        $addrecord = $this->ratemanagement->addrevchargesbyrecord($post, $user_id, $currency);
        $offering = isset($post['rate_offering']) ? $post['rate_offering'] : "";
        $rate_service = isset($post['rate_service']) ? $post['rate_service'] : "";
        $order_id = isset($post['order_id']) ? $post['order_id'] : "
        ";
        $shift_id = isset($post['shift_id']) ? $post['shift_id'] : "";
        $record = isset($post['record']) ? $post['record'] : "";
        $type = isset($post['type']) ? $post['type'] : "";
        if ($type == '0') {
            $type = "SELL";
        } else {
            $type = "BUY";
        }
        $sts = "NO Conversion 'UOM conversion Not available for Rate Calculation'";
        if ($record != "" && !is_null($record)) {

            $where = array('raterecord_id' => $record, 'status' => '1');
            $select = "rr_charge_type,rr_tier_id,geo_tier_id,rr_charge_id,charge_basis,exchange_rate_id,min_amount,amount,currency";
            $table = "tb_raterecord_charges";
            $getcharges = $this->common->gettbldata($where, $select, $table, 0, 0);
            if (!empty($getcharges)) {
                foreach ($getcharges as $row) {
                    $base_uom = "";
                    $rr_tier_id = $geo_tier_id = null;
                    $charge_basis = strtoupper($row['charge_basis'] ?? "");
                    $charge_type = strtoupper($row['rr_charge_type']);
                    $amount = $row['amount'];
                    if ($charge_type == 'FIXED') {
                        if ($charge_basis == 'PER KG' || $charge_basis == 'KG' || $charge_basis == 'PER CBM' || $charge_basis == 'CBM') {
                            $base_uom = $charge_basis;
                            if ($charge_basis == 'PER KG' || $charge_basis == 'KG') {
                                $base_uom = 'KG';
                            }
                            if ($charge_basis == 'PER CBM' || $charge_basis == 'CBM') {
                                $base_uom = 'CBM';
                            }
                        }
                        $stsid = $this->chekconversion_baseuom($offering, $base_uom, $order_id, $type);
                    }
                    if ($charge_type == 'TIER') {
                        $uom = "";
                        $rr_tier_id = $row['rr_tier_id'];
                        $getratetier = $this->common->gettblrowdata(array('id' => $rr_tier_id, 'user_id' => $user_id, 'status' => '1'), "billing_uom", "tb_tier_master", 0, 0);
                        if (!empty($getratetier)) {
                            $billing_uom = $getratetier['billing_uom'];
                            if ($billing_uom != "") {
                                if ($billing_uom == 'WEIGHT' || $billing_uom == 'ACTUAL WEIGHT') {
                                    $uom = 'KG';
                                }
                                if ($billing_uom == 'VOLUME' || $billing_uom == 'ACTUAL VOLUME') {
                                    $uom = 'CBM';
                                }
                                if ($billing_uom == 'LDM') {
                                    $uom = 'LDM';
                                }
                            }
                            if ($uom != "") {
                                $rate_sts = $this->chekconversion_baseuom($offering, $uom, $order_id, $type);
                            }
                        }
                    }
                    if ($charge_type == 'GEO TIER') {
                        $geo_tier_id = $row['geo_tier_id'];
                        $getgeotier = $this->common->gettblrowdata(array('id' => $geo_tier_id, 'status' => '1'), "unit_measure1", "tb_geo_tier", 0, 0);
                        if (!empty($getgeotier)) {
                            $unit_measure1 = $getgeotier['unit_measure1'];
                            $geo_sts = $this->chekconversion_baseuom($offering, $unit_measure1, $order_id, $type);
                        }
                    }
                }
                if ($stsid == "0") {
                    $sts = "NO Conversion 'UOM conversion Not available for Rate Calculation'";
                }
            }
            $response = array('sts' => $sts, 'rate_sts' => $rate_sts, 'geo_sts' => $geo_sts, 'stsid' => $stsid);
        }
        echo json_encode($response);
    }

    public function chekconversion_baseuom($offering, $base_uom, $order_id, $type)
    {
        $stsid = 0;
        $user_id = $this->session->userdata('user_id');
        $getconversion_id = $this->common->gettblrowdata(array('id' => $offering, 'status' => '1'), "uom_conversion_id", "tb_rate_offerings", 0, 0);
        if (!empty($getconversion_id)) {
            $conversion_id = $getconversion_id['uom_conversion_id'];
            if ($conversion_id != "" && $conversion_id != "0") {
                $get_country = $this->db->select('country_code,company_code')->get_where("tb_users", array('id' => $user_id));
                $country_code  = $get_country->row()->country_code;
                $company_code  = $get_country->row()->company_code;
                $getchargeable_weight = $this->common->gettblrowdata(array('id' => $conversion_id, 'country' => $country_code, 'type' => $type, 'base_uom' => $base_uom, 'status' => '1'), "uom_type1,uom1,uom1_conversion,uom_type2,uom2,uom2_conversion,uom_type3,uom3,uom3_conversion,uom_type4,uom4,uom4_conversion,customer_id", "tb_knuom_conversion", 0, 0);
                if (!empty($getchargeable_weight)) {
                    $customer_id = $getchargeable_weight['customer_id'];
                    if ($customer_id != "0" && $customer_id != "") {
                        $chkordercustomer = $this->common->gettblrowdata(array('id' => $order_id), "customer_id", "tb_orders", 0, 0);
                        if (!empty($chkordercustomer)) {
                            $order_customer_id = $chkordercustomer['customer_id'];
                            if ($order_customer_id == $customer_id) {
                                $stsid = 1;
                            } else {
                                $stsid = 0;
                            }
                        }
                    } else {
                        $stsid = 1;
                    }
                    $total_conversion1 = $total_conversion2 = $total_conversion3 = $total_conversion4 = array('sts' => '0', 'total_amount' => '1');
                    if ($stsid == '1') {
                        $uom1 = $getchargeable_weight['uom1'];
                        if ($uom1 != "") {
                            $uom1_conversion = $getchargeable_weight['uom1_conversion'];
                            $uom_type1 = $getchargeable_weight['uom_type1'];
                            $total_conversion1 = $this->ratemanagement->getconversionableamount($uom1, $uom_type1, $uom1_conversion, $order_id);
                        }
                        $uom2 = $getchargeable_weight['uom2'];
                        if ($uom2 != "") {
                            $uom2_conversion = $getchargeable_weight['uom2_conversion'];
                            $uom_type2 = $getchargeable_weight['uom_type2'];
                            $total_conversion2 = $this->ratemanagement->getconversionableamount($uom2, $uom_type2, $uom2_conversion, $order_id);
                        }
                        $uom3 = $getchargeable_weight['uom3'];
                        if ($uom3 != "") {
                            $uom3_conversion = $getchargeable_weight['uom3_conversion'];
                            $uom_type3 = $getchargeable_weight['uom_type3'];
                            $total_conversion3 = $this->ratemanagement->getconversionableamount($uom3, $uom_type3, $uom3_conversion, $order_id);
                        }
                        $uom4 = $getchargeable_weight['uom4'];
                        if ($uom4 != "") {
                            $uom4_conversion = $getchargeable_weight['uom4_conversion'];
                            $uom_type4 = $getchargeable_weight['uom_type4'];
                            $total_conversion4 = $this->ratemanagement->getconversionableamount($uom4, $uom_type4, $uom4_conversion, $order_id);
                        }
                        $final_conversion1 = $final_conversion2 = $final_conversion3 = $final_conversion4 = "0";
                        if ($total_conversion1['sts'] == '1') {
                            $final_conversion1 = $total_conversion1['total_amount'];
                        }
                        if ($total_conversion2['sts'] == '1') {
                            $final_conversion2 = $total_conversion2['total_amount'];
                        }
                        if ($total_conversion3['sts'] == '1') {
                            $final_conversion3 = $total_conversion3['total_amount'];
                        }
                        if ($total_conversion4['sts'] == '1') {
                            $final_conversion4 = $total_conversion4['total_amount'];
                        }
                        $final_conversion = max($final_conversion1, $final_conversion2, $final_conversion3, $final_conversion4);
                    }
                } else {
                    $stsid == "0";
                    $sts = "NO Conversion 'UOM conversion Not available for Rate Calculation'";
                }
            } else {
                $stsid = 1;
            }
        }
        return $stsid;
    }

    public function getallchargesbyid()
    {
        $post = array();
        $post = $this->input->post(NULL, TRUE);
        $session_companycode = $this->session->userdata("company_code");
        $id   = isset($post['id']) ? $post['id'] : "";
        $list = array();
        if ($id != "") {
            $chargesresult = $this->common->gettbldata(array('revenue_id' => $id, 'status' => '1'), 'description,amount,currency,vat_percentage,vat_amount', 'trip_charges', 0, 0);
            if (!empty($chargesresult)) {
                foreach ($chargesresult as $res) {
                    if ($res['amount'] > 0) {
                        $list[] = "<li><label>" . $res['description'] . " </label> <span class='amount'>" . floatval($res['amount']) . " " . $res['currency'] . "</span></li>";
                    }
                    if (($res['vat_percentage'] > 0) && ($res['vat_amount']  > 0)) {
                        $vat_name = "VAT";
                        if ($session_companycode == "SGKN") {
                            $vat_name = "GST";
                        }
                        $list[] = "<li><label>" . $vat_name . " " . $res['vat_percentage'] . " %" . " </label> <span class='amount'>" . floatval($res['vat_amount']) . " " . $res['currency'] . "</span></li>";
                    }
                }
            }
        }
        echo json_encode($list);
    }
}
