<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Tripstemplate extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['session','tripCreateFromOrders']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        if (!checkUrlAccessForUser('TRIPSTEMPLATE')) {
            redirect("Forbiddenaccess");
        }
        $this->companyCode = $this->session->userdata('company_code');
        $this->branchCode = $this->session->userdata('branch_code');
        $this->userId = $this->session->userdata('user_id');
        $this->currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $this->countryCode = $this->session->userdata("usr_tzone")['phone_code'];
        if ($this->countryCode == "") {
            $this->countryCode = $this->session->userdata("usr_tzone")['country'];
        }
        $this->load->model(["triptemplatemodel", "trips_model"]);
    }

    public function index(): void
    {
        $data['page_title'] = $this->lang->line('trips_template');
        $data['sub_title'] = $this->lang->line('trips');
        $services = $customerIds = $orderTypes = [];
        $postData = $this->input->post();
        $whereCondition = $this->searchConditions($postData);
        $data['templates'] = $this->triptemplatemodel->getRouteTemplatesDataByWhereCondition($whereCondition, 0);
        foreach ($data['templates'] as $eachTemplate) {
            $services[] = $eachTemplate['service'];
            $customerIds[] = $eachTemplate['customer_id'];
            $orderTypes[] = $eachTemplate['order_type'];
        }
        $services = array_unique($services);
        $customerIds = array_unique($customerIds);
        $orderTypes = array_unique($orderTypes);
        if (!empty($services)) {
            $getServices = $this->triptemplatemodel->getServiceDataByIds($services);
            foreach ($getServices as $eachLine) {
                $servicesData[$eachLine['id']] = $eachLine['service_id'] . "-" . $eachLine['name'];
            }
        }
        if (!empty($customerIds)) {
            $getCustomer = $this->triptemplatemodel->getCustomersById($customerIds);
            foreach ($getCustomer as $eachLine) {
                $customersData[$eachLine['id']] = $eachLine['code'];
            }
        }
        if (!empty($orderTypes)) {
            $getOrderTypes = $this->triptemplatemodel->getOrderTypesById($orderTypes);
            foreach ($getOrderTypes as $eachLine) {
                $orderTypesData[$eachLine['id']] = $eachLine['type_name'];
            }
        }
        $data['servicesData'] = $servicesData ?? [];
        $data['customersData'] = $customersData ?? [];
        $data['orderTypesData'] = $orderTypesData ?? [];
        $this->newtemplate->dashboard("tripstemplate/index", $data);
    }

    private function searchConditions(array $post): string
    {
        $whereCondition = "";
        if (!empty($post)) {
            if (isset($post['templateId']) && $post['templateId'] != "") {
                $whereCondition .= " template_id = '" . $post['templateId'] . "' AND ";
            }
            if (isset($post['templateName']) && $post['templateName'] != "") {
                $whereCondition .= " template_name = '" . $post['templateName'] . "' AND ";
            }
            if (isset($post['fromDate']) && $post['fromDate'] != "") {
                $whereCondition .= "  DATE(created_on) >='" . date('Y-m-d', strtotime($post['fromDate'])) . "' AND ";
            }
            if (isset($post['toDate']) && $post['toDate'] != "") {
                $whereCondition .= "  DATE(created_on) <='" . date('Y-m-d', strtotime($post['toDate'])) . "' AND ";
            }
            if (isset($post['product']) && $post['product'] != "") {
                $whereCondition .= "  product ='" . $post['product'] . "' AND ";
            }
            if (isset($post['carrierType']) && $post['carrierType'] != "") {
                $whereCondition .= " carrier_type ='" . $post['carrierType'] . "' AND ";
            }
            if (isset($post['shipmentType']) && $post['shipmentType'] != "") {
                $whereCondition .= "  shipment_type ='" . $post['shipmentType'] . "' AND ";
            }
            if (isset($post['customerId']) && $post['customerId'] != "") {
                $companyCodes = $this->getXborderCountries();
                $getCustomerCode = $this->triptemplatemodel->getCustomerRowByWhereCondition(0, ['code' => $post['customerId'], 'companyCode' => $companyCodes, 'status' => '1']);
                $customerRowId = $getCustomerCode['id'] ?? 0;
                $whereCondition .= "  customer_id ='" . $customerRowId . "' AND ";
            }
        }
        $whereCondition .= "user_id = '" . $this->userId . "' AND status = '1' ";
        return $whereCondition;
    }


    public function addTemplate(): void
    {
        $data = ['page_title' => $this->lang->line('trips_template'), "sub_title" => $this->lang->line('trips'), 'companyCode' => $this->companyCode, 'branchCode' => $this->branchCode];
        //$this->newtemplate->dashboard("tripstemplate/add", $data);
        $this->load->view("tripstemplate/add", $data);
    }

    public function viewTemplate($templateRowId): void
    {
        $data['page_title'] = $this->lang->line('trips_template');
        $data['sub_title'] = $this->lang->line('trips');
        $templateDetails = $this->triptemplatemodel->getRouteTemplatesDataByWhereCondition("id='" . $templateRowId . "' AND status ='1'", '1');
        if (empty($templateDetails)) {
            redirect('tripstemplates/addtemplate');
        }
        $customerRowId = $templateDetails['customer_id'];
        if ($customerRowId > 0) {
            $getCustomerCode = $this->triptemplatemodel->getCustomerRowByWhereCondition($customerRowId, []);
        }
        $customerCode = $getCustomerCode['code'] ?? "";
        $data = [
            'templateRowId' => $templateRowId,
            'templateId' => $templateDetails['template_id'],
            'templateName' => $templateDetails['template_name'],
            'activeTemplate' => $templateDetails['active'],
            'templateDescription' => $templateDetails['description'],
            'product' => $templateDetails['product'],
            'service' => $templateDetails['service'],
            'customerCode' => $customerCode,
            'customerRowId' => $customerRowId,
            'orderType' => $templateDetails['order_type'],
            'carrierType' => $templateDetails['carrier_type'],
            'shipmentType' => $templateDetails['shipment_type'],
            'minimumDistance' => $templateDetails['min_distance'],
            'minDistanceUom' => $templateDetails['mindistance_units'],
            'maximumDistance' => $templateDetails['max_distance'],
            'maxDistanceUom' => $templateDetails['maxdistance_units'],
            'minimumVolume' => $templateDetails['min_volume'],
            'minVolumeUom' => $templateDetails['minvolume_units'],
            'maximumVolume' => $templateDetails['max_volume'],
            'maxVolumeUom' => $templateDetails['maxvolume_units'],
            'minimumWeight' => $templateDetails['min_weight'],
            'minWeightUom' => $templateDetails['minweight_units'],
            'maximumWeight' => $templateDetails['max_weight'],
            'maxWeightUom' => $templateDetails['maxweight_units'],
            'companyCode' => $this->companyCode,
            'branchCode' => $this->branchCode,
        ];
        //$this->newtemplate->dashboard("tripstemplate/view", $data);
        $this->load->view("tripstemplate/view", $data);
    }

    public function editTemplate($templateRowId): void
    {
        if ($templateRowId == 0) {
            redirect('tripstemplates/addtemplate');
        }
        $data['page_title'] = $this->lang->line('trips_template');
        $data['sub_title'] = $this->lang->line('trips');
        $templateDetails = $this->triptemplatemodel->getRouteTemplatesDataByWhereCondition("id='" . $templateRowId . "' AND status ='1'", '1');
        if (empty($templateDetails)) {
            redirect('tripstemplates/addtemplate');
        }
        $customerRowId = $templateDetails['customer_id'];
        if ($customerRowId > 0) {
            $getCustomerCode = $this->triptemplatemodel->getCustomerRowByWhereCondition($customerRowId, []);
        }
        $customerCode = $getCustomerCode['code'] ?? "";
        $data = [
            'templateRowId' => $templateRowId,
            'templateId' => $templateDetails['template_id'],
            'templateName' => $templateDetails['template_name'],
            'activeTemplate' => $templateDetails['active'],
            'templateDescription' => $templateDetails['description'],
            'product' => $templateDetails['product'],
            'service' => $templateDetails['service'],
            'customerCode' => $customerCode,
            'customerRowId' => $customerRowId,
            'orderType' => $templateDetails['order_type'],
            'carrierType' => $templateDetails['carrier_type'],
            'shipmentType' => $templateDetails['shipment_type'],
            'minimumDistance' => $templateDetails['min_distance'],
            'minDistanceUom' => $templateDetails['mindistance_units'],
            'maximumDistance' => $templateDetails['max_distance'],
            'maxDistanceUom' => $templateDetails['maxdistance_units'],
            'minimumVolume' => $templateDetails['min_volume'],
            'minVolumeUom' => $templateDetails['minvolume_units'],
            'maximumVolume' => $templateDetails['max_volume'],
            'maxVolumeUom' => $templateDetails['maxvolume_units'],
            'minimumWeight' => $templateDetails['min_weight'],
            'minWeightUom' => $templateDetails['minweight_units'],
            'maximumWeight' => $templateDetails['max_weight'],
            'maxWeightUom' => $templateDetails['maxweight_units'],
            'companyCode' => $this->companyCode,
            'branchCode' => $this->branchCode,
        ];
        //$this->newtemplate->dashboard("tripstemplate/add", $data);
        $this->load->view("tripstemplate/add", $data);
    }

    public function deleteTripTemplateById(): void
    {
        $data['status'] = 0;
        $rowId = $_POST['rowId'] ?? 0;
        if ($rowId > 0) {
            $updated = $this->triptemplatemodel->updateRouteTemplateTableData(['status' => '0'], $rowId);
            if ($updated) {
                $data['status'] = 1;
            }
        }
        echo json_encode($data);
    }

    public function insertTemplate(): void
    {
        $post = $this->input->post();
        $activeTemplate = $post['activeTemplate'] ?? 0;
        $templateRowId = $post['templateRowId'] ?? 0;
        $data['template_name'] = $post['templateName'] ?? "";
        $data['active'] = $activeTemplate ? 1 : 0;
        $data['description'] = $post['templateDescription'] ?? "";
        $data['product'] = $post['product'] ?? "";
        $data['service'] = $post['service'] ?? "";
        $data['customer_id'] = $post['customerRowId'] ?? 0;
        $data['order_type'] = $post['orderType'] ?? "";
        $data['carrier_type'] = $post['carrierType'] ?? "";
        $data['shipment_type'] = $post['shipmentType'] ?? "";
        $data['min_distance'] = $post['minimumDistance'] ?? 0;
        $data['mindistance_units'] = $post['minDistanceUom'] ?? "KM";
        $data['max_distance'] = $post['maximumDistance'] ?? 0;
        $data['maxdistance_units'] = $post['maxDistanceUom'] ?? "KM";
        $data['min_volume'] = $post['minimumVolume'] ?? 0;
        $data['minvolume_units'] = $post['minVolumeUom'] ?? "CBM";
        $data['max_volume'] = $post['maximumVolume'] ?? 0;
        $data['maxvolume_units'] = $post['maxVolumeUom'] ?? "CBM";
        $data['min_weight'] = $post['minimumWeight'] ?? 0;
        $data['minweight_units'] = $post['minWeightUom'] ?? "KG";
        $data['max_weight'] = $post['maximumWeight'] ?? 0;
        $data['maxweight_units'] = $post['maxWeightUom'] ?? "KG";
        $data['company_code'] = $this->companyCode;
        $data['branch_code'] = $this->branchCode;
        $data['user_id'] = $this->userId;
        $currentDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
        $data['created_on'] = $currentDate['date'];
        if ($templateRowId > 0) {
            $updateTemplate = $this->triptemplatemodel->updateRouteTemplateTableData($data, $templateRowId);
            $data['template_id'] = $post['templateId'];
        } else {
            $data['template_id'] = $this->generateTripTemplateId();
            $templateRowId = $this->triptemplatemodel->insertRouteTemplateTableData($data);
        }
        if ($templateRowId > 0) {
            $legIds = $this->saveLegs($post, $data['template_id']);
            if (!empty($legIds)) {
                $updateLegs = $this->triptemplatemodel->updateRouteTemplateLegsTableData(['routetemplate_id' => $templateRowId], $legIds);
            }
        }
        redirect('tripstemplate');
    }

    private function generateTripTemplateId(): string
    {
        $currentYear = date('y');
        $currentWeek = date('W');
        $getLatestTemplateId = $this->triptemplatemodel->getLastTemplateId();
        if (empty($getLatestTemplateId)) {
            $sequence = 1;
        } else {
            $previousTemplateId = $getLatestTemplateId['template_id'];
            $previousWeekNumber = substr($previousTemplateId, 4, 2);
            $getPreviousSequence = substr($previousTemplateId, 6);
            $PreviousSequence = ltrim($getPreviousSequence, 0);
            if ($previousWeekNumber < $currentWeek) {
                $sequence = 1;
            } else {
                $sequence = $PreviousSequence;
                $sequence++;
            }
        }
        $templateId = str_pad($sequence, 4, "0", STR_PAD_LEFT);
        $generatedTemplateId = "TT" . $currentYear . $currentWeek . $templateId;
        return $generatedTemplateId;
    }

    private function saveLegs(array $data, string $shipmentId): array
    {
        $legRowIds = [];
        $templateRowId = $data['templateRowId'] ?? 0;
        $currentDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
        for ($i = 0; $i < 6; $i++) {
            $j = $i + 1;
            $originRowId = $data['originRowId' . $i] ?? 0;
            $destinationRowId = $data['destinationRowId' . $i] ?? 0;
            if (!in_array('0', [$originRowId, $destinationRowId])) {
                $legId = $shipmentId . "-" . $j;
                $legRowId = $data['legRowId' . $i] ?? 0;
                $originLocation = $data['originLocation' . $i] ?? "";
                $destinationLocation = $data['destinationLocation' . $i] ?? "";
                $carrier = $data['carrier' . $i] ?? 0;
                $vehicleType = $data['vehicleType' . $i] ?? 0;
                $modeOfTransport = $data['modeOfTransport' . $i] ?? 0;
                $vehicle = $data['vehicle' . $i] ?? 0;
                $driver = $data['driver' . $i] ?? 0;
                if ($legRowId > 0) {
                    $legRowIds[] = $legRowId;
                    $updateLegs = $this->triptemplatemodel->updateRouteTemplateLegsTableData(['routetemplate_id' => $templateRowId, 'leg_id' => $legId, 'origin_id' => $originRowId, 'origin_location' => $originLocation, 'destination_id' => $destinationRowId, 'destination_location' => $destinationLocation, 'carrier_id' => $carrier, 'transport_mode' => $modeOfTransport, 'vehicle_type' => $vehicleType, 'vehicle_id' => $vehicle, 'driver_id' => $driver, 'status' => '1'], [$legRowId]);
                } else {
                    $legRowIds[] = $this->triptemplatemodel->insertRouteTemplateLegsTableData(
                        ['routetemplate_id' => $templateRowId, 'leg_id' => $legId, 'origin_id' => $originRowId, 'origin_location' => $originLocation, 'destination_id' => $destinationRowId, 'destination_location' => $destinationLocation, 'carrier_id' => $carrier, 'transport_mode' => $modeOfTransport, 'vehicle_type' => $vehicleType, 'vehicle_id' => $vehicle, 'driver_id' => $driver, 'status' => '1', 'created_on' => $currentDate['date']]
                    );
                }
            }
        }
        return $legRowIds;
    }

    public function getCrossBorderCustomerDetails(): void
    {
        $customers = [];
        $customerId = $_POST['customerId'] ?? 0;
        $where = "";
        if ($customerId > 0) {
            $where .= " id = '" . $customerId . "' ";
        }
        $companyCodes = $this->getXborderCountries();
        $getCustomers = $this->triptemplatemodel->getCustomersByWhereCondition($companyCodes);
        foreach ($getCustomers as $eachCustomer) {
            $customers[] = [
                'checkBox' => "<input class='customerList' type='radio' name='selectCustomer' id='customerList_" . $eachCustomer['id'] . "' value='" . $eachCustomer['id'] . "' data-code='" . $eachCustomer['code'] . "' onclick=selectCustomer(" . $eachCustomer['id'] . ")>",
                'customerRowId' => $eachCustomer['id'],
                'customerName' => $eachCustomer['name'],
                'customerCity' => $eachCustomer['location'],
                'customerCode' => $eachCustomer['code'],
                'customerCountry' => $eachCustomer['country'],
                'customerState' => $eachCustomer['state'],
                'customerStreet' => $eachCustomer['street'],
                'customerMail' => $eachCustomer['email_id'],
                'companyCode' => $eachCustomer['company_code'],
                'branchCode' => $eachCustomer['branch_code'],
            ];
        }
        echo json_encode($customers);
    }

    public function getXborderCountries(): array
    {
        $countries = [];
        $getCouties = $this->triptemplatemodel->getxorderCountries($this->companyCode);
        if (!empty($getCouties)) {
            $countriesString = $getCouties['xborder_code'];
            if ($countriesString != "") {
                $countries = explode(',', $countriesString);
            }
        }
        $countries[] = $this->companyCode;
        return $countries;
    }

    public function getOrderTypesByCustomer(): void
    {
        $customerId = $_POST['customerId'] ?? 0;
        echo json_encode(getOrderTypes($customerId, $this->companyCode));
    }

    public function loadTripsLegsTableData(): void
    {
        $tripsData = $carrierIds = [];
        $templateRowId = $_POST['templateRowId'] ?? 0;
        if ($templateRowId > 0) {
            $getLegsFromTemplateId = $this->triptemplatemodel->getRouteTemplateLegsByWhereCondition($templateRowId);
            foreach ($getLegsFromTemplateId as $eachRowId) {
                if ($eachRowId['carrier_id'] > 0) {
                    $carrierIds[] = $eachRowId['carrier_id'];
                }
                $tripsData[] = [
                    'legRowId' => $eachRowId['id'],
                    'legId' => $eachRowId['leg_id'],
                    'OriginRowId' => $eachRowId['origin_id'],
                    'originLocation' => $eachRowId['origin_location'],
                    'destinationRowId' => $eachRowId['destination_id'],
                    'destinationLocation' => $eachRowId['destination_location'],
                    'carrierId' => $eachRowId['carrier_id'],
                    'transportMode' => $eachRowId['transport_mode'],
                    'vehicleType' => $eachRowId['vehicle_type'],
                    'vehicleId' => $eachRowId['vehicle_id'],
                    'driverId' => $eachRowId['driver_id']
                ];
            }
        }
        if (!empty($carrierIds)) {
            $carrierIds = array_unique($carrierIds);
            $carrierData = $this->trips_model->getVehicleDataFromCarriers($carrierIds);
        }
        $truckTypes = $carrierData['truckTypes'] ?? [];
        $trucksData = $carrierData['trucksData'] ?? [];
        $truckDrivers = $carrierData['truckDrivers'] ?? [];
        $companyCodes = $this->getXborderCountries();
        $carrierMaster = $this->triptemplatemodel->getCarrierMasterData($companyCodes);
        $transportMaster = gettransportmode();
        for ($i = 0; $i < 6; $i++) {
            $carrierId = $tripsData[$i]['carrierId'] ?? 0;
            $vehicleType = $tripsData[$i]['vehicleType'] ?? 0;
            $vehicleId = $tripsData[$i]['vehicleId'] ?? 0;
            $driverId = $tripsData[$i]['driverId'] ?? 0;
            $truckTypeMaster = $truckTypes[$carrierId] ?? [];
            $truckDataMaster = $trucksData[$vehicleType] ?? [];
            $truckDriversMaster = $truckDrivers[$vehicleId] ?? [];
            $legs[$i] = [
                "legId" => $tripsData[$i]['legId'] ?? "",
                "legRowId" => $tripsData[$i]['legRowId'] ?? 0,
                "origin" => $tripsData[$i]['originLocation'] ?? "",
                "OriginRowId" => $tripsData[$i]['OriginRowId'] ?? 0,
                "destination" => $tripsData[$i]['destinationLocation'] ?? "",
                "destinationRowId" => $tripsData[$i]['destinationRowId'] ?? 0,
                "carrier" => $carrierId,
                "modeOfTransport" => $tripsData[$i]['transportMode'] ?? "",
                "vehicleType" => $vehicleType,
                "vehicle" => $vehicleId,
                "driver" => $driverId,
                "truckTypeMaster" => $truckTypeMaster,
                "truckDataMaster" => $truckDataMaster,
                "truckDriversMaster" => $truckDriversMaster,
            ];
        }
        $data = [
            'legs' => $legs,
            'carrierMaster' => $carrierMaster,
            'transportMaster' => $transportMaster,
            'allTrucksData' => $trucksData,
            'allDriversData' => $truckDrivers
        ];
        echo json_encode($data);
    }

    public function loadTripsLegsTableDataForView(): void
    {
        $tripsData = $carrierIds = $driverIds = $vehicleIds = $vehicleTypeIds = [];
        $templateRowId = $_POST['templateRowId'] ?? 0;
        if ($templateRowId > 0) {
            $getLegsFromTemplateId = $this->triptemplatemodel->getRouteTemplateLegsByWhereCondition($templateRowId);
            foreach ($getLegsFromTemplateId as $eachRowId) {
                if ($eachRowId['carrier_id'] > 0) {
                    $carrierIds[] = $eachRowId['carrier_id'];
                    $driverIds[] = $eachRowId['driver_id'];
                    $vehicleIds[] = $eachRowId['vehicle_id'];
                    $vehicleTypeIds[] = $eachRowId['vehicle_type'];
                }
                if (!empty($carrierIds)) {
                    $getCarriers = $this->triptemplatemodel->getCarriersById($carrierIds);
                    foreach ($getCarriers as $eachLine) {
                        $carrierMaster[$eachLine['id']] = $eachLine['name'];
                    }
                }
                $transport = gettransportmode();
                foreach ($transport as $eachLine) {
                    $transportMaster[$eachLine['code']] = $eachLine['name'];
                }
                if (!empty($driverIds)) {
                    $getDrivers = $this->triptemplatemodel->getDriversById($driverIds);
                    foreach ($getDrivers as $eachLine) {
                        $driverMaster[$eachLine['id']] = $eachLine['name'];
                    }
                }
                if (!empty($vehicleIds)) {
                    $getVehicles = $this->triptemplatemodel->getVehiclesById($vehicleIds);
                    foreach ($getVehicles as $eachLine) {
                        $vehicleMaster[$eachLine['id']] = $eachLine['register_number'];
                    }
                }
                if (!empty($vehicleTypeIds)) {
                    $getVehicleTypes = $this->triptemplatemodel->getVehicleTypesById($vehicleTypeIds);
                    foreach ($getVehicleTypes as $eachLine) {
                        $vehicleTypeMaster[$eachLine['id']] = $eachLine['trucktype'];
                    }
                }
                $tripsData[] = [
                    'legRowId' => $eachRowId['id'],
                    'legId' => $eachRowId['leg_id'],
                    'OriginRowId' => $eachRowId['origin_id'],
                    'originLocation' => $eachRowId['origin_location'],
                    'destinationRowId' => $eachRowId['destination_id'],
                    'destinationLocation' => $eachRowId['destination_location'],
                    'carrierId' => $carrierMaster[$eachRowId['carrier_id']] ?? "",
                    'transportMode' => $transportMaster[$eachRowId['transport_mode']] ?? "",
                    'vehicleType' => $vehicleTypeMaster[$eachRowId['vehicle_type']] ?? "",
                    'vehicleId' => $vehicleMaster[$eachRowId['vehicle_id']] ?? "",
                    'driverId' => $driverMaster[$eachRowId['driver_id']] ?? ""
                ];
            }
        }
        echo json_encode($tripsData);
    }

    public function getCarrierAllVehiclesData(): void
    {
        $data = ['truckTypes' => [], 'trucksData' => [], 'truckDrivers' => []];
        $carrierRowId = $_POST['carrierRowId'] ?? 0;
        if ($carrierRowId == 0) {
            echo json_encode($data);
        }
        $carrierData = $this->trips_model->getVehicleDataFromCarriers([$carrierRowId]);
        $data['truckTypes'] = $carrierData['truckTypes'] ?? [];
        $data['trucksData'] = $carrierData['trucksData'] ?? [];
        $data['truckDrivers'] = $carrierData['truckDrivers'] ?? [];
        echo json_encode($data);
    }

    public function storeShipmentByTemplate(): void
    {
        $postData = $this->input->post(null, true);
        $templateId = $postData['templateId'] ?? "";
        $fromSource = $postData['fromsource'] ?? "";
        $stringOrders = $postData['ordid'] ?? "";
        $tripType = $postData['trip_type'] ?? "multi";
        $response = $this->tripcreatefromorders->createTripByTripTemplate(['orderId' => $stringOrders, 'templateId' => $templateId, 'tripType' => $tripType, 'fromSource' => $fromSource]);
        $orderIds = $response['orderIds'];
        $orderShiftIds = $response['orderShiftIds'];
        $shiftId = $response['shiftId'];
        if (($fromSource === "orders") && !empty($orderIds)) {
            $this->tripcreatefromorders->assignOrdersForNewTrip($orderIds, $orderShiftIds, $tripType);
            $orderShiftIds = array_unique($orderShiftIds);
            foreach ($orderShiftIds as $eachId) {
                $url = base_url() . "trips/KNETtripsedit/" . $eachId;
                echo "<script>window.open('" . $url . "', '_blank');</script>";
            }
            $ordersurl = base_url() . "orders";
            if (checkAccessConditions('RELATED_2_SG_MY', $this->companyCode)) {
                $ordersurl = base_url() . "smtcorders";
            }
            echo "<script>window.location.replace('" . $ordersurl . "');</script>";
        }
        echo $shiftId;
    }

    public function getTripTemplates(): void
    {
        $getTripTemplates = $this->triptemplatemodel->getTripTemplatesByUser($this->companyCode);
        foreach ($getTripTemplates as $eachRow) {
            $data['templates'][] = ['id' => $eachRow['id'], 'templateId' => $eachRow['template_id'], 'templateName' => $eachRow['template_name']];
        }
        echo $this->load->view("tripstemplate/templatespopupview", $data, true);
    }

    public function updateTripWithTripsTemplate(): void
    {
        $currentDate = getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), $this->currentTimeZone);
        $templateId = $this->input->post('templateId', true);
        $shiftId = $this->input->post('shiftId', true);
        $shipmentId = $this->input->post('shipmentId', true);
        if (!in_array('0', [$shiftId, $templateId], true)) {
            $getTemplateDetails = $this->triptemplatemodel->getRouteTemplateById($templateId);
            $getTemplateLegsData = $this->triptemplatemodel->getRouteTemplateLegsByWhereCondition($templateId);
            $daysCount = count($getTemplateLegsData);
            $this->updateNormalTripAsCrossBorderTrip($getTemplateLegsData, $shiftId, $getTemplateDetails);
            $saveLegs = $this->tripcreatefromorders->saveTripLegsForShiftId(['mainShiftId' => $shiftId, 'customerId' => $getTemplateDetails['customer_id'], 'shiftCreateDate' => $currentDate['date'], 'shipmentId' => $shipmentId, 'legsCount' => $daysCount, 'carrierType' => $getTemplateDetails['carrier_type'], 'shipmentType' => $getTemplateDetails['shipment_type'], 'date' => $currentDate['date']], $getTemplateLegsData, $templateId);
        }
        echo $shiftId;
    }

    private function updateNormalTripAsCrossBorderTrip(array $legsData, int $shiftId, array $tripsData): void
    {
        for ($i = 0; $i < 6; $i++) {
            $legRowId = $legsData[$i]['id'] ?? 0;
            if ($legRowId > 0) {
                if ($i === 0) {
                    $shipmentOriginRowId = $legsData[0]['origin_id'];
                }
                $shipmentDestinationRowId = $legsData[$i]['destination_id'];
            }
        }
        $originData = $this->tripcreatefromorders->getPartyMasterDataById($shipmentOriginRowId);
        $destinationData = $this->tripcreatefromorders->getPartyMasterDataById($shipmentDestinationRowId);
        $this->triptemplatemodel->updateShiftTabledata(
            ['carrier_type' => $tripsData['carrier_type'], 'border_type' => $tripsData['shipment_type'], 'origin_id' => $originData['code'], 'destination_id' => $destinationData['code'], 'splace' => $originData['city'], 'eplace' => $destinationData['city'], 'scity' => $originData['city'], 'dcity' => $destinationData['city'], 'slat' => $originData['latitude'], 'slng' => $originData['longitude'], 'elat' => $destinationData['latitude'], 'elng' => $destinationData['longitude']],
            $shiftId
        );
    }

    public function getMasterDataForTripTemplate(): void
    {
        $post = $this->input->post(null, true);
        $code = $post['code'] ?? "";
        if ($code !== "") {
            $getCrossBorderCompanies = $this->common->gettblrowdata(['company_code' => $this->companyCode], "xborder_code", "tb_xborder_country", 0, 0);
            if (empty($getCrossBorderCompanies)) {
                $crossBorderCompanyCodes = [$this->companyCode];
            } else {
                $countriesString = $getCrossBorderCompanies['xborder_code'];
                if ($countriesString != "") {
                    $crossBorderCompanyCodes = explode(',', $countriesString);
                    $crossBorderCompanyCodes[] = $this->companyCode;
                } else {
                    $crossBorderCompanyCodes = [$this->companyCode];
                }
            }
            $partyDetails = $this->triptemplatemodel->getMasterDataForTripTemplateByCode(['code' => $code, 'companyCode' => $crossBorderCompanyCodes, 'partyType' => $post['partyType'] ?? "origin"]);
        }
        echo json_encode($partyDetails ?? []);
    }
}

?>
