<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Tripvehicledriverupdate extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(["Edi_logger", "Vehicledriverupdatehandler"]);
    }

    public function index()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        if (empty($postData)) {
            http_response_code(500);
            echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>500</ResponseCode>
                            <ResponseMessage>Empty Request</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
            return;

        }
        try {
            $postXMLData = json_decode(json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
            $response = $this->vehicledriverupdatehandler->updateVehicleDriverForTrip($postXMLData);
            http_response_code($response['status_code']);
            echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>" . $response['status'] . "</ResponseStatus>
                            <ResponseCode>" . $response['status_code'] . "</ResponseCode>
                            <ResponseMessage>" . $response['message'] . "</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";

            $this->edi_logger->setEdi_request($postData);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Receiving Stardard Status XML From Carrier  " . $ex->getMessage());
        } finally {
            $this->edi_logger->setEdi_type(1);
            $this->edi_logger->setTransaction_id(time());
            $this->edi_logger->setEdi_id("49");
            $this->edi_logger->setEdi_name('TRIP VEHICLE DRIVER DTO');
            $this->edi_logger->setBounded_type(1);
            $this->edi_logger->setEdi_format_type('XML');
            $this->edi_logger->setStatus(($response['status'] === 'Success' ? 1 : 0));
            $this->edi_logger->setEdi_response(json_encode($response));
            $this->edi_logger->setObj_type_name('TRIP VEHICLE DRIVER DTO');
            $this->edi_logger->saveToEdiLogs();
        }
    }
}
