<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Trip\Services\TripService;

class Uniqloactions extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_id')) {
            redirect('login');
        }
        $this->load->model('common');
        $this->load->helper('log_helper');
    }

    public function updateOrder(int $id, string $orderId = '')
    {
        if ($this->session->userdata['user_id'] !== '244') {
            log_error(
                UNIQLO_LOG_PREFIX . "updateOrder - Unauhtorized permission."
            );

            exit('Unauhtorized permission.');
        }

        $orders = $this->common->gettblrowdata(['id' => $id], "id", "tb_orders", 0, 0);

        if (count($orders) !== 1) {
            log_error(
                UNIQLO_LOG_PREFIX . "updateOrder - No order found with provided id:" . $id
            );

            exit('No order found with provided id: ' . $id);
        }

        $data = [
            'status' => 1,
            'trip_sts' => 0,
            'shift_id' => 0,
            'trip_id' => 0,
            'shipmentid' => ''
        ];

        $message = 'Trip status has been reset.';
        if (!empty($orderId)) {
            $data['order_id'] = $orderId;
            $message = 'Booking ID has been changed successfully.';
        }

        log_error(
            UNIQLO_LOG_PREFIX . "updateOrder updated data in a tb_orders: " . implode(', ', $data)
        );

        if (!$this->common->updatetbledata('tb_orders', $data, ['id' => $id])) {
            $message = 'Something went wrong. Contact one of the developers.';
        }

        log_error(UNIQLO_LOG_PREFIX . "updateOrder outbound data: " . $message);

        $this->session->set_flashdata('success_msg', "Trip Reverted Successfully!");
        redirect('orders/orderslist/'.$id);
    }

    /**
     * cancel the order which already assigned to carrier (delhivery,ecom,xpressbees)
     *
     *
     *
     * @param Interger Order ID
     * @return    String
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function cancelcarrierorder($id)
    {
        log_error(UNIQLO_LOG_PREFIX . "cancelcarrierorder inbound data: " . $id);

        $response = "Something went wrong, please try again.";
        if ($id != "") {
            /*check trip should not be in picked up*/
            $chktrack = $this->common->gettblrowdata(
                array('order_id' => $id, 'status_id' => 1),
                "id",
                "tb_stop_status",
                0,
                0
            );

            if (count($chktrack) == 0) {
                /* get the way bill */
                $chkawb = $this->common->gettblrowdata(
                    array('order_id' => $id, 'reference_id' => 'AWB'),
                    "id,ref_value",
                    "tb_order_references",
                    0,
                    0
                );

                if (count($chkawb) > 0) {
                    $data['awb'] = $chkawb['ref_value'];

                    /* get the vendor */
                    $chkvend = $this->common->gettblrowdata(
                        array('id' => $id, 'trip_sts' => 0, 'shift_id >' => 0),
                        "vendor_id,shift_id,trip_id,plat,plng",
                        "tb_orders",
                        0,
                        0
                    );

                    if (count($chkvend) > 0) {
                        $status = 0;

                        if ($chkvend['vendor_id'] == '310') {
                            $response1 = $this->canceldelhiveryorder($data);
                            $status = $response1['status'];
                            $response = $response1['msg'];
                        } elseif ($chkvend['vendor_id'] == '311') {
                            $response2 = $this->cancelecomorder($data);
                            $status = $response2['status'];
                            $response = $response2['msg'];
                        }

                        if ($status == 1) {
                            TripService::cancel($chkvend['shift_id'] ?? 0, $this->session->userdata('user_id'));
                        }
                    }
                } else {
                    $response = "AWB number not found for this order";
                }
            } else {
                $response = "Already pickup done, cancel will be done.";
            }

            $this->session->set_flashdata('success_msg', $response);

            log_error(
                UNIQLO_LOG_PREFIX .
                "cancelcarrierorder response message: " . $response . " and redirect into 'orders/orderslist/" . $id . "'"
            );

            redirect('orders/orderslist/' . $id);
        } else {
            log_error(
                UNIQLO_LOG_PREFIX . "cancelcarrierorder redirect into 'orders'"
            );

            redirect('orders');
        }
    }

    /*cancel the order from delhivery carrier*/
    /**
     * cancel status update to order from delhivery carrier
     *
     *
     *
     * @param Array AWB number
     * @return    Array
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      29-03-2021 11:00:00+05.30
     * @change    Asia
     */
    public function canceldelhiveryorder($data)
    {
        log_error(UNIQLO_LOG_PREFIX . "canceldelhiveryorder inbound data: " . implode(', ', $data));

        $response = array('status' => 0, "msg" => "");
        $reqdata1 = array("waybill" => $data['awb'], "cancellation" => "true");
        $reqdata = json_encode($reqdata1);
        $server_url = DELHIVERY_ORD_EDIT;
        $api_token = "Token " . DELHIVERY_AUTH_TOKEN;
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($server_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader(array(
                                'Authorization' => $api_token,
                                'Content-Type' => 'application/json'
                            ));
        $request->setBody($reqdata);
        try {
            $resp = $request->send();
            $curdt = date("Y-m-d H:i:s");
            if ($resp->getStatus() == 200) {
                $postresp1 = $resp->getBody();
                $xml = new SimpleXMLElement($postresp1);
                $output = array();
                if (!empty($xml)) {
                    $ecomsts = isset($xml->root->status) ? $xml->object->status : "";
                    if ($ecomsts == 'True') {
                        $response['status'] = 1;
                        $response['msg'] = isset($xml->root->remark) ? $xml->object->remark : "";
                    }
                }
            } else {
                $response['msg'] = $resp->getStatus() . '' . $resp->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $response['msg'] = $e->getMessage();
        }

        log_error(UNIQLO_LOG_PREFIX . "canceldelhiveryorder outbound data: " . implode(', ', $response));

        return $response;
    }

    /* cancel ecom express order */
    public function cancelecomorder($data)
    {
        log_error(UNIQLO_LOG_PREFIX . "cancelecomorder inbound data: " . implode(', ', $data));

        $response = ['status' => 0, 'msg' => ''];
        $server_url = ECOM_EXP_CANCEL_API;
        $username = ECOM_EXP_UNAME;
        $password = ECOM_EXP_PWD;
        $method = 'POST';
        $headers = ['Content-Type: application/x-www-form-urlencoded'];
        $request = 'username=' . $username . '&password=' . $password . '&awbs=' . $data['awb'];
        $proxy = defined('VZEN_PROXY') ? VZEN_PROXY : '';

        //$requestConfig = [];
        //if (ENVIRONMENT !== 'development') {
        //    $requestConfig['proxy'] = VZEN_PROXY;
        //}
       
        //$resp = thirdpartyservicecurl($server_url,$headers,$request,$requestConfig);

        $ecomResponse = curlRequestor(
            $server_url,
            $method,
            $request,
            $proxy,
            $headers,
            retryDecider(),
            retryDelay()
        );
        $resp = $ecomResponse['body'];

        log_error(
            UNIQLO_LOG_PREFIX . 'cancelecomorder API response payload: ' . implode(', ', $resp)
        );

        if ($ecomResponse['respCode'] === 200) {
            log_error(
                UNIQLO_LOG_PREFIX . 'EcomExpress cancel order API request for data '
                . $request . ' succeeded.'
            );
        } else {
            log_error(
                UNIQLO_LOG_PREFIX . 'EcomExpress cancel order API request for data '
                . $request . ' failed with: ' . $ecomResponse['curlError']
            );
        }

        if (!empty($resp)) {
            if (isset($resp['shipments'])) {
                $respc = isset($resp['shipments'][0]) ? $resp['shipments'][0] : array();
                if ($respc['Success']) {
                    $response['status'] = 1;
                    $response['msg'] = isset($respc['reason']) ? $respc['reason'] : "";
                    if ($response['msg'] == "") {
                        $response['msg'] = "Cancelled";
                    }
                } else {
                    $response['status'] = 0;
                    $response['msg'] = isset($respc['reason']) ? $respc['reason'] : "";
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "cancelecomorder outbound data: " . implode(', ', $response));

        return $response;
    }
}
