<?php


if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Uniqloautobackupcloseorders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    /*31 days ago order scans status moved to backup table then delete the moved data from main table(cron run in everyday night)*/
    public function index($daysAgo = 90)
    {
        if ($daysAgo < 90) {
            echo "Number of days must be > 90  uniqlo close orders";
            return;
        }
        $ordersDate = date('Y-m-d', strtotime('-' . $daysAgo . ' days'));
        $this->db->select('order_id');
        $this->db->from("tb_uniqlo_order_scans");
        $this->db->where('date(createdon) <', $ordersDate);
        $this->db->where_in('scan_val', ['RTO', 'DTO', 'Delivered', 'Closed']);
        $this->db->order_by("id", "asc");
        $uniqloOrders = $this->db->get();
        if ($uniqloOrders->num_rows() > 0) {
            $orderIds = array_column($uniqloOrders->result_array(), 'order_id');
            $this->db->trans_start();
            $this->db->select('order_id,scan_datetime,scan_type,scan_val,scan_status_time,scan_location,scan_instruction,scan_status_code,call_duration,scan_geo_lat,scan_geo_lng,status,createdon');
            $this->db->from('tb_uniqlo_order_scans');
            $this->db->where_in('order_id', $orderIds);
            $uniqloOrderScanData = $this->db->get()->result_array();
            $this->db->insert_batch('tb_uniqlo_order_scans_backup', $uniqloOrderScanData);
            $this->db->where_in('order_id', $orderIds);
            $this->db->delete("tb_uniqlo_order_scans");
            $this->db->trans_complete();
            if ($this->db->trans_status() === false) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
        }
    }
}
