<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Libraries\infrastructure\ScheduledJobLoggerService;

/**
 * @property CI_Loader $load
 * @property Orderallocationservice $orderallocationservice
 * @property Common $common
 * @property Singletriporder $singletriporder
 * @property Uniqloediservices $uniqloediservices
 */
class Uniqlocarrierallot extends CI_Controller
{
    /** @var ScheduledJobLoggerService */
    private $scheduledJobService;

    public function __construct()
    {
        parent::__construct();
        $this->load->library(['Orderallocationservice', 'singletriporder', 'uniqloediservices', 'carriercommonedilib']);
        $this->load->helper(['log_helper', 'string_helper']);

        $this->scheduledJobService = ScheduledJobLoggerService::instance(get_class($this));
    }

    public function index($frmdt = null, $todt = null)
    {
        $this->scheduledJobService->startJob();

        ini_set('max_execution_time', 3000);
        if ($frmdt != "" && $todt != "") {
            $frmdt1 = date('Y-m-d', strtotime($frmdt));
            $todt1 = date('Y-m-d', strtotime($todt));
            if ((strpos($frmdt1, "1970-01-01") === false) && (strpos($todt1, "1970-01-01") === false)) {
                $fromDate = date('Y-m-d H:i:s', strtotime($frmdt));
                $toDate = date('Y-m-d H:i:s', strtotime($todt));
            } else {
                $toDate = date('Y-m-d 23:59:59');
                $fromDate = date('Y-m-d H:i:s', strtotime('-30 minutes'));
            }
        } else {
            $toDate = date('Y-m-d 23:59:59');
            $fromDate = date('Y-m-d H:i:s', strtotime('-6 hours' ));
        }
        $responsemsg = "No Data Found";
        $orderResults = $ccorderResults = array();
        $batchtime = $fromDate . "#" . $toDate;
        $orderDataQue = $this->db->query(
            "SELECT o.id,o.order_id,o.pickup_pincode,o.delivery_pincode,o.delivery_city,o.pickup_city,o.pickup_address2,
                    o.delivery_address2,o.user_id,o.createdon,o.created_source,o.uniqid_of_package,o.shipmentid,
                    t.ordtype_code,if(o.created_source = 16,o.pickup_pincode,o.delivery_pincode) as dpincode
                FROM tb_orders o
                    INNER JOIN tb_order_details d ON o.id=d.order_row_id
                    LEFT JOIN tb_order_types t ON d.order_type=t.id
                WHERE o.company_code='INKN'
                  AND o.branch_code='INCL'
                  AND o.trip_sts =0
                  AND o.shift_id=0
                  AND o.status !=0
                  AND o.createdon BETWEEN '" . $fromDate . "' AND '" . $toDate . "'
                  GROUP BY o.id ORDER BY dpincode ASC"
        );
        $orderTotalCount = $existsOrders = array();
        if ($orderDataQue->num_rows() > 0) {
            $this->scheduledJobService->log(
                'Uniqlocarrierallot',
                sprintf('Found %d possible records to allocated', $orderDataQue->num_rows())
            );

            foreach ($orderDataQue->result_array() as $res) {
                $dest_state = $origin_state = "";
                $dest_cnt = explode(", ", $res['delivery_address2']);
                if (!empty($dest_cnt)) {
                    if (count($dest_cnt) > 0) {
                        $dest_state = isset($dest_cnt[count($dest_cnt) - 1]) ? $dest_cnt[count($dest_cnt) - 1] : "";
                    }
                }
                $orgin_cnt = explode(", ", $res['pickup_address2']);
                if (!empty($orgin_cnt)) {
                    if (count($orgin_cnt) > 0) {
                        $origin_state = isset($orgin_cnt[count($orgin_cnt) - 1]) ? $orgin_cnt[count(
                            $orgin_cnt
                        ) - 1] : "";
                    }
                }
                if ($res['created_source'] == '15') {
                    $origin_state = 'HARYANA';
                }
                if ($res['created_source'] == '16') {
                    $dest_state = 'HARYANA';
                }
                if ($origin_state == "") {
                    $origin_state = $res['pickup_city'];
                }
                if ($dest_state == "") {
                    $dest_state = $res['delivery_city'];
                }
                $res['pickup_state'] = $origin_state;
                $res['delivery_state'] = $dest_state;
                $res['batchtime'] = $batchtime;
                if ($res['ordtype_code'] == "CC") {
                    $ccorderResults[] = $res;
                } else {
                    $existsOrders[] = $res['id'];
                    $orderResults[] = $res;
                }
            }
            /*check exists orders from transaction table*/
            if (!empty($existsOrders)) {
                $checkAllocatedOrders = "SELECT order_id FROM tb_allocate_ratio_txn WHERE allocate_status = 1 AND order_id IN (" . implode(
                        ',',
                        $existsOrders
                    ) . ")";
                $allocatedOrderData = $this->db->query($checkAllocatedOrders)->result();
                if (count($allocatedOrderData) > 0) {
                    $existOrders = [];
                    foreach ($allocatedOrderData as $existOrder) {
                        $existOrders[] = $existOrder->order_id;
                    }
                    foreach ($orderResults as $key => $order) {
                        if (in_array($order['id'], $existOrders)) {
                            unset($orderResults[$key]);
                        }
                    }
                }
            }

            $this->scheduledJobService->log(
                'Uniqlocarrierallot',
                sprintf('Creating trips for %d records', count($orderResults))
            );

            $orderTotalCount = count($ccorderResults) + count($orderResults);
            if (!empty($ccorderResults)) {
                /*get kn carrier*/
                $currentDate = date("Y-m-d");
                $curdt = date('Y-m-d H:i:s');
                $vendor = array(
                    'name' => 'KN_CARR',
                    'mobile' => '9032033997',
                    'location' => 'GURGAON',
                    'address' => 'KUEHNE + NAGEL, JKS LOGISTICS PARK, WH2, GURGAON, INDIA, 122413',
                    'pincode' => '122413',
                    'country' => 'INDIA',
                    'password' => 'd41d8cd98f00b204e9800998ecf8427e',
                    'code' => '9032033997',
                    'offering_type' => '',
                    'carrier_grade' => 'FTL',
                    'effective_date' => $currentDate,
                    'expiry_date' => $currentDate,
                    'service_id' => '',
                    'service_name' => '',
                    'fcm_token' => null,
                    'user_id' => 244,
                    'custid' => null,
                    'partyid' => null,
                    'company_code' => 'INKN',
                    'branch_code' => 'INCL',
                    'status' => 1,
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                );
                $cccarrier = 0;
                $vendorinfo = $this->common->gettblrowdata(
                    array("mobile" => '9032033997', 'user_id' => 244),
                    "id",
                    "tb_vendors",
                    0,
                    0
                );
                if (!empty($vendorinfo)) {
                    $cccarrier = $vendorinfo['id'];
                } else {
                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "Uniqlocarrierallot inserted data in a tb_vendors: " . implode(', ', $vendor)
                    );

                    $cccarrier = $this->common->insertTableData("tb_vendors", $vendor);
                }
                foreach ($ccorderResults as $orderInfo) {
                    $orderTxnData = array(
                        "user_id" => $orderInfo['user_id'],
                        "order_id" => $orderInfo['id'],
                        "awb_num" => $orderInfo['order_id'],
                        "order_type" => $orderInfo['ordtype_code'],
                        "actual_carrier_id" => $cccarrier,
                        "allocated_carrier_id" => $cccarrier,
                        "batch_count" => count($ccorderResults),
                        "allocate_status" => 1,
                        "nsz" => "",
                        "batchtime" => $orderInfo['batchtime'],
                        "alloted_state" => 1,
                        "createdon" => $curdt,
                        "total_count" => $orderTotalCount,
                    );
                    $savetxn = $this->orderallocationservice->saveTransaction($orderTxnData);
                    $txnccorder = array(
                        'order_id' => $orderInfo['id'],
                        'user_id' => $orderInfo['user_id'],
                        'carrier_id' => $cccarrier
                    );
                    $ship_id = $this->singletriporder->ordercreatetrip($txnccorder);
                    $updwhr = array("order_row_id" => $orderInfo['id']);
                    $updset = array("delivery_note" => $orderInfo['order_id']);

                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "Uniqlocarrierallot updated data in a tb_order_details: " . implode(', ', $updset)
                    );

                    $upd = $this->common->updatetbledata("tb_order_details", $updset, $updwhr);
                    $whr = array(
                        "order_id" => $orderInfo['id'],
                        "reference_id" => "AWB",
                        "ref_value" => $orderInfo['order_id'],
                        "status" => 1
                    );
                    $chk = $this->common->gettblrowdata($whr, "id", "tb_order_references", 0, 0);
                    if (count($chk) == 0) {
                        $insarr = array(
                            "order_id" => $orderInfo['id'],
                            "reference_id" => "AWB",
                            "ref_value" => $orderInfo['order_id'],
                            "createdon" => $curdt,
                            "status" => 1
                        );

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "Uniqlocarrierallot inserted data in a tb_order_references: " . implode(', ', $insarr)
                        );

                        $ins = $this->common->insertTableData("tb_order_references", $insarr);
                    }
                    $sendtrip3 = $this->uniqloediservices->senddocketnumber($orderInfo['id']);
                }
            }
            if (!empty($orderResults)) {
                $allotcarrier = $this->orderallocationservice->allocateOrders(
                    $orderResults,
                    $orderTotalCount,
                    $batchtime
                );
                /*get all carrier orders to create trip and get awb number*/
                $times = explode("#", $batchtime);
                $startime = date("Y-m-d", strtotime($times[0]));
                $endtime = date("Y-m-d", strtotime($times[1]));
                $whrtxn = " batchtime='" . $batchtime . "' AND actual_carrier_id!=0 AND allocate_status=0 AND alloted_state IN(0,2) AND status=1";
                $select = "id,order_id,user_id,actual_carrier_id as carrier_id,order_type,pincode";
                $tbl = "tb_allocate_ratio_txn";
                $txnorders = $this->common->gettbldataorderby($whrtxn, $select, $tbl, "id", "ASC");
                if (count($txnorders) > 0) {
                    foreach ($txnorders as $txnorder) {
                        $order_type = 0;
                        $qccarrier = 0;
                        $ordtypemsg = "Forward Order";
                        if ($txnorder['order_type'] != 'SO') {
                            $order_type = 1;
                            $initialvid = $txnorder['carrier_id'];
                            $ordtypemsg = "Return Order";
                            /* check qc */
                            $qccarrier = $this->checkcarrierrevqc($txnorder['carrier_id'], $txnorder['pincode']);
                            if ($qccarrier == 0) {
                                $getreturnnxtcarr = $this->getNxtcarrier(
                                    $txnorder['carrier_id'],
                                    $order_type,
                                    $startime,
                                    $endtime,
                                    $txnorder['pincode']
                                );
                                if (!empty($getreturnnxtcarr)) {
                                    if ($getreturnnxtcarr['carrier_id'] != $initialvid) {
                                        $qccarrier = $txnorder['carrier_id'] = $getreturnnxtcarr['carrier_id'];
                                    }
                                }
                            }
                        }
                        if ($order_type == 1 && $qccarrier == 0) {
                            $nocfailmsg = 'NOC';
                            /*send notification mail*/
                            $orditemid = $txnorder['order_id'];
                            $ordrefwhr = array(
                                "order_id" => $txnorder['order_id'],
                                "reference_id" => "DQ",
                                "status" => 1
                            );
                            $orderitem = $this->common->gettblrowdata(
                                $ordrefwhr,
                                "ref_value",
                                "tb_order_references",
                                0,
                                0
                            );
                            if (!empty($orderitem)) {
                                $orditemid = $orderitem['ref_value'];
                            }
                            $set = array("allocated_carrier_id" => 0, "allocate_status" => 1, "nsz" => $nocfailmsg);
                            $whr = array("id" => $txnorder['id']);

                            log_error(
                                UNIQLO_LOG_PREFIX .
                                "Uniqlocarrierallot updated data in a tb_allocate_ratio_txn: " . implode(', ', $set)
                            );

                            $updateTxn = $this->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                            /*send NOC to warehouse*/
                            $sendwhs = $this->uniqloediservices->senddocketnumber($txnorder['order_id']);
                            $mailarr = array(
                                "failmsg" => $nocfailmsg,
                                "order_id" => $orditemid,
                                "ordtype" => $ordtypemsg
                            );
                            $sendmail = $this->sendemailfornoawb($mailarr);
                        } else {
                            $ship_id = $this->singletriporder->ordercreatetrip($txnorder);
                            if ($ship_id > 0) {
                                $failmsg = "";
                                $initialvid = $vendor_id = $txnorder['carrier_id'];
                                $sendtrip = $this->getawbnum($vendor_id, $ship_id);
                                if ($sendtrip['status'] == 0) {
                                    $noawbreason = $sendtrip['failmsg'];
                                    $failmsg .= $sendtrip['failmsg'];
                                    /*send notification mail*/
                                    $orditemid = $txnorder['order_id'];
                                    if ($order_type == 0) {
                                        $ordrefwhr = array(
                                            "order_id" => $txnorder['order_id'],
                                            "reference_id" => "PO",
                                            "status" => 1
                                        );
                                    } else {
                                        $ordrefwhr = array(
                                            "order_id" => $txnorder['order_id'],
                                            "reference_id" => "DQ",
                                            "status" => 1
                                        );
                                    }
                                    $orderitem = $this->common->gettblrowdata(
                                        $ordrefwhr,
                                        "ref_value",
                                        "tb_order_references",
                                        0,
                                        0
                                    );
                                    if (!empty($orderitem)) {
                                        $orditemid = $orderitem['ref_value'];
                                    }
                                    $mailarr = array(
                                        "failmsg" => $noawbreason,
                                        "order_id" => $orditemid,
                                        "ordtype" => $ordtypemsg
                                    );
                                    $sendmail = $this->sendemailfornoawb($mailarr);
                                    $getnxtcarr = $this->getNxtcarrier(
                                        $txnorder['carrier_id'],
                                        $order_type,
                                        $startime,
                                        $endtime,
                                        $txnorder['pincode']
                                    );
                                    if (!empty($getnxtcarr)) {
                                        if ($getnxtcarr['carrier_id'] != $initialvid) {
                                            $vendor_id = $txnorder['carrier_id'] = $getnxtcarr['carrier_id'];
                                            $sendtrip = $this->getawbnum($vendor_id, $ship_id);
                                            if ($sendtrip['status'] == 0) {
                                                $noawbreason = $sendtrip['failmsg'];
                                                $failmsg .= $sendtrip['failmsg'];
                                                /*send notification mail*/
                                                $mailarr = array(
                                                    "failmsg" => $noawbreason,
                                                    "order_id" => $orditemid,
                                                    "ordtype" => $ordtypemsg
                                                );
                                                $sendmail = $this->sendemailfornoawb($mailarr);
                                                $getnxtcarr = $this->getNxtcarrier(
                                                    $txnorder['carrier_id'],
                                                    $order_type,
                                                    $startime,
                                                    $endtime,
                                                    $txnorder['pincode']
                                                );
                                                if (!empty($getnxtcarr)) {
                                                    if ($getnxtcarr['carrier_id'] != $initialvid) {
                                                        $vendor_id = $txnorder['carrier_id'] = $getnxtcarr['carrier_id'];
                                                        $sendtrip = $this->getawbnum($vendor_id, $ship_id);
                                                        if ($sendtrip['status'] == 0) {
                                                            $noawbreason = $sendtrip['failmsg'];
                                                            $failmsg .= $sendtrip['failmsg'];
                                                            /*send notification mail*/
                                                            $mailarr = array(
                                                                "failmsg" => $noawbreason,
                                                                "order_id" => $orditemid,
                                                                "ordtype" => $ordtypemsg
                                                            );
                                                            $sendmail = $this->sendemailfornoawb($mailarr);

                                                            $nocData = [
                                                                "failMessage" => $failmsg,
                                                                "transactionId" => $txnorder['id'],
                                                                "order_id" => $txnorder['order_id']
                                                            ];
                                                            $this->sendNOCToWarehouse($nocData);
                                                        } else {
                                                            $set = array(
                                                                "allocated_carrier_id" => $txnorder['carrier_id'],
                                                                "allocate_status" => 1,
                                                                "awb_num" => $sendtrip['data'],
                                                                "nsz" => $failmsg
                                                            );
                                                            $whr = array("id" => $txnorder['id']);

                                                            log_error(
                                                                UNIQLO_LOG_PREFIX .
                                                                "Uniqlocarrierallot updated data in a tb_allocate_ratio_txn: " . implode(
                                                                    ', ',
                                                                    $set
                                                                )
                                                            );

                                                            $updateTxn = $this->common->updatetbledata(
                                                                "tb_allocate_ratio_txn",
                                                                $set,
                                                                $whr
                                                            );
                                                            $updatevendorid = $this->updatecarr(
                                                                $txnorder['order_id'],
                                                                $txnorder['carrier_id'],
                                                                $ship_id
                                                            );
                                                        }
                                                    } else {
                                                        /*send NOC to warehouse*/
                                                        $nocData = [
                                                            "failMessage" => $failmsg,
                                                            "transactionId" => $txnorder['id'],
                                                            "order_id" => $txnorder['order_id']
                                                        ];
                                                        $this->sendNOCToWarehouse($nocData);
                                                    }
                                                } else {
                                                    /*send NOC to warehouse*/
                                                    $nocData = [
                                                        "failMessage" => $failmsg,
                                                        "transactionId" => $txnorder['id'],
                                                        "order_id" => $txnorder['order_id']
                                                    ];
                                                    $this->sendNOCToWarehouse($nocData);
                                                }
                                            } else {
                                                $set = array(
                                                    "allocated_carrier_id" => $txnorder['carrier_id'],
                                                    "allocate_status" => 1,
                                                    "awb_num" => $sendtrip['data'],
                                                    "nsz" => $failmsg
                                                );
                                                $whr = array("id" => $txnorder['id']);

                                                log_error(
                                                    UNIQLO_LOG_PREFIX .
                                                    "Uniqlocarrierallot updated data in a tb_allocate_ratio_txn: " . implode(
                                                        ', ',
                                                        $set
                                                    )
                                                );

                                                $updateTxn = $this->common->updatetbledata(
                                                    "tb_allocate_ratio_txn",
                                                    $set,
                                                    $whr
                                                );
                                                $updatevendorid = $this->updatecarr(
                                                    $txnorder['order_id'],
                                                    $txnorder['carrier_id'],
                                                    $ship_id
                                                );
                                            }
                                        } else {
                                            /*send NOC to warehouse*/
                                            $nocData = [
                                                "failMessage" => $failmsg,
                                                "transactionId" => $txnorder['id'],
                                                "order_id" => $txnorder['order_id']
                                            ];
                                            $this->sendNOCToWarehouse($nocData);
                                        }
                                    } else {
                                        /*send NOC to warehouse*/
                                        $nocData = [
                                            "failMessage" => $failmsg,
                                            "transactionId" => $txnorder['id'],
                                            "order_id" => $txnorder['order_id']
                                        ];
                                        $this->sendNOCToWarehouse($nocData);
                                    }
                                }
                                else {
                                    $set = array(
                                        "allocated_carrier_id" => $txnorder['carrier_id'],
                                        "allocate_status" => 1,
                                        "awb_num" => $sendtrip['data']
                                    );
                                    $whr = array("id" => $txnorder['id']);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "Uniqlocarrierallot updated data in a tb_allocate_ratio_txn: " . implode(
                                            ', ',
                                            $set
                                        )
                                    );

                                    $updateTxn = $this->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                                    $updatevendorid = $this->updatecarr($txnorder['order_id'], $vendor_id, $ship_id);
                                }
                            }
                        }
                    }
                    $responsemsg = "Orders assigned to carrier and updated docket number";
                } else {
                    $responsemsg = "Orders allocated in preferred level,No orders or carriers to process from allocation ratio logic";
                }
            } else {
                $responsemsg = "There is no SO and RETURN orders";
            }
            /* end get all carrier orders to create trip and get awb number*/
        } else {
            $responsemsg = "No Orders Found In This Slot " . $batchtime;
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlocarrierallot outbound data: " . $responsemsg);

        $this->scheduledJobService->log(
            'Uniqlocarrierallot',
            sprintf('Allocation finished with message: %s', $responsemsg)
        );

        $this->scheduledJobService->finishJob(true);

        echo $responsemsg;
    }

    private function sendNOCToWarehouse($nocData)
    {
        $setNocData = [
            "allocated_carrier_id" => 0,
            "allocate_status" => 1,
            "nsz" => $nocData['failMessage']
        ];
        $whereData = [
            "id" => $nocData['transactionId']
        ];
        $this->common->updatetbledata("tb_allocate_ratio_txn", $setNocData, $whereData);
        $orderWhere = [
            "id" => $nocData['order_id']
        ];
        $orderSetData = [
            "status" => 1,
            "shift_id" => 0
        ];

        $this->common->updatetbledata("tb_orders", $orderSetData, $orderWhere);
        $this->uniqloediservices->senddocketnumber($nocData['order_id']);
    }

    /*check carrier pincode reverse qc*/
    public function checkcarrierrevqc($carrierid, $pincode)
    {
        $resp = 0;
        $whrcond = array('destination_pin' => $pincode, 'carrier_id' => $carrierid, 'reverse_qc' => 1, 'status' => 1);
        $chkrevqc = $this->common->gettblrowdata($whrcond, "id,carrier_id", "tb_customer_pincodes", 0, 0);
        if (count($chkrevqc) > 0) {
            $resp = $carrierid;
        }

        log_error(UNIQLO_LOG_PREFIX . "checkcarrierrevqc outbound data: " . $resp);

        return $resp;
    }

    public function getawbnum($vendor_id, $ship_id)
    {
        $failmsg = '';
        if (checkAccessConditions('CHECK_BLOWHORN_CARRIER', $vendor_id)) {
            $vendor_id = "1290";
        }
        switch ($vendor_id) {
            case "310":
                $sendtrip = $this->uniqloediservices->getdelverywaybillnumber($ship_id);
                $failmsg = $sendtrip['status'] == 0 ? "Delhivery: " . $sendtrip['data'] . ", " : "";
                break;
            case "311":
                $sendtrip = $this->uniqloediservices->forwardmanifestation($ship_id);
                $failmsg = $sendtrip['status'] == 0 ? "EcomExpress: " . $sendtrip['data'] . ", " : "";
                break;
            case "312":
                $sendtrip = $this->uniqloediservices->xbordercreatemanifestation($ship_id);
                $failmsg = $sendtrip['status'] == 0 ? "ExpressBees: " . $sendtrip['data'] . ", " : "";
                break;
            case "1290":
                try {
                    $sendtrip = [];
                    $sendtrip2 = $this->carriercommonedilib->shipmentdata($ship_id);
                    if ($sendtrip2 == 0) {
                        $sendtrip['status'] = 0;
                        $sendtrip['data'] = "";
                        $failmsg = "Blow Horn: " . $ship_id;
                    } else {
                        $orderReferemceValue = $this->common->getjointbldata("tb_orders o", "`tb_order_references` tor", "o.id=tor.order_id", ["o.shift_id" => $ship_id, "tor.`reference_id`" => "AWB"], "tor.ref_value", 0, 0);
                        $sendtrip['status'] = 1;
                        $sendtrip['data'] = $orderReferemceValue["ref_value"] ?? "";
                        $failmsg = "";
                    }
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Blow Horn Trip Notification XML to Altova " . $ex->getMessage());
                }

                break;
            default:
                log_error(UNIQLO_LOG_PREFIX . "getawbnum outbound data: " . implode(', ', $vendor_id));
        }
        $sendtrip['failmsg'] = $failmsg;

        log_error(UNIQLO_LOG_PREFIX . "getawbnum outbound data: " . implode(', ', $sendtrip));

        return $sendtrip;
    }

    public function sendemailfornoawb($mailinfo)
    {
        log_error(UNIQLO_LOG_PREFIX . "sendemailfornoawb inbound data: " . implode(', ', $mailinfo));

        $orditem = $mailinfo['order_id'];
        $ordtypemsg = $mailinfo['ordtype'];
        $failmsg = $mailinfo['failmsg'];
        $sub1 = "eTN: " . $orditem . " " . $ordtypemsg . " Assigning Failed";
        $this->load->library('email');
        $this->email->from(SVKONEKT_EMAIL, 'svkonekt');
        $this->email->to(UNIQLO_ORDER_MAILS);
        $this->email->cc(strip_quotes(UNIQLO_ORDER_CC_MAILS));
        $this->email->subject($sub1);
        $this->email->set_mailtype("html");
        $body = "Dear Team, <br/>";
        $body .= $sub1 . " <br/>";
        $body .= "Details. <br/><br/>";
        $body .= $failmsg . "<br/><br/>";
        $body .= "Thank You <br/>";
        $body .= "Svkonekt <br/>";
        $this->email->message($body);
        $this->email->send();

        return true;
    }

    public function updatecarr($order_id, $carid, $shift_id)
    {
        $ordwhr = array("id" => $order_id);
        $ordset = array("vendor_id" => $carid);

        log_error(
            UNIQLO_LOG_PREFIX .
            sprintf('Updating vendor_id %d for order_id %d in a tb_orders', $carid, $order_id)
        );

        $this->scheduledJobService->log(
            'Uniqlocarrierallot',
            sprintf('Updating vendor_id %d for order_id %d in a tb_orders', $carid, $order_id)
        );

        $updateOrder = $this->common->updatetbledata("tb_orders", $ordset, $ordwhr);

        $shiftwhr = array("id" => $shift_id);
        $shiftset = array("vendor_id" => $carid);

        log_error(
            UNIQLO_LOG_PREFIX .
            sprintf('Updating vendor_id %d for shift_id %d in a tb_shifts', $carid, $shift_id)
        );

        $this->scheduledJobService->log(
            'Uniqlocarrierallot',
            sprintf('Updating vendor_id %d for shift_id %d in a tb_shifts', $carid, $shift_id)
        );

        $updateShifts = $this->common->updatetbledata("tb_shifts", $shiftset, $shiftwhr);

        $empwhr = array("shift_id" => $shift_id);
        $empset = array("vendor_id" => $carid);

        log_error(
            UNIQLO_LOG_PREFIX .
            sprintf('Updating vendor_id %d for shift_id %d in a tb_employee', $carid, $shift_id)
        );

        $this->scheduledJobService->log(
            'Uniqlocarrierallot',
            sprintf('Updating vendor_id %d for shift_id %d in a tb_employee', $carid, $shift_id)
        );

        $updateEmp = $this->common->updatetbledata("tb_employee", $empset, $empwhr);

        $vehwhr = array("shft_id" => $shift_id);
        $vehset = array("carrier_id" => $carid);

        log_error(
            UNIQLO_LOG_PREFIX .
            sprintf('Updating vendor_id %d for shift_id %d in a tb_shft_veh', $carid, $shift_id)
        );

        $this->scheduledJobService->log(
            'Uniqlocarrierallot',
            sprintf('Updating vendor_id %d for shift_id %d in a tb_shft_veh', $carid, $shift_id)
        );

        $updateVeh = $this->common->updatetbledata("tb_shft_veh", $vehset, $vehwhr);
        return true;
    }

    public function getNxtcarrier($carid, $type, $stime, $etime, $pincode)
    {
        $getnxtcarr = array();
        $whr = array(
            'carrier_id' => $carid,
            "order_type" => $type,
            "startdate <=" => $stime,
            "enddate>=" => $etime,
            "status" => 1
        );
        $getcurrcarr = $this->common->gettblrowdata($whr, "carrier_id,sequence_no", "tb_allocate_ratio_batch", 0, 0);
        if (!empty($getcurrcarr)) {
            $sequence_no = $getcurrcarr['sequence_no'] + 1;
            $whr2 = array(
                "order_type" => $type,
                "sequence_no" => $sequence_no,
                "startdate <=" => $stime,
                "enddate>=" => $etime,
                "status" => 1
            );
            $getnxtcarr = $this->common->gettblrowdata(
                $whr2,
                "carrier_id,sequence_no",
                "tb_allocate_ratio_batch",
                0,
                0
            );
            if (!empty($getnxtcarr)) {
                if ($type == 1) {
                    $chkqccarrier = $this->checkcarrierrevqc($getnxtcarr['carrier_id'], $pincode);
                    if ($chkqccarrier == 0) {
                        $nextcarrierseq = $sequence_no + 1;
                        $getnxtcarr = $this->getNxtQcCarrier(
                            $getnxtcarr['carrier_id'],
                            $type,
                            $stime,
                            $etime,
                            $nextcarrierseq,
                            $pincode
                        );
                        if (!empty($getnxtcarr)) {
                            log_error(UNIQLO_LOG_PREFIX . "getNxtcarrier outbound data: " . implode(', ', $getnxtcarr));

                            return $getnxtcarr;
                        }
                    }
                }

                log_error(UNIQLO_LOG_PREFIX . "getNxtcarrier outbound data: " . implode(', ', $getnxtcarr));

                return $getnxtcarr;
            } else {
                $whr3 = array(
                    "order_type" => $type,
                    "sequence_no" => 1,
                    "startdate <=" => $stime,
                    "enddate>=" => $etime,
                    "status" => 1
                );
                $getnxtcarr = $this->common->gettblrowdata(
                    $whr3,
                    "carrier_id,sequence_no",
                    "tb_allocate_ratio_batch",
                    0,
                    0
                );
                if (!empty($getnxtcarr)) {
                    if ($type == 1) {
                        $chkqccarrier = $this->checkcarrierrevqc($getnxtcarr['carrier_id'], $pincode);
                        if ($chkqccarrier == 0) {
                            $getnxtcarr = array();
                        }
                    }
                }

                log_error(UNIQLO_LOG_PREFIX . "getNxtcarrier outbound data: " . implode(', ', $getnxtcarr));

                return $getnxtcarr;
            }
        } else {
            log_error(UNIQLO_LOG_PREFIX . "getNxtcarrier outbound data: " . implode(', ', $getnxtcarr));

            return $getnxtcarr;
        }
    }

    public function getNxtQcCarrier($carid, $type, $stime, $etime, $sequence_no, $pincode)
    {
        $getnxtcarr = array();
        $whr2 = array(
            "order_type" => $type,
            "sequence_no" => $sequence_no,
            "startdate <=" => $stime,
            "enddate>=" => $etime,
            "status" => 1
        );
        $getnxtcarr = $this->common->gettblrowdata($whr2, "carrier_id,sequence_no", "tb_allocate_ratio_batch", 0, 0);
        if (!empty($getnxtcarr)) {
            $chkqccarrier = $this->checkcarrierrevqc($getnxtcarr['carrier_id'], $pincode);
            if ($chkqccarrier == 0) {
                $seqno = $sequence_no + 1;
                $getnxtcarr = $this->getNxtQcCarrier($carid, $type, $stime, $etime, $seqno, $pincode);
                if (!empty($getnxtcarr)) {
                    return $getnxtcarr;
                }
            }
            return $getnxtcarr;
        } else {
            $whr3 = array(
                "order_type" => $type,
                "sequence_no" => 1,
                "startdate <=" => $stime,
                "enddate>=" => $etime,
                "status" => 1
            );
            $getnxtcarr = $this->common->gettblrowdata(
                $whr3,
                "carrier_id,sequence_no",
                "tb_allocate_ratio_batch",
                0,
                0
            );
            if (!empty($getnxtcarr)) {
                $chkqccarrier = $this->checkcarrierrevqc($getnxtcarr['carrier_id'], $pincode);
                if ($chkqccarrier == 0) {
                    $getnxtcarr = array();
                }
            }

            log_error(UNIQLO_LOG_PREFIX . "getNxtQcCarrier outbound data: " . implode(', ', $getnxtcarr));

            return $getnxtcarr;
        }
    }

    /*if any failures with no awb/execution timeout run for every 5 min */
    public function getpendingtxnorders()
    {
        $whrtxn = " allocate_status=0 AND actual_carrier_id!=0 AND alloted_state IN(0,2) AND status=1";
        $select = "id,order_id,user_id,actual_carrier_id as carrier_id,order_type,batchtime,pincode";
        $tbl = "tb_allocate_ratio_txn";
        $txnorders = $this->common->gettbldataorderby($whrtxn, $select, $tbl, "id", "ASC");
        if (count($txnorders) > 0) {
            foreach ($txnorders as $txnorder) {
                $batchtime1 = explode("#", $txnorder['batchtime']);
                if (!empty($batchtime1)) {
                    $startime = date("Y-m-d", strtotime($batchtime1[0]));
                    $endtime = date("Y-m-d", strtotime($batchtime1[1]));
                    $order_type = 0;
                    $qccarrier = 0;
                    $ordtypemsg = "Forward Order";
                    if ($txnorder['order_type'] != 'SO') {
                        $order_type = 1;
                        $ordtypemsg = "Return Order";
                        /* check qc */
                        $qccarrier = $this->checkcarrierrevqc($txnorder['carrier_id'], $txnorder['pincode']);
                    }
                    if ($order_type == 1 && $qccarrier == 0) {
                        $nocfailmsg = 'NOC';
                        /*send notification mail*/
                        $orditemid = $txnorder['order_id'];
                        $ordrefwhr = array("order_id" => $txnorder['order_id'], "reference_id" => "DQ", "status" => 1);
                        $orderitem = $this->common->gettblrowdata($ordrefwhr, "ref_value", "tb_order_references", 0, 0);
                        if (!empty($orderitem)) {
                            $orditemid = $orderitem['ref_value'];
                        }
                        $set = array("allocated_carrier_id" => 0, "allocate_status" => 1, "nsz" => $nocfailmsg);
                        $whr = array("id" => $txnorder['id']);

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "getpendingtxnorders updated data in a tb_allocate_ratio_txn: " . implode(', ', $set)
                        );

                        $updateTxn = $this->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                        /*send NOC to warehouse*/
                        $sendwhs = $this->uniqloediservices->senddocketnumber($txnorder['order_id']);
                        $mailarr = array("failmsg" => $nocfailmsg, "order_id" => $orditemid, "ordtype" => $ordtypemsg);
                        $sendmail = $this->sendemailfornoawb($mailarr);
                    } else {
                        $ship_id = $this->singletriporder->ordercreatetrip($txnorder);
                        if ($ship_id > 0) {
                            $failmsg = "";
                            $initialvid = $vendor_id = $txnorder['carrier_id'];
                            $sendtrip = $this->getawbnum($vendor_id, $ship_id);
                            if ($sendtrip['status'] == 0) {
                                $noawbreason = $sendtrip['failmsg'];
                                $failmsg .= $sendtrip['failmsg'];
                                /*send notification mail*/
                                $orditemid = $txnorder['order_id'];
                                if ($order_type == 0) {
                                    $ordrefwhr = array(
                                        "order_id" => $txnorder['order_id'],
                                        "reference_id" => "PO",
                                        "status" => 1
                                    );
                                } else {
                                    $ordrefwhr = array(
                                        "order_id" => $txnorder['order_id'],
                                        "reference_id" => "DQ",
                                        "status" => 1
                                    );
                                }
                                $orderitem = $this->common->gettblrowdata(
                                    $ordrefwhr,
                                    "ref_value",
                                    "tb_order_references",
                                    0,
                                    0
                                );
                                if (!empty($orderitem)) {
                                    $orditemid = $orderitem['ref_value'];
                                }
                                $mailarr = array(
                                    "failmsg" => $noawbreason,
                                    "order_id" => $orditemid,
                                    "ordtype" => $ordtypemsg
                                );
                                $sendmail = $this->sendemailfornoawb($mailarr);
                                $getnxtcarr = $this->getNxtcarrier(
                                    $txnorder['carrier_id'],
                                    $order_type,
                                    $startime,
                                    $endtime,
                                    $txnorder['pincode']
                                );
                                if (!empty($getnxtcarr)) {
                                    if ($getnxtcarr['carrier_id'] != $initialvid) {
                                        $vendor_id = $txnorder['carrier_id'] = $getnxtcarr['carrier_id'];
                                        $sendtrip = $this->getawbnum($vendor_id, $ship_id);
                                        if ($sendtrip['status'] == 0) {
                                            $noawbreason = $sendtrip['failmsg'];
                                            $failmsg .= $sendtrip['failmsg'];
                                            /*send notification mail*/
                                            $mailarr = array(
                                                "failmsg" => $noawbreason,
                                                "order_id" => $orditemid,
                                                "ordtype" => $ordtypemsg
                                            );
                                            $sendmail = $this->sendemailfornoawb($mailarr);
                                            $getnxtcarr = $this->getNxtcarrier(
                                                $txnorder['carrier_id'],
                                                $order_type,
                                                $startime,
                                                $endtime,
                                                $txnorder['pincode']
                                            );
                                            if (!empty($getnxtcarr)) {
                                                if ($getnxtcarr['carrier_id'] != $initialvid) {
                                                    $vendor_id = $txnorder['carrier_id'] = $getnxtcarr['carrier_id'];
                                                    $sendtrip = $this->getawbnum($vendor_id, $ship_id);
                                                    if ($sendtrip['status'] == 0) {
                                                        $noawbreason = $sendtrip['failmsg'];
                                                        $failmsg .= $sendtrip['failmsg'];
                                                        /*send notification mail*/
                                                        $mailarr = array(
                                                            "failmsg" => $noawbreason,
                                                            "order_id" => $orditemid,
                                                            "ordtype" => $ordtypemsg
                                                        );
                                                        $sendmail = $this->sendemailfornoawb($mailarr);
                                                        $set = array(
                                                            "allocated_carrier_id" => 0,
                                                            "allocate_status" => 1,
                                                            "nsz" => $failmsg
                                                        );
                                                        $whr = array("id" => $txnorder['id']);

                                                        log_error(
                                                            UNIQLO_LOG_PREFIX .
                                                            "getpendingtxnorders updated data in a tb_allocate_ratio_txn: " . implode(
                                                                ', ',
                                                                $set
                                                            )
                                                        );

                                                        $updateTxn = $this->common->updatetbledata(
                                                            "tb_allocate_ratio_txn",
                                                            $set,
                                                            $whr
                                                        );
                                                        /*send NOC to warehouse*/
                                                        $ordwhr = array("id" => $txnorder['order_id']);
                                                        $ordset = array(
                                                            "vendor_id" => 0,
                                                            "status" => 1,
                                                            "shift_id" => 0
                                                        );

                                                        log_error(
                                                            UNIQLO_LOG_PREFIX .
                                                            "getpendingtxnorders updated data in a tb_orders: " . implode(
                                                                ', ',
                                                                $ordset
                                                            )
                                                        );

                                                        $updateOrder = $this->common->updatetbledata(
                                                            "tb_orders",
                                                            $ordset,
                                                            $ordwhr
                                                        );
                                                        $sendwhs = $this->uniqloediservices->senddocketnumber(
                                                            $txnorder['order_id']
                                                        );
                                                    } else {
                                                        $set = array(
                                                            "allocated_carrier_id" => $txnorder['carrier_id'],
                                                            "allocate_status" => 1,
                                                            "awb_num" => $sendtrip['data'],
                                                            "nsz" => $failmsg
                                                        );
                                                        $whr = array("id" => $txnorder['id']);

                                                        log_error(
                                                            UNIQLO_LOG_PREFIX .
                                                            "getpendingtxnorders updated data in a tb_allocate_ratio_txn: " . implode(
                                                                ', ',
                                                                $set
                                                            )
                                                        );

                                                        $updateTxn = $this->common->updatetbledata(
                                                            "tb_allocate_ratio_txn",
                                                            $set,
                                                            $whr
                                                        );
                                                        $updatevendorid = $this->updatecarr(
                                                            $txnorder['order_id'],
                                                            $txnorder['carrier_id'],
                                                            $ship_id
                                                        );
                                                    }
                                                }
                                            } else {
                                                /*send NOC to warehouse*/
                                                $ordwhr = array("id" => $txnorder['order_id']);
                                                $ordset = array("vendor_id" => 0);

                                                log_error(
                                                    UNIQLO_LOG_PREFIX .
                                                    "getpendingtxnorders updated data in a tb_orders: " . implode(
                                                        ', ',
                                                        $ordset
                                                    )
                                                );

                                                $updateOrder = $this->common->updatetbledata(
                                                    "tb_orders",
                                                    $ordset,
                                                    $ordwhr
                                                );
                                                $sendwhs = $this->uniqloediservices->senddocketnumber(
                                                    $txnorder['order_id']
                                                );
                                            }
                                        } else {
                                            $set = array(
                                                "allocated_carrier_id" => $txnorder['carrier_id'],
                                                "allocate_status" => 1,
                                                "awb_num" => $sendtrip['data'],
                                                "nsz" => $failmsg
                                            );
                                            $whr = array("id" => $txnorder['id']);

                                            log_error(
                                                UNIQLO_LOG_PREFIX .
                                                "getpendingtxnorders updated data in a tb_allocate_ratio_txn: " . implode(
                                                    ', ',
                                                    $set
                                                )
                                            );

                                            $updateTxn = $this->common->updatetbledata(
                                                "tb_allocate_ratio_txn",
                                                $set,
                                                $whr
                                            );
                                            $updatevendorid = $this->updatecarr(
                                                $txnorder['order_id'],
                                                $txnorder['carrier_id'],
                                                $ship_id
                                            );
                                        }
                                    }
                                } else {
                                    /*send NOC to warehouse*/
                                    $ordwhr = array("id" => $txnorder['order_id']);
                                    $ordset = array("vendor_id" => 0);

                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "getpendingtxnorders updated data in a tb_orders: " . implode(', ', $ordset)
                                    );

                                    $updateOrder = $this->common->updatetbledata("tb_orders", $ordset, $ordwhr);
                                    $sendwhs = $this->uniqloediservices->senddocketnumber($txnorder['order_id']);
                                }
                            } else {
                                $set = array(
                                    "allocated_carrier_id" => $txnorder['carrier_id'],
                                    "allocate_status" => 1,
                                    "awb_num" => $sendtrip['data']
                                );
                                $whr = array("id" => $txnorder['id']);

                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "getpendingtxnorders updated data in a tb_allocate_ratio_txn: " . implode(
                                        ', ',
                                        $set
                                    )
                                );

                                $updateTxn = $this->common->updatetbledata("tb_allocate_ratio_txn", $set, $whr);
                                $updatevendorid = $this->updatecarr($txnorder['order_id'], $vendor_id, $ship_id);
                            }
                        }
                    }
                }
            }
        } else {
            echo "No orders to process,no carrier_id";
        }
    }
}
