<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Users extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if($this->session->userdata('user_id') == ''){
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model('common');
        if (!checkUrlAccessForUser('USERS')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('user_title');;
        $data['sub_title'] = $this->lang->line('user_title');;
        $users = $customers = $customerslist = [];
        $userSelect = "id,name,emailid,mobile_no,company_code,branch_code,address,status,'1' as roleno,'KN Admin' as role";
        $userWhere = ['status' => 'Active'];
        $customerSelect = "id,name,code as cid,email_id as emailid,phone as mobile_no,company_code,branch_code,parent_id,address,street,location,state,country,pincode,status";
        $customerWhere = ['status' => 1];
        $post = $this->input->post(null, true);
        $adv_role = $post['adv_role'] ?? '';
        $role = $post['role'] ?? '';
        $company_code = $post['company_code'] ?? '';
        $branch_code = $post['branch_code'] ?? '';
        $name = $post['name'] ?? '';
        $mobile = $post['mobile'] ?? '';
        $email = $post['email'] ?? '';
        $code = $post['code'] ?? '';
        if ($adv_role != "" && $role == "") {
            $role = $adv_role;
        }
        if ($adv_role != "") {
            $data['role'] = $adv_role;
        }
        if ($role != "") {
            $data['role'] = $role;
        }
        if ($company_code != "") {
            $data['company_code'] = $company_code;
            $userWhere['company_code'] = $data['company_code'];
            $customerWhere['company_code'] = $data['company_code'];
        }
        if ($branch_code != "") {
            $data['branch_code'] = $branch_code;
            $userWhere['branch_code'] = $data['branch_code'];
            $customerWhere['branch_code'] = $data['branch_code'];
        }
        if ($role == 0 || $role == 1) {
            if ($name != "") {
                $userWhere['name'] = $name;
            }
            if ($mobile != "") {
                $userWhere['mobile_no'] = $mobile;
            }
            if ($email != "") {
                $userWhere['emailid'] = $email;
            }
            $users = $this->common->gettbldata($userWhere, $userSelect, 'tb_users', 0, 0);
        }
        if ($role == 0 || $role == 2 || $role == 3) {
            if ($role == 2) {
                $customerWhere['parent_id'] = 0;
            }
            if ($role == 3) {
                $customerWhere['parent_id !='] = 0;
            }
            if ($name != "") {
                $customerWhere['name'] = $name;
            }
            if ($mobile != "") {
                $customerWhere['phone'] = $mobile;
            }
            if ($code != "") {
                $customerWhere['code'] = $code;
            }
            if ($email != "") {
                $customerWhere['email_id'] = $email;
            }
            $customers = $this->common->gettbldata($customerWhere, $customerSelect, 'tb_customers', 100, 0);
        }
        foreach ($customers as $customer) {
            if ($customer['parent_id'] == 0) {
                $customer['roleno'] = 2;
                $customer['role'] = 'Customer';
            } else {
                $customer['roleno'] = 3;
                $customer['role'] = 'SubCustomer';
                $pcustomer = $this->common->gettblrowdata(['id' => $customer['parent_id']], 'code', 'tb_customers', 0, 0);
                $customer['parent_cid'] = $pcustomer['code'] ?? null;
            }
            $customer['address'] = $customer['address'] . ',' . $customer['street'] . ',' . $customer['location'] . ',' . $customer['state'] . ',' . $customer['country'] . ',' . $customer['pincode'];
            $customerslist[] = $customer;
        }
        $data['users'] = array_merge($users, $customerslist);
        $this->newtemplate->dashboard("users/index", $data);
    }

    public function valPassword($str){
        if(empty($str)){
            $this->form_validation->set_message('valPassword','Confirm Password Required');
            return FALSE;
        } else {
            if($this->input->post('password') == $str){
                return TRUE;
            } else {
                $this->form_validation->set_message('valPassword',"Confirm Password not match with password");
                return FALSE;
            }
        }
    }

    public function checkMobile($mobile){
        if(empty($mobile)){
            $this->form_validation->set_message('checkMobile','Username No Required');
            return FALSE;
        } else {
            if($this->input->post('role') == 1){
                $table = 'tb_users';
                $col = "mobile_no";
                $where = array('mobile_no'=>$mobile,'status'=>'Active');
            } else {
                $col = 'phone';
                $table = 'tb_customers';
                $where = array('phone'=>$mobile,'status'=>1);
            }
            $id = $this->uri->segment(3);

            if($id){
                $where['id !='] = $id;
            }
            $user = $this->common->gettblrowdata($where,$col,$table,0,0);
            if(empty($user)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkMobile',"Already User Existed with this username");
                return FALSE;
            }
        }
    }

    public function checkEmail($email){
        if(empty($email)){
            $this->form_validation->set_message('checkEmail','Email Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            if($this->input->post('role') == 1){
                $table = 'tb_users';
                $col = 'emailid';
                $where = array('emailid'=>$email,'status'=>'Active');
            } else {
                $table = 'tb_customers';
                $col = 'email_id';
                $where = array('email_id'=>$email,'status'=>1);
            }
            if($id){
                $where['id !='] = $id;
            }
            $user = $this->common->gettblrowdata($where,$col,$table,0,0);
            if(empty($user)){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkEmail',"Already User Existed with this Email");
                return FALSE;
            }
        }
    }

    public function checkCountryMaster($country_master){
        if($country_master == 0){
            $this->form_validation->set_message('checkCountryMaster','Country Required');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function valCID($cid){
        if(empty($cid)){
            $this->form_validation->set_message('valCID','CID  Required');
            return FALSE;
        } else {
            $id = $this->uri->segment(3);
            $where = array('code'=>$cid,'status'=>1);
            if($id){
                $where['id !='] = $id;
            }
            $user = $this->common->gettblrowdata($where,'code','tb_customers',0,0);
            if(empty($user)){
                return TRUE;
            } else {
                $this->form_validation->set_message('valCID',"Already User Existed with this CID");
                return FALSE;
            }
        }
    }

    public function checkParentcid($cid){
        if(empty($cid)){
            $this->form_validation->set_message('checkParentcid','Mobile No Required');
            return FALSE;
        } else {
            $user = $this->common->gettblrowdata(array('code'=>$cid,'status'=>1),'code','tb_customers',0,0);
            if($user){
                return TRUE;
            } else {
                $this->form_validation->set_message('checkParentcid',"NO Customer  with this CID");
                return FALSE;
            }
        }
    }

    public function checkBranch($branch){
        if(empty($branch)){
            $this->form_validation->set_message('checkBranch','Mobile No Required');
            return FALSE;
        } else {
                $id = $this->uri->segment(3);
                $role = $this->uri->segment(4);
                if($this->input->post('role') != 1){
                    $user = $this->common->gettblrowdata(array('branch_code'=>$branch,'status'=>'Active'),'id','tb_users',0,0);
                    if($user){
                        return TRUE;
                    } else {
                        $this->form_validation->set_message('checkBranch',"No User for this company and branch");
                        return FALSE;
                    }
                } else {
                    $where = array('branch_code'=>$branch,'status'=>'Active');
                    if($id && $role == 1){
                        $where['id !=']= $id;
                    }
                    $user = $this->common->gettblrowdata($where,'id','tb_users',0,0);
                    if(empty($user)){
                        return TRUE;
                    } else {
                        $this->form_validation->set_message('checkBranch',"Already user existed for this company and branch");
                        return FALSE;
                    }
                }

        }
    }

    public function add()   {
         $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data['page_title'] = $this->lang->line('user_title');;
        $data['sub_title'] = $this->lang->line('user_title');;
        $data['countries'] = $this->common->gettbldata(array('status'=>1),'id,country_name','tbl_country_master',0,0);

        if($_POST){
            $this->form_validation->set_rules('branch_code', 'Branch Code', 'required|callback_checkBranch');
            $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'required|callback_valPassword');
            $this->form_validation->set_rules('mobile_no', 'Mobile No', 'required|callback_checkMobile');
            $this->form_validation->set_rules('email', 'Email', 'required|callback_checkEmail');
            if($this->input->post('role')!= 1){
                $this->form_validation->set_rules('cid', 'CID', 'required|callback_valCID');
                if($this->input->post('role') == 3){
                    $this->form_validation->set_rules('parent_cid', 'Parent CID', 'required|callback_checkParentcid');
                }
            } else {
                $this->form_validation->set_rules('country_master_id', 'Country', 'required|callback_checkCountryMaster');
            }
            if ($this->form_validation->run() == false) {
                //echo validation_errors(); exit;
                //$this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                $this->newtemplate->dashboard('users/add', $data);
            } else {
                $country_master = $this->common->gettblrowdata(array('id'=>$this->input->post('country_master_id')),'currency,country_code,country_name','tbl_country_master',0,0);
                $addressinfo = implode(",", [$this->input->post('address'),$this->input->post('street'), $this->input->post('city'),$this->input->post('state'),$country_master['country_name'] , $this->input->post('pincode')]);
                $data = getlatlngsbyplace($addressinfo);
                if(!empty($data[0]) && !empty($data[1])){
                    $lat = @$data[0];
                    $lng = @$data[1];
                } else {
                    $lat = 40;
                    $lng = 112;
                }
                if($this->input->post('role') == 1){
                    $array['company_code'] = $this->input->post('company_code');
                    $array['branch_code'] = $this->input->post('branch_code');
                    $array['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                    $array['name'] = $this->input->post('name');
                    $array['updatedon'] = date('Y-m-d H:i:s');
                    $array['createdon'] = date('Y-m-d H:i:s');
                    $array['mobile_no'] = $this->input->post('mobile_no');
                    $array['emailid'] = $this->input->post('email');
                    $array['status'] = ($this->input->post('status')==1)?'Active':'Inactive';
                    $array['address'] = $this->input->post('address').','.$this->input->post('street').','.$this->input->post('city').','.$this->input->post('state').','.$this->input->post('pincode');
                    $array['business_type'] = 'Truck_Owner';
                    $array['createdby'] = $this->session->userdata('user_id');
                    $array['lat'] = $lat;
                    $array['lng'] = $lng;
                    $array['location_id'] = 1646;
                    $array['domain_name'] = $this->input->post('branch_code');
                    $array['company_indv_name'] = $this->input->post('company_code');
                    $array['createdby'] = 1;
                    $array['usr_country'] = $this->input->post('country_master_id');
                    $array['default_currency'] = $country_master['currency'];
                    $array['country_code'] = $country_master['country_code'];
                    $id = $this->common->insertTableData('tb_users',$array);
                    $sub_user_id = $id;
                    $company_code = $this->input->post('company_code',true);
                    $ptype['user_id'] = $id;
                    $ptype['company_code'] = $this->input->post('company_code');
                    $ptype['branch_code'] = $this->input->post('branch_code');
                    $ptype['status'] = 1;
                    $ptype['updated_on'] = date('Y-m-d H:i:s');
                    $ptype['created_on'] = date('Y-m-d H:i:s');
                    $party_types = array('Carrier','Consignor','Consignee','Shipper','Customer','NOTIFY_PARTY','FREIGHT_PAYER','Internal BU','Overseas OL');
                    foreach($party_types as $type){
                        $ptype['name'] = $type;
                        $ptype['description'] = $type;
                        $ins = $this->common->insertTableData('tbl_party_types',$ptype);
                    }
                    $cdate = date('Y-m-d H:i:s');
                    if($sub_user_id >0){
                        $chkadminuser = $this->common->gettblrowdata(array('company_code'=>$company_code,'status'=>'1'),"id",'tb_admin_users',0,0);
                        if(!empty($chkadminuser)){
                            $admin_id = $chkadminuser['id'];
                            if($admin_id >0 ){
                                $admin_ins = $this->common->insertTableData("tb_user_mappings",array('admin_user_id'=>$admin_id,'user_id'=>$sub_user_id,'status'=>'1','created_on'=>$cdate,'updated_on'=>$cdate));
                            }
                        }
                    }
                } else {
                    //customer insertion
                    $customer['company_code'] = $this->input->post('company_code');
                    $customer['branch_code'] = $this->input->post('branch_code');
                    $customer['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                    $customer['name'] = $this->input->post('name');
                    $customer['updatedon'] = date('Y-m-d H:i:s');
                    $customer['createdon'] = date('Y-m-d H:i:s');
                    $user = $this->common->gettblrowdata(array('company_code'=>$this->input->post('company_code'),'branch_code'=>$this->input->post('branch_code'),'status'=>'Active'),'id','tb_users',0,0);
                    $customer['partner_id'] = 0;
                    $customer['user_id'] = $user['id'];
                    $customer['phone'] = $this->input->post('mobile_no');
                    $customer['status'] = $this->input->post('status');
                    $customer['email_id'] = $this->input->post('email');
                    $customer['cid'] = $this->input->post('cid');
                    $customer['code'] = $customer['cid'];
                    $customer['address'] = $this->input->post('address');
                    $customer['street'] = $this->input->post('street');
                    $customer['location'] = $this->input->post('city');
                    $customer['state'] = $this->input->post('state');
                    $customer['country'] = $country_master['country_name'];
                    $customer['pincode'] = $this->input->post('pincode');
                    $customer['lat'] = $lat;
                    $customer['lng'] = $lng;
                    if($this->input->post('role') == 2){
                        $customer['parent_id'] = 0;
                    } else {
                        $customerinfo = $this->common->gettblrowdata(array('code'=>$this->input->post('parent_cid'),'status'=>1),'id,code','tb_customers',0,0);
                        $customer['parent_id'] = $customerinfo['id'];
                    }
                    $this->common->insertTableData('tb_customers',$customer);

                    //party master insertion
                    $pmaster['name'] = $this->input->post('name');
                    $pmaster['mobile'] = $this->input->post('mobile_no');
                    $pmaster['email'] = $this->input->post('email');
                    $pmaster['created_on'] = date('Y-m-d H:i:s');
                    $pmaster['updated_on'] = date('Y-m-d H:i:s');
                    $pmaster['user_id'] = $user['id'];
                    $pmaster['code'] = $this->input->post('cid');
                    $pmaster['company_code'] = $this->input->post('company_code');
                    $pmaster['branch_code'] = $this->input->post('branch_code');
                    $pmaster['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                    $pmaster['status'] = $this->input->post('status');
                    $pmaster['address'] = $this->input->post('address');
                    $pmaster['street'] = $this->input->post('street');
                    $pmaster['state'] = $this->input->post('state');
                    $pmaster['country'] = $country_master['country_name'];
                    $pmaster['pincode'] = $this->input->post('pincode');
                    $pmaster['customeridentifier'] = $this->input->post('cid');
                    $pmaster['latitude'] = $lat;
                    $pmaster['longitude'] = $lng;
                    if($customer['parent_id'] != 0){
                        $pmaster['customer_code'] = $customerinfo['code'];
                    }
                    $pmaster['location_id'] = $this->input->post('city');
                    $partywhere = array('company_code'=>$this->input->post('company_code'),'branch_code' => $this->input->post('branch_code'),'name' => 'CUSTOMER','status'=>1);
                    $party_type = $this->common->gettblrowdata($partywhere,'id','tbl_party_types',0,0);
                    if(empty($party_type)){
                      unset($partywhere['branch_code']);
                      $party_type = $this->common->gettblrowdata($partywhere,'id','tbl_party_types',0,0);
                      if(count($party_type) == 0){
                        $partywhere['user_id'] = $user['id'];
                        $party_type['id'] = $this->common->insertTableData("tbl_party_types",$partywhere);
                      }
                    }
                    $pmaster['party_type_id'] = $party_type['id'];
                    $pmaster['party_types'] = $party_type['id'];
                    $this->common->insertTableData('tbl_party_master',$pmaster);
                }

               redirect('users');
            }
        } else {
            $this->newtemplate->dashboard('users/add', $data);
        }
    }

    public function edit($id,$type) {
        $data['page_title'] = $this->lang->line('user_title');
        $data['sub_title'] = $this->lang->line('user_title');;
        $data['countries'] = $this->common->gettbldata(array('status'=>1),'id,country_name','tbl_country_master',0,0);
        if($type == 1){
            $table = 'tb_users';
        } else {
            $table = 'tb_customers';
        }
        $data['role'] = $type;
        $data['user'] = $this->common->gettblrowdata(array('id'=>$id),'*',$table,0,0);
        if($type ==3){
            $parentuser = $this->common->gettblrowdata(array('id'=>$data['user']['parent_id'],'status'=>1),'code','tb_customers',0,0);
            $data['user']['parent_cid'] = isset($parentuser['code'])?$parentuser['code']:'';
        }
        if($type == 1){
            $address = explode(',',$data['user']['address']);
            $data['user']['address'] = (isset($address[0]))?$address[0]:'';
            $data['user']['street'] = (isset($address[1]))?$address[1]:'';
            $data['user']['location'] = (isset($address[2]))?$address[2]:'';
            $data['user']['state'] = (isset($address[3]))?$address[3]:'';
            $data['user']['pincode'] = (isset($address[4]))?$address[4]:'';
        } else {
            $country_master = $this->common->gettblrowdata(array('country_name'=>$data['user']['country'],'status'=>1),'id','tbl_country_master',0,0);
            $data['user']['usr_country'] = isset($country_master['id'])?$country_master['id']:0;
        }
        if(isset($data['user']['id'])) {
            if($_POST){
               // print_r($this->input->post('role')); exit;
               $_POST['role'] = $type;
                $this->form_validation->set_rules('branch_code', 'Branch Code', 'required|callback_checkBranch');
                $this->form_validation->set_rules('mobile_no', 'Mobile No', 'required|callback_checkMobile');
                $this->form_validation->set_rules('email', 'Email', 'required|callback_checkEmail');
                if($this->input->post('role') != 1){
                    $this->form_validation->set_rules('cid', 'CID', 'required|callback_valCID');
                    if($this->input->post('role') == 3){
                       $this->form_validation->set_rules('parent_cid', 'Parent CID', 'required|callback_checkParentcid');
                    }
                } else {
                    $this->form_validation->set_rules('country_master_id', 'Country', 'required|callback_checkCountryMaster');
                }
                if ($this->form_validation->run() == false) {
                   // echo validation_errors(); exit;
                    //$this->form_validation->set_error_delimiters('<div class="alert alert-danger" style="padding: 5px;margin-left: 10px; margin-right: 10px;" ><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>', '</div>');
                    $this->newtemplate->dashboard('users/edit', $data);
                } else {
                    $array['company_code'] = $this->input->post('company_code');
                    $array['branch_code'] = $this->input->post('branch_code');
                    $array['name'] = $this->input->post('name');
                    $array['updatedon'] = date('Y-m-d H:i:s');
                    $country_master = $this->common->gettblrowdata(array('id'=>$this->input->post('country_master_id')),'currency,country_code,country_name','tbl_country_master',0,0);
                    $addressinfo = implode(",", [$this->input->post('address'),$this->input->post('street'), $this->input->post('city'),$this->input->post('state'),$country_master['country_name'] , $this->input->post('pincode')]);
                    $data = getlatlngsbyplace($addressinfo);
                    if(!empty($data[0]) && !empty($data[1])){
                        $lat = @$data[0];
                        $lng = @$data[1];
                    } else {
                        $lat = 40;
                        $lng = 112;
                    }

                    // User Updation
                if($this->input->post('role') == 1){
                    $array['mobile_no'] = $this->input->post('mobile_no');
                    $array['emailid'] = $this->input->post('email');
                    $array['status'] = ($this->input->post('status')==1)?'Active':'Inactive';
                    $array['address'] = $this->input->post('address').','.$this->input->post('street').','.$this->input->post('city').','.$this->input->post('state').','.$this->input->post('pincode');
                    $array['company_indv_name'] = $this->input->post('company_code');
                    $array['usr_country'] = $this->input->post('country_master_id');
                    $array['default_currency'] = $country_master['currency'];
                    $array['country_code'] = $country_master['country_code'];
                    $array['lat'] = $lat;
                    $array['lng'] = $lng;
                    $array['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                    $this->common->updatetbledata('tb_users',$array,array('id'=>$id));
                } else {
                    //customer updation
                    $customer['company_code'] = $this->input->post('company_code');
                    $customer['branch_code'] = $this->input->post('branch_code');
                    $customer['name'] = $this->input->post('name');
                    $customer['updatedon'] = date('Y-m-d H:i:s');
                    $customer['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
                    $user = $this->common->gettblrowdata(array('company_code'=>$this->input->post('company_code'),'branch_code'=>$this->input->post('branch_code'),'status'=>'Active'),'id','tb_users',0,0);
                    $customer['user_id'] = $user['id'];
                    $customer['phone'] = $this->input->post('mobile_no');
                    $customer['email_id'] = $this->input->post('email');
                    $customer['cid'] = $this->input->post('cid');
                    $customer['code'] = $customer['cid'];
                    $customer['address'] = $this->input->post('address');
                    $customer['street'] = $this->input->post('street');
                    $customer['location'] = $this->input->post('city');
                    $customer['state'] = $this->input->post('state');
                    $customer['country'] = $country_master['country_name'];
                    $customer['pincode'] = $this->input->post('pincode');
                    $customer['lat'] = $lat;
                    $customer['lng'] = $lng;
                    if($this->input->post('role') == 2){
                        $customer['parent_id'] = 0;
                    } else {
                        $customerinfo = $this->common->gettblrowdata(array('code'=>$this->input->post('parent_cid')),'id,code','tb_customers',0,0);
                        $customer['parent_id'] = $customerinfo['id'];
                    }
                    $this->common->updatetbledata('tb_customers',$customer,array('id'=>$id));
                    //party master insertion
                    $pmaster['name'] = $this->input->post('name');
                    $pmaster['mobile'] = $this->input->post('mobile_no');
                    $pmaster['email'] = $this->input->post('email');
                    $pmaster['updated_on'] = date('Y-m-d H:i:s');
                    $pmaster['user_id'] = $user['id'];
                    $pmaster['code'] = $this->input->post('cid');
                    $pmaster['company_code'] = $this->input->post('company_code');
                    $pmaster['branch_code'] = $this->input->post('branch_code');
                    $pmaster['address'] = $this->input->post('address');
                    $pmaster['street'] = $this->input->post('street');
                    $pmaster['state'] = $this->input->post('state');
                    $pmaster['country'] = $country_master['country_name'];
                    $pmaster['pincode'] = $this->input->post('pincode');
                    $pmaster['latitude'] = $lat;
                    $pmaster['longitude'] = $lng;
                    if($customer['parent_id'] != 0){
                        $pmaster['customer_code'] = $customerinfo['code'];
                    }
                    $partywhere = array('company_code'=>$this->input->post('company_code'),'branch_code' => $this->input->post('branch_code'),'name' => 'CUSTOMER','status'=>1);
                    $party_type = $this->common->gettblrowdata($partywhere,'id','tbl_party_types',0,0);
                    if(empty($party_type)){
                      unset($partywhere['branch_code']);
                      $party_type = $this->common->gettblrowdata($partywhere,'id','tbl_party_types',0,0);
                      if(count($party_type) == 0){
                        $partywhere['user_id'] = $user['id'];
                        $party_type['id'] = $this->common->insertTableData("tbl_party_types",$partywhere);
                      }
                    }
                    $pmaster['party_type_id'] = $party_type['id'];
                    $upd = $this->common->updatetbledata('tbl_party_master',$pmaster,array('code'=>$this->input->post('cid')));
                }
                redirect('users');
              }
            } else {
                $this->newtemplate->dashboard('users/edit', $data);
            }
        } else {
            show_error('The User you are trying to Edit does not exist.');
        }
    }

    public function deleteuser($id,$role){
        if($id != '' || $id != 0){
            if($role == 1){
                $table_name = "tb_users";
                $sts = array('status'=>'Inactive');
                $getadminid = $this->common->gettblrowdata(array('user_id'=>$id),"id","tb_user_mappings",0,0);
                if(!empty($getadminid)){
                    $mapping_id = $getadminid['user_id'];
                    if($mapping_id >0){
                        $upd = $this->common->updatetbledata("tb_user_mappings",array('status'=>'0'),array('id'=>$mapping_id));
                    }
                }
            } else {
                $table_name = "tb_customers";
                $sts = array('status'=>0);
            }
            $chk = $this->common->gettblrowdata(array('id'=>$id),'status',$table_name,0,0);
            if($chk){
                $upd = $this->common->updatetbledata($table_name,$sts,array('id'=>$id));
                if($upd){
                    echo "1";
                }else{
                    echo "0";
                }
            }else{
                echo "0";
            }
        }
    }

    public function view($id,$type){
        $data['page_title'] = $this->lang->line('user_title');
        $data['sub_title'] = $this->lang->line('user_title');;
        if($type == 1){
            $table = 'tb_users';
            $data['rolename'] = 'KN Admin';
        } else {
            $table = 'tb_customers';
            $data['rolename'] = 'Customers';
        }
        $data['role'] = $type;
        $data['user'] = $this->common->gettblrowdata(array('id'=>$id),'*',$table,0,0);
        if($type ==3){
            $parentuser = $this->common->gettblrowdata(array('id'=>$data['user']['parent_id']),'code','tb_customers',0,0);
            $data['user']['parent_cid'] = isset($parentuser['code'])?$parentuser['code']:'';
            $data['rolename'] = 'SubCustomers';
        }
        if($type == 1){
            $address = explode(',',$data['user']['address']);
            $data['user']['address'] = (isset($address[0]))?$address[0]:'';
            $data['user']['street'] = (isset($address[1]))?$address[1]:'';
            $data['user']['location'] = (isset($address[2]))?$address[2]:'';
            $data['user']['state'] = (isset($address[3]))?$address[3]:'';
            $data['user']['country'] = (isset($address[4]))?$address[4]:'';
            $data['user']['pincode'] = (isset($address[5]))?$address[5]:'';
        }

        $this->newtemplate->dashboard('users/view', $data);
    }

    public function getParentcid(){
        $term = $this->input->post('term');
        $company_code = $this->input->post('company_code');
        $branch_code = $this->input->post('branch_code');
        $result = array();
        $this->load->model('mastersmodel');
        if(!empty($company_code) && !empty($branch_code)){
            $where = array('company_code'=>$company_code,"branch_code"=>$branch_code,'status'=>1,'code !='=> null);
            $select = 'id,code as cid,name,phone,company_code,branch_code';
            $like = array('code'=>$term);
            // $result = $this->common->gettbldata($where,'id,cid,name,phone,company_code,branch_code','tb_customers',0,0);
            $result = $this->mastersmodel->getsearchdata($like,$where,$select,'tb_customers');
        }
        echo  json_encode($result);
    }

    public function getCustomerslist()
    {
        $result = array();
        $select = 'id,code as cid,name,phone,company_code,branch_code';
        $where = array('status'=>1,'code !='=> null,'company_code'=>$this->input->post('company_code'),'branch_code'=>$this->input->post('branch_code'));
        if($this->input->post('cid')){
            $where['code'] = $this->input->post('cid');
        }
        if($this->input->post('term')){
            $like['code'] = $this->input->post('term');
        } else {
            $like = array();
        }
        $this->load->model('mastersmodel');
        $chkqry = $this->mastersmodel->getsearchdata($like,$where,$select,'tb_customers');
        if (count($chkqry) > 0) {
            foreach ($chkqry as $res) {
                $check    = "<input type='radio' name='listcustomer' id='listcustomer_" . $res['id'] . "' class='listcustomer' onchange='selectcustomer(" . $res['id'] . ")' value='" . $res['cid'] . "'>";
                $result[] = array('check' => $check,'cid'=> $res['cid'],'name'=>$res['name'],'company_code' => $res['company_code'],'branch_code'=>$res['branch_code']);
            }
        }
        echo json_encode($result);
    }
}

