<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Vatmaster extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('common');
		$this->load->model('vatmastermodel');
        if (!checkUrlAccessForUser('VATMASTER')) {
            redirect("Forbiddenaccess");
        }
	}

	public function index(){
		$data = [];
		$post = [];
		$usercompany_code = $this->session->userdata('company_code');
		$data['page_title'] = $this->lang->line('vat_master');
		if($usercompany_code == "SGKN"){
			$data['page_title'] = $this->lang->line('gst');
		}
		$data['sub_title'] = "Search";
		if(isset($_POST['searchsubmit']) && $this->input->post('searchsubmit', TRUE)){
			$post = $this->input->post(NULL, TRUE);
		}
		
		$whr = $whr2 = [];
		$tobebilled = 0;
		if(!empty($post)){
			$whr = $this->searchvats($post);
		}
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$branch_code = $this->session->userdata('branch_code');
		$custid = $this->session->userdata("cust_id");
		$country_userids = $this->session->userdata("country_user_ids");
		$vatdata = $this->vatmastermodel->getvatdata($uid,$whr);

		$data['company_code'] = $company_code;
		$data['branch_code'] = $branch_code;
		$data['vatdata'] = $vatdata;
		$this->newtemplate->dashboard("vatmaster/index", $data);
	}
	public function searchvats($post){
		$whr = array();
		if (isset($post['search_vatid']) &&  $post['search_vatid'] != "")
		{
			$whr['v.vat_id'] = $post['search_vatid'];

		}
		if (isset($post['search_vatname']) &&  $post['search_vatname'] != "")
		{
			$whr['v.name'] = $post['search_vatname'];

		}
		if (isset($post['search_custname']) &&  $post['search_custname'] != "")
		{
			$whr['cp.name'] = $post['search_custname'];

		}

		if (isset($post['adv_vatid']) &&  $post['adv_vatid'] != "")
		{
			$whr['v.vat_id'] = $post['adv_vatid'];

		}
		if (isset($post['adv_vatname']) &&  $post['adv_vatname'] != "")
		{
			$whr['v.name'] = $post['adv_vatname'];

		}
		if (isset($post['adv_custname']) &&  $post['adv_custname'] != "")
		{
			$whr['cp.name'] = $post['adv_custname'];

		}
		if (isset($post['adv_vendorname']) &&  $post['adv_vendorname'] != "")
		{
			$whr['vp.name'] = $post['adv_vendorname'];

		}
		return $whr;

	}
	public function insertvatdata(){
		$post = $this->input->post(NULL,TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$vat_name = isset($post['vat_name']) ? $post['vat_name'] : "";
		$vat_description = isset($post['vat_description']) ? $post['vat_description'] : "";
		$company_code = isset($post['company_code']) ? $post['company_code'] : "";
		$customeridentifier = isset($post['customeridentifier']) ? $post['customeridentifier'] : "";
		$vendoridentifier = isset($post['vendoridentifier']) ? $post['vendoridentifier'] : "";
		$laneids = isset($post['laneids']) ? $post['laneids'] : array();
		$vat_category = isset($post['vat_category']) ? $post['vat_category'] : "";
		$cat_id= $generic =0;
		$cat_val = "";
		if($vat_category != ""){
         $vatcat_data = explode("_", $vat_category);
         if(isset($vatcat_data[0])){
          $cat_id=$vatcat_data[0];
         }
         if(isset($vatcat_data[1])){
          $cat_val=$vatcat_data[1];
         }
		}
		if($customeridentifier =="" && $vendoridentifier ==""){
          $generic =1;
		}

		if(!empty($post)){
			$insdata = array('vat_id'=>0,'name'=>$vat_name,'description'=>$vat_description, 'company_code'=>$company_code, 'customeridentifier'=>$customeridentifier, 'vendoridentifier'=>$vendoridentifier,'generic'=>$generic,'cat_id'=>$cat_id,'cat_val'=>$cat_val, 'user_id'=>$uid,'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
			$vatid = $this->common->insertTableData("tbl_vat_master",$insdata);
			$ccode = mb_substr($company_code, 0, 2);
			$idlength = strlen($vatid);
			$id = $vatid;
			if($idlength =='1'){
				$id = "00000".$id;
			}else if($idlength == '2'){
				$id = "0000".$id;
			}else if($idlength == '3'){
				$id = "000".$id;
			}else if($idlength == '4'){
				$id ="00".$id;
			}else if($idlength == '5'){
				$id ="0".$id;
			}else{
				$id = $id;
			}
			$vatcode = $ccode.$id;
			$upd = array('vat_id'=>$vatcode);
			$updatecode = $this->vatmastermodel->updatedata('tbl_vat_master',$vatid,$upd);
			if(count($laneids)>0){
				foreach ($laneids as $laneid) {
					$upd = array('vatid'=>$vatid);
					$updatelane = $this->vatmastermodel->updatedata('tbl_lanes',$laneid,$upd);
				}
			}
			$data['status'] = 1;

		}
		echo json_encode($data);
	}
	public function updatevatdata(){
		$post = $this->input->post(NULL,TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$vat_name = isset($post['vat_name']) ? $post['vat_name'] : "";
		$vat_description = isset($post['vat_description']) ? $post['vat_description'] : "";
		$company_code = isset($post['company_code']) ? $post['company_code'] : "";
		$customeridentifier = isset($post['customeridentifier']) ? $post['customeridentifier'] : "";
		$vendoridentifier = isset($post['vendoridentifier']) ? $post['vendoridentifier'] : "";
		$vat_masterid = isset($post['vat_masterid']) ? $post['vat_masterid'] : 0;
		if($vat_masterid =="undefined" || $vat_masterid ==""){
			$vat_masterid = 0;
		}
		$vat_category = isset($post['vat_category']) ? $post['vat_category'] : "";
		$cat_id=0;
		$cat_val = "";
		if($vat_category != ""){
         $vatcat_data = explode("_", $vat_category);
         if(isset($vatcat_data[0])){
          $cat_id=$vatcat_data[0];
         }
         if(isset($vatcat_data[1])){
          $cat_val=$vatcat_data[1];
         }
		}
		$generic =0;
		if($customeridentifier =="" && $vendoridentifier ==""){
          $generic =1;
		}
		if(!empty($post)){
			if($vat_masterid > 0){
				$updata = array('name'=>$vat_name,'description'=>$vat_description, 'company_code'=>$company_code, 'customeridentifier'=>$customeridentifier, 'vendoridentifier'=>$vendoridentifier,'generic'=>$generic, 'cat_id'=>$cat_id, 'cat_val'=>$cat_val, 'user_id'=>$uid, 'status'=>1, 'updated_on'=>$curdt);
				$updatevatmaster = $this->vatmastermodel->updatedata('tbl_vat_master',$vat_masterid,$updata);
				$data['status'] = 1;

			}
		}
		echo json_encode($data);
	}
	public function savelane(){
		$post = $this->input->post(NULL,TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$vat_id = isset($post['vat_id']) ? $post['vat_id'] : 0;
		if($vat_id =="undefined" || $vat_id ==""){
			$vat_id = 0;
		}
		$source_geo = isset($post['source_geo']) ? $post['source_geo'] : 1;
		$source_country = isset($post['source_country']) ? $post['source_country'] : "";
		$destination_geo = isset($post['destination_geo']) ? $post['destination_geo'] : 1;
		$destination_country = isset($post['destination_country']) ? $post['destination_country'] : "";
		if(!empty($post)){
			$insdata = array('vatid'=>$vat_id,'source_geo'=>$source_geo,'source_country'=>$source_country,'destination_geo'=>$destination_geo, 'destination_country'=>$destination_country,'company_code'=>$company_code, 'user_id'=>$uid, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
			$laneid = $this->common->insertTableData("tbl_lanes",$insdata);
			$data['status'] = 1;
			$data['laneid'] = $laneid;
		}
		echo json_encode($data);
	}
	public function updatelane(){
		$post = $this->input->post(NULL,TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$lane_id = isset($post['lane_id']) ? $post['lane_id'] : 0;
		if($lane_id =="undefined" || $lane_id ==""){
			$lane_id = 0;
		}
		$source_geo = isset($post['source_geo']) ? $post['source_geo'] : 1;
		$source_country = isset($post['source_country']) ? $post['source_country'] : "";
		$destination_geo = isset($post['destination_geo']) ? $post['destination_geo'] : 1;
		$destination_country = isset($post['destination_country']) ? $post['destination_country'] : "";
		if($lane_id > 0){
			$updata = array('source_geo'=>$source_geo,'source_country'=>$source_country,'destination_geo'=>$destination_geo, 'destination_country'=>$destination_country,'company_code'=>$company_code, 'user_id'=>$uid, 'status'=>1, 'updated_on'=>$curdt);
			$update = $this->vatmastermodel->updatedata("tbl_lanes",$lane_id,$updata);
			$data['status'] = 1;
			$data['laneid'] = $lane_id;
		}
		echo json_encode($data);
	}
	public function updatevat(){
		$post = $this->input->post(NULL,TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$vat_id = isset($post['vat_id']) ? $post['vat_id'] : 0;
		if($vat_id =="undefined" || $vat_id ==""){
			$vat_id = 0;
		}
		$charge_id = isset($post['charge_id']) ? $post['charge_id'] : 0;
		if($charge_id =="undefined" || $charge_id ==""){
			$charge_id = 0;
		}
		$vat = isset($post['vat']) ? $post['vat'] : "";
		$destination_geo = isset($post['destination_geo']) ? $post['destination_geo'] : 1;
		$destination_country = isset($post['destination_country']) ? $post['destination_country'] : "";
		if($vat_id > 0){
			$updata = array('charge_id'=>$charge_id,'vat'=>$vat,'company_code'=>$company_code, 'user_id'=>$uid, 'updated_on'=>$curdt);
			$update = $this->vatmastermodel->updatedata("tbl_lane_vat",$vat_id,$updata);
			$data['status'] = 1;
			$data['laneid'] = $vat_id;
		}
		echo json_encode($data);
	}
	public function getrecentlanes(){
		$lanes  = array();
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$post = $this->input->post(NULL,TRUE);
		$lanesdata = $this->vatmastermodel->getrecentlanes($uid,$company_code);
		if (!empty($lanesdata)) {
			foreach ($lanesdata as $res) {
				$action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowEditlane(this," . $res['id'] . ",0);'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletelane(" . $res['id'] . ",0);'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='lanerowAdd(this,0);'><span class='glyphicon glyphicon-plus' > </span>Add Lane</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'   onclick='addcharges(this," . $res['id'] . ");''><span class='fa fa-archive' > </span> Add charges</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'  onclick='getchargesbylane(this," . $res['id'] . ",1);'><span class='fa fa-archive' > </span> Get charges</a></li><input type='hidden' form='vat_data' class='laneids' name='laneids[]' value='".$res['id']."'>";
				if ($res['source_geo'] == '1') {
					$source_geo = "Country";
				} else if($res['source_geo'] == '2'){
					$source_geo = "Province";
				}else if($res['source_geo'] == '3'){
					$source_geo = "City";
				}
				if ($res['destination_geo'] == '1') {
					$destination_geo = "Country";
				} else if($res['destination_geo'] == '2'){
					$destination_geo = "Province";
				}else if($res['destination_geo'] == '3'){
					$destination_geo = "City";
				}
				$radio = "<input type='radio' name='getcharges' onclick='getchargesbylane(this," . $res['id'] . ",1);'>";
				$lanes[] = array('id' => $res['id'],'radio'=>$radio,'source_geo' => $source_geo, 'source_country' => $res['source_country'], 'destination_geo' => $destination_geo, 'destination_country' => $res['destination_country'], 'action' => $action);
			}
		}
		echo json_encode($lanes);
	}
	public function getlanes(){
		$lanes  = array();
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$post = $this->input->post(NULL,TRUE);
		$vatid = isset($post['vatid']) ? $post['vatid'] : 0;
		$type = isset($post['type']) ? $post['type'] : 'edit';
		$lanesdata = $this->vatmastermodel->getlanes($vatid,$uid,$company_code);
		if (!empty($lanesdata)) {
			foreach ($lanesdata as $res) {
				$radio = "";
				if($type == "edit"){
					$action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowEditlane(this," . $res['id'] . "," . $vatid . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletelane(" . $res['id'] . ",". $vatid .");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='lanerowAdd(this,". $vatid .");'><span class='glyphicon glyphicon-plus' > </span>Add Lane</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'   onclick='addcharges(this," . $res['id'] . ");''><span class='fa fa-archive' > </span> Add charges</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'  onclick='getchargesbylane(this," . $res['id'] . ",1);'><span class='fa fa-archive' > </span> Get charges</a></li><input type='hidden' form='vat_data' class='laneids' name='laneids[]' value='".$res['id']."'>";
					$radio = "<input type='radio' name='getcharges' onclick='getchargesbylane(this," . $res['id'] . ",1);'>";
				}else{
					$action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='innerpacking' type='button' class='btn btn-sm btn-default'  onclick='getchargesbylane(this," . $res['id'] . ",0);'><span class='fa fa-archive' > </span> Get charges</a></li><input type='hidden' form='vat_data' name='laneids[]' value='".$res['id']."'>";
					$radio = "<input type='radio' name='getcharges' onclick='getchargesbylane(this," . $res['id'] . ",0);'>";
				}
				if ($res['source_geo'] == '1') {
					$source_geo = "Country";
				} else if($res['source_geo'] == '2'){
					$source_geo = "Province";
				}else if($res['source_geo'] == '3'){
					$source_geo = "City";
				}
				if ($res['destination_geo'] == '1') {
					$destination_geo = "Country";
				} else if($res['destination_geo'] == '2'){
					$destination_geo = "Province";
				}else if($res['destination_geo'] == '3'){
					$destination_geo = "City";
				}

				$lanes[] = array('id' => $res['id'],'radio'=>$radio,'source_geo' => $source_geo, 'source_country' => $res['source_country'], 'destination_geo' => $destination_geo, 'destination_country' => $res['destination_country'], 'action' => $action);
			}
		}
		echo json_encode($lanes);
	}
	public function savelanevat(){
		$post = $this->input->post(NULL, TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$lane_id = isset($post['lane_id']) ? $post['lane_id'] : 0;
		if($lane_id =="undefined" || $lane_id ==""){
			$lane_id = 0;
		}
		$charge_id = isset($post['charge_id']) ? $post['charge_id'] : 1;
		if($charge_id =="undefined" || $charge_id ==""){
			$charge_id = 0;
		}
		$vat = isset($post['vat']) ? $post['vat'] : 0;
		if($vat =="undefined" || $vat ==""){
			$vat = 0;
		}
		$destination_country = isset($post['destination_country']) ? $post['destination_country'] : "";
		if(!empty($post)){
			$insdata = array('lane_id'=>$lane_id,'charge_id'=>$charge_id,'vat'=>$vat,'company_code'=>$company_code, 'user_id'=>$uid, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
			$lanevatid = $this->common->insertTableData("tbl_lane_vat",$insdata);
			$data['status'] = 1;
			$data['lanevatid'] = $lanevatid;
		}
		echo json_encode($data);

	}
	public function deletelane(){
		$post = $this->input->post(NULL, TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$lane_id = isset($post['laneid']) ? $post['laneid'] : 0;
		if($lane_id > 0){
			$updata = array( 'user_id'=>$uid, 'status'=>0,'updated_on'=>$curdt);
			$update = $this->vatmastermodel->updatedata("tbl_lanes",$lane_id,$updata);
			$data['status'] = 1;
		}
		echo json_encode($data);
	}
	public function deletecharge(){
		$post = $this->input->post(NULL, TRUE);
		$data['status'] = 0;
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$lane_vat = isset($post['lane_vat']) ? $post['lane_vat'] : 0;
		if($lane_vat > 0){
			$updata = array( 'user_id'=>$uid, 'status'=>0,'updated_on'=>$curdt);
			$update = $this->vatmastermodel->updatedata("tbl_lane_vat",$lane_vat,$updata);
			$data['status'] = 1;
		}
		echo json_encode($data);
	}
	public function deletevatmaster($id){
		$post = $this->input->post(NULL, TRUE);
		$curdt = date('Y-m-d H:i:s');
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		if($id > 0){
			$updata = array( 'user_id'=>$uid, 'status'=>0,'updated_on'=>$curdt);
			$update = $this->vatmastermodel->updatedata("tbl_vat_master",$id,$updata);
			echo "1";
		}else{
			echo "0";
		}
	}
	public function getlanevats(){
		$lanevats  = array();
		$post = $this->input->post(NULL, TRUE);
		$data['status'] = 0;
		$lane_id = isset($post['id']) ? $post['id'] : 0;
		$type = isset($post['type']) ? $post['type'] : 1;
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		if ($lane_id > 0) {
			$getlanevats = $this->vatmastermodel->getlanevats($lane_id);
			if(!empty($getlanevats)){
				foreach ($getlanevats as $res) {
					if($type ==1){
						$action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowEditcharge(this," . $res['id'] . ",".$lane_id .");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletecharge(" . $res['id'] . ",".$lane_id .");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'   onclick='addcharges(this," . $lane_id . ");''><span class='fa fa-archive' > </span> Add charges</a></li>";
					}else{
						$action = "";
					}


					$lanevats[] = array('charge_code' => $res['charge_code'], 'description' => $res['description'], 'vat' => $res['vat'], 'action' => $action);
				}
			}
		}
		echo json_encode($lanevats);
	}

	public function editvat($id){
		if($id != ""){
			$data = array();
			$data['lanes'] = $data['vatdata'] = $data['chargecodes'] = $data['vatcategory'] = array();
			$data['page_title'] = strtoupper($this->lang->line('vat'));
			$usercompany_code = $this->session->userdata('company_code');
			if($usercompany_code == "SGKN"){
				$data['page_title'] = $this->lang->line('gst');
			}
			$data['sub_title'] = $this->lang->line('general_edit');
			$company_code = $this->session->userdata('company_code');
			$uid = $this->session->userdata("user_id");
			$custid = $this->session->userdata("cust_id");
			$data['vatdata'] = $this->common->gettblrowdata(array("id"=>$id),"*","tbl_vat_master",0,0);
			$getchargecodes = $this->common->gettbldata(array('status' => '1'),"id,charge_code","tb_charge_codes",0,0);
		if (!empty($getchargecodes)) {
			foreach ($getchargecodes as $res) {
				$data['chargecodes'][] = array('charge_id' => $res['id'], 'charge_code' => $res['charge_code']);
			}
		}
			$getvatcategory = $this->common->gettbldata(array('company_code'=>$company_code,'status' => '1'),"id,description,vat_category,vat_percentage","tb_vat_category",0,0);
		if (!empty($getvatcategory)) {
			foreach ($getvatcategory as $res) {
				$val = $res['id']."_".$res['vat_category'];
				$desc = $res['description']." (".$res['vat_category']."-".$res['vat_percentage'].")";
				$data['vatcategory'][] = array('id' => $res['id'],'val'=>$val, 'desc'=>$desc);
			}
		}

			//$this->newtemplate->dashboard("vatmaster/editvat", $data);
			$this->load->view("vatmaster/editvat", $data);
		}else{
			redirect('vatmaster');
		}
	}
	public function viewvat($id){
		if($id != ""){
			$data = array();
			$data['lanes'] = $data['vatdata'] = array();
			$data['page_title'] = strtoupper($this->lang->line('vat'));
			$usercompany_code = $this->session->userdata('company_code');
			if($usercompany_code == "SGKN"){
				$data['page_title'] = $this->lang->line('gst');
			}
			$data['sub_title'] = $this->lang->line('general_edit');
			$company_code = $this->session->userdata('company_code');
			$uid = $this->session->userdata("user_id");
			$custid = $this->session->userdata("cust_id");
			$data['cat_desc'] = "";
			$data['vatdata'] = $this->common->gettblrowdata(array("id"=>$id),"*","tbl_vat_master",0,0);
			if(!empty($data['vatdata'])){
				$cat_id = $data['vatdata']['cat_id'];
				if($cat_id >0){
                 $getcatinfo = $this->common->gettblrowdata(array("id"=>$cat_id),"*","tb_vat_category",0,0);
                 if(!empty($getcatinfo)){
                 	$data['cat_desc'] = $getcatinfo['description']." (".$getcatinfo['vat_category']."-".$getcatinfo['vat_percentage'].")";
                 }
				}
			}

			//$this->newtemplate->dashboard("vatmaster/viewvat", $data);
			$this->load->view("vatmaster/viewvat", $data);
		}else{
			redirect('vatmaster');
		}
	}
	public function getlanebyid(){
		$post = $this->input->post(NULL, TRUE);
		$data = array();
		$id = isset($post['id']) ? $post['id'] : 0;
		if($id){
			$data = $this->common->gettblrowdata(array("id"=>$id),"*","tbl_lanes",0,0);
		}
		echo json_encode($data);
	}
	public function getchargebyid(){
		$post = $this->input->post(NULL, TRUE);
		$data = array();
		$id = isset($post['id']) ? $post['id'] : 0;
		if($id){
			$data = $this->vatmastermodel->getchargevat($id);
		}
		echo json_encode($data);
	}

	public function add(){
		$post = $this->input->post(NULL, TRUE);
		$data = $tobebilled = $whr = array();
		$data['page_title'] = strtoupper($this->lang->line('vat'));
		$usercompany_code = $this->session->userdata('company_code');
		if($usercompany_code == "SGKN"){
			$data['page_title'] = $this->lang->line('gst');
		}
		$data['sub_title'] = $this->lang->line('general_new');
		$data['company_code'] = $company_code =$this->session->userdata('company_code');
		$data['branch_code'] = $this->session->userdata('branch_code');
		$userid = $this->session->userdata("user_id");
		$custid = $this->session->userdata("cust_id");
		$country_userids = $this->session->userdata("country_user_ids");
		$data['bstatus'] = $data['bgroups'] =  $data['chargecodes'] = $data['vatcategory'] = array();

		$getchargecodes = $this->common->gettbldata(array('status' => '1'),"id,charge_code","tb_charge_codes",0,0);
		if (!empty($getchargecodes)) {
			foreach ($getchargecodes as $res) {
				$data['chargecodes'][] = array('charge_id' => $res['id'], 'charge_code' => $res['charge_code']);
			}
		}
		$getvatcategory = $this->common->gettbldata(array('company_code'=>$company_code,'status' => '1'),"id,description,vat_category,vat_percentage","tb_vat_category",0,0);
		if (!empty($getvatcategory)) {
			foreach ($getvatcategory as $res) {
				$id = $res['id']."_".$res['vat_category'];
				$desc = $res['description']." (".$res['vat_category']."-".$res['vat_percentage'].")";
				$data['vatcategory'][] = array('id' => $id, 'desc'=>$desc);
			}
		}
		//$this->newtemplate->dashboard("vatmaster/addvat", $data);
		$this->load->view("vatmaster/addvat", $data);

	}
	public function getchargedesc($id)
	{
		$data['desc'] = "";
		if ($id != "") {
			$getdesc = $this->db->query("SELECT description FROM tb_charge_codes WHERE id=$id AND status=1");
			if ($getdesc->num_rows() > 0) {
				$data['desc'] = $getdesc->row()->description;
			}
		}
		echo json_encode($data);
	}

	public function deletebill($id){
		if($id != '' || $id != 0){
			$chk = $this->db->select('id')->get_where("tbl_bills",array('id'=>$id));
			if($chk->num_rows() >0){
				$upd = $this->db->where(array('id'=>$id))->update('tbl_bills',array('status'=>0));
				if($upd){
					echo "1";
				}else{
					echo "0";
				}
			}else{
				echo "0";
			}
		}
	}



	public function getcustomercodes(){
		$custcode = $_REQUEST["custcode"];
		$partytype = $_REQUEST["type"];
		$data = array();
		$uid = $this->session->userdata('user_id');
		$company_code = $this->session->userdata('company_code');
		$this->db->select("m.customer_code");
		$this->db->from("tbl_party_master m");
		$this->db->join("tbl_party_types p","p.id=m.party_type_id","LEFT");
		$this->db->where("p.name",$partytype);
		$this->db->like("m.customer_code",$custcode);
		$this->db->where("m.user_id",$uid);
		$this->db->where("p.user_id",$uid);
		$getcustcode = $this->db->get();
		if($getcustcode->num_rows() > 0){
			foreach ($getcustcode->result() as $custcodes) {
				$data[] = $custcodes->customer_code;
			}
		}
		echo json_encode($data);
	}

	public function getpartnerdetailsbyID(){
		$user_id = $this->session->userdata('user_id');
		$custid = $this->session->userdata("cust_id");
		$data = array();
		$code = $this->input->post('id');
		$type = $this->input->post('type');
		$this->db->select("customeridentifier");
		$this->db->from("tbl_party_master");
		$this->db->where("customeridentifier",$code);
		$this->db->order_by("id","DESC");
		$chkqry =  $this->db->get();
		if($chkqry->num_rows() >0){
			$data = array('customeridentifier'=>$chkqry->row()->customeridentifier,'type'=>$type);
		}
		echo json_encode($data);
	}

	public function viewroletypelist(){
		$data = array();
		$type = isset($_POST['type']) ? $_POST['type'] : "";
		if($type != ""){
			$user_id = $this->session->userdata('user_id');
			$company_code = $this->session->userdata('company_code');
			if($user_id != '0'){
				$info = array('user_id'=>$user_id,'company_code'=>$company_code,'type'=>$type);
				$getroletypelist = $this->vatmastermodel->getroletypelist($info);
				if(!empty($getroletypelist)){
					foreach($getroletypelist as $list){
						$data[]  = array('check'=>"<input class='twopartieslist' type='radio' name='selectparties' id='twopartieslist_".$list['id']."' value='".$list['customeridentifier']."' onchange=selectpartiesbyid(".$list['id'].")>",'id'=>$list['id'],'code'=>$list['customeridentifier'],'name'=>$list['name'],'email_id'=>$list['email'],'company_code'=>$list['company_code'],'branch_code'=>$list['branch_code']);
					}
				}

			}
		}
		echo json_encode($data);
	}


}
