<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Vehicleprofile extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->library('form_validation');
        $this->load->model("common");
        $this->load->model("vehicleprofilemodel");
        if (!checkUrlAccessForUser('VEHICLEPROFILE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data["page_title"] = $this->lang->line('vehicle_profile');
        $data["sub_title"] = $this->lang->line('general_search');
        $post = $whr = $where = array();
        $whr['user_id'] = $this->session->userdata('user_id');
        // common where.
        $whr['company_code'] = $this->session->userdata('company_code');
        if($whr['company_code'] != 'RUKN') {
            $whr['branch_code'] = $this->session->userdata('branch_code');
        }

        $where['status'] = 1;

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $post = $_POST;
        }

        if (!empty($post)) {
            $where = $this->searchprofile($post);
            if (isset($post['name1']) && $post['name1'] != "") {
                $name1    = $post['name1'];
                $whr["name"] = $name1;
            }

            if (isset($post['customer_name']) && $post['customer_name'] != "") {
                $customer_name    = $post['customer_name'];
                $whr["name"] = $customer_name;
            }
        }

        $data['vehicle_profile_list'] = $this->vehicleprofilemodel->getvehicleprofiledata($whr, $where);

        $this->newtemplate->dashboard("vehicleprofile/index", $data);
    }

    public function searchprofile($post)
    {
        $whr = array();
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate                                      = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(createdon,'%Y-%m-%d') >="] = $fromdate;
        }

        if (isset($post['todate']) && $post['todate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (isset($post['profile_id1']) && $post['profile_id1'] != "") {
            $profile_id1  = $post['profile_id1'];
            $whr["veh_profile_id="] = $profile_id1;
        }

        if (isset($post['profile_id']) && $post['profile_id'] != "") {
            $profile_id  = $post['profile_id'];
            $whr["veh_profile_id="] = $profile_id;
        }

        if (isset($post['status']) && $post['status'] != "") {
            $status  = $post['status'];
            $whr["status="] = $status;
        } else {
            $whr['status='] = 1;
        }

        return $whr;
    }

    public function add() {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $table = 'tb_customers';
        $whr = array(
            "user_id" => $user_id
        );
        $cusname = $this->vehicleprofilemodel->selectlist('id,name', $table, $whr, 'name');
        $data['cusname'] = $cusname;
        $table1 = 'tb_department_master';
        $whr1 = array(
            "company_code" => $company_code,
            "branch_code" => $branch_code
        );
        $deprt = $this->vehicleprofilemodel->selectlist('id,department_name', $table1, $whr1, 'department_name');
        $data['depat'] = $deprt;

        $data["page_title"] = $this->lang->line('vehicle_profile');
        $data["sub_title"] = $this->lang->line('general_add');

        //$this->newtemplate->dashboard("vehicleprofile/add", $data);
        $this->load->view("vehicleprofile/add", $data);
    }

    public function update() {
        $id = $this->input->post('id');
        if (!is_numeric($id))
            return json_encode(FALSE);

        $name = $this->input->post('profile_name');
        $description = $this->input->post('desc');
        $company_code = $this->input->post('company_code');
        $branch_code = $this->input->post('branch_code');
        $status = $this->input->post('status');
        $user_id = $this->session->userdata('user_id');
        $data = array(
             'name' => $name,
            'description' => $description, 'company_code' => $company_code, 'branch_code' => $branch_code,
            'status' => $status
        );

        $table = 'tb_vehicle_profile';
        $whr = array(
            'id' => $id,'user_id' =>$user_id
        );

        $result = $this->common->updatetbledata($table, $data, $whr);
        echo json_encode($result);
    }

    public function edit($id) {
        $data["page_title"] = $this->lang->line('vehicle_profile');
        $data["sub_title"] = $this->lang->line('cutomer_edit');

        $company_code = $this->session->userdata('company_code');
        $branch_code = "";
        if($company_code != 'RUKN') {
            $branch_code = $this->session->userdata('branch_code');
        }
        $user_id = $this->session->userdata('user_id');

        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data['vehicle_profile'] = $this->vehicleprofilemodel->editdata($id,$company_code,$branch_code);
        if($data['vehicle_profile']) {
            //$this->newtemplate->dashboard('vehicleprofile/edit', $data);
            $this->load->view("vehicleprofile/edit", $data);
        } else {
            //redirect('vehicleprofile/add');
            $this->load->view("vehicleprofile/add", $data);
        }
    }

    public function view($id) {
        $data["page_title"] = $this->lang->line('vehicle_profile');
        $data["sub_title"] = $this->lang->line('view_view');
        $company_code = $this->session->userdata('company_code');
        $branch_code = "";
        if($company_code != 'RUKN') {
            $branch_code = $this->session->userdata('branch_code');
        }
        $data['vehicle_profile'] = $this->vehicleprofilemodel->viewdata($id,$company_code,$branch_code);
        if($data['vehicle_profile']){
            //$this->newtemplate->dashboard("vehicleprofile/view", $data);
            $this->load->view("vehicleprofile/view", $data);
        } else {
            //redirect('vehicleprofile/add');
            $this->load->view("vehicleprofile/add", $data);
        }
    }

    public function delete($id) {
        if ($id != '' && is_numeric($id)) {
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $this->db->where(array('id' => $id, 'company_code' => $company_code, 'branch_code' => $branch_code));
            $this->db->set('status', 0);
            $result = $this->db->update('tb_vehicle_profile');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function save() {
        $post = $_POST;
        $name = ($post['profile_name']) ? ($post['profile_name']) : '';
        $company_code = ($post['company_code']) ? ($post['company_code']) : '';
        $branch_code = ($post['branch_code']) ? ($post['branch_code']) : '';
        $description = ($post['description']) ? ($post['description']) : '';
        $user_id = $this->session->userdata('user_id');

        $veh_profile_id = $this->genvpid();

        $data = array(
            'veh_profile_id' => $veh_profile_id, 'name' => $name,
            'description' => $description, 'company_code' => $company_code, 'branch_code' => $branch_code,
            'user_id' => $user_id, 'status' => 1
        );

        $table = 'tb_vehicle_profile';
        $vehicle_profile_id = $this->common->insertTableData($table, $data);
        $vehicle_ids = explode(',',$post['vehicle_ids']);
        $updatedata = array('veh_p_id'=>$vehicle_profile_id);
        $result = $this->vehicleprofilemodel->updatelistmodule('tb_vehicle_profile_list',$updatedata,$vehicle_ids);
        echo json_encode($result);
    }

    public function gettrucktypes() {
        if (isset($_POST)) {
            $result = array();
            $user_id = $this->session->userdata('user_id');
            $where_condition = "";
            $company_code = $this->session->userdata('company_code');
            if($company_code == 'RUKN' || $company_code == "VNKN") {
                $where_condition = "company_code='$company_code'";
            } else {
                $where_condition = "user_id='$user_id'";
            }
            $chkqry = $this->db->query("select id,trucktype,description,iconimg from tb_trucktypes where $where_condition and status='Active' and trucktype is not null and trucktype != '' group by trucktype order by id desc");
            if (!empty($chkqry)) {
                foreach ($chkqry->result() as $res) {
                    $res->trucktype;
                    $check = '<input type="radio" name="listvehicle" id="listvehicle' . $res->trucktype . '" class="listvehicle" onchange="selectTruckMaster(' . "'" . $res->trucktype . "'" . ',' . "'" . $res->description . "'" . ',' . "'" . $res->iconimg . "'" . ',' . "'" . $res->id . "'" . ')" value="' . $res->trucktype . '">';
                    $result[] = array('check' => $check, 'trucktype' => $res->trucktype, 'description' => $res->description, 'iconimg' => $res->iconimg);
                }
            }
            echo json_encode($result);
        }
    }

    public function get_profile_ids() {
        $profile_id = $this->input->post('profile_id');
        $user_id = $this->session->userdata('user_id');
        $profile_ids_list = '';
        if (!empty($profile_id)) {
            $result = array();
            $result['status'] = 0;
            $chkqry = $this->db->query("select id,trucktype,description,iconimg from tb_trucktypes where user_id='$user_id' and status='Active' and trucktype is not null and trucktype != '' and trucktype like '%$profile_id%' group by trucktype");
            if ($chkqry->num_rows() > 0) {
                foreach ($chkqry->result() as $res) {
                    $trucktype = $res->trucktype;
                    $profile_ids_list .= "<option value='$trucktype'>";
                }
            }
            echo $profile_ids_list;
        } else {
            echo '';
        }
    }

    public function checkvehiclename()
    {
        $post = $this->input->post();
        $name = isset($post['name']) ? $post['name'] : "";
        $id = isset($post['id']) ? $post['id'] : "";
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        $user_id = $this->session->userdata('user_id');
        $where = array(
            'name' => $name,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'user_id' => $user_id,
            'status' => 1
        );
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, '*', 'tb_vehicle_profile', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {
            echo "1";
        }
    }

    public function getvechprofileid()
    {
        $uid = $this->session->userdata('user_id');

        $profile_id1 = isset($_REQUEST["profile_id1"])?$_REQUEST["profile_id1"]:"";

        $profile_id1 = trim($profile_id1);

        $data = array();

        $get_data = $this->db->query("SELECT veh_profile_id FROM tb_vehicle_profile  WHERE veh_profile_id like '%$profile_id1%' and user_id='$uid' and status=1");

        if($get_data->num_rows() > 0){

            foreach ($get_data->result() as $get_data_f) {

                $data[] = $get_data_f->veh_profile_id;

            }

        }

        echo json_encode($data);
    }

    public function savevehicletype($id = null){
        $post = $_POST;
        $vehicle = array();
        $userid = $this->session->userdata('user_id');
        $vehicle['profile_id'] = ($post['truck_id'])?$post['truck_id']:'';
        if($id == null) {
            if(isset($post['vehiprid'])) {
                $vehicle['veh_p_id'] = $post['vehiprid'];
            } else {
                $vehicle['veh_p_id'] = 0;
            }
            $vehicle['status'] = 1;
            $vehicle['createdon'] = date('Y-m-d H:i:s');
            $vehicle['updatedon'] = date('Y-m-d H:i:s');
            $data['id'] = $this->common->insertTableData('tb_vehicle_profile_list',$vehicle);
        } else {
            $vehicle['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_vehicle_profile_list',$vehicle,array('id'=>$id));
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showprofilelist()
    {
        $profilelist  = array();
        $ids     = isset($_POST['vehicle_ids_list']) ? $_POST['vehicle_ids_list'] : "";
        if ($ids != "") {
            $lists = $this->vehicleprofilemodel->getprofilelist($ids);
            foreach($lists as $list){
                $trucktype_id = '"'.$list['truck_id'].'"';
                $trucktype = '"'.$list['trucktype'].'"';
                $description = '"'.$list['description'].'"';
                $iconimg = '"'.$list['iconimg'].'"';
                $list['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowvehicleEdit(this," . $list['vehicle_id'] ."," . $list['truck_id'] .",".$trucktype.",".$description. "," . $iconimg . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowvehicleElim(this," . $list['vehicle_id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowCustProfile(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_profile')."</a></li>";
                $profilelist[] = $list;
        }
        }
        echo json_encode( $profilelist);
    }

    public function genvpid()
    {
        $company_code = $this->session->userdata('company_code');
        $year = date('y');
        $week = date('W');
        $country_code = substr($company_code, 0, 2);
        $vehi_res = $this->db->query("SELECT veh_profile_id FROM tb_vehicle_profile ORDER BY id DESC LIMIT 1");
        if ($vehi_res->num_rows() > 0) {
            $get_vehi_id = $vehi_res->row()->veh_profile_id;
            $get_vehi_id_c = strlen($get_vehi_id);
            $previous_weeknumber = substr($get_vehi_id, 6, 2);
            $get_vehi_id1 = substr($get_vehi_id, 8);
            $get_vehi_id2 = ltrim($get_vehi_id1, 0);
            if ($previous_weeknumber < $week) {
                    $id1 = '0001';
             } else {
               $i_id = $get_vehi_id2;
               $i_id ++;
               $idlength = strlen($i_id);
               if ($idlength == '1') {
                   $id1 = "000" . $i_id;
               } else if ($idlength == '2') {
                   $id1 = "00" . $i_id;
               } else if ($idlength == '3') {
                   $id1 = "0" . $i_id;
               } else if ($idlength == '4') {
                   $id1 = $i_id;
               } else {
                   $id1 = $i_id;
               }
            }
            $vehi_id1 = "VP" . $country_code . $year . $week . $id1;
            $chk = $this->db->query("select veh_profile_id FROM tb_vehicle_profile WHERE veh_profile_id='" . $vehi_id1 . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $vehi_id1 = "VP" . $country_code . $year . $week . $ii_d;
            } else {
                $vehi_id1 = $vehi_id1;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $vehi_id1 = "VP" . $country_code . $year . $week . $id1;
        }
        return $vehi_id1;
    }

    public function deleteprofiledetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '0';
        if ($id != '0') {
            $chk = $this->db->select('id,profile_id')->get_where('tb_vehicle_profile_list', array(
                'id' => $id
            ));
            if ($chk->num_rows() > 0) {
                $row_id = $chk->row()->profile_id;
                $upd = $this->db->where(array(
                    'id' => $id
                ))->update('tb_vehicle_profile_list', array(
                    'status' => 0
                ));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function getprofilelist()
    {
        $profile_list  = array();
        $vehiprid    = isset($_POST['vehiprid']) ? $_POST['vehiprid'] : "";
        if ($vehiprid != "") {
            $profilelist = $this->vehicleprofilemodel->profilelistbyid($vehiprid);
            foreach($profilelist as $profile){

                $trucktype_id = '"'.$profile['truck_id'].'"';
                $trucktype = '"'.$profile['trucktype'].'"';
                $description = '"'.$profile['description'].'"';
                $iconimg = '"'.$profile['iconimg'].'"';
                $profile['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowvehicleEdit(this," . $profile['vpl_id'] .",".$trucktype_id.",".$trucktype. "," . $description . "," .$iconimg.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowvehicleElim(this," . $profile['vpl_id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowCustProfile(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_profile')."</a></li>";
                $profile_list[] = ['vpl_id'=>$profile['vpl_id'],'trucktype'=>$profile['trucktype'],'description'=>$profile['description'],'iconimg'=>$profile['iconimg'],'action'=>$profile['action']];
            }
        }
        echo json_encode( $profile_list);
    }

}
