<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

require_once APPPATH . "/third_party/PHPExcel.php";

class Vehicles extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }

        $this->load->library('form_validation');
        $this->load->model('common');
        $this->load->model('Vehicle');
        if (!checkUrlAccessForUser('VEHICLES')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index($id = null)
    {

        if ($id != "") {
            $this->vehiclelist($id);
        } else {
            $this->vehiclelist();
        }
    }

    public function vehiclelist($id = null)
    {
        $excel_uploaddata = array();
        $list_type = 0;
        $vendorIds = [];

        $company_code = $this->session->userdata('company_code') ?? '';
        $user = $this->session->userdata('user_id') ?? 0;
        $vendor = $this->session->userdata('id') ?? 0;
        $businessType = $this->session->userdata('business_type') ?? '';
        $permission = checkuserpermissions();

        $vehicleId = $this->input->post('vehicle_id', true) ?? '';
        $contact = $this->input->post('contact', true) ?? '';
        $vendorName = $this->input->post('vendor', true) ?? '';

        if ($vendorName != '') {
            $vendorIds = $this->Vehicle->getVendorIdsByName($vendorName, $company_code, $permission, $user);
        }
        $user_role_id      = (int) $this->session->userdata('user_role_id');

        if (checkAccessConditions('CID_BASED_VEHICLES_DRIVERS', $company_code) && empty($vendorName)) {
            if($user_role_id===3) {
                $userId = $this->session->userdata('id');
                $vendor = $this->db->query("SELECT code FROM tb_vendors WHERE id = ? AND status=?",[$userId,1]);
                if($vendor->num_rows() > 0)
                {
                    $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE code = ? AND company_code = ? AND status=?",[$vendor->row()->code, $company_code, 1]);
                }
            }
            else {
                $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE company_code = ? AND status=?",[$company_code, 1]);
            }

            if ($vendorsList->num_rows() > 0) {
                $vendorIds = array_column($vendorsList->result_array(), 'id');
            }
        } elseif ((int) $user_role_id === 2 && checkAccessConditions('COMPANY_CODE_WISE_GROUP_MASTERS', $company_code) && empty($vendorIds)) {
            $vendorsList = $this->common->gettbldata(["company_code"=>$company_code,"status"=>1],"id","tb_vendors",0,0);
            if ($vendorsList) {
                $vendorIds = array_column($vendorsList, 'id');
            }
        }

        if (empty($vendorIds)) {
            $vendorIds = [$vendor];
        }

        if ($id == "01") {
            $filedata = @file_get_contents("assets/ordertemplate/vehicleexceldata.txt");
            $excel_uploaddata = @json_decode($filedata);

            if (!empty($excel_uploaddata)) {
                $list_type = 1;
                @file_put_contents("assets/ordertemplate/vehicleexceldata.txt", "");
                addordertologs($filedata);
            }
        }

        $data["table_search"] = "";
        $data['page_title'] = $this->lang->line('vehicles');
        $data['sub_title'] = $this->lang->line('vehicles');
        $data['list_type'] = $list_type;

        $data["vendor"] = $this->Vehicle->getVendors($vendorIds, $company_code, $permission, $user, $businessType);
        $data["vehicledata"] = $this->Vehicle->getVehicleList($vendorIds, $company_code, $permission, $user, $businessType, $vehicleId, $contact, $vendorName);
        $data["excel_uploaddata"] = $excel_uploaddata;

        $this->newtemplate->dashboard("vehicles/vehiclesview", $data);
    }

    public function driveradd()
    {
        $data['page_title'] = $this->lang->line('vehicles');
        $data['sub_title'] = $this->lang->line('vehicles');
        $data["id"] = null;
        $data["type"] = "add";
        $data['truck_types'] = $this->db->select("id,trucktype")->get_where("tb_trucktypes",
            array("status" => "Active"));
        $this->settemplate->dashboard("vehicles/add", $data);
    }

    public function add($id = null): void
    {
        $user = $this->session->userdata('user_id');
        $data['page_title'] = $data['sub_title'] = $this->lang->line('vehicles');
        $data["id"] = $id;
        $currentDate = date('Y-m-d H:i:s');
        $data['truck_types'] = $this->common->gettbldata(["status"=>"active"],"id,trucktype","tb_trucktypes",0,0);
        $vendorId = $vehicleId = 0;
        if ($this->session->userdata("business_type") == "Carrier") {
            $vendorId = $this->session->userdata("id");
        }
        if ($id == null) {
            $data["type"] = "add";
            
            if ($_POST) {
                $this->form_validation->set_rules('register_number', 'Register Number', 'trim|required|strip_tags');
                $this->form_validation->set_rules('truck_weight', 'Truck Weight', 'trim|required|strip_tags');
                if ($this->form_validation->run() == false) {
                    $this->settemplate->dashboard("vehicles/add", $data);
                } else {
                    $post = $this->input->post(NULL,TRUE);
                    $truckData = [
                        'truck_number' =>  $post['register_number'],
                        'truck_type' => $post['truck_type'] ?? 1,
                        'truck_capacity' => null,
                        'available_type' => '',
                        'insurence' => 'Yes',
                        'route' => $post['register_number'],
                        'createdby' =>   0,
                        'updatedby' => 0,
                        'vehicle_owner' => $post['vehicle_owner'] ?? "",
                        'gpsstatus' => $post['gpsstatus'] ?? 0,
                        'track_vendor_id' => $post['track_vendor_id'] ?? 0,
                        'length_unit' => $post['length_unit'],
                        'breadth_unit' => $post['breadth_unit'],
                        'weight_unit' => $post['weight_unit'],
                        'height_unit' => $post['height_unit'],
                        'volume_unit' => $post['volume_unit'],
                        'fuel_type' => $post["fuel_type"] ?? "",
                        'register_number' => $post["register_number"] ?? "",
                        'phone' => $post["phone"] ?? "",
                        'contact_name' => $post["contact_name"] ?? "",
                        'truck_brand' => $post['truck_brand'] ?? "",
                        'length' => $post['length'] ?? 0,
                        'breadth' => $post['breadth'] ?? 0,
                        'height' => $post['height'] ?? 0,
                        'truck_weight' => (float)$post['truck_weight'],
                        'truck_volume' => (float)$post['truck_volume'],
                        'port' => "0",
                        'speedLimit' => "0",
                        'user_id' => "$user",
                        'insurestart' => $post['insurestart'] ?? date('Y-m-d'),
                        'insureexp' => $post['insureexp'] ?: date('Y-m-d'),
                        'vehicle_emission' => $post['vehicle_emission'],
                        'insuredby' => $post['insuredby'] ?? '',
                        'description' => $post['description'] ?? '',
                        'createdon' => $currentDate,
                        'updatedon' => $currentDate,
                        'vendor_id' => $vendorId
                    ];
                    unset($post['submit']);
                    unset($post['id']);
                    $checkVehicle = $this->db->query("SELECT id FROM tb_trucks_data WHERE register_number LIKE ? AND status =?",
                        [trim($post['register_number']), 'Active']);
                    if ($checkVehicle->num_rows() == 0) {
                        $post["createdon"] = $post["updatedon"] = $currentDate;
                        $vehicleId = $this->common->insertTableData("tb_trucks_data", $truckData);
                        $co2Data = [
                            'vehicle_id' => $vehicleId ?? '',
                            'fuel_consumption' => $post['fuelConsumption'],
                            'fuel_consumption_cap' => $post['fuelConsumptionCap'],
                            'fuel_consumption_net_cap' => $post['fuelConsumptionNetCap'],
                            'tank_to_wheel' => $post['tankToWheel'],
                            'well_to_wheel' => $post['wellToWheel'],
                            'tank_to_wheel_co2e' => $post['tankToWheelCo2'],
                            'well_to_wheel_co2e' => $post['wellToWheelCo2'],
                            'temp_regime_type' => $post['regimeType'],
                            'temp_regime_value' => $post['regimeValue'],
                            'createdon' => $currentDate,
                            'updatedon' => $currentDate,
                            'status' => '1'

                        ];
                        $vehicleId = $this->common->insertTableData("tb_trucks_co2_info", $co2Data);
                    } else {
                        $post["updatedon"] = $currentDate;
                        $vehicleId = $checkVehicle->row()->id;
                        $this->common->updatetbledata("tb_trucks_data", $post, ['id' => $vehicleId]);
                    }
                    if ($vendorId > 0 && $vehicleId > 0) {
                        $this->common->insertTableData("tb_vendor_vehicles", [
                            'vendor_id' => $vendorId,
                            'vehicle_id' => $vehicleId,
                            'status' => '1',
                            'createdon' => $currentDate
                        ]);
                    }
                    redirect("vehicles");
                }
            }
        } else {
            
            $data['sub_title'] = $this->lang->line('vehicles');
            $data["type"] = "edit";
            $data["vehicle"] =  $this->Vehicle->getVehicleData($id);
            $data['co2Data'] = $this->common->gettblrowdata(['status' => 1, 'vehicle_id' => $id], 'fuel_consumption,fuel_consumption_cap,fuel_consumption_net_cap,tank_to_wheel,well_to_wheel,tank_to_wheel_co2e,well_to_wheel_co2e,temp_regime_type,temp_regime_value','tb_trucks_co2_info', 0, 0);
           
            if ($data["vehicle"]->num_rows() == 0) {
                redirect("vehicles/add");
            }
            
            if ($_POST) {
                
                $this->form_validation->set_rules('register_number', 'Register Number', 'trim|required|strip_tags');
                $this->form_validation->set_rules('truck_weight', 'Truck Weight', 'trim|required|strip_tags');
                $data["type"] = "add";
                if ($this->form_validation->run() == false) {
                    $this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
                    $this->add($id);
                } else {
                    $post = $this->input->post(NULL,TRUE);
                    $checkVehicle = $this->db->query(
                        "SELECT id FROM tb_trucks_data WHERE register_number LIKE ? AND id <> ? AND status = ?",
                        [trim($post['register_number']), $id, 'Active']
                    );
                    unset($post['submit']);
                    unset($post['id']);
                    
                    if ($checkVehicle->num_rows() == 0) {
                        $gpsStatus = $post['gpsstatus'] ?? 0;
                        $trackVendorId = $post['track_vendor_id'] ?? 0;
                        if ($gpsStatus == 0) {
                            $trackVendorId = 0;
                        }
                        $truckData = [
                            'updatedon' => $currentDate,
                            'truck_number' => $post['register_number'],
                            'truck_type' => $post['truck_type'] ?? 1,
                            'truck_capacity' => null,
                            'truck_weight' => (float)$post['truck_weight'],
                            'length' => $post['length'] ?: 0,
                            'breadth' => $post['breadth'] ?: 0,
                            'height' => $post['height'] ?: 0,
                            'truck_volume' => (float)$post['truck_volume'],
                            'length_unit' => $post['length_unit'],
                            'breadth_unit' => $post['breadth_unit'],
                            'weight_unit' => $post['weight_unit'],
                            'height_unit' => $post['height_unit'],
                            'available_type' => '',
                            'insurence' => 'Yes',
                            'route' => $post['register_number'],
                            'track_vendor_id' => $trackVendorId,
                            'fuel_type' => $post["fuel_type"] ?? "",
                            'vehicle_owner' => $post['vehicle_owner'] ?? "",
                            'register_number' => $post["register_number"] ?? "",
                            'phone' => $post["phone"] ?? "",
                            'contact_name' => $post["contact_name"] ?? "",
                            'truck_brand' => $post['truck_brand'] ?? "",
                            'insurestart' => $post['insurestart'] ?? date('Y-m-d'),
                            'insureexp' => $post['insureexp'] ?? date('Y-m-d'),
                            'insuredby' => $post['insuredby'] ?? '',
                            'description' => $post['description'] ?? "",
                            'gpsstatus' => $gpsStatus,
                        ];
                        $checkVehicle = $this->db->query("SELECT register_number FROM tb_trucks_data WHERE id = ?",
                            [$id]);
                        $oldVehicle = $checkVehicle->row()->register_number;
                        if ($vendorId > 0) {
                            $checkVendorVehicle = $this->db->query("SELECT id FROM tb_vendor_vehicles WHERE vehicle_id = ? AND vendor_id = ?",
                                [$id, $vendorId]);
                            if ($checkVendorVehicle->num_rows() > 0) {
                                $this->common->updatetbledata("tb_vendor_vehicles",
                                    ['vendor_id' => $vendorId, 'vehicle_id' => $id, 'status' => '1'],
                                    ['id' => $checkVendorVehicle->row()->id]);
                            } else {
                                $this->common->insertTableData("tb_vendor_vehicles", [
                                    'vendor_id' => $vendorId,
                                    'vehicle_id' => $id,
                                    'status' => '1',
                                    'createdon' => $currentDate
                                ]);
                            }
                        }
                        
                        $this->common->updatetbledata("tb_trucks_data", $truckData, ['id' => $id]);
                        $co2Data = [
                            'fuel_consumption' => $post['fuelConsumption'],
                            'fuel_consumption_cap' => $post['fuelConsumptionCap'],
                            'fuel_consumption_net_cap' => $post['fuelConsumptionNetCap'],
                            'tank_to_wheel' => $post['tankToWheel'],
                            'well_to_wheel' => $post['wellToWheel'],
                            'tank_to_wheel_co2e' => $post['tankToWheelCo2'],
                            'well_to_wheel_co2e' => $post['wellToWheelCo2'],
                            'temp_regime_type' => $post['regimeType'],
                            'temp_regime_value' => $post['regimeValue'],
                            'updatedon' => $currentDate,
                            'status' => '1'

                        ];
                        $updateCo2 = $this->common->updatetbledata("tb_trucks_co2_info", $co2Data, ['vehicle_id' => $id]);
                        $checkShiftVehicle = $this->db->query("SELECT id,register_number FROM tb_shft_veh WHERE register_number = ?",
                            [$oldVehicle]);
                        foreach ($checkShiftVehicle->result_array() as $eachRow){
                            $this->common->updatetbledata("tb_shft_veh",
                                ['register_number' => trim($post['register_number'])], ['id' => $eachRow['id']]);
                            $this->common->insertTableData('tb_shftveh_changed_log', [
                                'old_veh' => $eachRow['register_number'],
                                'new_veh' => trim($post['register_number'])
                            ]);
                        }
                        redirect("vehicles");
                    }
                }
            }
        }
        $this->load->view("vehicles/add", $data);
    }

    public function view($id): void
    {
        $data["vehicle"] = $this->Vehicle->getVehicleData($id)->row_array();
        $data['co2Data'] = $this->common->gettblrowdata(['status' => 1, 'vehicle_id' => $id], 'fuel_consumption,fuel_consumption_cap,fuel_consumption_net_cap,tank_to_wheel,well_to_wheel,tank_to_wheel_co2e,well_to_wheel_co2e,temp_regime_type,temp_regime_value','tb_trucks_co2_info', 0, 0);

        // sanitize to prevent XSS
        $data['vehicle'] = array_map(function($item) {
            // Check if the item is a string before applying strip_tags
            return is_string($item) ? strip_tags($item) : $item;
        }, $data['vehicle']);
        $data['vehicle'] = array_map(function($item) {
            // Check if the item is a string before applying strip_tags
            return is_string($item) ? htmlspecialchars($item) : $item;
        }, $data['vehicle']);
        //$data['vehicle'] = array_map( 'strip_tags', $data['vehicle']);
        //$data['vehicle'] = array_map( 'htmlspecialchars', $data['vehicle']);

        $data['page_title'] = $this->lang->line('vehicles');
        $data['sub_title'] = $this->lang->line('vehicles');

        $this->load->view("vehicles/view", $data);
    }

    public function delete($id = null)
    {
        if ($id == null) {
            redirect("vehicles");
        } else {
            if ($id != '0') {
                $this->common->updatetbledata('tb_trucks_data', ["status"=> "Inactive"],["id" =>$id]);
                $this->common->updatetbledata('tb_trucks_co2_info', ["status"=> 0],["vehicle_id" =>$id]);
            }
            redirect("vehicles");
        }
    }

    public function getVendors()
    {
        $term = $this->input->post('term');
        $user = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        if ($this->session->userdata('business_type') == "Carrier") {
            $vendor = $this->session->userdata('id');
            $data["vendor"] = $this->db->query("select id,name from tb_vendors where id = '$vendor' AND user_id=$user and status=1 AND name LIKE '%" . $term . "%'")->result();
        } else {
            $data["vendor"] = $this->db->query("select id,name from tb_vendors where company_code='" . $company_code . "' and status=1 AND name LIKE '%" . $term . "%'")->result();
        }
        foreach ($data["vendor"] as $res){
            $check = "<input type='radio' name='listvendor' id='listvendor_" . $res->id . "' class='listvendor' onchange='selectvendor(" . $res->id . ")' value='" . $res->name . "'>";
            $result[] = array('check' => $check, 'id' => $res->id, 'name' => $res->name);
        }
        echo json_encode($result);
    }

    public function parse()
    {
        $data = array();
        $data["status"] = "";
        if ($_FILES["file"]["error"] == 4) {
            $data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
    <strong>Warning!</strong> Please Select File before Submitting.
</div>
</div>
</div>
EOT;
        } else {
            if ($_FILES) {
                $file = $_FILES['file'];
                //load the excel library
                $ext = pathinfo($file["name"], PATHINFO_EXTENSION);
                if ($ext == "xls" || $ext == "xlsx") {
                    $this->load->library('excel');
                    //read file from path
                    try {
                        $objPHPExcel = @PHPExcel_IOFactory::load($file["tmp_name"]);
                        //get only the Cell Collection
                        $cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
                        //extract to a PHP readable array format
                        if (count($objPHPExcel->setActiveSheetIndex(0)->toArray()[0]) == "4") {
                            foreach ($cell_collection as $cell){
                                $column = $objPHPExcel->getActiveSheet()->getCell($cell)->getColumn();
                                $row = $objPHPExcel->getActiveSheet()->getCell($cell)->getRow();
                                $data_value = $objPHPExcel->getActiveSheet()->getCell($cell)->getValue();

                                //header will/should be in row 1 only.
                                if ($row == 1) {
                                    $data["header"][$row][$column] = $data_value;
                                } else {
                                    $data["arr_data"][$row][$column] = $data_value;
                                }
                            }
                        } else {
                            $data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
    <strong>Warning!</strong> Uploaded File is not valid, Please choose appropiate File.
</div>
</div>
</div>
EOT;
                        }
                    } catch (Exception $ex) {
                        $data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
    <strong>Warning!</strong> Uploaded File is not valid, Please choose appropiate File.
</div>
</div>
</div>
EOT;
                    }

                } else {
                    $data["status"] = <<<EOT
<div class="row">
<div class="col-md-12">
<div class="alert alert-danger">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
    <strong>Warning!</strong> Uploaded File is not valid, Please choose appropiate File.
</div>
</div>
</div>
EOT;
                }
            }
        }
        echo $this->load->view("excel_parse", $data, true);
    }

    public function uploadpopup()
    {
        return $this->load->view("upload_popup", true);
    }

    public function savedata()
    {
        if ($_POST) {
            $data = $this->input->post(NULL,TRUE);
            print_r($data);
            exit;
            foreach ($data as $d){
                $em = getEmployee($d['C']);
                $emp = $em->id;
                $veh = getVehicle($d['B']);
                $svid = $this->getshftvehid($d['A'], $veh);

            }
            $s = array();
            foreach ($data as $d){
                array_push($s, $d["A"]);
            }
            $shifts = array_unique($s);
            sort($shifts);
            $v = array();
            foreach ($shifts as $s){
                foreach ($data as $d){
                    if ($s == $d["A"]) {
                        array_push($v, $d["A"] . "," . $d["B"]);
                    }
                }
            }
            $vehs = array_unique($v);
            sort($vehs);
            $e = array();
            foreach ($vehs as $v){
                $va = explode(",", $v);
                $sql1 = $this->db->where(array(
                    "shft_id" => $va[0],
                    "register_number" => $va[1],
                    "status" => "1"
                ))->order_by("id", "desc")->get("tb_shft_veh");
                if ($sql1->num_rows() > 0) {
                    $v = $sql1->row()->id;
                } else {
                    $this->db->insert("tb_shft_veh", array(
                        "user_id" => $this->session->userdata("user_id"),
                        "shft_id" => $va[0],
                        "register_number" => $va[1],
                        "created_on" => date("Y-m-d H:i:s"),
                        "status" => "1"
                    ));
                    $v = $this->db->insert_id();
                }
                foreach ($data as $d){
                    if ($va[0] == $d["A"] && $va[1] == $d["B"]) {
                        array_push($e, $v . "," . $d["C"] . ",", $d["D"] . ",", $d["A"]);
                    }
                }
            }
            $emps = array_unique($e);
            sort($emps);
            foreach ($emps as $v){
                $va = explode(",", $v);
                print_r($va);
                exit;
                $em = getEmployee($va[1]);
                $va[1] = $em->id;
                $date = date("Y-m-d H:i:s");
                $sql1 = $this->db->query("select * from tb_shft_veh_emp e,tb_shft_veh v where e.shft_veh_id=v.id and v.shft_id=" . $va[3] . " and e.emp_id=" . $va[1] . " and v.status='1' and e.status='1'");
                //$sql1=$this->db->where(array("shft_veh_id" => $va[0], "emp_id" => $va[1], "status" => "1"))->order_by("id","desc")->get("tb_shft_veh_emp");
                if ($sql1->num_rows() > 0) {
                    //$this->db->where(array("shft_veh_id" => $va[0], "emp_id" => $va[1], "status" => "1"))->update("tb_shft_veh_emp",array("status"=>'0'));
                    $this->db->query("update tb_shft_veh_emp e,tb_shft_veh v set e.status='0',e.updated_on='" . $date . "' where e.shft_veh_id=v.id and v.shft_id=" . $va[3] . " and e.emp_id=" . $va[1] . " and v.status='1' and e.status='1'");
                }
                $this->db->insert("tb_shft_veh_emp", array(
                    "user_id" => $this->session->userdata("user_id"),
                    "shft_veh_id" => $va[0],
                    "emp_id" => $va[1],
                    "created_on" => date("Y-m-d H:i:s"),
                    "status" => "1",
                    "priority" => $va[2]
                ));
            }
            echo "1";
        }
    }

    public function downloadreport()
    {
        $shifts = 'SELECT s.id as Shift_ID,splace as Shift_Start_Place,stime as Start_Time,eplace as Shift_End_Place,etime as End_Time,v.register_number as Vehicle,em.name as Employee_Name,em.pickup as Pickup_Location,em.drop as Dropping_Location FROM tb_employee em,tb_shifts s,tb_shft_veh v,tb_shft_veh_emp e where s.user_id=' . $this->session->userdata("user_id") . ' AND s.id=v.shft_id AND v.id=e.shft_veh_id AND s.status="1" AND v.status="1" AND e.status="1" AND e.emp_id=em.id';
        $sql = $this->db->query($shifts);
        $this->load->dbutil();
        $this->load->helper('file');
        $this->load->helper('download');
        $delimiter = ",";
        $newline = "\r\n";
        $file = 'Shifts' . date("Ymdhis") . '.csv';
        $data = $this->dbutil->csv_from_result($sql, $delimiter, $newline);
        force_download($file, $data);
        header('Content-Type: application/csv');
    }

    public function dashboard()
    {
        $data1["page_title"] = "Trips";
        $data1["sub_title"] = "Dashboard";
        $this->settemplate->dashboard("shift/dashboard", $data1);
    }

    public function ajaxdashboard()
    {
        $user = $this->session->userdata("user_id");
        $vehs = $this->db->where("user_id", $user)->where("status", "Active")->get("tb_trucks_data");
        $now = date("H.i");
        $date = date("Y-m-d H:i:s");
        if ($vehs->num_rows() > 0) {
            foreach ($vehs->result() as $v){
                $temp = array();
                $temp["vehicle"] = $v->register_number;
                $trips = $this->db->query("select t.id as tripid,t.stime,t.etime,t.splace,t.eplace,d.name,d.contact_num,s.shipmentid from tb_trips t,tb_shifts s,tb_truck_drivers d where t.driver_id=d.id and s.id=t.shift_id and t.vehicle_id=$v->id and t.status='1'");
                $temp["next_shift"] = $temp["employee"] = $temp["type"] = $temp["driver"] = $temp["time"] = $temp["live"] = $temp["trip"] = "N/A";
                if ($trips->num_rows() > 0) {
                    foreach ($trips->result() as $t){
                        $temp["driver"] = $t->name . " -" . $t->contact_num;
                        $temp["trip"] = explode(",", $t->splace)[0] . " - " . explode(",", $t->eplace)[0];
                        $temp["vehicle"] = "<a href='" . base_url("shift/mapview/" . $v->id) . "' target='_blank'>$v->register_number</a>";
                        $tm = getClosest($now, array($t->stime, $t->etime));
                        if ($tm == $t->stime) {
                            $temp["type"] = "Normal";
                            $temp["time"] = date("h:i A", strtotime($t->stime));
                        } else {
                            $temp["type"] = "Return";
                            $temp["time"] = date("h:i A", strtotime($t->etime));
                        }
                        if ($v->latitude != "") {
                            $temp["live"] = getLocationName($v->latitude, $v->longitude);
                        } else {
                            $temp["live"] = "";
                        }

                        $emp = $this->db->select("te.id,e.order_id,te.status as emp_st")->where("te.trip_id",
                            $t->tripid)->where("te.employee_id=e.id")->order_by("te.stime",
                            "desc")->limit(1)->get("tb_trip_employee te,tb_employee e");
                        if ($emp->num_rows() > 0) {
                            $temp["employee"] = "<span style='color:red;'>" . $emp->row()->order_id . "</span>";
                            if ($emp->row()->emp_st == "1") {
                                $temp["employee"] = "<span style='color:black;'>" . $emp->row()->order_id . "</span>";
                            }

                        }
                    }
                }
                $shifts = $this->db->query("SELECT T.*,(SELECT CONCAT(td.id,'@@',td.name,'@@',td.contact_num) FROM tbl_assigned_drivers a,tb_truck_drivers td WHERE a.driver_id = td.id AND a.vehicle_id=t.id AND a.from_time<= CONCAT(CURDATE(),' ', REPLACE(T.time, '.', ':'),':00') AND a.to_time >= CONCAT(CURDATE(),' ', REPLACE(T.time, '.', ':'),':00') AND a.status='1') AS driver_info FROM ( SELECT id,user_id,stime AS TIME,splace,slat,slng,eplace,elat,elng, STATUS,'1' AS TYPE FROM `tb_shifts` UNION ALL SELECT id,user_id,etime AS TIME,eplace AS splace,elat AS slat,elng AS slng,splace AS eplace,slat AS elat,slng AS elng, STATUS,'0' AS TYPE FROM `tb_shifts`) T,tb_shft_veh s,tb_trucks_data t WHERE T.time>=$now AND s.register_number=t.register_number AND s.register_number='$v->register_number' AND s.shft_id=T.id AND s.status='1' ORDER BY T.time ASC");
                if ($shifts->num_rows() > 0) {
                    $temp["next_shift"] = explode(",", $shifts->row()->splace)[0] . " - " . explode(",",
                            $shifts->row()->eplace)[0] . "[" . $shifts->row()->TIME . "]";
                }
                $temp = array_values($temp);
                $data1["data"][] = $temp;
            }
        }
        echo json_encode($data1);
    }

    public function mapview($veh = null)
    {
        if ($veh != null) {
            $d["loc"] = $this->db->query("select latitude as lat,longitude as lng,receivedon as time from tb_trucks_data where id='$veh' limit 1")->result_array();
            $this->settemplate->dashboardtemp("mapview", $d);
        }
    }

    public function checkduplicate()
    {
        //$id1=$this->uri->segment (3);
        $post = $this->input->post(NULL,TRUE);
        extract($post);

        $id = isset($id) ? $id : "";
        $register_number = isset($register_number) ? $register_number : "";
        $where = array(
            'register_number' => $register_number,
            'status' => 'Active'
        );
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'register_number', 'tb_trucks_data', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }


    public function checkduplicatephone()
    {

        $post = $this->input->post(NULL,TRUE);
        extract($post);

        $id = isset($id) ? $id : "";
        $phone = isset($phone) ? $phone : "";
        $where = array(
            'phone' => $phone,
            'status' => 'Active'
        );
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'phone', 'tb_trucks_data', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }

    public function uploadvehicleexcel()
    {
        try {
            if ($this->session->userdata('company_code') == "SG") {
                $company_code = "SGKN";
            } else {
                $company_code = $this->session->userdata('company_code');
            }
            $branch_code = $this->session->userdata('branch_code');
            $data["createdon"] = $todaydate = date("Y-m-d H:i:s");
            $data["user_id"] = $data["createdby"] = $user_id = $this->session->userdata('user_id');
            if ($this->session->userdata("business_type") == "Carrier") {
                $id = $this->session->userdata("id");
                $data["vendor_id"] = $id;
            }

            if ($_FILES['import_file']['size'] > 0) {
                $inputFilename = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($inputFilename);
                $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                for ($i = 2; $i <= count($sheetData); $i++){
                    $data['register_number'] = $register_number = isset($sheetData[$i]['A']) ? $sheetData[$i]['A'] : "";
                    $data['contact_name'] = $contact_name = isset($sheetData[$i]['B']) ? $sheetData[$i]['B'] : "";
                    $data['phone'] = $phone = isset($sheetData[$i]['C']) ? $sheetData[$i]['C'] : "";
                    $truck_type = isset($sheetData[$i]['D']) ? $sheetData[$i]['D'] : "";
                    $data['length'] = $length = isset($sheetData[$i]['E']) ? $sheetData[$i]['E'] : "";
                    $data['length_unit'] = $length_unit = isset($sheetData[$i]['F']) ? $sheetData[$i]['F'] : "";
                    $data['breadth'] = $breadth = isset($sheetData[$i]['G']) ? $sheetData[$i]['G'] : "";
                    $data['breadth_unit'] = $breadth_unit = isset($sheetData[$i]['H']) ? $sheetData[$i]['H'] : "";
                    $data['height'] = $height = isset($sheetData[$i]['I']) ? $sheetData[$i]['I'] : "";
                    $data['height_unit'] = $height_unit = isset($sheetData[$i]['J']) ? $sheetData[$i]['J'] : "0";
                    $data['truck_weight'] = $truck_weight = isset($sheetData[$i]['K']) ? $sheetData[$i]['K'] : "";
                    $data['weight_unit'] = $weight_unit = isset($sheetData[$i]['L']) ? $sheetData[$i]['L'] : "";

                    $data['truck_volume'] = $truck_volume = isset($sheetData[$i]['M']) ? $sheetData[$i]['M'] : "";

                    $data['volume_unit'] = $volume_unit = isset($sheetData[$i]['N']) ? $sheetData[$i]['N'] : "";

                    $data['insuredby'] = $insuredby = isset($sheetData[$i]['O']) ? $sheetData[$i]['O'] : "";
                    $data['insurestart'] = $insurestart = isset($sheetData[$i]['P']) ? $sheetData[$i]['P'] : $todaydate;
                    $data['insureexp'] = $insureexp = isset($sheetData[$i]['Q']) ? $sheetData[$i]['Q'] : $todaydate;
                    $data['truck_brand'] = $truck_brand = isset($sheetData[$i]['R']) ? $sheetData[$i]['R'] : "";
                    $data['fuel_type'] = $fuel = isset($sheetData[$i]['S']) ? $sheetData[$i]['S'] : "";
                    $data['truck_number'] = $truck_number = isset($sheetData[$i]['T']) ? $sheetData[$i]['T'] : $data['register_number'];
                    $line_no = $i - 1;
                    if ($data['register_number'] != "" && $data['contact_name'] != "" && $data['phone'] != "" && $truck_type != "" && $data['length'] != "" && $data['breadth'] != "" && $data['height'] != "" && $data['truck_weight'] != "" && $data['truck_volume'] != "" && $fuel != "") {


                        $gettruckdata = $this->db->query("select id,trucktype from tb_trucktypes  where trucktype='" . $truck_type . "' AND status='Active'");

                        if ($gettruckdata->num_rows() > 0) {
                            foreach ($gettruckdata->result_array() as $row){
                                $data['truck_type'] = $row['id'];
                            }
                        } else {
                            $teruckdata2 = array(
                                "trucktype" => $truck_type,
                                "description" => $truck_type,
                                "user_id" => $user_id,
                                "company_code" => $company_code,
                                "branch_code" => $branch_code,
                                "createdby" => $user_id,
                                "createdon" => $data["createdon"]
                            );
                            $ins = $this->db->insert("tb_trucktypes", $teruckdata2);
                            $data['truck_type'] = $this->db->insert_id();
                        }


                        $gettruckdata = $this->db->select('id')->get_where("tb_trucks_data",
                            array('register_number' => $register_number, 'status' => 'Active'));
                        if ($gettruckdata->num_rows() > 0) {
                            $excel_sorders[] = array(
                                'line_no' => $line_no,
                                'register_number' => $register_number,
                                'contact_name' => $contact_name,
                                'phone' => $phone,
                                'truck_type' => $truck_type,
                                'status' => 'Already Register Number Exists'
                            );
                        } else {
                            $gettruckdata = $this->db->select('id')->get_where("tb_trucks_data",
                                array('phone' => $phone, 'status' => 'Active'));
                            if ($gettruckdata->num_rows() > 0) {
                                $excel_sorders[] = array(
                                    'line_no' => $line_no,
                                    'register_number' => $register_number,
                                    'contact_name' => $contact_name,
                                    'phone' => $phone,
                                    'truck_type' => $truck_type,
                                    'status' => 'Already Phone Number Exists'
                                );
                            } else {

                                $ins = $this->db->insert("tb_trucks_data", $data);
                                if ($ins) {
                                    $excel_sorders[] = array(
                                        'line_no' => $line_no,
                                        'register_number' => $register_number,
                                        'contact_name' => $contact_name,
                                        'phone' => $phone,
                                        'truck_type' => $truck_type,
                                        'status' => 'Success'
                                    );
                                } else {
                                    $excel_sorders[] = array(
                                        'line_no' => $line_no,
                                        'register_number' => $register_number,
                                        'contact_name' => $contact_name,
                                        'phone' => $phone,
                                        'truck_type' => $truck_type,
                                        'status' => 'Failed'
                                    );
                                }

                            }
                        }


                    } else {
                        $excel_sorders[] = array(
                            'line_no' => $line_no,
                            'register_number' => $register_number,
                            'contact_name' => $contact_name,
                            'phone' => $phone,
                            'truck_type' => $truck_type,
                            'status' => 'Failed'
                        );
                    }


                }
            }
            if (!empty($excel_sorders)) {
                @file_put_contents("assets/ordertemplate/vehicleexceldata.txt", json_encode($excel_sorders));
            }

            redirect('Vehicles/index/01');


        } catch (\Exception $e) {
            echo $e->getMessage();
        }


    }

    public function getVehicleEmission()
    {
        $truck_weight = $this->input->post('truck_weight');
        $weight_unit = $this->input->post('weight_unit');
        if ($weight_unit == 'Tons') {
            $truck_weight = $truck_weight * 1000;
        }
        $this->db->select('weight_range_from,weight_range_to,class_type');
        $this->db->from("tb_vehicle_emission_data");
        $query = $this->db->get();
        $res = $query->result_array();
        $response = '';
        foreach ($res as $row){
            if ($row['weight_range_from'] < $truck_weight && $row['weight_range_to'] >= $truck_weight) {
                $response = array('success' => true, 'result' => $row['class_type']);
            }
        }
        echo json_encode($response);
    }
}
