<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Vendor extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('user_id') == "") {
			redirect('login');
		}
	}

	public function index()
	{
		$data["page_title"]="vendor";
		$data["sub_title"]="view";
		$limit=10;
		$user_id=$this->session->userdata('user_id');
		$tot="select * from tb_vendors where user_id=$user_id and status=1";
		$st="";
		if(isset($_GET) && count($_GET)>0){
			$st=$this->input->get("table_search",true);
			$tot.=" and (name like '%$st%' or mobile like '%$st%' or email like '%$st%' or address like '%$st%')";
		}
		$total=$this->db->query($tot)->num_rows();
		$val =($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
		if($val=="" || $val ==null || $val=='0'){
			$val=0;
		}
		$sql=$tot." order by id desc limit ".$val.", $limit";
		$this->load->library('pagination');
		$config['base_url'] = base_url('vendor/index');
		if(strlen($st)>0)
			$config['suffix'] = '?'.http_build_query(array("table_search"=>$st),'',"&amp;");
	    $config['total_rows'] = $total;
	    $config['per_page'] = $limit;
	    $data["vendors"]=$this->db->query($sql);
	    $this->pagination->initialize($config);
	    $data["links"]=$this->pagination->create_links();
		$this->settemplate->dashboard("vendor/index", $data);
	}
	public function create($id=null)
	{
		if($id==null){
			$data["page_title"]="vendor";
			$data["sub_title"]="create";
			$data["id"]="";
			$data["name"]="";
			$data["mobile"]="";
			$data["email"]="";
			$data["address"]="";
		}else{
			$data["page_title"]="vendor";
			$data["sub_title"]="edit";
			$data["id"]=$id;
			$vendor=$this->db->where(array("id"=>$id))->get("tb_vendors");
			if($vendor->num_rows()>0){
				$data["name"]=$vendor->row()->name;
				$data["mobile"]=$vendor->row()->mobile;
				$data["email"]=$vendor->row()->email;
				$data["address"]=$vendor->row()->address;
			}else{
				redirect(base_url("vendor"));
			}
		}
		$this->settemplate->dashboard("vendor/create", $data);
	}
	public function add($id=null){
		$data["page_title"]="Carrier";
		$data["sub_title"]="New";
		$data["id"]=$id;
		if($id != ""){
			$vendor=$this->db->where(array("id"=>$id))->get("tb_vendors");
			if($vendor->num_rows()>0){
				$data["name"]=$vendor->row()->name;
				$data["mobile"]=$vendor->row()->mobile;
				$data["email"]=$vendor->row()->email;
				$data["address"]=$vendor->row()->address;
				$data["offering_type"]=$vendor->row()->offering_type;
				$data["carrier_grade"]=$vendor->row()->carrier_grade;
				$data["effective_date"]=$vendor->row()->effective_date;
				$data["expiry_date"]=$vendor->row()->expiry_date;
				$data["service_id"]=$vendor->row()->service_id;
				$data["service_name"]=$vendor->row()->service_name;
			}
		}
		$user_id=$this->session->userdata('user_id');
		$this->settemplate->dashboard("vendor/add", $data);
	}

	public function getcarriersbyusr(){
		$user_id=$this->session->userdata('user_id');
		$data["carriers"] = array();
		if($user_id != ""){
			$carriers=$this->db->query("SELECT id, name, mobile, email, address, offering_type, effective_date, expiry_date FROM tb_vendors WHERE user_id='$user_id' AND status=1");
			if($carriers->num_rows()>0){
				$data["carriers"] = $carriers->result_array();
			}
		}
		echo json_encode($data);
	}

	public function save($id=null)
	{
		$data=$this->input->post();
		unset($data["id"]);
		$this->load->library('form_validation');
		$this->form_validation->set_rules('mobile', 'Mobile Number', 'trim|required|callback_validate_member['.$id.']');
		if ($this->form_validation->run() == TRUE){
			if($id==null){
				$data["password"]=password_hash(rand(100000,999999), PASSWORD_DEFAULT);
				$data["created_on"]=date("Y-m-d H:i:s");
				$data['company_code'] = $this->session->userdata('company_code');
				$data['branch_code'] = $this->session->userdata('branch_code');
				$data["user_id"] = $this->session->userdata('user_id');
				$this->db->insert("tb_vendors",$data);
			}else{
				$this->db->where(array("id"=>$id))->update("tb_vendors",$data);
			}
			redirect(base_url("vendor"));
		}else{
			$this->form_validation->set_error_delimiters('<div class="alert alert-danger"><a href="#" class="close" data-dismiss="alert">&times;</a>', '</div>');
			$this->create($id);
		}
	}

	public function saveCarrier($id=null)
	{
		$data=$this->input->post();
		$autoaccept = isset($_POST['autoaccept']) ? $_POST['autoaccept'] : '0';
		unset($data["id"]);
		unset($data["autoaccept"]);
		$res = $this->checkNumber($this->input->post("mobile"),$id);
		if ($res == TRUE){
			if($id==null){
				$data["password"]= password_hash(rand(100000,999999), PASSWORD_DEFAULT);
				$data["created_on"]=date("Y-m-d H:i:s");
				$data["user_id"]=$this->session->userdata('user_id');
				$this->db->insert("tb_vendors",$data);
				$carrier_id = $this->db->insert_id();
				if($autoaccept == '1'){
					$r = $this->updatecarrierautoaccept($carrier_id);
				}
				echo json_encode(array("status"=>"1","carrier_id"=>$this->db->insert_id()));
			}else{
				$upd = $this->db->where(array("id"=>$id))->update("tb_vendors",$data);
				if($autoaccept == '0'){
					$upd = $this->db->where(array('vendor_id'=>$id))->update("tb_vendor_rules",array('status'=>'1','autoaccept'=>'0'));
				}if($autoaccept == '1'){
					$r = $this->updatecarrierautoaccept($id);
				}
				echo json_encode(array("status"=>"1","carrier_id"=>$id));
			}
		}else{
			echo json_encode(array("status"=>"0","message"=>"Carrier Mobile already exists!"));
		}
	}

	public function updatecarrierautoaccept($carrier_id){
		$cdate = date('Y-m-d H:i:s');
		$user_id = $this->session->userdata('user_id');
		$get_codes = $this->db->select('company_code,branch_code')->get_where("tb_users",array('id'=>$user_id));
		$branch_code = $company_code = "";
		if($get_codes->num_rows() >0){
			$company_code = $get_codes->row()->company_code;
			$branch_code = $get_codes->row()->branch_code;
		}
		$rules = array('vendor_id'=>$carrier_id,'company_code'=>$company_code,'branch_code'=>$branch_code,
		'user_id'=>$user_id,'createdon'=>$cdate,'rule_status'=>'Direct','status'=>1,'autoaccept'=>1);
		$chk = $this->db->select('id')->get_where("tb_vendor_rules",array('vendor_id'=>$carrier_id,'company_code'=>$company_code,
		'branch_code'=>$branch_code,'user_id'=>$user_id));
		if($chk->num_rows() == 0){
			$ins = $this->db->insert("tb_vendor_rules",$rules);
		}else{
			$rule_id = $chk->row()->id;
			$upd = $this->db->where(array('id'=>$rule_id))->update("tb_vendor_rules",array('status'=>'1','autoaccept'=>1));
		}
	}

	public function editCarrier(){
		$carrier_id = $this->input->post("carrier_id");
		$data["carrier"]=$this->db->query("select * from tb_vendors where id=$carrier_id")->row_array();
		$data["carrier_autoaccept"]=array();
		$qry = $this->db->query("select * from tb_vendor_rules where vendor_id=$carrier_id");
		if($qry->num_rows()>0){
			$data["carrier_autoaccept"]=$qry->row_array();
		}
		echo json_encode($data);
	}

	public function assign()
    {
		$data=$this->input->post();
		$vehicle_id = $data["vehicle_id"];
		$vendor_id = $data["vendor_id"];

		if($vehicle_id != "" && $vendor_id != "") {
			$this->db->where(array("id"=>$vehicle_id))->update("tb_trucks_data",array("vendor_id"=>$vendor_id));

            $this->load->model('Vendors');
            $this->Vendors->updateDriver($vendor_id, $vehicle_id);

            $chk1 = $this->db->select("id")->get_where("tb_vendor_vehicles",array("vehicle_id"=>$vehicle_id,"vendor_id <>"=>$vendor_id,"status"=>1),1,0);
			if($chk1->num_rows()>0){
				$vid=$chk1->row()->id;
				$this->db->where(array("id"=>$vid))->update("tb_vendor_vehicles",array("status"=>0));
			}
			$chk = $this->db->select("id")->get_where("tb_vendor_vehicles",array("vendor_id"=>$vendor_id,"vehicle_id"=>$vehicle_id),1,0);
			if($chk->num_rows()>0){
				$vid=$chk->row()->id;
				$this->db->where(array("id"=>$vid))->update("tb_vendor_vehicles",array("vendor_id"=>$vendor_id,"vehicle_id"=>$vehicle_id,"status"=>1));
			}else{
				$ins=array("vendor_id"=>$vendor_id,"vehicle_id"=>$vehicle_id,"status"=>1);
				$this->db->insert("tb_vendor_vehicles",$ins);
			}
		}
		echo "1";
	}
	function validate_member($str,$id)
	{
	   	$sql=$this->db->where(array("mobile"=>$str,"status"=>"1","id!="=>$id))->get("tb_vendors");
	   	if($sql->num_rows()==0){
	     	return TRUE;
	   	}
	   	else{
	   		$this->form_validation->set_message('validate_member','Mobile number already exists!');
	     	return FALSE;
	   	}
	}
	function checkNumber($str,$id){
		$sql=$this->db->where(array("mobile"=>$str,"status"=>"1","id!="=>$id))->get("tb_vendors");
	   	return $sql->num_rows()==0;
	}
	function delete($id){
		$this->db->where(array("id"=>$id))->update("tb_vendors",array("status"=>"0"));
	}
	public function sendPassword($id){
		$this->load->library("sms");
        $data=$this->db->select("name,mobile,password")->where("id",$id)->get("tb_vendors")->row_array();
        $params=array();
        $pwd=(($data["password"]));
        $params['mobile']=$data["mobile"];
        $params['module']="Driver Account Confirmation";
        $params['message']="Dear ".$data["name"].", Your ".$data["mobile"]." as LoginID and Password is ".$pwd.", You can login into http://vendor.trac247.in/ for more details";
        $params['user_id']=$this->session->userdata("user_id");
        $this->sms->send($params);
    }
    public function getCarrierRates(){
    	$carrier_id = $this->input->post("carrier_id");
		$data["rates"] = $this->db->query("SELECT * from tb_carrier_rates where carrier_id=$carrier_id and status=1")->result_array();
		echo json_encode($data);
    }
    public function editRates(){
    	$rate_id = $this->input->post("rate_id");
		$data["rate"]=$this->db->query("select * from tb_carrier_rates where id=$rate_id")->row_array();
		echo json_encode($data);
    }
    public function saveCarrierRate($id=null){
    	if($id==null){
			$data["carrier_id"]=$this->input->post("carrier_id");
			$data["name"]=$this->input->post("name");
			$data["lane_id"]=$this->input->post("lane_id");
			$data["vehicle_group"]=$this->input->post("vehicle_group");
			$data["fleet_size"]=$this->input->post("fleet_size");
			$this->db->insert("tb_carrier_rates",$data);
			echo json_encode(array("status"=>"1","message"=>"Carrier Rate Added Successfully!"));
		}else{
			$data["carrier_id"]=$this->input->post("carrier_id");
			$data["name"]=$this->input->post("name");
			$data["lane_id"]=$this->input->post("lane_id");
			$data["vehicle_group"]=$this->input->post("vehicle_group");
			$data["fleet_size"]=$this->input->post("fleet_size");
			$this->db->where(array("id"=>$id))->update("tb_carrier_rates",$data);
			echo json_encode(array("status"=>"1","message"=>"Carrier Rate Updated Successfully!"));
		}
    }
}
