<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";


class Vndailyordersreport extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('vnordersdailyreportmodel');
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');
    }

    public function getpastthreedeliveriesdata(){
        $company_code = "VNKN";
        $curtz = "Asia/Ho_Chi_Minh";
        $default_timezone ="UTC";
        $orders = array();
        $fromdate = date('Y-m-d',strtotime("-3 days"));
        $todate = date('Y-m-d',strtotime("-1 days"));
        $orderTableCondition = $whr = array();
        $customerIdCondition = "";
        $selectColumns = array('v.name as vendor_name,o.id,o.order_id,o.pickup_datetime,o.drop_endtime as delivery_datetime,o.pickup_company as pickup,o.delivery_company as delivery,o.delivery_city,o.transport_mode,o.company_code,o.branch_code,o.shipment_id,o.status,o.trip_sts,o.shift_id,o.trip_id,o.createdon as created_date,o.shipmentid as shipmentid,o.createdon,o.created_source,o.parent_id,s.createdon as delivered_time,cust.name as customer_name');
            $table_name='tb_orders o';
            $indexColumn='o.id';
            $groupBy='o.id';
            $excludeCountQuery='Yes';
            $whr["DATE_FORMAT(o.drop_endtime,'%Y-%m-%d') >="] = $fromdate;
            $whr["DATE_FORMAT(o.drop_endtime,'%Y-%m-%d') <="] = $todate;
            if(!empty($whr)){
                foreach($whr as $key=>$value){
                    $value="'$value'";
                    $orderTableCondition[]= $key.$value;
                }
            }
            $orderTableCondition[]= "o.company_code LIKE '".$company_code."'";
            $orderTableCondition[]= "o.status!= 0";
            $orderTableCondition[]= "o.trip_sts =0";
            $orderTableWhere= implode(' AND ',$orderTableCondition);
            if($orderTableWhere!=''){
                $orderTableWhere=" and $orderTableWhere ";
            }
            $wherecondition= $indexColumn."!='' ".$orderTableWhere;
            $dataTableSortOrdering=array();
            $joinsArray[]=array('table_name'=>'tb_stop_status as s','condition'=>"s.order_id=o.id AND s.status_code ='3000' AND s.status ='1'",'join_type'=>'left');
            $joinsArray[]=array('table_name'=>'tb_vendors as v','condition'=>"v.id=o.vendor_id AND v.status ='1'",'join_type'=>'left');
            $joinsArray[]=array('table_name'=>'tb_customers as cust','condition'=>"cust.id=o.customer_id AND cust.status ='1'",'join_type'=>'left');
            $getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST');
            $reqData=array('id');
            $formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);

            if(isset($formattedData['commaSeparated']['id'])){
                $codes="'DQ','XSR'";
                $formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$codes);
                $formattedData=$this->DataQueryFormatter_model->getAllRevenueDetailsForOrders($formattedData['commaSeparated']['id'],$formattedData);
                $formattedData=$this->DataQueryFormatter_model->getPODDelivered($formattedData['commaSeparated']['id'],$formattedData);
            }
            $getRecordListing=array();
            if(isset($formattedData['orders'])){
                $getRecordListing=$formattedData['orders'];
                krsort($getRecordListing);
            }
            if(!empty($getRecordListing)){
                $invoiced_bu_jfr=$billed_bu_jfr='';
                $revenueDataArray=array();
                $html = $debtor_jfr = "";
                foreach($getRecordListing as $res){
                   $delivery_note = $salog_ref = $referenceData  = "";
                    if (isset($res['reference_value'])) {
                        $referenceData = $res['reference_value'];
                    }
                    if($referenceData != ""){
                        $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                        if (isset($arrayData['DQ'])) {
                            $delivery_note = $arrayData['DQ'];
                        }
                        if (isset($arrayData['XSR'])) {
                            $salog_ref = $arrayData['XSR'];
                        }
                    }
                    $pod_available = $pod_sts = $status = "";
                    if(isset($res['pod_available'])){
                        if ( $res['pod_available'] != "" && $res['pod_available'] != "0000-00-00 00:00:00" ) {
                            $podavailable = getdatetimebytimezone( $curtz, $res['pod_available'], $default_timezone );
                            $pod_available = date('Y-m-d h:i A',strtotime($podavailable['datetime']));
                        }
                    }
                    if($pod_available != ""){
                        $pod_sts = date('Y-m-d h:i A',strtotime($pod_available));
                    }
                    $rev=$cost=array();
                    if(isset($res['revenue_details'])){
                        if($res['revenue_details']!=''){
                            $rev=$cost=array();
                            $invoiceDataArray = explode('+++++', $res['revenue_details']);
                            foreach ($invoiceDataArray as $eachInvoice) {
                                $invoiceData = $this->giveInvoiceParameters($eachInvoice);
                                if (!empty($invoiceData)) {
                                    $invdebtor_jfr = isset($invoiceData['debtor_jfr']) ? $invoiceData['debtor_jfr'] : "";
                                    if($invdebtor_jfr != ""){
                                        $debtor_jfr = $invdebtor_jfr;
                                    }
                                    $invoice_status = isset($invoiceData['invoice_status']) ? $invoiceData['invoice_status'] : "";
                                    $recipient_name = isset($invoiceData['recipient_name']) ? $invoiceData['recipient_name'] : "";
                                    $amount = isset($invoiceData['amount']) ? $invoiceData['amount'] : "0";
                                    if ($invoice_status == '0') {
                                        $status = 'To be billed';
                                    }
                                    if ($invoice_status == '1' || $invoice_status == '2') {
                                        $status = 'Ready To Invoice';
                                    }
                                    if ($invoiceData['type'] == '0') {
                                        $html .= "(Rev) " . $recipient_name . " : " . $status . " - [" . $amount . ']; ';
                                    } else {
                                        $html .= "(Cost)" . $recipient_name . " : " . $status . " - [" . $amount . '];';
                                    }
                                }
                            }
                        }
                    }
                    $billing_sts =  $html;
                    $trip_sts  = $res['trip_sts'];
                    $shift_id  = $res['shift_id'];
                    $shipmentid = $res['shipmentid'];
                    $order_row_id = $res['id'];
                    $trip_id   = $res['trip_id'];
                    $order_status = "Pending";
                    if($trip_id >'0'){
                        $order_status = "Active";
                    }
                    if($trip_sts == '1'){
                        $order_status = "Closed";
                    }
                    $created_date     = date('Y-m-d',strtotime($res['created_date']));
                    $from_source      = "";
                    $created_source   = $res['created_source'];
                    $vendor_name      = $res['vendor_name'];
                    $booking_id       = $res['order_id'];
                    $pdate            = $res['pickup_datetime'];
                    if($pdate != ""){
                        $pdates           = getdatetimebytimezone( $curtz, $pdate, $default_timezone );
                        $date1            = $pdates['datetime'];
                        $early_pickup     = date('Y-m-d',strtotime($date1));
                    }else{
                        $early_pickup = "";
                    }
                    $ddate               = $res['delivery_datetime'];
                    if($ddate != ""){
                        $ddates           = getdatetimebytimezone( $curtz, $ddate, $default_timezone );
                        $date2            = $ddates['datetime'];
                        $late_delivery    = date('Y-m-d',strtotime($date2));
                    }else{
                        $late_delivery = "";
                    }
                    $pickup_company   = $res['pickup'];
                    $delivery_company = $res['delivery'];
                    $delivery_city    = $res['delivery_city'];
                    $transport_mode   = $res['transport_mode'];
                    $vendor_name      = $res['vendor_name'];
                    $company_code     = $res['company_code'];
                    $branch_code      = $res['branch_code'];
                    $shipment_id      = $res['shipment_id'];
                    $from_source =  (new \App\Libraries\OrderCreationSourceHelper())->getOrderSourceName($created_source);
                    $delivered_time   = $res['delivered_time'];
                    $customer_name    = $res['customer_name'];
                    $orders[] = array('customer_name'=>$customer_name,'delivered_time'=>$delivered_time,'created_source'=>$from_source,'shipmentid'=>$shipmentid,'trip_id'=>$trip_id,'shift_id'=>$shift_id,'trip_sts'=>$trip_sts,'status'=>$status,'shipment_id'=>$shipment_id,'branch_code'=>$branch_code,'company_code'=>$company_code,'vendor_name'=>$vendor_name,'transport_mode'=>$transport_mode,'delivery_city'=>$delivery_city,'delivery_company'=>$delivery_company,'pickup_company'=>$pickup_company,'late_delivery'=>$late_delivery,'early_pickup'=>$early_pickup,'booking_id'=>$booking_id,'order_row_id'=>$order_row_id,'created_date'=>$created_date,'salog_ref'=>$salog_ref,'delivery_note'=>$delivery_note,'order_status'=>$order_status,'debtor_jfr'=>$debtor_jfr,'pod_available'=>$pod_sts,'billing_sts'=>$billing_sts);
                }
            }
            if(!empty($orders)){
                $fileName = $this->download_vnexceldata($orders);
                if($fileName != ""){
                    $this->sendmailwithdata($fileName);
                }
            }else{
                $this->sendmailwithnodata();
            }
    }
    
    public function giveInvoiceParameters($invoiceParam) {
        $finalArray = array();
        if (!empty($invoiceParam) && $invoiceParam != '') {
            $requiredArray = explode(';', $invoiceParam);
            if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
                foreach ($requiredArray as $eachitem) {
                    $explodeArray = explode('=====', $eachitem);
                    if (!empty($explodeArray) && sizeof($explodeArray) > 0) {
                        $key = isset($explodeArray[0]) ? $explodeArray[0] : "";
                        $value = isset($explodeArray[1]) ? $explodeArray[1] : "";
                        $finalArray[$key] = $value;
                    }
                }
            }
        }

        return $finalArray;
    }


    public function sendmailwithdata($filename){
        $rec_mail = $cc_mail = array();
        if(SYS_TYPE == 'TMS'){
            $rec_mail = array("quynh.ngoc.nguyen@kuehne-nagel.com","my.dang@kuehne-nagel.com","triet.vo@kuehne-nagel.com","lanh.dang@kuehne-nagel.com","anh.ngoc.le@kuehne-nagel.com","van.anh.nguyen@kuehne-nagel.com");
            $cc_mail = array("external.thy.le@kuehne-nagel.com","anh.ngo@kuehne-nagel.com","nareece.nguyen@kuehne-nagel.com","phuong.pham@kuehne-nagel.com");
        }else{
            $rec_mail = array("external.push.v@kuehne-nagel.com");
            $cc_mail = array("external.push.v@kuehne-nagel.com");
        }
        if(!empty($rec_mail)){
            $this->load->library('email');
            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
            $this->email->to($rec_mail);
            $sub = date('Y-m-d')." : Auto Report";
            $message  =  "Hi All,<br>";
            $message .= "Attached is the Auto Report for ".date('d-M')."<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
            if(!empty($cc_mail)){
                $this->email->cc($cc_mail);
            }
            $this->email->subject($sub);
            $this->email->set_mailtype("html");
            $this->email->message($message);
           
          /*   $epodpath = FCPATH."assets/quote/vnautoreports/".$filename; */
            $epodpath = sprintf('%s/assets/quote/vnautoreports/%s', FCPATH, $filename);
            
            $this->email->attach($epodpath);
            echo $message;
            
            if(!$this->email->send()) {
                log_message("error","Vndailyautoreport(376) >> sendmailwithdata >> ".$this->email->print_debugger());
            }

            $this->email->clear(true);
        }
    }
      
    public function sendmailwithnodata(){
        $rec_mail = $cc_mail = array();
        if(SYS_TYPE == 'TMS'){
            $rec_mail = array("quynh.ngoc.nguyen@kuehne-nagel.com","my.dang@kuehne-nagel.com","triet.vo@kuehne-nagel.com","lanh.dang@kuehne-nagel.com","anh.ngoc.le@kuehne-nagel.com","van.anh.nguyen@kuehne-nagel.com");
            $cc_mail = array("external.thy.le@kuehne-nagel.com","anh.ngo@kuehne-nagel.com","nareece.nguyen@kuehne-nagel.com","phuong.pham@kuehne-nagel.com");
        }else{
            $rec_mail = array("external.supriya.a@kuehne-nagel.com");
            $cc_mail = array("external.push.v@kuehne-nagel.com");
        }
        if(!empty($rec_mail)){
            $this->load->library('email');
            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
            $this->email->to($rec_mail);
            $sub = date('Y-m-d')." : Auto Report";
            $message  =  "Hi All,<br>";
            $message .= "No Data Available for - ".date('d-M')."<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
            echo $message;
            if(!empty($cc_mail)){
                $this->email->cc($cc_mail);
            }
            $this->email->subject($sub);
            $this->email->set_mailtype("html");
            $this->email->message($message);

            if(!$this->email->send()) {
                log_message("error","Vndailyautoreport(407) >> sendmailwithnodata >> ".$this->email->print_debugger());
            }

            $this->email->clear(true);
        }
    }

    public function giveReferenceParameters($referenceParam) {
        $finalArray = array();
        if (!empty($referenceParam) && $referenceParam != '') {
            $requiredArray = explode('=====', $referenceParam);
            if (!empty($requiredArray) && sizeof($requiredArray) > 0) {
                $finalArray['type'] = isset($requiredArray[0]) ? trim($requiredArray[0]) : "";
                $finalArray['value'] = isset($requiredArray[1]) ? trim($requiredArray[1]) : "";
            }
        }

        return $finalArray;
    }

    public function download_vnexceldata($data){

        $fileName = "";
        if(!empty($data)){
            $styleArray = array(
                    'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => 'FFFFFF'),
                    'size'  => 10,
                    'name'  => 'Verdana'
                ));
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
            ->getStyle('A1:T1')
            ->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => '0c3b81')
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Booking ID');
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Customer Name');
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Delivery Note');
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Salog Ref');
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Pickup');
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Delivery');
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Trip No');
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Vendor Name');
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'Status');
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'Created Date');
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Pickup Date');
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Estimated Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', 'Delivery Date');
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', 'Mode Of Transport');
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', 'Billing Status');
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', 'Debitor JFR');
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'POD Available');
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', 'Company Code');
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', 'Branch Code');
            $objPHPExcel->getActiveSheet()->getStyle('S1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'From Source');
            $objPHPExcel->getActiveSheet()->getStyle('T1')->applyFromArray($styleArray);

            $rowCount = 2;
            foreach ($data as $result) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $result['booking_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['customer_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['delivery_note']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $result['salog_ref']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $result['pickup_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['delivery_company']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $result['shipmentid']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $result['vendor_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $result['order_status']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $result['created_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $result['early_pickup']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $result['late_delivery']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $result['delivered_time']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $result['transport_mode']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $result['billing_sts']);
                $objPHPExcel->getActiveSheet()->SetCellValue('P' . $rowCount, $result['debtor_jfr']);
                $objPHPExcel->getActiveSheet()->SetCellValue('Q' . $rowCount, $result['pod_available']);
                $objPHPExcel->getActiveSheet()->SetCellValue('R' . $rowCount, $result['branch_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('S' . $rowCount, $result['branch_code']);
                $objPHPExcel->getActiveSheet()->SetCellValue('T' . $rowCount, $result['created_source']);
                $rowCount++;
            }
            $fileName ='VNReport-'. date("d-M").'.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            
            if(!file_exists('assets/quote/vnautoreports')){
                mkdir('assets/quote/vnautoreports',0710,true);
            }
            $objWriter->save(str_replace(__FILE__,'assets/quote/vnautoreports/'.$fileName,__FILE__));
            
        }
        return $fileName;

    }       
}
?>
