<?php

defined('BASEPATH') or exit('No direct script access allowed');

class WestPharmaShipment extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->model('WestPharmaModel');
        $this->load->library('Edi_logger');
        $this->load->library('WestPharmaService');
    }

    public function index(): void
    {
        $statusMessage = '';
        try {
            $postData = file_get_contents('php://input');
            log_message("error", "WestPharmaShipment Request Data " . json_encode($postData, JSON_THROW_ON_ERROR));
            if (!empty($postData)) {
                $xml = new SimpleXMLElement($postData);
                $response = [];
                if ($xml == false) {
                    $statusMessage = "Invalid request,Please try again!";
                } else {
                    $this->edi_logger->setEdi_request($postData);
                    $shipmentDataInfo = $this->westpharmaservice->readShipmentData($xml);
                    $curtz = date_default_timezone_get();
                    $logDate = date('Y-m-d H:i:s');
                    $actualDate = getdatetimebytimezone(DFLT_TZ, $logDate, $curtz);
                    $logDate = $actualDate['datetime'];
                    if (!empty($shipmentDataInfo)) {
                        //log_message("error", "Westpharmaparseddata " . json_encode($shipmentDataInfo));
                        $response = $this->getShipmentDataParse($shipmentDataInfo, $logDate);
                    }
                    $statusMessage = "Success";
                    if (empty($response)) {
                        $statusMessage = "Failed for unformatted request,Please try again!";
                    }
                }
            } else {
                $statusMessage = "Invalid request,Please Proviede the proper XML as input and try again!";
            }
            log_message("error", "Westpharma_EDI" . $statusMessage);
        } catch (Exception $exc) {
            $statusMessage = "Catch Block:" . $exc->getTraceAsString();
        } finally {
            log_message("error", "Westpharma inbound data writing into edi logs");
            $this->edi_logger->setEdi_type(1);
            $this->edi_logger->setTransaction_id(time());
            $this->edi_logger->setEdi_name('Westpharma');
            $this->edi_logger->setBounded_type(1);
            $this->edi_logger->setEdi_format_type('XML');
            $this->edi_logger->setStatus(($statusMessage == 'Success' ? 1 : 0));
            $this->edi_logger->setEdi_response($statusMessage);
            $this->edi_logger->setObj_type_name('Westpharma Ref');
            $this->edi_logger->saveToEdiLogs();
        }
        echo $statusMessage;
    }

    public function getShipmentDataParse(array $data, string $logDate): array
    {
        $curtz = date_default_timezone_get();
        $currentDate = $logDate;
        $responseOrder = [];
        $transportMode = "TL";
        $dedicateVehicle = 0;
        foreach ($data['shipdata'] as $shipmentData) {
            $serviceType = $shipmentData['servicetype'];
            if ($serviceType != "Full Truck Load") {
                $transportMode = "LTL";
                $dedicateVehicle = 0;
            }
            $orderId = $shipmentData['orderid'];
            $receivers = $data['header']['receivers'];
            if (!empty($receivers)) {
                $this->westpharmaservice->insertOrderReceivers($orderId, $data);
            }
            $logicalSender = $data['header']['lsender'];
            if (strlen($logicalSender) > 2) {
                $firstTwoChars = substr($logicalSender, 0, 2);
            } else {
                $firstTwoChars = $logicalSender;
            }
            $companyCode = $company_code = $shipmentData['sendercmpcode'];
            $branchCode = $branch_code = $shipmentData['senderbranchcode'];
            $checkLogicalReceiver = $data['header']['lreceiver'];
            if ($checkLogicalReceiver != "") {
                $checkCompanyCodeDetails = $this->WestPharmaModel->checkCompanyCode($checkLogicalReceiver);
                if ($checkCompanyCodeDetails->num_rows() > 0) {
                    $company_code = $checkCompanyCodeDetails->row()->company_code;
                    $branch_code = $checkCompanyCodeDetails->row()->branch_code;
                }
            }
            $user_id = $this->westpharmaservice->checkUser($company_code, $branch_code, $firstTwoChars);
            $this->edi_logger->setUser_id($user_id);
            $data['truck']['shipment_id'] = mt_rand();
            $data['truck']['ordernum'] = mt_rand();
            $shipmentData['incoterm'] = "";
            $actualDateTime = getdatetimebytimezone(DFLT_TZ, $shipmentData['statusinfo_date'], $curtz);
            /*cargo details*/
            $cargo_content = "Boxes";
            if (!empty($shipmentData['cargo_content'])) {
                $cargo_content = implode(",", $shipmentData['cargo_content']);
                $cargo_content = substr($cargo_content, 0, 95);
            }
            $shipmentData['sourcedate'] = $shipmentData['destinationdate'] = $actualDateTime['datetime'];
            $sship_id = $this->westpharmaservice->insertShipmentDetails(
                $orderId,
                $shipmentData,
                $data,
                $logDate,
                $transportMode,
                $cargo_content
            );
            if (isset($shipmentData['pickdrops'])) {
                if (isset($shipmentData['freight_term'])) {
                    $this->westpharmaservice->getCustomerType($shipmentData);
                } else {
                    $shipmentData['freight_term'] = 60;
                }
                $customer_id = 0;
                if (!empty($shipmentData['consignee'])) {
                    $consignee = $this->WestPharmaModel->checkOrderParties(
                        $shipmentData['consignee'],
                        $company_code,
                        $branch_code,
                        $user_id,
                        "CN"
                    );
                    if ($consignee['id'] > 0) {
                        $customer_id = $consignee['id'];
                        $drop_custid = $drop_partyid = $consignee['party_id'];
                    }
                }
                if (isset($consignee['party_id'])) {
                    $consignee_id = $consignee['id'];
                    $cn_partytype = $consignee['party_type'] ?? 3;
                    $involvedParty[] = [
                        'party_id' => $consignee_id,
                        'party_type' => $cn_partytype,
                    ];
                }
                if (!empty($shipmentData['shipper'])) {
                    $shipper = $this->WestPharmaModel->checkOrderParties(
                        $shipmentData['shipper'],
                        $company_code,
                        $branch_code,
                        $user_id,
                        "SH"
                    );
                    if ($shipper['id'] > 0) {
                        $customer_id = $shipper['id'];
                        $pickup_custid = $pickup_partyid = $shipper['party_id'];
                    }
                }
                if (isset($shipper['party_id'])) {
                    $shipper_id = $shipper['id'];
                    $sh_partytype = $shipper['party_type'] ?? 1;
                    $involvedParty[] = [
                        'party_id' => $shipper_id,
                        'party_type' => $sh_partytype,
                    ];
                }
                if (!empty($shipmentData['customer'])) {
                    $customer = $this->WestPharmaModel->checkCustomer(
                        $shipmentData['customer'],
                        $company_code,
                        $branch_code,
                        $user_id,
                        "PF"
                    );
                    if ($customer['id'] > 0) {
                        $customer_id = $customer['id'];
                    }
                    if (isset($customer['party_id'])) {
                        $cust_id = $customer['id'];
                        $cust_Party_id = $customer['party_id'];
                        $pf_partytype = $cu_partytype = $customer['party_type'] ?? 1;
                        $involvedParty[] = [
                            'party_id' => $cust_Party_id,
                            'party_type' => $pf_partytype,
                        ];
                    }
                }

                if (!empty($shipmentData['ff'])) {
                    $ff = $this->WestPharmaModel->checkParties(
                        $shipmentData['ff'],
                        $company_code,
                        $branch_code,
                        $user_id,
                        "NOTIFY_PARTY"
                    );
                    $ff_id = $ff['party_id'];
                    $ff_partytype = $ff['party_type'];
                    $involvedParty[] = [
                        'party_id' => $ff_id,
                        'party_type' => $ff_partytype,
                    ];
                }
                if (!empty($shipmentData['do'])) {
                    $do = $this->WestPharmaModel->checkParties(
                        $shipmentData['do'],
                        $company_code,
                        $branch_code,
                        $user_id,
                        "DELIVERY"
                    );
                    $do_id = $do['party_id'];
                    $do_partytype = $do['party_type'];
                    $involvedParty[] = [
                        'party_id' => $do_id,
                        'party_type' => $do_partytype,
                    ];
                }
                if ($customer_id == 0) {
                    if ($shipmentData['freight_term'] != "60") {
                        $customer_id = $this->WestPharmaModel->checkCustomerinfo(
                            $user_id,
                            $company_code,
                            $branch_code,
                            $firstTwoChars
                        );
                    }
                }
                $orderDetails = $this->WestPharmaModel->insertOrderDetails($shipmentData,$company_code,$branch_code,$sship_id,$data,$transportMode,$dedicateVehicle,$user_id,$customer_id);
                /*orders table */
                $ord_id =$orderDetails['ord_id'];
                $booking_id =$orderDetails['booking_id'];
                $bookext =$orderDetails['bookext'];
                $xsrvalue = $shipmentData['xsrvalue'];
                $this->edi_logger->setTxn_obj_id($xsrvalue);
                $this->edi_logger->setCompany_code($shipmentData['sendercmpcode']);
                $this->edi_logger->setBranch_code($shipmentData['senderbranchcode']);
                $responseOrder[] = $ord_id;
                if ($ord_id > 0) {
                    $department_code = $shipmentData['senderdeptcode'];
                    $order_type = "3";
                    $get_country = $this->db->select('country_code,company_code')->get_where(
                        "tb_users",
                        ['id' => $user_id]
                    );
                    $country_code = $get_country->row()->country_code;
                    $company_code = $get_country->row()->company_code;
                    $genord = [
                        "user_id" => $user_id,
                        "order_id" => $ord_id,
                        "country_code" => $country_code,
                        "company_code" => $company_code,
                    ];
                    $shipmentData['order_id'] = $booking_id;
                    if ($bookext == 0) {
                        $booking_id = generatebookingid($genord);
                        $upd = $this->common->updatetbledata("tb_orders", ['order_id' => $booking_id], ['id' => $ord_id]
                        );
                        $details_ins = [
                            'order_row_id' => $ord_id,
                            'order_id' => $booking_id,
                            'order_status' => 'PENDING',
                            'distance' => '0',
                            'department_code' => $department_code,
                            'order_type' => $order_type,
                            'createdon' => $currentDate,
                        ];
                        $this->common->insertTableData('tb_order_details', $details_ins);
                    } else {
                        $this->common->updatetbledata("tb_order_details", [
                            'department_code' => $department_code,
                            'order_type' => $order_type,
                        ], ['order_row_id' => $ord_id]);
                    }
                    $cargoId = $this->WestPharmaModel->checkCargoInfo($shipmentData, $cargo_content);
                    $this->WestPharmaModel->checkOrderCargoInfo($shipmentData,$ord_id,$cargoId, $cargo_content,$user_id);

                    if ($serviceType != "") {
                        $referenceData[] = ['code' => 'SDT', 'value' => $serviceType];
                    }
                    $referenceData = $this->westpharmaservice->generateRefererences($shipmentData);
                    $referenceData[] = ['code' => 'CMP', 'value' => $companyCode];
                    $referenceData[] = ['code' => 'BRN', 'value' => $branchCode];
                }
                foreach ($referenceData as $references) {
                    $this->WestPharmaModel->insertOrderReferences($ord_id, $references);
                }
                if ($sship_id > 0) {
                    foreach ($involvedParty as $party) {
                        $this->WestPharmaModel->insertInvolvedParties(
                            $ord_id,
                            $party['party_id'],
                            $shipmentData['orderid'],
                            $party['party_type']
                        );
                    }
                }
            }
        }
        return $responseOrder;
    }

}
