<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}


class Workbench extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['WorkbenchModel']);
        if (!checkUrlAccessForUser('WORKBENCH')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index(): void
    {
        $businessType = $this->session->userdata("business_type");
        if (!in_array($businessType, ["Country Admin", "Truck_Owner", "Customer", "Carrier"])) {
            redirect('home');
        }
        $data['page_title'] = $this->lang->line('workbench');
        $data['sub_title'] = $this->lang->line('workbench');
        $companyCode = $this->session->userdata('company_code');
        $isRelatedToSingaporeMalaysia = checkAccessConditions('RELATED_2_SG_MY', $companyCode);
        $isRelatedToNewZealand = checkAccessConditions('RELATED_2_NZKN_NZPG', $companyCode);
        $data = [];
        if ($businessType == "Country Admin") {
            $userIds = $this->session->userdata('country_user_ids');
        }
        if ($businessType == "Truck_Owner") {
            $userIds[] = $this->session->userdata("user_id");
        }
        if ($businessType == "Customer") {
            $customerId = $this->session->userdata("cust_id");
        }
        if ($businessType == "Carrier") {
            $vendorId = $this->session->userdata("id");
        }
        $where = [
            'companyCode' => $companyCode,
            'businessType' => $businessType,
            'userIds' => $userIds ?? [],
            'customerId' => $customerId ?? 0,
            'vendorId' => $vendorId ?? 0
        ];
        $data['bookingsCount'] = $this->WorkbenchModel->getBookingIdsCount($where);
        $recentBookings = $this->WorkbenchModel->getRecentBookings($where);
        $conditions = [
            'businessType' => $businessType,
            'recentBookings' => $recentBookings,
            'isRelatedToSingaporeMalaysia' => $isRelatedToSingaporeMalaysia,
            'isRelatedToNewZealand' => $isRelatedToNewZealand,
        ];
        $data['recentBookings'] = $this->getOrderViewPageUrlBasedOnBusinessType($conditions);
        $data['bookingMenu'] = $this->getBookingMenuBasedOnBusinessType($conditions);
        $this->newtemplate->dashboard('workbench/index', $data);
    }

    private function getOrderViewPageUrlBasedOnBusinessType(array $data): array
    {
        if (empty($data['recentBookings'])) {
            return $data['recentBookings'];
        }
        $orderViewUrl = "";
        if (in_array($data['businessType'], ["Country Admin", "Truck_Owner"])) {
            if ($data['isRelatedToSingaporeMalaysia']) {
                $orderViewUrl = base_url() . "smtcorders/vieworder/";
            } else {
                $orderViewUrl = base_url() . "orders/vieworder/";
            }
        } elseif ($data['businessType'] == "Customer") {
            if ($data['isRelatedToSingaporeMalaysia']) {
                $orderViewUrl = base_url() . "smtccustorders/vieworder/";
            } elseif ($data['isRelatedToNewZealand']) {
                $orderViewUrl = base_url() . "NZGENorders/vieworder/";
            } else {
                $orderViewUrl = base_url() . "KNCustorders/vieworder/";
            }
        }
        foreach ($data['recentBookings'] as $eachBooking) {
            $eachBooking['url'] = $orderViewUrl != "" ? $orderViewUrl . $eachBooking['id'] : "";
            $recentBookingsWithUrl[] = $eachBooking;
        }
        return $recentBookingsWithUrl ?? [];
    }

    private function getBookingMenuBasedOnBusinessType(array $data): array
    {
        if (in_array($data['businessType'], ["Country Admin", "Truck_Owner"])) {
            if ($data['isRelatedToSingaporeMalaysia']) {
                $bookingMenu = [
                    'schedule_a_booking' => base_url() . 'smtcorders/neworder',
                    'your_bookings' => 'smtcorders'
                ];
            } else {
                $bookingMenu = [
                    'schedule_a_booking' => base_url() . 'orders/neworder',
                    'your_bookings' => 'orders'
                ];
            }
        } elseif ($data['businessType'] == "Customer") {
            if ($data['isRelatedToSingaporeMalaysia']) {
                $bookingMenu = [
                    'schedule_a_booking' => base_url() . 'smtccustorders/neworder',
                    'your_bookings' => 'smtccustorders'
                ];
            } elseif ($data['isRelatedToNewZealand']) {
                $bookingMenu = [
                    'schedule_a_booking' => base_url() . 'NZGENorders/neworder',
                    'your_bookings' => 'NZGENorders'
                ];
            } else {
                $bookingMenu = [
                    'schedule_a_booking' => base_url() . 'KNCustorders/neworder',
                    'your_bookings' => 'KNCustorders'
                ];
            }
        }
        return $bookingMenu ?? [];
    }
}
