<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require_once APPPATH . 'libraries/REST_Controller.php';

use Restserver\Libraries\REST_Controller;
use SVKAPI\v1\StatusExecutionHandler;
use SVKAPI\v1\Exceptions\ValidationException;

class StatusExecution extends REST_Controller
{
    public function index_post()
    {
        if ($this->request->format !== 'xml') {
            throw new \Exception('Invalid format, only XML is allowed');
        }
        $this->load->library('Edi_logger');
        $statusmsg = "";
        $handler = new StatusExecutionHandler();
        try {
            $this->edi_logger->setEdi_request($this->input->raw_input_stream);
            $handler->setUserId($this->rest->user_id)
                ->setMessageBody($this->input->raw_input_stream)
                ->processMessage();
            if (!empty($handler)) {
                $statusmsg = "Success";
            } else {
                $statusmsg = "Failed for unformatted request,Please try again!";
            }

        } catch (ValidationException $e) {
            $handler->log($e->getMessage(), 'error');
            return $this->response([
                $this->config->item('rest_status_field_name') => false,
                $this->config->item('rest_message_field_name') => $e->getMessage(),
            ], REST_Controller::HTTP_BAD_REQUEST);
        } catch (\Exception $e) {
            $handler->log($e->getMessage(), 'error');
            return $this->response([
                $this->config->item('rest_status_field_name') => false,
                $this->config->item('rest_message_field_name') => 'Internal failure',
            ], REST_Controller::HTTP_BAD_REQUEST);
        } finally {
            $this->edi_logger->setEdi_type(1);
            $this->edi_logger->setTransaction_id(time());
            $this->edi_logger->setEdi_id("34");
            $this->edi_logger->setEdi_name('Shipsy');
            $this->edi_logger->setBounded_type(2);
            $this->edi_logger->setEdi_format_type('XML');
            $this->edi_logger->setStatus(($statusmsg == 'Success' ? 1 : 0));
            $this->edi_logger->setEdi_response("Order Status Inserted Successfully");
            $this->edi_logger->setObj_type_name('Shipsy Status');
            $this->edi_logger->saveToEdiLogs();
        }

        return $this->response([
            $this->config->item('rest_status_field_name') => true,
        ]);
    }
}
