<?php

use App\EventsQueue\AbstractEventController;
use App\EventsQueue\Payload\TripNotificationPayload;
use App\MobileEvents\MobileEvent;

defined('BASEPATH') or exit('No direct script access allowed');


class Trip extends AbstractEventController
{
    public function outbound(): void
    {
        $tripId = $this->input->post('trip_id');
        $payload = new TripNotificationPayload([
            'tripId' => $tripId,
            'identifier' => "{$tripId}-" . time()
        ]);

        $event  = new MobileEvent('mobile.trip.outbound', $payload);

        $result = $this->eventDispatcher->dispatch($event);
    }

    public function logs($limit = 50): void
    {

        if (!$this->session->has_userdata('user_id')) {
            redirect('login');
        }

        $results = $this->db->select('id, status, result, updated_on')
            ->from('tbl_events_queue')
            ->where('event_name', 'mobile.trip.outbound')
            ->order_by('updated_on', 'DESC')
            ->limit($limit)
            ->get()
            ->result_array();
        foreach ($results as $result) {
            echo "<h3>{$result['id']} &mdash; {$result['updated_on']} &mdash; {$result['status']}</h3>";
            if ($result['status'] === 'COMPLETED') {
                echo '<pre>';
                echo htmlspecialchars($result['result']);
                echo '</pre>';
            }
            echo '<hr/>';
        }
    }
}
