<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Boomifailedtransactionedi extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
    }

    public function index(): void
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                $orderID = $this->parseOrderXml($xmldata);
                if ("0" !== $orderID) {
                    $this->sendFailedNotify($orderID);
                } else {
                    log_message('error', 'Boomifailedtransactionedi Empty Order ');
                }
            }
        } else {
            echo "Please Send Proper XML";
        }
    }

    public function parseOrderXml(object $xmldata): string
    {
        $etnOrderHeader = $xmldata->xpath('SVKEDITripBody');
        $TripDetails = $etnOrderHeader[0]->xpath('TripDetails');
        $TripOrderDetails = $TripDetails[0]->xpath('TripOrderDetails');
        return isset($TripOrderDetails['0']->OrderID) ? (string)($TripOrderDetails['0']->OrderID) : "0";
    }

    public function sendFailedNotify($orderId): void
    {
        if (!empty($orderId)) {
            try {
                $this->load->library('email');
                $data['page_title'] = $data['subject'] = $subject = 'Dell Boomi Booking Failed Notification';
                $data['order'] = $orderId;
                if (SYS_TYPE == 'TMS') {
                    $data['receivemail'] = $receivemail = "fernanda.costa@kuehne-nagel.com";
                } else {
                    $data['receivemail'] = $receivemail = "External.Tirupathi.Rao@Kuehne-Nagel.com";
                }
                $data['receivename'] = $receivename = "Tirupathi";
                $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                $this->email->to($receivemail, $receivename);
                $this->email->subject($subject);
                $this->email->set_mailtype("html");
                $body = $this->load->view('mail_forms/dellboomi_booking_failed', $data, true);
                $this->email->message($body);
                $this->email->send();
                $this->email->clear(true);
            } catch (Exception $ex) {
                log_message("error", "Dell Boomi Booking Failed Notification Failed" . $ex->getMessage());
            }
        } else {
            log_message('error', 'No Order data for id : ' . $orderId);
        }
    }
}
