<?php

class CarrierInboundAPI extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper("auth_helper");
        $this->load->library(['apis/CarrierInboundServices','apis/TCIExpressEDIServices']);
        $this->load->model('order');
    }

    public function index()
    {
        /*if (! $this->carrierinboundservices->checkClientAuth()) {
            header('HTTP/1.1 401 Unauthorized');
            header('WWW-Authenticate: Basic realm="API Access"');
            echo json_encode(['status' => false, 'message' => 'Unauthorized']);
            exit;
        }*/
        $postData = file_get_contents('php://input');
        //log_message("error", "PostData:" . json_encode($postData));
        if (! empty($postData)) {
            $rawInput = $this->input->raw_input_stream; // raw JSON body
            $data     = json_decode($rawInput, true);   // convert to associative array
            //log_message("error", "Data:" . json_encode($data));
            if (json_last_error() !== JSON_ERROR_NONE) {
                //log_message('error', 'Invalid JSON input');
                show_error('Invalid JSON input', 400);
            }
            
            $response = $this->carrierinboundservices->generateStandardInbound($data);
            if($response == "")
            {
                $response = "Order Created Successfully"; 
            }
            echo $response;
        } else {
            echo "Please Send Proper JSON Format";
        }
    }
    
    public function getDoumentInboundAPI(): array
    {
        $postData = file_get_contents('php://input');
        $response = [];
        log_message("error", "PostData:" . json_encode($postData));
        if (! $this->carrierinboundservices->checkClientAuth()) {
            header('HTTP/1.1 401 Unauthorized');
            header('WWW-Authenticate: Basic realm="API Access"');
            echo json_encode(['status' => false, 'message' => 'Unauthorized']);
            exit;
        }
        if (! empty($postData)) {
            $rawInput = $this->input->raw_input_stream; // raw JSON body
            $data     = json_decode($rawInput, true);   // convert to associative array
            //log_message("error", "Data:" . json_encode($data));
            if (json_last_error() !== JSON_ERROR_NONE) {
                log_message('error', 'Invalid JSON input');
                show_error('Invalid JSON input', 400);
            }
            
            $response = $this->carrierinboundservices->generateStandardDocumentInbound($data);
            
            return $response;
        } else {
            return ["Please Send Proper JSON Format"];
        }
    }
    
    /*public function getStatusInboundAPI(): array
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error","Post:".json_encode($postData));
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                $header = $xmldata->xpath('SVKEDITransmissionHeader');
                $sourceApp = isset($header[0]->SourceApp) ? (string)($header[0]->SourceApp) : "";
                if (! $this->carrierinboundservices->checkClientAuth($sourceApp)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
               $response = [];
               return $response;
            }
        } else {
            return ["Please Send Proper XML"];
        }
    }
    
    public function getDocsInboundAPI(): array
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error","Post:".json_encode($postData));
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                $header = $xmldata->xpath('SVKEDITransmissionHeader');
                $sourceApp = isset($header[0]->SourceApp) ? (string)($header[0]->SourceApp) : "";
                if (! $this->carrierinboundservices->checkClientAuth($sourceApp)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
               $response = [];
               return $response;
            }
        } else {
            return ["Please Send Proper XML"];
        }
    }*/
    
    public function getStatusInboundAPI()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error", "Post: " . json_encode($postData));
    
        $response = [];
    
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
    
            if ($xmldata === false) {
                $response = [
                    "status" => "error",
                    "message" => "Invalid XML request",
                ];
            } else {
                $header = $xmldata->xpath('SVKEDITransmissionHeader');
                $sourceApp = isset($header[0]->SourceApp) ? (string) $header[0]->SourceApp : "";
                
                // … Check Authorization
                if (!$this->tciexpressediservices->checkClientAuth($sourceApp)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
    
                // âœ… Process all Orders
                $orders = $xmldata->xpath('SVKEDITransmissionBody/Order');
    
                if (!empty($orders)) {
                    foreach ($orders as $orderNode) {
                        $orderId = isset($orderNode->OrderID) ? (string) $orderNode->OrderID : null;
    
                        if ($orderId) {
                            $orderDetails = $this->order->getOrderDetails($orderId);
                            //log_message('error', 'orderDetails: ' . json_encode($orderDetails));
                            if ($orderDetails && isset($orderDetails->id)) {
                                $order_id = $orderDetails->order_id;
                                //$external_order_id = $orderDetails->external_order_id;
                                $id = (int)$orderDetails->id;
    
                                // ðŸ‘‡ Assuming this method internally logs its process
                                if($sourceApp == "EKART"){$sourceApp = "FLIPKART";}
                                $this->tciexpressediservices->getStatus($orderNode, $id, $sourceApp);
    
                                $response = [
                                    "order_id" => $orderId,
                                    "status" => "success",
                                    "message" => "Status updated"
                                ];
                            } else {
                                log_message("error", "Order not found for ID: " . $orderId);
                                $response = [
                                    "order_id" => $orderId,
                                    "status" => "error",
                                    "message" => "Order not found"
                                ];
                            }
                        }
                    }
                } else {
                    $response = [
                        "status" => "error",
                        "message" => "No <Order> nodes found in XML"
                    ];
                }
            }
        } else {
            $response = [
                "status" => "error",
                "message" => "Please send proper XML"
            ];
        }
    
        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }

    public function getDocsInboundAPI()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error", "Post:" . json_encode($postData));
        if (! empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                $header       = $xmldata->xpath('SVKHeader');
                $orderIdNodes = $xmldata->xpath('SVKOrderID');
                $orderId      = isset($orderIdNodes[0]) ? (string) $orderIdNodes[0] : null;
                $sourceApp = isset($header[0]->SVKSourceApp) ? (string) $header[0]->SVKSourceApp : "";
                
                // … Check Authorization
                if (!$this->tciexpressediservices->checkClientAuth($sourceApp)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
                $response     = [];
                if ($orderId) {
                    $orderDetails = $this->order->getOrderDetails($orderId);
                    //log_message('error', 'orderDetails: ' . json_encode($orderDetails));
                    if ($orderDetails && isset($orderDetails->id)) {
                        $order_id = $orderDetails->order_id;
                        $external_order_id = $orderDetails->external_order_id;
                        $id = (int)$orderDetails->id;
    
                        // ðŸ‘‡ Assuming this method internally logs its process
                        //$this->tciexpressediservices->getStatus($orderNode, $id, $sourceApp);
                        $this->tciexpressediservices->getXPPod($xmldata, $id);
    
                        $response = [
                            "order_id" => $orderId,
                            "status" => "success",
                            "message" => "Document updated"
                        ];
                    } else {
                        log_message("error", "Order not found for ID: " . $orderId);
                        $response = [
                            "order_id" => $orderId,
                            "status" => "error",
                            "message" => "Order not found"
                        ];
                    }
                }
            }
        } else {
            $response = [
                "status"  => "error",
                "message" => "Please Send Proper XML",
            ];
        }
        header('Content-Type: application/json');
        echo json_encode($response);
        exit; // stop further output
    }
}
