<?php

defined('BASEPATH') or exit('No direct script access allowed');



class Commonpodedi extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('roadlogsalogdocument');
        $this->load->model(['Singlestatusmodel', 'Roadlogtosalogmodel']);
    }

    public function index(): void
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        if (!empty($postData)) {
            if (($xml = new SimpleXMLElement($postData)) == false) {
                echo "Invalid request,Please try again!";
            } else {
                echo $this->parsePodXml($xml);
            }
        } else {
            echo "Please Send Proper XML";
        }
    }

    public function parsePodXml($xmldata): string
    {
        $header = $xmldata->xpath('Header');
        $headerdata = [
            "version" => isset($header[0]->Version) ? (string)($header[0]->Version) : "",
            "sequenceNumber" => isset($header[0]->SequenceNumber) ? (string)($header[0]->SequenceNumber) : "",
            "sourceApp" => isset($header[0]->AckSpec->SourceApp) ? (string)($header[0]->AckSpec->SourceApp) : "",
        ];
        $ordersData = [
            "action" => $xmldata->Action !== null ? (string)($xmldata->Action) : "",
            "documentType" => $xmldata->DocumentType !== null ? (string)($xmldata->DocumentType) : "",
            "OrderID" => $xmldata->OrderID !== null ? (string)($xmldata->OrderID) : "0",
            "documentName" => isset($xmldata->UploadDetails->DocumentName) ? (string)($xmldata->UploadDetails->DocumentName) : "",
            "documentURL" => isset($xmldata->UploadDetails->URL) ? (string)($xmldata->UploadDetails->URL) : "",
            "documentFile" => isset($xmldata->UploadDetails->DocumentFile) ? (string)($xmldata->UploadDetails->DocumentFile) : "",
            "receiverName" => isset($xmldata->UploadDetails->Receiver_Name) ? (string)($xmldata->UploadDetails->Receiver_Name) : "",
        ];
        return $this->Singlestatusmodel->uploadOrderPod(json_encode($ordersData),$this);
    }
}
