<?php if (! defined('BASEPATH')) {exit('No direct script access allowed');}

class FlipkartEDI extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('apis/FlipkartEDIServices');
    }

    public function generateAPIToken(): void
    {
        $this->flipkartediservices->generateToken();
    }

    public function getDocketNo()
    {
        $docketNo = $this->flipkartediservices->getDocketNo();
        //log_message("error", "DocketNo:" . $docketNo);

        header('Content-Type: text/plain');
        echo $docketNo;                     
        exit;                              
    }
    
    public function getOrderDetails(string $startDate, string $endDate)
    {
        $docketNo = $this->flipkartediservices->getOrderDetails($startDate, $endDate);
        header('Content-Type: text/plain');
        echo $docketNo;                     
        exit;                              
    }
    
    public function getLiveStatus(): string
    {
        $response = $this->flipkartediservices->getLiveStatus();
        return $response;
    }
    
    public function getStatusTracking() : void
    {
		// Get raw POST data
        $rawInput = file_get_contents('php://input');
    
        // Decode JSON into associative array
        $data = json_decode($rawInput, true);
    
        // Check if decoding was successful and data is an array
        if (is_array($data) && !empty($data)) {
            $trackNo = $data['trackNo'] ?? null;
            $orderId = $data['orderId'] ?? null;
    
            if ($trackNo && $orderId) {
                // Call service
                /*$chk_qry_order = $this->db->get_where('tb_orders', ['order_id' => $orderId])->row_array();
                $id = $chk_qry_order['id'];*/
                //log_message('error', "Iddd:" . $id);
                $trackingData = $this->flipkartediservices->getTracking((array)$trackNo, $orderId, "XP_INDIA");
    
                // Logging
                /*log_message("error", "order: " . $orderId);
                log_message("error", "trackingData: " . print_r($trackingData, true));*/
                //redirect('orders/orderslist/' . $orderId);
            } else {
                log_message("error", "Invalid input: Missing trackNo or orderId");
            }
        } else {
            log_message("error", "Invalid JSON or empty input");
        }
    }
    
    public function getTracking(string $trackNo, string $orderId, string $carrier) : void
    {
        log_message("error","carrier:".$carrier);
        if($carrier == "FLIPKART")
        {
            $trackRequest = (array)$trackNo;
            $trackingData = $this->flipkartediservices->getTracking($trackRequest, $orderId, $carrier);
        }
        else if($carrier == XP_INDIA_EATON)
        {
            $trackingData = $this->flipkartediservices->getXPStatus($trackNo, $orderId, "XP_INDIA_SOUTH");
        }
        else if($carrier == XP_INDIA_SIEMENS || $carrier == "1001403696")
        {
            $trackingData = $this->flipkartediservices->getXPStatus($trackNo, $orderId, "XP_INDIA_WEST");
        }           
        /*else if($carrier == "XP_INDIA")
        {
            $trackingData = $this->flipkartediservices->getXPStatus($trackNo, $orderId, $carrier);
        }*/
        //log_message("error","order:".$orderId);
        //log_message("error","trackingData:".$trackingData);
        redirect('orders/orderslist/' . $orderId);
    }
    
    public function getPOD(string $trackNo, int $orderId, string $carrier) : void
    {
        /*if($carrier == "XP_INDIA")
        {
            $podData = $this->flipkartediservices->getPod($trackNo, $orderId, $carrier);
        }*/
        if($carrier == XP_INDIA_EATON)
        {
            $podData = $this->flipkartediservices->getPod($trackNo, $orderId, "XP_INDIA_SOUTH");
        }
        else if($carrier == XP_INDIA_SIEMENS || $carrier == "1001403696")
        {
            $podData = $this->flipkartediservices->getPod($trackNo, $orderId, "XP_INDIA_WEST");
        } 
        /*log_message("error","order:".$orderId);
        log_message("error","trackingData:".$podData);*/
        redirect('orders/orderslist/' . $orderId);
    }
    
}
