<?php

class Standardapis extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper("auth_helper");
        $this->load->model("common");
        $this->load->library(
            ["standardstatushandler", "Edi_logger", "standarddocumenthandler", 'CarrierDocumentOutbound']
        );
    }

    public function orderCreate()
    {
        try {
            $requestHeaders = $this->getAuthenticationHeaders();
            if (empty($requestHeaders)) {
                http_response_code(401);
                echo json_encode(['status' => "Failed", 'message' => "Empty Request"]);
                return;
            }
            $checkAuthentication = validateAuthenticationToken($requestHeaders);
            if ($checkAuthentication['status'] == "Failed") {
                echo json_encode($checkAuthentication);
                return;
            }
            $postData = file_get_contents('php://input');
            if (empty($postData)) {
                http_response_code(401);
                echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>401</ResponseCode>
                            <ResponseMessage>Request Data is Empty</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
                return;
            }

            $response = $this->sendStandardXMLtoAltova($postData, "Booking");
            http_response_code(200);
            echo json_encode($response);
        } catch (Exception $e) {
            return ['code' => $e->getCode(), 'error_message' => $e->getMessage()];
        }
    }

    public function orderStatus()
    {
        try {
            $requestHeaders = $this->getAuthenticationHeaders();
            $checkAuthentication = validateAuthenticationToken($requestHeaders);
            $postData = file_get_contents('php://input');
            //log_message("error", "Order Status From YTD" . json_encode($postData));
            if ($checkAuthentication['status'] == "Failed") {
                http_response_code($checkAuthentication['status_code']);
                $this->sendFailedEmailNotification($postData, "Status", $checkAuthentication['message']);
                echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>" . $checkAuthentication['status_code'] . "</ResponseCode>
                            <ResponseMessage>" . $checkAuthentication['message'] . "</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
                return;
            }
            if (empty($postData)) {
                http_response_code(422);
                echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>422</ResponseCode>
                            <ResponseMessage>Empty Request</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
                return;
            }
            $this->edi_logger->setEdi_request($postData);
            try {
                $postXMLData = json_decode(json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
                $response = $this->standardstatushandler->insertOrderStatus($postXMLData);
                if ($response['status'] === 'Success') {
                    $bookingId = isset($postXMLData['SVKEDITransmissionBody']['Order']['OrderID']) ? $postXMLData['SVKEDITransmissionBody']['Order']['OrderID'] : 0;
                    if ($bookingId > 0) {
                        $statusCode = (isset($postXMLData['SVKEDITransmissionBody']['Order']['Status']['StatusCode']) && in_array($postXMLData['SVKEDITransmissionBody']['Order']['Status']['StatusCode'], ['2300','0500'])) ? $postXMLData['SVKEDITransmissionBody']['Order']['Status']['StatusCode'] : '';
                        $this->load->library('EportalBUFA');
                        $this->eportalbufa->orderId = $bookingId;
                        $this->eportalbufa->statusCode = $statusCode;
                        $this->eportalbufa->sendStatusNotificationToEportal($postData);
                    }
                }
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Receiving Stardard Status XML From Carrier  " . $ex->getMessage());
            } finally {
                $this->edi_logger->setEdi_type(1);
                $this->edi_logger->setTransaction_id(time());
                $this->edi_logger->setEdi_id("36");
                $this->edi_logger->setEdi_name('Status Inbound');
                $this->edi_logger->setBounded_type(2);
                $this->edi_logger->setEdi_format_type('XML');
                $this->edi_logger->setStatus(($response['status'] === 'Success' ? 1 : 0));
                $this->edi_logger->setEdi_response(json_encode($response));
                $this->edi_logger->setObj_type_name('Status Inbound');
                $this->edi_logger->saveToEdiLogs();
            }

            http_response_code($response['status_code']);
            if ($response['status'] === "Failed") {
                $this->sendFailedEmailNotification($postData, "Status", $response['message']);
            }
            echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>" . $response['status'] . "</ResponseStatus>
                            <ResponseCode>" . $response['status_code'] . "</ResponseCode>
                            <ResponseMessage>" . $response['message'] . "</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
            $bookingId = isset($postXMLData['SVKEDITransmissionBody']['Order']['OrderID']) ? $postXMLData['SVKEDITransmissionBody']['Order']['OrderID'] : 0;
            $StatusCode = !empty($postXMLData['SVKEDITransmissionBody']['Order']['Status']['StatusCode']) ? $postXMLData['SVKEDITransmissionBody']['Order']['Status']['StatusCode'] : "";
            if ($StatusCode == "1075" && $bookingId > 0) {
                $orderDetails = $this->common->gettblrowdata(["order_id" => $bookingId], "id,company_code,order_id", "tb_orders", 0, 0);
                if (!empty($orderDetails)) {
                    try {
                        $this->carrierdocumentoutbound->sendDocumentsToCarrier($orderDetails['id']);
                    } catch (Exception $ex) {
                        log_message(
                            "error",
                            "Document Outbound cron failed: " . $bookingId . " : " . $ex->getMessage()
                        );
                    }
                    if (checkAccessConditions('WECHAT_COUNTRY', $orderDetails['company_code'])) {
                        $this->load->library('Wechat');
                        $this->wechat->orderId = $orderDetails['order_id'];
                        $this->wechat->sendNotificationsToWeChat();
                    }
                }

            }
        } catch (Exception $e) {
            echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>" . $e->getCode() . "</ResponseCode>
                            <ResponseMessage>" . $e->getMessage() . "</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
        }
    }

    public function orderDocument()
    {
        try {
            $requestHeaders = $this->getAuthenticationHeaders();
            $checkAuthentication = validateAuthenticationToken($requestHeaders);
            $postData = file_get_contents('php://input');
            //log_message("error", "Order Document From YTD" . json_encode($postData));
            if ($checkAuthentication['status'] == "Failed") {
                http_response_code($checkAuthentication['status_code']);
                $this->sendFailedEmailNotification($postData, "Document", $checkAuthentication['message']);
                echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>" . $checkAuthentication['status_code'] . "</ResponseCode>
                            <ResponseMessage>" . $checkAuthentication['message'] . "</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
                return;
            }
            if (empty($postData)) {
                http_response_code(422);
                echo "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>422</ResponseCode>
                            <ResponseMessage>Empty Request</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
                return;
            }
            $this->edi_logger->setEdi_request($postData);
            try {
                $postXMLData = json_decode(json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
                $response = $this->standarddocumenthandler->insertOrderDocument($postXMLData);
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Receiving Stardard Document XML From Carrier  " . $ex->getMessage());
            } finally {
                $this->edi_logger->setEdi_type(1);
                $this->edi_logger->setTransaction_id(time());
                $this->edi_logger->setEdi_id("37");
                $this->edi_logger->setEdi_name('Document Inbound');
                $this->edi_logger->setBounded_type(2);
                $this->edi_logger->setEdi_format_type('XML');
                $this->edi_logger->setStatus(($response['status'] === 'Success' ? 1 : 0));
                $this->edi_logger->setEdi_response(json_encode($response));
                $this->edi_logger->setObj_type_name('Document Inbound');
                $this->edi_logger->saveToEdiLogs();
            }
            if ($response['status'] === "Failed") {
                $this->sendFailedEmailNotification($postData, "Document", $response['message']);
            }
            http_response_code($response['status_code']);
            $message = "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>" . $response['status'] . "</ResponseStatus>
                            <ResponseCode>" . $response['status_code'] . "</ResponseCode>
                            <ResponseMessage>" . $response['message'] . "</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
        } catch (Exception $e) {
            $message = "<?xml version='1.0' encoding='UTF-8'?>
                        <SVKEDIMessage>
                            <Response><ResponseStatus>Fail</ResponseStatus>
                            <ResponseCode>" . $e->getCode() . "</ResponseCode>
                            <ResponseMessage>" . $e->getMessage() . "</ResponseMessage>
                            </Response>
                           </SVKEDIMessage>";
        }
        echo $message ?? "";
    }

    private function getAuthenticationHeaders()
    {
        $requestHeaders = apache_request_headers();
        $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
        return $requestHeaders;
    }

    private function sendStandardXMLtoAltova($orderinfo, $typeofEDI): string
    {
        switch ($typeofEDI) {
            case "Booking":
                $altovalURL = "http://hktkoms130.corp.int.kn:4646/service/STANDARD_BOOKING_TEST";
                break;
            case "Status":
                $altovalURL = "http://hktkoms130.corp.int.kn:4646/service/STANDARD_STATUS_TEST";
                break;
            case "Document":
                $altovalURL = "http://hktkoms130.corp.int.kn:4646/service/STANDARD_DOCUMENT_TEST";
                break;
            default:
                $altovalURL = "";
        }
        if ($altovalURL != "") {
            try {
                //log_message("error", "sendTollXML Request to Altova" . json_encode($orderinfo));
                $data = 'inputFiles=' . $orderinfo;
                $curl = curl_init($altovalURL);
                curl_setopt($curl, CURLOPT_URL, $altovalURL);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                $headers = ["Content-Type: application/x-www-form-urlencoded"];
                curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                $resp = curl_exec($curl);
                if ($resp === false) {
                    log_message('error', 'sendElg360order request failed: ' . curl_error($curl));
                }
                //log_message("error", "sendTollXML Response" . $resp);
                curl_close($curl);
            } catch (Exception $ex) {
                $resp = "";
                log_message("error", "Some Problem occured!, While Sending Trip Notification XML to Altova " . $ex->getMessage());
            }
        }
        return $resp;
    }

    public function sendFailedEmailNotification(string $data, string $type, string $responceMessage): void
    {
        $postXMLData = json_decode(json_encode(simplexml_load_string($data, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
        if ($type == "Status") {
            $bookingID = !empty($postXMLData['SVKEDITransmissionBody']['Order']['OrderID']) ? $postXMLData['SVKEDITransmissionBody']['Order']['OrderID'] : "";
        } else {
            $bookingID = !empty($postXMLData['SVKEDITransmissionBody']['OrderDocument']['OrderID']) ? $postXMLData['SVKEDITransmissionBody']['OrderDocument']['OrderID'] : "";
        }
        if ($bookingID == "") {
            $carrierName = !empty($postXMLData['SVKEDITransmissionHeader']['SourceApp']) ? $postXMLData['SVKEDITransmissionHeader']['SourceApp'] : "";
        } else {
            $carrierName = "";
            $orderCarrierinfo = $this->common->getjointbldata("tb_orders o", "tb_vendors v", "o.vendor_id = v.id", ['o.order_id' => $bookingID], "v.name", 0, 0);
            foreach ($orderCarrierinfo as $carrierInfo) {
                $carrierName = $carrierInfo['name'];
            }
        }
        log_message("error", $type . " Inbound  Failed for  Booking ID:" . $bookingID);
        $this->load->library('PhpMailerLibrary');
        $subject = "Error/Alert - " . $type . " Inbound Failed for The Booking ID:  " . $bookingID;
        $message = "Hi Team,<br>";
        $message .= $type . " Inbound  Failed for  Booking ID: " . $bookingID . "<br>";
        $message .= "Carrier Name:  " . $carrierName . "<br>";
        $message .= "The Error Message is:  " . $responceMessage . "<br><br>";
        $message .= "This is an automatically generated EMail, please do not reply <br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>svkonekt.com";

        log_message("error", $type . " Inbound  Failed  Message" . json_encode($message));
        try {
            if ($this->phpmailerlibrary->sendmail(YTDREPORT_MAILS, $subject, $message, json_decode(YTDREPORT_CC_MAILS))) {
                log_message("error", "email sent for " . $subject);
            } else {
                log_message("error", "email failed for " . $subject);
            }
        } catch (Exception $e) {
            log_message("error", "sendTripFailedEmailNotification email failed - " . $e->getMessage());
        }
    }

}
