<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Standardtrip extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('standardtriphandler');
    }

    public function index()
    {
        ini_set('max_execution_time', 500);
        $postData = file_get_contents('php://input');
        if (empty($postData)) {
            echo "Please Send Proper XML";
            return;
        }
        $response = json_decode(json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
        $this->standardtriphandler->pullTripXml($response);
    }
    
    public function getInboundAPI()
    {
        $postData = file_get_contents('php://input');
        $response = [];
    
        if (! empty($postData)) {
            $data = json_decode(
                json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)),
                true
            );
    
            log_message("error", "Data:" . json_encode($data));
    
            $insertResponse = $this->standardtriphandler->insertTripXmlData($data);
            //log_message("error", "Insert Response:" . json_encode($insertResponse));
    
            // Wrap response in a consistent structure
            if (isset($insertResponse['message'])) {
                $message = $insertResponse['message'];
            } elseif (isset($insertResponse[0])) {
                $message = $insertResponse[0];
            } else {
                $message = "Unknown response";
            }
    
            // Extract booking number if present
            $booking = "";
            if (preg_match('/Booking\s*-\s*(\d+)/', $message, $matches)) {
                $booking = $matches[1];
            }
    
            $response = [
                "status"  => "success",
                "message" => $message,
                //"booking" => $booking
            ];
        } else {
            $response = [
                "status"  => "error",
                "message" => "Please Send Proper XML"
            ];
        }
    
        // ✅ echo JSON so VBA gets it
        header('Content-Type: application/json');
        echo json_encode($response);
        exit; // stop further output
    }
}
