<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Dashboard extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['CodeIgniterAuthorization', 'session', 'customerchartlib',]);
        $this->load->model(['common', 'AmChartModel']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
    }

    public function index(string $id = ''): void
    {
        $cuserid = $this->session->userdata("user_id");
        $cid = $this->session->userdata("cust_id");
        $yearInfo = [
            "currentYear" => DATE("Y"),
            "currentMonth" => DATE("m"),
            "currentweek" => DATE("w")
        ];
        $data['piechartdata'] = $this->customerchartlib->getPieChartData($yearInfo);
        $data['gaugechartdata'] = $this->customerchartlib->getGaugeChartData($yearInfo);
        $whr = "";
        if ($this->session->userdata('sub_cust') !== false) {
            $subcusts = $this->session->userdata('sub_cust');
            if (!empty($subcusts)) {
                array_push($subcusts, $cid);
                $whr .= " AND e.customer_id IN(" . implode(",", $subcusts) . ") ";
            } else {
                $whr .= " AND e.customer_id=$cid ";
            }
        }
        $data['activebooks'] = $this->AmChartModel->getActiveBookingsCount($whr);
        $data['pendbooks'] = $this->AmChartModel->getPendingBookingCount($whr);
        $data['donebooks'] = $this->AmChartModel->getCompletedBookingCount($whr);
        $this->newtemplate->dashboard("svkCustomer/dashboard", $data);
    }

    public function getActiveTrips(): void
    {
        $input = $this->input->post();
        $cid = $this->session->userdata("cust_id");
        $trips = [];
        $whr = "";
        if (isset($input['shipment_id']) && $input['shipment_id'] != "") {
            $sh = trim($input['shipment_id']);
            $whr .= " AND s.shipmentid LIKE '%" . $sh . "%' ";
        }
        $sql = $this->common->getactivetripids($whr, $cid);
        if (!empty($sql)) {
            foreach ($sql as $row) {
                $trips[] = [
                    "id" => $row['id'],
                    "name" => "<div class='btn btn-xs btn-primary' onclick='openTripMap(\"" . $row['id'] . "\",\"" . $row['shipmentid'] . " - " . $row['splace'] . " - " . $row['eplace'] . "\")'>" . $row['shipmentid'] . "</div> " . $row['splace'] . " - " . $row['eplace'],
                ];
            }
        }
        echo json_encode($trips);
    }

    public function loadMapVehicles()
    {
        $cid = $this->session->userdata("cust_id");
        $data = [];
        $companyCode = $this->session->userdata('company_code');
        $checkAccessConditions = checkAccessConditions('RELATED_2_TW_CN', $companyCode);
        $qr = $this->AmChartModel->getMapVechicles($cid);
        $data["data"] = [];
        $currentdate = $checkAccessConditions ? date("Y-m-d H:i:s") : date("Y-m-d");
        if (!empty($qr)) {
            foreach ($qr as $row) {
                $d = [];
                $d[] = $row['name'];
                $d[] = $row['register_number'];
                $tripgpsinfo = $this->common->getgpslocationbyorder($row['vehicle_id'], $currentdate);
                if (!empty($tripgpsinfo)) {
                    $tripgpsinfo = current($tripgpsinfo);
                    if ($checkAccessConditions) {
                        $d[] = getLocationName($tripgpsinfo['latitude'], $tripgpsinfo['longitude']) . "<input type='hidden' id='position' value='" . $tripgpsinfo['latitude'] . "," . $tripgpsinfo['longitude'] . "'>
                        <input type='hidden' id='imei' value='" . $tripgpsinfo['mobileimei'] . "'><input type='hidden' id='shipmentid' value='" . $tripgpsinfo['shipmentid'] . "'><input type='hidden' id='orderid' value='" . $tripgpsinfo['orderId'] . "'><input type='hidden' id='tripid' value='" . $tripgpsinfo['tripid'] . "'>";
                    } else {
                        $d[] = getLocationName($tripgpsinfo['latitude'], $tripgpsinfo['longitude']) . "<input type='hidden' id='position' value='" . $tripgpsinfo['latitude'] . "," . $tripgpsinfo['longitude'] . "'>
                        <input type='hidden' id='speed' value='" . $tripgpsinfo['speed'] . "'><input type='hidden' id='imei' value='" . $tripgpsinfo['mobileimei'] . "'><input type='hidden' id='fuel' value='" . $tripgpsinfo['fuel'] . "'><input type='hidden' id='shipmentid' value='" . $tripgpsinfo['shipmentid'] . "'><input type='hidden' id='orderid' value='" . $tripgpsinfo['orderId'] . "'><input type='hidden' id='tripid' value='" . $tripgpsinfo['tripid'] . "'>";
                        if (strlen($tripgpsinfo['speed']) > 0) {
                            $d[] = $tripgpsinfo['speed'] . " KMPH";
                        } else {
                            $d[] = "";
                        }
                        $d[] = (strlen(trim($tripgpsinfo['battery'])) > 0 ? $tripgpsinfo['battery'] . " %" : "");
                        $d[] = getShipDetailByVeh($row['id']);
                    }
                    if (strlen($tripgpsinfo['receivedon']) > 0) {
                        $d[] = date('d M,Y H:i a', strtotime($tripgpsinfo['receivedon']));
                    } else {
                        $d[] = "";
                    }
                    $data["data"][] = $d;
                }
            }
        }
        if ($checkAccessConditions) {
            $results = $this->AmChartModel->getLatLongData($cid);
            if (!empty($results)) {
                foreach ($results as $orderData) {
                    $ordersData = [];
                    $ordersData[] = $orderData['id'];
                    $ordersData[] = $orderData['trip_sts'];
                    $ordersData[] = getLocationName($orderData->latitude, $orderData->longitude) . "<input type='hidden' id='position' value='" . $orderData->latitude . "," . $orderData->longitude . "'>
                        <input type='hidden' id='imei' value='0'><input type='hidden' id='shipid' value=''><input type='hidden' id='orderid' value='" . $orderData->orderid . "'><input type='hidden' id='tripid' value='0'>";
                    $ordersData[] = "";
                    $data["data"][] = $ordersData;
                }
            }
        }
        echo json_encode($data);
    }

    public function getPieChartInfo(): void
    {
        $yearInfo = [
            "currentYear" => $this->input->post('currentyear', true) ?? 0,
            "currentMonth" => $this->input->post('currentmonth', true) ?? 0,
            "currentweek" => $this->input->post('currentweek', true) ?? 0
        ];
        $data = $this->customerchartlib->getPieChartData($yearInfo);
        echo json_encode($data);
    }

    public function getBandsGaugeChartDetails(): void
    {
        $yearInfo = [
            "currentYear" => $this->input->post('currentyear', true) ?? 0,
            "currentMonth" => $this->input->post('currentmonth', true) ?? 0,
            "currentweek" => $this->input->post('currentweek', true) ?? 0
        ];
        $data = $this->customerchartlib->getGaugeChartData($yearInfo);
        echo json_encode($data);
    }
}
